/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.File;
import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.SchemaPruning;
import org.apache.spark.sql.catalyst.expressions.SchemaPruning$;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\r3Aa\u0001\u0003\u0001#!)A\u0004\u0001C\u0001;!)\u0001\u0005\u0001C\u0005C\t\u00112k\u00195f[\u0006\u0004&/\u001e8j]\u001e\u001cV/\u001b;f\u0015\t)a!A\u0006fqB\u0014Xm]:j_:\u001c(BA\u0004\t\u0003!\u0019\u0017\r^1msN$(BA\u0005\u000b\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u00171\tQa\u001d9be.T!!\u0004\b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0011aA8sO\u000e\u00011c\u0001\u0001\u0013-A\u00111\u0003F\u0007\u0002\u0015%\u0011QC\u0003\u0002\u000e'B\f'o\u001b$v]N+\u0018\u000e^3\u0011\u0005]QR\"\u0001\r\u000b\u0005e1\u0011!\u00029mC:\u001c\u0018BA\u000e\u0019\u0005%\u0019\u0016\u000b\u0014%fYB,'/\u0001\u0004=S:LGO\u0010\u000b\u0002=A\u0011q\u0004A\u0007\u0002\t\u0005\u0001B/Z:u!J,h.\u001a3TG\",W.\u0019\u000b\u0005E!\u0002\u0014\t\u0005\u0002$M5\tAEC\u0001&\u0003\u0015\u00198-\u00197b\u0013\t9CE\u0001\u0003V]&$\b\"B\u0015\u0003\u0001\u0004Q\u0013AB:dQ\u0016l\u0017\r\u0005\u0002,]5\tAF\u0003\u0002.\u0011\u0005)A/\u001f9fg&\u0011q\u0006\f\u0002\u000b'R\u0014Xo\u0019;UsB,\u0007\"B\u0019\u0003\u0001\u0004\u0011\u0014a\u0004:fcV,7\u000f^3e\r&,G\u000eZ:\u0011\u0007MZdH\u0004\u00025s9\u0011Q\u0007O\u0007\u0002m)\u0011q\u0007E\u0001\u0007yI|w\u000e\u001e \n\u0003\u0015J!A\u000f\u0013\u0002\u000fA\f7m[1hK&\u0011A(\u0010\u0002\u0004'\u0016\f(B\u0001\u001e%!\tYs(\u0003\u0002AY\tY1\u000b\u001e:vGR4\u0015.\u001a7e\u0011\u0015\u0011%\u00011\u0001+\u00039)\u0007\u0010]3di\u0016$7k\u00195f[\u0006\u0004")
public class SchemaPruningSuite
extends SparkFunSuite
implements SQLHelper {
    private String sparkHome;
    private volatile boolean bitmap$0;

    @Override
    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLHelper.withSQLConf$(this, pairs, f);
    }

    @Override
    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$(this, f);
    }

    @Override
    public <T> void testSpecialDatetimeValues(Function1<ZoneId, T> test) {
        SQLHelper.testSpecialDatetimeValues$(this, test);
    }

    private String sparkHome$lzycompute() {
        SchemaPruningSuite schemaPruningSuite = this;
        synchronized (schemaPruningSuite) {
            if (!this.bitmap$0) {
                this.sparkHome = SQLHelper.sparkHome$(this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkHome;
    }

    @Override
    public String sparkHome() {
        return !this.bitmap$0 ? this.sparkHome$lzycompute() : this.sparkHome;
    }

    private void testPrunedSchema(StructType schema, Seq<StructField> requestedFields, StructType expectedSchema) {
        Seq requestedRootFields = (Seq)requestedFields.map((Function1 & Serializable)f -> new SchemaPruning.RootField(f, true, SchemaPruning.RootField$.MODULE$.apply$default$3()));
        StructType prunedSchema = SchemaPruning$.MODULE$.pruneDataSchema(schema, requestedRootFields);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(prunedSchema);
        StructType $org_scalatest_assert_macro_right = expectedSchema;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SchemaPruningSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 35));
    }

    public SchemaPruningSuite() {
        SQLHelper.$init$(this);
        this.test("prune schema by the requested fields", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.testPrunedSchema(StructType$.MODULE$.fromDDL("a int, b int"), (Seq<StructField>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("a", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}))), StructType$.MODULE$.fromDDL("a int, b int"));
            StructType structOfStruct = StructType$.MODULE$.fromDDL("a struct<a:int, b:int>, b int");
            this.testPrunedSchema(structOfStruct, (Seq<StructField>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("a", (DataType)StructType$.MODULE$.fromDDL("a int"), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("b", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}))), StructType$.MODULE$.fromDDL("a struct<a:int>, b int"));
            this.testPrunedSchema(structOfStruct, (Seq<StructField>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("a", (DataType)StructType$.MODULE$.fromDDL("a int"), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}))), StructType$.MODULE$.fromDDL("a struct<a:int>, b int"));
            StructField arrayOfStruct = new StructField("a", (DataType)ArrayType$.MODULE$.apply((DataType)StructType$.MODULE$.fromDDL("a int, b int, c string")), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            StructField mapOfStruct = new StructField("d", (DataType)MapType$.MODULE$.apply((DataType)StructType$.MODULE$.fromDDL("a int, b int, c string"), (DataType)StructType$.MODULE$.fromDDL("d int, e int, f string")), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            StructField structField = arrayOfStruct;
            StructField structField2 = new StructField("b", (DataType)structOfStruct, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            StructField structField3 = new StructField("c", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            StructField structField4 = mapOfStruct;
            StructType complexStruct = StructType$.MODULE$.apply((Seq)package$.MODULE$.Nil().$colon$colon((Object)structField4).$colon$colon((Object)structField3).$colon$colon((Object)structField2).$colon$colon((Object)structField));
            StructField structField5 = new StructField("a", (DataType)ArrayType$.MODULE$.apply((DataType)StructType$.MODULE$.fromDDL("b int")), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            StructField structField6 = new StructField("b", (DataType)StructType$.MODULE$.fromDDL("a int"), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            StructField structField7 = new StructField("c", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            StructField structField8 = mapOfStruct;
            this.testPrunedSchema(complexStruct, (Seq<StructField>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("a", (DataType)ArrayType$.MODULE$.apply((DataType)StructType$.MODULE$.fromDDL("b int")), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("b", (DataType)StructType$.MODULE$.fromDDL("a int"), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}))), StructType$.MODULE$.apply((Seq)package$.MODULE$.Nil().$colon$colon((Object)structField8).$colon$colon((Object)structField7).$colon$colon((Object)structField6).$colon$colon((Object)structField5)));
            StructField structField9 = new StructField("a", (DataType)ArrayType$.MODULE$.apply((DataType)StructType$.MODULE$.fromDDL("b int, c string")), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            StructField structField10 = new StructField("b", (DataType)StructType$.MODULE$.fromDDL("b int"), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            StructField structField11 = new StructField("c", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            StructField structField12 = mapOfStruct;
            this.testPrunedSchema(complexStruct, (Seq<StructField>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("a", (DataType)ArrayType$.MODULE$.apply((DataType)StructType$.MODULE$.fromDDL("b int, c string")), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("b", (DataType)StructType$.MODULE$.fromDDL("b int"), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}))), StructType$.MODULE$.apply((Seq)package$.MODULE$.Nil().$colon$colon((Object)structField12).$colon$colon((Object)structField11).$colon$colon((Object)structField10).$colon$colon((Object)structField9)));
            StructField selectFieldInMap = new StructField("d", (DataType)MapType$.MODULE$.apply((DataType)StructType$.MODULE$.fromDDL("a int, b int"), (DataType)StructType$.MODULE$.fromDDL("e int, f string")), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            StructField structField13 = arrayOfStruct;
            StructField structField14 = new StructField("b", (DataType)structOfStruct, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            StructField structField15 = new StructField("c", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            StructField structField16 = selectFieldInMap;
            this.testPrunedSchema(complexStruct, (Seq<StructField>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("c", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), selectFieldInMap}))), StructType$.MODULE$.apply((Seq)package$.MODULE$.Nil().$colon$colon((Object)structField16).$colon$colon((Object)structField15).$colon$colon((Object)structField14).$colon$colon((Object)structField13)));
        }, new Position("SchemaPruningSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 38));
        this.test("SPARK-35096: test case insensitivity of pruned schema", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            StructType upperCaseSchema = StructType$.MODULE$.fromDDL("A struct<A:int, B:int>, B int");
            StructType lowerCaseSchema = StructType$.MODULE$.fromDDL("a struct<a:int, b:int>, b int");
            Seq upperCaseRequestedFields = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("A", (DataType)StructType$.MODULE$.fromDDL("A int"), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}));
            Seq lowerCaseRequestedFields = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("a", (DataType)StructType$.MODULE$.fromDDL("a int"), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}));
            package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{true, false})).foreach((Function1 & Serializable)isCaseSensitive -> {
                this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.CASE_SENSITIVE().key()), (Object)Boolean.toString(BoxesRunTime.unboxToBoolean((Object)isCaseSensitive)))}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                    if (isCaseSensitive) {
                        $this.testPrunedSchema(upperCaseSchema$1, (Seq<StructField>)upperCaseRequestedFields$1, StructType$.MODULE$.fromDDL("A struct<A:int>, B int"));
                        $this.testPrunedSchema(upperCaseSchema$1, (Seq<StructField>)lowerCaseRequestedFields$1, upperCaseSchema$1);
                        $this.testPrunedSchema(lowerCaseSchema$1, (Seq<StructField>)upperCaseRequestedFields$1, lowerCaseSchema$1);
                        $this.testPrunedSchema(lowerCaseSchema$1, (Seq<StructField>)lowerCaseRequestedFields$1, StructType$.MODULE$.fromDDL("a struct<a:int>, b int"));
                    } else {
                        package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Seq[]{upperCaseRequestedFields$1, lowerCaseRequestedFields$1})).foreach((Function1 & Serializable)requestedFields -> {
                            $this.testPrunedSchema(upperCaseSchema$1, (Seq<StructField>)requestedFields, StructType$.MODULE$.fromDDL("A struct<A:int>, B int"));
                            return BoxedUnit.UNIT;
                        });
                        package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Seq[]{upperCaseRequestedFields$1, lowerCaseRequestedFields$1})).foreach((Function1 & Serializable)requestedFields -> {
                            $this.testPrunedSchema(lowerCaseSchema$1, (Seq<StructField>)requestedFields, StructType$.MODULE$.fromDDL("a struct<a:int>, b int"));
                            return BoxedUnit.UNIT;
                        });
                    }
                });
                return BoxedUnit.UNIT;
            });
        }, new Position("SchemaPruningSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 88));
        this.test("SPARK-35232: getRootFields/pruneDataSchema should retain attribute metadata", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Seq rootFields;
            Metadata metadata = new MetadataBuilder().putString("foo", "bar").build();
            String x$1 = "my_attr";
            IntegerType$ x$2 = IntegerType$.MODULE$;
            Metadata x$3 = metadata;
            boolean x$4 = AttributeReference$.MODULE$.apply$default$3();
            ExprId x$5 = AttributeReference$.MODULE$.apply$default$5("my_attr", (DataType)x$2, x$4, x$3);
            Seq x$6 = AttributeReference$.MODULE$.apply$default$6("my_attr", (DataType)x$2, x$4, x$3);
            AttributeReference attr = new AttributeReference("my_attr", (DataType)x$2, x$4, x$3, x$5, x$6);
            Seq $org_scalatest_assert_macro_left = rootFields = SchemaPruning$.MODULE$.getRootFields((Expression)attr);
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SchemaPruningSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 138));
            StructField field = ((SchemaPruning.RootField)rootFields.head()).field();
            String $org_scalatest_assert_macro_left2 = field.metadata().getString("foo");
            String $org_scalatest_assert_macro_right2 = "bar";
            String string = $org_scalatest_assert_macro_left2;
            String string2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SchemaPruningSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 140));
            StructType schema = StructType$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StructField[]{field})));
            StructType prunedSchema = SchemaPruning$.MODULE$.pruneDataSchema(schema, rootFields);
            String $org_scalatest_assert_macro_left3 = ((StructField)prunedSchema.head()).metadata().getString("foo");
            String $org_scalatest_assert_macro_right3 = "bar";
            String string3 = $org_scalatest_assert_macro_left3;
            String string4 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SchemaPruningSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 144));
        }, new Position("SchemaPruningSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 133));
    }
}

