/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.optimizer;

import java.io.File;
import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAttribute;
import org.apache.spark.sql.catalyst.analysis.UnresolvedExtractValue;
import org.apache.spark.sql.catalyst.dsl.package;
import org.apache.spark.sql.catalyst.expressions.Add;
import org.apache.spark.sql.catalyst.expressions.Add$;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.AliasHelper;
import org.apache.spark.sql.catalyst.expressions.AssertTrue;
import org.apache.spark.sql.catalyst.expressions.AssertTrue$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.Coalesce;
import org.apache.spark.sql.catalyst.expressions.Contains;
import org.apache.spark.sql.catalyst.expressions.CreateArray$;
import org.apache.spark.sql.catalyst.expressions.EqualTo;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.In;
import org.apache.spark.sql.catalyst.expressions.IsNotNull;
import org.apache.spark.sql.catalyst.expressions.IsNull;
import org.apache.spark.sql.catalyst.expressions.Like;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.Not;
import org.apache.spark.sql.catalyst.expressions.PredicateHelper;
import org.apache.spark.sql.catalyst.expressions.Rand$;
import org.apache.spark.sql.catalyst.expressions.Size$;
import org.apache.spark.sql.catalyst.expressions.Substring;
import org.apache.spark.sql.catalyst.expressions.UnaryMinus;
import org.apache.spark.sql.catalyst.expressions.UnaryMinus$;
import org.apache.spark.sql.catalyst.expressions.Upper;
import org.apache.spark.sql.catalyst.optimizer.ConstantFoldingSuite$Optimize$;
import org.apache.spark.sql.catalyst.optimizer.ConstantFoldingSuite$OptimizeForCreate$;
import org.apache.spark.sql.catalyst.plans.PlanTest;
import org.apache.spark.sql.catalyst.plans.PlanTestBase;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.catalyst.plans.logical.Aggregate;
import org.apache.spark.sql.catalyst.plans.logical.LocalRelation;
import org.apache.spark.sql.catalyst.plans.logical.LocalRelation$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType$;
import org.scalactic.source.Position;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Symbol;
import scala.Tuple2;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005u3AAD\b\u00019!)q\u0005\u0001C\u0001Q\u001d)1\u0006\u0001E\u0001Y\u0019)a\u0006\u0001E\u0001_!)qe\u0001C\u0001y!9Qh\u0001b\u0001\n\u0003q\u0004BB'\u0004A\u0003%q\bC\u0004O\u0001\t\u0007I\u0011A(\t\rM\u0003\u0001\u0015!\u0003Q\u000f\u0015!\u0006\u0001#\u0001V\r\u00151\u0006\u0001#\u0001X\u0011\u00159#\u0002\"\u0001Y\u0011\u001di$B1A\u0005\u0002eCa!\u0014\u0006!\u0002\u0013Q&\u0001F\"p]N$\u0018M\u001c;G_2$\u0017N\\4Tk&$XM\u0003\u0002\u0011#\u0005Iq\u000e\u001d;j[&TXM\u001d\u0006\u0003%M\t\u0001bY1uC2L8\u000f\u001e\u0006\u0003)U\t1a]9m\u0015\t1r#A\u0003ta\u0006\u00148N\u0003\u0002\u00193\u00051\u0011\r]1dQ\u0016T\u0011AG\u0001\u0004_J<7\u0001A\n\u0004\u0001u\t\u0003C\u0001\u0010 \u001b\u0005)\u0012B\u0001\u0011\u0016\u00055\u0019\u0006/\u0019:l\rVt7+^5uKB\u0011!%J\u0007\u0002G)\u0011A%E\u0001\u0006a2\fgn]\u0005\u0003M\r\u0012\u0001\u0002\u00157b]R+7\u000f^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003%\u0002\"A\u000b\u0001\u000e\u0003=\t\u0001b\u00149uS6L'0\u001a\t\u0003[\ri\u0011\u0001\u0001\u0002\t\u001fB$\u0018.\\5{KN\u00111\u0001\r\t\u0004cQ2T\"\u0001\u001a\u000b\u0005M\n\u0012!\u0002:vY\u0016\u001c\u0018BA\u001b3\u00051\u0011V\u000f\\3Fq\u0016\u001cW\u000f^8s!\t9$(D\u00019\u0015\tI4%A\u0004m_\u001eL7-\u00197\n\u0005mB$a\u0003'pO&\u001c\u0017\r\u001c)mC:$\u0012\u0001L\u0001\bE\u0006$8\r[3t+\u0005y\u0004c\u0001!H\u00136\t\u0011I\u0003\u0002C\u0007\u0006I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0003\t\u0016\u000b!bY8mY\u0016\u001cG/[8o\u0015\u00051\u0015!B:dC2\f\u0017B\u0001%B\u0005\u0011a\u0015n\u001d;\u0011\u0005)[U\"A\u0002\n\u00051#$!\u0002\"bi\u000eD\u0017\u0001\u00032bi\u000eDWm\u001d\u0011\u0002\u0019Q,7\u000f\u001e*fY\u0006$\u0018n\u001c8\u0016\u0003A\u0003\"aN)\n\u0005IC$!\u0004'pG\u0006d'+\u001a7bi&|g.A\u0007uKN$(+\u001a7bi&|g\u000eI\u0001\u0012\u001fB$\u0018.\\5{K\u001a{'o\u0011:fCR,\u0007CA\u0017\u000b\u0005Ey\u0005\u000f^5nSj,gi\u001c:De\u0016\fG/Z\n\u0003\u0015A\"\u0012!V\u000b\u00025B\u0019\u0001iR.\u0011\u0005q[U\"\u0001\u0006")
public class ConstantFoldingSuite
extends SparkFunSuite
implements PlanTest {
    private volatile ConstantFoldingSuite$Optimize$ Optimize$module;
    private volatile ConstantFoldingSuite$OptimizeForCreate$ OptimizeForCreate$module;
    private final LocalRelation testRelation;
    private String sparkHome;
    private volatile boolean bitmap$0;

    @Override
    public LogicalPlan normalizeExprIds(LogicalPlan plan) {
        return PlanTestBase.normalizeExprIds$(this, plan);
    }

    @Override
    public LogicalPlan rewriteNameFromAttrNullability(LogicalPlan plan) {
        return PlanTestBase.rewriteNameFromAttrNullability$(this, plan);
    }

    @Override
    public LogicalPlan normalizePlan(LogicalPlan plan) {
        return PlanTestBase.normalizePlan$(this, plan);
    }

    @Override
    public void comparePlans(LogicalPlan plan1, LogicalPlan plan2, boolean checkAnalysis) {
        PlanTestBase.comparePlans$(this, plan1, plan2, checkAnalysis);
    }

    @Override
    public boolean comparePlans$default$3() {
        return PlanTestBase.comparePlans$default$3$(this);
    }

    @Override
    public void compareExpressions(Expression e1, Expression e2) {
        PlanTestBase.compareExpressions$(this, e1, e2);
    }

    public SQLConf conf() {
        return SQLConfHelper.conf$((SQLConfHelper)this);
    }

    @Override
    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLHelper.withSQLConf$(this, pairs, f);
    }

    @Override
    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$(this, f);
    }

    @Override
    public <T> void testSpecialDatetimeValues(Function1<ZoneId, T> test) {
        SQLHelper.testSpecialDatetimeValues$(this, test);
    }

    public Seq<Expression> splitConjunctivePredicates(Expression condition) {
        return PredicateHelper.splitConjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Option<Tuple2<Expression, LogicalPlan>> findExpressionAndTrackLineageDown(Expression exp, LogicalPlan plan) {
        return PredicateHelper.findExpressionAndTrackLineageDown$((PredicateHelper)this, (Expression)exp, (LogicalPlan)plan);
    }

    public Seq<Expression> splitDisjunctivePredicates(Expression condition) {
        return PredicateHelper.splitDisjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Expression buildBalancedPredicate(Seq<Expression> expressions, Function2<Expression, Expression, Expression> op) {
        return PredicateHelper.buildBalancedPredicate$((PredicateHelper)this, expressions, op);
    }

    public boolean canEvaluate(Expression expr, LogicalPlan plan) {
        return PredicateHelper.canEvaluate$((PredicateHelper)this, (Expression)expr, (LogicalPlan)plan);
    }

    public boolean canEvaluateWithinJoin(Expression expr) {
        return PredicateHelper.canEvaluateWithinJoin$((PredicateHelper)this, (Expression)expr);
    }

    public Option<Expression> extractPredicatesWithinOutputSet(Expression condition, AttributeSet outputSet) {
        return PredicateHelper.extractPredicatesWithinOutputSet$((PredicateHelper)this, (Expression)condition, (AttributeSet)outputSet);
    }

    public boolean isNullIntolerant(Expression expr) {
        return PredicateHelper.isNullIntolerant$((PredicateHelper)this, (Expression)expr);
    }

    public Seq<Attribute> outputWithNullability(Seq<Attribute> output, Seq<ExprId> nonNullAttrExprIds) {
        return PredicateHelper.outputWithNullability$((PredicateHelper)this, output, nonNullAttrExprIds);
    }

    public AttributeMap<Alias> getAliasMap(Project plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Project)plan);
    }

    public AttributeMap<Alias> getAliasMap(Aggregate plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Aggregate)plan);
    }

    public AttributeMap<Alias> getAliasMap(Seq<NamedExpression> exprs) {
        return AliasHelper.getAliasMap$((AliasHelper)this, exprs);
    }

    public Expression replaceAlias(Expression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAlias$((AliasHelper)this, (Expression)expr, aliasMap);
    }

    public NamedExpression replaceAliasButKeepName(NamedExpression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAliasButKeepName$((AliasHelper)this, (NamedExpression)expr, aliasMap);
    }

    public Expression trimAliases(Expression e) {
        return AliasHelper.trimAliases$((AliasHelper)this, (Expression)e);
    }

    public <T extends Expression> T trimNonTopLevelAliases(T e) {
        return (T)AliasHelper.trimNonTopLevelAliases$((AliasHelper)this, e);
    }

    public ConstantFoldingSuite$Optimize$ Optimize() {
        if (this.Optimize$module == null) {
            this.Optimize$lzycompute$1();
        }
        return this.Optimize$module;
    }

    public ConstantFoldingSuite$OptimizeForCreate$ OptimizeForCreate() {
        if (this.OptimizeForCreate$module == null) {
            this.OptimizeForCreate$lzycompute$1();
        }
        return this.OptimizeForCreate$module;
    }

    private String sparkHome$lzycompute() {
        ConstantFoldingSuite constantFoldingSuite = this;
        synchronized (constantFoldingSuite) {
            if (!this.bitmap$0) {
                this.sparkHome = SQLHelper.sparkHome$(this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkHome;
    }

    @Override
    public String sparkHome() {
        return !this.bitmap$0 ? this.sparkHome$lzycompute() : this.sparkHome;
    }

    public LocalRelation testRelation() {
        return this.testRelation;
    }

    private final void Optimize$lzycompute$1() {
        ConstantFoldingSuite constantFoldingSuite = this;
        synchronized (constantFoldingSuite) {
            if (this.Optimize$module == null) {
                this.Optimize$module = new ConstantFoldingSuite$Optimize$(this);
            }
        }
    }

    private final void OptimizeForCreate$lzycompute$1() {
        ConstantFoldingSuite constantFoldingSuite = this;
        synchronized (constantFoldingSuite) {
            if (this.OptimizeForCreate$module == null) {
                this.OptimizeForCreate$module = new ConstantFoldingSuite$OptimizeForCreate$(this);
            }
        }
    }

    public ConstantFoldingSuite() {
        AliasHelper.$init$((AliasHelper)this);
        PredicateHelper.$init$((PredicateHelper)this);
        SQLHelper.$init$(this);
        SQLConfHelper.$init$((SQLConfHelper)this);
        PlanTestBase.$init$(this);
        this.testRelation = LocalRelation$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Attribute[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "c")).int()}));
        this.test("eliminate subqueries", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery((Symbol)SymbolLiteral.bootstrap("apply", "y"))).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a"))}));
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(originalQuery).analyze());
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).attr()}))).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("ConstantFoldingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 43));
        this.test("Constant folding test: expressions only have literals", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2))).$plus((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)3)))).$plus((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)4)))).as((Symbol)SymbolLiteral.bootstrap("apply", "2+3+4")), (Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2))).$times((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)3)))).$plus((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)4)))).as((Symbol)SymbolLiteral.bootstrap("apply", "2*3+4")), (Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2))).$times(package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)3))).$plus((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)4))))).as((Symbol)SymbolLiteral.bootstrap("apply", "2*(3+4)"))}))).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1))).$eq$eq$eq((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1)))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2))).$greater((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)3))))).$bar$bar((Expression)package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)3))).$greater((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2)))))).groupBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2))).$times((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)3)))).$minus(package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)6))).$div(package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)4))).$minus((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2)))))}), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)9))).$div((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)3)))).as((Symbol)SymbolLiteral.bootstrap("apply", "9/3"))}));
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(originalQuery).analyze());
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)9))).as((Symbol)SymbolLiteral.bootstrap("apply", "2+3+4")), (Expression)package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)10))).as((Symbol)SymbolLiteral.bootstrap("apply", "2*3+4")), (Expression)package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)14))).as((Symbol)SymbolLiteral.bootstrap("apply", "2*(3+4)"))}))).where((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)true)))).groupBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)3.0))}), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)3.0))).as((Symbol)SymbolLiteral.bootstrap("apply", "9/3"))}))).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("ConstantFoldingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 61));
        this.test("Constant folding test: expressions have attribute references and literals in arithmetic operations", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2))).$plus((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)3)))).$plus((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")))).as((Symbol)SymbolLiteral.bootstrap("apply", "c1")), (Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$plus((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2)))).$plus((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)3)))).as((Symbol)SymbolLiteral.bootstrap("apply", "c2")), (Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2))).$times((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")))).$plus((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)4)))).as((Symbol)SymbolLiteral.bootstrap("apply", "c3")), (Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$times(package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)3))).$plus((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)4))))).as((Symbol)SymbolLiteral.bootstrap("apply", "c4"))}));
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(originalQuery).analyze());
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)5))).$plus((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")))).as((Symbol)SymbolLiteral.bootstrap("apply", "c1")), (Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$plus((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2)))).$plus((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)3)))).as((Symbol)SymbolLiteral.bootstrap("apply", "c2")), (Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2))).$times((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")))).$plus((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)4)))).as((Symbol)SymbolLiteral.bootstrap("apply", "c3")), (Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$times((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)7)))).as((Symbol)SymbolLiteral.bootstrap("apply", "c4"))}))).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("ConstantFoldingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 92));
        this.test("Constant folding test: expressions have attribute references and literals in predicates", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$greater((Expression)package.expressions$.MODULE$.intToLiteral(1))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1))).$eq$eq$eq((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1))))).$bar$bar((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$less((Expression)package.expressions$.MODULE$.intToLiteral(10))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1))).$eq$eq$eq((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2)))))).$bar$bar((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1))).$eq$eq$eq((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1)))).$amp$amp((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).$greater((Expression)package.expressions$.MODULE$.intToLiteral(1))))).$bar$bar((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1))).$eq$eq$eq((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2)))).$amp$amp((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).$less((Expression)package.expressions$.MODULE$.intToLiteral(10))))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$greater((Expression)package.expressions$.MODULE$.intToLiteral(1))).$bar$bar((Expression)package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1))).$eq$eq$eq((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1))))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$less((Expression)package.expressions$.MODULE$.intToLiteral(10))).$bar$bar((Expression)package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1))).$eq$eq$eq((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2)))))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1))).$eq$eq$eq((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1)))).$bar$bar((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).$greater((Expression)package.expressions$.MODULE$.intToLiteral(1))))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1))).$eq$eq$eq((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2)))).$bar$bar((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).$less((Expression)package.expressions$.MODULE$.intToLiteral(10))))));
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(originalQuery).analyze());
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$greater((Expression)package.expressions$.MODULE$.intToLiteral(1))).$bar$bar((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).$greater((Expression)package.expressions$.MODULE$.intToLiteral(1)))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$less((Expression)package.expressions$.MODULE$.intToLiteral(10))).$amp$amp((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).$less((Expression)package.expressions$.MODULE$.intToLiteral(10)))))).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("ConstantFoldingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 116));
        this.test("Constant folding test: expressions have foldable functions", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression((Expression)new Cast((Expression)Literal$.MODULE$.apply((Object)"2"), (DataType)IntegerType$.MODULE$, Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4())).$plus((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)3)))).$plus((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")))).as((Symbol)SymbolLiteral.bootstrap("apply", "c1")), (Expression)package.expressions$.MODULE$.DslExpression((Expression)new Coalesce((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{new Cast((Expression)Literal$.MODULE$.apply((Object)"abc"), (DataType)IntegerType$.MODULE$, Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4()), Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)3))})))).as((Symbol)SymbolLiteral.bootstrap("apply", "c2"))}));
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(originalQuery).analyze());
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)5))).$plus((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")))).as((Symbol)SymbolLiteral.bootstrap("apply", "c1")), (Expression)package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)3))).as((Symbol)SymbolLiteral.bootstrap("apply", "c2"))}))).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("ConstantFoldingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 139));
        this.test("Constant folding test: expressions have nonfoldable functions", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression((Expression)Rand$.MODULE$.apply(5L)).$plus((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1)))).as((Symbol)SymbolLiteral.bootstrap("apply", "c1")), (Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.sum((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.sum$default$2())).as((Symbol)SymbolLiteral.bootstrap("apply", "c2"))}));
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(originalQuery).analyze());
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression((Expression)Rand$.MODULE$.apply(5L)).$plus((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)1.0)))).as((Symbol)SymbolLiteral.bootstrap("apply", "c1")), (Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.sum((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.sum$default$2())).as((Symbol)SymbolLiteral.bootstrap("apply", "c2"))}))).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("ConstantFoldingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 158));
        this.test("Constant folding test: expressions have null literals", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)package.expressions$.MODULE$.DslExpression((Expression)new IsNull((Expression)Literal$.MODULE$.apply(null))).as((Symbol)SymbolLiteral.bootstrap("apply", "c1")), (Expression)package.expressions$.MODULE$.DslExpression((Expression)new IsNotNull((Expression)Literal$.MODULE$.apply(null))).as((Symbol)SymbolLiteral.bootstrap("apply", "c2")), (Expression)package.expressions$.MODULE$.DslExpression((Expression)new UnresolvedExtractValue((Expression)Literal$.MODULE$.create(null, (DataType)ArrayType$.MODULE$.apply((DataType)IntegerType$.MODULE$)), (Expression)package.expressions$.MODULE$.intToLiteral(1))).as((Symbol)SymbolLiteral.bootstrap("apply", "c3")), (Expression)package.expressions$.MODULE$.DslExpression((Expression)new UnresolvedExtractValue((Expression)Literal$.MODULE$.create((Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})), (DataType)ArrayType$.MODULE$.apply((DataType)IntegerType$.MODULE$)), (Expression)Literal$.MODULE$.create(null, (DataType)IntegerType$.MODULE$))).as((Symbol)SymbolLiteral.bootstrap("apply", "c4")), (Expression)package.expressions$.MODULE$.DslExpression((Expression)new UnresolvedExtractValue((Expression)Literal$.MODULE$.create(null, (DataType)StructType$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("a", (DataType)IntegerType$.MODULE$, true, StructField$.MODULE$.apply$default$4())})))), (Expression)package.expressions$.MODULE$.stringToLiteral("a"))).as((Symbol)SymbolLiteral.bootstrap("apply", "c5")), (Expression)package.expressions$.MODULE$.DslExpression((Expression)new UnaryMinus((Expression)Literal$.MODULE$.create(null, (DataType)IntegerType$.MODULE$), UnaryMinus$.MODULE$.apply$default$2())).as((Symbol)SymbolLiteral.bootstrap("apply", "c6")), (Expression)package.expressions$.MODULE$.DslExpression((Expression)new Cast((Expression)Literal$.MODULE$.apply(null), (DataType)IntegerType$.MODULE$, Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4())).as((Symbol)SymbolLiteral.bootstrap("apply", "c7")), (Expression)package.expressions$.MODULE$.DslExpression((Expression)new Not((Expression)Literal$.MODULE$.create(null, (DataType)BooleanType$.MODULE$))).as((Symbol)SymbolLiteral.bootstrap("apply", "c8")), (Expression)package.expressions$.MODULE$.DslExpression((Expression)new Add((Expression)Literal$.MODULE$.create(null, (DataType)IntegerType$.MODULE$), (Expression)package.expressions$.MODULE$.intToLiteral(1), Add$.MODULE$.apply$default$3())).as((Symbol)SymbolLiteral.bootstrap("apply", "c9")), (Expression)package.expressions$.MODULE$.DslExpression((Expression)new Add((Expression)package.expressions$.MODULE$.intToLiteral(1), (Expression)Literal$.MODULE$.create(null, (DataType)IntegerType$.MODULE$), Add$.MODULE$.apply$default$3())).as((Symbol)SymbolLiteral.bootstrap("apply", "c10")), (Expression)package.expressions$.MODULE$.DslExpression((Expression)new EqualTo((Expression)Literal$.MODULE$.create(null, (DataType)IntegerType$.MODULE$), (Expression)package.expressions$.MODULE$.intToLiteral(1))).as((Symbol)SymbolLiteral.bootstrap("apply", "c11")), (Expression)package.expressions$.MODULE$.DslExpression((Expression)new EqualTo((Expression)package.expressions$.MODULE$.intToLiteral(1), (Expression)Literal$.MODULE$.create(null, (DataType)IntegerType$.MODULE$))).as((Symbol)SymbolLiteral.bootstrap("apply", "c12")), (Expression)package.expressions$.MODULE$.DslExpression((Expression)new Like((Expression)Literal$.MODULE$.create(null, (DataType)StringType$.MODULE$), (Expression)package.expressions$.MODULE$.stringToLiteral("abc"))).as((Symbol)SymbolLiteral.bootstrap("apply", "c13")), (Expression)package.expressions$.MODULE$.DslExpression((Expression)new Like((Expression)package.expressions$.MODULE$.stringToLiteral("abc"), (Expression)Literal$.MODULE$.create(null, (DataType)StringType$.MODULE$))).as((Symbol)SymbolLiteral.bootstrap("apply", "c14")), (Expression)package.expressions$.MODULE$.DslExpression((Expression)new Upper((Expression)Literal$.MODULE$.create(null, (DataType)StringType$.MODULE$))).as((Symbol)SymbolLiteral.bootstrap("apply", "c15")), (Expression)package.expressions$.MODULE$.DslExpression((Expression)new Substring((Expression)Literal$.MODULE$.create(null, (DataType)StringType$.MODULE$), (Expression)package.expressions$.MODULE$.intToLiteral(0), (Expression)package.expressions$.MODULE$.intToLiteral(1))).as((Symbol)SymbolLiteral.bootstrap("apply", "c16")), (Expression)package.expressions$.MODULE$.DslExpression((Expression)new Substring((Expression)package.expressions$.MODULE$.stringToLiteral("abc"), (Expression)Literal$.MODULE$.create(null, (DataType)IntegerType$.MODULE$), (Expression)package.expressions$.MODULE$.intToLiteral(1))).as((Symbol)SymbolLiteral.bootstrap("apply", "c17")), (Expression)package.expressions$.MODULE$.DslExpression((Expression)new Substring((Expression)package.expressions$.MODULE$.stringToLiteral("abc"), (Expression)package.expressions$.MODULE$.intToLiteral(0), (Expression)Literal$.MODULE$.create(null, (DataType)IntegerType$.MODULE$))).as((Symbol)SymbolLiteral.bootstrap("apply", "c18")), (Expression)package.expressions$.MODULE$.DslExpression((Expression)new Contains((Expression)Literal$.MODULE$.create(null, (DataType)StringType$.MODULE$), (Expression)package.expressions$.MODULE$.stringToLiteral("abc"))).as((Symbol)SymbolLiteral.bootstrap("apply", "c19")), (Expression)package.expressions$.MODULE$.DslExpression((Expression)new Contains((Expression)package.expressions$.MODULE$.stringToLiteral("abc"), (Expression)Literal$.MODULE$.create(null, (DataType)StringType$.MODULE$))).as((Symbol)SymbolLiteral.bootstrap("apply", "c20"))}));
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(originalQuery).analyze());
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)true))).as((Symbol)SymbolLiteral.bootstrap("apply", "c1")), (Expression)package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)false))).as((Symbol)SymbolLiteral.bootstrap("apply", "c2")), (Expression)package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.create(null, (DataType)IntegerType$.MODULE$)).as((Symbol)SymbolLiteral.bootstrap("apply", "c3")), (Expression)package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.create(null, (DataType)IntegerType$.MODULE$)).as((Symbol)SymbolLiteral.bootstrap("apply", "c4")), (Expression)package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.create(null, (DataType)IntegerType$.MODULE$)).as((Symbol)SymbolLiteral.bootstrap("apply", "c5")), (Expression)package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.create(null, (DataType)IntegerType$.MODULE$)).as((Symbol)SymbolLiteral.bootstrap("apply", "c6")), (Expression)package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.create(null, (DataType)IntegerType$.MODULE$)).as((Symbol)SymbolLiteral.bootstrap("apply", "c7")), (Expression)package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.create(null, (DataType)BooleanType$.MODULE$)).as((Symbol)SymbolLiteral.bootstrap("apply", "c8")), (Expression)package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.create(null, (DataType)IntegerType$.MODULE$)).as((Symbol)SymbolLiteral.bootstrap("apply", "c9")), (Expression)package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.create(null, (DataType)IntegerType$.MODULE$)).as((Symbol)SymbolLiteral.bootstrap("apply", "c10")), (Expression)package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.create(null, (DataType)BooleanType$.MODULE$)).as((Symbol)SymbolLiteral.bootstrap("apply", "c11")), (Expression)package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.create(null, (DataType)BooleanType$.MODULE$)).as((Symbol)SymbolLiteral.bootstrap("apply", "c12")), (Expression)package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.create(null, (DataType)BooleanType$.MODULE$)).as((Symbol)SymbolLiteral.bootstrap("apply", "c13")), (Expression)package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.create(null, (DataType)BooleanType$.MODULE$)).as((Symbol)SymbolLiteral.bootstrap("apply", "c14")), (Expression)package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.create(null, (DataType)StringType$.MODULE$)).as((Symbol)SymbolLiteral.bootstrap("apply", "c15")), (Expression)package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.create(null, (DataType)StringType$.MODULE$)).as((Symbol)SymbolLiteral.bootstrap("apply", "c16")), (Expression)package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.create(null, (DataType)StringType$.MODULE$)).as((Symbol)SymbolLiteral.bootstrap("apply", "c17")), (Expression)package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.create(null, (DataType)StringType$.MODULE$)).as((Symbol)SymbolLiteral.bootstrap("apply", "c18")), (Expression)package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.create(null, (DataType)BooleanType$.MODULE$)).as((Symbol)SymbolLiteral.bootstrap("apply", "c19")), (Expression)package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.create(null, (DataType)BooleanType$.MODULE$)).as((Symbol)SymbolLiteral.bootstrap("apply", "c20"))}))).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("ConstantFoldingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 177));
        this.test("Constant folding test: Fold In(v, list) into true or false", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a"))}))).where((Expression)new In((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1)), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Literal[]{Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1)), Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2))}))));
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(originalQuery).analyze());
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a"))}))).where((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)true)))).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("ConstantFoldingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 250));
        this.test("SPARK-33544: Constant folding test with side effects", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a"))}))).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)Size$.MODULE$.apply((Expression)CreateArray$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AssertTrue[]{AssertTrue$.MODULE$.apply((Expression)package.expressions$.MODULE$.booleanToLiteral(false))}))))).$greater((Expression)package.expressions$.MODULE$.intToLiteral(0)));
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(originalQuery).analyze());
            this.comparePlans(optimized, package.plans$.MODULE$.DslLogicalPlan(originalQuery).analyze(), this.comparePlans$default$3());
        }, new Position("ConstantFoldingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 267));
        this.test("SPARK-33544: Constant folding test CreateArray", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a"))}))).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)Size$.MODULE$.apply((Expression)CreateArray$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new UnresolvedAttribute[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a"))}))))).$greater((Expression)package.expressions$.MODULE$.intToLiteral(0)));
            LogicalPlan optimized = (LogicalPlan)this.OptimizeForCreate().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(originalQuery).analyze());
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a"))}))).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("ConstantFoldingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 287));
    }
}

