/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.parser;

import java.io.File;
import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.analysis.AnalysisTest;
import org.apache.spark.sql.catalyst.analysis.Analyzer;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.dsl.package;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.AliasHelper;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.PredicateHelper;
import org.apache.spark.sql.catalyst.expressions.SortOrder;
import org.apache.spark.sql.catalyst.parser.CatalystSqlParser$;
import org.apache.spark.sql.catalyst.parser.ParseException;
import org.apache.spark.sql.catalyst.plans.PlanTestBase;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.catalyst.plans.logical.Aggregate;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.rules.Rule;
import org.apache.spark.sql.internal.SQLConf;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005U3A!\u0002\u0004\u0001'!)a\u0004\u0001C\u0001?!)!\u0005\u0001C\u0005G!)\u0011\t\u0001C\u0001\u0005\")\u0011\t\u0001C\u0001\u0013\n\u0001RI\u001d:peB\u000b'o]3s'VLG/\u001a\u0006\u0003\u000f!\ta\u0001]1sg\u0016\u0014(BA\u0005\u000b\u0003!\u0019\u0017\r^1msN$(BA\u0006\r\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u001b9\tQa\u001d9be.T!a\u0004\t\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\t\u0012aA8sO\u000e\u00011c\u0001\u0001\u00151A\u0011QCF\u0007\u0002\u0019%\u0011q\u0003\u0004\u0002\u000e'B\f'o\u001b$v]N+\u0018\u000e^3\u0011\u0005eaR\"\u0001\u000e\u000b\u0005mA\u0011\u0001C1oC2L8/[:\n\u0005uQ\"\u0001D!oC2L8/[:UKN$\u0018A\u0002\u001fj]&$h\bF\u0001!!\t\t\u0003!D\u0001\u0007\u0003-\t7o]3si\u0016\u000bX/\u00197\u0015\u0007\u0011Rs\u0007\u0005\u0002&Q5\taEC\u0001(\u0003\u0015\u00198-\u00197b\u0013\tIcE\u0001\u0003V]&$\b\"B\u0016\u0003\u0001\u0004a\u0013AC:rY\u000e{W.\\1oIB\u0011Q\u0006\u000e\b\u0003]I\u0002\"a\f\u0014\u000e\u0003AR!!\r\n\u0002\rq\u0012xn\u001c;?\u0013\t\u0019d%\u0001\u0004Qe\u0016$WMZ\u0005\u0003kY\u0012aa\u0015;sS:<'BA\u001a'\u0011\u0015A$\u00011\u0001:\u0003\u0011\u0001H.\u00198\u0011\u0005izT\"A\u001e\u000b\u0005qj\u0014a\u00027pO&\u001c\u0017\r\u001c\u0006\u0003}!\tQ\u0001\u001d7b]NL!\u0001Q\u001e\u0003\u00171{w-[2bYBc\u0017M\\\u0001\nS:$XM]2faR$2\u0001J\"E\u0011\u0015Y3\u00011\u0001-\u0011\u0015)5\u00011\u0001G\u0003!iWm]:bO\u0016\u001c\bcA\u0013HY%\u0011\u0001J\n\u0002\u000byI,\u0007/Z1uK\u0012tDC\u0002\u0013K\u0017B\u0013F\u000bC\u0003\f\t\u0001\u0007A\u0006C\u0003M\t\u0001\u0007Q*\u0001\u0003mS:,\u0007CA\u0013O\u0013\tyeEA\u0002J]RDQ!\u0015\u0003A\u00025\u000bQb\u001d;beR\u0004vn]5uS>t\u0007\"B*\u0005\u0001\u0004i\u0015\u0001D:u_B\u0004vn]5uS>t\u0007\"B#\u0005\u0001\u00041\u0005")
public class ErrorParserSuite
extends SparkFunSuite
implements AnalysisTest {
    private String sparkHome;
    private volatile boolean bitmap$0;

    @Override
    public /* synthetic */ void org$apache$spark$sql$catalyst$analysis$AnalysisTest$$super$comparePlans(LogicalPlan plan1, LogicalPlan plan2, boolean checkAnalysis) {
        PlanTestBase.comparePlans$(this, plan1, plan2, checkAnalysis);
    }

    @Override
    public Seq<Rule<LogicalPlan>> extendedAnalysisRules() {
        return AnalysisTest.extendedAnalysisRules$(this);
    }

    @Override
    public void createTempView(SessionCatalog catalog, String name, LogicalPlan plan, boolean overrideIfExists) {
        AnalysisTest.createTempView$(this, catalog, name, plan, overrideIfExists);
    }

    @Override
    public void createGlobalTempView(SessionCatalog catalog, String name, LogicalPlan plan, boolean overrideIfExists) {
        AnalysisTest.createGlobalTempView$(this, catalog, name, plan, overrideIfExists);
    }

    @Override
    public Analyzer getAnalyzer() {
        return AnalysisTest.getAnalyzer$(this);
    }

    @Override
    public void checkAnalysis(LogicalPlan inputPlan, LogicalPlan expectedPlan, boolean caseSensitive) {
        AnalysisTest.checkAnalysis$(this, inputPlan, expectedPlan, caseSensitive);
    }

    @Override
    public boolean checkAnalysis$default$3() {
        return AnalysisTest.checkAnalysis$default$3$(this);
    }

    @Override
    public void checkAnalysisWithoutViewWrapper(LogicalPlan inputPlan, LogicalPlan expectedPlan, boolean caseSensitive, boolean inlineCTE) {
        AnalysisTest.checkAnalysisWithoutViewWrapper$(this, inputPlan, expectedPlan, caseSensitive, inlineCTE);
    }

    @Override
    public boolean checkAnalysisWithoutViewWrapper$default$3() {
        return AnalysisTest.checkAnalysisWithoutViewWrapper$default$3$(this);
    }

    @Override
    public boolean checkAnalysisWithoutViewWrapper$default$4() {
        return AnalysisTest.checkAnalysisWithoutViewWrapper$default$4$(this);
    }

    @Override
    public void comparePlans(LogicalPlan plan1, LogicalPlan plan2, boolean checkAnalysis) {
        AnalysisTest.comparePlans$(this, plan1, plan2, checkAnalysis);
    }

    @Override
    public boolean comparePlans$default$3() {
        return AnalysisTest.comparePlans$default$3$(this);
    }

    @Override
    public void assertAnalysisSuccess(LogicalPlan inputPlan, boolean caseSensitive) {
        AnalysisTest.assertAnalysisSuccess$(this, inputPlan, caseSensitive);
    }

    @Override
    public boolean assertAnalysisSuccess$default$2() {
        return AnalysisTest.assertAnalysisSuccess$default$2$(this);
    }

    @Override
    public void assertAnalysisError(LogicalPlan inputPlan, Seq<String> expectedErrors, boolean caseSensitive) {
        AnalysisTest.assertAnalysisError$(this, inputPlan, expectedErrors, caseSensitive);
    }

    @Override
    public boolean assertAnalysisError$default$3() {
        return AnalysisTest.assertAnalysisError$default$3$(this);
    }

    @Override
    public void interceptParseException(Function1<String, Object> parser, String sqlCommand, Seq<String> messages) {
        AnalysisTest.interceptParseException$(this, parser, sqlCommand, messages);
    }

    @Override
    public LogicalPlan normalizeExprIds(LogicalPlan plan) {
        return PlanTestBase.normalizeExprIds$(this, plan);
    }

    @Override
    public LogicalPlan rewriteNameFromAttrNullability(LogicalPlan plan) {
        return PlanTestBase.rewriteNameFromAttrNullability$(this, plan);
    }

    @Override
    public LogicalPlan normalizePlan(LogicalPlan plan) {
        return PlanTestBase.normalizePlan$(this, plan);
    }

    @Override
    public void compareExpressions(Expression e1, Expression e2) {
        PlanTestBase.compareExpressions$(this, e1, e2);
    }

    public SQLConf conf() {
        return SQLConfHelper.conf$((SQLConfHelper)this);
    }

    @Override
    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLHelper.withSQLConf$(this, pairs, f);
    }

    @Override
    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$(this, f);
    }

    @Override
    public <T> void testSpecialDatetimeValues(Function1<ZoneId, T> test) {
        SQLHelper.testSpecialDatetimeValues$(this, test);
    }

    public Seq<Expression> splitConjunctivePredicates(Expression condition) {
        return PredicateHelper.splitConjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Option<Tuple2<Expression, LogicalPlan>> findExpressionAndTrackLineageDown(Expression exp, LogicalPlan plan) {
        return PredicateHelper.findExpressionAndTrackLineageDown$((PredicateHelper)this, (Expression)exp, (LogicalPlan)plan);
    }

    public Seq<Expression> splitDisjunctivePredicates(Expression condition) {
        return PredicateHelper.splitDisjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Expression buildBalancedPredicate(Seq<Expression> expressions, Function2<Expression, Expression, Expression> op) {
        return PredicateHelper.buildBalancedPredicate$((PredicateHelper)this, expressions, op);
    }

    public boolean canEvaluate(Expression expr, LogicalPlan plan) {
        return PredicateHelper.canEvaluate$((PredicateHelper)this, (Expression)expr, (LogicalPlan)plan);
    }

    public boolean canEvaluateWithinJoin(Expression expr) {
        return PredicateHelper.canEvaluateWithinJoin$((PredicateHelper)this, (Expression)expr);
    }

    public Option<Expression> extractPredicatesWithinOutputSet(Expression condition, AttributeSet outputSet) {
        return PredicateHelper.extractPredicatesWithinOutputSet$((PredicateHelper)this, (Expression)condition, (AttributeSet)outputSet);
    }

    public boolean isNullIntolerant(Expression expr) {
        return PredicateHelper.isNullIntolerant$((PredicateHelper)this, (Expression)expr);
    }

    public Seq<Attribute> outputWithNullability(Seq<Attribute> output, Seq<ExprId> nonNullAttrExprIds) {
        return PredicateHelper.outputWithNullability$((PredicateHelper)this, output, nonNullAttrExprIds);
    }

    public AttributeMap<Alias> getAliasMap(Project plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Project)plan);
    }

    public AttributeMap<Alias> getAliasMap(Aggregate plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Aggregate)plan);
    }

    public AttributeMap<Alias> getAliasMap(Seq<NamedExpression> exprs) {
        return AliasHelper.getAliasMap$((AliasHelper)this, exprs);
    }

    public Expression replaceAlias(Expression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAlias$((AliasHelper)this, (Expression)expr, aliasMap);
    }

    public NamedExpression replaceAliasButKeepName(NamedExpression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAliasButKeepName$((AliasHelper)this, (NamedExpression)expr, aliasMap);
    }

    public Expression trimAliases(Expression e) {
        return AliasHelper.trimAliases$((AliasHelper)this, (Expression)e);
    }

    public <T extends Expression> T trimNonTopLevelAliases(T e) {
        return (T)AliasHelper.trimNonTopLevelAliases$((AliasHelper)this, e);
    }

    private String sparkHome$lzycompute() {
        ErrorParserSuite errorParserSuite = this;
        synchronized (errorParserSuite) {
            if (!this.bitmap$0) {
                this.sparkHome = SQLHelper.sparkHome$(this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkHome;
    }

    @Override
    public String sparkHome() {
        return !this.bitmap$0 ? this.sparkHome$lzycompute() : this.sparkHome;
    }

    private void assertEqual(String sqlCommand, LogicalPlan plan) {
        LogicalPlan $org_scalatest_assert_macro_left = CatalystSqlParser$.MODULE$.parsePlan(sqlCommand);
        LogicalPlan $org_scalatest_assert_macro_right = plan;
        LogicalPlan logicalPlan = $org_scalatest_assert_macro_left;
        LogicalPlan logicalPlan2 = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(logicalPlan != null ? !logicalPlan.equals(logicalPlan2) : logicalPlan2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ErrorParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 31));
    }

    public void intercept(String sqlCommand, Seq<String> messages) {
        this.interceptParseException((Function1<String, Object>)(Function1 & Serializable)sqlText -> CatalystSqlParser$.MODULE$.parsePlan(sqlText), sqlCommand, messages);
    }

    public void intercept(String sql, int line, int startPosition, int stopPosition, Seq<String> messages) {
        ParseException e = (ParseException)this.intercept((Function0 & Serializable)() -> CatalystSqlParser$.MODULE$.parsePlan(sql), ClassTag$.MODULE$.apply(ParseException.class), new Position("ErrorParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 39));
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(e.line().isDefined(), "e.line.isDefined", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ErrorParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 42));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(e.line().get());
        int $org_scalatest_assert_macro_right = line;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ErrorParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 43));
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(e.startPosition().isDefined(), "e.startPosition.isDefined", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ErrorParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 44));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(e.startPosition().get());
        int $org_scalatest_assert_macro_right2 = startPosition;
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ErrorParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 45));
        Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(e.stop().startPosition().isDefined(), "e.stop.startPosition.isDefined", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ErrorParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 46));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(e.stop().startPosition().get());
        int $org_scalatest_assert_macro_right3 = stopPosition;
        Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ErrorParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 47));
        String error = e.getMessage();
        messages.foreach((Function1 & Serializable)message -> {
            String $org_scalatest_assert_macro_left = error;
            String $org_scalatest_assert_macro_right = message;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ErrorParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 52));
        });
    }

    public ErrorParserSuite() {
        AliasHelper.$init$((AliasHelper)this);
        PredicateHelper.$init$((PredicateHelper)this);
        SQLHelper.$init$(this);
        SQLConfHelper.$init$((SQLConfHelper)this);
        PlanTestBase.$init$(this);
        AnalysisTest.$init$(this);
        this.test("no viable input", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.intercept("select ((r + 1) ", 1, 16, 16, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"no viable alternative at input", "----------------^^^"})), new Position("ErrorParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 56));
        this.test("extraneous input", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.intercept("select 1 1", 1, 9, 10, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"extraneous input '1' expecting", "---------^^^"}));
            this.intercept("select *\nfrom r as q t", 2, 12, 13, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"extraneous input", "------------^^^"}));
        }, new Position("ErrorParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 61));
        this.test("mismatched input", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.intercept("select * from r order by q from t", 1, 27, 31, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"mismatched input", "---------------------------^^^"}));
            this.intercept("select *\nfrom r\norder by q\nfrom t", 4, 0, 4, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"mismatched input", "^^^"}));
        }, new Position("ErrorParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 66));
        this.test("semantic errors", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.intercept("select *\nfrom r\norder by q\ncluster by q", 3, 0, 11, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Combination of ORDER BY/SORT BY/DISTRIBUTE BY/CLUSTER BY is not supported", "^^^"})), new Position("ErrorParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 73));
        this.test("SPARK-21136: misleading error message due to problematic antlr grammar", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.intercept("select * from a left join_ b on a.id = b.id", (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"missing 'JOIN' at 'join_'"}));
            this.intercept("select * from test where test.t is like 'test'", (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"mismatched input 'is' expecting"}));
            this.intercept("SELECT * FROM test WHERE x NOT NULL", (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"mismatched input 'NOT' expecting"}));
        }, new Position("ErrorParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 79));
        this.test("hyphen in identifier - DDL tests", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String msg = "unquoted identifier";
            this.intercept("USE test-test", 1, 8, 9, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(10).append(msg).append(" test-test").toString()}));
            this.intercept("CREATE DATABASE IF NOT EXISTS my-database", 1, 32, 33, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(12).append(msg).append(" my-database").toString()}));
            this.intercept(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |ALTER DATABASE my-database\n        |SET DBPROPERTIES ('p1'='v1')")), 2, 17, 18, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(12).append(msg).append(" my-database").toString()}));
            this.intercept("DROP DATABASE my-database", 1, 16, 17, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(12).append(msg).append(" my-database").toString()}));
            this.intercept(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |ALTER TABLE t\n        |CHANGE COLUMN\n        |test-col TYPE BIGINT\n      ")), 4, 4, 5, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(9).append(msg).append(" test-col").toString()}));
            this.intercept(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |ALTER TABLE t\n        |RENAME COLUMN\n        |test-col TO test\n      ")), 4, 4, 5, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(9).append(msg).append(" test-col").toString()}));
            this.intercept(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |ALTER TABLE t\n        |RENAME COLUMN\n        |test TO test-col\n      ")), 4, 12, 13, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(9).append(msg).append(" test-col").toString()}));
            this.intercept(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |ALTER TABLE t\n        |DROP COLUMN\n        |test-col, test\n      ")), 4, 4, 5, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(9).append(msg).append(" test-col").toString()}));
            this.intercept("CREATE TABLE test (attri-bute INT)", 1, 24, 25, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(11).append(msg).append(" attri-bute").toString()}));
            this.intercept("CREATE FUNCTION test-func as org.test.func", 1, 20, 21, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(10).append(msg).append(" test-func").toString()}));
            this.intercept("DROP FUNCTION test-func as org.test.func", 1, 18, 19, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(10).append(msg).append(" test-func").toString()}));
            this.intercept("SHOW FUNCTIONS LIKE test-func", 1, 24, 25, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(10).append(msg).append(" test-func").toString()}));
            this.intercept(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |CREATE TABLE IF NOT EXISTS mydb.page-view\n        |USING parquet\n        |COMMENT 'This is the staging page view table'\n        |LOCATION '/user/external/page_view'\n        |TBLPROPERTIES ('p1'='v1', 'p2'='v2')\n        |AS SELECT * FROM src")), 2, 36, 37, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(10).append(msg).append(" page-view").toString()}));
            this.intercept(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |CREATE TABLE IF NOT EXISTS tab\n        |USING test-provider\n        |AS SELECT * FROM src")), 3, 10, 11, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(14).append(msg).append(" test-provider").toString()}));
            this.intercept("SHOW TABLES IN hyphen-database", 1, 21, 22, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(16).append(msg).append(" hyphen-database").toString()}));
            this.intercept("SHOW TABLE EXTENDED IN hyphen-db LIKE \"str\"", 1, 29, 30, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(10).append(msg).append(" hyphen-db").toString()}));
            this.intercept("SHOW COLUMNS IN t FROM test-db", 1, 27, 28, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(8).append(msg).append(" test-db").toString()}));
            this.intercept("DESC SCHEMA EXTENDED test-db", 1, 25, 26, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(8).append(msg).append(" test-db").toString()}));
            this.intercept("ANALYZE TABLE test-table PARTITION (part1)", 1, 18, 19, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(11).append(msg).append(" test-table").toString()}));
            this.intercept("LOAD DATA INPATH \"path\" INTO TABLE my-tab", 1, 37, 38, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(7).append(msg).append(" my-tab").toString()}));
        }, new Position("ErrorParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85));
        this.test("hyphen in identifier - DML tests", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String msg = "unquoted identifier";
            this.intercept("SELECT * FROM table-with-hyphen", 1, 19, 25, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(18).append(msg).append(" table-with-hyphen").toString()}));
            this.intercept("SELECT a-b FROM table-with-hyphen", 1, 21, 27, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(18).append(msg).append(" table-with-hyphen").toString()}));
            this.intercept("SELECT a-b AS a-b FROM t", 1, 15, 16, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(4).append(msg).append(" a-b").toString()}));
            this.intercept("SELECT a-b FROM table-hyphen WHERE a-b = 0", 1, 21, 22, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(13).append(msg).append(" table-hyphen").toString()}));
            this.intercept("SELECT (a - test_func(b-c)) FROM test-table", 1, 37, 38, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(11).append(msg).append(" test-table").toString()}));
            this.intercept("WITH a-b AS (SELECT 1 FROM s) SELECT * FROM s;", 1, 6, 7, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(4).append(msg).append(" a-b").toString()}));
            this.intercept(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |SELECT a, b\n        |FROM t1 JOIN t2\n        |USING (a, b, at-tr)\n      ")), 4, 15, 16, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(6).append(msg).append(" at-tr").toString()}));
            this.intercept(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |SELECT product, category, dense_rank()\n        |OVER (PARTITION BY category ORDER BY revenue DESC) as hyphen-rank\n        |FROM productRevenue\n      ")), 3, 60, 61, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(12).append(msg).append(" hyphen-rank").toString()}));
            this.intercept(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |SELECT a, b\n        |FROM grammar-breaker\n        |WHERE a-b > 10\n        |GROUP BY fake-breaker\n        |ORDER BY c\n      ")), 3, 12, 13, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(16).append(msg).append(" grammar-breaker").toString()}));
            this.assertEqual(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |SELECT a, b\n        |FROM t\n        |WHERE a-b > 10\n        |GROUP BY fake-breaker\n        |ORDER BY c\n      ")), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}))).where((Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$minus((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b")))).$greater((Expression)package.expressions$.MODULE$.intToLiteral(10)))).groupBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "fake")).$minus((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "breaker")))}), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))}))).orderBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "c")).asc()})));
            this.intercept(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |SELECT * FROM tab\n        |WINDOW hyphen-window AS\n        |  (PARTITION BY a, b ORDER BY c rows BETWEEN 1 PRECEDING AND 1 FOLLOWING)\n      ")), 3, 13, 14, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(14).append(msg).append(" hyphen-window").toString()}));
            this.intercept(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |SELECT * FROM tab\n        |WINDOW window_ref AS window-ref\n      ")), 3, 27, 28, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(11).append(msg).append(" window-ref").toString()}));
            this.intercept(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |SELECT tb.*\n        |FROM t-a INNER JOIN tb\n        |ON ta.a = tb.a AND ta.tag = tb.tag\n      ")), 3, 6, 7, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(4).append(msg).append(" t-a").toString()}));
            this.intercept(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |FROM test-table\n        |SELECT a\n        |SELECT b\n      ")), 2, 9, 10, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(11).append(msg).append(" test-table").toString()}));
        }, new Position("ErrorParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 143));
        this.test("SPARK-35789: lateral join with non-subquery relations", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String msg = "LATERAL can only be used with subquery";
            this.intercept("SELECT * FROM t1, LATERAL t2", (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{msg}));
            this.intercept("SELECT * FROM t1 JOIN LATERAL t2", (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{msg}));
            this.intercept("SELECT * FROM t1, LATERAL (t2 JOIN t3)", (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{msg}));
            this.intercept("SELECT * FROM t1, LATERAL (LATERAL t2)", (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{msg}));
            this.intercept("SELECT * FROM t1, LATERAL VALUES (0, 1)", (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{msg}));
            this.intercept("SELECT * FROM t1, LATERAL RANGE(0, 1)", (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{msg}));
        }, new Position("ErrorParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 212));
    }
}

