/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connector.catalog;

import java.io.Serializable;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.catalyst.analysis.TableAlreadyExistsException;
import org.apache.spark.sql.connector.catalog.CatalogV2Implicits$;
import org.apache.spark.sql.connector.catalog.CatalogV2Util$;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.InMemoryTable;
import org.apache.spark.sql.connector.catalog.InMemoryTable$;
import org.apache.spark.sql.connector.catalog.InMemoryTableCatalog$;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.connector.catalog.TableChange;
import org.apache.spark.sql.connector.distributions.Distribution;
import org.apache.spark.sql.connector.distributions.Distributions;
import org.apache.spark.sql.connector.expressions.SortOrder;
import org.apache.spark.sql.connector.expressions.Transform;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import scala.Array$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.JavaConverters$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005]f\u0001B\f\u0019\u0001\u0015BQA\r\u0001\u0005\u0002MBq!\u000e\u0001C\u0002\u0013Ea\u0007\u0003\u0004V\u0001\u0001\u0006Ia\u000e\u0005\b-\u0002\u0011\r\u0011\"\u0005X\u0011\u0019y\u0006\u0001)A\u00051\"9\u0001\r\u0001b\u0001\n\u0013\t\u0007BB3\u0001A\u0003%!\rC\u0004g\u0001\u0001\u0007I\u0011B4\t\u000f1\u0004\u0001\u0019!C\u0005[\"11\u000f\u0001Q!\n!DQ\u0001\u001e\u0001\u0005BUDQa\u001e\u0001\u0005B}Dq!!\u0001\u0001\t\u0003\n\u0019\u0001C\u0004\u0002\u0012\u0001!\t%a\u0005\t\u000f\u0005e\u0001\u0001\"\u0011\u0002\u001c!9\u0011q\u0004\u0001\u0005B\u0005\u0005\u0002bBA\u0010\u0001\u0011\u0005\u0011Q\n\u0005\b\u0003\u007f\u0002A\u0011IAA\u0011\u001d\t)\n\u0001C!\u0003/Cq!!)\u0001\t\u0003\n\u0019\u000bC\u0004\u0002.\u0002!\t!a,\t\u000f\u0005M\u0006\u0001\"\u0001\u00026\nI\")Y:jG&sW*Z7pef$\u0016M\u00197f\u0007\u0006$\u0018\r\\8h\u0015\tI\"$A\u0004dCR\fGn\\4\u000b\u0005ma\u0012!C2p]:,7\r^8s\u0015\tib$A\u0002tc2T!a\b\u0011\u0002\u000bM\u0004\u0018M]6\u000b\u0005\u0005\u0012\u0013AB1qC\u000eDWMC\u0001$\u0003\ry'oZ\u0002\u0001'\r\u0001aE\f\t\u0003O1j\u0011\u0001\u000b\u0006\u0003S)\nA\u0001\\1oO*\t1&\u0001\u0003kCZ\f\u0017BA\u0017)\u0005\u0019y%M[3diB\u0011q\u0006M\u0007\u00021%\u0011\u0011\u0007\u0007\u0002\r)\u0006\u0014G.Z\"bi\u0006dwnZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003Q\u0002\"a\f\u0001\u0002\u00159\fW.Z:qC\u000e,7/F\u00018!\u0011A4(P*\u000e\u0003eR!A\u000f\u0016\u0002\tU$\u0018\u000e\\\u0005\u0003ye\u00121!T1q!\rq\u0004j\u0013\b\u0003\u007f\u0015s!\u0001Q\"\u000e\u0003\u0005S!A\u0011\u0013\u0002\rq\u0012xn\u001c;?\u0013\u0005!\u0015!B:dC2\f\u0017B\u0001$H\u0003\u001d\u0001\u0018mY6bO\u0016T\u0011\u0001R\u0005\u0003\u0013*\u0013A\u0001T5ti*\u0011ai\u0012\t\u0003\u0019Bs!!\u0014(\u0011\u0005\u0001;\u0015BA(H\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011K\u0015\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005=;\u0005\u0003\u0002'U\u0017.K!\u0001\u0010*\u0002\u00179\fW.Z:qC\u000e,7\u000fI\u0001\u0007i\u0006\u0014G.Z:\u0016\u0003a\u0003B\u0001O\u001eZ9B\u0011qFW\u0005\u00037b\u0011!\"\u00133f]RLg-[3s!\tyS,\u0003\u0002_1\t)A+\u00192mK\u00069A/\u00192mKN\u0004\u0013!E5om\u0006d\u0017\u000eZ1uK\u0012$\u0016M\u00197fgV\t!\rE\u00029GfK!\u0001Z\u001d\u0003\u0007M+G/\u0001\nj]Z\fG.\u001b3bi\u0016$G+\u00192mKN\u0004\u0013!B0oC6,W#\u00015\u0011\u0007%T7*D\u0001H\u0013\tYwI\u0001\u0004PaRLwN\\\u0001\n?:\fW.Z0%KF$\"A\\9\u0011\u0005%|\u0017B\u00019H\u0005\u0011)f.\u001b;\t\u000fIL\u0011\u0011!a\u0001Q\u0006\u0019\u0001\u0010J\u0019\u0002\r}s\u0017-\\3!\u0003)Ig.\u001b;jC2L'0\u001a\u000b\u0004]ZD\b\"B<\f\u0001\u0004Y\u0015\u0001\u00028b[\u0016DQ!_\u0006A\u0002i\fqa\u001c9uS>t7\u000f\u0005\u0002|{6\tAP\u0003\u0002;9%\u0011a\u0010 \u0002\u0019\u0007\u0006\u001cX-\u00138tK:\u001c\u0018\u000e^5wKN#(/\u001b8h\u001b\u0006\u0004H#A&\u0002\u00151L7\u000f\u001e+bE2,7\u000f\u0006\u0003\u0002\u0006\u0005-\u0001\u0003B5\u0002\beK1!!\u0003H\u0005\u0015\t%O]1z\u0011\u001d\ti!\u0004a\u0001\u0003\u001f\t\u0011B\\1nKN\u0004\u0018mY3\u0011\t%\f9aS\u0001\nY>\fG\rV1cY\u0016$2\u0001XA\u000b\u0011\u0019\t9B\u0004a\u00013\u0006)\u0011\u000eZ3oi\u0006y\u0011N\u001c<bY&$\u0017\r^3UC\ndW\rF\u0002o\u0003;Aa!a\u0006\u0010\u0001\u0004I\u0016aC2sK\u0006$X\rV1cY\u0016$\u0012\u0002XA\u0012\u0003K\t)$a\u0012\t\r\u0005]\u0001\u00031\u0001Z\u0011\u001d\t9\u0003\u0005a\u0001\u0003S\taa]2iK6\f\u0007\u0003BA\u0016\u0003ci!!!\f\u000b\u0007\u0005=B$A\u0003usB,7/\u0003\u0003\u00024\u00055\"AC*ueV\u001cG\u000fV=qK\"9\u0011q\u0007\tA\u0002\u0005e\u0012A\u00039beRLG/[8ogB)\u0011.a\u0002\u0002<A!\u0011QHA\"\u001b\t\tyDC\u0002\u0002Bi\t1\"\u001a=qe\u0016\u001c8/[8og&!\u0011QIA \u0005%!&/\u00198tM>\u0014X\u000eC\u0004\u0002JA\u0001\r!a\u0013\u0002\u0015A\u0014x\u000e]3si&,7\u000f\u0005\u00039w-[Ec\u0004/\u0002P\u0005E\u00131KA+\u0003/\n9'a\u001d\t\r\u0005]\u0011\u00031\u0001Z\u0011\u001d\t9#\u0005a\u0001\u0003SAq!a\u000e\u0012\u0001\u0004\tI\u0004C\u0004\u0002JE\u0001\r!a\u0013\t\u000f\u0005e\u0013\u00031\u0001\u0002\\\u0005aA-[:ue&\u0014W\u000f^5p]B!\u0011QLA2\u001b\t\tyFC\u0002\u0002bi\tQ\u0002Z5tiJL'-\u001e;j_:\u001c\u0018\u0002BA3\u0003?\u0012A\u0002R5tiJL'-\u001e;j_:Dq!!\u001b\u0012\u0001\u0004\tY'\u0001\u0005pe\u0012,'/\u001b8h!\u0015I\u0017qAA7!\u0011\ti$a\u001c\n\t\u0005E\u0014q\b\u0002\n'>\u0014Ho\u0014:eKJDq!!\u001e\u0012\u0001\u0004\t9(A\u000bsKF,\u0018N]3e\u001dVl\u0007+\u0019:uSRLwN\\:\u0011\t%T\u0017\u0011\u0010\t\u0004S\u0006m\u0014bAA?\u000f\n\u0019\u0011J\u001c;\u0002\u0015\u0005dG/\u001a:UC\ndW\rF\u0003]\u0003\u0007\u000b)\t\u0003\u0004\u0002\u0018I\u0001\r!\u0017\u0005\b\u0003\u000f\u0013\u0002\u0019AAE\u0003\u001d\u0019\u0007.\u00198hKN\u0004R![AF\u0003\u001fK1!!$H\u0005)a$/\u001a9fCR,GM\u0010\t\u0004_\u0005E\u0015bAAJ1\tYA+\u00192mK\u000eC\u0017M\\4f\u0003%!'o\u001c9UC\ndW\r\u0006\u0003\u0002\u001a\u0006}\u0005cA5\u0002\u001c&\u0019\u0011QT$\u0003\u000f\t{w\u000e\\3b]\"1\u0011qC\nA\u0002e\u000b1B]3oC6,G+\u00192mKR)a.!*\u0002*\"1\u0011q\u0015\u000bA\u0002e\u000b\u0001b\u001c7e\u0013\u0012,g\u000e\u001e\u0005\u0007\u0003W#\u0002\u0019A-\u0002\u00119,w/\u00133f]R\f!#[:UC\ndW-\u00138wC2LG-\u0019;fIR!\u0011\u0011TAY\u0011\u0019\t9\"\u0006a\u00013\u0006Y1\r\\3beR\u000b'\r\\3t)\u0005q\u0007")
public class BasicInMemoryTableCatalog
implements TableCatalog {
    private final java.util.Map<List<String>, Map<String, String>> namespaces = new ConcurrentHashMap<List<String>, Map<String, String>>();
    private final java.util.Map<Identifier, Table> tables = new ConcurrentHashMap<Identifier, Table>();
    private final Set<Identifier> invalidatedTables = ConcurrentHashMap.newKeySet();
    private Option<String> _name = None$.MODULE$;

    public boolean tableExists(Identifier x$1) {
        return super.tableExists(x$1);
    }

    public boolean purgeTable(Identifier x$1) throws UnsupportedOperationException {
        return super.purgeTable(x$1);
    }

    public java.util.Map<List<String>, Map<String, String>> namespaces() {
        return this.namespaces;
    }

    public java.util.Map<Identifier, Table> tables() {
        return this.tables;
    }

    private Set<Identifier> invalidatedTables() {
        return this.invalidatedTables;
    }

    private Option<String> _name() {
        return this._name;
    }

    private void _name_$eq(Option<String> x$1) {
        this._name = x$1;
    }

    public void initialize(String name, CaseInsensitiveStringMap options) {
        this._name_$eq((Option<String>)new Some((Object)name));
    }

    public String name() {
        return (String)this._name().get();
    }

    public Identifier[] listTables(String[] namespace) {
        return (Identifier[])((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.asScalaSetConverter(this.tables().keySet()).asScala()).filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)BasicInMemoryTableCatalog.$anonfun$listTables$1(namespace, x$1)))).toArray(ClassTag$.MODULE$.apply(Identifier.class));
    }

    public Table loadTable(Identifier ident) {
        Table table;
        Option option = Option$.MODULE$.apply((Object)this.tables().get(ident));
        if (!(option instanceof Some)) {
            throw new NoSuchTableException(ident);
        }
        Some some = (Some)option;
        Table table2 = table = (Table)some.value();
        return table2;
    }

    public void invalidateTable(Identifier ident) {
        this.invalidatedTables().add(ident);
    }

    public Table createTable(Identifier ident, StructType schema, Transform[] partitions, java.util.Map<String, String> properties) {
        return this.createTable(ident, schema, partitions, properties, (Distribution)Distributions.unspecified(), (SortOrder[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(SortOrder.class)), (Option<Object>)None$.MODULE$);
    }

    public Table createTable(Identifier ident, StructType schema, Transform[] partitions, java.util.Map<String, String> properties, Distribution distribution, SortOrder[] ordering, Option<Object> requiredNumPartitions) {
        if (this.tables().containsKey(ident)) {
            throw new TableAlreadyExistsException(ident);
        }
        InMemoryTableCatalog$.MODULE$.maybeSimulateFailedTableCreation(properties);
        String tableName = new StringBuilder(1).append(this.name()).append(".").append(CatalogV2Implicits$.MODULE$.IdentifierHelper(ident).quoted()).toString();
        InMemoryTable table = new InMemoryTable(tableName, schema, partitions, properties, distribution, ordering, requiredNumPartitions);
        this.tables().put(ident, (Table)table);
        this.namespaces().putIfAbsent((List<String>)Predef$.MODULE$.wrapRefArray((Object[])ident.namespace()).toList(), (Map<String, String>)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$));
        return table;
    }

    public Table alterTable(Identifier ident, Seq<TableChange> changes) {
        InMemoryTable table = (InMemoryTable)this.loadTable(ident);
        java.util.Map properties = CatalogV2Util$.MODULE$.applyPropertiesChanges(table.properties(), changes);
        StructType schema = CatalogV2Util$.MODULE$.applySchemaChanges(table.schema(), changes);
        if (ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])schema.fields()))) {
            throw new IllegalArgumentException("Cannot drop all fields");
        }
        InMemoryTable newTable = new InMemoryTable(table.name(), schema, table.partitioning(), properties, InMemoryTable$.MODULE$.$lessinit$greater$default$5(), InMemoryTable$.MODULE$.$lessinit$greater$default$6(), InMemoryTable$.MODULE$.$lessinit$greater$default$7()).withData(table.data());
        this.tables().put(ident, (Table)newTable);
        return newTable;
    }

    public boolean dropTable(Identifier ident) {
        return Option$.MODULE$.apply((Object)this.tables().remove(ident)).isDefined();
    }

    public void renameTable(Identifier oldIdent, Identifier newIdent) {
        if (this.tables().containsKey(newIdent)) {
            throw new TableAlreadyExistsException(newIdent);
        }
        Option option = Option$.MODULE$.apply((Object)this.tables().remove(oldIdent));
        if (!(option instanceof Some)) {
            throw new NoSuchTableException(oldIdent);
        }
        Some some = (Some)option;
        Table table = (Table)some.value();
        this.tables().put(newIdent, table);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public boolean isTableInvalidated(Identifier ident) {
        return this.invalidatedTables().contains(ident);
    }

    public void clearTables() {
        this.tables().clear();
    }

    public Table alterTable(Identifier ident, TableChange[] changes) {
        return this.alterTable(ident, (Seq<TableChange>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])changes));
    }

    public static final /* synthetic */ boolean $anonfun$listTables$1(String[] namespace$1, Identifier x$1) {
        return Predef$.MODULE$.wrapRefArray((Object[])x$1.namespace()).sameElements((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])namespace$1));
    }
}

