/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.ArrayBasedSimpleHigherOrderFunction;
import org.apache.spark.sql.catalyst.expressions.ArraySort$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.HigherOrderFunction;
import org.apache.spark.sql.catalyst.expressions.LambdaFunction;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.NamedLambdaVariable;
import org.apache.spark.sql.catalyst.expressions.RowOrdering$;
import org.apache.spark.sql.catalyst.expressions.SimpleHigherOrderFunction;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.trees.BinaryLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.NullType$;
import scala.Enumeration;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(expr, func) - Sorts the input array. If func is omitted, sort\n    in ascending order. The elements of the input array must be orderable.\n    NaN is greater than any non-NaN elements for double/float type.\n    Null elements will be placed at the end of the returned array.\n    Since 3.0.0 this function also sorts and returns the array based on the\n    given comparator function. The comparator will take two arguments representing\n    two elements of the array.\n    It returns -1, 0, or 1 as the first element is less than, equal to, or greater\n    than the second element. If the comparator function returns other\n    values (including null), the function will fail and raise an error.\n    ", examples="\n    Examples:\n      > SELECT _FUNC_(array(5, 6, 1), (left, right) -> case when left < right then -1 when left > right then 1 else 0 end);\n       [1,5,6]\n      > SELECT _FUNC_(array('bc', 'ab', 'dc'), (left, right) -> case when left is null and right is null then 0 when left is null then -1 when right is null then 1 when left < right then 1 when left > right then -1 else 0 end);\n       [\"dc\",\"bc\",\"ab\"]\n      > SELECT _FUNC_(array('b', 'd', null, 'c', 'a'));\n       [\"a\",\"b\",\"c\",\"d\",null]\n  ", since="2.4.0", group="lambda_funcs")
@ScalaSignature(bytes="\u0006\u0005\t-c\u0001B\u0013'\u0001NB\u0001b\u0015\u0001\u0003\u0016\u0004%\t\u0001\u0016\u0005\t+\u0002\u0011\t\u0012)A\u0005i!Aa\u000b\u0001BK\u0002\u0013\u0005A\u000b\u0003\u0005X\u0001\tE\t\u0015!\u00035\u0011\u0015A\u0006\u0001\"\u0001Z\u0011\u0015A\u0006\u0001\"\u0001^\u0011!y\u0006\u0001#b\u0001\n\u0003\u0001\u0007\"B6\u0001\t\u0003b\u0007\"\u00029\u0001\t\u0003\n\b\"\u0002=\u0001\t\u0003J\b\u0002DA\f\u0001A\u0005\tr1Q\u0005\n\u0005e\u0001BCA\u0012\u0001!\u0015\r\u0011\"\u0001\u0002&!Q\u0011\u0011\u0006\u0001\t\u0006\u0004%\t!!\n\t\u000f\u00055\u0002\u0001\"\u0001\u00020!9\u00111\u000b\u0001\u0005B\u0005U\u0003bBA/\u0001\u0011\u0005\u0013q\f\u0005\b\u0003c\u0002A\u0011KA:\u0011%\ti\bAA\u0001\n\u0003\ty\bC\u0005\u0002\u0006\u0002\t\n\u0011\"\u0001\u0002\b\"I\u0011Q\u0014\u0001\u0012\u0002\u0013\u0005\u0011q\u0011\u0005\n\u0003?\u0003\u0011\u0011!C!\u0003CC\u0011\"!,\u0001\u0003\u0003%\t!a,\t\u0013\u0005]\u0006!!A\u0005\u0002\u0005e\u0006\"CA`\u0001\u0005\u0005I\u0011IAa\u0011%\ty\rAA\u0001\n\u0003\t\t\u000eC\u0005\u0002V\u0002\t\t\u0011\"\u0011\u0002X\"I\u00111\u001c\u0001\u0002\u0002\u0013\u0005\u0013Q\\\u0004\b\u0005\u00031\u0003\u0012\u0001B\u0002\r\u0019)c\u0005#\u0001\u0003\u0006!1\u0001,\bC\u0001\u0005/Aq!!\f\u001e\t\u0003\u0011I\u0002C\u0005\u0003$u\u0011\r\u0011\"\u0001\u0003&!A!qE\u000f!\u0002\u0013\t\t\u0002C\u0005\u0003*u\t\t\u0011\"!\u0003,!I!\u0011G\u000f\u0002\u0002\u0013\u0005%1\u0007\u0005\n\u0005\u0003j\u0012\u0011!C\u0005\u0005\u0007\u0012\u0011\"\u0011:sCf\u001cvN\u001d;\u000b\u0005\u001dB\u0013aC3yaJ,7o]5p]NT!!\u000b\u0016\u0002\u0011\r\fG/\u00197zgRT!a\u000b\u0017\u0002\u0007M\fHN\u0003\u0002.]\u0005)1\u000f]1sW*\u0011q\u0006M\u0001\u0007CB\f7\r[3\u000b\u0003E\n1a\u001c:h\u0007\u0001\u0019b\u0001\u0001\u001b9w\u0005;\u0005CA\u001b7\u001b\u00051\u0013BA\u001c'\u0005))\u0005\u0010\u001d:fgNLwN\u001c\t\u0003keJ!A\u000f\u0014\u0003G\u0005\u0013(/Y=CCN,GmU5na2,\u0007*[4iKJ|%\u000fZ3s\rVt7\r^5p]B\u0011AhP\u0007\u0002{)\u0011aHJ\u0001\bG>$WmZ3o\u0013\t\u0001UHA\bD_\u0012,w-\u001a8GC2d'-Y2l!\t\u0011U)D\u0001D\u0015\u0005!\u0015!B:dC2\f\u0017B\u0001$D\u0005\u001d\u0001&o\u001c3vGR\u0004\"\u0001\u0013)\u000f\u0005%seB\u0001&N\u001b\u0005Y%B\u0001'3\u0003\u0019a$o\\8u}%\tA)\u0003\u0002P\u0007\u00069\u0001/Y2lC\u001e,\u0017BA)S\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\ty5)\u0001\u0005be\u001e,X.\u001a8u+\u0005!\u0014!C1sOVlWM\u001c;!\u0003!1WO\\2uS>t\u0017!\u00034v]\u000e$\u0018n\u001c8!\u0003\u0019a\u0014N\\5u}Q\u0019!l\u0017/\u0011\u0005U\u0002\u0001\"B*\u0006\u0001\u0004!\u0004\"\u0002,\u0006\u0001\u0004!DC\u0001._\u0011\u0015\u0019f\u00011\u00015\u0003-)G.Z7f]R$\u0016\u0010]3\u0016\u0003\u0005\u0004\"AY3\u000e\u0003\rT!\u0001\u001a\u0016\u0002\u000bQL\b/Z:\n\u0005\u0019\u001c'\u0001\u0003#bi\u0006$\u0016\u0010]3)\u0005\u001dA\u0007C\u0001\"j\u0013\tQ7IA\u0005ue\u0006t7/[3oi\u0006AA-\u0019;b)f\u0004X-F\u0001n!\t\u0011g.\u0003\u0002pG\nI\u0011I\u001d:bsRK\b/Z\u0001\u0014G\",7m[%oaV$H)\u0019;b)f\u0004Xm\u001d\u000b\u0002eB\u00111O^\u0007\u0002i*\u0011Q\u000fK\u0001\tC:\fG._:jg&\u0011q\u000f\u001e\u0002\u0010)f\u0004Xm\u00115fG.\u0014Vm];mi\u0006!!-\u001b8e)\tQ&\u0010C\u0003|\u0015\u0001\u0007A0A\u0001g!\u0019\u0011U\u0010N@\u0002\u0012%\u0011ap\u0011\u0002\n\rVt7\r^5p]J\u0002R\u0001SA\u0001\u0003\u000bI1!a\u0001S\u0005\r\u0019V-\u001d\t\u0007\u0005\u0006\u001d\u0011-a\u0003\n\u0007\u0005%1I\u0001\u0004UkBdWM\r\t\u0004\u0005\u00065\u0011bAA\b\u0007\n9!i\\8mK\u0006t\u0007cA\u001b\u0002\u0014%\u0019\u0011Q\u0003\u0014\u0003\u001d1\u000bWN\u00193b\rVt7\r^5p]\u0006!\u0001\u0010J\u00192+\t\tY\u0002E\u0004C\u0003\u000f\ti\"!\b\u0011\u0007U\ny\"C\u0002\u0002\"\u0019\u00121CT1nK\u0012d\u0015-\u001c2eCZ\u000b'/[1cY\u0016\fABZ5sgR,E.Z7WCJ,\"!!\b)\u00051A\u0017!D:fG>tG-\u00127f[Z\u000b'\u000f\u000b\u0002\u000eQ\u0006Q1m\\7qCJ\fGo\u001c:\u0015\t\u0005E\u0012q\t\t\u0007\u0003g\ti$!\u0011\u000e\u0005\u0005U\"\u0002BA\u001c\u0003s\tA!\u001e;jY*\u0011\u00111H\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002@\u0005U\"AC\"p[B\f'/\u0019;peB\u0019!)a\u0011\n\u0007\u0005\u00153IA\u0002B]fDq!!\u0013\u000f\u0001\u0004\tY%\u0001\u0005j]B,HOU8x!\u0011\ti%a\u0014\u000e\u0003!J1!!\u0015)\u0005-Ie\u000e^3s]\u0006d'k\\<\u0002\u00199,H\u000e\\*bM\u0016,e/\u00197\u0015\r\u0005\u0005\u0013qKA-\u0011\u001d\tIe\u0004a\u0001\u0003\u0017Bq!a\u0017\u0010\u0001\u0004\t\t%A\u0007be\u001e,X.\u001a8u-\u0006dW/Z\u0001\u000baJ,G\u000f^=OC6,WCAA1!\u0011\t\u0019'a\u001b\u000f\t\u0005\u0015\u0014q\r\t\u0003\u0015\u000eK1!!\u001bD\u0003\u0019\u0001&/\u001a3fM&!\u0011QNA8\u0005\u0019\u0019FO]5oO*\u0019\u0011\u0011N\"\u0002/]LG\u000f\u001b(fo\u000eC\u0017\u000e\u001c3sK:Le\u000e^3s]\u0006dG#\u0002.\u0002v\u0005e\u0004BBA<#\u0001\u0007A'A\u0004oK^dUM\u001a;\t\r\u0005m\u0014\u00031\u00015\u0003!qWm\u001e*jO\"$\u0018\u0001B2paf$RAWAA\u0003\u0007Cqa\u0015\n\u0011\u0002\u0003\u0007A\u0007C\u0004W%A\u0005\t\u0019\u0001\u001b\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011\u0011\u0012\u0016\u0004i\u0005-5FAAG!\u0011\ty)!'\u000e\u0005\u0005E%\u0002BAJ\u0003+\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005]5)\u0001\u0006b]:|G/\u0019;j_:LA!a'\u0002\u0012\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!a)\u0011\t\u0005\u0015\u00161V\u0007\u0003\u0003OSA!!+\u0002:\u0005!A.\u00198h\u0013\u0011\ti'a*\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005E\u0006c\u0001\"\u00024&\u0019\u0011QW\"\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005\u0005\u00131\u0018\u0005\n\u0003{;\u0012\u0011!a\u0001\u0003c\u000b1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAAb!\u0019\t)-a3\u0002B5\u0011\u0011q\u0019\u0006\u0004\u0003\u0013\u001c\u0015AC2pY2,7\r^5p]&!\u0011QZAd\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005-\u00111\u001b\u0005\n\u0003{K\u0012\u0011!a\u0001\u0003\u0003\n!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR!\u00111UAm\u0011%\tiLGA\u0001\u0002\u0004\t\t,\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003\u0017\ty\u000eC\u0005\u0002>n\t\t\u00111\u0001\u0002B!\u001a\u0002!a9\u0002j\u0006-\u0018q^Ay\u0003k\f90a?\u0002~B\u0019Q'!:\n\u0007\u0005\u001dhEA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\u00055\u0018!\"\u001e`\rVs5i\u0018\u0015fqB\u0014H\u0006\t4v]\u000eL\u0003%\f\u0011T_J$8\u000f\t;iK\u0002Jg\u000e];uA\u0005\u0014(/Y=/A%3\u0007EZ;oG\u0002J7\u000fI8nSR$X\r\u001a\u0017!g>\u0014HO\u0003\u0011!A\u0001Jg\u000eI1tG\u0016tG-\u001b8hA=\u0014H-\u001a:/AQCW\rI3mK6,g\u000e^:!_\u001a\u0004C\u000f[3!S:\u0004X\u000f\u001e\u0011beJ\f\u0017\u0010I7vgR\u0004#-\u001a\u0011pe\u0012,'/\u00192mK:R\u0001\u0005\t\u0011!\u001d\u0006t\u0005%[:!OJ,\u0017\r^3sAQD\u0017M\u001c\u0011b]f\u0004cn\u001c8.\u001d\u0006t\u0005%\u001a7f[\u0016tGo\u001d\u0011g_J\u0004Cm\\;cY\u0016|c\r\\8bi\u0002\"\u0018\u0010]3/\u0015\u0001\u0002\u0003\u0005\t(vY2\u0004S\r\\3nK:$8\u000fI<jY2\u0004#-\u001a\u0011qY\u0006\u001cW\r\u001a\u0011bi\u0002\"\b.\u001a\u0011f]\u0012\u0004sN\u001a\u0011uQ\u0016\u0004#/\u001a;ve:,G\rI1se\u0006LhF\u0003\u0011!A\u0001\u001a\u0016N\\2fAMr\u0003G\f\u0019!i\"L7\u000f\t4v]\u000e$\u0018n\u001c8!C2\u001cx\u000eI:peR\u001c\b%\u00198eAI,G/\u001e:og\u0002\"\b.\u001a\u0011beJ\f\u0017\u0010\t2bg\u0016$\u0007e\u001c8!i\",'\u0002\t\u0011!A\u001dLg/\u001a8!G>l\u0007/\u0019:bi>\u0014\bEZ;oGRLwN\u001c\u0018!)\",\u0007eY8na\u0006\u0014\u0018\r^8sA]LG\u000e\u001c\u0011uC.,\u0007\u0005^<pA\u0005\u0014x-^7f]R\u001c\bE]3qe\u0016\u001cXM\u001c;j]\u001eT\u0001\u0005\t\u0011!i^|\u0007%\u001a7f[\u0016tGo\u001d\u0011pM\u0002\"\b.\u001a\u0011beJ\f\u0017P\f\u0006!A\u0001\u0002\u0013\n\u001e\u0011sKR,(O\\:![Eb\u0003\u0005\r\u0017!_J\u0004\u0013\u0007I1tAQDW\r\t4jeN$\b%\u001a7f[\u0016tG\u000fI5tA1,7o\u001d\u0011uQ\u0006tG\u0006I3rk\u0006d\u0007\u0005^8-A=\u0014\be\u001a:fCR,'O\u0003\u0011!A\u0001\"\b.\u00198!i\",\u0007e]3d_:$\u0007%\u001a7f[\u0016tGO\f\u0011JM\u0002\"\b.\u001a\u0011d_6\u0004\u0018M]1u_J\u0004c-\u001e8di&|g\u000e\t:fiV\u0014hn\u001d\u0011pi\",'O\u0003\u0011!A\u00012\u0018\r\\;fg\u0002B\u0013N\\2mk\u0012Lgn\u001a\u0011ok2d\u0017\u0006\f\u0011uQ\u0016\u0004c-\u001e8di&|g\u000eI<jY2\u0004c-Y5mA\u0005tG\r\t:bSN,\u0007%\u00198!KJ\u0014xN\u001d\u0018\u000bA\u0001\u0002\u0003%\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\t\u00190ABo\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"\n'O]1zQUb\u0003E\u000e\u0017!c%b\u0003\u0005\u000b7fMRd\u0003E]5hQRL\u0003%\f !G\u0006\u001cX\rI<iK:\u0004C.\u001a4uAq\u0002#/[4ii\u0002\"\b.\u001a8![E\u0002s\u000f[3oA1,g\r\u001e\u0011?AILw\r\u001b;!i\",g\u000eI\u0019!K2\u001cX\r\t\u0019!K:$\u0017f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011\\c1*DFN/\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u0005\u0014(/Y=)O\t\u001cw\u0005\f\u0011(C\n<C\u0006I\u0014eG\u001eJC\u0006\t\u0015mK\u001a$H\u0006\t:jO\"$\u0018\u0006I\u0017?A\r\f7/\u001a\u0011xQ\u0016t\u0007\u0005\\3gi\u0002J7\u000f\t8vY2\u0004\u0013M\u001c3!e&<\u0007\u000e\u001e\u0011jg\u0002rW\u000f\u001c7!i\",g\u000e\t\u0019!o\",g\u000e\t7fMR\u0004\u0013n\u001d\u0011ok2d\u0007\u0005\u001e5f]\u0002j\u0013\u0007I<iK:\u0004#/[4ii\u0002J7\u000f\t8vY2\u0004C\u000f[3oAE\u0002s\u000f[3oA1,g\r\u001e\u0011=AILw\r\u001b;!i\",g\u000eI\u0019!o\",g\u000e\t7fMR\u0004c\b\t:jO\"$\b\u0005\u001e5f]\u0002j\u0013\u0007I3mg\u0016\u0004\u0003\u0007I3oI&Z$\u0002\t\u0011!A\u0001\u0002\u0003e\u0017\u0012eG\nb#EY2#Y\t\n'MI/\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u0005\u0014(/Y=)O\t<C\u0006I\u0014eO1\u0002c.\u001e7mY\u0001:3m\n\u0017!O\u0005<\u0013&K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!7\n\n'\u0005\f\u0012cE1\u00123M\t\u0017#I\nbc.\u001e7m;*\u0001\u0003%A\u0003tS:\u001cW-\t\u0002\u0002z\u0006)!G\f\u001b/a\u0005)qM]8va\u0006\u0012\u0011q`\u0001\rY\u0006l'\rZ1`MVt7m]\u0001\n\u0003J\u0014\u0018-_*peR\u0004\"!N\u000f\u0014\u000bu\u00119A!\u0004\u0011\u0007\t\u0013I!C\u0002\u0003\f\r\u0013a!\u00118z%\u00164\u0007\u0003\u0002B\b\u0005+i!A!\u0005\u000b\t\tM\u0011\u0011H\u0001\u0003S>L1!\u0015B\t)\t\u0011\u0019\u0001F\u00035\u00057\u0011y\u0002\u0003\u0004\u0003\u001e}\u0001\r\u0001N\u0001\u0005Y\u00164G\u000f\u0003\u0004\u0003\"}\u0001\r\u0001N\u0001\u0006e&<\u0007\u000e^\u0001\u0012I\u00164\u0017-\u001e7u\u0007>l\u0007/\u0019:bi>\u0014XCAA\t\u0003I!WMZ1vYR\u001cu.\u001c9be\u0006$xN\u001d\u0011\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000bi\u0013iCa\f\t\u000bM\u0013\u0003\u0019\u0001\u001b\t\u000bY\u0013\u0003\u0019\u0001\u001b\u0002\u000fUt\u0017\r\u001d9msR!!Q\u0007B\u001f!\u0015\u0011%q\u0007B\u001e\u0013\r\u0011Id\u0011\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u000b\t\u000b9\u0001\u000e\u001b\t\u0011\t}2%!AA\u0002i\u000b1\u0001\u001f\u00131\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\u0011)\u0005\u0005\u0003\u0002&\n\u001d\u0013\u0002\u0002B%\u0003O\u0013aa\u00142kK\u000e$\b")
public class ArraySort
extends Expression
implements ArrayBasedSimpleHigherOrderFunction,
CodegenFallback,
Serializable {
    private transient DataType elementType;
    private Tuple2<NamedLambdaVariable, NamedLambdaVariable> x$11;
    private transient NamedLambdaVariable firstElemVar;
    private transient NamedLambdaVariable secondElemVar;
    private final Expression argument;
    private final Expression function;
    private transient Seq<Expression> children;
    private Seq<Enumeration.Value> nodePatterns;
    private boolean argumentsResolved;
    private boolean resolved;
    private transient Seq<Expression> functionsForEval;
    private Expression canonicalized;
    private volatile transient byte bitmap$trans$0;
    private volatile byte bitmap$0;

    public static Option<Tuple2<Expression, Expression>> unapply(ArraySort arraySort) {
        return ArraySort$.MODULE$.unapply(arraySort);
    }

    public static LambdaFunction defaultComparator() {
        return ArraySort$.MODULE$.defaultComparator();
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return CodegenFallback.doGenCode$(this, ctx, ev);
    }

    @Override
    public AbstractDataType argumentType() {
        return ArrayBasedSimpleHigherOrderFunction.argumentType$(this);
    }

    @Override
    public Seq<Expression> arguments() {
        return SimpleHigherOrderFunction.arguments$(this);
    }

    @Override
    public Seq<AbstractDataType> argumentTypes() {
        return SimpleHigherOrderFunction.argumentTypes$(this);
    }

    @Override
    public Seq<Expression> functions() {
        return SimpleHigherOrderFunction.functions$(this);
    }

    @Override
    public AbstractDataType functionType() {
        return SimpleHigherOrderFunction.functionType$(this);
    }

    @Override
    public Seq<AbstractDataType> functionTypes() {
        return SimpleHigherOrderFunction.functionTypes$(this);
    }

    @Override
    public Expression functionForEval() {
        return SimpleHigherOrderFunction.functionForEval$(this);
    }

    @Override
    public Expression left() {
        return SimpleHigherOrderFunction.left$(this);
    }

    @Override
    public Expression right() {
        return SimpleHigherOrderFunction.right$(this);
    }

    @Override
    public Object eval(InternalRow inputRow) {
        return SimpleHigherOrderFunction.eval$(this, inputRow);
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return BinaryLike.mapChildren$(this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return BinaryLike.withNewChildrenInternal$(this, newChildren);
    }

    @Override
    public boolean nullable() {
        return HigherOrderFunction.nullable$(this);
    }

    @Override
    public TypeCheckResult checkArgumentDataTypes() {
        return HigherOrderFunction.checkArgumentDataTypes$(this);
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return HigherOrderFunction.inputTypes$(this);
    }

    private Seq<Expression> children$lzycompute() {
        ArraySort arraySort = this;
        synchronized (arraySort) {
            if ((byte)(this.bitmap$trans$0 & 8) == 0) {
                this.children = BinaryLike.children$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 8);
            }
        }
        return this.children;
    }

    @Override
    public final Seq<Expression> children() {
        return (byte)(this.bitmap$trans$0 & 8) == 0 ? this.children$lzycompute() : this.children;
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private boolean argumentsResolved$lzycompute() {
        ArraySort arraySort = this;
        synchronized (arraySort) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.argumentsResolved = HigherOrderFunction.argumentsResolved$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.argumentsResolved;
    }

    @Override
    public boolean argumentsResolved() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.argumentsResolved$lzycompute() : this.argumentsResolved;
    }

    private boolean resolved$lzycompute() {
        ArraySort arraySort = this;
        synchronized (arraySort) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.resolved = HigherOrderFunction.resolved$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.resolved$lzycompute() : this.resolved;
    }

    private Seq<Expression> functionsForEval$lzycompute() {
        ArraySort arraySort = this;
        synchronized (arraySort) {
            if ((byte)(this.bitmap$trans$0 & 0x10) == 0) {
                this.functionsForEval = HigherOrderFunction.functionsForEval$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 0x10);
            }
        }
        return this.functionsForEval;
    }

    @Override
    public Seq<Expression> functionsForEval() {
        return (byte)(this.bitmap$trans$0 & 0x10) == 0 ? this.functionsForEval$lzycompute() : this.functionsForEval;
    }

    private Expression canonicalized$lzycompute() {
        ArraySort arraySort = this;
        synchronized (arraySort) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.canonicalized = HigherOrderFunction.canonicalized$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.canonicalized;
    }

    @Override
    public Expression canonicalized() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.canonicalized$lzycompute() : this.canonicalized;
    }

    @Override
    public final void org$apache$spark$sql$catalyst$expressions$HigherOrderFunction$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    @Override
    public Expression argument() {
        return this.argument;
    }

    @Override
    public Expression function() {
        return this.function;
    }

    private DataType elementType$lzycompute() {
        ArraySort arraySort = this;
        synchronized (arraySort) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.elementType = ((ArrayType)this.argument().dataType()).elementType();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.elementType;
    }

    public DataType elementType() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.elementType$lzycompute() : this.elementType;
    }

    @Override
    public ArrayType dataType() {
        return (ArrayType)this.argument().dataType();
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    public TypeCheckResult checkInputDataTypes() {
        block5: {
            block4: {
                var3_1 = this.checkArgumentDataTypes();
                if (!TypeCheckResult$TypeCheckSuccess$.MODULE$.equals(var3_1)) break block4;
                var4_2 = false;
                var5_3 = null;
                var6_4 = this.argument().dataType();
                if (!(var6_4 instanceof ArrayType)) ** GOTO lbl-1000
                var4_2 = true;
                var5_3 = (ArrayType)var6_4;
                dt = var5_3.elementType();
                if (RowOrdering$.MODULE$.isOrderable(dt)) {
                    v0 = this.function().dataType();
                    var8_6 = IntegerType$.MODULE$;
                    var2_7 /* !! */  = !(v0 != null ? v0.equals(var8_6) == false : var8_6 != null) ? TypeCheckResult$TypeCheckSuccess$.MODULE$ : new TypeCheckResult.TypeCheckFailure("Return type of the given function has to be IntegerType");
                } else if (var4_2) {
                    dt = var5_3.elementType();
                    dtSimple = dt.catalogString();
                    var2_7 /* !! */  = new TypeCheckResult.TypeCheckFailure(new StringBuilder(9).append(new StringBuilder(54).append(this.prettyName()).append(" does not support sorting array of type ").append(dtSimple).append(" which is not ").toString()).append("orderable").toString());
                } else {
                    var2_7 /* !! */  = new TypeCheckResult.TypeCheckFailure(new StringBuilder(27).append(this.prettyName()).append(" only supports array input.").toString());
                }
                var1_10 = var2_7 /* !! */ ;
                break block5;
            }
            var1_10 = var3_1;
        }
        return var1_10;
    }

    @Override
    public ArraySort bind(Function2<Expression, Seq<Tuple2<DataType, Object>>, LambdaFunction> f) {
        DataType dataType = this.argument().dataType();
        if (!(dataType instanceof ArrayType)) {
            throw new MatchError((Object)dataType);
        }
        ArrayType arrayType = (ArrayType)dataType;
        DataType elementType = arrayType.elementType();
        boolean containsNull = arrayType.containsNull();
        Tuple2 tuple2 = new Tuple2((Object)elementType, (Object)BoxesRunTime.boxToBoolean((boolean)containsNull));
        Tuple2 tuple22 = tuple2;
        DataType elementType2 = (DataType)tuple22._1();
        boolean containsNull2 = tuple22._2$mcZ$sp();
        Tuple2 tuple23 = new Tuple2((Object)elementType2, (Object)BoxesRunTime.boxToBoolean((boolean)containsNull2));
        Tuple2 tuple24 = new Tuple2((Object)elementType2, (Object)BoxesRunTime.boxToBoolean((boolean)containsNull2));
        LambdaFunction x$1 = (LambdaFunction)f.apply((Object)this.function(), (Object)package$.MODULE$.Nil().$colon$colon((Object)tuple24).$colon$colon((Object)tuple23));
        Expression x$2 = this.copy$default$1();
        return this.copy(x$2, x$1);
    }

    private Tuple2<NamedLambdaVariable, NamedLambdaVariable> x$11$lzycompute() {
        block5: {
            ArraySort arraySort = this;
            synchronized (arraySort) {
                NamedLambdaVariable namedLambdaVariable;
                NamedExpression secondElemVar;
                block7: {
                    Expression expression;
                    block6: {
                        SeqOps seqOps;
                        LambdaFunction lambdaFunction;
                        Seq<NamedExpression> seq;
                        if ((byte)(this.bitmap$0 & 1) != 0) break block5;
                        expression = this.function();
                        if (!(expression instanceof LambdaFunction) || (seq = (lambdaFunction = (LambdaFunction)expression).arguments()) == null || SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq(seq)) || new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) == null || SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) != 0) break block6;
                        NamedExpression firstElemVar = (NamedExpression)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
                        secondElemVar = (NamedExpression)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
                        if (!(firstElemVar instanceof NamedLambdaVariable)) break block6;
                        namedLambdaVariable = (NamedLambdaVariable)firstElemVar;
                        if (secondElemVar instanceof NamedLambdaVariable) break block7;
                    }
                    throw new MatchError((Object)expression);
                }
                NamedLambdaVariable namedLambdaVariable2 = (NamedLambdaVariable)secondElemVar;
                Tuple2 tuple2 = new Tuple2((Object)namedLambdaVariable, (Object)namedLambdaVariable2);
                this.x$11 = tuple2;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.x$11;
    }

    private /* synthetic */ Tuple2 x$11() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.x$11$lzycompute() : this.x$11;
    }

    private NamedLambdaVariable firstElemVar$lzycompute() {
        ArraySort arraySort = this;
        synchronized (arraySort) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.firstElemVar = (NamedLambdaVariable)this.x$11()._1();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.firstElemVar;
    }

    public NamedLambdaVariable firstElemVar() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.firstElemVar$lzycompute() : this.firstElemVar;
    }

    private NamedLambdaVariable secondElemVar$lzycompute() {
        ArraySort arraySort = this;
        synchronized (arraySort) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.secondElemVar = (NamedLambdaVariable)this.x$11()._2();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.secondElemVar;
    }

    public NamedLambdaVariable secondElemVar() {
        return (byte)(this.bitmap$trans$0 & 4) == 0 ? this.secondElemVar$lzycompute() : this.secondElemVar;
    }

    public Comparator<Object> comparator(InternalRow inputRow) {
        Expression f = this.functionForEval();
        return (o1, o2) -> {
            this.firstElemVar().value().set(o1);
            this.secondElemVar().value().set(o2);
            return BoxesRunTime.unboxToInt((Object)f.eval(inputRow));
        };
    }

    @Override
    public Object nullSafeEval(InternalRow inputRow, Object argumentValue) {
        Object[] arr = (Object[])((ArrayData)argumentValue).toArray(this.elementType(), ClassTag$.MODULE$.AnyRef());
        DataType dataType = this.elementType();
        NullType$ nullType$ = NullType$.MODULE$;
        if (dataType == null ? nullType$ != null : !dataType.equals(nullType$)) {
            Arrays.sort(arr, this.comparator(inputRow));
        }
        return new GenericArrayData(arr);
    }

    @Override
    public String prettyName() {
        return "array_sort";
    }

    @Override
    public ArraySort withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    public ArraySort copy(Expression argument, Expression function) {
        return new ArraySort(argument, function);
    }

    public Expression copy$default$1() {
        return this.argument();
    }

    public Expression copy$default$2() {
        return this.function();
    }

    @Override
    public String productPrefix() {
        return "ArraySort";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.argument();
                break;
            }
            case 1: {
                object = this.function();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ArraySort;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "argument";
                break;
            }
            case 1: {
                string = "function";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ArraySort)) return false;
        boolean bl = true;
        if (!bl) return false;
        ArraySort arraySort = (ArraySort)x$1;
        Expression expression = this.argument();
        Expression expression2 = arraySort.argument();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.function();
        Expression expression4 = arraySort.function();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!arraySort.canEqual(this)) return false;
        return true;
    }

    public ArraySort(Expression argument, Expression function) {
        this.argument = argument;
        this.function = function;
        ExpectsInputTypes.$init$(this);
        HigherOrderFunction.$init$(this);
        BinaryLike.$init$(this);
        SimpleHigherOrderFunction.$init$(this);
        ArrayBasedSimpleHigherOrderFunction.$init$(this);
        CodegenFallback.$init$(this);
        Statics.releaseFence();
    }

    public ArraySort(Expression argument) {
        this(argument, ArraySort$.MODULE$.defaultComparator());
    }
}

