/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.expressions.Atan2$;
import org.apache.spark.sql.catalyst.expressions.BinaryMathExpression;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(exprY, exprX) - Returns the angle in radians between the positive x-axis of a plane\n      and the point given by the coordinates (`exprX`, `exprY`), as if computed by\n      `java.lang.Math._FUNC_`.\n  ", arguments="\n    Arguments:\n      * exprY - coordinate on y-axis\n      * exprX - coordinate on x-axis\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(0, 0);\n       0.0\n  ", since="1.4.0", group="math_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005Mf\u0001\u0002\u000e\u001c\u0001\"B\u0001b\u0010\u0001\u0003\u0016\u0004%\t\u0001\u0011\u0005\t\t\u0002\u0011\t\u0012)A\u0005\u0003\"AQ\t\u0001BK\u0002\u0013\u0005\u0001\t\u0003\u0005G\u0001\tE\t\u0015!\u0003B\u0011\u00159\u0005\u0001\"\u0001I\u0011\u0015a\u0005\u0001\"\u0015N\u0011\u0015)\u0006\u0001\"\u0011W\u0011\u0015!\u0007\u0001\"\u0015f\u0011\u001dQ\u0007!!A\u0005\u0002-DqA\u001c\u0001\u0012\u0002\u0013\u0005q\u000eC\u0004{\u0001E\u0005I\u0011A8\t\u000fm\u0004\u0011\u0011!C!y\"I\u00111\u0002\u0001\u0002\u0002\u0013\u0005\u0011Q\u0002\u0005\n\u0003+\u0001\u0011\u0011!C\u0001\u0003/A\u0011\"!\b\u0001\u0003\u0003%\t%a\b\t\u0013\u00055\u0002!!A\u0005\u0002\u0005=\u0002\"CA\u001d\u0001\u0005\u0005I\u0011IA\u001e\u0011%\ty\u0004AA\u0001\n\u0003\n\teB\u0005\u0002lm\t\t\u0011#\u0001\u0002n\u0019A!dGA\u0001\u0012\u0003\ty\u0007\u0003\u0004H)\u0011\u0005\u0011q\u0011\u0005\n\u0003\u0013#\u0012\u0011!C#\u0003\u0017C\u0011\"!$\u0015\u0003\u0003%\t)a$\t\u0013\u0005UE#!A\u0005\u0002\u0006]\u0005\"CAU)\u0005\u0005I\u0011BAV\u0005\u0015\tE/\u001983\u0015\taR$A\u0006fqB\u0014Xm]:j_:\u001c(B\u0001\u0010 \u0003!\u0019\u0017\r^1msN$(B\u0001\u0011\"\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003E\r\nQa\u001d9be.T!\u0001J\u0013\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u00051\u0013aA8sO\u000e\u00011\u0003\u0002\u0001*[M\u0002\"AK\u0016\u000e\u0003mI!\u0001L\u000e\u0003)\tKg.\u0019:z\u001b\u0006$\b.\u0012=qe\u0016\u001c8/[8o!\tq\u0013'D\u00010\u0015\u0005\u0001\u0014!B:dC2\f\u0017B\u0001\u001a0\u0005\u001d\u0001&o\u001c3vGR\u0004\"\u0001\u000e\u001f\u000f\u0005URdB\u0001\u001c:\u001b\u00059$B\u0001\u001d(\u0003\u0019a$o\\8u}%\t\u0001'\u0003\u0002<_\u00059\u0001/Y2lC\u001e,\u0017BA\u001f?\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\tYt&\u0001\u0003mK\u001a$X#A!\u0011\u0005)\u0012\u0015BA\"\u001c\u0005))\u0005\u0010\u001d:fgNLwN\\\u0001\u0006Y\u00164G\u000fI\u0001\u0006e&<\u0007\u000e^\u0001\u0007e&<\u0007\u000e\u001e\u0011\u0002\rqJg.\u001b;?)\rI%j\u0013\t\u0003U\u0001AQaP\u0003A\u0002\u0005CQ!R\u0003A\u0002\u0005\u000bAB\\;mYN\u000bg-Z#wC2$2AT)T!\tqs*\u0003\u0002Q_\t\u0019\u0011I\\=\t\u000bI3\u0001\u0019\u0001(\u0002\r%t\u0007/\u001e;2\u0011\u0015!f\u00011\u0001O\u0003\u0019Ig\u000e];ue\u0005IAm\\$f]\u000e{G-\u001a\u000b\u0004/v\u0013\u0007C\u0001-\\\u001b\u0005I&B\u0001.\u001c\u0003\u001d\u0019w\u000eZ3hK:L!\u0001X-\u0003\u0011\u0015C\bO]\"pI\u0016DQAX\u0004A\u0002}\u000b1a\u0019;y!\tA\u0006-\u0003\u0002b3\nq1i\u001c3fO\u0016t7i\u001c8uKb$\b\"B2\b\u0001\u00049\u0016AA3w\u0003]9\u0018\u000e\u001e5OK^\u001c\u0005.\u001b7ee\u0016t\u0017J\u001c;fe:\fG\u000eF\u0002BM\"DQa\u001a\u0005A\u0002\u0005\u000bqA\\3x\u0019\u00164G\u000fC\u0003j\u0011\u0001\u0007\u0011)\u0001\u0005oK^\u0014\u0016n\u001a5u\u0003\u0011\u0019w\u000e]=\u0015\u0007%cW\u000eC\u0004@\u0013A\u0005\t\u0019A!\t\u000f\u0015K\u0001\u0013!a\u0001\u0003\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nT#\u00019+\u0005\u0005\u000b8&\u0001:\u0011\u0005MDX\"\u0001;\u000b\u0005U4\u0018!C;oG\",7m[3e\u0015\t9x&\u0001\u0006b]:|G/\u0019;j_:L!!\u001f;\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\u0005i\bc\u0001@\u0002\b5\tqP\u0003\u0003\u0002\u0002\u0005\r\u0011\u0001\u00027b]\u001eT!!!\u0002\u0002\t)\fg/Y\u0005\u0004\u0003\u0013y(AB*ue&tw-\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002\u0010A\u0019a&!\u0005\n\u0007\u0005MqFA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000fF\u0002O\u00033A\u0011\"a\u0007\u000f\u0003\u0003\u0005\r!a\u0004\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\t\t\u0003E\u0003\u0002$\u0005%b*\u0004\u0002\u0002&)\u0019\u0011qE\u0018\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002,\u0005\u0015\"\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!!\r\u00028A\u0019a&a\r\n\u0007\u0005UrFA\u0004C_>dW-\u00198\t\u0011\u0005m\u0001#!AA\u00029\u000b!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR\u0019Q0!\u0010\t\u0013\u0005m\u0011#!AA\u0002\u0005=\u0011AB3rk\u0006d7\u000f\u0006\u0003\u00022\u0005\r\u0003\u0002CA\u000e%\u0005\u0005\t\u0019\u0001()/\u0001\t9%!\u0014\u0002P\u0005M\u0013QKA-\u00037\ny&!\u0019\u0002f\u0005\u001d\u0004c\u0001\u0016\u0002J%\u0019\u00111J\u000e\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012\u0011\u0011K\u0001\u0002**\u0001\u0003\u0005\t\u0011`\rVs5i\u0018\u0015fqB\u0014\u0018\f\f\u0011fqB\u0014\b,\u000b\u0011.AI+G/\u001e:og\u0002\"\b.\u001a\u0011b]\u001edW\rI5oAI\fG-[1og\u0002\u0012W\r^<fK:\u0004C\u000f[3!a>\u001c\u0018\u000e^5wK\u0002BX&\u0019=jg\u0002zg\rI1!a2\fg.\u001a\u0006!A\u0001\u0002\u0003\u0005I1oI\u0002\"\b.\u001a\u0011q_&tG\u000fI4jm\u0016t\u0007EY=!i\",\u0007eY8pe\u0012Lg.\u0019;fg\u0002B\u0003-\u001a=qeb\u0003G\u0006\t1fqB\u0014\u0018\fY\u0015-A\u0005\u001c\b%\u001b4!G>l\u0007/\u001e;fI\u0002\u0012\u0017P\u0003\u0011!A\u0001\u0002\u0003\u0005\u00196bm\u0006tC.\u00198h]5\u000bG\u000f\u001b\u0018`\rVs5i\u00181/\u0015\u0001\u0002\u0013!C1sOVlWM\u001c;tC\t\t9&\u0001/\u000bA\u0001\u0002\u0003%\u0011:hk6,g\u000e^:;\u0015\u0001\u0002\u0003\u0005\t\u0011!U\u0001*\u0007\u0010\u001d:ZA5\u00023m\\8sI&t\u0017\r^3!_:\u0004\u00130L1ySNT\u0001\u0005\t\u0011!A\u0001R\u0003%\u001a=qeb\u0003S\u0006I2p_J$\u0017N\\1uK\u0002zg\u000e\t=.CbL7O\u0003\u0011!\u0003!)\u00070Y7qY\u0016\u001c\u0018EAA/\u0003eR\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006\u0006\r\u0017!a%Z$\u0002\t\u0011!A\u0001\u0002\u0003\u0005\r\u00181\u0015\u0001\u0002\u0013!B:j]\u000e,\u0017EAA2\u0003\u0015\td\u0006\u000e\u00181\u0003\u00159'o\\;qC\t\tI'\u0001\u0006nCRDwLZ;oGN\fQ!\u0011;b]J\u0002\"A\u000b\u000b\u0014\u000bQ\t\t(! \u0011\u000f\u0005M\u0014\u0011P!B\u00136\u0011\u0011Q\u000f\u0006\u0004\u0003oz\u0013a\u0002:v]RLW.Z\u0005\u0005\u0003w\n)HA\tBEN$(/Y2u\rVt7\r^5p]J\u0002B!a \u0002\u00066\u0011\u0011\u0011\u0011\u0006\u0005\u0003\u0007\u000b\u0019!\u0001\u0002j_&\u0019Q(!!\u0015\u0005\u00055\u0014\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0003u\fQ!\u00199qYf$R!SAI\u0003'CQaP\fA\u0002\u0005CQ!R\fA\u0002\u0005\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002\u001a\u0006\u0015\u0006#\u0002\u0018\u0002\u001c\u0006}\u0015bAAO_\t1q\n\u001d;j_:\u0004RALAQ\u0003\u0006K1!a)0\u0005\u0019!V\u000f\u001d7fe!A\u0011q\u0015\r\u0002\u0002\u0003\u0007\u0011*A\u0002yIA\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"!!,\u0011\u0007y\fy+C\u0002\u00022~\u0014aa\u00142kK\u000e$\b")
public class Atan2
extends BinaryMathExpression {
    private final Expression left;
    private final Expression right;

    public static Option<Tuple2<Expression, Expression>> unapply(Atan2 atan2) {
        return Atan2$.MODULE$.unapply(atan2);
    }

    public static Function1<Tuple2<Expression, Expression>, Atan2> tupled() {
        return Atan2$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Atan2>> curried() {
        return Atan2$.MODULE$.curried();
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public Object nullSafeEval(Object input1, Object input2) {
        return BoxesRunTime.boxToDouble((double)package$.MODULE$.atan2(BoxesRunTime.unboxToDouble((Object)input1) + 0.0, BoxesRunTime.unboxToDouble((Object)input2) + 0.0));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.defineCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable)(c1, c2) -> new StringBuilder(36).append("java.lang.Math.atan2(").append((String)c1).append(" + 0.0, ").append((String)c2).append(" + 0.0)").toString());
    }

    @Override
    public Expression withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    public Atan2 copy(Expression left, Expression right) {
        return new Atan2(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "Atan2";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.left();
                break;
            }
            case 1: {
                object = this.right();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Atan2;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "left";
                break;
            }
            case 1: {
                string = "right";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Atan2)) return false;
        boolean bl = true;
        if (!bl) return false;
        Atan2 atan2 = (Atan2)x$1;
        Expression expression = this.left();
        Expression expression2 = atan2.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = atan2.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!atan2.canEqual(this)) return false;
        return true;
    }

    public Atan2(Expression left, Expression right) {
        this.left = left;
        this.right = right;
        super((Function2<Object, Object, Object>)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final double apply(double y, double x) {
                return this.apply$mcDDD$sp(y, x);
            }

            public double apply$mcDDD$sp(double y, double x) {
                return package$.MODULE$.atan2(y, x);
            }
        }, "ATAN2");
    }
}

