/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.csv.CSVOptions;
import org.apache.spark.sql.catalyst.csv.UnivocityParser;
import org.apache.spark.sql.catalyst.expressions.CsvToStructs$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.ExprUtils$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.util.FailFastMode$;
import org.apache.spark.sql.catalyst.util.FailureSafeParser;
import org.apache.spark.sql.catalyst.util.ParseMode;
import org.apache.spark.sql.catalyst.util.PermissiveMode$;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Tuple5;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(csvStr, schema[, options]) - Returns a struct value with the given `csvStr` and `schema`.", examples="\n    Examples:\n      > SELECT _FUNC_('1, 0.8', 'a INT, b DOUBLE');\n       {\"a\":1,\"b\":0.8}\n      > SELECT _FUNC_('26/08/2015', 'time Timestamp', map('timestampFormat', 'dd/MM/yyyy'));\n       {\"time\":2015-08-26 00:00:00}\n  ", since="3.0.0", group="csv_funcs")
@ScalaSignature(bytes="\u0006\u0005\tuf\u0001\u0002\u001b6\u0001\nC\u0001b\u001b\u0001\u0003\u0016\u0004%\t\u0001\u001c\u0005\tg\u0002\u0011\t\u0012)A\u0005[\"AA\u000f\u0001BK\u0002\u0013\u0005Q\u000fC\u0005\u0002\u0004\u0001\u0011\t\u0012)A\u0005m\"Q\u0011Q\u0001\u0001\u0003\u0016\u0004%\t!a\u0002\t\u0015\u0005=\u0001A!E!\u0002\u0013\tI\u0001\u0003\u0006\u0002\u0012\u0001\u0011)\u001a!C\u0001\u0003'A!\"a\u0007\u0001\u0005#\u0005\u000b\u0011BA\u000b\u0011)\ti\u0002\u0001BK\u0002\u0013\u0005\u0011q\u0004\u0005\u000b\u0003G\u0001!\u0011#Q\u0001\n\u0005\u0005\u0002bBA\u0013\u0001\u0011\u0005\u0011q\u0005\u0005\b\u0003k\u0001A\u0011IA\u001c\u0011!\ty\u0004\u0001b\u0001\n\u0003a\u0007bBA!\u0001\u0001\u0006I!\u001c\u0005\b\u0003K\u0001A\u0011AA\"\u0011\u001d\t)\u0003\u0001C\u0001\u0003\u0017Bq!!\n\u0001\t\u0003\t\t\u0006\u0003\u0006\u0002Z\u0001A)\u0019!C\u0001\u00037B\u0011\"!\u001f\u0001\u0005\u0004%\t!a\u001f\t\u000f\u0005u\u0004\u0001)A\u0005}\"Q\u0011q\u0010\u0001\t\u0006\u0004%\t!!!\t\u000f\u0005E\u0005\u0001\"\u0011\u0002\u0014\"9\u00111\u0014\u0001\u0005B\u0005u\u0005bBAQ\u0001\u0011\u0005\u00131\u0015\u0005\b\u0003_\u0003A\u0011IAY\u0011\u001d\ty\f\u0001C!\u0003wBq!!1\u0001\t#\n\u0019\rC\u0005\u0002J\u0002\t\t\u0011\"\u0001\u0002L\"I\u0011q\u001b\u0001\u0012\u0002\u0013\u0005\u0011\u0011\u001c\u0005\n\u0003_\u0004\u0011\u0013!C\u0001\u0003cD\u0011\"!>\u0001#\u0003%\t!a>\t\u0013\u0005m\b!%A\u0005\u0002\u0005u\b\"\u0003B\u0001\u0001E\u0005I\u0011\u0001B\u0002\u0011%\u00119\u0001AA\u0001\n\u0003\u0012I\u0001C\u0005\u0003\u001a\u0001\t\t\u0011\"\u0001\u0003\u001c!I!1\u0005\u0001\u0002\u0002\u0013\u0005!Q\u0005\u0005\n\u0005W\u0001\u0011\u0011!C!\u0005[A\u0011B!\u000f\u0001\u0003\u0003%\tAa\u000f\t\u0013\t}\u0002!!A\u0005B\t\u0005\u0003\"\u0003B#\u0001\u0005\u0005I\u0011\tB$\u000f%\u0011Y'NA\u0001\u0012\u0003\u0011iG\u0002\u00055k\u0005\u0005\t\u0012\u0001B8\u0011\u001d\t)C\u000bC\u0001\u0005\u000fC\u0011B!#+\u0003\u0003%)Ea#\t\u0013\t5%&!A\u0005\u0002\n=\u0005\"\u0003BNUE\u0005I\u0011AA\u007f\u0011%\u0011iJKI\u0001\n\u0003\u0011\u0019\u0001C\u0005\u0003 *\n\t\u0011\"!\u0003\"\"I!q\u0016\u0016\u0012\u0002\u0013\u0005\u0011Q \u0005\n\u0005cS\u0013\u0013!C\u0001\u0005\u0007A\u0011Ba-+\u0003\u0003%IA!.\u0003\u0019\r\u001bh\u000fV8TiJ,8\r^:\u000b\u0005Y:\u0014aC3yaJ,7o]5p]NT!\u0001O\u001d\u0002\u0011\r\fG/\u00197zgRT!AO\u001e\u0002\u0007M\fHN\u0003\u0002={\u0005)1\u000f]1sW*\u0011ahP\u0001\u0007CB\f7\r[3\u000b\u0003\u0001\u000b1a\u001c:h\u0007\u0001\u0019\u0002\u0002A\"H\u0015B\u001b&\f\u0019\t\u0003\t\u0016k\u0011!N\u0005\u0003\rV\u0012q\"\u00168bef,\u0005\u0010\u001d:fgNLwN\u001c\t\u0003\t\"K!!S\u001b\u0003/QKW.\u001a.p]\u0016\fu/\u0019:f\u000bb\u0004(/Z:tS>t\u0007CA&O\u001b\u0005a%BA'6\u0003\u001d\u0019w\u000eZ3hK:L!a\u0014'\u0003\u001f\r{G-Z4f]\u001a\u000bG\u000e\u001c2bG.\u0004\"\u0001R)\n\u0005I+$!E#ya\u0016\u001cGo]%oaV$H+\u001f9fgB\u0011Ak\u0016\b\u0003\tVK!AV\u001b\u0002\u000fA\f7m[1hK&\u0011\u0001,\u0017\u0002\u000f\u001dVdG.\u00138u_2,'/\u00198u\u0015\t1V\u0007\u0005\u0002\\=6\tALC\u0001^\u0003\u0015\u00198-\u00197b\u0013\tyFLA\u0004Qe>$Wo\u0019;\u0011\u0005\u0005DgB\u00012h\u001d\t\u0019g-D\u0001e\u0015\t)\u0017)\u0001\u0004=e>|GOP\u0005\u0002;&\u0011a\u000bX\u0005\u0003S*\u0014AbU3sS\u0006d\u0017N_1cY\u0016T!A\u0016/\u0002\rM\u001c\u0007.Z7b+\u0005i\u0007C\u00018r\u001b\u0005y'B\u00019:\u0003\u0015!\u0018\u0010]3t\u0013\t\u0011xN\u0001\u0006TiJ,8\r\u001e+za\u0016\fqa]2iK6\f\u0007%A\u0004paRLwN\\:\u0016\u0003Y\u0004Ba^>\u007f}:\u0011\u00010\u001f\t\u0003GrK!A\u001f/\u0002\rA\u0013X\rZ3g\u0013\taXPA\u0002NCBT!A\u001f/\u0011\u0005]|\u0018bAA\u0001{\n11\u000b\u001e:j]\u001e\f\u0001b\u001c9uS>t7\u000fI\u0001\u0006G\"LG\u000eZ\u000b\u0003\u0003\u0013\u00012\u0001RA\u0006\u0013\r\ti!\u000e\u0002\u000b\u000bb\u0004(/Z:tS>t\u0017AB2iS2$\u0007%\u0001\u0006uS6,'l\u001c8f\u0013\u0012,\"!!\u0006\u0011\tm\u000b9B`\u0005\u0004\u00033a&AB(qi&|g.A\u0006uS6,'l\u001c8f\u0013\u0012\u0004\u0013A\u0004:fcVL'/\u001a3TG\",W.Y\u000b\u0003\u0003C\u0001BaWA\f[\u0006y!/Z9vSJ,GmU2iK6\f\u0007%\u0001\u0004=S:LGO\u0010\u000b\r\u0003S\tY#!\f\u00020\u0005E\u00121\u0007\t\u0003\t\u0002AQa[\u0006A\u00025DQ\u0001^\u0006A\u0002YDq!!\u0002\f\u0001\u0004\tI\u0001C\u0005\u0002\u0012-\u0001\n\u00111\u0001\u0002\u0016!I\u0011QD\u0006\u0011\u0002\u0003\u0007\u0011\u0011E\u0001\t]VdG.\u00192mKV\u0011\u0011\u0011\b\t\u00047\u0006m\u0012bAA\u001f9\n9!i\\8mK\u0006t\u0017A\u00048vY2\f'\r\\3TG\",W.Y\u0001\u0010]VdG.\u00192mKN\u001b\u0007.Z7bAQA\u0011\u0011FA#\u0003\u000f\nI\u0005C\u0004\u0002\u0006=\u0001\r!!\u0003\t\r-|\u0001\u0019AA\u0005\u0011\u0015!x\u00021\u0001w)\u0019\tI#!\u0014\u0002P!9\u0011Q\u0001\tA\u0002\u0005%\u0001BB6\u0011\u0001\u0004\tI\u0001\u0006\u0005\u0002*\u0005M\u0013QKA,\u0011\u001d\t)!\u0005a\u0001\u0003\u0013Aaa[\tA\u0002\u0005%\u0001B\u0002;\u0012\u0001\u0004\tI!A\u0005d_:4XM\u001d;feV\u0011\u0011Q\f\t\b7\u0006}\u00131MA5\u0013\r\t\t\u0007\u0018\u0002\n\rVt7\r^5p]F\u0002R!YA3\u0003SJ1!a\u001ak\u0005!IE/\u001a:bi>\u0014\b\u0003BA6\u0003[j\u0011aN\u0005\u0004\u0003_:$aC%oi\u0016\u0014h.\u00197S_^D3AEA:!\rY\u0016QO\u0005\u0004\u0003ob&!\u0003;sC:\u001c\u0018.\u001a8u\u0003Mq\u0017-\\3PM\u000e{'O];qiJ+7m\u001c:e+\u0005q\u0018\u0001\u00068b[\u0016|emQ8seV\u0004HOU3d_J$\u0007%\u0001\u0004qCJ\u001cXM]\u000b\u0003\u0003\u0007\u0003R!!\"\u0002\fzl!!a\"\u000b\u0007\u0005%u'\u0001\u0003vi&d\u0017\u0002BAG\u0003\u000f\u0013\u0011CR1jYV\u0014XmU1gKB\u000b'o]3sQ\r)\u00121O\u0001\tI\u0006$\u0018\rV=qKV\u0011\u0011Q\u0013\t\u0004]\u0006]\u0015bAAM_\nAA)\u0019;b)f\u0004X-\u0001\u0007xSRDG+[7f5>tW\rF\u0002H\u0003?Ca!!\u0005\u0018\u0001\u0004q\u0018\u0001\u00048vY2\u001c\u0016MZ3Fm\u0006dG\u0003BAS\u0003W\u00032aWAT\u0013\r\tI\u000b\u0018\u0002\u0004\u0003:L\bbBAW1\u0001\u0007\u0011QU\u0001\u0006S:\u0004X\u000f^\u0001\u000bS:\u0004X\u000f\u001e+za\u0016\u001cXCAAZ!\u0015\t\u0017QWA]\u0013\r\t9L\u001b\u0002\u0004'\u0016\f\bc\u00018\u0002<&\u0019\u0011QX8\u0003!\u0005\u00137\u000f\u001e:bGR$\u0015\r^1UsB,\u0017A\u00039sKR$\u0018PT1nK\u0006!r/\u001b;i\u001d\u0016<8\t[5mI&sG/\u001a:oC2$B!!\u000b\u0002F\"9\u0011qY\u000eA\u0002\u0005%\u0011\u0001\u00038fo\u000eC\u0017\u000e\u001c3\u0002\t\r|\u0007/\u001f\u000b\r\u0003S\ti-a4\u0002R\u0006M\u0017Q\u001b\u0005\bWr\u0001\n\u00111\u0001n\u0011\u001d!H\u0004%AA\u0002YD\u0011\"!\u0002\u001d!\u0003\u0005\r!!\u0003\t\u0013\u0005EA\u0004%AA\u0002\u0005U\u0001\"CA\u000f9A\u0005\t\u0019AA\u0011\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!a7+\u00075\fin\u000b\u0002\u0002`B!\u0011\u0011]Av\u001b\t\t\u0019O\u0003\u0003\u0002f\u0006\u001d\u0018!C;oG\",7m[3e\u0015\r\tI\u000fX\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAw\u0003G\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"!a=+\u0007Y\fi.\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005e(\u0006BA\u0005\u0003;\fabY8qs\u0012\"WMZ1vYR$C'\u0006\u0002\u0002\u0000*\"\u0011QCAo\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIU*\"A!\u0002+\t\u0005\u0005\u0012Q\\\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\t-\u0001\u0003\u0002B\u0007\u0005/i!Aa\u0004\u000b\t\tE!1C\u0001\u0005Y\u0006twM\u0003\u0002\u0003\u0016\u0005!!.\u0019<b\u0013\u0011\t\tAa\u0004\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\tu\u0001cA.\u0003 %\u0019!\u0011\u0005/\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005\u0015&q\u0005\u0005\n\u0005S!\u0013\u0011!a\u0001\u0005;\t1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XC\u0001B\u0018!\u0019\u0011\tDa\u000e\u0002&6\u0011!1\u0007\u0006\u0004\u0005ka\u0016AC2pY2,7\r^5p]&!\u0011q\rB\u001a\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA\u001d\u0005{A\u0011B!\u000b'\u0003\u0003\u0005\r!!*\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0005\u0005\u0017\u0011\u0019\u0005C\u0005\u0003*\u001d\n\t\u00111\u0001\u0003\u001e\u00051Q-];bYN$B!!\u000f\u0003J!I!\u0011\u0006\u0015\u0002\u0002\u0003\u0007\u0011Q\u0015\u0015\u0014\u0001\t5#1\u000bB+\u00053\u0012YFa\u0018\u0003b\t\u0015$q\r\t\u0004\t\n=\u0013b\u0001B)k\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017E\u0001B,\u0003\u0001|f)\u0016(D?\"\u001a7O^*ue2\u00023o\u00195f[\u0006\\F\u0006I8qi&|gn]/*A5\u0002#+\u001a;ve:\u001c\b%\u0019\u0011tiJ,8\r\u001e\u0011wC2,X\rI<ji\"\u0004C\u000f[3!O&4XM\u001c\u0011aGN48\u000b\u001e:aA\u0005tG\r\t1tG\",W.\u00191/\u0003!)\u00070Y7qY\u0016\u001c\u0018E\u0001B/\u0003\u0005m&\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u00142Y\u0001\u0002d\u0006O\u0014-A\u001d\n\u0007%\u0013(UY\u0001\u0012\u0007\u0005R(V\u00052+u%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!w\n\n'EO\u0019-E\t\u0014#\b\r\u00189{*\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~CsE\r\u001c0aaz#\u0007M\u00196O1\u0002s\u0005^5nK\u0002\"\u0016.\\3ti\u0006l\u0007o\n\u0017![\u0006\u0004\bf\n;j[\u0016\u001cH/Y7q\r>\u0014X.\u0019;(Y\u0001:C\rZ\u0018N\u001b>J\u00180_=(S%Z$\u0002\t\u0011!A\u0001\u0002\u0003e\u001f\u0012uS6,'E\u000f\u001a1cUj\u0003\u0007O\u00173m\u0001\u0002\u0004G\u000f\u00191uA\u0002TP\u0003\u0011!\u0003\u0015\u0019\u0018N\\2fC\t\u0011\u0019'A\u00034]Ar\u0003'A\u0003he>,\b/\t\u0002\u0003j\u0005I1m\u001d<`MVt7m]\u0001\r\u0007N4Hk\\*ueV\u001cGo\u001d\t\u0003\t*\u001aRA\u000bB9\u0005{\u0002bBa\u001d\u0003z54\u0018\u0011BA\u000b\u0003C\tI#\u0004\u0002\u0003v)\u0019!q\u000f/\u0002\u000fI,h\u000e^5nK&!!1\u0010B;\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|g.\u000e\t\u0005\u0005\u007f\u0012))\u0004\u0002\u0003\u0002*!!1\u0011B\n\u0003\tIw.C\u0002j\u0005\u0003#\"A!\u001c\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"Aa\u0003\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0019\u0005%\"\u0011\u0013BJ\u0005+\u00139J!'\t\u000b-l\u0003\u0019A7\t\u000bQl\u0003\u0019\u0001<\t\u000f\u0005\u0015Q\u00061\u0001\u0002\n!I\u0011\u0011C\u0017\u0011\u0002\u0003\u0007\u0011Q\u0003\u0005\n\u0003;i\u0003\u0013!a\u0001\u0003C\tq\"\u00199qYf$C-\u001a4bk2$H\u0005N\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%k\u00059QO\\1qa2LH\u0003\u0002BR\u0005W\u0003RaWA\f\u0005K\u00032b\u0017BT[Z\fI!!\u0006\u0002\"%\u0019!\u0011\u0016/\u0003\rQ+\b\u000f\\36\u0011%\u0011i\u000bMA\u0001\u0002\u0004\tI#A\u0002yIA\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\"\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$S'\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u00038B!!Q\u0002B]\u0013\u0011\u0011YLa\u0004\u0003\r=\u0013'.Z2u\u0001")
public class CsvToStructs
extends UnaryExpression
implements TimeZoneAwareExpression,
CodegenFallback,
ExpectsInputTypes,
package.NullIntolerant,
Serializable {
    private transient Function1<Iterator<InternalRow>, InternalRow> converter;
    private transient FailureSafeParser<String> parser;
    private final StructType schema;
    private final Map<String, String> options;
    private final Expression child;
    private final Option<String> timeZoneId;
    private final Option<StructType> requiredSchema;
    private final StructType nullableSchema;
    private final String nameOfCorruptRecord;
    private boolean resolved;
    private Seq<Enumeration.Value> nodePatterns;
    private transient ZoneId zoneId;
    private volatile transient byte bitmap$trans$0;
    private volatile boolean bitmap$0;

    public static Option<StructType> $lessinit$greater$default$5() {
        return CsvToStructs$.MODULE$.$lessinit$greater$default$5();
    }

    public static Option<String> $lessinit$greater$default$4() {
        return CsvToStructs$.MODULE$.$lessinit$greater$default$4();
    }

    public static Option<Tuple5<StructType, Map<String, String>, Expression, Option<String>, Option<StructType>>> unapply(CsvToStructs csvToStructs) {
        return CsvToStructs$.MODULE$.unapply(csvToStructs);
    }

    public static Option<StructType> apply$default$5() {
        return CsvToStructs$.MODULE$.apply$default$5();
    }

    public static Option<String> apply$default$4() {
        return CsvToStructs$.MODULE$.apply$default$4();
    }

    public static Function1<Tuple5<StructType, Map<String, String>, Expression, Option<String>, Option<StructType>>, CsvToStructs> tupled() {
        return CsvToStructs$.MODULE$.tupled();
    }

    public static Function1<StructType, Function1<Map<String, String>, Function1<Expression, Function1<Option<String>, Function1<Option<StructType>, CsvToStructs>>>>> curried() {
        return CsvToStructs$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return CodegenFallback.doGenCode$(this, ctx, ev);
    }

    @Override
    public Seq<Enumeration.Value> nodePatternsInternal() {
        return TimeZoneAwareExpression.nodePatternsInternal$(this);
    }

    @Override
    public ZoneId zoneIdForType(DataType dataType) {
        return TimeZoneAwareExpression.zoneIdForType$(this, dataType);
    }

    private boolean resolved$lzycompute() {
        CsvToStructs csvToStructs = this;
        synchronized (csvToStructs) {
            if (!this.bitmap$0) {
                this.resolved = TimeZoneAwareExpression.resolved$(this);
                this.bitmap$0 = true;
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        return !this.bitmap$0 ? this.resolved$lzycompute() : this.resolved;
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private ZoneId zoneId$lzycompute() {
        CsvToStructs csvToStructs = this;
        synchronized (csvToStructs) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.zoneId = TimeZoneAwareExpression.zoneId$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.zoneId;
    }

    @Override
    public ZoneId zoneId() {
        return (byte)(this.bitmap$trans$0 & 4) == 0 ? this.zoneId$lzycompute() : this.zoneId;
    }

    @Override
    public final void org$apache$spark$sql$catalyst$expressions$TimeZoneAwareExpression$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public StructType schema() {
        return this.schema;
    }

    public Map<String, String> options() {
        return this.options;
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public Option<String> timeZoneId() {
        return this.timeZoneId;
    }

    public Option<StructType> requiredSchema() {
        return this.requiredSchema;
    }

    @Override
    public boolean nullable() {
        return this.child().nullable();
    }

    public StructType nullableSchema() {
        return this.nullableSchema;
    }

    private Function1<Iterator<InternalRow>, InternalRow> converter$lzycompute() {
        CsvToStructs csvToStructs = this;
        synchronized (csvToStructs) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.converter = (Function1 & Serializable)rows -> {
                    void var1_1;
                    if (!rows.hasNext()) {
                        throw QueryExecutionErrors$.MODULE$.rowFromCSVParserNotExpectedError();
                    }
                    InternalRow result = (InternalRow)rows.next();
                    Predef$.MODULE$.assert(!rows.hasNext());
                    return var1_1;
                };
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.converter;
    }

    public Function1<Iterator<InternalRow>, InternalRow> converter() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.converter$lzycompute() : this.converter;
    }

    public String nameOfCorruptRecord() {
        return this.nameOfCorruptRecord;
    }

    private FailureSafeParser<String> parser$lzycompute() {
        CsvToStructs csvToStructs = this;
        synchronized (csvToStructs) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                ParseMode mode;
                CSVOptions parsedOptions = new CSVOptions(this.options(), true, (String)this.timeZoneId().get(), this.nameOfCorruptRecord());
                ParseMode parseMode = mode = parsedOptions.parseMode();
                PermissiveMode$ permissiveMode$ = PermissiveMode$.MODULE$;
                if (parseMode == null ? permissiveMode$ != null : !parseMode.equals(permissiveMode$)) {
                    ParseMode parseMode2 = mode;
                    FailFastMode$ failFastMode$ = FailFastMode$.MODULE$;
                    if (parseMode2 == null ? failFastMode$ != null : !parseMode2.equals(failFastMode$)) {
                        throw QueryCompilationErrors$.MODULE$.parseModeUnsupportedError("from_csv", mode);
                    }
                }
                ExprUtils$.MODULE$.verifyColumnNameOfCorruptRecord(this.nullableSchema(), parsedOptions.columnNameOfCorruptRecord());
                StructType actualSchema = StructType$.MODULE$.apply((Seq<StructField>)((Seq)this.nullableSchema().filterNot((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)CsvToStructs.$anonfun$parser$1(parsedOptions, x$1)))));
                StructType actualRequiredSchema = StructType$.MODULE$.apply((Seq<StructField>)((Seq)((IterableOps)this.requiredSchema().map((Function1 & Serializable)x$2 -> x$2.asNullable()).getOrElse((Function0 & Serializable)() -> this.nullableSchema())).filterNot((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)CsvToStructs.$anonfun$parser$4(parsedOptions, x$3)))));
                UnivocityParser rawParser = new UnivocityParser(actualSchema, actualRequiredSchema, parsedOptions);
                this.parser = new FailureSafeParser((Function1 & Serializable)input -> Option$.MODULE$.option2Iterable((Option)rawParser.parse().apply(input)), mode, this.nullableSchema(), parsedOptions.columnNameOfCorruptRecord());
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.parser;
    }

    public FailureSafeParser<String> parser() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.parser$lzycompute() : this.parser;
    }

    @Override
    public DataType dataType() {
        return ((StructType)this.requiredSchema().getOrElse((Function0 & Serializable)() -> this.schema())).asNullable();
    }

    @Override
    public TimeZoneAwareExpression withTimeZone(String timeZoneId) {
        Option x$1 = Option$.MODULE$.apply((Object)timeZoneId);
        StructType x$2 = this.copy$default$1();
        Map<String, String> x$3 = this.copy$default$2();
        Expression x$4 = this.copy$default$3();
        Option<StructType> x$5 = this.copy$default$5();
        return this.copy(x$2, x$3, x$4, (Option<String>)x$1, x$5);
    }

    @Override
    public Object nullSafeEval(Object input) {
        String csv = ((UTF8String)input).toString();
        return this.converter().apply(this.parser().parse(csv));
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        StringType$ stringType$ = StringType$.MODULE$;
        return package$.MODULE$.Nil().$colon$colon((Object)stringType$);
    }

    @Override
    public String prettyName() {
        return "from_csv";
    }

    @Override
    public CsvToStructs withNewChildInternal(Expression newChild) {
        Expression x$1 = newChild;
        StructType x$2 = this.copy$default$1();
        Map<String, String> x$3 = this.copy$default$2();
        Option<String> x$4 = this.copy$default$4();
        Option<StructType> x$5 = this.copy$default$5();
        return this.copy(x$2, x$3, x$1, x$4, x$5);
    }

    public CsvToStructs copy(StructType schema, Map<String, String> options, Expression child, Option<String> timeZoneId, Option<StructType> requiredSchema) {
        return new CsvToStructs(schema, options, child, timeZoneId, requiredSchema);
    }

    public StructType copy$default$1() {
        return this.schema();
    }

    public Map<String, String> copy$default$2() {
        return this.options();
    }

    public Expression copy$default$3() {
        return this.child();
    }

    public Option<String> copy$default$4() {
        return this.timeZoneId();
    }

    public Option<StructType> copy$default$5() {
        return this.requiredSchema();
    }

    @Override
    public String productPrefix() {
        return "CsvToStructs";
    }

    public int productArity() {
        return 5;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.schema();
                break;
            }
            case 1: {
                object = this.options();
                break;
            }
            case 2: {
                object = this.child();
                break;
            }
            case 3: {
                object = this.timeZoneId();
                break;
            }
            case 4: {
                object = this.requiredSchema();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof CsvToStructs;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "schema";
                break;
            }
            case 1: {
                string = "options";
                break;
            }
            case 2: {
                string = "child";
                break;
            }
            case 3: {
                string = "timeZoneId";
                break;
            }
            case 4: {
                string = "requiredSchema";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof CsvToStructs)) return false;
        boolean bl = true;
        if (!bl) return false;
        CsvToStructs csvToStructs = (CsvToStructs)x$1;
        StructType structType = this.schema();
        StructType structType2 = csvToStructs.schema();
        if (structType == null) {
            if (structType2 != null) {
                return false;
            }
        } else if (!((Object)structType).equals(structType2)) return false;
        Map<String, String> map = this.options();
        Map<String, String> map2 = csvToStructs.options();
        if (map == null) {
            if (map2 != null) {
                return false;
            }
        } else if (!map.equals(map2)) return false;
        Expression expression = this.child();
        Expression expression2 = csvToStructs.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Option<String> option = this.timeZoneId();
        Option<String> option2 = csvToStructs.timeZoneId();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Option<StructType> option3 = this.requiredSchema();
        Option<StructType> option4 = csvToStructs.requiredSchema();
        if (option3 == null) {
            if (option4 != null) {
                return false;
            }
        } else if (!option3.equals(option4)) return false;
        if (!csvToStructs.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$parser$1(CSVOptions parsedOptions$1, StructField x$1) {
        String string = x$1.name();
        String string2 = parsedOptions$1.columnNameOfCorruptRecord();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$parser$4(CSVOptions parsedOptions$1, StructField x$3) {
        String string = x$3.name();
        String string2 = parsedOptions$1.columnNameOfCorruptRecord();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public CsvToStructs(StructType schema, Map<String, String> options, Expression child, Option<String> timeZoneId, Option<StructType> requiredSchema) {
        this.schema = schema;
        this.options = options;
        this.child = child;
        this.timeZoneId = timeZoneId;
        this.requiredSchema = requiredSchema;
        TimeZoneAwareExpression.$init$(this);
        CodegenFallback.$init$(this);
        ExpectsInputTypes.$init$(this);
        this.nullableSchema = schema.asNullable();
        this.nameOfCorruptRecord = SQLConf$.MODULE$.get().getConf(SQLConf$.MODULE$.COLUMN_NAME_OF_CORRUPT_RECORD());
        Statics.releaseFence();
    }

    public CsvToStructs(Expression child, Expression schema, Map<String, String> options) {
        this(ExprUtils$.MODULE$.evalSchemaExpr(schema), options, child, (Option<String>)None$.MODULE$, CsvToStructs$.MODULE$.$lessinit$greater$default$5());
    }

    public CsvToStructs(Expression child, Expression schema) {
        this(child, schema, (Map<String, String>)Predef$.MODULE$.Map().empty());
    }

    public CsvToStructs(Expression child, Expression schema, Expression options) {
        this(ExprUtils$.MODULE$.evalSchemaExpr(schema), ExprUtils$.MODULE$.convertToMapData(options), child, (Option<String>)None$.MODULE$, CsvToStructs$.MODULE$.$lessinit$greater$default$5());
    }
}

