/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Length$;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TypeCollection;
import org.apache.spark.sql.types.TypeCollection$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(expr) - Returns the character length of string data or number of bytes of binary data. The length of string data includes the trailing spaces. The length of binary data includes binary zeros.", examples="\n    Examples:\n      > SELECT _FUNC_('Spark SQL ');\n       10\n      > SELECT CHAR_LENGTH('Spark SQL ');\n       10\n      > SELECT CHARACTER_LENGTH('Spark SQL ');\n       10\n  ", since="1.5.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005\rg\u0001B\r\u001b\u0001\u001eB\u0001b\u0012\u0001\u0003\u0016\u0004%\t\u0001\u0013\u0005\t\u0019\u0002\u0011\t\u0012)A\u0005\u0013\")Q\n\u0001C\u0001\u001d\")\u0011\u000b\u0001C!%\")\u0011\f\u0001C!5\")\u0011\r\u0001C)E\")\u0001\u000e\u0001C!S\")q\u000f\u0001C)q\"91\u0010AA\u0001\n\u0003a\bb\u0002@\u0001#\u0003%\ta \u0005\n\u0003+\u0001\u0011\u0011!C!\u0003/A\u0011\"!\u000b\u0001\u0003\u0003%\t!a\u000b\t\u0013\u0005M\u0002!!A\u0005\u0002\u0005U\u0002\"CA\u001e\u0001\u0005\u0005I\u0011IA\u001f\u0011%\tY\u0005AA\u0001\n\u0003\ti\u0005C\u0005\u0002X\u0001\t\t\u0011\"\u0011\u0002Z!I\u0011Q\f\u0001\u0002\u0002\u0013\u0005\u0013qL\u0004\n\u0003\u0007S\u0012\u0011!E\u0001\u0003\u000b3\u0001\"\u0007\u000e\u0002\u0002#\u0005\u0011q\u0011\u0005\u0007\u001bN!\t!a(\t\u0013\u0005\u00056#!A\u0005F\u0005\r\u0006\"CAS'\u0005\u0005I\u0011QAT\u0011%\tYkEA\u0001\n\u0003\u000bi\u000bC\u0005\u0002:N\t\t\u0011\"\u0003\u0002<\n1A*\u001a8hi\"T!a\u0007\u000f\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003;y\t\u0001bY1uC2L8\u000f\u001e\u0006\u0003?\u0001\n1a]9m\u0015\t\t#%A\u0003ta\u0006\u00148N\u0003\u0002$I\u00051\u0011\r]1dQ\u0016T\u0011!J\u0001\u0004_J<7\u0001A\n\u0007\u0001!bsF\u000e\u001f\u0011\u0005%RS\"\u0001\u000e\n\u0005-R\"aD+oCJLX\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005%j\u0013B\u0001\u0018\u001b\u0005YIU\u000e\u001d7jG&$8)Y:u\u0013:\u0004X\u000f\u001e+za\u0016\u001c\bC\u0001\u00194\u001d\tI\u0013'\u0003\u000235\u00059\u0001/Y2lC\u001e,\u0017B\u0001\u001b6\u00059qU\u000f\u001c7J]R|G.\u001a:b]RT!A\r\u000e\u0011\u0005]RT\"\u0001\u001d\u000b\u0003e\nQa]2bY\u0006L!a\u000f\u001d\u0003\u000fA\u0013x\u000eZ;diB\u0011Q\b\u0012\b\u0003}\rs!a\u0010\"\u000e\u0003\u0001S!!\u0011\u0014\u0002\rq\u0012xn\u001c;?\u0013\u0005I\u0014B\u0001\u001a9\u0013\t)eI\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u00023q\u0005)1\r[5mIV\t\u0011\n\u0005\u0002*\u0015&\u00111J\u0007\u0002\u000b\u000bb\u0004(/Z:tS>t\u0017AB2iS2$\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0003\u001fB\u0003\"!\u000b\u0001\t\u000b\u001d\u001b\u0001\u0019A%\u0002\u0011\u0011\fG/\u0019+za\u0016,\u0012a\u0015\t\u0003)^k\u0011!\u0016\u0006\u0003-z\tQ\u0001^=qKNL!\u0001W+\u0003\u0011\u0011\u000bG/\u0019+za\u0016\f!\"\u001b8qkR$\u0016\u0010]3t+\u0005Y\u0006cA\u001f]=&\u0011QL\u0012\u0002\u0004'\u0016\f\bC\u0001+`\u0013\t\u0001WK\u0001\tBEN$(/Y2u\t\u0006$\u0018\rV=qK\u0006aa.\u001e7m'\u00064W-\u0012<bYR\u00111M\u001a\t\u0003o\u0011L!!\u001a\u001d\u0003\u0007\u0005s\u0017\u0010C\u0003h\r\u0001\u00071-A\u0003wC2,X-A\u0005e_\u001e+gnQ8eKR\u0019!\u000e];\u0011\u0005-tW\"\u00017\u000b\u00055T\u0012aB2pI\u0016<WM\\\u0005\u0003_2\u0014\u0001\"\u0012=qe\u000e{G-\u001a\u0005\u0006c\u001e\u0001\rA]\u0001\u0004GRD\bCA6t\u0013\t!HN\u0001\bD_\u0012,w-\u001a8D_:$X\r\u001f;\t\u000bY<\u0001\u0019\u00016\u0002\u0005\u00154\u0018\u0001F<ji\"tUm^\"iS2$\u0017J\u001c;fe:\fG\u000e\u0006\u0002Ps\")!\u0010\u0003a\u0001\u0013\u0006Aa.Z<DQ&dG-\u0001\u0003d_BLHCA(~\u0011\u001d9\u0015\u0002%AA\u0002%\u000babY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002\u0002)\u001a\u0011*a\u0001,\u0005\u0005\u0015\u0001\u0003BA\u0004\u0003#i!!!\u0003\u000b\t\u0005-\u0011QB\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\u00049\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003'\tIAA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA\r!\u0011\tY\"!\n\u000e\u0005\u0005u!\u0002BA\u0010\u0003C\tA\u0001\\1oO*\u0011\u00111E\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002(\u0005u!AB*ue&tw-\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002.A\u0019q'a\f\n\u0007\u0005E\u0002HA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000fF\u0002d\u0003oA\u0011\"!\u000f\u000e\u0003\u0003\u0005\r!!\f\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\ty\u0004E\u0003\u0002B\u0005\u001d3-\u0004\u0002\u0002D)\u0019\u0011Q\t\u001d\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002J\u0005\r#\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!a\u0014\u0002VA\u0019q'!\u0015\n\u0007\u0005M\u0003HA\u0004C_>dW-\u00198\t\u0011\u0005er\"!AA\u0002\r\f!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR!\u0011\u0011DA.\u0011%\tI\u0004EA\u0001\u0002\u0004\ti#\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003\u001f\n\t\u0007\u0003\u0005\u0002:E\t\t\u00111\u0001dQM\u0001\u0011QMA6\u0003[\n\t(a\u001d\u0002x\u0005e\u0014QPA@!\rI\u0013qM\u0005\u0004\u0003SR\"!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0003_\n\u0011QR0G+:\u001bu\fK3yaJL\u0003%\f\u0011SKR,(O\\:!i\",\u0007e\u00195be\u0006\u001cG/\u001a:!Y\u0016tw\r\u001e5!_\u001a\u00043\u000f\u001e:j]\u001e\u0004C-\u0019;bA=\u0014\bE\\;nE\u0016\u0014\be\u001c4!Ef$Xm\u001d\u0011pM\u0002\u0012\u0017N\\1ss\u0002\"\u0017\r^1/AQCW\r\t7f]\u001e$\b\u000eI8gAM$(/\u001b8hA\u0011\fG/\u0019\u0011j]\u000edW\u000fZ3tAQDW\r\t;sC&d\u0017N\\4!gB\f7-Z:/AQCW\r\t7f]\u001e$\b\u000eI8gA\tLg.\u0019:zA\u0011\fG/\u0019\u0011j]\u000edW\u000fZ3tA\tLg.\u0019:zAi,'o\\:/\u0003!)\u00070Y7qY\u0016\u001c\u0018EAA;\u0003\u0005m#\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u0014Ta\u0006\u00148\u000eI*R\u0019\u0002:\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00112a)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u00033\tS!S?2+ej\u0012+IQ\u001d\u001a\u0006/\u0019:lAM\u000bF\nI\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001\n\u0004G\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011D\u0011\u0006\u0013\u0016i\u0011+F%~cUIT$U\u0011\":3\u000b]1sW\u0002\u001a\u0016\u000b\u0014\u0011(SmR\u0001\u0005\t\u0011!A\u0001\u0002\u0013\u0007\r\u0006!A\u0005)1/\u001b8dK\u0006\u0012\u00111P\u0001\u0006c9*d\u0006M\u0001\u0006OJ|W\u000f]\u0011\u0003\u0003\u0003\u000bAb\u001d;sS:<wLZ;oGN\fa\u0001T3oORD\u0007CA\u0015\u0014'\u0015\u0019\u0012\u0011RAK!\u0019\tY)!%J\u001f6\u0011\u0011Q\u0012\u0006\u0004\u0003\u001fC\u0014a\u0002:v]RLW.Z\u0005\u0005\u0003'\u000biIA\tBEN$(/Y2u\rVt7\r^5p]F\u0002B!a&\u0002\u001e6\u0011\u0011\u0011\u0014\u0006\u0005\u00037\u000b\t#\u0001\u0002j_&\u0019Q)!'\u0015\u0005\u0005\u0015\u0015\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005e\u0011!B1qa2LHcA(\u0002*\")qI\u0006a\u0001\u0013\u00069QO\\1qa2LH\u0003BAX\u0003k\u0003BaNAY\u0013&\u0019\u00111\u0017\u001d\u0003\r=\u0003H/[8o\u0011!\t9lFA\u0001\u0002\u0004y\u0015a\u0001=%a\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u0011\u0011Q\u0018\t\u0005\u00037\ty,\u0003\u0003\u0002B\u0006u!AB(cU\u0016\u001cG\u000f")
public class Length
extends UnaryExpression
implements ImplicitCastInputTypes,
package.NullIntolerant,
Serializable {
    private final Expression child;

    public static Option<Expression> unapply(Length length) {
        return Length$.MODULE$.unapply(length);
    }

    public static <A> Function1<Expression, A> andThen(Function1<Length, A> function1) {
        return Length$.MODULE$.andThen(function1);
    }

    public static <A$> Function1<A$, Length> compose(Function1<A$, Expression> function1) {
        return Length$.MODULE$.compose(function1);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public DataType dataType() {
        return IntegerType$.MODULE$;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TypeCollection[]{TypeCollection$.MODULE$.apply((Seq<AbstractDataType>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{StringType$.MODULE$, BinaryType$.MODULE$}))}));
    }

    @Override
    public Object nullSafeEval(Object value) {
        Integer n;
        DataType dataType = this.child().dataType();
        if (StringType$.MODULE$.equals(dataType)) {
            n = BoxesRunTime.boxToInteger((int)((UTF8String)value).numChars());
        } else if (BinaryType$.MODULE$.equals(dataType)) {
            n = BoxesRunTime.boxToInteger((int)((byte[])value).length);
        } else {
            throw new MatchError((Object)dataType);
        }
        return n;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode exprCode;
        DataType dataType = this.child().dataType();
        if (StringType$.MODULE$.equals(dataType)) {
            exprCode = this.defineCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable)c -> new StringBuilder(13).append("(").append((String)c).append(").numChars()").toString());
        } else if (BinaryType$.MODULE$.equals(dataType)) {
            exprCode = this.defineCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable)c -> new StringBuilder(9).append("(").append((String)c).append(").length").toString());
        } else {
            throw new MatchError((Object)dataType);
        }
        return exprCode;
    }

    @Override
    public Length withNewChildInternal(Expression newChild) {
        return this.copy(newChild);
    }

    public Length copy(Expression child) {
        return new Length(child);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "Length";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.child();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Length;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "child";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Length)) return false;
        boolean bl = true;
        if (!bl) return false;
        Length length = (Length)x$1;
        Expression expression = this.child();
        Expression expression2 = length.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!length.canEqual(this)) return false;
        return true;
    }

    public Length(Expression child) {
        this.child = child;
        ExpectsInputTypes.$init$(this);
    }
}

