/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Reverse$;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TypeCollection;
import org.apache.spark.sql.types.TypeCollection$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(array) - Returns a reversed string or an array with reverse order of elements.", examples="\n    Examples:\n      > SELECT _FUNC_('Spark SQL');\n       LQS krapS\n      > SELECT _FUNC_(array(2, 1, 4, 3));\n       [3,4,1,2]\n  ", group="collection_funcs", since="1.5.0", note="\n    Reverse logic for arrays is available since 2.4.0.\n  ")
@ScalaSignature(bytes="\u0006\u0005\t%a\u0001B\u000f\u001f\u0001.B\u0001b\u0013\u0001\u0003\u0016\u0004%\t\u0001\u0014\u0005\t!\u0002\u0011\t\u0012)A\u0005\u001b\")\u0011\u000b\u0001C\u0001%\")Q\u000b\u0001C!-\")\u0001\r\u0001C!C\")Q\r\u0001C!M\"AA\u000e\u0001EC\u0002\u0013%Q\u000eC\u0003v\u0001\u0011\u0005c\u000fC\u0004\u0002\n\u0001!I!a\u0003\t\u000f\u0005\r\u0002\u0001\"\u0003\u0002&!9\u0011Q\u0006\u0001\u0005B\u0005=\u0002bBA\u0019\u0001\u0011E\u00131\u0007\u0005\n\u0003s\u0001\u0011\u0011!C\u0001\u0003wA\u0011\"a\u0010\u0001#\u0003%\t!!\u0011\t\u0013\u0005]\u0003!!A\u0005B\u0005e\u0003\"CA5\u0001\u0005\u0005I\u0011AA6\u0011%\t\u0019\bAA\u0001\n\u0003\t)\bC\u0005\u0002|\u0001\t\t\u0011\"\u0011\u0002~!I\u00111\u0012\u0001\u0002\u0002\u0013\u0005\u0011Q\u0012\u0005\n\u0003/\u0003\u0011\u0011!C!\u00033C\u0011\"!(\u0001\u0003\u0003%\t%a(\b\u0013\u0005%g$!A\t\u0002\u0005-g\u0001C\u000f\u001f\u0003\u0003E\t!!4\t\rE;B\u0011AAs\u0011%\t9oFA\u0001\n\u000b\nI\u000fC\u0005\u0002l^\t\t\u0011\"!\u0002n\"I\u0011\u0011_\f\u0002\u0002\u0013\u0005\u00151\u001f\u0005\n\u0003\u007f<\u0012\u0011!C\u0005\u0005\u0003\u0011qAU3wKJ\u001cXM\u0003\u0002 A\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\t\t#%\u0001\u0005dCR\fG._:u\u0015\t\u0019C%A\u0002tc2T!!\n\u0014\u0002\u000bM\u0004\u0018M]6\u000b\u0005\u001dB\u0013AB1qC\u000eDWMC\u0001*\u0003\ry'oZ\u0002\u0001'\u0019\u0001A\u0006M\u001a;\u0001B\u0011QFL\u0007\u0002=%\u0011qF\b\u0002\u0010+:\f'/_#yaJ,7o]5p]B\u0011Q&M\u0005\u0003ey\u0011a#S7qY&\u001c\u0017\u000e^\"bgRLe\u000e];u)f\u0004Xm\u001d\t\u0003i]r!!L\u001b\n\u0005Yr\u0012a\u00029bG.\fw-Z\u0005\u0003qe\u0012aBT;mY&sGo\u001c7fe\u0006tGO\u0003\u00027=A\u00111HP\u0007\u0002y)\tQ(A\u0003tG\u0006d\u0017-\u0003\u0002@y\t9\u0001K]8ek\u000e$\bCA!I\u001d\t\u0011uI\u0004\u0002D\r6\tAI\u0003\u0002FU\u00051AH]8pizJ\u0011!P\u0005\u0003mqJ!!\u0013&\u0003\u0019M+'/[1mSj\f'\r\\3\u000b\u0005Yb\u0014!B2iS2$W#A'\u0011\u00055r\u0015BA(\u001f\u0005))\u0005\u0010\u001d:fgNLwN\\\u0001\u0007G\"LG\u000e\u001a\u0011\u0002\rqJg.\u001b;?)\t\u0019F\u000b\u0005\u0002.\u0001!)1j\u0001a\u0001\u001b\u0006Q\u0011N\u001c9viRK\b/Z:\u0016\u0003]\u00032!\u0011-[\u0013\tI&JA\u0002TKF\u0004\"a\u00170\u000e\u0003qS!!\u0018\u0012\u0002\u000bQL\b/Z:\n\u0005}c&\u0001E!cgR\u0014\u0018m\u0019;ECR\fG+\u001f9f\u0003!!\u0017\r^1UsB,W#\u00012\u0011\u0005m\u001b\u0017B\u00013]\u0005!!\u0015\r^1UsB,\u0017\u0001\u00048vY2\u001c\u0016MZ3Fm\u0006dGCA4k!\tY\u0004.\u0003\u0002jy\t\u0019\u0011I\\=\t\u000b-4\u0001\u0019A4\u0002\u000b%t\u0007/\u001e;\u0002\u0013\u0011|'+\u001a<feN,W#\u00018\u0011\tmzwmZ\u0005\u0003ar\u0012\u0011BR;oGRLwN\\\u0019)\u0005\u001d\u0011\bCA\u001et\u0013\t!HHA\u0005ue\u0006t7/[3oi\u0006IAm\\$f]\u000e{G-\u001a\u000b\u0005ov\f)\u0001\u0005\u0002yw6\t\u0011P\u0003\u0002{=\u000591m\u001c3fO\u0016t\u0017B\u0001?z\u0005!)\u0005\u0010\u001d:D_\u0012,\u0007\"\u0002@\t\u0001\u0004y\u0018aA2uqB\u0019\u00010!\u0001\n\u0007\u0005\r\u0011P\u0001\bD_\u0012,w-\u001a8D_:$X\r\u001f;\t\r\u0005\u001d\u0001\u00021\u0001x\u0003\t)g/A\u0007tiJLgnZ\"pI\u0016<UM\u001c\u000b\u0007\u0003\u001b\ti\"a\b\u0011\t\u0005=\u0011q\u0003\b\u0005\u0003#\t\u0019\u0002\u0005\u0002Dy%\u0019\u0011Q\u0003\u001f\u0002\rA\u0013X\rZ3g\u0013\u0011\tI\"a\u0007\u0003\rM#(/\u001b8h\u0015\r\t)\u0002\u0010\u0005\u0007\u0003\u000fI\u0001\u0019A<\t\u000f\u0005\u0005\u0012\u00021\u0001\u0002\u000e\u0005I1\r[5mI:\u000bW.Z\u0001\rCJ\u0014\u0018-_\"pI\u0016<UM\u001c\u000b\t\u0003\u001b\t9#!\u000b\u0002,!)aP\u0003a\u0001\u007f\"1\u0011q\u0001\u0006A\u0002]Dq!!\t\u000b\u0001\u0004\ti!\u0001\u0006qe\u0016$H/\u001f(b[\u0016,\"!!\u0004\u0002)]LG\u000f\u001b(fo\u000eC\u0017\u000e\u001c3J]R,'O\\1m)\r\u0019\u0016Q\u0007\u0005\u0007\u0003oa\u0001\u0019A'\u0002\u00119,wo\u00115jY\u0012\fAaY8qsR\u00191+!\u0010\t\u000f-k\u0001\u0013!a\u0001\u001b\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA\"U\ri\u0015QI\u0016\u0003\u0003\u000f\u0002B!!\u0013\u0002T5\u0011\u00111\n\u0006\u0005\u0003\u001b\ny%A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011\u000b\u001f\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002V\u0005-#!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006i\u0001O]8ek\u000e$\bK]3gSb,\"!a\u0017\u0011\t\u0005u\u0013qM\u0007\u0003\u0003?RA!!\u0019\u0002d\u0005!A.\u00198h\u0015\t\t)'\u0001\u0003kCZ\f\u0017\u0002BA\r\u0003?\nA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!!\u001c\u0011\u0007m\ny'C\u0002\u0002rq\u00121!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$2aZA<\u0011%\tI(EA\u0001\u0002\u0004\ti'A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003\u007f\u0002R!!!\u0002\b\u001el!!a!\u000b\u0007\u0005\u0015E(\u0001\u0006d_2dWm\u0019;j_:LA!!#\u0002\u0004\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\ty)!&\u0011\u0007m\n\t*C\u0002\u0002\u0014r\u0012qAQ8pY\u0016\fg\u000e\u0003\u0005\u0002zM\t\t\u00111\u0001h\u0003I\u0001(o\u001c3vGR,E.Z7f]Rt\u0015-\\3\u0015\t\u0005m\u00131\u0014\u0005\n\u0003s\"\u0012\u0011!a\u0001\u0003[\na!Z9vC2\u001cH\u0003BAH\u0003CC\u0001\"!\u001f\u0016\u0003\u0003\u0005\ra\u001a\u0015\u0018\u0001\u0005\u0015\u00161VAW\u0003c\u000b\u0019,a.\u0002:\u0006u\u0016qXAb\u0003\u000b\u00042!LAT\u0013\r\tIK\b\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\ty+A+`\rVs5i\u0018\u0015beJ\f\u00170\u000b\u0011.AI+G/\u001e:og\u0002\n\u0007E]3wKJ\u001cX\r\u001a\u0011tiJLgn\u001a\u0011pe\u0002\ng\u000eI1se\u0006L\be^5uQ\u0002\u0012XM^3sg\u0016\u0004sN\u001d3fe\u0002zg\rI3mK6,g\u000e^:/\u0003!)\u00070Y7qY\u0016\u001c\u0018EAA[\u0003\u0005\r!\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u0014Ta\u0006\u00148\u000eI*R\u0019\u001eJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t'R'\u0002Z'/\u00199T\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"\n'O]1zQIb\u0003%\r\u0017!i1\u00023'K\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!Am\u001bD\u0006\u000e\u00172YIj&\u0002\t\u0011\u0002\u000b\u001d\u0014x.\u001e9\"\u0005\u0005m\u0016\u0001E2pY2,7\r^5p]~3WO\\2t\u0003\u0015\u0019\u0018N\\2fC\t\t\t-A\u00032]Ur\u0003'\u0001\u0003o_R,\u0017EAAd\u0003iR\u0001\u0005\t\u0011!%\u00164XM]:fA1|w-[2!M>\u0014\b%\u0019:sCf\u001c\b%[:!CZ\f\u0017\u000e\\1cY\u0016\u00043/\u001b8dK\u0002\u0012d\u0006\u000e\u00181])\u0001\u0003%A\u0004SKZ,'o]3\u0011\u00055:2#B\f\u0002P\u0006m\u0007CBAi\u0003/l5+\u0004\u0002\u0002T*\u0019\u0011Q\u001b\u001f\u0002\u000fI,h\u000e^5nK&!\u0011\u0011\\Aj\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|g.\r\t\u0005\u0003;\f\u0019/\u0004\u0002\u0002`*!\u0011\u0011]A2\u0003\tIw.C\u0002J\u0003?$\"!a3\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!a\u0017\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0007M\u000by\u000fC\u0003L5\u0001\u0007Q*A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005U\u00181 \t\u0005w\u0005]X*C\u0002\u0002zr\u0012aa\u00149uS>t\u0007\u0002CA\u007f7\u0005\u0005\t\u0019A*\u0002\u0007a$\u0003'\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0003\u0004A!\u0011Q\fB\u0003\u0013\u0011\u00119!a\u0018\u0003\r=\u0013'.Z2u\u0001")
public class Reverse
extends UnaryExpression
implements ImplicitCastInputTypes,
package.NullIntolerant,
Serializable {
    private transient Function1<Object, Object> doReverse;
    private final Expression child;
    private volatile transient boolean bitmap$trans$0;

    public static Option<Expression> unapply(Reverse reverse) {
        return Reverse$.MODULE$.unapply(reverse);
    }

    public static <A> Function1<Expression, A> andThen(Function1<Reverse, A> function1) {
        return Reverse$.MODULE$.andThen(function1);
    }

    public static <A$> Function1<A$, Reverse> compose(Function1<A$, Expression> function1) {
        return Reverse$.MODULE$.compose(function1);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TypeCollection[]{TypeCollection$.MODULE$.apply((Seq<AbstractDataType>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{StringType$.MODULE$, ArrayType$.MODULE$}))}));
    }

    @Override
    public DataType dataType() {
        return this.child().dataType();
    }

    @Override
    public Object nullSafeEval(Object input) {
        return this.doReverse().apply(input);
    }

    private Function1<Object, Object> doReverse$lzycompute() {
        Reverse reverse = this;
        synchronized (reverse) {
            if (!this.bitmap$trans$0) {
                Function1 & Serializable intersect;
                DataType dataType = this.dataType();
                if (dataType instanceof ArrayType) {
                    ArrayType arrayType = (ArrayType)dataType;
                    DataType elementType = arrayType.elementType();
                    intersect = (Function1 & Serializable)input -> {
                        ArrayData arrayData = (ArrayData)input;
                        return new GenericArrayData(ArrayOps$.MODULE$.reverse$extension(Predef$.MODULE$.refArrayOps(arrayData.toObjectArray(elementType))));
                    };
                } else if (StringType$.MODULE$.equals(dataType)) {
                    intersect = (Function1 & Serializable)x$19 -> ((UTF8String)x$19).reverse();
                } else {
                    throw new MatchError((Object)dataType);
                }
                this.doReverse = intersect;
                this.bitmap$trans$0 = true;
            }
        }
        return this.doReverse;
    }

    private Function1<Object, Object> doReverse() {
        return !this.bitmap$trans$0 ? this.doReverse$lzycompute() : this.doReverse;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable)c -> {
            String string;
            DataType dataType = this.dataType();
            if (dataType instanceof StringType) {
                string = this.stringCodeGen(ev, (String)c);
            } else if (dataType instanceof ArrayType) {
                string = this.arrayCodeGen(ctx, ev, (String)c);
            } else {
                throw new MatchError((Object)dataType);
            }
            return string;
        });
    }

    private String stringCodeGen(ExprCode ev, String childName) {
        return new StringBuilder(16).append(ev.value()).append(" = (").append(childName).append(").reverse();").toString();
    }

    private String arrayCodeGen(CodegenContext ctx, ExprCode ev, String childName) {
        String numElements = ctx.freshName("numElements");
        String arrayData = ctx.freshName("arrayData");
        String i = ctx.freshName("i");
        String j = ctx.freshName("j");
        DataType elementType = ((ArrayType)this.dataType()).elementType();
        String initialization = CodeGenerator$.MODULE$.createArrayData(arrayData, elementType, numElements, new StringBuilder(9).append(" ").append(this.prettyName()).append(" failed.").toString());
        String assignment = CodeGenerator$.MODULE$.createArrayAssignment(arrayData, elementType, childName, i, j, ((ArrayType)this.dataType()).containsNull());
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(146).append("\n       |final int ").append(numElements).append(" = ").append(childName).append(".numElements();\n       |").append(initialization).append("\n       |for (int ").append(i).append(" = 0; ").append(i).append(" < ").append(numElements).append("; ").append(i).append("++) {\n       |  int ").append(j).append(" = ").append(numElements).append(" - ").append(i).append(" - 1;\n       |  ").append(assignment).append("\n       |}\n       |").append(ev.value()).append(" = ").append(arrayData).append(";\n     ").toString()));
    }

    @Override
    public String prettyName() {
        return "reverse";
    }

    @Override
    public Reverse withNewChildInternal(Expression newChild) {
        return this.copy(newChild);
    }

    public Reverse copy(Expression child) {
        return new Reverse(child);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "Reverse";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.child();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Reverse;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "child";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Reverse)) return false;
        boolean bl = true;
        if (!bl) return false;
        Reverse reverse = (Reverse)x$1;
        Expression expression = this.child();
        Expression expression2 = reverse.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!reverse.canEqual(this)) return false;
        return true;
    }

    public Reverse(Expression child) {
        this.child = child;
        ExpectsInputTypes.$init$(this);
    }
}

