/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.aggregate;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.DecimalPrecision$;
import org.apache.spark.sql.catalyst.analysis.FunctionRegistry$;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.dsl.package$expressions$;
import org.apache.spark.sql.catalyst.expressions.Add;
import org.apache.spark.sql.catalyst.expressions.Add$;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.CheckOverflowInSum;
import org.apache.spark.sql.catalyst.expressions.Divide;
import org.apache.spark.sql.catalyst.expressions.DivideDTInterval;
import org.apache.spark.sql.catalyst.expressions.DivideYMInterval;
import org.apache.spark.sql.catalyst.expressions.EqualTo;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.If;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.aggregate.Average$;
import org.apache.spark.sql.catalyst.expressions.aggregate.DeclarativeAggregate;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.trees.TreePattern$;
import org.apache.spark.sql.catalyst.trees.UnaryLike;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.DayTimeIntervalType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DecimalType$Fixed$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.NumericType$;
import org.apache.spark.sql.types.TypeCollection;
import org.apache.spark.sql.types.TypeCollection$;
import org.apache.spark.sql.types.YearMonthIntervalType;
import org.apache.spark.sql.types.YearMonthIntervalType$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(expr) - Returns the mean calculated from values of a group.", examples="\n    Examples:\n      > SELECT _FUNC_(col) FROM VALUES (1), (2), (3) AS tab(col);\n       2.0\n      > SELECT _FUNC_(col) FROM VALUES (1), (2), (NULL) AS tab(col);\n       1.5\n  ", group="agg_funcs", since="1.0.0")
@ScalaSignature(bytes="\u0006\u0005\tMe\u0001\u0002\u0017.\u0001rB\u0001\u0002\u0019\u0001\u0003\u0016\u0004%\t!\u0019\u0005\tE\u0002\u0011\t\u0012)A\u0005\u0017\"A1\r\u0001BK\u0002\u0013\u0005A\r\u0003\u0005i\u0001\tE\t\u0015!\u0003f\u0011\u0015I\u0007\u0001\"\u0001k\u0011\u0015I\u0007\u0001\"\u0001o\u0011\u0015\u0001\b\u0001\"\u0011r\u0011\u0015Q\b\u0001\"\u0011|\u0011\u001d\tY\u0001\u0001C!\u0003\u001bAa!a\u0007\u0001\t\u0003\"\u0007bBA\u000f\u0001\u0011\u0005\u0013q\u0004\u0005\n\u0003O\u0001!\u0019!C#\u0003SA\u0001\"a\u0015\u0001A\u00035\u00111\u0006\u0005\u000b\u0003+\u0002\u0001R1A\u0005\n\u0005]\u0003BCA:\u0001!\u0015\r\u0011\"\u0003\u0002v!Q\u00111\u0010\u0001\t\u0006\u0004%I!! \t\u0015\u0005\u0015\u0005\u0001#b\u0001\n\u0013\ti\b\u0003\u0006\u0002\b\u0002A)\u0019!C!\u0003\u0013C!\"a'\u0001\u0011\u000b\u0007I\u0011IAO\u0011)\tI\u000b\u0001EC\u0002\u0013\u0005\u00131\u0016\u0005\n\u0003_\u0003\u0001R1A\u0005B\u0005D!\"!-\u0001\u0011\u000b\u0007I\u0011IAZ\u0011\u001d\t9\f\u0001C)\u0003sCq!a0\u0001\t\u0003\n\t\rC\u0005\u0002P\u0002\t\t\u0011\"\u0001\u0002R\"I\u0011q\u001b\u0001\u0012\u0002\u0013\u0005\u0011\u0011\u001c\u0005\n\u0003_\u0004\u0011\u0013!C\u0001\u0003cD\u0011\"!>\u0001\u0003\u0003%\t%a>\t\u0013\t\r\u0001!!A\u0005\u0002\t\u0015\u0001\"\u0003B\u0007\u0001\u0005\u0005I\u0011\u0001B\b\u0011%\u0011)\u0002AA\u0001\n\u0003\u00129\u0002C\u0005\u0003 \u0001\t\t\u0011\"\u0001\u0003\"!I!Q\u0005\u0001\u0002\u0002\u0013\u0005#q\u0005\u0005\n\u0005W\u0001\u0011\u0011!C!\u0005[9\u0011B!\u0015.\u0003\u0003E\tAa\u0015\u0007\u00111j\u0013\u0011!E\u0001\u0005+Ba!\u001b\u0013\u0005\u0002\t\r\u0004\"\u0003B3I\u0005\u0005IQ\tB4\u0011%\u0011I\u0007JA\u0001\n\u0003\u0013Y\u0007C\u0005\u0003r\u0011\n\n\u0011\"\u0001\u0002r\"I!1\u000f\u0013\u0002\u0002\u0013\u0005%Q\u000f\u0005\n\u0005\u000f#\u0013\u0013!C\u0001\u0003cD\u0011B!#%\u0003\u0003%IAa#\u0003\u000f\u00053XM]1hK*\u0011afL\u0001\nC\u001e<'/Z4bi\u0016T!\u0001M\u0019\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003eM\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003iU\n1a]9m\u0015\t1t'A\u0003ta\u0006\u00148N\u0003\u00029s\u00051\u0011\r]1dQ\u0016T\u0011AO\u0001\u0004_J<7\u0001A\n\u0007\u0001u\nUI\u0014+\u0011\u0005yzT\"A\u0017\n\u0005\u0001k#\u0001\u0006#fG2\f'/\u0019;jm\u0016\fum\u001a:fO\u0006$X\r\u0005\u0002C\u00076\tq&\u0003\u0002E_\t1\u0012*\u001c9mS\u000eLGoQ1ti&s\u0007/\u001e;UsB,7\u000fE\u0002G\u0013.k\u0011a\u0012\u0006\u0003\u0011F\nQ\u0001\u001e:fKNL!AS$\u0003\u0013Us\u0017M]=MS.,\u0007C\u0001\"M\u0013\tiuF\u0001\u0006FqB\u0014Xm]:j_:\u0004\"a\u0014*\u000e\u0003AS\u0011!U\u0001\u0006g\u000e\fG.Y\u0005\u0003'B\u0013q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002V;:\u0011ak\u0017\b\u0003/jk\u0011\u0001\u0017\u0006\u00033n\na\u0001\u0010:p_Rt\u0014\"A)\n\u0005q\u0003\u0016a\u00029bG.\fw-Z\u0005\u0003=~\u0013AbU3sS\u0006d\u0017N_1cY\u0016T!\u0001\u0018)\u0002\u000b\rD\u0017\u000e\u001c3\u0016\u0003-\u000baa\u00195jY\u0012\u0004\u0013a\u00034bS2|e.\u0012:s_J,\u0012!\u001a\t\u0003\u001f\u001aL!a\u001a)\u0003\u000f\t{w\u000e\\3b]\u0006aa-Y5m\u001f:,%O]8sA\u00051A(\u001b8jiz\"2a\u001b7n!\tq\u0004\u0001C\u0003a\u000b\u0001\u00071\nC\u0004d\u000bA\u0005\t\u0019A3\u0015\u0005-|\u0007\"\u00021\u0007\u0001\u0004Y\u0015A\u00039sKR$\u0018PT1nKV\t!\u000f\u0005\u0002to:\u0011A/\u001e\t\u0003/BK!A\u001e)\u0002\rA\u0013X\rZ3g\u0013\tA\u0018P\u0001\u0004TiJLgn\u001a\u0006\u0003mB\u000b!\"\u001b8qkR$\u0016\u0010]3t+\u0005a\bcA+~\u007f&\u0011ap\u0018\u0002\u0004'\u0016\f\b\u0003BA\u0001\u0003\u000fi!!a\u0001\u000b\u0007\u0005\u00151'A\u0003usB,7/\u0003\u0003\u0002\n\u0005\r!\u0001E!cgR\u0014\u0018m\u0019;ECR\fG+\u001f9f\u0003M\u0019\u0007.Z2l\u0013:\u0004X\u000f\u001e#bi\u0006$\u0016\u0010]3t)\t\ty\u0001\u0005\u0003\u0002\u0012\u0005]QBAA\n\u0015\r\t)\"M\u0001\tC:\fG._:jg&!\u0011\u0011DA\n\u0005=!\u0016\u0010]3DQ\u0016\u001c7NU3tk2$\u0018\u0001\u00038vY2\f'\r\\3\u0002\u0011\u0011\fG/\u0019+za\u0016,\"!!\t\u0011\t\u0005\u0005\u00111E\u0005\u0005\u0003K\t\u0019A\u0001\u0005ECR\fG+\u001f9f\u00031qw\u000eZ3QCR$XM\u001d8t+\t\tY\u0003\u0005\u0003V{\u00065\u0002\u0003BA\u0018\u0003\u001brA!!\r\u0002J9!\u00111GA$\u001d\u0011\t)$!\u0012\u000f\t\u0005]\u00121\t\b\u0005\u0003s\t\tE\u0004\u0003\u0002<\u0005}bbA,\u0002>%\t!(\u0003\u00029s%\u0011agN\u0005\u0003iUJ!AM\u001a\n\u0005!\u000b\u0014bAA&\u000f\u0006YAK]3f!\u0006$H/\u001a:o\u0013\u0011\ty%!\u0015\u0003\u0017Q\u0013X-\u001a)biR,'O\u001c\u0006\u0004\u0003\u0017:\u0015!\u00048pI\u0016\u0004\u0016\r\u001e;fe:\u001c\b%\u0001\u0006sKN,H\u000e\u001e+za\u0016,\"!!\u0017\u0013\u000f\u0005m\u0013q\f(\u0002f\u00191\u0011Q\f\u0001\u0001\u00033\u0012A\u0002\u0010:fM&tW-\\3oiz\u0002B!!\u0001\u0002b%!\u00111MA\u0002\u0005)\tEo\\7jGRK\b/\u001a\t\u0005\u0003O\n\t(\u0004\u0002\u0002j)!\u00111NA7\u0003\tIwN\u0003\u0002\u0002p\u0005!!.\u0019<b\u0013\rq\u0016\u0011N\u0001\fgVlG)\u0019;b)f\u0004X-\u0006\u0002\u0002xI9\u0011\u0011PA0\u001d\u0006\u0015dABA/\u0001\u0001\t9(A\u0002tk6,\"!a \u0011\u0007\t\u000b\t)C\u0002\u0002\u0004>\u0012!#\u0011;ue&\u0014W\u000f^3SK\u001a,'/\u001a8dK\u0006)1m\\;oi\u0006\u0019\u0012mZ4Ck\u001a4WM]!uiJL'-\u001e;fgV\u0011\u00111\u0012\t\u0007\u0003\u001b\u000b9*a \u000e\u0005\u0005=%\u0002BAI\u0003'\u000b\u0011\"[7nkR\f'\r\\3\u000b\u0007\u0005U\u0005+\u0001\u0006d_2dWm\u0019;j_:LA!!'\u0002\u0010\n!A*[:u\u00035Ig.\u001b;jC24\u0016\r\\;fgV\u0011\u0011q\u0014\t\u0007\u0003\u001b\u000b\t+a)\n\u0007y\fy\tE\u0002C\u0003KK1!a*0\u0005\u001da\u0015\u000e^3sC2\f\u0001#\\3sO\u0016,\u0005\u0010\u001d:fgNLwN\\:\u0016\u0005\u00055\u0006#BAG\u0003C[\u0015AE3wC2,\u0018\r^3FqB\u0014Xm]:j_:\f\u0011#\u001e9eCR,W\t\u001f9sKN\u001c\u0018n\u001c8t+\t\t)\fE\u0002V{.\u000bAc^5uQ:+wo\u00115jY\u0012Le\u000e^3s]\u0006dGcA6\u0002<\"1\u0011QX\fA\u0002-\u000b\u0001B\\3x\u0007\"LG\u000eZ\u0001\u000eM2\fG/\u0011:hk6,g\u000e^:\u0016\u0005\u0005\r\u0007#B+\u0002F\u0006%\u0017bAAd?\nA\u0011\n^3sCR|'\u000fE\u0002P\u0003\u0017L1!!4Q\u0005\r\te._\u0001\u0005G>\u0004\u0018\u0010F\u0003l\u0003'\f)\u000eC\u0004a3A\u0005\t\u0019A&\t\u000f\rL\u0002\u0013!a\u0001K\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAAnU\rY\u0015Q\\\u0016\u0003\u0003?\u0004B!!9\u0002l6\u0011\u00111\u001d\u0006\u0005\u0003K\f9/A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011\u001e)\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002n\u0006\r(!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TCAAzU\r)\u0017Q\\\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005e\b\u0003BA~\u0005\u0003i!!!@\u000b\t\u0005}\u0018QN\u0001\u0005Y\u0006tw-C\u0002y\u0003{\fA\u0002\u001d:pIV\u001cG/\u0011:jif,\"Aa\u0002\u0011\u0007=\u0013I!C\u0002\u0003\fA\u00131!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!!3\u0003\u0012!I!1\u0003\u0010\u0002\u0002\u0003\u0007!qA\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\te\u0001C\u0002B\u000e\u0005;\tI-\u0004\u0002\u0002\u0014&!\u0011qYAJ\u0003!\u0019\u0017M\\#rk\u0006dGcA3\u0003$!I!1\u0003\u0011\u0002\u0002\u0003\u0007\u0011\u0011Z\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0002z\n%\u0002\"\u0003B\nC\u0005\u0005\t\u0019\u0001B\u0004\u0003\u0019)\u0017/^1mgR\u0019QMa\f\t\u0013\tM!%!AA\u0002\u0005%\u0007f\u0005\u0001\u00034\te\"1\bB \u0005\u0003\u0012)Ea\u0012\u0003L\t5\u0003c\u0001\"\u00036%\u0019!qG\u0018\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012!QH\u0001C?\u001a+fjQ0)Kb\u0004(/\u000b\u0011.AI+G/\u001e:og\u0002\"\b.\u001a\u0011nK\u0006t\u0007eY1mGVd\u0017\r^3eA\u0019\u0014x.\u001c\u0011wC2,Xm\u001d\u0011pM\u0002\n\u0007e\u001a:pkBt\u0013\u0001C3yC6\u0004H.Z:\"\u0005\t\r\u0013!!\u0018\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\r|G.\u000b\u0011G%>k\u0005EV!M+\u0016\u001b\u0006\u0005K\u0019*Y\u0001B#'\u000b\u0017!QMJ\u0003%Q*!i\u0006\u0014\u0007fY8mSmR\u0001\u0005\t\u0011!A\u0001\u0002#G\f\u0019\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\r|G.\u000b\u0011G%>k\u0005EV!M+\u0016\u001b\u0006\u0005K\u0019*Y\u0001B#'\u000b\u0017!Q9+F\nT\u0015!\u0003N\u0003C/\u00192)G>d\u0017f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00112]UR\u0001\u0005I\u0001\u0006OJ|W\u000f]\u0011\u0003\u0005\u0013\n\u0011\"Y4h?\u001a,hnY:\u0002\u000bMLgnY3\"\u0005\t=\u0013!B\u0019/a9\u0002\u0014aB!wKJ\fw-\u001a\t\u0003}\u0011\u001aR\u0001\nB,\u0003K\u0002rA!\u0017\u0003`-+7.\u0004\u0002\u0003\\)\u0019!Q\f)\u0002\u000fI,h\u000e^5nK&!!\u0011\rB.\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gN\r\u000b\u0003\u0005'\n\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003s\fQ!\u00199qYf$Ra\u001bB7\u0005_BQ\u0001Y\u0014A\u0002-CqaY\u0014\u0011\u0002\u0003\u0007Q-A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00133\u0003\u001d)h.\u00199qYf$BAa\u001e\u0003\u0004B)qJ!\u001f\u0003~%\u0019!1\u0010)\u0003\r=\u0003H/[8o!\u0015y%qP&f\u0013\r\u0011\t\t\u0015\u0002\u0007)V\u0004H.\u001a\u001a\t\u0011\t\u0015\u0015&!AA\u0002-\f1\u0001\u001f\u00131\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%e\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u0011!Q\u0012\t\u0005\u0003w\u0014y)\u0003\u0003\u0003\u0012\u0006u(AB(cU\u0016\u001cG\u000f")
public class Average
extends DeclarativeAggregate
implements ImplicitCastInputTypes,
UnaryLike<Expression> {
    private AtomicType resultType;
    private AtomicType sumDataType;
    private AttributeReference sum;
    private AttributeReference count;
    private List<AttributeReference> aggBufferAttributes;
    private Seq<Literal> initialValues;
    private Seq<Expression> mergeExpressions;
    private Expression evaluateExpression;
    private Seq<Expression> updateExpressions;
    private final Expression child;
    private final boolean failOnError;
    private final Seq<Enumeration.Value> nodePatterns;
    private transient Seq<Expression> children;
    private volatile transient boolean bitmap$trans$0;
    private volatile int bitmap$0;

    public static boolean $lessinit$greater$default$2() {
        return Average$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple2<Expression, Object>> unapply(Average average) {
        return Average$.MODULE$.unapply(average);
    }

    public static boolean apply$default$2() {
        return Average$.MODULE$.apply$default$2();
    }

    public static Function1<Tuple2<Expression, Object>, Average> tupled() {
        return Average$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Object, Average>> curried() {
        return Average$.MODULE$.curried();
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return UnaryLike.mapChildren$(this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return UnaryLike.withNewChildrenInternal$(this, newChildren);
    }

    private Seq<Expression> children$lzycompute() {
        Average average = this;
        synchronized (average) {
            if (!this.bitmap$trans$0) {
                this.children = UnaryLike.children$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.children;
    }

    @Override
    public final Seq<Expression> children() {
        return !this.bitmap$trans$0 ? this.children$lzycompute() : this.children;
    }

    @Override
    public Expression child() {
        return this.child;
    }

    public boolean failOnError() {
        return this.failOnError;
    }

    @Override
    public String prettyName() {
        return (String)this.getTagValue(FunctionRegistry$.MODULE$.FUNC_ALIAS()).getOrElse((Function0 & Serializable)() -> "avg");
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TypeCollection[]{TypeCollection$.MODULE$.apply((Seq<AbstractDataType>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{NumericType$.MODULE$, YearMonthIntervalType$.MODULE$, DayTimeIntervalType$.MODULE$}))}));
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return TypeUtils$.MODULE$.checkForAnsiIntervalOrNumericType(this.child().dataType(), "average");
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public DataType dataType() {
        return this.resultType();
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private AtomicType resultType$lzycompute() {
        Average average = this;
        synchronized (average) {
            if ((this.bitmap$0 & 1) == 0) {
                AtomicType atomicType;
                DecimalType decimalType;
                Option<Tuple2<Object, Object>> option;
                DataType dataType = this.child().dataType();
                if (dataType instanceof DecimalType && !(option = DecimalType$Fixed$.MODULE$.unapply(decimalType = (DecimalType)dataType)).isEmpty()) {
                    int p = ((Tuple2)option.get())._1$mcI$sp();
                    int s = ((Tuple2)option.get())._2$mcI$sp();
                    atomicType = DecimalType$.MODULE$.bounded(p + 4, s + 4);
                } else {
                    atomicType = dataType instanceof YearMonthIntervalType ? YearMonthIntervalType$.MODULE$.apply() : (dataType instanceof DayTimeIntervalType ? DayTimeIntervalType$.MODULE$.apply() : DoubleType$.MODULE$);
                }
                this.resultType = atomicType;
                this.bitmap$0 |= 1;
            }
        }
        return this.resultType;
    }

    private AtomicType resultType() {
        return (this.bitmap$0 & 1) == 0 ? this.resultType$lzycompute() : this.resultType;
    }

    private AtomicType sumDataType$lzycompute() {
        Average average = this;
        synchronized (average) {
            if ((this.bitmap$0 & 2) == 0) {
                AtomicType atomicType;
                DecimalType decimalType;
                Option<Tuple2<Object, Object>> option;
                DataType dataType = this.child().dataType();
                if (dataType instanceof DecimalType && !(option = DecimalType$Fixed$.MODULE$.unapply(decimalType = (DecimalType)dataType)).isEmpty()) {
                    int p = ((Tuple2)option.get())._1$mcI$sp();
                    int s = ((Tuple2)option.get())._2$mcI$sp();
                    atomicType = DecimalType$.MODULE$.bounded(p + 10, s);
                } else {
                    atomicType = dataType instanceof YearMonthIntervalType ? YearMonthIntervalType$.MODULE$.apply() : (dataType instanceof DayTimeIntervalType ? DayTimeIntervalType$.MODULE$.apply() : DoubleType$.MODULE$);
                }
                this.sumDataType = atomicType;
                this.bitmap$0 |= 2;
            }
        }
        return this.sumDataType;
    }

    private AtomicType sumDataType() {
        return (this.bitmap$0 & 2) == 0 ? this.sumDataType$lzycompute() : this.sumDataType;
    }

    private AttributeReference sum$lzycompute() {
        Average average = this;
        synchronized (average) {
            if ((this.bitmap$0 & 4) == 0) {
                String x$1 = "sum";
                AtomicType x$2 = this.sumDataType();
                boolean x$3 = AttributeReference$.MODULE$.apply$default$3();
                Metadata x$4 = AttributeReference$.MODULE$.apply$default$4();
                ExprId x$5 = AttributeReference$.MODULE$.apply$default$5("sum", x$2, x$3, x$4);
                Seq<String> x$6 = AttributeReference$.MODULE$.apply$default$6("sum", x$2, x$3, x$4);
                this.sum = new AttributeReference("sum", x$2, x$3, x$4, x$5, x$6);
                this.bitmap$0 |= 4;
            }
        }
        return this.sum;
    }

    private AttributeReference sum() {
        return (this.bitmap$0 & 4) == 0 ? this.sum$lzycompute() : this.sum;
    }

    private AttributeReference count$lzycompute() {
        Average average = this;
        synchronized (average) {
            if ((this.bitmap$0 & 8) == 0) {
                String x$1 = "count";
                LongType$ x$2 = LongType$.MODULE$;
                boolean x$3 = AttributeReference$.MODULE$.apply$default$3();
                Metadata x$4 = AttributeReference$.MODULE$.apply$default$4();
                ExprId x$5 = AttributeReference$.MODULE$.apply$default$5("count", x$2, x$3, x$4);
                Seq<String> x$6 = AttributeReference$.MODULE$.apply$default$6("count", x$2, x$3, x$4);
                this.count = new AttributeReference("count", x$2, x$3, x$4, x$5, x$6);
                this.bitmap$0 |= 8;
            }
        }
        return this.count;
    }

    private AttributeReference count() {
        return (this.bitmap$0 & 8) == 0 ? this.count$lzycompute() : this.count;
    }

    private List<AttributeReference> aggBufferAttributes$lzycompute() {
        Average average = this;
        synchronized (average) {
            if ((this.bitmap$0 & 0x10) == 0) {
                AttributeReference attributeReference = this.sum();
                AttributeReference attributeReference2 = this.count();
                this.aggBufferAttributes = package$.MODULE$.Nil().$colon$colon((Object)attributeReference2).$colon$colon((Object)attributeReference);
                this.bitmap$0 |= 0x10;
            }
        }
        return this.aggBufferAttributes;
    }

    public List<AttributeReference> aggBufferAttributes() {
        return (this.bitmap$0 & 0x10) == 0 ? this.aggBufferAttributes$lzycompute() : this.aggBufferAttributes;
    }

    private Seq<Literal> initialValues$lzycompute() {
        Average average = this;
        synchronized (average) {
            if ((this.bitmap$0 & 0x20) == 0) {
                this.initialValues = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Literal[]{Literal$.MODULE$.default(this.sumDataType()), Literal$.MODULE$.apply(BoxesRunTime.boxToLong((long)0L))}));
                this.bitmap$0 |= 0x20;
            }
        }
        return this.initialValues;
    }

    public Seq<Literal> initialValues() {
        return (this.bitmap$0 & 0x20) == 0 ? this.initialValues$lzycompute() : this.initialValues;
    }

    private Seq<Expression> mergeExpressions$lzycompute() {
        Average average = this;
        synchronized (average) {
            if ((this.bitmap$0 & 0x40) == 0) {
                this.mergeExpressions = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package$expressions$.MODULE$.DslExpression(this.RichAttribute(this.sum()).left()).$plus(this.RichAttribute(this.sum()).right()), package$expressions$.MODULE$.DslExpression(this.RichAttribute(this.count()).left()).$plus(this.RichAttribute(this.count()).right())}));
                this.bitmap$0 |= 0x40;
            }
        }
        return this.mergeExpressions;
    }

    @Override
    public Seq<Expression> mergeExpressions() {
        return (this.bitmap$0 & 0x40) == 0 ? this.mergeExpressions$lzycompute() : this.mergeExpressions;
    }

    private Expression evaluateExpression$lzycompute() {
        Average average = this;
        synchronized (average) {
            if ((this.bitmap$0 & 0x80) == 0) {
                DataType dataType = this.child().dataType();
                Expression expression = dataType instanceof DecimalType ? package$expressions$.MODULE$.DslExpression((Expression)DecimalPrecision$.MODULE$.decimalAndDecimal().apply((Object)new Divide(new CheckOverflowInSum(this.sum(), (DecimalType)this.sumDataType(), !this.failOnError()), package$expressions$.MODULE$.DslExpression(this.count()).cast(DecimalType$.MODULE$.LongDecimal()), false))).cast(this.resultType()) : (dataType instanceof YearMonthIntervalType ? new If(new EqualTo(this.count(), Literal$.MODULE$.apply(BoxesRunTime.boxToLong((long)0L))), new Literal(null, YearMonthIntervalType$.MODULE$.apply()), new DivideYMInterval(this.sum(), this.count())) : (dataType instanceof DayTimeIntervalType ? new If(new EqualTo(this.count(), Literal$.MODULE$.apply(BoxesRunTime.boxToLong((long)0L))), new Literal(null, DayTimeIntervalType$.MODULE$.apply()), new DivideDTInterval(this.sum(), this.count())) : new Divide(package$expressions$.MODULE$.DslExpression(this.sum()).cast(this.resultType()), package$expressions$.MODULE$.DslExpression(this.count()).cast(this.resultType()), false)));
                this.evaluateExpression = expression;
                this.bitmap$0 |= 0x80;
            }
        }
        return this.evaluateExpression;
    }

    @Override
    public Expression evaluateExpression() {
        return (this.bitmap$0 & 0x80) == 0 ? this.evaluateExpression$lzycompute() : this.evaluateExpression;
    }

    private Seq<Expression> updateExpressions$lzycompute() {
        Average average = this;
        synchronized (average) {
            if ((this.bitmap$0 & 0x100) == 0) {
                this.updateExpressions = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{new Add(this.sum(), package$expressions$.MODULE$.coalesce((Seq<Expression>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package$expressions$.MODULE$.DslExpression(this.child()).cast(this.sumDataType()), Literal$.MODULE$.default(this.sumDataType())})), Add$.MODULE$.apply$default$3()), new If((Expression)((Object)package$expressions$.MODULE$.DslExpression(this.child()).isNull()), this.count(), package$expressions$.MODULE$.DslExpression(this.count()).$plus(package$expressions$.MODULE$.longToLiteral(1L)))}));
                this.bitmap$0 |= 0x100;
            }
        }
        return this.updateExpressions;
    }

    @Override
    public Seq<Expression> updateExpressions() {
        return (this.bitmap$0 & 0x100) == 0 ? this.updateExpressions$lzycompute() : this.updateExpressions;
    }

    @Override
    public Average withNewChildInternal(Expression newChild) {
        return this.copy(newChild, this.copy$default$2());
    }

    @Override
    public Iterator<Object> flatArguments() {
        return package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{this.child()}));
    }

    public Average copy(Expression child, boolean failOnError) {
        return new Average(child, failOnError);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public boolean copy$default$2() {
        return this.failOnError();
    }

    @Override
    public String productPrefix() {
        return "Average";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.child();
                break;
            }
            case 1: {
                object = BoxesRunTime.boxToBoolean((boolean)this.failOnError());
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Average;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "child";
                break;
            }
            case 1: {
                string = "failOnError";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Average)) return false;
        boolean bl = true;
        if (!bl) return false;
        Average average = (Average)x$1;
        if (this.failOnError() != average.failOnError()) return false;
        Expression expression = this.child();
        Expression expression2 = average.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!average.canEqual(this)) return false;
        return true;
    }

    public Average(Expression child, boolean failOnError) {
        this.child = child;
        this.failOnError = failOnError;
        ExpectsInputTypes.$init$(this);
        UnaryLike.$init$(this);
        this.nodePatterns = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Enumeration.Value[]{TreePattern$.MODULE$.AVERAGE()}));
    }

    public Average(Expression child) {
        this(child, SQLConf$.MODULE$.get().ansiEnabled());
    }
}

