/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAttribute;
import org.apache.spark.sql.catalyst.expressions.ArraysZip$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.catalyst.expressions.LeafExpression;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.NamePlaceholder$;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.trees.TreePattern$;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;

@ExpressionDescription(usage="\n    _FUNC_(a1, a2, ...) - Returns a merged array of structs in which the N-th struct contains all\n    N-th values of input arrays.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(array(1, 2, 3), array(2, 3, 4));\n       [{\"0\":1,\"1\":2},{\"0\":2,\"1\":3},{\"0\":3,\"1\":4}]\n      > SELECT _FUNC_(array(1, 2), array(2, 3), array(3, 4));\n       [{\"0\":1,\"1\":2,\"2\":3},{\"0\":2,\"1\":3,\"2\":4}]\n  ", group="array_funcs", since="2.4.0")
@ScalaSignature(bytes="\u0006\u0005\tuc\u0001\u0002\u0014(\u0001RB\u0001B\u0014\u0001\u0003\u0016\u0004%\ta\u0014\u0005\t'\u0002\u0011\t\u0012)A\u0005!\"AA\u000b\u0001BK\u0002\u0013\u0005q\n\u0003\u0005V\u0001\tE\t\u0015!\u0003Q\u0011\u00151\u0006\u0001\"\u0001X\u0011\u00151\u0006\u0001\"\u0001\\\u0011\u001di\u0006A1A\u0005FyCa!\u001e\u0001!\u0002\u001by\u0006\u0002\u0003<\u0001\u0011\u000b\u0007I\u0011I<\t\u000bm\u0004A\u0011\t?\t\u0015\u0005%\u0001\u0001#b\u0001\n\u0003\nY\u0001\u0003\u0004\u0002\u001c\u0001!\te\u001e\u0005\u000b\u0003;\u0001\u0001R1A\u0005\n\u0005}\u0001bBA\u0019\u0001\u0011%\u00111\u0007\u0005\b\u0003\u000b\u0002A\u0011AA$\u0011\u001d\tI\u0006\u0001C\u0001\u00037Bq!!\u001b\u0001\t\u0003\nY\u0007C\u0004\u0002r\u0001!\t%a\u001d\t\u000f\u0005\u001d\u0005\u0001\"\u0011\u0002\n\"9\u0011\u0011\u0014\u0001\u0005R\u0005m\u0005\"CAT\u0001\u0005\u0005I\u0011AAU\u0011%\ty\u000bAI\u0001\n\u0003\t\t\fC\u0005\u0002H\u0002\t\n\u0011\"\u0001\u00022\"I\u0011\u0011\u001a\u0001\u0002\u0002\u0013\u0005\u00131\u0007\u0005\n\u0003\u0017\u0004\u0011\u0011!C\u0001\u0003\u001bD\u0011\"!6\u0001\u0003\u0003%\t!a6\t\u0013\u0005u\u0007!!A\u0005B\u0005}\u0007\"CAu\u0001\u0005\u0005I\u0011AAv\u0011%\ty\u000fAA\u0001\n\u0003\n\t\u0010C\u0005\u0002v\u0002\t\t\u0011\"\u0011\u0002x\u001e9!1D\u0014\t\u0002\tuaA\u0002\u0014(\u0011\u0003\u0011y\u0002\u0003\u0004WA\u0011\u0005!\u0011\u0007\u0005\b\u0005g\u0001C\u0011\u0001B\u001b\u0011%\u0011\u0019\u0004IA\u0001\n\u0003\u0013I\u0004C\u0005\u0003@\u0001\n\t\u0011\"!\u0003B!I!1\u000b\u0011\u0002\u0002\u0013%!Q\u000b\u0002\n\u0003J\u0014\u0018-_:[SBT!\u0001K\u0015\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003U-\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003Y5\n1a]9m\u0015\tqs&A\u0003ta\u0006\u00148N\u0003\u00021c\u00051\u0011\r]1dQ\u0016T\u0011AM\u0001\u0004_J<7\u0001A\n\u0006\u0001UJDH\u0011\t\u0003m]j\u0011aJ\u0005\u0003q\u001d\u0012!\"\u0012=qe\u0016\u001c8/[8o!\t1$(\u0003\u0002<O\t\tR\t\u001f9fGR\u001c\u0018J\u001c9viRK\b/Z:\u0011\u0005u\u0002U\"\u0001 \u000b\u0003}\nQa]2bY\u0006L!!\u0011 \u0003\u000fA\u0013x\u000eZ;diB\u00111i\u0013\b\u0003\t&s!!\u0012%\u000e\u0003\u0019S!aR\u001a\u0002\rq\u0012xn\u001c;?\u0013\u0005y\u0014B\u0001&?\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001T'\u0003\u0019M+'/[1mSj\f'\r\\3\u000b\u0005)s\u0014\u0001C2iS2$'/\u001a8\u0016\u0003A\u00032aQ)6\u0013\t\u0011VJA\u0002TKF\f\u0011b\u00195jY\u0012\u0014XM\u001c\u0011\u0002\u000b9\fW.Z:\u0002\r9\fW.Z:!\u0003\u0019a\u0014N\\5u}Q\u0019\u0001,\u0017.\u0011\u0005Y\u0002\u0001\"\u0002(\u0006\u0001\u0004\u0001\u0006\"\u0002+\u0006\u0001\u0004\u0001FC\u0001-]\u0011\u0015qe\u00011\u0001Q\u00031qw\u000eZ3QCR$XM\u001d8t+\u0005y\u0006cA\"RAB\u0011\u0011M\u001d\b\u0003E>t!aY7\u000f\u0005\u0011dgBA3l\u001d\t1'N\u0004\u0002hS:\u0011Q\t[\u0005\u0002e%\u0011\u0001'M\u0005\u0003]=J!\u0001L\u0017\n\u0005)Z\u0013B\u00018*\u0003\u0015!(/Z3t\u0013\t\u0001\u0018/A\u0006Ue\u0016,\u0007+\u0019;uKJt'B\u00018*\u0013\t\u0019HOA\u0006Ue\u0016,\u0007+\u0019;uKJt'B\u00019r\u00035qw\u000eZ3QCR$XM\u001d8tA\u0005A!/Z:pYZ,G-F\u0001y!\ti\u00140\u0003\u0002{}\t9!i\\8mK\u0006t\u0017AC5oaV$H+\u001f9fgV\tQ\u0010E\u0002D#z\u00042a`A\u0003\u001b\t\t\tAC\u0002\u0002\u0004-\nQ\u0001^=qKNLA!a\u0002\u0002\u0002\t\u0001\u0012IY:ue\u0006\u001cG\u000fR1uCRK\b/Z\u0001\tI\u0006$\u0018\rV=qKV\u0011\u0011Q\u0002\t\u0004\u007f\u0006=\u0011\u0002BA\t\u0003\u0003\u0011\u0001\u0002R1uCRK\b/\u001a\u0015\u0004\u0017\u0005U\u0001cA\u001f\u0002\u0018%\u0019\u0011\u0011\u0004 \u0003\u0013Q\u0014\u0018M\\:jK:$\u0018\u0001\u00038vY2\f'\r\\3\u0002#\u0005\u0014(/Y=FY\u0016lWM\u001c;UsB,7/\u0006\u0002\u0002\"A1\u00111EA\u0017\u0003\u001bi!!!\n\u000b\t\u0005\u001d\u0012\u0011F\u0001\nS6lW\u000f^1cY\u0016T1!a\u000b?\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0004%\u0006\u0015\u0002fA\u0007\u0002\u0016\u0005\u0001r-\u001a8fe&\u001c\u0017I\u001d:bs\u0012\u000bG/Y\u000b\u0003\u0003k\u0001B!a\u000e\u0002B5\u0011\u0011\u0011\b\u0006\u0005\u0003w\ti$\u0001\u0003mC:<'BAA \u0003\u0011Q\u0017M^1\n\t\u0005\r\u0013\u0011\b\u0002\u0007'R\u0014\u0018N\\4\u0002#\u0015l\u0007\u000f^=J]B,HoR3o\u0007>$W\r\u0006\u0003\u0002J\u0005U\u0003\u0003BA&\u0003#j!!!\u0014\u000b\u0007\u0005=s%A\u0004d_\u0012,w-\u001a8\n\t\u0005M\u0013Q\n\u0002\t\u000bb\u0004(oQ8eK\"9\u0011qK\bA\u0002\u0005%\u0013AA3w\u0003QqwN\\#naRL\u0018J\u001c9vi\u001e+gnQ8eKR1\u0011\u0011JA/\u0003OBq!a\u0018\u0011\u0001\u0004\t\t'A\u0002dib\u0004B!a\u0013\u0002d%!\u0011QMA'\u00059\u0019u\u000eZ3hK:\u001cuN\u001c;fqRDq!a\u0016\u0011\u0001\u0004\tI%A\u0005e_\u001e+gnQ8eKR1\u0011\u0011JA7\u0003_Bq!a\u0018\u0012\u0001\u0004\t\t\u0007C\u0004\u0002XE\u0001\r!!\u0013\u0002\t\u00154\u0018\r\u001c\u000b\u0005\u0003k\nY\bE\u0002>\u0003oJ1!!\u001f?\u0005\r\te.\u001f\u0005\n\u0003{\u0012\u0002\u0013!a\u0001\u0003\u007f\nQ!\u001b8qkR\u0004B!!!\u0002\u00046\t\u0011&C\u0002\u0002\u0006&\u00121\"\u00138uKJt\u0017\r\u001c*po\u0006Q\u0001O]3uift\u0015-\\3\u0016\u0005\u0005-\u0005\u0003BAG\u0003+sA!a$\u0002\u0012B\u0011QIP\u0005\u0004\u0003's\u0014A\u0002)sK\u0012,g-\u0003\u0003\u0002D\u0005]%bAAJ}\u00059r/\u001b;i\u001d\u0016<8\t[5mIJ,g.\u00138uKJt\u0017\r\u001c\u000b\u00041\u0006u\u0005bBAP)\u0001\u0007\u0011\u0011U\u0001\f]\u0016<8\t[5mIJ,g\u000e\u0005\u0003D\u0003G+\u0014bAAS\u001b\nQ\u0011J\u001c3fq\u0016$7+Z9\u0002\t\r|\u0007/\u001f\u000b\u00061\u0006-\u0016Q\u0016\u0005\b\u001dV\u0001\n\u00111\u0001Q\u0011\u001d!V\u0003%AA\u0002A\u000babY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u00024*\u001a\u0001+!.,\u0005\u0005]\u0006\u0003BA]\u0003\u0007l!!a/\u000b\t\u0005u\u0016qX\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!1?\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003\u000b\fYLA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003\u001f\u00042!PAi\u0013\r\t\u0019N\u0010\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003k\nI\u000eC\u0005\u0002\\j\t\t\u00111\u0001\u0002P\u0006\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!!9\u0011\r\u0005\r\u0018Q]A;\u001b\t\tI#\u0003\u0003\u0002h\u0006%\"\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$2\u0001_Aw\u0011%\tY\u000eHA\u0001\u0002\u0004\t)(\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003BA\u001b\u0003gD\u0011\"a7\u001e\u0003\u0003\u0005\r!a4\u0002\r\u0015\fX/\u00197t)\rA\u0018\u0011 \u0005\n\u00037t\u0012\u0011!a\u0001\u0003kB3\u0003AA\u007f\u0005\u0007\u0011)A!\u0003\u0003\f\t=!\u0011\u0003B\u000b\u0005/\u00012ANA\u0000\u0013\r\u0011\ta\n\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\u00119!AA\u0007\u0015\u0001\u0002\u0003\u0005I0G+:\u001bu\fK12Y\u0001\n'\u0007\f\u0011/]9J\u0003%\f\u0011SKR,(O\\:!C\u0002jWM]4fI\u0002\n'O]1zA=4\u0007e\u001d;sk\u000e$8\u000fI5oA]D\u0017n\u00195!i\",\u0007ET\u0017uQ\u0002\u001aHO];di\u0002\u001awN\u001c;bS:\u001c\b%\u00197m\u0015\u0001\u0002\u0003\u0005\t(.i\"\u0004c/\u00197vKN\u0004sN\u001a\u0011j]B,H\u000fI1se\u0006L8O\f\u0006!A\u0005AQ\r_1na2,7/\t\u0002\u0003\u000e\u0005\t)N\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015beJ\f\u0017\u0010K\u0019-AIb\u0003eM\u0015-A\u0005\u0014(/Y=)e1\u00023\u0007\f\u00115S%Z$\u0002\t\u0011!A\u0001\u0002\u0003eW>#a\tR\u0014\u0007\f\u00122Ei\u0012T\u0010L>#a\tR$\u0007\f\u00122Ei\u001aT\u0010L>#a\tR4\u0007\f\u00122Ei\"T0\u0018\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)CJ\u0014\u0018-\u001f\u00152Y\u0001\u0012\u0014\u0006\f\u0011beJ\f\u0017\u0010\u000b\u001a-AMJC\u0006I1se\u0006L\bf\r\u0017!i%J3H\u0003\u0011!A\u0001\u0002\u0003\u0005I.|EA\u0012#(\r\u0017#c\tR$\u0007\f\u00123Ei\u001aT\u0010L>#a\tR$\u0007\f\u00122Ei\u001aDF\t\u001a#uQjXL\u0003\u0011!\u0003\u00159'o\\;qC\t\u0011\u0019\"A\u0006beJ\f\u0017p\u00184v]\u000e\u001c\u0018!B:j]\u000e,\u0017E\u0001B\r\u0003\u0015\u0011d\u0006\u000e\u00181\u0003%\t%O]1zgjK\u0007\u000f\u0005\u00027AM)\u0001E!\t\u0003(A\u0019QHa\t\n\u0007\t\u0015bH\u0001\u0004B]f\u0014VM\u001a\t\u0005\u0005S\u0011y#\u0004\u0002\u0003,)!!QFA\u001f\u0003\tIw.C\u0002M\u0005W!\"A!\b\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0007a\u00139\u0004C\u0003OE\u0001\u0007\u0001\u000bF\u0003Y\u0005w\u0011i\u0004C\u0003OG\u0001\u0007\u0001\u000bC\u0003UG\u0001\u0007\u0001+A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\t\r#q\n\t\u0006{\t\u0015#\u0011J\u0005\u0004\u0005\u000fr$AB(qi&|g\u000eE\u0003>\u0005\u0017\u0002\u0006+C\u0002\u0003Ny\u0012a\u0001V;qY\u0016\u0014\u0004\u0002\u0003B)I\u0005\u0005\t\u0019\u0001-\u0002\u0007a$\u0003'\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0003XA!\u0011q\u0007B-\u0013\u0011\u0011Y&!\u000f\u0003\r=\u0013'.Z2u\u0001")
public class ArraysZip
extends Expression
implements ExpectsInputTypes,
Serializable {
    private boolean resolved;
    private transient DataType dataType;
    private transient Seq<DataType> arrayElementTypes;
    private final Seq<Expression> children;
    private final Seq<Expression> names;
    private final Seq<Enumeration.Value> nodePatterns;
    private volatile transient byte bitmap$trans$0;
    private volatile boolean bitmap$0;

    public static Option<Tuple2<Seq<Expression>, Seq<Expression>>> unapply(ArraysZip arraysZip) {
        return ArraysZip$.MODULE$.unapply(arraysZip);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Seq<Expression> children() {
        return this.children;
    }

    public Seq<Expression> names() {
        return this.names;
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private boolean resolved$lzycompute() {
        ArraysZip arraysZip = this;
        synchronized (arraysZip) {
            if (!this.bitmap$0) {
                this.resolved = this.childrenResolved() && this.checkInputDataTypes().isSuccess() && this.names().forall((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.resolved()));
                this.bitmap$0 = true;
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        return !this.bitmap$0 ? this.resolved$lzycompute() : this.resolved;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)package$.MODULE$.Seq().fill(this.children().length(), (Function0 & Serializable)() -> ArrayType$.MODULE$);
    }

    private DataType dataType$lzycompute() {
        ArraysZip arraysZip = this;
        synchronized (arraysZip) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                Seq fields = (Seq)((IterableOps)this.arrayElementTypes().zip(this.names())).map((Function1 & Serializable)x0$1 -> {
                    Object name;
                    DataType elementType;
                    block3: {
                        Tuple2 tuple2;
                        block2: {
                            tuple2 = x0$1;
                            if (tuple2 == null) break block2;
                            elementType = (DataType)tuple2._1();
                            Expression expression = (Expression)tuple2._2();
                            if (!(expression instanceof Literal)) break block2;
                            Literal literal = (Literal)expression;
                            name = literal.value();
                            DataType dataType = literal.dataType();
                            if (StringType$.MODULE$.equals(dataType)) break block3;
                        }
                        throw new MatchError((Object)tuple2);
                    }
                    StructField structField = new StructField(name.toString(), elementType, true, StructField$.MODULE$.apply$default$4());
                    return structField;
                });
                this.dataType = new ArrayType(StructType$.MODULE$.apply((Seq<StructField>)fields), false);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.dataType;
    }

    @Override
    public DataType dataType() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.dataType$lzycompute() : this.dataType;
    }

    @Override
    public boolean nullable() {
        return this.children().exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.nullable()));
    }

    private Seq<DataType> arrayElementTypes$lzycompute() {
        ArraysZip arraysZip = this;
        synchronized (arraysZip) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.arrayElementTypes = (Seq)this.children().map((Function1 & Serializable)x$3 -> ((ArrayType)x$3.dataType()).elementType());
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.arrayElementTypes;
    }

    private Seq<DataType> arrayElementTypes() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.arrayElementTypes$lzycompute() : this.arrayElementTypes;
    }

    private String genericArrayData() {
        return GenericArrayData.class.getName();
    }

    public ExprCode emptyInputGenCode(ExprCode ev) {
        return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n      |", " ", " = new ", "(new Object[0]);\n      |boolean ", " = false;\n    "}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), this.genericArrayData(), ev.isNull()})).stripMargin(), ev.copy$default$2(), ev.copy$default$3());
    }

    public ExprCode nonEmptyInputGenCode(CodegenContext ctx, ExprCode ev) {
        Seq getValuesAndCardinalities;
        String genericInternalRow = GenericInternalRow.class.getName();
        String arrVals = ctx.freshName("arrVals");
        String biggestCardinality = ctx.freshName("biggestCardinality");
        String currentRow = ctx.freshName("currentRow");
        String j = ctx.freshName("j");
        String i = ctx.freshName("i");
        String args = ctx.freshName("args");
        Seq evals = (Seq)this.children().map((Function1 & Serializable)x$4 -> x$4.genCode(ctx));
        Seq x$1 = getValuesAndCardinalities = (Seq)((IterableOps)evals.zipWithIndex()).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            ExprCode eval = (ExprCode)tuple2._1();
            int index = tuple2._2$mcI$sp();
            String string = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(190).append("\n        |if (").append(biggestCardinality).append(" != -1) {\n        |  ").append(eval.code()).append("\n        |  if (!").append(eval.isNull()).append(") {\n        |    ").append(arrVals).append("[").append(index).append("] = ").append(eval.value()).append(";\n        |    ").append(biggestCardinality).append(" = Math.max(").append(biggestCardinality).append(", ").append(eval.value()).append(".numElements());\n        |  } else {\n        |    ").append(biggestCardinality).append(" = -1;\n        |  }\n        |}\n      ").toString()));
            return string;
        });
        String x$2 = "getValuesAndCardinalities";
        String x$3 = "int";
        Function1 & Serializable x$42 = (Function1 & Serializable)body -> StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(41).append("\n          |").append((String)body).append("\n          |return ").append(biggestCardinality).append(";\n        ").toString()));
        Function1 & Serializable x$52 = (Function1 & Serializable)x$5 -> ((IterableOnceOps)x$5.map((Function1 & Serializable)funcCall -> new StringBuilder(4).append(biggestCardinality).append(" = ").append((String)funcCall).append(";").toString())).mkString("\n");
        Tuple2 tuple2 = new Tuple2((Object)"ArrayData[]", (Object)arrVals);
        Tuple2 tuple22 = new Tuple2((Object)"int", (Object)biggestCardinality);
        List x$6 = package$.MODULE$.Nil().$colon$colon((Object)tuple22).$colon$colon((Object)tuple2);
        String splittedGetValuesAndCardinalities = ctx.splitExpressionsWithCurrentInputs((Seq<String>)x$1, "getValuesAndCardinalities", (Seq<Tuple2<String, String>>)x$6, "int", (Function1<String, String>)x$42, (Function1<Seq<String>, String>)x$52);
        Seq getValueForType = (Seq)((IterableOps)this.arrayElementTypes().zipWithIndex()).map((Function1 & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            DataType eleType = (DataType)tuple2._1();
            int idx = tuple2._2$mcI$sp();
            String g = CodeGenerator$.MODULE$.getValue(new StringBuilder(2).append(arrVals).append("[").append(idx).append("]").toString(), eleType, i);
            String string = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(130).append("\n        |if (").append(i).append(" < ").append(arrVals).append("[").append(idx).append("].numElements() && !").append(arrVals).append("[").append(idx).append("].isNullAt(").append(i).append(")) {\n        |  ").append(currentRow).append("[").append(idx).append("] = ").append(g).append(";\n        |} else {\n        |  ").append(currentRow).append("[").append(idx).append("] = null;\n        |}\n      ").toString()));
            return string;
        });
        Tuple2 tuple23 = new Tuple2((Object)"int", (Object)i);
        Tuple2 tuple24 = new Tuple2((Object)"Object[]", (Object)currentRow);
        Tuple2 tuple25 = new Tuple2((Object)"ArrayData[]", (Object)arrVals);
        String getValueForTypeSplitted = ctx.splitExpressions((Seq<String>)getValueForType, "extractValue", (Seq<Tuple2<String, String>>)package$.MODULE$.Nil().$colon$colon((Object)tuple25).$colon$colon((Object)tuple24).$colon$colon((Object)tuple23), ctx.splitExpressions$default$4(), ctx.splitExpressions$default$5(), ctx.splitExpressions$default$6());
        String initVariables = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(78).append("\n      |ArrayData[] ").append(arrVals).append(" = new ArrayData[").append(this.children().length()).append("];\n      |int ").append(biggestCardinality).append(" = 0;\n      |").append(CodeGenerator$.MODULE$.javaType(this.dataType())).append(" ").append(ev.value()).append(" = null;\n    ").toString()));
        return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n      |", "\n      |", "\n      |boolean ", " = ", " == -1;\n      |if (!", ") {\n      |  Object[] ", " = new Object[", "];\n      |  for (int ", " = 0; ", " < ", "; ", " ++) {\n      |    Object[] ", " = new Object[", "];\n      |    ", "\n      |    ", "[", "] = new ", "(", ");\n      |  }\n      |  ", " = new ", "(", ");\n      |}\n    "}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{initVariables, splittedGetValuesAndCardinalities, ev.isNull(), biggestCardinality, ev.isNull(), args, biggestCardinality, i, i, biggestCardinality, i, currentRow, BoxesRunTime.boxToInteger((int)this.children().length()), getValueForTypeSplitted, args, i, genericInternalRow, currentRow, ev.value(), this.genericArrayData(), args})).stripMargin(), ev.copy$default$2(), ev.copy$default$3());
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.children().isEmpty() ? this.emptyInputGenCode(ev) : this.nonEmptyInputGenCode(ctx, ev);
    }

    @Override
    public Object eval(InternalRow input) {
        GenericArrayData genericArrayData;
        Seq inputArrays = (Seq)this.children().map((Function1 & Serializable)x$6 -> (ArrayData)x$6.eval(input));
        if (inputArrays.contains(null)) {
            genericArrayData = null;
        } else {
            int biggestCardinality = inputArrays.isEmpty() ? 0 : BoxesRunTime.unboxToInt((Object)((IterableOnceOps)inputArrays.map((Function1 & Serializable)x$7 -> BoxesRunTime.boxToInteger((int)x$7.numElements()))).max((Ordering)Ordering.Int$.MODULE$));
            InternalRow[] result = new InternalRow[biggestCardinality];
            Seq zippedArrs = (Seq)inputArrays.zipWithIndex();
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), biggestCardinality).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                Seq currentLayer = (Seq)zippedArrs.map((Function1 & Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    ArrayData arr = (ArrayData)tuple2._1();
                    int index = tuple2._2$mcI$sp();
                    Object object = i < arr.numElements() && !arr.isNullAt(i) ? arr.get(i, (DataType)this.arrayElementTypes().apply(index)) : null;
                    return object;
                });
                result$1[i] = InternalRow$.MODULE$.apply((Seq<Object>)currentLayer);
            });
            genericArrayData = new GenericArrayData((Object)result);
        }
        return genericArrayData;
    }

    @Override
    public String prettyName() {
        return "arrays_zip";
    }

    @Override
    public ArraysZip withNewChildrenInternal(IndexedSeq<Expression> newChildren) {
        return this.copy((Seq<Expression>)newChildren, this.copy$default$2());
    }

    public ArraysZip copy(Seq<Expression> children2, Seq<Expression> names) {
        return new ArraysZip(children2, names);
    }

    public Seq<Expression> copy$default$1() {
        return this.children();
    }

    public Seq<Expression> copy$default$2() {
        return this.names();
    }

    @Override
    public String productPrefix() {
        return "ArraysZip";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.children();
                break;
            }
            case 1: {
                object = this.names();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ArraysZip;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "children";
                break;
            }
            case 1: {
                string = "names";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ArraysZip)) return false;
        boolean bl = true;
        if (!bl) return false;
        ArraysZip arraysZip = (ArraysZip)x$1;
        Seq<Expression> seq = this.children();
        Seq<Expression> seq2 = arraysZip.children();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        Seq<Expression> seq3 = this.names();
        Seq<Expression> seq4 = arraysZip.names();
        if (seq3 == null) {
            if (seq4 != null) {
                return false;
            }
        } else if (!seq3.equals(seq4)) return false;
        if (!arraysZip.canEqual(this)) return false;
        return true;
    }

    public ArraysZip(Seq<Expression> children2, Seq<Expression> names) {
        this.children = children2;
        this.names = names;
        ExpectsInputTypes.$init$(this);
        if (children2.size() != names.size()) {
            throw new IllegalArgumentException("The numbers of zipped arrays and field names should be the same");
        }
        this.nodePatterns = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Enumeration.Value[]{TreePattern$.MODULE$.ARRAYS_ZIP()}));
    }

    public ArraysZip(Seq<Expression> children2) {
        this(children2, (Seq<Expression>)((Seq)((IterableOps)children2.zipWithIndex()).map((Function1)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final Expression apply(Tuple2<Expression, Object> x0$1) {
                Expression e;
                NamedExpression namedExpression;
                Expression e2;
                LeafExpression leafExpression;
                Expression u;
                Tuple2<Expression, Object> tuple2 = x0$1;
                if (tuple2 != null && (u = (Expression)tuple2._1()) instanceof UnresolvedAttribute) {
                    UnresolvedAttribute unresolvedAttribute = (UnresolvedAttribute)u;
                    leafExpression = Literal$.MODULE$.apply(unresolvedAttribute.nameParts().last());
                } else if (tuple2 != null && (e2 = (Expression)tuple2._1()) instanceof NamedExpression && ((Expression)((Object)(namedExpression = (NamedExpression)((Object)e2)))).resolved()) {
                    leafExpression = Literal$.MODULE$.apply(namedExpression.name());
                } else if (tuple2 != null && (e = (Expression)tuple2._1()) instanceof NamedExpression) {
                    leafExpression = NamePlaceholder$.MODULE$;
                } else if (tuple2 != null) {
                    int idx = tuple2._2$mcI$sp();
                    leafExpression = Literal$.MODULE$.apply(Integer.toString(idx));
                } else {
                    throw new MatchError(tuple2);
                }
                return leafExpression;
            }
        })));
    }
}

