/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCoercion$;
import org.apache.spark.sql.catalyst.expressions.CreateMap$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.GenArrayData$;
import org.apache.spark.sql.catalyst.expressions.NoThrow;
import org.apache.spark.sql.catalyst.expressions.codegen.Block;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.FalseLiteral$;
import org.apache.spark.sql.catalyst.util.ArrayBasedMapBuilder;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.StringType$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Product;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IndexedSeqOps;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;

@ExpressionDescription(usage="_FUNC_(key0, value0, key1, value1, ...) - Creates a map with the given key/value pairs.", examples="\n    Examples:\n      > SELECT _FUNC_(1.0, '2', 3.0, '4');\n       {1.0:\"2\",3.0:\"4\"}\n  ", since="2.0.0", group="map_funcs")
@ScalaSignature(bytes="\u0006\u0005\t}b\u0001\u0002\u0014(\u0001RB\u0001B\u0014\u0001\u0003\u0016\u0004%\ta\u0014\u0005\t'\u0002\u0011\t\u0012)A\u0005!\"AA\u000b\u0001BK\u0002\u0013\u0005Q\u000b\u0003\u0005Z\u0001\tE\t\u0015!\u0003W\u0011\u0015Q\u0006\u0001\"\u0001\\\u0011\u0015Q\u0006\u0001\"\u0001`\u0011!\t\u0007\u0001#b\u0001\n\u0003\u0011\u0007\u0002C6\u0001\u0011\u000b\u0007I\u0011\u00012\t\u000f1\u0004!\u0019!C\u0005[\"1A\u000f\u0001Q\u0001\n9DQ!\u001e\u0001\u0005BUCQA\u001e\u0001\u0005B]DQA \u0001\u0005B}D!\"!\u0004\u0001\u0011\u000b\u0007I\u0011IA\b\u0011\u0019\t9\u0002\u0001C!+\"Q\u0011\u0011\u0004\u0001\t\u0006\u0004%I!a\u0007\t\u000f\u0005%\u0002\u0001\"\u0011\u0002,!9\u0011\u0011\b\u0001\u0005B\u0005m\u0002bBA,\u0001\u0011\u0005\u0013\u0011\f\u0005\b\u0003W\u0002A\u0011KA7\u0011%\t9\bAA\u0001\n\u0003\tI\bC\u0005\u0002\u0000\u0001\t\n\u0011\"\u0001\u0002\u0002\"I\u0011q\u0013\u0001\u0012\u0002\u0013\u0005\u0011\u0011\u0014\u0005\n\u0003;\u0003\u0011\u0011!C!\u0003?C\u0011\"a,\u0001\u0003\u0003%\t!!-\t\u0013\u0005e\u0006!!A\u0005\u0002\u0005m\u0006\"CAa\u0001\u0005\u0005I\u0011IAb\u0011%\tY\rAA\u0001\n\u0003\ti\rC\u0005\u0002R\u0002\t\t\u0011\"\u0011\u0002T\"I\u0011q\u001b\u0001\u0002\u0002\u0013\u0005\u0013\u0011\\\u0004\b\u0003{<\u0003\u0012AA\u0000\r\u00191s\u0005#\u0001\u0003\u0002!1!\f\tC\u0001\u0005'AqA!\u0006!\t\u0003\u00119\u0002C\u0005\u0003\u0016\u0001\n\t\u0011\"!\u0003\u001c!I!\u0011\u0005\u0011\u0002\u0002\u0013\u0005%1\u0005\u0005\n\u0005k\u0001\u0013\u0011!C\u0005\u0005o\u0011\u0011b\u0011:fCR,W*\u00199\u000b\u0005!J\u0013aC3yaJ,7o]5p]NT!AK\u0016\u0002\u0011\r\fG/\u00197zgRT!\u0001L\u0017\u0002\u0007M\fHN\u0003\u0002/_\u0005)1\u000f]1sW*\u0011\u0001'M\u0001\u0007CB\f7\r[3\u000b\u0003I\n1a\u001c:h\u0007\u0001\u0019R\u0001A\u001b:y\t\u0003\"AN\u001c\u000e\u0003\u001dJ!\u0001O\u0014\u0003\u0015\u0015C\bO]3tg&|g\u000e\u0005\u00027u%\u00111h\n\u0002\b\u001d>$\u0006N]8x!\ti\u0004)D\u0001?\u0015\u0005y\u0014!B:dC2\f\u0017BA!?\u0005\u001d\u0001&o\u001c3vGR\u0004\"aQ&\u000f\u0005\u0011KeBA#I\u001b\u00051%BA$4\u0003\u0019a$o\\8u}%\tq(\u0003\u0002K}\u00059\u0001/Y2lC\u001e,\u0017B\u0001'N\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\tQe(\u0001\u0005dQ&dGM]3o+\u0005\u0001\u0006cA\"Rk%\u0011!+\u0014\u0002\u0004'\u0016\f\u0018!C2iS2$'/\u001a8!\u0003Y)8/Z*ue&tw\rV=qK^CWM\\#naRLX#\u0001,\u0011\u0005u:\u0016B\u0001-?\u0005\u001d\u0011un\u001c7fC:\fq#^:f'R\u0014\u0018N\\4UsB,w\u000b[3o\u000b6\u0004H/\u001f\u0011\u0002\rqJg.\u001b;?)\raVL\u0018\t\u0003m\u0001AQAT\u0003A\u0002ACQ\u0001V\u0003A\u0002Y#\"\u0001\u00181\t\u000b93\u0001\u0019\u0001)\u0002\t-,\u0017p]\u000b\u0002GB\u0019A-[\u001b\u000e\u0003\u0015T!AZ4\u0002\u0013%lW.\u001e;bE2,'B\u00015?\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003U\u0016\u0014!\"\u00138eKb,GmU3r\u0003\u00191\u0018\r\\;fg\u0006\u0011B-\u001a4bk2$X\t\\3nK:$H+\u001f9f+\u0005q\u0007CA8s\u001b\u0005\u0001(BA9,\u0003\u0015!\u0018\u0010]3t\u0013\t\u0019\bO\u0001\u0005ECR\fG+\u001f9f\u0003M!WMZ1vYR,E.Z7f]R$\u0016\u0010]3!\u0003!1w\u000e\u001c3bE2,\u0017AC:ue&tw-\u0011:hgV\t\u0001\u0010E\u0002DsnL!A_'\u0003\u0011%#XM]1u_J\u0004\"!\u0010?\n\u0005ut$aA!os\u0006\u00192\r[3dW&s\u0007/\u001e;ECR\fG+\u001f9fgR\u0011\u0011\u0011\u0001\t\u0005\u0003\u0007\tI!\u0004\u0002\u0002\u0006)\u0019\u0011qA\u0015\u0002\u0011\u0005t\u0017\r\\=tSNLA!a\u0003\u0002\u0006\tyA+\u001f9f\u0007\",7m\u001b*fgVdG/\u0001\u0005eCR\fG+\u001f9f+\t\t\t\u0002E\u0002p\u0003'I1!!\u0006q\u0005\u001di\u0015\r\u001d+za\u0016\f\u0001B\\;mY\u0006\u0014G.Z\u0001\u000b[\u0006\u0004()^5mI\u0016\u0014XCAA\u000f!\u0011\ty\"!\n\u000e\u0005\u0005\u0005\"bAA\u0012S\u0005!Q\u000f^5m\u0013\u0011\t9#!\t\u0003)\u0005\u0013(/Y=CCN,G-T1q\u0005VLG\u000eZ3s\u0003\u0011)g/\u00197\u0015\u0007m\fi\u0003C\u0005\u00020E\u0001\n\u00111\u0001\u00022\u0005)\u0011N\u001c9viB!\u00111GA\u001b\u001b\u0005I\u0013bAA\u001cS\tY\u0011J\u001c;fe:\fGNU8x\u0003%!wnR3o\u0007>$W\r\u0006\u0004\u0002>\u0005%\u00131\u000b\t\u0005\u0003\u007f\t)%\u0004\u0002\u0002B)\u0019\u00111I\u0014\u0002\u000f\r|G-Z4f]&!\u0011qIA!\u0005!)\u0005\u0010\u001d:D_\u0012,\u0007bBA&%\u0001\u0007\u0011QJ\u0001\u0004GRD\b\u0003BA \u0003\u001fJA!!\u0015\u0002B\tq1i\u001c3fO\u0016t7i\u001c8uKb$\bbBA+%\u0001\u0007\u0011QH\u0001\u0003KZ\f!\u0002\u001d:fiRLh*Y7f+\t\tY\u0006\u0005\u0003\u0002^\u0005\u0015d\u0002BA0\u0003C\u0002\"!\u0012 \n\u0007\u0005\rd(\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003O\nIG\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003Gr\u0014aF<ji\"tUm^\"iS2$'/\u001a8J]R,'O\\1m)\ra\u0016q\u000e\u0005\b\u0003c\"\u0002\u0019AA:\u0003-qWm^\"iS2$'/\u001a8\u0011\t\r\u000b)(N\u0005\u0003U6\u000bAaY8qsR)A,a\u001f\u0002~!9a*\u0006I\u0001\u0002\u0004\u0001\u0006b\u0002+\u0016!\u0003\u0005\rAV\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\t\u0019IK\u0002Q\u0003\u000b[#!a\"\u0011\t\u0005%\u00151S\u0007\u0003\u0003\u0017SA!!$\u0002\u0010\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003#s\u0014AC1o]>$\u0018\r^5p]&!\u0011QSAF\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\tYJK\u0002W\u0003\u000b\u000bQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAAQ!\u0011\t\u0019+!,\u000e\u0005\u0005\u0015&\u0002BAT\u0003S\u000bA\u0001\\1oO*\u0011\u00111V\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002h\u0005\u0015\u0016\u0001\u00049s_\u0012,8\r^!sSRLXCAAZ!\ri\u0014QW\u0005\u0004\u0003os$aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$HcA>\u0002>\"I\u0011q\u0018\u000e\u0002\u0002\u0003\u0007\u00111W\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005\u0015\u0007#BAd\u0003\u0013\\X\"A4\n\u0005i<\u0017\u0001C2b]\u0016\u000bX/\u00197\u0015\u0007Y\u000by\r\u0003\u0005\u0002@r\t\t\u00111\u0001|\u0003I\u0001(o\u001c3vGR,E.Z7f]Rt\u0015-\\3\u0015\t\u0005\u0005\u0016Q\u001b\u0005\n\u0003\u007fk\u0012\u0011!a\u0001\u0003g\u000ba!Z9vC2\u001cHc\u0001,\u0002\\\"A\u0011q\u0018\u0010\u0002\u0002\u0003\u00071\u0010K\n\u0001\u0003?\f)/a:\u0002l\u00065\u0018\u0011_Az\u0003o\fI\u0010E\u00027\u0003CL1!a9(\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#!!;\u0002/~3UKT\"`Q-,\u0017\u0010\r\u0017!m\u0006dW/\u001a\u0019-A-,\u00170\r\u0017!m\u0006dW/Z\u0019-A9rc&\u000b\u0011.A\r\u0013X-\u0019;fg\u0002\n\u0007%\\1qA]LG\u000f\u001b\u0011uQ\u0016\u0004s-\u001b<f]\u0002ZW-_\u0018wC2,X\r\t9bSJ\u001ch&\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\ty/A+\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`QEr\u0003\u0007\f\u0011(e\u001db\u0003e\r\u00181Y\u0001:CgJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!Am\fd\u0006\r\u001e#e\tb3G\f\u0019;EQ\u0012SP\u0003\u0011!\u0003\u0015\u0019\u0018N\\2fC\t\t)0A\u00033]Ar\u0003'A\u0003he>,\b/\t\u0002\u0002|\u0006IQ.\u00199`MVt7m]\u0001\n\u0007J,\u0017\r^3NCB\u0004\"A\u000e\u0011\u0014\u000b\u0001\u0012\u0019A!\u0003\u0011\u0007u\u0012)!C\u0002\u0003\by\u0012a!\u00118z%\u00164\u0007\u0003\u0002B\u0006\u0005#i!A!\u0004\u000b\t\t=\u0011\u0011V\u0001\u0003S>L1\u0001\u0014B\u0007)\t\ty0A\u0003baBd\u0017\u0010F\u0002]\u00053AQA\u0014\u0012A\u0002A#R\u0001\u0018B\u000f\u0005?AQAT\u0012A\u0002ACQ\u0001V\u0012A\u0002Y\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003&\tE\u0002#B\u001f\u0003(\t-\u0012b\u0001B\u0015}\t1q\n\u001d;j_:\u0004R!\u0010B\u0017!ZK1Aa\f?\u0005\u0019!V\u000f\u001d7fe!A!1\u0007\u0013\u0002\u0002\u0003\u0007A,A\u0002yIA\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"A!\u000f\u0011\t\u0005\r&1H\u0005\u0005\u0005{\t)K\u0001\u0004PE*,7\r\u001e")
public class CreateMap
extends Expression
implements NoThrow,
Serializable {
    private IndexedSeq<Expression> keys;
    private IndexedSeq<Expression> values;
    private MapType dataType;
    private ArrayBasedMapBuilder mapBuilder;
    private final Seq<Expression> children;
    private final boolean useStringTypeWhenEmpty;
    private final DataType defaultElementType;
    private volatile byte bitmap$0;

    public static Option<Tuple2<Seq<Expression>, Object>> unapply(CreateMap createMap) {
        return CreateMap$.MODULE$.unapply(createMap);
    }

    @Override
    public Seq<Expression> children() {
        return this.children;
    }

    public boolean useStringTypeWhenEmpty() {
        return this.useStringTypeWhenEmpty;
    }

    private IndexedSeq<Expression> keys$lzycompute() {
        CreateMap createMap = this;
        synchronized (createMap) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.keys = (IndexedSeq)((IndexedSeqOps)this.children().indices().filter((Function1)(JFunction1.mcZI.sp & Serializable)x$7 -> x$7 % 2 == 0)).map(this.children());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.keys;
    }

    public IndexedSeq<Expression> keys() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.keys$lzycompute() : this.keys;
    }

    private IndexedSeq<Expression> values$lzycompute() {
        CreateMap createMap = this;
        synchronized (createMap) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.values = (IndexedSeq)((IndexedSeqOps)this.children().indices().filter((Function1)(JFunction1.mcZI.sp & Serializable)x$8 -> x$8 % 2 != 0)).map(this.children());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.values;
    }

    public IndexedSeq<Expression> values() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.values$lzycompute() : this.values;
    }

    private DataType defaultElementType() {
        return this.defaultElementType;
    }

    @Override
    public boolean foldable() {
        return this.children().forall((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)x$9.foldable()));
    }

    @Override
    public Iterator<Object> stringArgs() {
        return super.stringArgs().take(1);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return this.children().size() % 2 != 0 ? new TypeCheckResult.TypeCheckFailure(new StringBuilder(45).append(this.prettyName()).append(" expects a positive even number of arguments.").toString()) : (!TypeCoercion$.MODULE$.haveSameType((Seq<DataType>)((Seq)this.keys().map((Function1 & Serializable)x$10 -> x$10.dataType()))) ? new TypeCheckResult.TypeCheckFailure(new StringBuilder(73).append("The given keys of function map should all be the same type, but they are ").append(((IterableOnceOps)this.keys().map((Function1 & Serializable)x$11 -> x$11.dataType().catalogString())).mkString("[", ", ", "]")).toString()) : (!TypeCoercion$.MODULE$.haveSameType((Seq<DataType>)((Seq)this.values().map((Function1 & Serializable)x$12 -> x$12.dataType()))) ? new TypeCheckResult.TypeCheckFailure(new StringBuilder(75).append("The given values of function map should all be the same type, but they are ").append(((IterableOnceOps)this.values().map((Function1 & Serializable)x$13 -> x$13.dataType().catalogString())).mkString("[", ", ", "]")).toString()) : TypeUtils$.MODULE$.checkForMapKeyType(this.dataType().keyType())));
    }

    private MapType dataType$lzycompute() {
        CreateMap createMap = this;
        synchronized (createMap) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.dataType = new MapType((DataType)TypeCoercion$.MODULE$.findCommonTypeDifferentOnlyInNullFlags((Seq<DataType>)((Seq)this.keys().map((Function1 & Serializable)x$14 -> x$14.dataType()))).getOrElse((Function0 & Serializable)() -> this.defaultElementType()), (DataType)TypeCoercion$.MODULE$.findCommonTypeDifferentOnlyInNullFlags((Seq<DataType>)((Seq)this.values().map((Function1 & Serializable)x$15 -> x$15.dataType()))).getOrElse((Function0 & Serializable)() -> this.defaultElementType()), this.values().exists((Function1 & Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)x$16.nullable())));
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.dataType;
    }

    @Override
    public MapType dataType() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.dataType$lzycompute() : this.dataType;
    }

    @Override
    public boolean nullable() {
        return false;
    }

    private ArrayBasedMapBuilder mapBuilder$lzycompute() {
        CreateMap createMap = this;
        synchronized (createMap) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.mapBuilder = new ArrayBasedMapBuilder(this.dataType().keyType(), this.dataType().valueType());
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.mapBuilder;
    }

    private ArrayBasedMapBuilder mapBuilder() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.mapBuilder$lzycompute() : this.mapBuilder;
    }

    @Override
    public Object eval(InternalRow input) {
        for (int i = 0; i < this.keys().length(); ++i) {
            this.mapBuilder().put(((Expression)this.keys().apply(i)).eval(input), ((Expression)this.values().apply(i)).eval(input));
        }
        return this.mapBuilder().build();
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        MapType mapType = this.dataType();
        if (mapType == null) {
            throw new MatchError((Object)mapType);
        }
        DataType keyDt = mapType.keyType();
        DataType valueDt = mapType.valueType();
        Tuple2 tuple2 = new Tuple2((Object)keyDt, (Object)valueDt);
        Tuple2 tuple22 = tuple2;
        DataType keyDt2 = (DataType)tuple22._1();
        DataType valueDt2 = (DataType)tuple22._2();
        Tuple3<String, String, String> tuple3 = GenArrayData$.MODULE$.genCodeToCreateArrayData(ctx, keyDt2, (Seq<Expression>)this.keys(), "createMap");
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        String allocationKeyData = (String)tuple3._1();
        String assignKeys = (String)tuple3._2();
        String keyArrayData = (String)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)allocationKeyData, (Object)assignKeys, (Object)keyArrayData);
        Tuple3 tuple33 = tuple32;
        String allocationKeyData2 = (String)tuple33._1();
        String assignKeys2 = (String)tuple33._2();
        String keyArrayData2 = (String)tuple33._3();
        Tuple3<String, String, String> tuple34 = GenArrayData$.MODULE$.genCodeToCreateArrayData(ctx, valueDt2, (Seq<Expression>)this.values(), "createMap");
        if (tuple34 == null) {
            throw new MatchError(tuple34);
        }
        String allocationValueData = (String)tuple34._1();
        String assignValues = (String)tuple34._2();
        String valueArrayData = (String)tuple34._3();
        Tuple3 tuple35 = new Tuple3((Object)allocationValueData, (Object)assignValues, (Object)valueArrayData);
        Tuple3 tuple36 = tuple35;
        String allocationValueData2 = (String)tuple36._1();
        String assignValues2 = (String)tuple36._2();
        String valueArrayData2 = (String)tuple36._3();
        String builderTerm = ctx.addReferenceObj("mapBuilder", this.mapBuilder(), ctx.addReferenceObj$default$3());
        Block code = Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n       ", "\n       ", "\n       ", "\n       ", "\n       final MapData ", " = ", ".from(", ", ", ");\n      "}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{allocationKeyData2, assignKeys2, allocationValueData2, assignValues2, ev.value(), builderTerm, keyArrayData2, valueArrayData2}));
        return ev.copy(code, FalseLiteral$.MODULE$, ev.copy$default$3());
    }

    @Override
    public String prettyName() {
        return "map";
    }

    @Override
    public CreateMap withNewChildrenInternal(IndexedSeq<Expression> newChildren) {
        return this.copy((Seq<Expression>)newChildren, this.copy$default$2());
    }

    public CreateMap copy(Seq<Expression> children2, boolean useStringTypeWhenEmpty) {
        return new CreateMap(children2, useStringTypeWhenEmpty);
    }

    public Seq<Expression> copy$default$1() {
        return this.children();
    }

    public boolean copy$default$2() {
        return this.useStringTypeWhenEmpty();
    }

    @Override
    public String productPrefix() {
        return "CreateMap";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.children();
                break;
            }
            case 1: {
                object = BoxesRunTime.boxToBoolean((boolean)this.useStringTypeWhenEmpty());
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof CreateMap;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "children";
                break;
            }
            case 1: {
                string = "useStringTypeWhenEmpty";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof CreateMap)) return false;
        boolean bl = true;
        if (!bl) return false;
        CreateMap createMap = (CreateMap)x$1;
        if (this.useStringTypeWhenEmpty() != createMap.useStringTypeWhenEmpty()) return false;
        Seq<Expression> seq = this.children();
        Seq<Expression> seq2 = createMap.children();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        if (!createMap.canEqual(this)) return false;
        return true;
    }

    public CreateMap(Seq<Expression> children2, boolean useStringTypeWhenEmpty) {
        this.children = children2;
        this.useStringTypeWhenEmpty = useStringTypeWhenEmpty;
        this.defaultElementType = useStringTypeWhenEmpty ? StringType$.MODULE$ : NullType$.MODULE$;
    }

    public CreateMap(Seq<Expression> children2) {
        this(children2, BoxesRunTime.unboxToBoolean((Object)SQLConf$.MODULE$.get().getConf(SQLConf$.MODULE$.LEGACY_CREATE_EMPTY_COLLECTION_USING_STRING_TYPE())));
    }
}

