/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Factorial$;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(expr) - Returns the factorial of `expr`. `expr` is [0..20]. Otherwise, null.", examples="\n    Examples:\n      > SELECT _FUNC_(5);\n       120\n  ", since="1.5.0", group="math_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005]w!\u0002\u000f\u001e\u0011\u0003Qc!\u0002\u0017\u001e\u0011\u0003i\u0003\"\u0002\u001f\u0002\t\u0003i\u0004\"\u0002 \u0002\t\u0003y\u0004b\u0002%\u0002\u0005\u0004%I!\u0013\u0005\u0007\u001b\u0006\u0001\u000b\u0011\u0002&\t\u000f9\u000b\u0011\u0011!CA\u001f\"I\u0011qX\u0001\u0002\u0002\u0013\u0005\u0015\u0011\u0019\u0005\n\u0003\u001b\f\u0011\u0011!C\u0005\u0003\u001f4A\u0001L\u000fA#\"AA.\u0003BK\u0002\u0013\u0005Q\u000e\u0003\u0005r\u0013\tE\t\u0015!\u0003o\u0011\u0015a\u0014\u0002\"\u0001s\u0011\u0015!\u0018\u0002\"\u0011v\u0011\u0019y\u0018\u0002\"\u0011\u0002\u0002!9\u00111A\u0005\u0005B\u0005\u0015\u0001bBA\u0007\u0013\u0011E\u0013q\u0002\u0005\b\u00037IA\u0011IA\u000f\u0011\u001d\tI$\u0003C)\u0003wA\u0011\"!\u0011\n\u0003\u0003%\t!a\u0011\t\u0013\u0005\u001d\u0013\"%A\u0005\u0002\u0005%\u0003\"CA0\u0013\u0005\u0005I\u0011IA1\u0011%\ty'CA\u0001\n\u0003\t\t\bC\u0005\u0002t%\t\t\u0011\"\u0001\u0002v!I\u00111P\u0005\u0002\u0002\u0013\u0005\u0013Q\u0010\u0005\n\u0003\u0017K\u0011\u0011!C\u0001\u0003\u001bC\u0011\"!%\n\u0003\u0003%\t%a%\t\u0013\u0005]\u0015\"!A\u0005B\u0005e\u0015!\u0003$bGR|'/[1m\u0015\tqr$A\u0006fqB\u0014Xm]:j_:\u001c(B\u0001\u0011\"\u0003!\u0019\u0017\r^1msN$(B\u0001\u0012$\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003I\u0015\nQa\u001d9be.T!AJ\u0014\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005A\u0013aA8sO\u000e\u0001\u0001CA\u0016\u0002\u001b\u0005i\"!\u0003$bGR|'/[1m'\r\ta\u0006\u000e\t\u0003_Ij\u0011\u0001\r\u0006\u0002c\u0005)1oY1mC&\u00111\u0007\r\u0002\u0007\u0003:L(+\u001a4\u0011\u0005URT\"\u0001\u001c\u000b\u0005]B\u0014AA5p\u0015\u0005I\u0014\u0001\u00026bm\u0006L!a\u000f\u001c\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\rqJg.\u001b;?)\u0005Q\u0013!\u00034bGR|'/[1m)\t\u00015\t\u0005\u00020\u0003&\u0011!\t\r\u0002\u0005\u0019>tw\rC\u0003E\u0007\u0001\u0007Q)A\u0001o!\tyc)\u0003\u0002Ha\t\u0019\u0011J\u001c;\u0002\u0015\u0019\f7\r^8sS\u0006d7/F\u0001K!\ry3\nQ\u0005\u0003\u0019B\u0012Q!\u0011:sCf\f1BZ1di>\u0014\u0018.\u00197tA\u0005)\u0011\r\u001d9msR\u0019\u0001+!0\u0011\u0005-J1CB\u0005S+b{&\r\u0005\u0002,'&\u0011A+\b\u0002\u0010+:\f'/_#yaJ,7o]5p]B\u00111FV\u0005\u0003/v\u0011a#S7qY&\u001c\u0017\u000e^\"bgRLe\u000e];u)f\u0004Xm\u001d\t\u00033rs!a\u000b.\n\u0005mk\u0012a\u00029bG.\fw-Z\u0005\u0003;z\u0013aBT;mY&sGo\u001c7fe\u0006tGO\u0003\u0002\\;A\u0011q\u0006Y\u0005\u0003CB\u0012q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002dU:\u0011A-\u001b\b\u0003K\"l\u0011A\u001a\u0006\u0003O&\na\u0001\u0010:p_Rt\u0014\"A\u0019\n\u0005m\u0003\u0014BA\u001el\u0015\tY\u0006'A\u0003dQ&dG-F\u0001o!\tYs.\u0003\u0002q;\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0002\r\rD\u0017\u000e\u001c3!)\t\u00016\u000fC\u0003m\u0019\u0001\u0007a.\u0001\u0006j]B,H\u000fV=qKN,\u0012A\u001e\t\u0004G^L\u0018B\u0001=l\u0005\r\u0019V-\u001d\t\u0003uvl\u0011a\u001f\u0006\u0003y\u0006\nQ\u0001^=qKNL!A`>\u0003\u0011\u0011\u000bG/\u0019+za\u0016\f\u0001\u0002Z1uCRK\b/Z\u000b\u0002s\u0006Aa.\u001e7mC\ndW-\u0006\u0002\u0002\bA\u0019q&!\u0003\n\u0007\u0005-\u0001GA\u0004C_>dW-\u00198\u0002\u00199,H\u000e\\*bM\u0016,e/\u00197\u0015\t\u0005E\u0011q\u0003\t\u0004_\u0005M\u0011bAA\u000ba\t\u0019\u0011I\\=\t\u000f\u0005e\u0001\u00031\u0001\u0002\u0012\u0005)\u0011N\u001c9vi\u0006IAm\\$f]\u000e{G-\u001a\u000b\u0007\u0003?\tY#!\u000e\u0011\t\u0005\u0005\u0012qE\u0007\u0003\u0003GQ1!!\n\u001e\u0003\u001d\u0019w\u000eZ3hK:LA!!\u000b\u0002$\tAQ\t\u001f9s\u0007>$W\rC\u0004\u0002.E\u0001\r!a\f\u0002\u0007\r$\b\u0010\u0005\u0003\u0002\"\u0005E\u0012\u0002BA\u001a\u0003G\u0011abQ8eK\u001e,gnQ8oi\u0016DH\u000fC\u0004\u00028E\u0001\r!a\b\u0002\u0005\u00154\u0018\u0001F<ji\"tUm^\"iS2$\u0017J\u001c;fe:\fG\u000eF\u0002Q\u0003{Aa!a\u0010\u0013\u0001\u0004q\u0017\u0001\u00038fo\u000eC\u0017\u000e\u001c3\u0002\t\r|\u0007/\u001f\u000b\u0004!\u0006\u0015\u0003b\u00027\u0014!\u0003\u0005\rA\\\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\tYEK\u0002o\u0003\u001bZ#!a\u0014\u0011\t\u0005E\u00131L\u0007\u0003\u0003'RA!!\u0016\u0002X\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u00033\u0002\u0014AC1o]>$\u0018\r^5p]&!\u0011QLA*\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005\r\u0004\u0003BA3\u0003Wj!!a\u001a\u000b\u0007\u0005%\u0004(\u0001\u0003mC:<\u0017\u0002BA7\u0003O\u0012aa\u0015;sS:<\u0017\u0001\u00049s_\u0012,8\r^!sSRLX#A#\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011\u0011CA<\u0011!\tIhFA\u0001\u0002\u0004)\u0015a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002\u0000A1\u0011\u0011QAD\u0003#i!!a!\u000b\u0007\u0005\u0015\u0005'\u0001\u0006d_2dWm\u0019;j_:LA!!#\u0002\u0004\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\t9!a$\t\u0013\u0005e\u0014$!AA\u0002\u0005E\u0011A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$B!a\u0019\u0002\u0016\"A\u0011\u0011\u0010\u000e\u0002\u0002\u0003\u0007Q)\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003\u000f\tY\nC\u0005\u0002zm\t\t\u00111\u0001\u0002\u0012!\u001a\u0012\"a(\u0002&\u0006\u001d\u00161VAW\u0003c\u000b\u0019,a.\u0002:B\u00191&!)\n\u0007\u0005\rVDA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\u0005%\u0016aU0G+:\u001bu\fK3yaJL\u0003%\f\u0011SKR,(O\\:!i\",\u0007EZ1di>\u0014\u0018.\u00197!_\u001a\u0004\u0003-\u001a=qe\u0002t\u0003\u0005Y3yaJ\u0004\u0007%[:!7BrcF\r\u0019^]\u0001zE\u000f[3so&\u001cX\r\f\u0011ok2dg&\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\ty+\u0001\u001c\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`QUJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005I\u00193a)\u0001\u0003%A\u0003tS:\u001cW-\t\u0002\u00026\u0006)\u0011GL\u001b/a\u0005)qM]8va\u0006\u0012\u00111X\u0001\u000b[\u0006$\bn\u00184v]\u000e\u001c\b\"\u00027\u0007\u0001\u0004q\u0017aB;oCB\u0004H.\u001f\u000b\u0005\u0003\u0007\fI\r\u0005\u00030\u0003\u000bt\u0017bAAda\t1q\n\u001d;j_:D\u0001\"a3\b\u0003\u0003\u0005\r\u0001U\u0001\u0004q\u0012\u0002\u0014\u0001D<sSR,'+\u001a9mC\u000e,GCAAi!\u0011\t)'a5\n\t\u0005U\u0017q\r\u0002\u0007\u001f\nTWm\u0019;")
public class Factorial
extends UnaryExpression
implements ImplicitCastInputTypes,
package.NullIntolerant,
Serializable {
    private final Expression child;

    public static Option<Expression> unapply(Factorial factorial) {
        return Factorial$.MODULE$.unapply(factorial);
    }

    public static long factorial(int n) {
        return Factorial$.MODULE$.factorial(n);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    public Seq<DataType> inputTypes() {
        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new IntegerType$[]{IntegerType$.MODULE$}));
    }

    @Override
    public DataType dataType() {
        return LongType$.MODULE$;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public Object nullSafeEval(Object input) {
        Integer value = (Integer)input;
        return Predef$.MODULE$.Integer2int(value) > 20 || Predef$.MODULE$.Integer2int(value) < 0 ? null : BoxesRunTime.boxToLong((long)Factorial$.MODULE$.factorial(Predef$.MODULE$.Integer2int(value)));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable)eval -> new StringBuilder(172).append("\n        if (").append((String)eval).append(" > 20 || ").append((String)eval).append(" < 0) {\n          ").append(ev.isNull()).append(" = true;\n        } else {\n          ").append(ev.value()).append(" =\n            org.apache.spark.sql.catalyst.expressions.Factorial.factorial(").append((String)eval).append(");\n        }\n      ").toString());
    }

    @Override
    public Factorial withNewChildInternal(Expression newChild) {
        return this.copy(newChild);
    }

    public Factorial copy(Expression child) {
        return new Factorial(child);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "Factorial";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.child();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Factorial;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "child";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Factorial)) return false;
        boolean bl = true;
        if (!bl) return false;
        Factorial factorial = (Factorial)x$1;
        Expression expression = this.child();
        Expression expression2 = factorial.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!factorial.canEqual(this)) return false;
        return true;
    }

    public Factorial(Expression child) {
        this.child = child;
        ExpectsInputTypes.$init$(this);
    }
}

