/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.analysis.TypeCoercion$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.HigherOrderFunction;
import org.apache.spark.sql.catalyst.expressions.LambdaFunction;
import org.apache.spark.sql.catalyst.expressions.MapZipWith$;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.NamedLambdaVariable;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.trees.TernaryLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.util.ArrayBasedMapData;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AnyDataType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.unsafe.array.ByteArrayMethods;
import scala.Array;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Iterable;
import scala.collection.mutable.LinkedHashMap;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n      _FUNC_(map1, map2, function) - Merges two given maps into a single map by applying\n      function to the pair of values with the same key. For keys only presented in one map,\n      NULL will be passed as the value for the missing key. If an input map contains duplicated\n      keys, only the first entry of the duplicated key is passed into the lambda function.\n    ", examples="\n    Examples:\n      > SELECT _FUNC_(map(1, 'a', 2, 'b'), map(1, 'x', 2, 'y'), (k, v1, v2) -> concat(v1, v2));\n       {1:\"ax\",2:\"by\"}\n  ", since="3.0.0", group="lambda_funcs")
@ScalaSignature(bytes="\u0006\u0005\r-b\u0001\u0002\u001f>\u0001*C\u0001\u0002\u001d\u0001\u0003\u0016\u0004%\t!\u001d\u0005\te\u0002\u0011\t\u0012)A\u0005\u0017\"A1\u000f\u0001BK\u0002\u0013\u0005\u0011\u000f\u0003\u0005u\u0001\tE\t\u0015!\u0003L\u0011!)\bA!f\u0001\n\u0003\t\b\u0002\u0003<\u0001\u0005#\u0005\u000b\u0011B&\t\u000b]\u0004A\u0011\u0001=\t\u000bu\u0004A\u0011A9\t\u0015y\u0004\u0001\u0013!EDB\u0013%q\u0010\u0003\u0006\u0002\u001a\u0001A)\u0019!C\u0001\u00037A!\"!\n\u0001\u0011\u000b\u0007I\u0011AA\u000e\u0011)\tI\u0003\u0001EC\u0002\u0013\u0005\u00111\u0006\u0005\f\u0003_\u0001\u0001\u0013!EDB\u0013%q\u0010\u0003\u0006\u00022\u0001A)\u0019!C\u0001\u00037A!\"!\u000e\u0001\u0011\u000b\u0007I\u0011AA\u000e\u0011)\tI\u0004\u0001EC\u0002\u0013\u0005\u00111\u0006\u0005\u000b\u0003{\u0001\u0001R1A\u0005\u0002\u0005m\u0001BCA!\u0001!\u0015\r\u0011\"\u0001\u0002D!9\u00111\u000b\u0001\u0005B\u0005U\u0003bBA/\u0001\u0011\u0005\u0013q\f\u0005\b\u0003S\u0002A\u0011IA+\u0011\u001d\tY\u0007\u0001C!\u0003?Bq!!\u001c\u0001\t\u0003\nY\u0002C\u0004\u0002p\u0001!\t%!\u001d\t\u000f\u0005-\u0005\u0001\"\u0011\u0002\u000e\"9\u00111\u0014\u0001\u0005B\u00055\u0005bBAO\u0001\u0011\u0005\u0013q\u0014\u0005\r\u0003[\u0003\u0001\u0013!EDB\u0013%\u0011q\u0016\u0005\u000b\u0003s\u0003\u0001R1A\u0005\u0002\u0005m\u0006BCA`\u0001!\u0015\r\u0011\"\u0001\u0002<\"Q\u00111\u0019\u0001\t\u0006\u0004%\t!a/\t\u0015\u0005\u001d\u0007\u0001#b\u0001\n\u0013\tI\rC\u0004\u0002\u0000\u0002!IA!\u0001\t\u000f\t5\u0001\u0001\"\u0003\u0003\u0010!9!q\u0004\u0001\u0005\n\t\u0005\u0002b\u0002B\u0017\u0001\u0011%!q\u0006\u0005\b\u0005{\u0001A\u0011\tB \u0011\u0019\u0011\t\u0006\u0001C!c\"1!1\u000b\u0001\u0005BEDaA!\u0016\u0001\t\u0003\n\bb\u0002B,\u0001\u0011E#\u0011\f\u0005\n\u0005O\u0002\u0011\u0011!C\u0001\u0005SB\u0011B!\u001d\u0001#\u0003%\tAa\u001d\t\u0013\t%\u0005!%A\u0005\u0002\tM\u0004\"\u0003BF\u0001E\u0005I\u0011\u0001B:\u0011%\u0011i\tAA\u0001\n\u0003\u0012y\tC\u0005\u0003 \u0002\t\t\u0011\"\u0001\u0003\"\"I!1\u0015\u0001\u0002\u0002\u0013\u0005!Q\u0015\u0005\n\u0005W\u0003\u0011\u0011!C!\u0005[C\u0011Ba.\u0001\u0003\u0003%\tA!/\t\u0013\tu\u0006!!A\u0005B\t}\u0006\"\u0003Bb\u0001\u0005\u0005I\u0011\tBc\u000f%\u0011I/PA\u0001\u0012\u0003\u0011YO\u0002\u0005={\u0005\u0005\t\u0012\u0001Bw\u0011\u00199h\u0007\"\u0001\u0004\u0006!I1q\u0001\u001c\u0002\u0002\u0013\u00153\u0011\u0002\u0005\n\u0007\u00171\u0014\u0011!CA\u0007\u001bA\u0011b!\u00067\u0003\u0003%\tia\u0006\t\u0013\r\u0005b'!A\u0005\n\r\r\"AC'bajK\u0007oV5uQ*\u0011ahP\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002A\u0003\u0006A1-\u0019;bYf\u001cHO\u0003\u0002C\u0007\u0006\u00191/\u001d7\u000b\u0005\u0011+\u0015!B:qCJ\\'B\u0001$H\u0003\u0019\t\u0007/Y2iK*\t\u0001*A\u0002pe\u001e\u001c\u0001aE\u0004\u0001\u0017>\u0013\u0006L\u00183\u0011\u00051kU\"A\u001f\n\u00059k$AC#yaJ,7o]5p]B\u0011A\nU\u0005\u0003#v\u00121\u0003S5hQ\u0016\u0014xJ\u001d3fe\u001a+hn\u0019;j_:\u0004\"a\u0015,\u000e\u0003QS!!V\u001f\u0002\u000f\r|G-Z4f]&\u0011q\u000b\u0016\u0002\u0010\u0007>$WmZ3o\r\u0006dGNY1dWB\u0019\u0011\fX&\u000e\u0003iS!aW \u0002\u000bQ\u0014X-Z:\n\u0005uS&a\u0003+fe:\f'/\u001f'jW\u0016\u0004\"a\u00182\u000e\u0003\u0001T\u0011!Y\u0001\u0006g\u000e\fG.Y\u0005\u0003G\u0002\u0014q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002f[:\u0011am\u001b\b\u0003O*l\u0011\u0001\u001b\u0006\u0003S&\u000ba\u0001\u0010:p_Rt\u0014\"A1\n\u00051\u0004\u0017a\u00029bG.\fw-Z\u0005\u0003]>\u0014AbU3sS\u0006d\u0017N_1cY\u0016T!\u0001\u001c1\u0002\t1,g\r^\u000b\u0002\u0017\u0006)A.\u001a4uA\u0005)!/[4ii\u00061!/[4ii\u0002\n\u0001BZ;oGRLwN\\\u0001\nMVt7\r^5p]\u0002\na\u0001P5oSRtD\u0003B={wr\u0004\"\u0001\u0014\u0001\t\u000bA<\u0001\u0019A&\t\u000bM<\u0001\u0019A&\t\u000bU<\u0001\u0019A&\u0002\u001f\u0019,hn\u0019;j_:4uN]#wC2\fA\u0001\u001f\u00133oU\u0011\u0011\u0011\u0001\t\n?\u0006\r\u0011qAA\u0004\u0003'I1!!\u0002a\u0005\u0019!V\u000f\u001d7fgA!\u0011\u0011BA\b\u001b\t\tYAC\u0002\u0002\u000e\u0005\u000bQ\u0001^=qKNLA!!\u0005\u0002\f\tAA)\u0019;b)f\u0004X\rE\u0002`\u0003+I1!a\u0006a\u0005\u001d\u0011un\u001c7fC:\f1\u0002\\3gi.+\u0017\u0010V=qKV\u0011\u0011q\u0001\u0015\u0004\u0015\u0005}\u0001cA0\u0002\"%\u0019\u00111\u00051\u0003\u0013Q\u0014\u0018M\\:jK:$\u0018!\u00047fMR4\u0016\r\\;f)f\u0004X\rK\u0002\f\u0003?\tQ\u0003\\3giZ\u000bG.^3D_:$\u0018-\u001b8t\u001dVdG.\u0006\u0002\u0002\u0014!\u001aA\"a\b\u0002\ta$#\u0007O\u0001\re&<\u0007\u000e^&fsRK\b/\u001a\u0015\u0004\u001d\u0005}\u0011A\u0004:jO\"$h+\u00197vKRK\b/\u001a\u0015\u0004\u001f\u0005}\u0011A\u0006:jO\"$h+\u00197vK\u000e{g\u000e^1j]NtU\u000f\u001c7)\u0007A\ty\"A\u0004lKf$\u0016\u0010]3)\u0007E\ty\"\u0001\u0005pe\u0012,'/\u001b8h+\t\t)\u0005E\u0003f\u0003\u000f\nY%C\u0002\u0002J=\u0014\u0001b\u0014:eKJLgn\u001a\t\u0004?\u00065\u0013bAA(A\n\u0019\u0011I\\=)\u0007I\ty\"A\u0005be\u001e,X.\u001a8ugV\u0011\u0011q\u000b\t\u0005K\u0006e3*C\u0002\u0002\\=\u00141aU3r\u00035\t'oZ;nK:$H+\u001f9fgV\u0011\u0011\u0011\r\t\u0006K\u0006e\u00131\r\t\u0005\u0003\u0013\t)'\u0003\u0003\u0002h\u0005-!\u0001E!cgR\u0014\u0018m\u0019;ECR\fG+\u001f9f\u0003%1WO\\2uS>t7/A\u0007gk:\u001cG/[8o)f\u0004Xm]\u0001\tI\u0006$\u0018\rV=qK\u0006!!-\u001b8e)\rI\u00181\u000f\u0005\b\u0003kB\u0002\u0019AA<\u0003\u00051\u0007\u0003C0\u0002z-\u000bi(!\"\n\u0007\u0005m\u0004MA\u0005Gk:\u001cG/[8oeA)Q-!\u0017\u0002\u0000A9q,!!\u0002\b\u0005M\u0011bAABA\n1A+\u001e9mKJ\u00022\u0001TAD\u0013\r\tI)\u0010\u0002\u000f\u0019\u0006l'\rZ1Gk:\u001cG/[8o\u0003Y\u0019\u0007.Z2l\u0003J<W/\\3oi\u0012\u000bG/\u0019+za\u0016\u001cHCAAH!\u0011\t\t*a&\u000e\u0005\u0005M%bAAK\u007f\u0005A\u0011M\\1msNL7/\u0003\u0003\u0002\u001a\u0006M%a\u0004+za\u0016\u001c\u0005.Z2l%\u0016\u001cX\u000f\u001c;\u0002'\rDWmY6J]B,H\u000fR1uCRK\b/Z:\u0002\t\u00154\u0018\r\u001c\u000b\u0005\u0003\u0017\n\t\u000bC\u0005\u0002$n\u0001\n\u00111\u0001\u0002&\u0006)\u0011N\u001c9viB!\u0011qUAU\u001b\u0005y\u0014bAAV\u007f\tY\u0011J\u001c;fe:\fGNU8x\u0003\u0011AHEM\u001d\u0016\u0005\u0005E\u0006#C0\u0002\u0004\u0005M\u00161WAZ!\ra\u0015QW\u0005\u0004\u0003ok$a\u0005(b[\u0016$G*Y7cI\u00064\u0016M]5bE2,\u0017AB6fsZ\u000b'/\u0006\u0002\u00024\"\u001aQ$a\b\u0002\u0013Y\fG.^32-\u0006\u0014\bf\u0001\u0010\u0002 \u0005Ia/\u00197vKJ2\u0016M\u001d\u0015\u0004?\u0005}\u0011aF4fi.+\u0017p],ji\"4\u0016\r\\;f\u0013:$W\r_3t+\t\tY\rE\u0005`\u0003s\ni-!4\u0002ZB!\u0011qZAk\u001b\t\t\tNC\u0002\u0002T~\nA!\u001e;jY&!\u0011q[Ai\u0005%\t%O]1z\t\u0006$\u0018\r\u0005\u0004\u0002\\\u0006\u0015\u0018\u0011^\u0007\u0003\u0003;TA!a8\u0002b\u00069Q.\u001e;bE2,'bAArA\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005\u001d\u0018Q\u001c\u0002\t\u0013R,'/\u00192mKB9q,!!\u0002L\u0005-\b#B0\u0002n\u0006E\u0018bAAxA\n)\u0011I\u001d:bsB)q,a=\u0002x&\u0019\u0011Q\u001f1\u0003\r=\u0003H/[8o!\ry\u0016\u0011`\u0005\u0004\u0003w\u0004'aA%oi\"\u001a\u0001%a\b\u0002/\u0005\u001c8/\u001a:u'&TXm\u00144BeJ\f\u0017PQ;gM\u0016\u0014H\u0003\u0002B\u0002\u0005\u0013\u00012a\u0018B\u0003\u0013\r\u00119\u0001\u0019\u0002\u0005+:LG\u000fC\u0004\u0003\f\u0005\u0002\r!a>\u0002\tML'0Z\u0001\u0017O\u0016$8*Z=t/&$\b.\u00138eKb,7OR1tiR1!\u0011\u0003B\f\u00057\u0001\u0002\"a7\u0003\u0014\u0005-\u00131^\u0005\u0005\u0005+\tiNA\u0007MS:\\W\r\u001a%bg\"l\u0015\r\u001d\u0005\b\u00053\u0011\u0003\u0019AAg\u0003\u0015YW-_:2\u0011\u001d\u0011iB\ta\u0001\u0003\u001b\fQa[3zgJ\nAdZ3u\u0017\u0016L8oV5uQ&sG-\u001a=fg\n\u0013X\u000f^3G_J\u001cW\r\u0006\u0004\u0003$\t%\"1\u0006\t\u0007\u00037\u0014)#!;\n\t\t\u001d\u0012Q\u001c\u0002\f\u0003J\u0014\u0018-\u001f\"vM\u001a,'\u000fC\u0004\u0003\u001a\r\u0002\r!!4\t\u000f\tu1\u00051\u0001\u0002N\u0006aa.\u001e7m'\u00064W-\u0012<bYRA\u00111\nB\u0019\u0005k\u0011I\u0004C\u0004\u00034\u0011\u0002\r!!*\u0002\u0011%t\u0007/\u001e;S_^DqAa\u000e%\u0001\u0004\tY%\u0001\u0004wC2,X-\r\u0005\b\u0005w!\u0003\u0019AA&\u0003\u00191\u0018\r\\;fe\u0005Q\u0001O]3uift\u0015-\\3\u0016\u0005\t\u0005\u0003\u0003\u0002B\"\u0005\u0017rAA!\u0012\u0003HA\u0011q\rY\u0005\u0004\u0005\u0013\u0002\u0017A\u0002)sK\u0012,g-\u0003\u0003\u0003N\t=#AB*ue&twMC\u0002\u0003J\u0001\fQAZ5sgR\faa]3d_:$\u0017!\u0002;iSJ$\u0017aF<ji\"tUm^\"iS2$'/\u001a8J]R,'O\\1m)\u001dI(1\fB0\u0005GBaA!\u0018*\u0001\u0004Y\u0015\u0001\u00038fo\u001aK'o\u001d;\t\r\t\u0005\u0014\u00061\u0001L\u0003%qWm^*fG>tG\r\u0003\u0004\u0003f%\u0002\raS\u0001\t]\u0016<H\u000b[5sI\u0006!1m\u001c9z)\u001dI(1\u000eB7\u0005_Bq\u0001\u001d\u0016\u0011\u0002\u0003\u00071\nC\u0004tUA\u0005\t\u0019A&\t\u000fUT\u0003\u0013!a\u0001\u0017\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTC\u0001B;U\rY%qO\u0016\u0003\u0005s\u0002BAa\u001f\u0003\u00066\u0011!Q\u0010\u0006\u0005\u0005\u007f\u0012\t)A\u0005v]\u000eDWmY6fI*\u0019!1\u00111\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003\b\nu$!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012\u0014AD2paf$C-\u001a4bk2$HeM\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\tE\u0005\u0003\u0002BJ\u0005;k!A!&\u000b\t\t]%\u0011T\u0001\u0005Y\u0006twM\u0003\u0002\u0003\u001c\u0006!!.\u0019<b\u0013\u0011\u0011iE!&\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005]\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003\u0017\u00129\u000bC\u0005\u0003*B\n\t\u00111\u0001\u0002x\u0006\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"Aa,\u0011\r\tE&1WA&\u001b\t\t\t/\u0003\u0003\u00036\u0006\u0005(\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!a\u0005\u0003<\"I!\u0011\u0016\u001a\u0002\u0002\u0003\u0007\u00111J\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0003\u0012\n\u0005\u0007\"\u0003BUg\u0005\u0005\t\u0019AA|\u0003\u0019)\u0017/^1mgR!\u00111\u0003Bd\u0011%\u0011I\u000bNA\u0001\u0002\u0004\tY\u0005K\n\u0001\u0005\u0017\u0014\tNa5\u0003X\ne'Q\u001cBp\u0005G\u0014)\u000fE\u0002M\u0005\u001bL1Aa4>\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#A!6\u0002\u0005WT\u0001\u0005\t\u0011!A\u0001zf)\u0016(D?\"j\u0017\r]\u0019-A5\f\u0007O\r\u0017!MVt7\r^5p]&\u0002S\u0006I'fe\u001e,7\u000f\t;x_\u0002:\u0017N^3oA5\f\u0007o\u001d\u0011j]R|\u0007%\u0019\u0011tS:<G.\u001a\u0011nCB\u0004#-\u001f\u0011baBd\u00170\u001b8h\u0015\u0001\u0002\u0003\u0005\t\u0011!MVt7\r^5p]\u0002\"x\u000e\t;iK\u0002\u0002\u0018-\u001b:!_\u001a\u0004c/\u00197vKN\u0004s/\u001b;iAQDW\rI:b[\u0016\u00043.Z=/A\u0019{'\u000fI6fsN\u0004sN\u001c7zAA\u0014Xm]3oi\u0016$\u0007%\u001b8!_:,\u0007%\\1qY)\u0001\u0003\u0005\t\u0011!A9+F\n\u0014\u0011xS2d\u0007EY3!a\u0006\u001c8/\u001a3!CN\u0004C\u000f[3!m\u0006dW/\u001a\u0011g_J\u0004C\u000f[3![&\u001c8/\u001b8hA-,\u0017P\f\u0011JM\u0002\ng\u000eI5oaV$\b%\\1qA\r|g\u000e^1j]N\u0004C-\u001e9mS\u000e\fG/\u001a3\u000bA\u0001\u0002\u0003\u0005\t\u0011lKf\u001cH\u0006I8oYf\u0004C\u000f[3!M&\u00148\u000f\u001e\u0011f]R\u0014\u0018\u0010I8gAQDW\r\t3va2L7-\u0019;fI\u0002ZW-\u001f\u0011jg\u0002\u0002\u0018m]:fI\u0002Jg\u000e^8!i\",\u0007\u0005\\1nE\u0012\f\u0007EZ;oGRLwN\u001c\u0018\u000bA\u0001\u0002\u0003%\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\u0011Y.AA\t\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"j\u0017\r\u001d\u00152Y\u0001:\u0013m\n\u0017!e1\u0002sEY\u0014*Y\u0001j\u0017\r\u001d\u00152Y\u0001:\u0003p\n\u0017!e1\u0002s%_\u0014*Y\u0001B3\u000e\f\u0011wc1\u0002cOM\u0015![y\u00023m\u001c8dCRDc/\r\u0017!mJJ\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011|ci\u0012\u0013\r\u001f\u0012-ei\u0012#-\u001f\u0012~\u0015\u0001\u0002\u0013!B:j]\u000e,\u0017E\u0001Bq\u0003\u0015\u0019d\u0006\r\u00181\u0003\u00159'o\\;qC\t\u00119/\u0001\u0007mC6\u0014G-Y0gk:\u001c7/\u0001\u0006NCBT\u0016\u000e],ji\"\u0004\"\u0001\u0014\u001c\u0014\u000bY\u0012yOa?\u0011\u0011\tE(q_&L\u0017fl!Aa=\u000b\u0007\tU\b-A\u0004sk:$\u0018.\\3\n\t\te(1\u001f\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u001c\u0004\u0003\u0002B\u007f\u0007\u0007i!Aa@\u000b\t\r\u0005!\u0011T\u0001\u0003S>L1A\u001cB\u0000)\t\u0011Y/\u0001\u0005u_N#(/\u001b8h)\t\u0011\t*A\u0003baBd\u0017\u0010F\u0004z\u0007\u001f\u0019\tba\u0005\t\u000bAL\u0004\u0019A&\t\u000bML\u0004\u0019A&\t\u000bUL\u0004\u0019A&\u0002\u000fUt\u0017\r\u001d9msR!1\u0011DB\u000f!\u0015y\u00161_B\u000e!\u0019y\u00161A&L\u0017\"A1q\u0004\u001e\u0002\u0002\u0003\u0007\u00110A\u0002yIA\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"a!\n\u0011\t\tM5qE\u0005\u0005\u0007S\u0011)J\u0001\u0004PE*,7\r\u001e")
public class MapZipWith
extends Expression
implements HigherOrderFunction,
CodegenFallback,
TernaryLike<Expression>,
Serializable {
    private Tuple3<DataType, DataType, Object> x$27;
    private transient DataType leftKeyType;
    private transient DataType leftValueType;
    private transient boolean leftValueContainsNull;
    private Tuple3<DataType, DataType, Object> x$28;
    private transient DataType rightKeyType;
    private transient DataType rightValueType;
    private transient boolean rightValueContainsNull;
    private transient DataType keyType;
    private transient Ordering<Object> ordering;
    private Tuple3<NamedLambdaVariable, NamedLambdaVariable, NamedLambdaVariable> x$29;
    private transient NamedLambdaVariable keyVar;
    private transient NamedLambdaVariable value1Var;
    private transient NamedLambdaVariable value2Var;
    private transient Function2<ArrayData, ArrayData, Iterable<Tuple2<Object, Option<Object>[]>>> getKeysWithValueIndexes;
    private final Expression left;
    private final Expression right;
    private final Expression function;
    private transient Seq<Expression> children;
    private Seq<Enumeration.Value> nodePatterns;
    private boolean argumentsResolved;
    private boolean resolved;
    private transient Seq<Expression> functionsForEval;
    private Expression canonicalized;
    private volatile transient int bitmap$trans$0;
    private volatile byte bitmap$0;

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(MapZipWith mapZipWith) {
        return MapZipWith$.MODULE$.unapply(mapZipWith);
    }

    public static Function1<Tuple3<Expression, Expression, Expression>, MapZipWith> tupled() {
        return MapZipWith$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, MapZipWith>>> curried() {
        return MapZipWith$.MODULE$.curried();
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return TernaryLike.mapChildren$(this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return TernaryLike.withNewChildrenInternal$(this, newChildren);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return CodegenFallback.doGenCode$(this, ctx, ev);
    }

    @Override
    public boolean nullable() {
        return HigherOrderFunction.nullable$(this);
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return HigherOrderFunction.inputTypes$(this);
    }

    private Seq<Expression> children$lzycompute() {
        MapZipWith mapZipWith = this;
        synchronized (mapZipWith) {
            if ((this.bitmap$trans$0 & 0x1000) == 0) {
                this.children = TernaryLike.children$(this);
                this.bitmap$trans$0 |= 0x1000;
            }
        }
        return this.children;
    }

    @Override
    public final Seq<Expression> children() {
        return (this.bitmap$trans$0 & 0x1000) == 0 ? this.children$lzycompute() : this.children;
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private boolean argumentsResolved$lzycompute() {
        MapZipWith mapZipWith = this;
        synchronized (mapZipWith) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.argumentsResolved = HigherOrderFunction.argumentsResolved$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.argumentsResolved;
    }

    @Override
    public boolean argumentsResolved() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.argumentsResolved$lzycompute() : this.argumentsResolved;
    }

    private boolean resolved$lzycompute() {
        MapZipWith mapZipWith = this;
        synchronized (mapZipWith) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.resolved = HigherOrderFunction.resolved$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        return (byte)(this.bitmap$0 & 0x10) == 0 ? this.resolved$lzycompute() : this.resolved;
    }

    private Seq<Expression> functionsForEval$lzycompute() {
        MapZipWith mapZipWith = this;
        synchronized (mapZipWith) {
            if ((this.bitmap$trans$0 & 0x2000) == 0) {
                this.functionsForEval = HigherOrderFunction.functionsForEval$(this);
                this.bitmap$trans$0 |= 0x2000;
            }
        }
        return this.functionsForEval;
    }

    @Override
    public Seq<Expression> functionsForEval() {
        return (this.bitmap$trans$0 & 0x2000) == 0 ? this.functionsForEval$lzycompute() : this.functionsForEval;
    }

    private Expression canonicalized$lzycompute() {
        MapZipWith mapZipWith = this;
        synchronized (mapZipWith) {
            if ((byte)(this.bitmap$0 & 0x20) == 0) {
                this.canonicalized = HigherOrderFunction.canonicalized$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x20);
            }
        }
        return this.canonicalized;
    }

    @Override
    public Expression canonicalized() {
        return (byte)(this.bitmap$0 & 0x20) == 0 ? this.canonicalized$lzycompute() : this.canonicalized;
    }

    @Override
    public final void org$apache$spark$sql$catalyst$expressions$HigherOrderFunction$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public Expression left() {
        return this.left;
    }

    public Expression right() {
        return this.right;
    }

    public Expression function() {
        return this.function;
    }

    public Expression functionForEval() {
        return (Expression)this.functionsForEval().head();
    }

    private Tuple3<DataType, DataType, Object> x$27$lzycompute() {
        MapZipWith mapZipWith = this;
        synchronized (mapZipWith) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                DataType dataType = this.left().dataType();
                if (!(dataType instanceof MapType)) {
                    throw new MatchError((Object)dataType);
                }
                MapType mapType = (MapType)dataType;
                DataType leftKeyType = mapType.keyType();
                DataType leftValueType = mapType.valueType();
                boolean leftValueContainsNull = mapType.valueContainsNull();
                Tuple3 tuple3 = new Tuple3((Object)leftKeyType, (Object)leftValueType, (Object)BoxesRunTime.boxToBoolean((boolean)leftValueContainsNull));
                this.x$27 = tuple3;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.x$27;
    }

    private /* synthetic */ Tuple3 x$27() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.x$27$lzycompute() : this.x$27;
    }

    private DataType leftKeyType$lzycompute() {
        MapZipWith mapZipWith = this;
        synchronized (mapZipWith) {
            if ((this.bitmap$trans$0 & 1) == 0) {
                this.leftKeyType = (DataType)this.x$27()._1();
                this.bitmap$trans$0 |= 1;
            }
        }
        return this.leftKeyType;
    }

    public DataType leftKeyType() {
        return (this.bitmap$trans$0 & 1) == 0 ? this.leftKeyType$lzycompute() : this.leftKeyType;
    }

    private DataType leftValueType$lzycompute() {
        MapZipWith mapZipWith = this;
        synchronized (mapZipWith) {
            if ((this.bitmap$trans$0 & 2) == 0) {
                this.leftValueType = (DataType)this.x$27()._2();
                this.bitmap$trans$0 |= 2;
            }
        }
        return this.leftValueType;
    }

    public DataType leftValueType() {
        return (this.bitmap$trans$0 & 2) == 0 ? this.leftValueType$lzycompute() : this.leftValueType;
    }

    private boolean leftValueContainsNull$lzycompute() {
        MapZipWith mapZipWith = this;
        synchronized (mapZipWith) {
            if ((this.bitmap$trans$0 & 4) == 0) {
                this.leftValueContainsNull = BoxesRunTime.unboxToBoolean((Object)this.x$27()._3());
                this.bitmap$trans$0 |= 4;
            }
        }
        return this.leftValueContainsNull;
    }

    public boolean leftValueContainsNull() {
        return (this.bitmap$trans$0 & 4) == 0 ? this.leftValueContainsNull$lzycompute() : this.leftValueContainsNull;
    }

    private Tuple3<DataType, DataType, Object> x$28$lzycompute() {
        MapZipWith mapZipWith = this;
        synchronized (mapZipWith) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                DataType dataType = this.right().dataType();
                if (!(dataType instanceof MapType)) {
                    throw new MatchError((Object)dataType);
                }
                MapType mapType = (MapType)dataType;
                DataType rightKeyType = mapType.keyType();
                DataType rightValueType = mapType.valueType();
                boolean rightValueContainsNull = mapType.valueContainsNull();
                Tuple3 tuple3 = new Tuple3((Object)rightKeyType, (Object)rightValueType, (Object)BoxesRunTime.boxToBoolean((boolean)rightValueContainsNull));
                this.x$28 = tuple3;
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.x$28;
    }

    private /* synthetic */ Tuple3 x$28() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.x$28$lzycompute() : this.x$28;
    }

    private DataType rightKeyType$lzycompute() {
        MapZipWith mapZipWith = this;
        synchronized (mapZipWith) {
            if ((this.bitmap$trans$0 & 8) == 0) {
                this.rightKeyType = (DataType)this.x$28()._1();
                this.bitmap$trans$0 |= 8;
            }
        }
        return this.rightKeyType;
    }

    public DataType rightKeyType() {
        return (this.bitmap$trans$0 & 8) == 0 ? this.rightKeyType$lzycompute() : this.rightKeyType;
    }

    private DataType rightValueType$lzycompute() {
        MapZipWith mapZipWith = this;
        synchronized (mapZipWith) {
            if ((this.bitmap$trans$0 & 0x10) == 0) {
                this.rightValueType = (DataType)this.x$28()._2();
                this.bitmap$trans$0 |= 0x10;
            }
        }
        return this.rightValueType;
    }

    public DataType rightValueType() {
        return (this.bitmap$trans$0 & 0x10) == 0 ? this.rightValueType$lzycompute() : this.rightValueType;
    }

    private boolean rightValueContainsNull$lzycompute() {
        MapZipWith mapZipWith = this;
        synchronized (mapZipWith) {
            if ((this.bitmap$trans$0 & 0x20) == 0) {
                this.rightValueContainsNull = BoxesRunTime.unboxToBoolean((Object)this.x$28()._3());
                this.bitmap$trans$0 |= 0x20;
            }
        }
        return this.rightValueContainsNull;
    }

    public boolean rightValueContainsNull() {
        return (this.bitmap$trans$0 & 0x20) == 0 ? this.rightValueContainsNull$lzycompute() : this.rightValueContainsNull;
    }

    private DataType keyType$lzycompute() {
        MapZipWith mapZipWith = this;
        synchronized (mapZipWith) {
            if ((this.bitmap$trans$0 & 0x40) == 0) {
                this.keyType = (DataType)TypeCoercion$.MODULE$.findCommonTypeDifferentOnlyInNullFlags(this.leftKeyType(), this.rightKeyType()).get();
                this.bitmap$trans$0 |= 0x40;
            }
        }
        return this.keyType;
    }

    public DataType keyType() {
        return (this.bitmap$trans$0 & 0x40) == 0 ? this.keyType$lzycompute() : this.keyType;
    }

    private Ordering<Object> ordering$lzycompute() {
        MapZipWith mapZipWith = this;
        synchronized (mapZipWith) {
            if ((this.bitmap$trans$0 & 0x80) == 0) {
                this.ordering = TypeUtils$.MODULE$.getInterpretedOrdering(this.keyType());
                this.bitmap$trans$0 |= 0x80;
            }
        }
        return this.ordering;
    }

    public Ordering<Object> ordering() {
        return (this.bitmap$trans$0 & 0x80) == 0 ? this.ordering$lzycompute() : this.ordering;
    }

    @Override
    public Seq<Expression> arguments() {
        Expression expression = this.left();
        Expression expression2 = this.right();
        return package$.MODULE$.Nil().$colon$colon((Object)expression2).$colon$colon((Object)expression);
    }

    @Override
    public Seq<AbstractDataType> argumentTypes() {
        MapType$ mapType$ = MapType$.MODULE$;
        MapType$ mapType$2 = MapType$.MODULE$;
        return package$.MODULE$.Nil().$colon$colon((Object)mapType$2).$colon$colon((Object)mapType$);
    }

    @Override
    public Seq<Expression> functions() {
        Expression expression = this.function();
        return package$.MODULE$.Nil().$colon$colon((Object)expression);
    }

    @Override
    public Seq<AbstractDataType> functionTypes() {
        AnyDataType$ anyDataType$ = AnyDataType$.MODULE$;
        return package$.MODULE$.Nil().$colon$colon((Object)anyDataType$);
    }

    @Override
    public DataType dataType() {
        return new MapType(this.keyType(), this.function().dataType(), this.function().nullable());
    }

    @Override
    public MapZipWith bind(Function2<Expression, Seq<Tuple2<DataType, Object>>, LambdaFunction> f) {
        Seq arguments = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)this.keyType(), (Object)BoxesRunTime.boxToBoolean((boolean)false)), new Tuple2((Object)this.leftValueType(), (Object)BoxesRunTime.boxToBoolean((boolean)true)), new Tuple2((Object)this.rightValueType(), (Object)BoxesRunTime.boxToBoolean((boolean)true))}));
        LambdaFunction x$1 = (LambdaFunction)f.apply((Object)this.function(), (Object)arguments);
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        return this.copy(x$2, x$3, x$1);
    }

    @Override
    public TypeCheckResult checkArgumentDataTypes() {
        TypeCheckResult typeCheckResult = HigherOrderFunction.checkArgumentDataTypes$(this);
        TypeCheckResult typeCheckResult2 = TypeCheckResult$TypeCheckSuccess$.MODULE$.equals(typeCheckResult) ? (this.leftKeyType().sameType(this.rightKeyType()) ? TypeUtils$.MODULE$.checkForOrderingExpr(this.leftKeyType(), new StringBuilder(9).append("function ").append(this.prettyName()).toString()) : new TypeCheckResult.TypeCheckFailure(new StringBuilder(0).append(new StringBuilder(35).append("The input to function ").append(this.prettyName()).append(" should have ").toString()).append(new StringBuilder(60).append("been two ").append(MapType$.MODULE$.simpleString()).append("s with compatible key types, but the key types are ").toString()).append(new StringBuilder(5).append("[").append(this.leftKeyType().catalogString()).append(", ").append(this.rightKeyType().catalogString()).append("].").toString()).toString())) : typeCheckResult;
        return typeCheckResult2;
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return this.checkArgumentDataTypes();
    }

    @Override
    public Object eval(InternalRow input) {
        Object value2;
        Object value1 = this.left().eval(input);
        return value1 == null ? null : ((value2 = this.right().eval(input)) == null ? null : this.nullSafeEval(input, value1, value2));
    }

    private Tuple3<NamedLambdaVariable, NamedLambdaVariable, NamedLambdaVariable> x$29$lzycompute() {
        block5: {
            MapZipWith mapZipWith = this;
            synchronized (mapZipWith) {
                NamedLambdaVariable namedLambdaVariable;
                NamedLambdaVariable namedLambdaVariable2;
                NamedExpression value2Var;
                block7: {
                    Expression expression;
                    block6: {
                        SeqOps seqOps;
                        LambdaFunction lambdaFunction;
                        Seq<NamedExpression> seq;
                        if ((byte)(this.bitmap$0 & 4) != 0) break block5;
                        expression = this.function();
                        if (!(expression instanceof LambdaFunction) || (seq = (lambdaFunction = (LambdaFunction)expression).arguments()) == null || SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq(seq)) || new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) == null || SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 3) != 0) break block6;
                        NamedExpression keyVar = (NamedExpression)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
                        NamedExpression value1Var = (NamedExpression)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
                        value2Var = (NamedExpression)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2);
                        if (!(keyVar instanceof NamedLambdaVariable)) break block6;
                        namedLambdaVariable2 = (NamedLambdaVariable)keyVar;
                        if (!(value1Var instanceof NamedLambdaVariable)) break block6;
                        namedLambdaVariable = (NamedLambdaVariable)value1Var;
                        if (value2Var instanceof NamedLambdaVariable) break block7;
                    }
                    throw new MatchError((Object)expression);
                }
                NamedLambdaVariable namedLambdaVariable3 = (NamedLambdaVariable)value2Var;
                Tuple3 tuple3 = new Tuple3((Object)namedLambdaVariable2, (Object)namedLambdaVariable, (Object)namedLambdaVariable3);
                this.x$29 = tuple3;
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.x$29;
    }

    private /* synthetic */ Tuple3 x$29() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.x$29$lzycompute() : this.x$29;
    }

    private NamedLambdaVariable keyVar$lzycompute() {
        MapZipWith mapZipWith = this;
        synchronized (mapZipWith) {
            if ((this.bitmap$trans$0 & 0x100) == 0) {
                this.keyVar = (NamedLambdaVariable)this.x$29()._1();
                this.bitmap$trans$0 |= 0x100;
            }
        }
        return this.keyVar;
    }

    public NamedLambdaVariable keyVar() {
        return (this.bitmap$trans$0 & 0x100) == 0 ? this.keyVar$lzycompute() : this.keyVar;
    }

    private NamedLambdaVariable value1Var$lzycompute() {
        MapZipWith mapZipWith = this;
        synchronized (mapZipWith) {
            if ((this.bitmap$trans$0 & 0x200) == 0) {
                this.value1Var = (NamedLambdaVariable)this.x$29()._2();
                this.bitmap$trans$0 |= 0x200;
            }
        }
        return this.value1Var;
    }

    public NamedLambdaVariable value1Var() {
        return (this.bitmap$trans$0 & 0x200) == 0 ? this.value1Var$lzycompute() : this.value1Var;
    }

    private NamedLambdaVariable value2Var$lzycompute() {
        MapZipWith mapZipWith = this;
        synchronized (mapZipWith) {
            if ((this.bitmap$trans$0 & 0x400) == 0) {
                this.value2Var = (NamedLambdaVariable)this.x$29()._3();
                this.bitmap$trans$0 |= 0x400;
            }
        }
        return this.value2Var;
    }

    public NamedLambdaVariable value2Var() {
        return (this.bitmap$trans$0 & 0x400) == 0 ? this.value2Var$lzycompute() : this.value2Var;
    }

    private Function2<ArrayData, ArrayData, Iterable<Tuple2<Object, Option<Object>[]>>> getKeysWithValueIndexes$lzycompute() {
        MapZipWith mapZipWith = this;
        synchronized (mapZipWith) {
            if ((this.bitmap$trans$0 & 0x800) == 0) {
                this.getKeysWithValueIndexes = TypeUtils$.MODULE$.typeWithProperEquals(this.keyType()) ? (Function2 & Serializable)(keys1, keys2) -> this.getKeysWithIndexesFast((ArrayData)keys1, (ArrayData)keys2) : (Function2 & Serializable)(keys1, keys2) -> this.getKeysWithIndexesBruteForce((ArrayData)keys1, (ArrayData)keys2);
                this.bitmap$trans$0 |= 0x800;
            }
        }
        return this.getKeysWithValueIndexes;
    }

    private Function2<ArrayData, ArrayData, Iterable<Tuple2<Object, Option<Object>[]>>> getKeysWithValueIndexes() {
        return (this.bitmap$trans$0 & 0x800) == 0 ? this.getKeysWithValueIndexes$lzycompute() : this.getKeysWithValueIndexes;
    }

    private void assertSizeOfArrayBuffer(int size) {
        if (size > ByteArrayMethods.MAX_ROUNDED_ARRAY_LENGTH) {
            throw QueryExecutionErrors$.MODULE$.mapSizeExceedArraySizeWhenZipMapError(size);
        }
    }

    /*
     * WARNING - void declaration
     */
    private LinkedHashMap<Object, Option<Object>[]> getKeysWithIndexesFast(ArrayData keys1, ArrayData keys2) {
        void var3_3;
        LinkedHashMap hashMap = new LinkedHashMap();
        ArrayOps$.MODULE$.withFilter$extension(Predef$.MODULE$.refArrayOps((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToInteger((int)0), (Object)keys1), new Tuple2((Object)BoxesRunTime.boxToInteger((int)1), (Object)keys2)}), (Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)MapZipWith.$anonfun$getKeysWithIndexesFast$1(check$ifrefutable$1))).foreach((Function1 & Serializable)x$30 -> {
            MapZipWith.$anonfun$getKeysWithIndexesFast$2(this, hashMap, x$30);
            return BoxedUnit.UNIT;
        });
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private ArrayBuffer<Tuple2<Object, Option<Object>[]>> getKeysWithIndexesBruteForce(ArrayData keys1, ArrayData keys2) {
        void var3_3;
        ArrayBuffer arrayBuffer = new ArrayBuffer();
        ArrayOps$.MODULE$.withFilter$extension(Predef$.MODULE$.refArrayOps((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToInteger((int)0), (Object)keys1), new Tuple2((Object)BoxesRunTime.boxToInteger((int)1), (Object)keys2)}), (Function1 & Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)MapZipWith.$anonfun$getKeysWithIndexesBruteForce$1(check$ifrefutable$2))).foreach((Function1 & Serializable)x$32 -> {
            MapZipWith.$anonfun$getKeysWithIndexesBruteForce$2(this, arrayBuffer, x$32);
            return BoxedUnit.UNIT;
        });
        return var3_3;
    }

    private Object nullSafeEval(InternalRow inputRow, Object value1, Object value2) {
        MapData mapData1 = (MapData)value1;
        MapData mapData2 = (MapData)value2;
        Iterable keysWithIndexes = (Iterable)this.getKeysWithValueIndexes().apply((Object)mapData1.keyArray(), (Object)mapData2.keyArray());
        int size = keysWithIndexes.size();
        GenericArrayData keys = new GenericArrayData(new Object[size]);
        GenericArrayData values = new GenericArrayData(new Object[size]);
        ArrayData valueData1 = mapData1.valueArray();
        ArrayData valueData2 = mapData2.valueArray();
        IntRef i = IntRef.create((int)0);
        keysWithIndexes.withFilter((Function1 & Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean((boolean)MapZipWith.$anonfun$nullSafeEval$2(check$ifrefutable$3))).foreach((Function1 & Serializable)x$35 -> {
            MapZipWith.$anonfun$nullSafeEval$3(this, valueData1, valueData2, keys, i, inputRow, values, x$35);
            return BoxedUnit.UNIT;
        });
        return new ArrayBasedMapData(keys, values);
    }

    @Override
    public String prettyName() {
        return "map_zip_with";
    }

    @Override
    public Expression first() {
        return this.left();
    }

    @Override
    public Expression second() {
        return this.right();
    }

    @Override
    public Expression third() {
        return this.function();
    }

    @Override
    public MapZipWith withNewChildrenInternal(Expression newFirst, Expression newSecond, Expression newThird) {
        return this.copy(newFirst, newSecond, newThird);
    }

    public MapZipWith copy(Expression left, Expression right, Expression function) {
        return new MapZipWith(left, right, function);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    public Expression copy$default$3() {
        return this.function();
    }

    @Override
    public String productPrefix() {
        return "MapZipWith";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.left();
                break;
            }
            case 1: {
                object = this.right();
                break;
            }
            case 2: {
                object = this.function();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof MapZipWith;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "left";
                break;
            }
            case 1: {
                string = "right";
                break;
            }
            case 2: {
                string = "function";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof MapZipWith)) return false;
        boolean bl = true;
        if (!bl) return false;
        MapZipWith mapZipWith = (MapZipWith)x$1;
        Expression expression = this.left();
        Expression expression2 = mapZipWith.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = mapZipWith.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.function();
        Expression expression6 = mapZipWith.function();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!mapZipWith.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$getKeysWithIndexesFast$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$getKeysWithIndexesFast$2(MapZipWith $this, LinkedHashMap hashMap$1, Tuple2 x$30) {
        Tuple2 tuple2 = x$30;
        if (tuple2 != null) {
            int z = tuple2._1$mcI$sp();
            ArrayData array = (ArrayData)tuple2._2();
            for (int i = 0; i < array.numElements(); ++i) {
                BoxedUnit boxedUnit;
                Object key = array.get(i, $this.keyType());
                Option option = hashMap$1.get(key);
                if (option instanceof Some) {
                    BoxedUnit boxedUnit2;
                    Some some = (Some)option;
                    Option[] indexes = (Option[])some.value();
                    if (indexes[z].isEmpty()) {
                        indexes[z] = new Some((Object)BoxesRunTime.boxToInteger((int)i));
                        boxedUnit2 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit2 = BoxedUnit.UNIT;
                    }
                    boxedUnit = boxedUnit2;
                    continue;
                }
                if (None$.MODULE$.equals(option)) {
                    Option[] indexes = (Option[])((Object[])new Option[]{None$.MODULE$, None$.MODULE$});
                    indexes[z] = new Some((Object)BoxesRunTime.boxToInteger((int)i));
                    boxedUnit = hashMap$1.put(key, (Object)indexes);
                    continue;
                }
                throw new MatchError((Object)option);
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$getKeysWithIndexesBruteForce$1(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$getKeysWithIndexesBruteForce$2(MapZipWith $this, ArrayBuffer arrayBuffer$1, Tuple2 x$32) {
        Tuple2 tuple2 = x$32;
        if (tuple2 != null) {
            int z = tuple2._1$mcI$sp();
            ArrayData array = (ArrayData)tuple2._2();
            for (int i = 0; i < array.numElements(); ++i) {
                BoxedUnit boxedUnit;
                Object key = array.get(i, $this.keyType());
                boolean found = false;
                for (int j = 0; !found && j < arrayBuffer$1.size(); ++j) {
                    Tuple2 tuple22 = (Tuple2)arrayBuffer$1.apply(j);
                    if (tuple22 == null) {
                        throw new MatchError((Object)tuple22);
                    }
                    Object bufferKey = tuple22._1();
                    Option[] indexes = (Option[])tuple22._2();
                    Tuple2 tuple23 = new Tuple2(bufferKey, (Object)indexes);
                    Tuple2 tuple24 = tuple23;
                    Object bufferKey2 = tuple24._1();
                    Option[] indexes2 = (Option[])tuple24._2();
                    if (!$this.ordering().equiv(bufferKey2, key)) continue;
                    found = true;
                    if (!indexes2[z].isEmpty()) continue;
                    indexes2[z] = new Some((Object)BoxesRunTime.boxToInteger((int)i));
                }
                if (!found) {
                    $this.assertSizeOfArrayBuffer(arrayBuffer$1.size());
                    Option[] indexes = (Option[])((Object[])new Option[]{None$.MODULE$, None$.MODULE$});
                    indexes[z] = new Some((Object)BoxesRunTime.boxToInteger((int)i));
                    boxedUnit = arrayBuffer$1.$plus$eq((Object)new Tuple2(key, (Object)indexes));
                    continue;
                }
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$nullSafeEval$2(Tuple2 check$ifrefutable$3) {
        Object object;
        Option[] optionArray;
        Tuple2 tuple2 = check$ifrefutable$3;
        boolean bl = tuple2 != null && (optionArray = (Option[])tuple2._2()) != null && !Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq((Object)optionArray)) && new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object)) != null && Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 2) == 0;
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ void $anonfun$nullSafeEval$3(MapZipWith $this, ArrayData valueData1$1, ArrayData valueData2$1, GenericArrayData keys$1, IntRef i$1, InternalRow inputRow$3, GenericArrayData values$1, Tuple2 x$35) {
        Object object;
        Tuple2 tuple2 = x$35;
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        Object key = tuple2._1();
        Option[] optionArray = (Option[])tuple2._2();
        if (optionArray == null || Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq((Object)optionArray)) || new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object)) == null || Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 2) != 0) throw new MatchError((Object)tuple2);
        Option index1 = (Option)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 0);
        Option index2 = (Option)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 1);
        Object v1 = index1.map((Function1 & Serializable)x$33 -> valueData1$1.get(BoxesRunTime.unboxToInt((Object)x$33), $this.leftValueType())).getOrElse((Function0 & Serializable)() -> null);
        Object v2 = index2.map((Function1 & Serializable)x$34 -> valueData2$1.get(BoxesRunTime.unboxToInt((Object)x$34), $this.rightValueType())).getOrElse((Function0 & Serializable)() -> null);
        $this.keyVar().value().set(key);
        $this.value1Var().value().set(v1);
        $this.value2Var().value().set(v2);
        keys$1.update(i$1.elem, key);
        Object v = InternalRow$.MODULE$.copyValue($this.functionForEval().eval(inputRow$3));
        values$1.update(i$1.elem, v);
        ++i$1.elem;
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public MapZipWith(Expression left, Expression right, Expression function) {
        this.left = left;
        this.right = right;
        this.function = function;
        ExpectsInputTypes.$init$(this);
        HigherOrderFunction.$init$(this);
        CodegenFallback.$init$(this);
        TernaryLike.$init$(this);
        Statics.releaseFence();
    }
}

