/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.NaNvl$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.TypeCollection;
import org.apache.spark.sql.types.TypeCollection$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Product;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(expr1, expr2) - Returns `expr1` if it's not NaN, or `expr2` otherwise.", examples="\n    Examples:\n      > SELECT _FUNC_(cast('NaN' as double), 123);\n       123.0\n  ", since="1.5.0", group="conditional_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005mg\u0001\u0002\u000f\u001e\u0001*B\u0001\u0002\u0012\u0001\u0003\u0016\u0004%\t!\u0012\u0005\t\u0013\u0002\u0011\t\u0012)A\u0005\r\"A!\n\u0001BK\u0002\u0013\u0005Q\t\u0003\u0005L\u0001\tE\t\u0015!\u0003G\u0011\u0015a\u0005\u0001\"\u0001N\u0011\u0015\t\u0006\u0001\"\u0011S\u0011\u0015I\u0006\u0001\"\u0011[\u0011\u0015\t\u0007\u0001\"\u0011c\u0011\u0015a\u0007\u0001\"\u0011n\u0011\u0015Y\b\u0001\"\u0015}\u0011%\t\u0019\u0001AA\u0001\n\u0003\t)\u0001C\u0005\u0002\f\u0001\t\n\u0011\"\u0001\u0002\u000e!I\u00111\u0005\u0001\u0012\u0002\u0013\u0005\u0011Q\u0002\u0005\n\u0003K\u0001\u0011\u0011!C!\u0003OA\u0011\"!\u000f\u0001\u0003\u0003%\t!a\u000f\t\u0013\u0005\r\u0003!!A\u0005\u0002\u0005\u0015\u0003\"CA&\u0001\u0005\u0005I\u0011IA'\u0011%\tY\u0006AA\u0001\n\u0003\ti\u0006C\u0005\u0002h\u0001\t\t\u0011\"\u0011\u0002j!I\u0011Q\u000e\u0001\u0002\u0002\u0013\u0005\u0013qN\u0004\n\u0003'k\u0012\u0011!E\u0001\u0003+3\u0001\u0002H\u000f\u0002\u0002#\u0005\u0011q\u0013\u0005\u0007\u0019Z!\t!a,\t\u0013\u0005Ef#!A\u0005F\u0005M\u0006\"CA[-\u0005\u0005I\u0011QA\\\u0011%\tiLFA\u0001\n\u0003\u000by\fC\u0005\u0002RZ\t\t\u0011\"\u0003\u0002T\n)a*\u0019(wY*\u0011adH\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002!C\u0005A1-\u0019;bYf\u001cHO\u0003\u0002#G\u0005\u00191/\u001d7\u000b\u0005\u0011*\u0013!B:qCJ\\'B\u0001\u0014(\u0003\u0019\t\u0007/Y2iK*\t\u0001&A\u0002pe\u001e\u001c\u0001aE\u0003\u0001W=\u0012\u0004\b\u0005\u0002-[5\tQ$\u0003\u0002/;\t\u0001\")\u001b8bef,\u0005\u0010\u001d:fgNLwN\u001c\t\u0003YAJ!!M\u000f\u0003-%k\u0007\u000f\\5dSR\u001c\u0015m\u001d;J]B,H\u000fV=qKN\u0004\"a\r\u001c\u000e\u0003QR\u0011!N\u0001\u0006g\u000e\fG.Y\u0005\u0003oQ\u0012q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002:\u0003:\u0011!h\u0010\b\u0003wyj\u0011\u0001\u0010\u0006\u0003{%\na\u0001\u0010:p_Rt\u0014\"A\u001b\n\u0005\u0001#\u0014a\u00029bG.\fw-Z\u0005\u0003\u0005\u000e\u0013AbU3sS\u0006d\u0017N_1cY\u0016T!\u0001\u0011\u001b\u0002\t1,g\r^\u000b\u0002\rB\u0011AfR\u0005\u0003\u0011v\u0011!\"\u0012=qe\u0016\u001c8/[8o\u0003\u0015aWM\u001a;!\u0003\u0015\u0011\u0018n\u001a5u\u0003\u0019\u0011\u0018n\u001a5uA\u00051A(\u001b8jiz\"2AT(Q!\ta\u0003\u0001C\u0003E\u000b\u0001\u0007a\tC\u0003K\u000b\u0001\u0007a)\u0001\u0005eCR\fG+\u001f9f+\u0005\u0019\u0006C\u0001+X\u001b\u0005)&B\u0001,\"\u0003\u0015!\u0018\u0010]3t\u0013\tAVK\u0001\u0005ECR\fG+\u001f9f\u0003)Ig\u000e];u)f\u0004Xm]\u000b\u00027B\u0019\u0011\b\u00180\n\u0005u\u001b%aA*fcB\u0011AkX\u0005\u0003AV\u0013\u0001#\u00112tiJ\f7\r\u001e#bi\u0006$\u0016\u0010]3\u0002\t\u00154\u0018\r\u001c\u000b\u0003G\u001a\u0004\"a\r3\n\u0005\u0015$$aA!os\"9q\r\u0003I\u0001\u0002\u0004A\u0017!B5oaV$\bCA5k\u001b\u0005y\u0012BA6 \u0005-Ie\u000e^3s]\u0006d'k\\<\u0002\u0013\u0011|w)\u001a8D_\u0012,Gc\u00018usB\u0011qN]\u0007\u0002a*\u0011\u0011/H\u0001\bG>$WmZ3o\u0013\t\u0019\bO\u0001\u0005FqB\u00148i\u001c3f\u0011\u0015)\u0018\u00021\u0001w\u0003\r\u0019G\u000f\u001f\t\u0003_^L!\u0001\u001f9\u0003\u001d\r{G-Z4f]\u000e{g\u000e^3yi\")!0\u0003a\u0001]\u0006\u0011QM^\u0001\u0018o&$\bNT3x\u0007\"LG\u000e\u001a:f]&sG/\u001a:oC2$2AT?\u0000\u0011\u0015q(\u00021\u0001G\u0003\u001dqWm\u001e'fMRDa!!\u0001\u000b\u0001\u00041\u0015\u0001\u00038foJKw\r\u001b;\u0002\t\r|\u0007/\u001f\u000b\u0006\u001d\u0006\u001d\u0011\u0011\u0002\u0005\b\t.\u0001\n\u00111\u0001G\u0011\u001dQ5\u0002%AA\u0002\u0019\u000babY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002\u0010)\u001aa)!\u0005,\u0005\u0005M\u0001\u0003BA\u000b\u0003?i!!a\u0006\u000b\t\u0005e\u00111D\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\b5\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003C\t9BA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003S\u0001B!a\u000b\u000265\u0011\u0011Q\u0006\u0006\u0005\u0003_\t\t$\u0001\u0003mC:<'BAA\u001a\u0003\u0011Q\u0017M^1\n\t\u0005]\u0012Q\u0006\u0002\u0007'R\u0014\u0018N\\4\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005u\u0002cA\u001a\u0002@%\u0019\u0011\u0011\t\u001b\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\u0007\r\f9\u0005C\u0005\u0002JA\t\t\u00111\u0001\u0002>\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!a\u0014\u0011\u000b\u0005E\u0013qK2\u000e\u0005\u0005M#bAA+i\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005e\u00131\u000b\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002`\u0005\u0015\u0004cA\u001a\u0002b%\u0019\u00111\r\u001b\u0003\u000f\t{w\u000e\\3b]\"A\u0011\u0011\n\n\u0002\u0002\u0003\u00071-\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003BA\u0015\u0003WB\u0011\"!\u0013\u0014\u0003\u0003\u0005\r!!\u0010\u0002\r\u0015\fX/\u00197t)\u0011\ty&!\u001d\t\u0011\u0005%C#!AA\u0002\rD3\u0003AA;\u0003w\ni(!!\u0002\u0004\u0006\u001d\u0015\u0011RAG\u0003\u001f\u00032\u0001LA<\u0013\r\tI(\b\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\ty(A'`\rVs5i\u0018\u0015fqB\u0014\u0018\u0007\f\u0011fqB\u0014('\u000b\u0011.AI+G/\u001e:og\u0002\u0002W\r\u001f9sc\u0001\u0004\u0013N\u001a\u0011ji\u001e\u001a\bE\\8uA9\u000bg\n\f\u0011pe\u0002\u0002W\r\u001f9se\u0001\u0004s\u000e\u001e5fe^L7/\u001a\u0018\u0002\u0011\u0015D\u0018-\u001c9mKN\f#!!\"\u0002#*\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~C3-Y:uQ\u001dr\u0015MT\u0014!CN\u0004Cm\\;cY\u0016LC\u0006I\u00193g%Z$\u0002\t\u0011!A\u0001\u0002\u0003%\r\u001a4]AR\u0001\u0005I\u0001\u0006g&t7-Z\u0011\u0003\u0003\u0017\u000bQ!\r\u00186]A\nQa\u001a:pkB\f#!!%\u0002#\r|g\u000eZ5uS>t\u0017\r\\0gk:\u001c7/A\u0003OC:3H\u000e\u0005\u0002--M)a#!'\u0002&B9\u00111TAQ\r\u001asUBAAO\u0015\r\ty\nN\u0001\beVtG/[7f\u0013\u0011\t\u0019+!(\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t'\u0007\u0005\u0003\u0002(\u00065VBAAU\u0015\u0011\tY+!\r\u0002\u0005%|\u0017b\u0001\"\u0002*R\u0011\u0011QS\u0001\ti>\u001cFO]5oOR\u0011\u0011\u0011F\u0001\u0006CB\u0004H.\u001f\u000b\u0006\u001d\u0006e\u00161\u0018\u0005\u0006\tf\u0001\rA\u0012\u0005\u0006\u0015f\u0001\rAR\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\t\t-!4\u0011\u000bM\n\u0019-a2\n\u0007\u0005\u0015GG\u0001\u0004PaRLwN\u001c\t\u0006g\u0005%gIR\u0005\u0004\u0003\u0017$$A\u0002+va2,'\u0007\u0003\u0005\u0002Pj\t\t\u00111\u0001O\u0003\rAH\u0005M\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u0003+\u0004B!a\u000b\u0002X&!\u0011\u0011\\A\u0017\u0005\u0019y%M[3di\u0002")
public class NaNvl
extends BinaryExpression
implements ImplicitCastInputTypes,
Serializable {
    private final Expression left;
    private final Expression right;

    public static Option<Tuple2<Expression, Expression>> unapply(NaNvl naNvl) {
        return NaNvl$.MODULE$.unapply(naNvl);
    }

    public static Function1<Tuple2<Expression, Expression>, NaNvl> tupled() {
        return NaNvl$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, NaNvl>> curried() {
        return NaNvl$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public DataType dataType() {
        return this.left().dataType();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TypeCollection[]{TypeCollection$.MODULE$.apply((Seq<AbstractDataType>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{DoubleType$.MODULE$, FloatType$.MODULE$})), TypeCollection$.MODULE$.apply((Seq<AbstractDataType>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{DoubleType$.MODULE$, FloatType$.MODULE$}))}));
    }

    @Override
    public Object eval(InternalRow input) {
        Object object;
        Object value = this.left().eval(input);
        if (value == null) {
            object = null;
        } else {
            Object object2;
            DataType dataType = this.left().dataType();
            if (DoubleType$.MODULE$.equals(dataType)) {
                object2 = !Double.isNaN(BoxesRunTime.unboxToDouble((Object)value)) ? value : this.right().eval(input);
            } else if (FloatType$.MODULE$.equals(dataType)) {
                object2 = !Float.isNaN(BoxesRunTime.unboxToFloat((Object)value)) ? value : this.right().eval(input);
            } else {
                throw new MatchError((Object)dataType);
            }
            object = object2;
        }
        return object;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode leftGen = this.left().genCode(ctx);
        ExprCode rightGen = this.right().genCode(ctx);
        DataType dataType = this.left().dataType();
        boolean bl = DoubleType$.MODULE$.equals(dataType) ? true : FloatType$.MODULE$.equals(dataType);
        if (!bl) {
            throw new MatchError((Object)dataType);
        }
        ExprCode exprCode = ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n          ", "\n          boolean ", " = false;\n          ", " ", " = ", ";\n          if (", ") {\n            ", " = true;\n          } else {\n            if (!Double.isNaN(", ")) {\n              ", " = ", ";\n            } else {\n              ", "\n              if (", ") {\n                ", " = true;\n              } else {\n                ", " = ", ";\n              }\n            }\n          }"}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{leftGen.code(), ev.isNull(), CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), CodeGenerator$.MODULE$.defaultValue(this.dataType(), CodeGenerator$.MODULE$.defaultValue$default$2()), leftGen.isNull(), ev.isNull(), leftGen.value(), ev.value(), leftGen.value(), rightGen.code(), rightGen.isNull(), ev.isNull(), ev.value(), rightGen.value()})), ev.copy$default$2(), ev.copy$default$3());
        return exprCode;
    }

    @Override
    public NaNvl withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    public NaNvl copy(Expression left, Expression right) {
        return new NaNvl(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "NaNvl";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.left();
                break;
            }
            case 1: {
                object = this.right();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof NaNvl;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "left";
                break;
            }
            case 1: {
                string = "right";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof NaNvl)) return false;
        boolean bl = true;
        if (!bl) return false;
        NaNvl naNvl = (NaNvl)x$1;
        Expression expression = this.left();
        Expression expression2 = naNvl.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = naNvl.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!naNvl.canEqual(this)) return false;
        return true;
    }

    public NaNvl(Expression left, Expression right) {
        this.left = left;
        this.right = right;
        ExpectsInputTypes.$init$(this);
    }
}

