/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.aggregate;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.UnsafeArrayData;
import org.apache.spark.sql.catalyst.expressions.aggregate.Collect;
import org.apache.spark.sql.catalyst.expressions.aggregate.CollectSet$;
import org.apache.spark.sql.catalyst.expressions.aggregate.ImperativeAggregate;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(expr) - Collects and returns a set of unique elements.", examples="\n    Examples:\n      > SELECT _FUNC_(col) FROM VALUES (1), (2), (1) AS tab(col);\n       [1,2]\n  ", note="\n    The function is non-deterministic because the order of collected results depends\n    on the order of the rows which may be non-deterministic after a shuffle.\n  ", group="agg_funcs", since="2.0.0")
@ScalaSignature(bytes="\u0006\u0005\t-b\u0001\u0002\u0015*\u0001bB\u0001B\u0017\u0001\u0003\u0016\u0004%\ta\u0017\u0005\tA\u0002\u0011\t\u0012)A\u00059\"A\u0011\r\u0001BK\u0002\u0013\u0005!\r\u0003\u0005g\u0001\tE\t\u0015!\u0003d\u0011!9\u0007A!f\u0001\n\u0003\u0011\u0007\u0002\u00035\u0001\u0005#\u0005\u000b\u0011B2\t\u000b%\u0004A\u0011\u00016\t\u000b%\u0004A\u0011A8\t\u0011E\u0004\u0001R1A\u0005BIDQ!\u001f\u0001\u0005BiDQ! \u0001\u0005ByDq!a\u0001\u0001\t\u0003\n)\u0001C\u0004\u0002\u0014\u0001!\t%!\u0006\t\u000f\u0005\u0005\u0002\u0001\"\u0011\u0002$!9\u0011\u0011\u0006\u0001\u0005B\u0005-\u0002bBA\u001f\u0001\u0011\u0005\u0013q\b\u0005\b\u0003\u0003\u0002A\u0011KA\"\u0011%\tI\u0005AA\u0001\n\u0003\tY\u0005C\u0005\u0002T\u0001\t\n\u0011\"\u0001\u0002V!I\u00111\u000e\u0001\u0012\u0002\u0013\u0005\u0011Q\u000e\u0005\n\u0003c\u0002\u0011\u0013!C\u0001\u0003[B\u0011\"a\u001d\u0001\u0003\u0003%\t%!\u001e\t\u0011\u0005\u0015\u0005!!A\u0005\u0002\tD\u0011\"a\"\u0001\u0003\u0003%\t!!#\t\u0013\u0005=\u0005!!A\u0005B\u0005E\u0005\"CAN\u0001\u0005\u0005I\u0011AAO\u0011%\t9\u000bAA\u0001\n\u0003\nI\u000bC\u0005\u0002.\u0002\t\t\u0011\"\u0011\u00020\u001eI\u0011\u0011\\\u0015\u0002\u0002#\u0005\u00111\u001c\u0004\tQ%\n\t\u0011#\u0001\u0002^\"1\u0011N\bC\u0001\u0003kD\u0011\"a>\u001f\u0003\u0003%)%!?\t\u0013\u0005mh$!A\u0005\u0002\u0006u\b\"\u0003B\u0003=E\u0005I\u0011AA7\u0011%\u00119AHI\u0001\n\u0003\ti\u0007C\u0005\u0003\ny\t\t\u0011\"!\u0003\f!I!Q\u0004\u0010\u0012\u0002\u0013\u0005\u0011Q\u000e\u0005\n\u0005?q\u0012\u0013!C\u0001\u0003[B\u0011B!\t\u001f\u0003\u0003%IAa\t\u0003\u0015\r{G\u000e\\3diN+GO\u0003\u0002+W\u0005I\u0011mZ4sK\u001e\fG/\u001a\u0006\u0003Y5\n1\"\u001a=qe\u0016\u001c8/[8og*\u0011afL\u0001\tG\u0006$\u0018\r\\=ti*\u0011\u0001'M\u0001\u0004gFd'B\u0001\u001a4\u0003\u0015\u0019\b/\u0019:l\u0015\t!T'\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002m\u0005\u0019qN]4\u0004\u0001M!\u0001!O&O!\rQ4(P\u0007\u0002S%\u0011A(\u000b\u0002\b\u0007>dG.Z2u!\rqTiR\u0007\u0002\u007f)\u0011\u0001)Q\u0001\b[V$\u0018M\u00197f\u0015\t\u00115)\u0001\u0006d_2dWm\u0019;j_:T\u0011\u0001R\u0001\u0006g\u000e\fG.Y\u0005\u0003\r~\u0012q\u0001S1tQN+G\u000f\u0005\u0002I\u00136\t1)\u0003\u0002K\u0007\n\u0019\u0011I\\=\u0011\u0005!c\u0015BA'D\u0005\u001d\u0001&o\u001c3vGR\u0004\"aT,\u000f\u0005A+fBA)U\u001b\u0005\u0011&BA*8\u0003\u0019a$o\\8u}%\tA)\u0003\u0002W\u0007\u00069\u0001/Y2lC\u001e,\u0017B\u0001-Z\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\t16)A\u0003dQ&dG-F\u0001]!\tif,D\u0001,\u0013\ty6F\u0001\u0006FqB\u0014Xm]:j_:\faa\u00195jY\u0012\u0004\u0013AF7vi\u0006\u0014G.Z!hO\n+hMZ3s\u001f\u001a47/\u001a;\u0016\u0003\r\u0004\"\u0001\u00133\n\u0005\u0015\u001c%aA%oi\u00069R.\u001e;bE2,\u0017iZ4Ck\u001a4WM](gMN,G\u000fI\u0001\u0015S:\u0004X\u000f^!hO\n+hMZ3s\u001f\u001a47/\u001a;\u0002+%t\u0007/\u001e;BO\u001e\u0014UO\u001a4fe>3gm]3uA\u00051A(\u001b8jiz\"Ba\u001b7n]B\u0011!\b\u0001\u0005\u00065\u001e\u0001\r\u0001\u0018\u0005\bC\u001e\u0001\n\u00111\u0001d\u0011\u001d9w\u0001%AA\u0002\r$\"a\u001b9\t\u000biC\u0001\u0019\u0001/\u0002#\t,hMZ3s\u000b2,W.\u001a8u)f\u0004X-F\u0001t!\t!x/D\u0001v\u0015\t1x&A\u0003usB,7/\u0003\u0002yk\nAA)\u0019;b)f\u0004X-\u0001\fd_:4XM\u001d;U_\n+hMZ3s\u000b2,W.\u001a8u)\t95\u0010C\u0003}\u0015\u0001\u0007q)A\u0003wC2,X-\u0001\u0003fm\u0006dGCA$\u0000\u0011\u0019\t\ta\u0003a\u0001{\u00051!-\u001e4gKJ\f1c\u00195fG.Le\u000e];u\t\u0006$\u0018\rV=qKN$\"!a\u0002\u0011\t\u0005%\u0011qB\u0007\u0003\u0003\u0017Q1!!\u0004.\u0003!\tg.\u00197zg&\u001c\u0018\u0002BA\t\u0003\u0017\u0011q\u0002V=qK\u000eCWmY6SKN,H\u000e^\u0001\u001eo&$\bNT3x\u001bV$\u0018M\u00197f\u0003\u001e<')\u001e4gKJ|eMZ:fiR!\u0011qCA\u000f!\rQ\u0014\u0011D\u0005\u0004\u00037I#aE%na\u0016\u0014\u0018\r^5wK\u0006;wM]3hCR,\u0007BBA\u0010\u001b\u0001\u00071-A\roK^lU\u000f^1cY\u0016\fum\u001a\"vM\u001a,'o\u00144gg\u0016$\u0018aG<ji\"tUm^%oaV$\u0018iZ4Ck\u001a4WM](gMN,G\u000f\u0006\u0003\u0002\u0018\u0005\u0015\u0002BBA\u0014\u001d\u0001\u00071-A\foK^Le\u000e];u\u0003\u001e<')\u001e4gKJ|eMZ:fi\u0006Q\u0001O]3uift\u0015-\\3\u0016\u0005\u00055\u0002\u0003BA\u0018\u0003oqA!!\r\u00024A\u0011\u0011kQ\u0005\u0004\u0003k\u0019\u0015A\u0002)sK\u0012,g-\u0003\u0003\u0002:\u0005m\"AB*ue&twMC\u0002\u00026\r\u000bqc\u0019:fCR,\u0017iZ4sK\u001e\fG/[8o\u0005V4g-\u001a:\u0015\u0003u\nAc^5uQ:+wo\u00115jY\u0012Le\u000e^3s]\u0006dGcA6\u0002F!1\u0011qI\tA\u0002q\u000b\u0001B\\3x\u0007\"LG\u000eZ\u0001\u0005G>\u0004\u0018\u0010F\u0004l\u0003\u001b\ny%!\u0015\t\u000fi\u0013\u0002\u0013!a\u00019\"9\u0011M\u0005I\u0001\u0002\u0004\u0019\u0007bB4\u0013!\u0003\u0005\raY\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\t9FK\u0002]\u00033Z#!a\u0017\u0011\t\u0005u\u0013qM\u0007\u0003\u0003?RA!!\u0019\u0002d\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003K\u001a\u0015AC1o]>$\u0018\r^5p]&!\u0011\u0011NA0\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\tyGK\u0002d\u00033\nabY8qs\u0012\"WMZ1vYR$3'A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003o\u0002B!!\u001f\u0002\u00046\u0011\u00111\u0010\u0006\u0005\u0003{\ny(\u0001\u0003mC:<'BAAA\u0003\u0011Q\u0017M^1\n\t\u0005e\u00121P\u0001\raJ|G-^2u\u0003JLG/_\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\r9\u00151\u0012\u0005\t\u0003\u001bC\u0012\u0011!a\u0001G\u0006\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!a%\u0011\u000b\u0005U\u0015qS$\u000e\u0003\u0005K1!!'B\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005}\u0015Q\u0015\t\u0004\u0011\u0006\u0005\u0016bAAR\u0007\n9!i\\8mK\u0006t\u0007\u0002CAG5\u0005\u0005\t\u0019A$\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0005\u0003o\nY\u000b\u0003\u0005\u0002\u000en\t\t\u00111\u0001d\u0003\u0019)\u0017/^1mgR!\u0011qTAY\u0011!\ti\tHA\u0001\u0002\u00049\u0005f\u0006\u0001\u00026\u0006m\u0016QXAa\u0003\u0007\f9-!3\u0002N\u0006=\u00171[Ak!\ri\u0016qW\u0005\u0004\u0003s[#!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0003\u007f\u000bQh\u0018$V\u001d\u000e{\u0006&\u001a=qe&\u0002S\u0006I\"pY2,7\r^:!C:$\u0007E]3ukJt7\u000fI1!g\u0016$\be\u001c4!k:L\u0017/^3!K2,W.\u001a8ug:\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0003\u000b\f\u0001M\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015d_2L\u0003E\u0012*P\u001b\u00022\u0016\tT+F'\u0002B\u0013'\u000b\u0017!QIJC\u0006\t\u00152S\u0001\n5\u000b\t;bE\"\u001aw\u000e\\\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!Am\u000bDFM/\u000bA\u0001\nAA\\8uK\u0006\u0012\u00111Z\u0001\u0002L)\u0001\u0003\u0005\t\u0011UQ\u0016\u0004c-\u001e8di&|g\u000eI5tA9|g.\f3fi\u0016\u0014X.\u001b8jgRL7\r\t2fG\u0006,8/\u001a\u0011uQ\u0016\u0004sN\u001d3fe\u0002zg\rI2pY2,7\r^3eAI,7/\u001e7ug\u0002\"W\r]3oINT\u0001\u0005\t\u0011!_:\u0004C\u000f[3!_J$WM\u001d\u0011pM\u0002\"\b.\u001a\u0011s_^\u001c\be\u001e5jG\"\u0004S.Y=!E\u0016\u0004cn\u001c8.I\u0016$XM]7j]&\u001cH/[2!C\u001a$XM\u001d\u0011bAMDWO\u001a4mK:R\u0001\u0005I\u0001\u0006OJ|W\u000f]\u0011\u0003\u0003#\f\u0011\"Y4h?\u001a,hnY:\u0002\u000bMLgnY3\"\u0005\u0005]\u0017!\u0002\u001a/a9\u0002\u0014AC\"pY2,7\r^*fiB\u0011!HH\n\u0006=\u0005}\u00171\u001e\t\t\u0003C\f9\u000fX2dW6\u0011\u00111\u001d\u0006\u0004\u0003K\u001c\u0015a\u0002:v]RLW.Z\u0005\u0005\u0003S\f\u0019OA\tBEN$(/Y2u\rVt7\r^5p]N\u0002B!!<\u0002t6\u0011\u0011q\u001e\u0006\u0005\u0003c\fy(\u0001\u0002j_&\u0019\u0001,a<\u0015\u0005\u0005m\u0017\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005]\u0014!B1qa2LHcB6\u0002\u0000\n\u0005!1\u0001\u0005\u00065\u0006\u0002\r\u0001\u0018\u0005\bC\u0006\u0002\n\u00111\u0001d\u0011\u001d9\u0017\u0005%AA\u0002\r\fq\"\u00199qYf$C-\u001a4bk2$HEM\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%g\u00059QO\\1qa2LH\u0003\u0002B\u0007\u00053\u0001R\u0001\u0013B\b\u0005'I1A!\u0005D\u0005\u0019y\u0005\u000f^5p]B1\u0001J!\u0006]G\u000eL1Aa\u0006D\u0005\u0019!V\u000f\u001d7fg!A!1\u0004\u0013\u0002\u0002\u0003\u00071.A\u0002yIA\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u0012\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$3'\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0003&A!\u0011\u0011\u0010B\u0014\u0013\u0011\u0011I#a\u001f\u0003\r=\u0013'.Z2u\u0001")
public class CollectSet
extends Collect<HashSet<Object>>
implements Serializable {
    private DataType bufferElementType;
    private final Expression child;
    private final int mutableAggBufferOffset;
    private final int inputAggBufferOffset;
    private volatile boolean bitmap$0;

    public static int $lessinit$greater$default$3() {
        return CollectSet$.MODULE$.$lessinit$greater$default$3();
    }

    public static int $lessinit$greater$default$2() {
        return CollectSet$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple3<Expression, Object, Object>> unapply(CollectSet collectSet) {
        return CollectSet$.MODULE$.unapply(collectSet);
    }

    public static int apply$default$3() {
        return CollectSet$.MODULE$.apply$default$3();
    }

    public static int apply$default$2() {
        return CollectSet$.MODULE$.apply$default$2();
    }

    public static Function1<Tuple3<Expression, Object, Object>, CollectSet> tupled() {
        return CollectSet$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Object, Function1<Object, CollectSet>>> curried() {
        return CollectSet$.MODULE$.curried();
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public int mutableAggBufferOffset() {
        return this.mutableAggBufferOffset;
    }

    @Override
    public int inputAggBufferOffset() {
        return this.inputAggBufferOffset;
    }

    private DataType bufferElementType$lzycompute() {
        CollectSet collectSet = this;
        synchronized (collectSet) {
            if (!this.bitmap$0) {
                DataType dataType = this.child().dataType();
                DataType dataType2 = BinaryType$.MODULE$.equals(dataType) ? ArrayType$.MODULE$.apply(ByteType$.MODULE$) : dataType;
                this.bufferElementType = dataType2;
                this.bitmap$0 = true;
            }
        }
        return this.bufferElementType;
    }

    @Override
    public DataType bufferElementType() {
        return !this.bitmap$0 ? this.bufferElementType$lzycompute() : this.bufferElementType;
    }

    @Override
    public Object convertToBufferElement(Object value) {
        DataType dataType = this.child().dataType();
        Object object = BinaryType$.MODULE$.equals(dataType) ? UnsafeArrayData.fromPrimitiveArray((byte[])value) : InternalRow$.MODULE$.copyValue(value);
        return object;
    }

    @Override
    public Object eval(HashSet<Object> buffer) {
        DataType dataType = this.child().dataType();
        Object object = BinaryType$.MODULE$.equals(dataType) ? buffer.iterator().map((Function1 & Serializable)x$2 -> ((ArrayData)x$2).toByteArray()).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE))) : buffer.toArray(ClassTag$.MODULE$.Any());
        Object array = object;
        return new GenericArrayData(array);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return !this.child().dataType().existsRecursively((Function1<DataType, Object>)(Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)CollectSet.$anonfun$checkInputDataTypes$1(x$3))) ? TypeCheckResult$TypeCheckSuccess$.MODULE$ : new TypeCheckResult.TypeCheckFailure("collect_set() cannot have map type data");
    }

    @Override
    public ImperativeAggregate withNewMutableAggBufferOffset(int newMutableAggBufferOffset) {
        int x$1 = newMutableAggBufferOffset;
        Expression x$2 = this.copy$default$1();
        int x$3 = this.copy$default$3();
        return this.copy(x$2, x$1, x$3);
    }

    @Override
    public ImperativeAggregate withNewInputAggBufferOffset(int newInputAggBufferOffset) {
        int x$1 = newInputAggBufferOffset;
        Expression x$2 = this.copy$default$1();
        int x$3 = this.copy$default$2();
        return this.copy(x$2, x$3, x$1);
    }

    @Override
    public String prettyName() {
        return "collect_set";
    }

    @Override
    public HashSet<Object> createAggregationBuffer() {
        return HashSet$.MODULE$.empty();
    }

    @Override
    public CollectSet withNewChildInternal(Expression newChild) {
        return this.copy(newChild, this.copy$default$2(), this.copy$default$3());
    }

    public CollectSet copy(Expression child, int mutableAggBufferOffset, int inputAggBufferOffset) {
        return new CollectSet(child, mutableAggBufferOffset, inputAggBufferOffset);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public int copy$default$2() {
        return this.mutableAggBufferOffset();
    }

    public int copy$default$3() {
        return this.inputAggBufferOffset();
    }

    @Override
    public String productPrefix() {
        return "CollectSet";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.child();
                break;
            }
            case 1: {
                object = BoxesRunTime.boxToInteger((int)this.mutableAggBufferOffset());
                break;
            }
            case 2: {
                object = BoxesRunTime.boxToInteger((int)this.inputAggBufferOffset());
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof CollectSet;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "child";
                break;
            }
            case 1: {
                string = "mutableAggBufferOffset";
                break;
            }
            case 2: {
                string = "inputAggBufferOffset";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof CollectSet)) return false;
        boolean bl = true;
        if (!bl) return false;
        CollectSet collectSet = (CollectSet)x$1;
        if (this.mutableAggBufferOffset() != collectSet.mutableAggBufferOffset()) return false;
        if (this.inputAggBufferOffset() != collectSet.inputAggBufferOffset()) return false;
        Expression expression = this.child();
        Expression expression2 = collectSet.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!collectSet.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$checkInputDataTypes$1(DataType x$3) {
        return x$3 instanceof MapType;
    }

    public CollectSet(Expression child, int mutableAggBufferOffset, int inputAggBufferOffset) {
        this.child = child;
        this.mutableAggBufferOffset = mutableAggBufferOffset;
        this.inputAggBufferOffset = inputAggBufferOffset;
    }

    public CollectSet(Expression child) {
        this(child, 0, 0);
    }
}

