/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.xml;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.FunctionRegistry$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.xml.XPathDouble$;
import org.apache.spark.sql.catalyst.expressions.xml.XPathExtract;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(xml, xpath) - Returns a double value, the value zero if no match is found, or NaN if a match is found but the value is non-numeric.", examples="\n    Examples:\n      > SELECT _FUNC_('<a><b>1</b><b>2</b></a>', 'sum(a/b)');\n       3.0\n  ", since="2.0.0", group="xml_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005Mf\u0001B\u000e\u001d\u0001.B\u0001\"\b\u0001\u0003\u0016\u0004%\tA\u0011\u0005\t\u000f\u0002\u0011\t\u0012)A\u0005\u0007\"A\u0001\n\u0001BK\u0002\u0013\u0005!\t\u0003\u0005J\u0001\tE\t\u0015!\u0003D\u0011\u0015Q\u0005\u0001\"\u0001L\u0011\u0015y\u0005\u0001\"\u0011Q\u0011\u0015I\u0006\u0001\"\u0011[\u0011\u0015\t\u0007\u0001\"\u0011c\u0011\u0015A\u0007\u0001\"\u0015j\u0011\u001dq\u0007!!A\u0005\u0002=DqA\u001d\u0001\u0012\u0002\u0013\u00051\u000fC\u0004\u007f\u0001E\u0005I\u0011A:\t\u0011}\u0004\u0011\u0011!C!\u0003\u0003A\u0011\"!\u0005\u0001\u0003\u0003%\t!a\u0005\t\u0013\u0005m\u0001!!A\u0005\u0002\u0005u\u0001\"CA\u0012\u0001\u0005\u0005I\u0011IA\u0013\u0011%\t\u0019\u0004AA\u0001\n\u0003\t)\u0004C\u0005\u0002@\u0001\t\t\u0011\"\u0011\u0002B!I\u0011Q\t\u0001\u0002\u0002\u0013\u0005\u0013qI\u0004\n\u0003Wb\u0012\u0011!E\u0001\u0003[2\u0001b\u0007\u000f\u0002\u0002#\u0005\u0011q\u000e\u0005\u0007\u0015V!\t!a\"\t\u0013\u0005%U#!A\u0005F\u0005-\u0005\"CAG+\u0005\u0005I\u0011QAH\u0011%\t)*FA\u0001\n\u0003\u000b9\nC\u0005\u0002*V\t\t\u0011\"\u0003\u0002,\nY\u0001\fU1uQ\u0012{WO\u00197f\u0015\tib$A\u0002y[2T!a\b\u0011\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003C\t\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003G\u0011\n1a]9m\u0015\t)c%A\u0003ta\u0006\u00148N\u0003\u0002(Q\u00051\u0011\r]1dQ\u0016T\u0011!K\u0001\u0004_J<7\u0001A\n\u0005\u00011\u0002d\u0007\u0005\u0002.]5\tA$\u0003\u000209\ta\u0001\fU1uQ\u0016CHO]1diB\u0011\u0011\u0007N\u0007\u0002e)\t1'A\u0003tG\u0006d\u0017-\u0003\u00026e\t9\u0001K]8ek\u000e$\bCA\u001c@\u001d\tATH\u0004\u0002:y5\t!H\u0003\u0002<U\u00051AH]8pizJ\u0011aM\u0005\u0003}I\nq\u0001]1dW\u0006<W-\u0003\u0002A\u0003\na1+\u001a:jC2L'0\u00192mK*\u0011aHM\u000b\u0002\u0007B\u0011A)R\u0007\u0002=%\u0011aI\b\u0002\u000b\u000bb\u0004(/Z:tS>t\u0017\u0001\u0002=nY\u0002\nA\u0001]1uQ\u0006)\u0001/\u0019;iA\u00051A(\u001b8jiz\"2\u0001T'O!\ti\u0003\u0001C\u0003\u001e\u000b\u0001\u00071\tC\u0003I\u000b\u0001\u00071)\u0001\u0006qe\u0016$H/\u001f(b[\u0016,\u0012!\u0015\t\u0003%Zs!a\u0015+\u0011\u0005e\u0012\u0014BA+3\u0003\u0019\u0001&/\u001a3fM&\u0011q\u000b\u0017\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005U\u0013\u0014\u0001\u00033bi\u0006$\u0016\u0010]3\u0016\u0003m\u0003\"\u0001X0\u000e\u0003uS!A\u0018\u0012\u0002\u000bQL\b/Z:\n\u0005\u0001l&\u0001\u0003#bi\u0006$\u0016\u0010]3\u0002\u00199,H\u000e\\*bM\u0016,e/\u00197\u0015\u0007\r4w\r\u0005\u00022I&\u0011QM\r\u0002\u0004\u0003:L\b\"B\u000f\t\u0001\u0004\u0019\u0007\"\u0002%\t\u0001\u0004\u0019\u0017aF<ji\"tUm^\"iS2$'/\u001a8J]R,'O\\1m)\ra%\u000e\u001c\u0005\u0006W&\u0001\raQ\u0001\b]\u0016<H*\u001a4u\u0011\u0015i\u0017\u00021\u0001D\u0003!qWm\u001e*jO\"$\u0018\u0001B2paf$2\u0001\u00149r\u0011\u001di\"\u0002%AA\u0002\rCq\u0001\u0013\u0006\u0011\u0002\u0003\u00071)\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0003QT#aQ;,\u0003Y\u0004\"a\u001e?\u000e\u0003aT!!\u001f>\u0002\u0013Ut7\r[3dW\u0016$'BA>3\u0003)\tgN\\8uCRLwN\\\u0005\u0003{b\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA\u0002!\u0011\t)!a\u0004\u000e\u0005\u0005\u001d!\u0002BA\u0005\u0003\u0017\tA\u0001\\1oO*\u0011\u0011QB\u0001\u0005U\u00064\u0018-C\u0002X\u0003\u000f\tA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!!\u0006\u0011\u0007E\n9\"C\u0002\u0002\u001aI\u00121!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$2aYA\u0010\u0011%\t\tcDA\u0001\u0002\u0004\t)\"A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003O\u0001R!!\u000b\u00020\rl!!a\u000b\u000b\u0007\u00055\"'\u0001\u0006d_2dWm\u0019;j_:LA!!\r\u0002,\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\t9$!\u0010\u0011\u0007E\nI$C\u0002\u0002<I\u0012qAQ8pY\u0016\fg\u000e\u0003\u0005\u0002\"E\t\t\u00111\u0001d\u0003I\u0001(o\u001c3vGR,E.Z7f]Rt\u0015-\\3\u0015\t\u0005\r\u00111\t\u0005\n\u0003C\u0011\u0012\u0011!a\u0001\u0003+\ta!Z9vC2\u001cH\u0003BA\u001c\u0003\u0013B\u0001\"!\t\u0014\u0003\u0003\u0005\ra\u0019\u0015\u0014\u0001\u00055\u00131KA+\u00033\nY&a\u0018\u0002b\u0005\u0015\u0014q\r\t\u0004\t\u0006=\u0013bAA)=\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017EAA,\u0003\u0005UqLR+O\u0007~C\u00030\u001c7-Aa\u0004\u0018\r\u001e5*A5\u0002#+\u001a;ve:\u001c\b%\u0019\u0011e_V\u0014G.\u001a\u0011wC2,X\r\f\u0011uQ\u0016\u0004c/\u00197vK\u0002RXM]8!S\u001a\u0004cn\u001c\u0011nCR\u001c\u0007\u000eI5tA\u0019|WO\u001c3-A=\u0014\bET1OA%4\u0007%\u0019\u0011nCR\u001c\u0007\u000eI5tA\u0019|WO\u001c3!EV$\b\u0005\u001e5fAY\fG.^3!SN\u0004cn\u001c8.]VlWM]5d]\u0005AQ\r_1na2,7/\t\u0002\u0002^\u0005Q&\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u0014=Czb$MP\u0019=_\ttDH\u0019 3y=\u0012g\bP\u0018b}\u001db\u0003eJ:v[\"\nwFY\u0015(SmR\u0001\u0005\t\u0011!A\u0001\u00023G\f\u0019\u000bA\u0001\nQa]5oG\u0016\f#!a\u0019\u0002\u000bIr\u0003G\f\u0019\u0002\u000b\u001d\u0014x.\u001e9\"\u0005\u0005%\u0014!\u0003=nY~3WO\\2t\u0003-A\u0006+\u0019;i\t>,(\r\\3\u0011\u00055*2#B\u000b\u0002r\u0005u\u0004cBA:\u0003s\u001a5\tT\u0007\u0003\u0003kR1!a\u001e3\u0003\u001d\u0011XO\u001c;j[\u0016LA!a\u001f\u0002v\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001a\u0011\t\u0005}\u0014QQ\u0007\u0003\u0003\u0003SA!a!\u0002\f\u0005\u0011\u0011n\\\u0005\u0004\u0001\u0006\u0005ECAA7\u0003!!xn\u0015;sS:<GCAA\u0002\u0003\u0015\t\u0007\u000f\u001d7z)\u0015a\u0015\u0011SAJ\u0011\u0015i\u0002\u00041\u0001D\u0011\u0015A\u0005\u00041\u0001D\u0003\u001d)h.\u00199qYf$B!!'\u0002&B)\u0011'a'\u0002 &\u0019\u0011Q\u0014\u001a\u0003\r=\u0003H/[8o!\u0015\t\u0014\u0011U\"D\u0013\r\t\u0019K\r\u0002\u0007)V\u0004H.\u001a\u001a\t\u0011\u0005\u001d\u0016$!AA\u00021\u000b1\u0001\u001f\u00131\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\ti\u000b\u0005\u0003\u0002\u0006\u0005=\u0016\u0002BAY\u0003\u000f\u0011aa\u00142kK\u000e$\b")
public class XPathDouble
extends XPathExtract
implements Serializable {
    private final Expression xml;
    private final Expression path;

    public static Option<Tuple2<Expression, Expression>> unapply(XPathDouble xPathDouble) {
        return XPathDouble$.MODULE$.unapply(xPathDouble);
    }

    public static Function1<Tuple2<Expression, Expression>, XPathDouble> tupled() {
        return XPathDouble$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, XPathDouble>> curried() {
        return XPathDouble$.MODULE$.curried();
    }

    @Override
    public Expression xml() {
        return this.xml;
    }

    @Override
    public Expression path() {
        return this.path;
    }

    @Override
    public String prettyName() {
        return (String)this.getTagValue(FunctionRegistry$.MODULE$.FUNC_ALIAS()).getOrElse((Function0 & Serializable)() -> "xpath_double");
    }

    @Override
    public DataType dataType() {
        return DoubleType$.MODULE$;
    }

    @Override
    public Object nullSafeEval(Object xml, Object path) {
        Double ret = this.xpathUtil().evalNumber(((UTF8String)xml).toString(), this.pathString());
        return ret == null ? null : BoxesRunTime.boxToDouble((double)ret);
    }

    @Override
    public XPathDouble withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    public XPathDouble copy(Expression xml, Expression path) {
        return new XPathDouble(xml, path);
    }

    public Expression copy$default$1() {
        return this.xml();
    }

    public Expression copy$default$2() {
        return this.path();
    }

    @Override
    public String productPrefix() {
        return "XPathDouble";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.xml();
                break;
            }
            case 1: {
                object = this.path();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof XPathDouble;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "xml";
                break;
            }
            case 1: {
                string = "path";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof XPathDouble)) return false;
        boolean bl = true;
        if (!bl) return false;
        XPathDouble xPathDouble = (XPathDouble)x$1;
        Expression expression = this.xml();
        Expression expression2 = xPathDouble.xml();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.path();
        Expression expression4 = xPathDouble.path();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!xPathDouble.canEqual(this)) return false;
        return true;
    }

    public XPathDouble(Expression xml, Expression path) {
        this.xml = xml;
        this.path = path;
    }
}

