/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.Abs$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.NumericType;
import org.apache.spark.sql.types.NumericType$;
import org.apache.spark.sql.types.ShortType$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.math.Numeric;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(expr) - Returns the absolute value of the numeric value.", examples="\n    Examples:\n      > SELECT _FUNC_(-1);\n       1\n  ", since="1.2.0", group="math_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005mh\u0001\u0002\u0011\"\u0001:B\u0001B\u0014\u0001\u0003\u0016\u0004%\ta\u0014\u0005\t'\u0002\u0011\t\u0012)A\u0005!\"AA\u000b\u0001BK\u0002\u0013\u0005Q\u000b\u0003\u0005Z\u0001\tE\t\u0015!\u0003W\u0011\u0015Q\u0006\u0001\"\u0001\\\u0011\u0015Q\u0006\u0001\"\u0001`\u0011\u0015\t\u0007\u0001\"\u0011c\u0011\u0015a\u0007\u0001\"\u0011n\u0011!\t\b\u0001#b\u0001\n\u0013\u0011\b\"B=\u0001\t\u0003R\bbBA\t\u0001\u0011E\u00131\u0003\u0005\b\u00033\u0001A\u0011KA\u000e\u0011%\t\t\u0003AA\u0001\n\u0003\t\u0019\u0003C\u0005\u0002*\u0001\t\n\u0011\"\u0001\u0002,!I\u0011\u0011\t\u0001\u0012\u0002\u0013\u0005\u00111\t\u0005\n\u0003\u000f\u0002\u0011\u0011!C!\u0003\u0013B\u0011\"a\u0017\u0001\u0003\u0003%\t!!\u0018\t\u0013\u0005\u0015\u0004!!A\u0005\u0002\u0005\u001d\u0004\"CA7\u0001\u0005\u0005I\u0011IA8\u0011%\ti\bAA\u0001\n\u0003\ty\bC\u0005\u0002\u0004\u0002\t\t\u0011\"\u0011\u0002\u0006\"I\u0011\u0011\u0012\u0001\u0002\u0002\u0013\u0005\u00131R\u0004\n\u0003_\u000b\u0013\u0011!E\u0001\u0003c3\u0001\u0002I\u0011\u0002\u0002#\u0005\u00111\u0017\u0005\u00075b!\t!a3\t\u0013\u00055\u0007$!A\u0005F\u0005=\u0007\"CAi1\u0005\u0005I\u0011QAj\u0011%\tI\u000eGI\u0001\n\u0003\t\u0019\u0005C\u0005\u0002\\b\t\t\u0011\"!\u0002^\"I\u0011q\u001e\r\u0012\u0002\u0013\u0005\u00111\t\u0005\n\u0003cD\u0012\u0011!C\u0005\u0003g\u00141!\u00112t\u0015\t\u00113%A\u0006fqB\u0014Xm]:j_:\u001c(B\u0001\u0013&\u0003!\u0019\u0017\r^1msN$(B\u0001\u0014(\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003Q%\nQa\u001d9be.T!AK\u0016\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005a\u0013aA8sO\u000e\u00011C\u0002\u00010gYj4\t\u0005\u00021c5\t\u0011%\u0003\u00023C\tyQK\\1ss\u0016C\bO]3tg&|g\u000e\u0005\u00021i%\u0011Q'\t\u0002\u0012\u000bb\u0004Xm\u0019;t\u0013:\u0004X\u000f\u001e+za\u0016\u001c\bCA\u001c;\u001d\t\u0001\u0004(\u0003\u0002:C\u00059\u0001/Y2lC\u001e,\u0017BA\u001e=\u00059qU\u000f\u001c7J]R|G.\u001a:b]RT!!O\u0011\u0011\u0005y\nU\"A \u000b\u0003\u0001\u000bQa]2bY\u0006L!AQ \u0003\u000fA\u0013x\u000eZ;diB\u0011Ai\u0013\b\u0003\u000b*s!AR%\u000e\u0003\u001dS!\u0001S\u0017\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0001\u0015BA\u001d@\u0013\taUJ\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u0002:\u007f\u0005)1\r[5mIV\t\u0001\u000b\u0005\u00021#&\u0011!+\t\u0002\u000b\u000bb\u0004(/Z:tS>t\u0017AB2iS2$\u0007%A\u0006gC&dwJ\\#se>\u0014X#\u0001,\u0011\u0005y:\u0016B\u0001-@\u0005\u001d\u0011un\u001c7fC:\fABZ1jY>sWI\u001d:pe\u0002\na\u0001P5oSRtDc\u0001/^=B\u0011\u0001\u0007\u0001\u0005\u0006\u001d\u0016\u0001\r\u0001\u0015\u0005\b)\u0016\u0001\n\u00111\u0001W)\ta\u0006\rC\u0003O\r\u0001\u0007\u0001+\u0001\u0006j]B,H\u000fV=qKN,\u0012a\u0019\t\u0004\t\u00124\u0017BA3N\u0005\r\u0019V-\u001d\t\u0003O*l\u0011\u0001\u001b\u0006\u0003S\u0016\nQ\u0001^=qKNL!a\u001b5\u0003!\u0005\u00137\u000f\u001e:bGR$\u0015\r^1UsB,\u0017\u0001\u00033bi\u0006$\u0016\u0010]3\u0016\u00039\u0004\"aZ8\n\u0005AD'\u0001\u0003#bi\u0006$\u0016\u0010]3\u0002\u000f9,X.\u001a:jGV\t1\u000fE\u0002EiZL!!^'\u0003\u000f9+X.\u001a:jGB\u0011ah^\u0005\u0003q~\u00121!\u00118z\u0003%!wnR3o\u0007>$W\rF\u0003|\u0003\u0007\ti\u0001\u0005\u0002}\u007f6\tQP\u0003\u0002\u007fC\u000591m\u001c3fO\u0016t\u0017bAA\u0001{\nAQ\t\u001f9s\u0007>$W\rC\u0004\u0002\u0006)\u0001\r!a\u0002\u0002\u0007\r$\b\u0010E\u0002}\u0003\u0013I1!a\u0003~\u00059\u0019u\u000eZ3hK:\u001cuN\u001c;fqRDa!a\u0004\u000b\u0001\u0004Y\u0018AA3w\u00031qW\u000f\u001c7TC\u001a,WI^1m)\r1\u0018Q\u0003\u0005\u0007\u0003/Y\u0001\u0019\u0001<\u0002\u000b%t\u0007/\u001e;\u0002)]LG\u000f\u001b(fo\u000eC\u0017\u000e\u001c3J]R,'O\\1m)\ra\u0016Q\u0004\u0005\u0007\u0003?a\u0001\u0019\u0001)\u0002\u00119,wo\u00115jY\u0012\fAaY8qsR)A,!\n\u0002(!9a*\u0004I\u0001\u0002\u0004\u0001\u0006b\u0002+\u000e!\u0003\u0005\rAV\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\tiCK\u0002Q\u0003_Y#!!\r\u0011\t\u0005M\u0012QH\u0007\u0003\u0003kQA!a\u000e\u0002:\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003wy\u0014AC1o]>$\u0018\r^5p]&!\u0011qHA\u001b\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\t)EK\u0002W\u0003_\tQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA&!\u0011\ti%a\u0016\u000e\u0005\u0005=#\u0002BA)\u0003'\nA\u0001\\1oO*\u0011\u0011QK\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002Z\u0005=#AB*ue&tw-\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002`A\u0019a(!\u0019\n\u0007\u0005\rtHA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000fF\u0002w\u0003SB\u0011\"a\u001b\u0013\u0003\u0003\u0005\r!a\u0018\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\t\t\bE\u0003\u0002t\u0005ed/\u0004\u0002\u0002v)\u0019\u0011qO \u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002|\u0005U$\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$2AVAA\u0011!\tY\u0007FA\u0001\u0002\u00041\u0018A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$B!a\u0013\u0002\b\"I\u00111N\u000b\u0002\u0002\u0003\u0007\u0011qL\u0001\u0007KF,\u0018\r\\:\u0015\u0007Y\u000bi\t\u0003\u0005\u0002lY\t\t\u00111\u0001wQM\u0001\u0011\u0011SAL\u00033\u000bi*a(\u0002$\u0006\u0015\u0016\u0011VAV!\r\u0001\u00141S\u0005\u0004\u0003+\u000b#!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u00037\u000bqh\u0018$V\u001d\u000e{\u0006&\u001a=qe&\u0002S\u0006\t*fiV\u0014hn\u001d\u0011uQ\u0016\u0004\u0013MY:pYV$X\r\t<bYV,\u0007e\u001c4!i\",\u0007E\\;nKJL7\r\t<bYV,g&\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\t\t+A\u001b\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q5\n\u0014f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00112\u0015\u0001\u0002\u0013!B:j]\u000e,\u0017EAAT\u0003\u0015\tdF\r\u00181\u0003\u00159'o\\;qC\t\ti+\u0001\u0006nCRDwLZ;oGN\f1!\u00112t!\t\u0001\u0004dE\u0003\u0019\u0003k\u000b\t\rE\u0004\u00028\u0006u\u0006K\u0016/\u000e\u0005\u0005e&bAA^\u007f\u00059!/\u001e8uS6,\u0017\u0002BA`\u0003s\u0013\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c83!\u0011\t\u0019-!3\u000e\u0005\u0005\u0015'\u0002BAd\u0003'\n!![8\n\u00071\u000b)\r\u0006\u0002\u00022\u0006AAo\\*ue&tw\r\u0006\u0002\u0002L\u0005)\u0011\r\u001d9msR)A,!6\u0002X\")aj\u0007a\u0001!\"9Ak\u0007I\u0001\u0002\u00041\u0016aD1qa2LH\u0005Z3gCVdG\u000f\n\u001a\u0002\u000fUt\u0017\r\u001d9msR!\u0011q\\Av!\u0015q\u0014\u0011]As\u0013\r\t\u0019o\u0010\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u000by\n9\u000f\u0015,\n\u0007\u0005%xH\u0001\u0004UkBdWM\r\u0005\t\u0003[l\u0012\u0011!a\u00019\u0006\u0019\u0001\u0010\n\u0019\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00133\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\t)\u0010\u0005\u0003\u0002N\u0005]\u0018\u0002BA}\u0003\u001f\u0012aa\u00142kK\u000e$\b")
public class Abs
extends UnaryExpression
implements ExpectsInputTypes,
package.NullIntolerant,
Serializable {
    private Numeric<Object> numeric;
    private final Expression child;
    private final boolean failOnError;
    private volatile boolean bitmap$0;

    public static boolean $lessinit$greater$default$2() {
        return Abs$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple2<Expression, Object>> unapply(Abs abs) {
        return Abs$.MODULE$.unapply(abs);
    }

    public static boolean apply$default$2() {
        return Abs$.MODULE$.apply$default$2();
    }

    public static Function1<Tuple2<Expression, Object>, Abs> tupled() {
        return Abs$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Object, Abs>> curried() {
        return Abs$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    public boolean failOnError() {
        return this.failOnError;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new NumericType$[]{NumericType$.MODULE$}));
    }

    @Override
    public DataType dataType() {
        return this.child().dataType();
    }

    private Numeric<Object> numeric$lzycompute() {
        Abs abs = this;
        synchronized (abs) {
            if (!this.bitmap$0) {
                this.numeric = TypeUtils$.MODULE$.getNumeric(this.dataType(), this.failOnError());
                this.bitmap$0 = true;
            }
        }
        return this.numeric;
    }

    private Numeric<Object> numeric() {
        return !this.bitmap$0 ? this.numeric$lzycompute() : this.numeric;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode exprCode;
        DataType dataType = this.dataType();
        if (dataType instanceof DecimalType) {
            exprCode = this.defineCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable)c -> new StringBuilder(6).append((String)c).append(".abs()").toString());
        } else {
            boolean bl = ByteType$.MODULE$.equals(dataType) ? true : ShortType$.MODULE$.equals(dataType);
            if (bl && this.failOnError()) {
                String javaBoxedType = CodeGenerator$.MODULE$.boxedType(this.dataType());
                String javaType = CodeGenerator$.MODULE$.javaType(this.dataType());
                exprCode = this.nullSafeCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable)eval -> StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(219).append("\n          |if (").append((String)eval).append(" == ").append(javaBoxedType).append(".MIN_VALUE) {\n          |  throw QueryExecutionErrors.unaryMinusCauseOverflowError(").append((String)eval).append(");\n          |} else if (").append((String)eval).append(" < 0) {\n          |  ").append(ev.value()).append(" = (").append(javaType).append(")-").append((String)eval).append(";\n          |} else {\n          |  ").append(ev.value()).append(" = ").append((String)eval).append(";\n          |}\n          |").toString())));
            } else {
                boolean bl2 = IntegerType$.MODULE$.equals(dataType) ? true : LongType$.MODULE$.equals(dataType);
                if (bl2 && this.failOnError()) {
                    exprCode = this.defineCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable)c -> new StringBuilder(38).append((String)c).append(" < 0 ? java.lang.Math.negateExact(").append((String)c).append(") : ").append((String)c).toString());
                } else if (dataType instanceof NumericType) {
                    NumericType numericType = (NumericType)dataType;
                    exprCode = this.defineCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable)c -> new StringBuilder(24).append("(").append(CodeGenerator$.MODULE$.javaType(numericType)).append(")(java.lang.Math.abs(").append((String)c).append("))").toString());
                } else {
                    throw new MatchError((Object)dataType);
                }
            }
        }
        return exprCode;
    }

    @Override
    public Object nullSafeEval(Object input) {
        return this.numeric().abs(input);
    }

    @Override
    public Abs withNewChildInternal(Expression newChild) {
        return this.copy(newChild, this.copy$default$2());
    }

    public Abs copy(Expression child, boolean failOnError) {
        return new Abs(child, failOnError);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public boolean copy$default$2() {
        return this.failOnError();
    }

    @Override
    public String productPrefix() {
        return "Abs";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.child();
                break;
            }
            case 1: {
                object = BoxesRunTime.boxToBoolean((boolean)this.failOnError());
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Abs;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "child";
                break;
            }
            case 1: {
                string = "failOnError";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Abs)) return false;
        boolean bl = true;
        if (!bl) return false;
        Abs abs = (Abs)x$1;
        if (this.failOnError() != abs.failOnError()) return false;
        Expression expression = this.child();
        Expression expression2 = abs.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!abs.canEqual(this)) return false;
        return true;
    }

    public Abs(Expression child, boolean failOnError) {
        this.child = child;
        this.failOnError = failOnError;
        ExpectsInputTypes.$init$(this);
    }

    public Abs(Expression child) {
        this(child, SQLConf$.MODULE$.get().ansiEnabled());
    }
}

