/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.util.HashSet;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.ArraysOverlap$;
import org.apache.spark.sql.catalyst.expressions.BinaryArrayExpressionWithImplicitCast;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(a1, a2) - Returns true if a1 contains at least a non-null element present also in a2. If the arrays have no common element and they are both non-empty and either of them contains a null element null is returned, false otherwise.", examples="\n    Examples:\n      > SELECT _FUNC_(array(1, 2, 3), array(3, 4, 5));\n       true\n  ", group="array_funcs", since="2.4.0")
@ScalaSignature(bytes="\u0006\u0005\ted\u0001B\u0013'\u0001NB\u0001b\u0015\u0001\u0003\u0016\u0004%\t\u0001\u0016\u0005\t1\u0002\u0011\t\u0012)A\u0005+\"A\u0011\f\u0001BK\u0002\u0013\u0005A\u000b\u0003\u0005[\u0001\tE\t\u0015!\u0003V\u0011\u0015Y\u0006\u0001\"\u0001]\u0011\u0015\u0001\u0007\u0001\"\u0011b\u0011!A\u0007\u0001#b\u0001\n\u0013I\u0007\u0002\u0003;\u0001\u0011\u000b\u0007I\u0011B;\t\u000f\u0005\u0005\u0001\u0001\"\u0011\u0002\u0004!9\u0011\u0011\u0003\u0001\u0005B\u0005M\u0001bBA\u000e\u0001\u0011\u0005\u0013Q\u0004\u0005\b\u0003O\u0001A\u0011BA\u0015\u0011\u001d\t\u0019\u0004\u0001C\u0005\u0003kAq!a\u000f\u0001\t\u0003\ni\u0004C\u0004\u0002Z\u0001!I!a\u0017\t\u000f\u0005e\u0004\u0001\"\u0003\u0002|!9\u0011Q\u0011\u0001\u0005\u0002\u0005\u001d\u0005bBAM\u0001\u0011\u0005\u00131\u0014\u0005\b\u0003;\u0003A\u0011KAP\u0011%\tI\u000bAA\u0001\n\u0003\tY\u000bC\u0005\u00022\u0002\t\n\u0011\"\u0001\u00024\"I\u0011\u0011\u001a\u0001\u0012\u0002\u0013\u0005\u00111\u0017\u0005\n\u0003\u0017\u0004\u0011\u0011!C!\u0003\u001bD\u0011\"!8\u0001\u0003\u0003%\t!a8\t\u0013\u0005\u001d\b!!A\u0005\u0002\u0005%\b\"CAx\u0001\u0005\u0005I\u0011IAy\u0011%\ty\u0010AA\u0001\n\u0003\u0011\t\u0001C\u0005\u0003\u0006\u0001\t\t\u0011\"\u0011\u0003\b!I!1\u0002\u0001\u0002\u0002\u0013\u0005#QB\u0004\n\u0005c1\u0013\u0011!E\u0001\u0005g1\u0001\"\n\u0014\u0002\u0002#\u0005!Q\u0007\u0005\u00077~!\tA!\u0014\t\u0013\t=s$!A\u0005F\tE\u0003\"\u0003B*?\u0005\u0005I\u0011\u0011B+\u0011%\u0011YfHA\u0001\n\u0003\u0013i\u0006C\u0005\u0003p}\t\t\u0011\"\u0003\u0003r\ti\u0011I\u001d:bsN|e/\u001a:mCBT!a\n\u0015\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003S)\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003W1\n1a]9m\u0015\tic&A\u0003ta\u0006\u00148N\u0003\u00020a\u00051\u0011\r]1dQ\u0016T\u0011!M\u0001\u0004_J<7\u0001A\n\u0007\u0001QB4H\u0011%\u0011\u0005U2T\"\u0001\u0014\n\u0005]2#\u0001\u0005\"j]\u0006\u0014\u00180\u0012=qe\u0016\u001c8/[8o!\t)\u0014(\u0003\u0002;M\t)#)\u001b8bef\f%O]1z\u000bb\u0004(/Z:tS>tw+\u001b;i\u00136\u0004H.[2ji\u000e\u000b7\u000f\u001e\t\u0003y}r!!N\u001f\n\u0005y2\u0013a\u00029bG.\fw-Z\u0005\u0003\u0001\u0006\u0013aBT;mY&sGo\u001c7fe\u0006tGO\u0003\u0002?MA\u00111IR\u0007\u0002\t*\tQ)A\u0003tG\u0006d\u0017-\u0003\u0002H\t\n9\u0001K]8ek\u000e$\bCA%Q\u001d\tQuJ\u0004\u0002L\u001d6\tAJ\u0003\u0002Ne\u00051AH]8pizJ\u0011!R\u0005\u0003}\u0011K!!\u0015*\u0003\u0019M+'/[1mSj\f'\r\\3\u000b\u0005y\"\u0015\u0001\u00027fMR,\u0012!\u0016\t\u0003kYK!a\u0016\u0014\u0003\u0015\u0015C\bO]3tg&|g.A\u0003mK\u001a$\b%A\u0003sS\u001eDG/\u0001\u0004sS\u001eDG\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007usv\f\u0005\u00026\u0001!)1+\u0002a\u0001+\")\u0011,\u0002a\u0001+\u0006\u00192\r[3dW&s\u0007/\u001e;ECR\fG+\u001f9fgR\t!\r\u0005\u0002dM6\tAM\u0003\u0002fQ\u0005A\u0011M\\1msNL7/\u0003\u0002hI\nyA+\u001f9f\u0007\",7m\u001b*fgVdG/\u0001\u0005pe\u0012,'/\u001b8h+\u0005Q\u0007cA%l[&\u0011AN\u0015\u0002\t\u001fJ$WM]5oOB\u00111I\\\u0005\u0003_\u0012\u00131!\u00118zQ\t9\u0011\u000f\u0005\u0002De&\u00111\u000f\u0012\u0002\niJ\fgn]5f]R\fA\u0002Z8Fm\u0006dW/\u0019;j_:,\u0012A\u001e\t\u0006\u0007^L\u00180\\\u0005\u0003q\u0012\u0013\u0011BR;oGRLwN\u001c\u001a\u0011\u0005ilX\"A>\u000b\u0005qD\u0013\u0001B;uS2L!A`>\u0003\u0013\u0005\u0013(/Y=ECR\f\u0007F\u0001\u0005r\u0003!!\u0017\r^1UsB,WCAA\u0003!\u0011\t9!!\u0004\u000e\u0005\u0005%!bAA\u0006U\u0005)A/\u001f9fg&!\u0011qBA\u0005\u0005!!\u0015\r^1UsB,\u0017\u0001\u00038vY2\f'\r\\3\u0016\u0005\u0005U\u0001cA\"\u0002\u0018%\u0019\u0011\u0011\u0004#\u0003\u000f\t{w\u000e\\3b]\u0006aa.\u001e7m'\u00064W-\u0012<bYR)Q.a\b\u0002$!1\u0011\u0011E\u0006A\u00025\f!!Y\u0019\t\r\u0005\u00152\u00021\u0001n\u0003\t\t''\u0001\u0005gCN$XI^1m)\u0015i\u00171FA\u0018\u0011\u0019\ti\u0003\u0004a\u0001s\u0006!\u0011M\u001d:2\u0011\u0019\t\t\u0004\u0004a\u0001s\u0006!\u0011M\u001d:3\u00039\u0011'/\u001e;f\r>\u00148-Z#wC2$R!\\A\u001c\u0003sAa!!\f\u000e\u0001\u0004I\bBBA\u0019\u001b\u0001\u0007\u00110A\u0005e_\u001e+gnQ8eKR1\u0011qHA&\u0003+\u0002B!!\u0011\u0002H5\u0011\u00111\t\u0006\u0004\u0003\u000b2\u0013aB2pI\u0016<WM\\\u0005\u0005\u0003\u0013\n\u0019E\u0001\u0005FqB\u00148i\u001c3f\u0011\u001d\tiE\u0004a\u0001\u0003\u001f\n1a\u0019;y!\u0011\t\t%!\u0015\n\t\u0005M\u00131\t\u0002\u000f\u0007>$WmZ3o\u0007>tG/\u001a=u\u0011\u001d\t9F\u0004a\u0001\u0003\u007f\t!!\u001a<\u0002\u0017\u0019\f7\u000f^\"pI\u0016<WM\u001c\u000b\u000b\u0003;\ni'a\u001c\u0002r\u0005U\u0004\u0003BA0\u0003OrA!!\u0019\u0002dA\u00111\nR\u0005\u0004\u0003K\"\u0015A\u0002)sK\u0012,g-\u0003\u0003\u0002j\u0005-$AB*ue&twMC\u0002\u0002f\u0011Cq!!\u0014\u0010\u0001\u0004\ty\u0005C\u0004\u0002X=\u0001\r!a\u0010\t\u000f\u0005Mt\u00021\u0001\u0002^\u000591/\\1mY\u0016\u0014\bbBA<\u001f\u0001\u0007\u0011QL\u0001\u0007E&<w-\u001a:\u0002#\t\u0014X\u000f^3G_J\u001cWmQ8eK\u001e,g\u000e\u0006\u0006\u0002^\u0005u\u0014qPAA\u0003\u0007Cq!!\u0014\u0011\u0001\u0004\ty\u0005C\u0004\u0002XA\u0001\r!a\u0010\t\u000f\u0005M\u0004\u00031\u0001\u0002^!9\u0011q\u000f\tA\u0002\u0005u\u0013A\u00068vY2\u001c\u0016MZ3FY\u0016lWM\u001c;D_\u0012,w-\u001a8\u0015\u0015\u0005u\u0013\u0011RAG\u0003#\u000b)\nC\u0004\u0002\fF\u0001\r!!\u0018\u0002\u0011\u0005\u0014(/Y=WCJDq!a$\u0012\u0001\u0004\ti&A\u0003j]\u0012,\u0007\u0010C\u0004\u0002\u0014F\u0001\r!!\u0018\u0002\t\r|G-\u001a\u0005\b\u0003/\u000b\u0002\u0019AA/\u0003)I7OT;mY\u000e{G-Z\u0001\u000baJ,G\u000f^=OC6,WCAA/\u0003]9\u0018\u000e\u001e5OK^\u001c\u0005.\u001b7ee\u0016t\u0017J\u001c;fe:\fG\u000eF\u0003^\u0003C\u000b)\u000b\u0003\u0004\u0002$N\u0001\r!V\u0001\b]\u0016<H*\u001a4u\u0011\u0019\t9k\u0005a\u0001+\u0006Aa.Z<SS\u001eDG/\u0001\u0003d_BLH#B/\u0002.\u0006=\u0006bB*\u0015!\u0003\u0005\r!\u0016\u0005\b3R\u0001\n\u00111\u0001V\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!!.+\u0007U\u000b9l\u000b\u0002\u0002:B!\u00111XAc\u001b\t\tiL\u0003\u0003\u0002@\u0006\u0005\u0017!C;oG\",7m[3e\u0015\r\t\u0019\rR\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAd\u0003{\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAAh!\u0011\t\t.a7\u000e\u0005\u0005M'\u0002BAk\u0003/\fA\u0001\\1oO*\u0011\u0011\u0011\\\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002j\u0005M\u0017\u0001\u00049s_\u0012,8\r^!sSRLXCAAq!\r\u0019\u00151]\u0005\u0004\u0003K$%aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$HcA7\u0002l\"I\u0011Q^\r\u0002\u0002\u0003\u0007\u0011\u0011]\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005M\b#BA{\u0003wlWBAA|\u0015\r\tI\u0010R\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA\u007f\u0003o\u0014\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u0011Q\u0003B\u0002\u0011!\tioGA\u0001\u0002\u0004i\u0017A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$B!a4\u0003\n!I\u0011Q\u001e\u000f\u0002\u0002\u0003\u0007\u0011\u0011]\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005U!q\u0002\u0005\t\u0003[l\u0012\u0011!a\u0001[\"\u001a\u0002Aa\u0005\u0003\u001a\tm!q\u0004B\u0011\u0005K\u00119Ca\u000b\u0003.A\u0019QG!\u0006\n\u0007\t]aEA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\tu\u0011!a6`\rVs5i\u0018\u0015bc1\u0002\u0013MM\u0015![\u0001\u0012V\r^;s]N\u0004CO];fA%4\u0007%Y\u0019!G>tG/Y5og\u0002\nG\u000f\t7fCN$\b%\u0019\u0011o_:lc.\u001e7mA\u0015dW-\\3oi\u0002\u0002(/Z:f]R\u0004\u0013\r\\:pA%t\u0007%\u0019\u001a/A%3\u0007\u0005\u001e5fA\u0005\u0014(/Y=tA!\fg/\u001a\u0011o_\u0002\u001aw.\\7p]\u0002*G.Z7f]R\u0004\u0013M\u001c3!i\",\u0017\u0010I1sK\u0002\u0012w\u000e\u001e5!]>tW&Z7qif\u0004\u0013M\u001c3!K&$\b.\u001a:!_\u001a\u0004C\u000f[3nA\r|g\u000e^1j]N\u0004\u0013\r\t8vY2\u0004S\r\\3nK:$\bE\\;mY\u0002J7\u000f\t:fiV\u0014h.\u001a3-A\u0019\fGn]3!_RDWM]<jg\u0016t\u0013\u0001C3yC6\u0004H.Z:\"\u0005\t\r\u0012\u0001\u0016\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)CJ\u0014\u0018-\u001f\u00152Y\u0001\u0012D\u0006I\u001a*Y\u0001\n'O]1zQMb\u0003\u0005\u000e\u0017!k%J3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t;sk\u0016T\u0001\u0005I\u0001\u0006OJ|W\u000f]\u0011\u0003\u0005S\t1\"\u0019:sCf|f-\u001e8dg\u0006)1/\u001b8dK\u0006\u0012!qF\u0001\u0006e9\"d\u0006M\u0001\u000e\u0003J\u0014\u0018-_:Pm\u0016\u0014H.\u00199\u0011\u0005Uz2#B\u0010\u00038\t\r\u0003c\u0002B\u001d\u0005\u007f)V+X\u0007\u0003\u0005wQ1A!\u0010E\u0003\u001d\u0011XO\u001c;j[\u0016LAA!\u0011\u0003<\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001a\u0011\t\t\u0015#1J\u0007\u0003\u0005\u000fRAA!\u0013\u0002X\u0006\u0011\u0011n\\\u0005\u0004#\n\u001dCC\u0001B\u001a\u0003!!xn\u0015;sS:<GCAAh\u0003\u0015\t\u0007\u000f\u001d7z)\u0015i&q\u000bB-\u0011\u0015\u0019&\u00051\u0001V\u0011\u0015I&\u00051\u0001V\u0003\u001d)h.\u00199qYf$BAa\u0018\u0003lA)1I!\u0019\u0003f%\u0019!1\r#\u0003\r=\u0003H/[8o!\u0015\u0019%qM+V\u0013\r\u0011I\u0007\u0012\u0002\u0007)V\u0004H.\u001a\u001a\t\u0011\t54%!AA\u0002u\u000b1\u0001\u001f\u00131\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\u0011\u0019\b\u0005\u0003\u0002R\nU\u0014\u0002\u0002B<\u0003'\u0014aa\u00142kK\u000e$\b")
public class ArraysOverlap
extends BinaryExpression
implements BinaryArrayExpressionWithImplicitCast,
package.NullIntolerant,
Serializable {
    private transient Ordering<Object> ordering;
    private transient Function2<ArrayData, ArrayData, Object> doEvaluation;
    private final Expression left;
    private final Expression right;
    private transient DataType elementType;
    private volatile transient byte bitmap$trans$0;

    public static Option<Tuple2<Expression, Expression>> unapply(ArraysOverlap arraysOverlap) {
        return ArraysOverlap$.MODULE$.unapply(arraysOverlap);
    }

    public static Function1<Tuple2<Expression, Expression>, ArraysOverlap> tupled() {
        return ArraysOverlap$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, ArraysOverlap>> curried() {
        return ArraysOverlap$.MODULE$.curried();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return BinaryArrayExpressionWithImplicitCast.inputTypes$(this);
    }

    private DataType elementType$lzycompute() {
        ArraysOverlap arraysOverlap = this;
        synchronized (arraysOverlap) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.elementType = BinaryArrayExpressionWithImplicitCast.elementType$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.elementType;
    }

    @Override
    public DataType elementType() {
        return (byte)(this.bitmap$trans$0 & 4) == 0 ? this.elementType$lzycompute() : this.elementType;
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        TypeCheckResult typeCheckResult = BinaryArrayExpressionWithImplicitCast.checkInputDataTypes$(this);
        TypeCheckResult typeCheckResult2 = TypeCheckResult$TypeCheckSuccess$.MODULE$.equals(typeCheckResult) ? TypeUtils$.MODULE$.checkForOrderingExpr(this.elementType(), new StringBuilder(9).append("function ").append(this.prettyName()).toString()) : typeCheckResult;
        return typeCheckResult2;
    }

    private Ordering<Object> ordering$lzycompute() {
        ArraysOverlap arraysOverlap = this;
        synchronized (arraysOverlap) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.ordering = TypeUtils$.MODULE$.getInterpretedOrdering(this.elementType());
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.ordering;
    }

    private Ordering<Object> ordering() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.ordering$lzycompute() : this.ordering;
    }

    private Function2<ArrayData, ArrayData, Object> doEvaluation$lzycompute() {
        ArraysOverlap arraysOverlap = this;
        synchronized (arraysOverlap) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.doEvaluation = TypeUtils$.MODULE$.typeWithProperEquals(this.elementType()) ? (Function2 & Serializable)(arr1, arr2) -> this.fastEval((ArrayData)arr1, (ArrayData)arr2) : (Function2 & Serializable)(arr1, arr2) -> this.bruteForceEval((ArrayData)arr1, (ArrayData)arr2);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.doEvaluation;
    }

    private Function2<ArrayData, ArrayData, Object> doEvaluation() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.doEvaluation$lzycompute() : this.doEvaluation;
    }

    @Override
    public DataType dataType() {
        return BooleanType$.MODULE$;
    }

    @Override
    public boolean nullable() {
        return this.left().nullable() || this.right().nullable() || ((ArrayType)this.left().dataType()).containsNull() || ((ArrayType)this.right().dataType()).containsNull();
    }

    @Override
    public Object nullSafeEval(Object a1, Object a2) {
        return this.doEvaluation().apply((Object)((ArrayData)a1), (Object)((ArrayData)a2));
    }

    private Object fastEval(ArrayData arr1, ArrayData arr2) {
        Object object;
        Object object2 = new Object();
        try {
            Tuple2 tuple2;
            BooleanRef hasNull = BooleanRef.create((boolean)false);
            Tuple2 tuple22 = tuple2 = arr1.numElements() > arr2.numElements() ? new Tuple2((Object)arr1, (Object)arr2) : new Tuple2((Object)arr2, (Object)arr1);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            ArrayData bigger = (ArrayData)tuple2._1();
            ArrayData smaller = (ArrayData)tuple2._2();
            Tuple2 tuple23 = new Tuple2((Object)bigger, (Object)smaller);
            Tuple2 tuple24 = tuple23;
            ArrayData bigger2 = (ArrayData)tuple24._1();
            ArrayData smaller2 = (ArrayData)tuple24._2();
            if (smaller2.numElements() > 0) {
                HashSet smallestSet = new HashSet();
                smaller2.foreach(this.elementType(), (Function2<Object, Object, BoxedUnit>)(Function2 & Serializable)(x$21, v) -> {
                    ArraysOverlap.$anonfun$fastEval$1(hasNull, smallestSet, BoxesRunTime.unboxToInt((Object)x$21), v);
                    return BoxedUnit.UNIT;
                });
                bigger2.foreach(this.elementType(), (Function2<Object, Object, BoxedUnit>)(Function2 & Serializable)(x$22, v1) -> {
                    ArraysOverlap.$anonfun$fastEval$2(hasNull, smallestSet, object2, BoxesRunTime.unboxToInt((Object)x$22), v1);
                    return BoxedUnit.UNIT;
                });
            }
            object = hasNull.elem ? null : BoxesRunTime.boxToBoolean((boolean)false);
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object2) {
                object = ex.value();
            }
            throw ex;
        }
        return object;
    }

    private Object bruteForceEval(ArrayData arr1, ArrayData arr2) {
        Object object;
        Object object2 = new Object();
        try {
            BooleanRef hasNull = BooleanRef.create((boolean)false);
            if (arr1.numElements() > 0 && arr2.numElements() > 0) {
                arr1.foreach(this.elementType(), (Function2<Object, Object, BoxedUnit>)(Function2 & Serializable)(x$23, v1) -> {
                    ArraysOverlap.$anonfun$bruteForceEval$1(this, hasNull, arr2, object2, BoxesRunTime.unboxToInt((Object)x$23), v1);
                    return BoxedUnit.UNIT;
                });
            }
            object = hasNull.elem ? null : BoxesRunTime.boxToBoolean((boolean)false);
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object2) {
                object = ex.value();
            }
            throw ex;
        }
        return object;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable)(a1, a2) -> {
            String smaller = ctx.freshName("smallerArray");
            String bigger = ctx.freshName("biggerArray");
            String comparisonCode = TypeUtils$.MODULE$.typeWithProperEquals(this.elementType()) ? this.fastCodegen(ctx, ev, smaller, bigger) : this.bruteForceCodegen(ctx, ev, smaller, bigger);
            return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(261).append("\n         |ArrayData ").append(smaller).append(";\n         |ArrayData ").append(bigger).append(";\n         |if (").append((String)a1).append(".numElements() > ").append((String)a2).append(".numElements()) {\n         |  ").append(bigger).append(" = ").append((String)a1).append(";\n         |  ").append(smaller).append(" = ").append((String)a2).append(";\n         |} else {\n         |  ").append(smaller).append(" = ").append((String)a1).append(";\n         |  ").append(bigger).append(" = ").append((String)a2).append(";\n         |}\n         |if (").append(smaller).append(".numElements() > 0) {\n         |  ").append(comparisonCode).append("\n         |}\n       ").toString()));
        });
    }

    private String fastCodegen(CodegenContext ctx, ExprCode ev, String smaller, String bigger) {
        String i = ctx.freshName("i");
        String getFromSmaller = CodeGenerator$.MODULE$.getValue(smaller, this.elementType(), i);
        String getFromBigger = CodeGenerator$.MODULE$.getValue(bigger, this.elementType(), i);
        String javaElementClass = CodeGenerator$.MODULE$.boxedType(this.elementType());
        String javaSet = HashSet.class.getName();
        String set = ctx.freshName("set");
        String addToSetFromSmallerCode = this.nullSafeElementCodegen(smaller, i, new StringBuilder(7).append(set).append(".add(").append(getFromSmaller).append(");").toString(), new StringBuilder(8).append(ev.isNull()).append(" = true;").toString());
        String setIsNullCode = this.nullable() ? new StringBuilder(9).append(ev.isNull()).append(" = false;").toString() : "";
        String elementIsInSetCode = this.nullSafeElementCodegen(bigger, i, StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(102).append("\n         |if (").append(set).append(".contains(").append(getFromBigger).append(")) {\n         |  ").append(setIsNullCode).append("\n         |  ").append(ev.value()).append(" = true;\n         |  break;\n         |}\n       ").toString())), new StringBuilder(8).append(ev.isNull()).append(" = true;").toString());
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(170).append("\n       |").append(javaSet).append("<").append(javaElementClass).append("> ").append(set).append(" = new ").append(javaSet).append("<").append(javaElementClass).append(">();\n       |for (int ").append(i).append(" = 0; ").append(i).append(" < ").append(smaller).append(".numElements(); ").append(i).append(" ++) {\n       |  ").append(addToSetFromSmallerCode).append("\n       |}\n       |for (int ").append(i).append(" = 0; ").append(i).append(" < ").append(bigger).append(".numElements(); ").append(i).append(" ++) {\n       |  ").append(elementIsInSetCode).append("\n       |}\n     ").toString()));
    }

    private String bruteForceCodegen(CodegenContext ctx, ExprCode ev, String smaller, String bigger) {
        String i = ctx.freshName("i");
        String j = ctx.freshName("j");
        String getFromSmaller = CodeGenerator$.MODULE$.getValue(smaller, this.elementType(), j);
        String getFromBigger = CodeGenerator$.MODULE$.getValue(bigger, this.elementType(), i);
        String setIsNullCode = this.nullable() ? new StringBuilder(9).append(ev.isNull()).append(" = false;").toString() : "";
        String compareValues = this.nullSafeElementCodegen(smaller, j, StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(72).append("\n         |if (").append(ctx.genEqual(this.elementType(), getFromSmaller, getFromBigger)).append(") {\n         |  ").append(setIsNullCode).append("\n         |  ").append(ev.value()).append(" = true;\n         |}\n       ").toString())), new StringBuilder(8).append(ev.isNull()).append(" = true;").toString());
        String isInSmaller = this.nullSafeElementCodegen(bigger, i, StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(89).append("\n         |for (int ").append(j).append(" = 0; ").append(j).append(" < ").append(smaller).append(".numElements() && !").append(ev.value()).append("; ").append(j).append(" ++) {\n         |  ").append(compareValues).append("\n         |}\n       ").toString())), new StringBuilder(8).append(ev.isNull()).append(" = true;").toString());
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(81).append("\n       |for (int ").append(i).append(" = 0; ").append(i).append(" < ").append(bigger).append(".numElements() && !").append(ev.value()).append("; ").append(i).append(" ++) {\n       |  ").append(isInSmaller).append("\n       |}\n     ").toString()));
    }

    public String nullSafeElementCodegen(String arrayVar, String index, String code, String isNullCode) {
        return this.inputTypes().exists((Function1 & Serializable)x$25 -> BoxesRunTime.boxToBoolean((boolean)ArraysOverlap.$anonfun$nullSafeElementCodegen$1(x$25))) ? StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(94).append("\n         |if (").append(arrayVar).append(".isNullAt(").append(index).append(")) {\n         |  ").append(isNullCode).append("\n         |} else {\n         |  ").append(code).append("\n         |}\n       ").toString())) : code;
    }

    @Override
    public String prettyName() {
        return "arrays_overlap";
    }

    @Override
    public ArraysOverlap withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    public ArraysOverlap copy(Expression left, Expression right) {
        return new ArraysOverlap(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "ArraysOverlap";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.left();
                break;
            }
            case 1: {
                object = this.right();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ArraysOverlap;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "left";
                break;
            }
            case 1: {
                string = "right";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ArraysOverlap)) return false;
        boolean bl = true;
        if (!bl) return false;
        ArraysOverlap arraysOverlap = (ArraysOverlap)x$1;
        Expression expression = this.left();
        Expression expression2 = arraysOverlap.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = arraysOverlap.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!arraysOverlap.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ void $anonfun$fastEval$1(BooleanRef hasNull$2, HashSet smallestSet$1, int x$21, Object v) {
        if (v == null) {
            hasNull$2.elem = true;
        } else {
            smallestSet$1.add(v);
        }
    }

    public static final /* synthetic */ void $anonfun$fastEval$2(BooleanRef hasNull$2, HashSet smallestSet$1, Object nonLocalReturnKey2$1, int x$22, Object v1) {
        if (v1 == null) {
            hasNull$2.elem = true;
        } else if (smallestSet$1.contains(v1)) {
            throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey2$1, true);
        }
    }

    public static final /* synthetic */ void $anonfun$bruteForceEval$2(ArraysOverlap $this, BooleanRef hasNull$3, Object v1$1, Object nonLocalReturnKey3$1, int x$24, Object v2) {
        if (v2 == null) {
            hasNull$3.elem = true;
        } else if ($this.ordering().equiv(v1$1, v2)) {
            throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey3$1, true);
        }
    }

    public static final /* synthetic */ void $anonfun$bruteForceEval$1(ArraysOverlap $this, BooleanRef hasNull$3, ArrayData arr2$1, Object nonLocalReturnKey3$1, int x$23, Object v1) {
        if (v1 == null) {
            hasNull$3.elem = true;
        } else {
            arr2$1.foreach($this.elementType(), (Function2<Object, Object, BoxedUnit>)(Function2 & Serializable)(x$24, v2) -> {
                ArraysOverlap.$anonfun$bruteForceEval$2($this, hasNull$3, v1, nonLocalReturnKey3$1, BoxesRunTime.unboxToInt((Object)x$24), v2);
                return BoxedUnit.UNIT;
            });
        }
    }

    public static final /* synthetic */ boolean $anonfun$nullSafeElementCodegen$1(AbstractDataType x$25) {
        return ((ArrayType)x$25).containsNull();
    }

    public ArraysOverlap(Expression left, Expression right) {
        this.left = left;
        this.right = right;
        ExpectsInputTypes.$init$(this);
        BinaryArrayExpressionWithImplicitCast.$init$(this);
    }
}

