/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.DatePart$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.RuntimeReplaceable;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.Unevaluable;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.DataType;
import scala.Enumeration;
import scala.Function0;
import scala.Option;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(field, source) - Extracts a part of the date/timestamp or interval source.", arguments="\n    Arguments:\n      * field - selects which part of the source should be extracted, and supported string values are as same as the fields of the equivalent function `EXTRACT`.\n      * source - a date/timestamp or interval column from where `field` should be extracted\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('YEAR', TIMESTAMP '2019-08-12 01:00:00.123456');\n       2019\n      > SELECT _FUNC_('week', timestamp'2019-08-12 01:00:00.123456');\n       33\n      > SELECT _FUNC_('doy', DATE'2019-08-12');\n       224\n      > SELECT _FUNC_('SECONDS', timestamp'2019-10-01 00:00:01.000001');\n       1.000001\n      > SELECT _FUNC_('days', interval 5 days 3 hours 7 minutes);\n       5\n      > SELECT _FUNC_('seconds', interval 5 hours 30 seconds 1 milliseconds 1 microseconds);\n       30.001001\n      > SELECT _FUNC_('MONTH', INTERVAL '2021-11' YEAR TO MONTH);\n       11\n      > SELECT _FUNC_('MINUTE', INTERVAL '123 23:55:59.002001' DAY TO SECOND);\n       55\n  ", note="\n    The _FUNC_ function is equivalent to the SQL-standard function `EXTRACT(field FROM source)`\n  ", group="datetime_funcs", since="3.0.0")
@ScalaSignature(bytes="\u0006\u0005\u0005-x!\u0002\u0011\"\u0011\u0003qc!\u0002\u0019\"\u0011\u0003\t\u0004\"\u0002!\u0002\t\u0003\t\u0005\"\u0002\"\u0002\t\u0003\u0019\u0005\"\u00020\u0002\t\u0003y\u0006bB2\u0002\u0003\u0003%\t\t\u001a\u0005\n\u0003\u001b\f\u0011\u0011!CA\u0003\u001fD\u0011\"!9\u0002\u0003\u0003%I!a9\u0007\tA\n\u0003I\u001a\u0005\tC\"\u0011)\u001a!C\u0001q\"A\u0011\u0010\u0003B\tB\u0003%A\t\u0003\u0005V\u0011\tU\r\u0011\"\u0001y\u0011!Q\bB!E!\u0002\u0013!\u0005\u0002C>\t\u0005+\u0007I\u0011\u0001=\t\u0011qD!\u0011#Q\u0001\n\u0011CQ\u0001\u0011\u0005\u0005\u0002uDa\u0001\u0011\u0005\u0005\u0002\u0005\r\u0001bBA\u0005\u0011\u0011\u0005\u00131\u0002\u0005\b\u00033AA\u0011IA\u000e\u0011\u001d\t\u0019\u0003\u0003C!\u0003KAq!a\n\t\t#\nI\u0003C\u0005\u00020!\t\t\u0011\"\u0001\u00022!I\u0011\u0011\b\u0005\u0012\u0002\u0013\u0005\u00111\b\u0005\n\u0003#B\u0011\u0013!C\u0001\u0003wA\u0011\"a\u0015\t#\u0003%\t!a\u000f\t\u0013\u0005U\u0003\"!A\u0005B\u0005]\u0003\"CA2\u0011\u0005\u0005I\u0011AA3\u0011%\ti\u0007CA\u0001\n\u0003\ty\u0007C\u0005\u0002v!\t\t\u0011\"\u0011\u0002x!I\u00111\u0011\u0005\u0002\u0002\u0013\u0005\u0011Q\u0011\u0005\n\u0003\u001fC\u0011\u0011!C!\u0003#C\u0011\"!&\t\u0003\u0003%\t%a&\u0002\u0011\u0011\u000bG/\u001a)beRT!AI\u0012\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003I\u0015\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003M\u001d\n1a]9m\u0015\tA\u0013&A\u0003ta\u0006\u00148N\u0003\u0002+W\u00051\u0011\r]1dQ\u0016T\u0011\u0001L\u0001\u0004_J<7\u0001\u0001\t\u0003_\u0005i\u0011!\t\u0002\t\t\u0006$X\rU1siN\u0019\u0011A\r\u001d\u0011\u0005M2T\"\u0001\u001b\u000b\u0003U\nQa]2bY\u0006L!a\u000e\u001b\u0003\r\u0005s\u0017PU3g!\tId(D\u0001;\u0015\tYD(\u0001\u0002j_*\tQ(\u0001\u0003kCZ\f\u0017BA ;\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003\u0019a\u0014N\\5u}Q\ta&A\tqCJ\u001cX-\u0012=ue\u0006\u001cGOR5fY\u0012$B\u0001R$U-B\u0011q&R\u0005\u0003\r\u0006\u0012!\"\u0012=qe\u0016\u001c8/[8o\u0011\u0015A5\u00011\u0001J\u00031)\u0007\u0010\u001e:bGR4\u0015.\u001a7e!\tQ\u0015K\u0004\u0002L\u001fB\u0011A\nN\u0007\u0002\u001b*\u0011a*L\u0001\u0007yI|w\u000e\u001e \n\u0005A#\u0014A\u0002)sK\u0012,g-\u0003\u0002S'\n11\u000b\u001e:j]\u001eT!\u0001\u0015\u001b\t\u000bU\u001b\u0001\u0019\u0001#\u0002\rM|WO]2f\u0011\u001996\u0001\"a\u00011\u0006yQM\u001d:pe\"\u000bg\u000e\u001a7f\rVt7\rE\u000243nK!A\u0017\u001b\u0003\u0011q\u0012\u0017P\\1nKz\u0002\"a\r/\n\u0005u#$a\u0002(pi\"LgnZ\u0001\u0011i>,\u0015/^5wC2,g\u000e^#yaJ$2\u0001\u00121c\u0011\u0015\tG\u00011\u0001E\u0003\u00151\u0017.\u001a7e\u0011\u0015)F\u00011\u0001E\u0003\u0015\t\u0007\u000f\u001d7z)\u001d)\u0017qYAe\u0003\u0017\u0004\"a\f\u0005\u0014\u000b!9'.\u001c9\u0011\u0005=B\u0017BA5\"\u0005=)f.\u0019:z\u000bb\u0004(/Z:tS>t\u0007CA\u0018l\u0013\ta\u0017E\u0001\nSk:$\u0018.\\3SKBd\u0017mY3bE2,\u0007CA\u001ao\u0013\tyGGA\u0004Qe>$Wo\u0019;\u0011\u0005E4hB\u0001:u\u001d\ta5/C\u00016\u0013\t)H'A\u0004qC\u000e\\\u0017mZ3\n\u0005}:(BA;5+\u0005!\u0015A\u00024jK2$\u0007%A\u0004t_V\u00148-\u001a\u0011\u0002\u000b\rD\u0017\u000e\u001c3\u0002\r\rD\u0017\u000e\u001c3!)\u0015)gp`A\u0001\u0011\u0015\tw\u00021\u0001E\u0011\u0015)v\u00021\u0001E\u0011\u0015Yx\u00021\u0001E)\u0015)\u0017QAA\u0004\u0011\u0015\t\u0007\u00031\u0001E\u0011\u0015)\u0006\u00031\u0001E\u000351G.\u0019;Be\u001e,X.\u001a8ugV\u0011\u0011Q\u0002\t\u0006c\u0006=\u00111C\u0005\u0004\u0003#9(\u0001C%uKJ\fGo\u001c:\u0011\u0007M\n)\"C\u0002\u0002\u0018Q\u00121!\u00118z\u00035)\u0007\u0010\u001d:t%\u0016\u0004H.Y2fIV\u0011\u0011Q\u0004\t\u0005c\u0006}A)C\u0002\u0002\"]\u00141aU3r\u0003)\u0001(/\u001a;us:\u000bW.Z\u000b\u0002\u0013\u0006!r/\u001b;i\u001d\u0016<8\t[5mI&sG/\u001a:oC2$2!ZA\u0016\u0011\u0019\ti\u0003\u0006a\u0001\t\u0006Aa.Z<DQ&dG-\u0001\u0003d_BLHcB3\u00024\u0005U\u0012q\u0007\u0005\bCV\u0001\n\u00111\u0001E\u0011\u001d)V\u0003%AA\u0002\u0011Cqa_\u000b\u0011\u0002\u0003\u0007A)\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005u\"f\u0001#\u0002@-\u0012\u0011\u0011\t\t\u0005\u0003\u0007\ni%\u0004\u0002\u0002F)!\u0011qIA%\u0003%)hn\u00195fG.,GMC\u0002\u0002LQ\n!\"\u00198o_R\fG/[8o\u0013\u0011\ty%!\u0012\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%g\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!!\u0017\u0011\t\u0005m\u0013\u0011M\u0007\u0003\u0003;R1!a\u0018=\u0003\u0011a\u0017M\\4\n\u0007I\u000bi&\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002hA\u00191'!\u001b\n\u0007\u0005-DGA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002\u0014\u0005E\u0004\"CA:7\u0005\u0005\t\u0019AA4\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011\u0011\u0010\t\u0007\u0003w\n\t)a\u0005\u000e\u0005\u0005u$bAA@i\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005E\u0011QP\u0001\tG\u0006tW)];bYR!\u0011qQAG!\r\u0019\u0014\u0011R\u0005\u0004\u0003\u0017#$a\u0002\"p_2,\u0017M\u001c\u0005\n\u0003gj\u0012\u0011!a\u0001\u0003'\t!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR!\u0011\u0011LAJ\u0011%\t\u0019HHA\u0001\u0002\u0004\t9'\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003\u000f\u000bI\nC\u0005\u0002t}\t\t\u00111\u0001\u0002\u0014!Z\u0002\"!(\u0002$\u0006\u0015\u0016\u0011VAV\u0003_\u000b\t,!.\u00028\u0006m\u0016QXAa\u0003\u0007\u00042aLAP\u0013\r\t\t+\t\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\t9+A)`\rVs5i\u0018\u0015gS\u0016dG\r\f\u0011t_V\u00148-Z\u0015![\u0001*\u0005\u0010\u001e:bGR\u001c\b%\u0019\u0011qCJ$\be\u001c4!i\",\u0007\u0005Z1uK>\"\u0018.\\3ti\u0006l\u0007\u000fI8sA%tG/\u001a:wC2\u00043o\\;sG\u0016t\u0013!C1sOVlWM\u001c;tC\t\ti+\u0001B\u0011\u0015\u0001\u0002\u0003\u0005I!sOVlWM\u001c;tu)\u0001\u0003\u0005\t\u0011!A)\u0002c-[3mI\u0002j\u0003e]3mK\u000e$8\u000fI<iS\u000eD\u0007\u0005]1si\u0002zg\r\t;iK\u0002\u001ax.\u001e:dK\u0002\u001a\bn\\;mI\u0002\u0012W\rI3yiJ\f7\r^3eY\u0001\ng\u000e\u001a\u0011tkB\u0004xN\u001d;fI\u0002\u001aHO]5oO\u00022\u0018\r\\;fg\u0002\n'/\u001a\u0011bg\u0002\u001a\u0018-\\3!CN\u0004C\u000f[3!M&,G\u000eZ:!_\u001a\u0004C\u000f[3!KF,\u0018N^1mK:$\bEZ;oGRLwN\u001c\u0011a\u000bb#&+Q\"UA:R\u0001\u0005\t\u0011!A\u0001R\u0003e]8ve\u000e,\u0007%\f\u0011bA\u0011\fG/Z\u0018uS6,7\u000f^1na\u0002z'\u000fI5oi\u0016\u0014h/\u00197!G>dW/\u001c8!MJ|W\u000eI<iKJ,\u0007\u0005\u00194jK2$\u0007\rI:i_VdG\r\t2fA\u0015DHO]1di\u0016$'\u0002\t\u0011\u0002\u0011\u0015D\u0018-\u001c9mKN\f#!a-\u0002\u000b\u001bR\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006fJ-F\u0003J;C\u0006\t+J\u001b\u0016\u001bF+Q'QA\u001d\u0012\u0004'M\u001d.aaj\u0013G\r\u00111ci\u0002\u0004G\u000f\u00191]E\u00124\u0007N\u001b7O%Z$\u0002\t\u0011!A\u0001\u0002\u0003E\r\u00192s)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~Cse^3fW\u001eb\u0003\u0005^5nKN$\u0018-\u001c9(eA\n\u0014(\f\u00199[E\u0012\u0004\u0005M\u0019;aAR\u0004\u0007\r\u00182eM\"TGN\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001\u001a4G\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015(I>Lx\u0005\f\u0011E\u0003R+uE\r\u00192s5\u0002\u0004(L\u00193O%Z$\u0002\t\u0011!A\u0001\u0002\u0003E\r\u001a5\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\":3+R\"P\u001d\u0012\u001bv\u0005\f\u0011uS6,7\u000f^1na\u001e\u0012\u0004'M\u001d.cAj\u0003'\r\u00111ai\u0002\u0004G\u000f\u00192]A\u0002\u0004\u0007\r\u00192O%Z$\u0002\t\u0011!A\u0001\u0002\u0003%\r\u00181aA\u0002\u0004'\r\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)O\u0011\f\u0017p]\u0014-A%tG/\u001a:wC2\u0004S\u0007\t3bsN\u00043\u0007\t5pkJ\u001c\be\u000e\u0011nS:,H/Z:*w)\u0001\u0003\u0005\t\u0011!A\u0001*$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u0014tK\u000e|g\u000eZ:(Y\u0001Jg\u000e^3sm\u0006d\u0007%\u000e\u0011i_V\u00148\u000fI\u001a1AM,7m\u001c8eg\u0002\n\u0004%\\5mY&\u001cXmY8oIN\u0004\u0013\u0007I7jGJ|7/Z2p]\u0012\u001c\u0018f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00114a9\u0002\u0004'\r\u00191c)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~Cs%T(O)\";C\u0006I%O)\u0016\u0013f+\u0011'!OI\u0002$'M\u00172c\u001d\u0002\u0013,R!SAQ{\u0005%T(O)\"K3H\u0003\u0011!A\u0001\u0002\u0003\u0005I\u00192\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\":S*\u0013(V)\u0016;C\u0006I%O)\u0016\u0013f+\u0011'!OE\u00124\u0007\t\u001a4uU*$(N\u001d/aA\u0012\u0004\u0007M\u0019(A\u0011\u000b\u0015\f\t+PAM+5i\u0014(ESmR\u0001\u0005\t\u0011!A\u0001\u0002S'\u000e\u0006!A\u0005!an\u001c;fC\t\tI,A2\u000bA\u0001\u0002\u0003\u0005\u00165fA}3UKT\"`A\u0019,hn\u0019;j_:\u0004\u0013n\u001d\u0011fcVLg/\u00197f]R\u0004Co\u001c\u0011uQ\u0016\u00043+\u0015'.gR\fg\u000eZ1sI\u00022WO\\2uS>t\u0007\u0005Y#Y)J\u000b5\t\u0016\u0015gS\u0016dG\r\t$S\u001f6\u00033o\\;sG\u0016L\u0003M\u0003\u0011!\u0003\u00159'o\\;qC\t\ty,\u0001\beCR,G/[7f?\u001a,hnY:\u0002\u000bMLgnY3\"\u0005\u0005\u0015\u0017!B\u001a/a9\u0002\u0004\"B1\u0006\u0001\u0004!\u0005\"B+\u0006\u0001\u0004!\u0005\"B>\u0006\u0001\u0004!\u0015aB;oCB\u0004H.\u001f\u000b\u0005\u0003#\fi\u000eE\u00034\u0003'\f9.C\u0002\u0002VR\u0012aa\u00149uS>t\u0007CB\u001a\u0002Z\u0012#E)C\u0002\u0002\\R\u0012a\u0001V;qY\u0016\u001c\u0004\u0002CAp\r\u0005\u0005\t\u0019A3\u0002\u0007a$\u0003'\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0002fB!\u00111LAt\u0013\u0011\tI/!\u0018\u0003\r=\u0013'.Z2u\u0001")
public class DatePart
extends UnaryExpression
implements RuntimeReplaceable,
Serializable {
    private final Expression field;
    private final Expression source;
    private final Expression child;
    private Expression canonicalized;
    private Seq<Enumeration.Value> nodePatterns;
    private volatile boolean bitmap$0;

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(DatePart datePart) {
        return DatePart$.MODULE$.unapply(datePart);
    }

    public static Expression toEquivalentExpr(Expression expression, Expression expression2) {
        return DatePart$.MODULE$.toEquivalentExpr(expression, expression2);
    }

    public static Expression parseExtractField(String string, Expression expression, Function0<Nothing$> function0) {
        return DatePart$.MODULE$.parseExtractField(string, expression, function0);
    }

    @Override
    public boolean nullable() {
        return RuntimeReplaceable.nullable$(this);
    }

    @Override
    public DataType dataType() {
        return RuntimeReplaceable.dataType$(this);
    }

    @Override
    public String sql() {
        return RuntimeReplaceable.sql$(this);
    }

    @Override
    public String mkString(Seq<String> childrenString) {
        return RuntimeReplaceable.mkString$(this, childrenString);
    }

    @Override
    public final boolean foldable() {
        return Unevaluable.foldable$(this);
    }

    @Override
    public final Object eval(InternalRow input) {
        return Unevaluable.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return Unevaluable.eval$default$1$(this);
    }

    @Override
    public final ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return Unevaluable.doGenCode$(this, ctx, ev);
    }

    private Expression canonicalized$lzycompute() {
        DatePart datePart = this;
        synchronized (datePart) {
            if (!this.bitmap$0) {
                this.canonicalized = RuntimeReplaceable.canonicalized$(this);
                this.bitmap$0 = true;
            }
        }
        return this.canonicalized;
    }

    @Override
    public Expression canonicalized() {
        return !this.bitmap$0 ? this.canonicalized$lzycompute() : this.canonicalized;
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    @Override
    public final void org$apache$spark$sql$catalyst$expressions$RuntimeReplaceable$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public Expression field() {
        return this.field;
    }

    public Expression source() {
        return this.source;
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public Iterator<Object> flatArguments() {
        return package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{this.field(), this.source()}));
    }

    @Override
    public Seq<Expression> exprsReplaced() {
        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{this.field(), this.source()}));
    }

    @Override
    public String prettyName() {
        return "date_part";
    }

    @Override
    public DatePart withNewChildInternal(Expression newChild) {
        Expression x$1 = newChild;
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        return this.copy(x$2, x$3, x$1);
    }

    public DatePart copy(Expression field, Expression source, Expression child) {
        return new DatePart(field, source, child);
    }

    public Expression copy$default$1() {
        return this.field();
    }

    public Expression copy$default$2() {
        return this.source();
    }

    public Expression copy$default$3() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "DatePart";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.field();
                break;
            }
            case 1: {
                object = this.source();
                break;
            }
            case 2: {
                object = this.child();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof DatePart;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "field";
                break;
            }
            case 1: {
                string = "source";
                break;
            }
            case 2: {
                string = "child";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof DatePart)) return false;
        boolean bl = true;
        if (!bl) return false;
        DatePart datePart = (DatePart)x$1;
        Expression expression = this.field();
        Expression expression2 = datePart.field();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.source();
        Expression expression4 = datePart.source();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.child();
        Expression expression6 = datePart.child();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!datePart.canEqual(this)) return false;
        return true;
    }

    public DatePart(Expression field, Expression source, Expression child) {
        this.field = field;
        this.source = source;
        this.child = child;
        Unevaluable.$init$(this);
        RuntimeReplaceable.$init$(this);
        Statics.releaseFence();
    }

    public DatePart(Expression field, Expression source) {
        this(field, source, DatePart$.MODULE$.toEquivalentExpr(field, source));
    }
}

