/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.DatePart$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Extract$;
import org.apache.spark.sql.catalyst.expressions.RuntimeReplaceable;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.Unevaluable;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.DataType;
import scala.Enumeration;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(field FROM source) - Extracts a part of the date/timestamp or interval source.", arguments="\n    Arguments:\n      * field - selects which part of the source should be extracted\n          - Supported string values of `field` for dates and timestamps are(case insensitive):\n              - \"YEAR\", (\"Y\", \"YEARS\", \"YR\", \"YRS\") - the year field\n              - \"YEAROFWEEK\" - the ISO 8601 week-numbering year that the datetime falls in. For example, 2005-01-02 is part of the 53rd week of year 2004, so the result is 2004\n              - \"QUARTER\", (\"QTR\") - the quarter (1 - 4) of the year that the datetime falls in\n              - \"MONTH\", (\"MON\", \"MONS\", \"MONTHS\") - the month field (1 - 12)\n              - \"WEEK\", (\"W\", \"WEEKS\") - the number of the ISO 8601 week-of-week-based-year. A week is considered to start on a Monday and week 1 is the first week with >3 days. In the ISO week-numbering system, it is possible for early-January dates to be part of the 52nd or 53rd week of the previous year, and for late-December dates to be part of the first week of the next year. For example, 2005-01-02 is part of the 53rd week of year 2004, while 2012-12-31 is part of the first week of 2013\n              - \"DAY\", (\"D\", \"DAYS\") - the day of the month field (1 - 31)\n              - \"DAYOFWEEK\",(\"DOW\") - the day of the week for datetime as Sunday(1) to Saturday(7)\n              - \"DAYOFWEEK_ISO\",(\"DOW_ISO\") - ISO 8601 based day of the week for datetime as Monday(1) to Sunday(7)\n              - \"DOY\" - the day of the year (1 - 365/366)\n              - \"HOUR\", (\"H\", \"HOURS\", \"HR\", \"HRS\") - The hour field (0 - 23)\n              - \"MINUTE\", (\"M\", \"MIN\", \"MINS\", \"MINUTES\") - the minutes field (0 - 59)\n              - \"SECOND\", (\"S\", \"SEC\", \"SECONDS\", \"SECS\") - the seconds field, including fractional parts\n          - Supported string values of `field` for interval(which consists of `months`, `days`, `microseconds`) are(case insensitive):\n              - \"YEAR\", (\"Y\", \"YEARS\", \"YR\", \"YRS\") - the total `months` / 12\n              - \"MONTH\", (\"MON\", \"MONS\", \"MONTHS\") - the total `months` % 12\n              - \"DAY\", (\"D\", \"DAYS\") - the `days` part of interval\n              - \"HOUR\", (\"H\", \"HOURS\", \"HR\", \"HRS\") - how many hours the `microseconds` contains\n              - \"MINUTE\", (\"M\", \"MIN\", \"MINS\", \"MINUTES\") - how many minutes left after taking hours from `microseconds`\n              - \"SECOND\", (\"S\", \"SEC\", \"SECONDS\", \"SECS\") - how many second with fractions left after taking hours and minutes from `microseconds`\n      * source - a date/timestamp or interval column from where `field` should be extracted\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(YEAR FROM TIMESTAMP '2019-08-12 01:00:00.123456');\n       2019\n      > SELECT _FUNC_(week FROM timestamp'2019-08-12 01:00:00.123456');\n       33\n      > SELECT _FUNC_(doy FROM DATE'2019-08-12');\n       224\n      > SELECT _FUNC_(SECONDS FROM timestamp'2019-10-01 00:00:01.000001');\n       1.000001\n      > SELECT _FUNC_(days FROM interval 5 days 3 hours 7 minutes);\n       5\n      > SELECT _FUNC_(seconds FROM interval 5 hours 30 seconds 1 milliseconds 1 microseconds);\n       30.001001\n      > SELECT _FUNC_(MONTH FROM INTERVAL '2021-11' YEAR TO MONTH);\n       11\n      > SELECT _FUNC_(MINUTE FROM INTERVAL '123 23:55:59.002001' DAY TO SECOND);\n       55\n  ", note="\n    The _FUNC_ function is equivalent to `date_part(field, source)`.\n  ", group="datetime_funcs", since="3.0.0")
@ScalaSignature(bytes="\u0006\u0005\u0005]g\u0001B\u0010!\u00016B\u0001b\u0012\u0001\u0003\u0016\u0004%\t\u0001\u0013\u0005\t\u0019\u0002\u0011\t\u0012)A\u0005\u0013\"AQ\n\u0001BK\u0002\u0013\u0005\u0001\n\u0003\u0005O\u0001\tE\t\u0015!\u0003J\u0011!y\u0005A!f\u0001\n\u0003A\u0005\u0002\u0003)\u0001\u0005#\u0005\u000b\u0011B%\t\u000bE\u0003A\u0011\u0001*\t\u000bE\u0003A\u0011A,\t\u000bi\u0003A\u0011I.\t\u000b\t\u0004A\u0011I2\t\u000b\u001d\u0004A\u0011\t5\t\u000bQ\u0004A\u0011K;\t\u000fa\u0004\u0011\u0011!C\u0001s\"9Q\u0010AI\u0001\n\u0003q\b\u0002CA\n\u0001E\u0005I\u0011\u0001@\t\u0011\u0005U\u0001!%A\u0005\u0002yD\u0011\"a\u0006\u0001\u0003\u0003%\t%!\u0007\t\u0013\u0005%\u0002!!A\u0005\u0002\u0005-\u0002\"CA\u001a\u0001\u0005\u0005I\u0011AA\u001b\u0011%\tY\u0004AA\u0001\n\u0003\ni\u0004C\u0005\u0002J\u0001\t\t\u0011\"\u0001\u0002L!I\u0011Q\u000b\u0001\u0002\u0002\u0013\u0005\u0013q\u000b\u0005\n\u00037\u0002\u0011\u0011!C!\u0003;:\u0011\"!$!\u0003\u0003E\t!a$\u0007\u0011}\u0001\u0013\u0011!E\u0001\u0003#Ca!U\r\u0005\u0002\u0005%\u0006\"CAV3\u0005\u0005IQIAW\u0011%\ty+GA\u0001\n\u0003\u000b\t\fC\u0005\u0002:f\t\t\u0011\"!\u0002<\"I\u0011QZ\r\u0002\u0002\u0013%\u0011q\u001a\u0002\b\u000bb$(/Y2u\u0015\t\t#%A\u0006fqB\u0014Xm]:j_:\u001c(BA\u0012%\u0003!\u0019\u0017\r^1msN$(BA\u0013'\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003O!\nQa\u001d9be.T!!\u000b\u0016\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0013aA8sO\u000e\u00011#\u0002\u0001/eUZ\u0004CA\u00181\u001b\u0005\u0001\u0013BA\u0019!\u0005=)f.\u0019:z\u000bb\u0004(/Z:tS>t\u0007CA\u00184\u0013\t!\u0004E\u0001\nSk:$\u0018.\\3SKBd\u0017mY3bE2,\u0007C\u0001\u001c:\u001b\u00059$\"\u0001\u001d\u0002\u000bM\u001c\u0017\r\\1\n\u0005i:$a\u0002)s_\u0012,8\r\u001e\t\u0003y\u0011s!!\u0010\"\u000f\u0005y\nU\"A \u000b\u0005\u0001c\u0013A\u0002\u001fs_>$h(C\u00019\u0013\t\u0019u'A\u0004qC\u000e\\\u0017mZ3\n\u0005\u00153%\u0001D*fe&\fG.\u001b>bE2,'BA\"8\u0003\u00151\u0017.\u001a7e+\u0005I\u0005CA\u0018K\u0013\tY\u0005E\u0001\u0006FqB\u0014Xm]:j_:\faAZ5fY\u0012\u0004\u0013AB:pkJ\u001cW-A\u0004t_V\u00148-\u001a\u0011\u0002\u000b\rD\u0017\u000e\u001c3\u0002\r\rD\u0017\u000e\u001c3!\u0003\u0019a\u0014N\\5u}Q!1\u000bV+W!\ty\u0003\u0001C\u0003H\u000f\u0001\u0007\u0011\nC\u0003N\u000f\u0001\u0007\u0011\nC\u0003P\u000f\u0001\u0007\u0011\nF\u0002T1fCQa\u0012\u0005A\u0002%CQ!\u0014\u0005A\u0002%\u000bQB\u001a7bi\u0006\u0013x-^7f]R\u001cX#\u0001/\u0011\u0007qjv,\u0003\u0002_\r\nA\u0011\n^3sCR|'\u000f\u0005\u00027A&\u0011\u0011m\u000e\u0002\u0004\u0003:L\u0018!D3yaJ\u001c(+\u001a9mC\u000e,G-F\u0001e!\raT-S\u0005\u0003M\u001a\u00131aU3r\u0003!i7n\u0015;sS:<GCA5r!\tQgN\u0004\u0002lYB\u0011ahN\u0005\u0003[^\na\u0001\u0015:fI\u00164\u0017BA8q\u0005\u0019\u0019FO]5oO*\u0011Qn\u000e\u0005\u0006e.\u0001\ra]\u0001\u000fG\"LG\u000e\u001a:f]N#(/\u001b8h!\raT-[\u0001\u0015o&$\bNT3x\u0007\"LG\u000eZ%oi\u0016\u0014h.\u00197\u0015\u0005M3\b\"B<\r\u0001\u0004I\u0015\u0001\u00038fo\u000eC\u0017\u000e\u001c3\u0002\t\r|\u0007/\u001f\u000b\u0005'j\\H\u0010C\u0004H\u001bA\u0005\t\u0019A%\t\u000f5k\u0001\u0013!a\u0001\u0013\"9q*\u0004I\u0001\u0002\u0004I\u0015AD2paf$C-\u001a4bk2$H%M\u000b\u0002\u007f*\u001a\u0011*!\u0001,\u0005\u0005\r\u0001\u0003BA\u0003\u0003\u001fi!!a\u0002\u000b\t\u0005%\u00111B\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u00048\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003#\t9AA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\tY\u0002\u0005\u0003\u0002\u001e\u0005\u001dRBAA\u0010\u0015\u0011\t\t#a\t\u0002\t1\fgn\u001a\u0006\u0003\u0003K\tAA[1wC&\u0019q.a\b\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u00055\u0002c\u0001\u001c\u00020%\u0019\u0011\u0011G\u001c\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\u0007}\u000b9\u0004C\u0005\u0002:M\t\t\u00111\u0001\u0002.\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!a\u0010\u0011\u000b\u0005\u0005\u0013qI0\u000e\u0005\u0005\r#bAA#o\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0007y\u000b\u0019%\u0001\u0005dC:,\u0015/^1m)\u0011\ti%a\u0015\u0011\u0007Y\ny%C\u0002\u0002R]\u0012qAQ8pY\u0016\fg\u000e\u0003\u0005\u0002:U\t\t\u00111\u0001`\u0003I\u0001(o\u001c3vGR,E.Z7f]Rt\u0015-\\3\u0015\t\u0005m\u0011\u0011\f\u0005\n\u0003s1\u0012\u0011!a\u0001\u0003[\ta!Z9vC2\u001cH\u0003BA'\u0003?B\u0001\"!\u000f\u0018\u0003\u0003\u0005\ra\u0018\u0015\u001c\u0001\u0005\r\u0014\u0011NA6\u0003_\n\t(!\u001e\u0002x\u0005m\u0014QPAA\u0003\u0007\u000b9)!#\u0011\u0007=\n)'C\u0002\u0002h\u0001\u0012Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0002n\u0005)vLR+O\u0007~Cc-[3mI\u00022%kT'!g>,(oY3*A5\u0002S\t\u001f;sC\u000e$8\u000fI1!a\u0006\u0014H\u000fI8gAQDW\r\t3bi\u0016|C/[7fgR\fW\u000e\u001d\u0011pe\u0002Jg\u000e^3sm\u0006d\u0007e]8ve\u000e,g&A\u0005be\u001e,X.\u001a8ug\u0006\u0012\u00111O\u0001\u0014L*\u0001\u0003\u0005\t\u0011Be\u001e,X.\u001a8ugjR\u0001\u0005\t\u0011!A\u0001R\u0003EZ5fY\u0012\u0004S\u0006I:fY\u0016\u001cGo\u001d\u0011xQ&\u001c\u0007\u000e\t9beR\u0004sN\u001a\u0011uQ\u0016\u00043o\\;sG\u0016\u00043\u000f[8vY\u0012\u0004#-\u001a\u0011fqR\u0014\u0018m\u0019;fI*\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005I\u0017!'V\u0004\bo\u001c:uK\u0012\u00043\u000f\u001e:j]\u001e\u0004c/\u00197vKN\u0004sN\u001a\u0011aM&,G\u000e\u001a1!M>\u0014\b\u0005Z1uKN\u0004\u0013M\u001c3!i&lWm\u001d;b[B\u001c\b%\u0019:fQ\r\f7/\u001a\u0011j]N,gn]5uSZ,\u0017F\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011.A\tJV)\u0011*#Y\u0001B#%\u0017\u0012-A\tJV)\u0011*TE1\u0002#%\u0017*#Y\u0001\u0012\u0013LU*#S\u0001j\u0003\u0005\u001e5fAe,\u0017M\u001d\u0011gS\u0016dGM\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005I\u0017!Ee+\u0015IU(G/\u0016+5J\t\u0011.AQDW\rI%T\u001f\u0002Bd\u0007M\u0019!o\u0016,7.\f8v[\n,'/\u001b8hAe,\u0017M\u001d\u0011uQ\u0006$\b\u0005\u001e5fA\u0011\fG/\u001a;j[\u0016\u0004c-\u00197mg\u0002JgN\f\u0011G_J\u0004S\r_1na2,G\u0006\t\u001a1aUj\u0003'M\u00171e\u0001J7\u000f\t9beR\u0004sN\u001a\u0011uQ\u0016\u0004Sg\r:eA],Wm\u001b\u0011pM\u0002JX-\u0019:!eA\u0002D\u0007\f\u0011t_\u0002\"\b.\u001a\u0011sKN,H\u000e\u001e\u0011jg\u0002\u0012\u0004\u0007\r\u001b\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011![\u0001\u0012\u0013+V!S)\u0016\u0013&\u0005\f\u0011)EE#&KI\u0015![\u0001\"\b.\u001a\u0011rk\u0006\u0014H/\u001a:!QE\u0002S\u0006\t\u001b*A=4\u0007\u0005\u001e5fAe,\u0017M\u001d\u0011uQ\u0006$\b\u0005\u001e5fA\u0011\fG/\u001a;j[\u0016\u0004c-\u00197mg\u0002JgN\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005I\u0017!E5{e\n\u0016%#Y\u0001B#%T(OE1\u0002#%T(O'\nb\u0003EI'P\u001dRC5KI\u0015![\u0001\"\b.\u001a\u0011n_:$\b\u000e\t4jK2$\u0007\u0005K\u0019![\u0001\n$'\u000b\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011.A\t:V)R&#Y\u0001B#e\u0016\u0012-A\t:V)R&TE%\u0002S\u0006\t;iK\u0002rW/\u001c2fe\u0002zg\r\t;iK\u0002J5k\u0014\u00119mA\n\u0004e^3fW6zg-L<fK.l#-Y:fI6JX-\u0019:/A\u0005\u0003s/Z3lA%\u001c\beY8og&$WM]3eAQ|\u0007e\u001d;beR\u0004sN\u001c\u0011bA5{g\u000eZ1zA\u0005tG\rI<fK.\u0004\u0013\u0007I5tAQDW\r\t4jeN$\be^3fW\u0002:\u0018\u000e\u001e5!}M\u0002C-Y=t]\u0001Je\u000e\t;iK\u0002J5k\u0014\u0011xK\u0016\\WF\\;nE\u0016\u0014\u0018N\\4!gf\u001cH/Z7-A%$\b%[:!a>\u001c8/\u001b2mK\u00022wN\u001d\u0011fCJd\u00170\f&b]V\f'/\u001f\u0011eCR,7\u000f\t;pA\t,\u0007\u0005]1si\u0002zg\r\t;iK\u0002*$G\u001c3!_J\u0004Sg\r:eA],Wm\u001b\u0011pM\u0002\"\b.\u001a\u0011qe\u00164\u0018n\\;tAe,\u0017M\u001d\u0017!C:$\u0007EZ8sA1\fG/Z\u0017EK\u000e,WNY3sA\u0011\fG/Z:!i>\u0004#-\u001a\u0011qCJ$\be\u001c4!i\",\u0007EZ5sgR\u0004s/Z3lA=4\u0007\u0005\u001e5fA9,\u0007\u0010\u001e\u0011zK\u0006\u0014h\u0006\t$pe\u0002*\u00070Y7qY\u0016d\u0003E\r\u00191k5\u0002\u0014'\f\u00193A%\u001c\b\u0005]1si\u0002zg\r\t;iK\u0002*4G\u001d3!o\u0016,7\u000eI8gAe,\u0017M\u001d\u00113aA\"D\u0006I<iS2,\u0007E\r\u00192e5\n$'L\u001a2A%\u001c\b\u0005]1si\u0002zg\r\t;iK\u00022\u0017N]:uA],Wm\u001b\u0011pM\u0002\u0012\u0004'M\u001a\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011![\u0001\u0012C)Q-#Y\u0001B#\u0005\u0012\u0012-A\t\"\u0015)W*#S\u0001j\u0003\u0005\u001e5fA\u0011\f\u0017\u0010I8gAQDW\rI7p]RD\u0007EZ5fY\u0012\u0004\u0003&\r\u0011.AM\n\u0014F\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005I\u0017!E\u0011\u000b\u0015l\u0014$X\u000b\u0016[%\u0005\f\u0015#\t>;&%\u000b\u0011.AQDW\r\t3bs\u0002zg\r\t;iK\u0002:X-Z6!M>\u0014\b\u0005Z1uKRLW.\u001a\u0011bg\u0002\u001aVO\u001c3bs\"\n\u0014\u0006\t;pAM\u000bG/\u001e:eCfDs'\u000b\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011.A\t\"\u0015)W(G/\u0016+5jX%T\u001f\nb\u0003F\t#P/~K5k\u0014\u0012*A5\u0002\u0013jU(!qY\u0002\u0014\u0007\t2bg\u0016$\u0007\u0005Z1zA=4\u0007\u0005\u001e5fA],Wm\u001b\u0011g_J\u0004C-\u0019;fi&lW\rI1tA5{g\u000eZ1zQEJ\u0003\u0005^8!'VtG-Y=)o%R\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002S\u0006\t\u0012E\u001ff\u0013\u0003%\f\u0011uQ\u0016\u0004C-Y=!_\u001a\u0004C\u000f[3!s\u0016\f'\u000f\t\u00152A5\u00023GN\u001b0gY2\u0014F\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005I\u0017!E!{UK\u0015\u0012-A!\u0012\u0003J\t\u0017!E!{UKU*#Y\u0001\u0012\u0003J\u0015\u0012-A\tB%k\u0015\u0012*A5\u0002C\u000b[3!Q>,(\u000f\t4jK2$\u0007\u0005\u000b\u0019![\u0001\u00124'\u000b\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011.A\tj\u0015JT+U\u000b\nb\u0003\u0005\u000b\u0012NE1\u0002#%T%OE1\u0002#%T%O'\nb\u0003EI'J\u001dV#Vi\u0015\u0012*A5\u0002C\u000f[3![&tW\u000f^3tA\u0019LW\r\u001c3!QA\u0002S\u0006I\u001b:S)\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001j\u0003EI*F\u0007>sEI\t\u0017!Q\t\u001a&\u0005\f\u0011#'\u0016\u001b%\u0005\f\u0011#'\u0016\u001buJ\u0014#TE1\u0002#eU#D'\nJ\u0003%\f\u0011uQ\u0016\u00043/Z2p]\u0012\u001c\bEZ5fY\u0012d\u0003%\u001b8dYV$\u0017N\\4!MJ\f7\r^5p]\u0006d\u0007\u0005]1siNT\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011.AM+\b\u000f]8si\u0016$\u0007e\u001d;sS:<\u0007E^1mk\u0016\u001c\be\u001c4!A\u001aLW\r\u001c3aA\u0019|'\u000fI5oi\u0016\u0014h/\u00197)o\"L7\r\u001b\u0011d_:\u001c\u0018n\u001d;tA=4\u0007\u0005Y7p]RD7\u000f\u0019\u0017!A\u0012\f\u0017p\u001d1-A\u0001l\u0017n\u0019:pg\u0016\u001cwN\u001c3tA&\u0002\u0013M]3)G\u0006\u001cX\rI5og\u0016t7/\u001b;jm\u0016L#H\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005I\u0017!Ee+\u0015I\u0015\u0012-A!\u0012\u0013L\t\u0017!Ee+\u0015IU*#Y\u0001\u0012\u0013L\u0015\u0012-A\tJ&k\u0015\u0012*A5\u0002C\u000f[3!i>$\u0018\r\u001c\u0011a[>tG\u000f[:aA=\u0002\u0013G\r\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011.A\tjuJ\u0014+IE1\u0002\u0003FI'P\u001d\nb\u0003EI'P\u001dN\u0013C\u0006\t\u0012N\u001f:#\u0006j\u0015\u0012*A5\u0002C\u000f[3!i>$\u0018\r\u001c\u0011a[>tG\u000f[:aA\u0015\u0002\u0013G\r\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011.A\t\"\u0015)\u0017\u0012-A!\u0012CI\t\u0017!E\u0011\u000b\u0015l\u0015\u0012*A5\u0002C\u000f[3!A\u0012\f\u0017p\u001d1!a\u0006\u0014H\u000fI8gA%tG/\u001a:wC2T\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002S\u0006\t\u0012I\u001fV\u0013&\u0005\f\u0011)E!\u0013C\u0006\t\u0012I\u001fV\u00136K\t\u0017!E!\u0013&\u0005\f\u0011#\u0011J\u001b&%\u000b\u0011.A!|w\u000fI7b]f\u0004\u0003n\\;sg\u0002\"\b.\u001a\u0011a[&\u001c'o\\:fG>tGm\u001d1!G>tG/Y5og*\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001j\u0003EI'J\u001dV#VI\t\u0017!Q\tj%\u0005\f\u0011#\u001b&s%\u0005\f\u0011#\u001b&s5K\t\u0017!E5Ke*\u0016+F'\nJ\u0003%\f\u0011i_^\u0004S.\u00198zA5Lg.\u001e;fg\u0002bWM\u001a;!C\u001a$XM\u001d\u0011uC.Lgn\u001a\u0011i_V\u00148\u000f\t4s_6\u0004\u0003-\\5de>\u001cXmY8oIN\u0004'\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003%\f\u0011#'\u0016\u001buJ\u0014##Y\u0001B#e\u0015\u0012-A\t\u001aVi\u0011\u0012-A\t\u001aViQ(O\tN\u0013C\u0006\t\u0012T\u000b\u000e\u001b&%\u000b\u0011.A!|w\u000fI7b]f\u00043/Z2p]\u0012\u0004s/\u001b;iA\u0019\u0014\u0018m\u0019;j_:\u001c\b\u0005\\3gi\u0002\ng\r^3sAQ\f7.\u001b8hA!|WO]:!C:$\u0007%\\5okR,7\u000f\t4s_6\u0004\u0003-\\5de>\u001cXmY8oIN\u0004'\u0002\t\u0011!A\u0001\u0002#\u0006I:pkJ\u001cW\rI\u0017!C\u0002\"\u0017\r^30i&lWm\u001d;b[B\u0004sN\u001d\u0011j]R,'O^1mA\r|G.^7oA\u0019\u0014x.\u001c\u0011xQ\u0016\u0014X\r\t1gS\u0016dG\r\u0019\u0011tQ>,H\u000e\u001a\u0011cK\u0002*\u0007\u0010\u001e:bGR,GM\u0003\u0011!\u0003!)\u00070Y7qY\u0016\u001c\u0018EAA=\u0003\u00155$\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK-F\u0003J\u0003cIU(NAQKU*R*U\u00036\u0003\u0006e\n\u001a1cej\u0003\u0007O\u00172e\u0001\u0002\u0014G\u000f\u00191uA\u0002d&\r\u001a4iU2t%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!eA\n\u0014H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015xK\u0016\\\u0007E\u0012*P\u001b\u0002\"\u0018.\\3ti\u0006l\u0007o\n\u001a1cej\u0003\u0007O\u00172e\u0001\u0002\u0014G\u000f\u00191uA\u0002d&\r\u001a4iU2t%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!gMR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006\u0006Z8zA\u0019\u0013v*\u0014\u0011E\u0003R+uE\r\u00192s5\u0002\u0004(L\u00193O%Z$\u0002\t\u0011!A\u0001\u0002\u0003E\r\u001a5\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"\u001aViQ(O\tN\u0003cIU(NAQLW.Z:uC6\u0004xE\r\u00192s5\n\u0004'\f\u00192AA\u0002$\b\r\u0019;aEr\u0003\u0007\r\u00191aE:\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00112]A\u0002\u0004\u0007\r\u00192\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"\"\u0017-_:!\rJ{U\nI5oi\u0016\u0014h/\u00197!k\u0001\"\u0017-_:!g\u0001Bw.\u001e:tA]\u0002S.\u001b8vi\u0016\u001c\u0018f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00116\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"\u001aXmY8oIN\u0004cIU(NA%tG/\u001a:wC2\u0004S\u0007\t5pkJ\u001c\be\r\u0019!g\u0016\u001cwN\u001c3tAE\u0002S.\u001b7mSN,7m\u001c8eg\u0002\n\u0004%\\5de>\u001cXmY8oINL3H\u0003\u0011!A\u0001\u0002\u0003\u0005I\u001a1]A\u0002\u0014\u0007\r\u00192\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"juJ\u0014+IA\u0019\u0013v*\u0014\u0011J\u001dR+%KV!MA\u001d\u0012\u0004GM\u0019.cE:\u0003%W#B%\u0002\"v\nI'P\u001dRC\u0015f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00112c)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~CS*\u0013(V)\u0016\u0003cIU(NA%sE+\u0012*W\u00032\u0003s%\r\u001a4AI\u001a$(N\u001b;ker\u0003\u0007\r\u001a1aE:\u0003\u0005R!ZAQ{\u0005eU#D\u001f:#\u0015f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00116k)\u0001\u0003%\u0001\u0003o_R,\u0017EAA@\u0003!S\u0001\u0005\t\u0011!)\",\u0007e\u0018$V\u001d\u000e{\u0006EZ;oGRLwN\u001c\u0011jg\u0002*\u0017/^5wC2,g\u000e\u001e\u0011u_\u0002\u0002G-\u0019;f?B\f'\u000f\u001e\u0015gS\u0016dG\r\f\u0011t_V\u00148-Z\u0015a])\u0001\u0003%A\u0003he>,\b/\t\u0002\u0002\u0006\u0006qA-\u0019;fi&lWm\u00184v]\u000e\u001c\u0018!B:j]\u000e,\u0017EAAF\u0003\u0015\u0019d\u0006\r\u00181\u0003\u001d)\u0005\u0010\u001e:bGR\u0004\"aL\r\u0014\u000be\t\u0019*a(\u0011\u0011\u0005U\u00151T%J\u0013Nk!!a&\u000b\u0007\u0005eu'A\u0004sk:$\u0018.\\3\n\t\u0005u\u0015q\u0013\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u001c\u0004\u0003BAQ\u0003Ok!!a)\u000b\t\u0005\u0015\u00161E\u0001\u0003S>L1!RAR)\t\ty)\u0001\u0005u_N#(/\u001b8h)\t\tY\"A\u0003baBd\u0017\u0010F\u0004T\u0003g\u000b),a.\t\u000b\u001dc\u0002\u0019A%\t\u000b5c\u0002\u0019A%\t\u000b=c\u0002\u0019A%\u0002\u000fUt\u0017\r\u001d9msR!\u0011QXAe!\u00151\u0014qXAb\u0013\r\t\tm\u000e\u0002\u0007\u001fB$\u0018n\u001c8\u0011\rY\n)-S%J\u0013\r\t9m\u000e\u0002\u0007)V\u0004H.Z\u001a\t\u0011\u0005-W$!AA\u0002M\u000b1\u0001\u001f\u00131\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\t\t\u000e\u0005\u0003\u0002\u001e\u0005M\u0017\u0002BAk\u0003?\u0011aa\u00142kK\u000e$\b")
public class Extract
extends UnaryExpression
implements RuntimeReplaceable,
Serializable {
    private final Expression field;
    private final Expression source;
    private final Expression child;
    private Expression canonicalized;
    private Seq<Enumeration.Value> nodePatterns;
    private volatile boolean bitmap$0;

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(Extract extract2) {
        return Extract$.MODULE$.unapply(extract2);
    }

    public static Function1<Tuple3<Expression, Expression, Expression>, Extract> tupled() {
        return Extract$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, Extract>>> curried() {
        return Extract$.MODULE$.curried();
    }

    @Override
    public boolean nullable() {
        return RuntimeReplaceable.nullable$(this);
    }

    @Override
    public DataType dataType() {
        return RuntimeReplaceable.dataType$(this);
    }

    @Override
    public String sql() {
        return RuntimeReplaceable.sql$(this);
    }

    @Override
    public final boolean foldable() {
        return Unevaluable.foldable$(this);
    }

    @Override
    public final Object eval(InternalRow input) {
        return Unevaluable.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return Unevaluable.eval$default$1$(this);
    }

    @Override
    public final ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return Unevaluable.doGenCode$(this, ctx, ev);
    }

    private Expression canonicalized$lzycompute() {
        Extract extract2 = this;
        synchronized (extract2) {
            if (!this.bitmap$0) {
                this.canonicalized = RuntimeReplaceable.canonicalized$(this);
                this.bitmap$0 = true;
            }
        }
        return this.canonicalized;
    }

    @Override
    public Expression canonicalized() {
        return !this.bitmap$0 ? this.canonicalized$lzycompute() : this.canonicalized;
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    @Override
    public final void org$apache$spark$sql$catalyst$expressions$RuntimeReplaceable$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public Expression field() {
        return this.field;
    }

    public Expression source() {
        return this.source;
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public Iterator<Object> flatArguments() {
        return package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{this.field(), this.source()}));
    }

    @Override
    public Seq<Expression> exprsReplaced() {
        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{this.field(), this.source()}));
    }

    @Override
    public String mkString(Seq<String> childrenString) {
        return new StringBuilder(0).append(this.prettyName()).append(childrenString.mkString("(", " FROM ", ")")).toString();
    }

    @Override
    public Extract withNewChildInternal(Expression newChild) {
        Expression x$1 = newChild;
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        return this.copy(x$2, x$3, x$1);
    }

    public Extract copy(Expression field, Expression source, Expression child) {
        return new Extract(field, source, child);
    }

    public Expression copy$default$1() {
        return this.field();
    }

    public Expression copy$default$2() {
        return this.source();
    }

    public Expression copy$default$3() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "Extract";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.field();
                break;
            }
            case 1: {
                object = this.source();
                break;
            }
            case 2: {
                object = this.child();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Extract;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "field";
                break;
            }
            case 1: {
                string = "source";
                break;
            }
            case 2: {
                string = "child";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Extract)) return false;
        boolean bl = true;
        if (!bl) return false;
        Extract extract2 = (Extract)x$1;
        Expression expression = this.field();
        Expression expression2 = extract2.field();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.source();
        Expression expression4 = extract2.source();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.child();
        Expression expression6 = extract2.child();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!extract2.canEqual(this)) return false;
        return true;
    }

    public Extract(Expression field, Expression source, Expression child) {
        this.field = field;
        this.source = source;
        this.child = child;
        Unevaluable.$init$(this);
        RuntimeReplaceable.$init$(this);
        Statics.releaseFence();
    }

    public Extract(Expression field, Expression source) {
        this(field, source, DatePart$.MODULE$.toEquivalentExpr(field, source));
    }
}

