/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.BinaryArithmetic;
import org.apache.spark.sql.catalyst.expressions.DivModLike;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.IntegralDivide$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal$DecimalAsIfIntegral$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.IntegralType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.TypeCollection$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="expr1 _FUNC_ expr2 - Divide `expr1` by `expr2`. It returns NULL if an operand is NULL or `expr2` is 0. The result is casted to long.", examples="\n    Examples:\n      > SELECT 3 _FUNC_ 2;\n       1\n  ", since="3.0.0", group="math_funcs")
@ScalaSignature(bytes="\u0006\u0005\t-a\u0001B\u0014)\u0001VB\u0001b\u0014\u0001\u0003\u0016\u0004%\t\u0001\u0015\u0005\t)\u0002\u0011\t\u0012)A\u0005#\"AQ\u000b\u0001BK\u0002\u0013\u0005\u0001\u000b\u0003\u0005W\u0001\tE\t\u0015!\u0003R\u0011!9\u0006A!f\u0001\n\u0003A\u0006\u0002\u0003/\u0001\u0005#\u0005\u000b\u0011B-\t\u000bu\u0003A\u0011\u00010\t\u000bu\u0003A\u0011A2\t\u000b\u0019\u0004A\u0011\t-\t\u000b\u001d\u0004A\u0011\t5\t\u000b=\u0004A\u0011\t9\t\u000bQ\u0004A\u0011I;\t\u000by\u0004A\u0011I;\t\r}\u0004A\u0011IA\u0001\u0011\u0019\t9\u0001\u0001C!k\"Q\u0011\u0011\u0002\u0001\t\u0006\u0004%I!a\u0003\t\u000f\u0005e\u0001\u0001\"\u0011\u0002\u001c!9\u0011\u0011\u0005\u0001\u0005R\u0005\r\u0002\"CA\u0017\u0001\u0005\u0005I\u0011AA\u0018\u0011%\t9\u0004AI\u0001\n\u0003\tI\u0004C\u0005\u0002P\u0001\t\n\u0011\"\u0001\u0002:!I\u0011\u0011\u000b\u0001\u0012\u0002\u0013\u0005\u00111\u000b\u0005\n\u0003/\u0002\u0011\u0011!C!\u00033B\u0011\"!\u001b\u0001\u0003\u0003%\t!a\u001b\t\u0013\u0005M\u0004!!A\u0005\u0002\u0005U\u0004\"CA>\u0001\u0005\u0005I\u0011IA?\u0011%\tY\tAA\u0001\n\u0003\ti\tC\u0005\u0002\u0012\u0002\t\t\u0011\"\u0011\u0002\u0014\"I\u0011q\u0013\u0001\u0002\u0002\u0013\u0005\u0013\u0011T\u0004\n\u0003{C\u0013\u0011!E\u0001\u0003\u007f3\u0001b\n\u0015\u0002\u0002#\u0005\u0011\u0011\u0019\u0005\u0007;~!\t!!7\t\u0013\u0005mw$!A\u0005F\u0005u\u0007\"CAp?\u0005\u0005I\u0011QAq\u0011%\tIoHI\u0001\n\u0003\t\u0019\u0006C\u0005\u0002l~\t\t\u0011\"!\u0002n\"I\u0011q`\u0010\u0012\u0002\u0013\u0005\u00111\u000b\u0005\n\u0005\u0003y\u0012\u0011!C\u0005\u0005\u0007\u0011a\"\u00138uK\u001e\u0014\u0018\r\u001c#jm&$WM\u0003\u0002*U\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\tYC&\u0001\u0005dCR\fG._:u\u0015\tic&A\u0002tc2T!a\f\u0019\u0002\u000bM\u0004\u0018M]6\u000b\u0005E\u0012\u0014AB1qC\u000eDWMC\u00014\u0003\ry'oZ\u0002\u0001'\u0015\u0001aGO\u001fD!\t9\u0004(D\u0001)\u0013\tI\u0004F\u0001\tCS:\f'/_!sSRDW.\u001a;jGB\u0011qgO\u0005\u0003y!\u0012!\u0002R5w\u001b>$G*[6f!\tq\u0014)D\u0001@\u0015\u0005\u0001\u0015!B:dC2\f\u0017B\u0001\"@\u0005\u001d\u0001&o\u001c3vGR\u0004\"\u0001\u0012'\u000f\u0005\u0015SeB\u0001$J\u001b\u00059%B\u0001%5\u0003\u0019a$o\\8u}%\t\u0001)\u0003\u0002L\u007f\u00059\u0001/Y2lC\u001e,\u0017BA'O\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\tYu(\u0001\u0003mK\u001a$X#A)\u0011\u0005]\u0012\u0016BA*)\u0005))\u0005\u0010\u001d:fgNLwN\\\u0001\u0006Y\u00164G\u000fI\u0001\u0006e&<\u0007\u000e^\u0001\u0007e&<\u0007\u000e\u001e\u0011\u0002\u0017\u0019\f\u0017\u000e\\(o\u000bJ\u0014xN]\u000b\u00023B\u0011aHW\u0005\u00037~\u0012qAQ8pY\u0016\fg.\u0001\u0007gC&dwJ\\#se>\u0014\b%\u0001\u0004=S:LGO\u0010\u000b\u0005?\u0002\f'\r\u0005\u00028\u0001!)qj\u0002a\u0001#\")Qk\u0002a\u0001#\"9qk\u0002I\u0001\u0002\u0004IFcA0eK\")q\n\u0003a\u0001#\")Q\u000b\u0003a\u0001#\u0006\u00192\r[3dW\u0012Kg/\u001b3f\u001fZ,'O\u001a7po\u0006I\u0011N\u001c9viRK\b/Z\u000b\u0002SB\u0011!.\\\u0007\u0002W*\u0011A\u000eL\u0001\u0006if\u0004Xm]\u0005\u0003].\u0014\u0001#\u00112tiJ\f7\r\u001e#bi\u0006$\u0016\u0010]3\u0002\u0011\u0011\fG/\u0019+za\u0016,\u0012!\u001d\t\u0003UJL!a]6\u0003\u0011\u0011\u000bG/\u0019+za\u0016\faa]=nE>dW#\u0001<\u0011\u0005]\\hB\u0001=z!\t1u(\u0003\u0002{\u007f\u00051\u0001K]3eK\u001aL!\u0001`?\u0003\rM#(/\u001b8h\u0015\tQx(A\u0007eK\u000eLW.\u00197NKRDw\u000eZ\u0001\u0019I\u0016\u001c\u0017.\\1m)>$\u0015\r^1UsB,7i\u001c3f\u000f\u0016tGc\u0001<\u0002\u0004!1\u0011Q\u0001\bA\u0002Y\fQ\u0002Z3dS6\fGNU3tk2$\u0018aC:rY>\u0003XM]1u_J\f1\u0001Z5w+\t\ti\u0001E\u0005?\u0003\u001f\t\u0019\"a\u0005\u0002\u0014%\u0019\u0011\u0011C \u0003\u0013\u0019+hn\u0019;j_:\u0014\u0004c\u0001 \u0002\u0016%\u0019\u0011qC \u0003\u0007\u0005s\u00170A\u0007fm\u0006dw\n]3sCRLwN\u001c\u000b\u0007\u0003'\ti\"a\b\t\r=\u000b\u0002\u0019AA\n\u0011\u0019)\u0016\u00031\u0001\u0002\u0014\u00059r/\u001b;i\u001d\u0016<8\t[5mIJ,g.\u00138uKJt\u0017\r\u001c\u000b\u0006?\u0006\u0015\u0012\u0011\u0006\u0005\u0007\u0003O\u0011\u0002\u0019A)\u0002\u000f9,w\u000fT3gi\"1\u00111\u0006\nA\u0002E\u000b\u0001B\\3x%&<\u0007\u000e^\u0001\u0005G>\u0004\u0018\u0010F\u0004`\u0003c\t\u0019$!\u000e\t\u000f=\u001b\u0002\u0013!a\u0001#\"9Qk\u0005I\u0001\u0002\u0004\t\u0006bB,\u0014!\u0003\u0005\r!W\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\tYDK\u0002R\u0003{Y#!a\u0010\u0011\t\u0005\u0005\u00131J\u0007\u0003\u0003\u0007RA!!\u0012\u0002H\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u0013z\u0014AC1o]>$\u0018\r^5p]&!\u0011QJA\"\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM*\"!!\u0016+\u0007e\u000bi$A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u00037\u0002B!!\u0018\u0002h5\u0011\u0011q\f\u0006\u0005\u0003C\n\u0019'\u0001\u0003mC:<'BAA3\u0003\u0011Q\u0017M^1\n\u0007q\fy&\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002nA\u0019a(a\u001c\n\u0007\u0005EtHA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002\u0014\u0005]\u0004\"CA=3\u0005\u0005\t\u0019AA7\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011q\u0010\t\u0007\u0003\u0003\u000b9)a\u0005\u000e\u0005\u0005\r%bAAC\u007f\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005%\u00151\u0011\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000eF\u0002Z\u0003\u001fC\u0011\"!\u001f\u001c\u0003\u0003\u0005\r!a\u0005\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0005\u00037\n)\nC\u0005\u0002zq\t\t\u00111\u0001\u0002n\u00051Q-];bYN$2!WAN\u0011%\tI(HA\u0001\u0002\u0004\t\u0019\u0002K\n\u0001\u0003?\u000b)+a*\u0002,\u00065\u0016\u0011WAZ\u0003o\u000bI\fE\u00028\u0003CK1!a))\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#!!+\u0002\u0003\u0013)\u0007\u0010\u001d:2A}3UKT\"`A\u0015D\bO\u001d\u001a![\u0001\"\u0015N^5eK\u0002\u0002W\r\u001f9sc\u0001\u0004#-\u001f\u0011aKb\u0004(O\r1/A%#\bE]3ukJt7\u000f\t(V\u00192\u0003\u0013N\u001a\u0011b]\u0002z\u0007/\u001a:b]\u0012\u0004\u0013n\u001d\u0011O+2c\u0005e\u001c:!A\u0016D\bO\u001d\u001aaA%\u001c\b\u0005\r\u0018!)\",\u0007E]3tk2$\b%[:!G\u0006\u001cH/\u001a3!i>\u0004Cn\u001c8h]\u0005AQ\r_1na2,7/\t\u0002\u00020\u0006)$\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI\u001a!?\u001a+fjQ0!emR\u0001\u0005\t\u0011!A\u0001\u0002\u0013G\u0003\u0011!\u0003\u0015\u0019\u0018N\\2fC\t\t),A\u00034]Ar\u0003'A\u0003he>,\b/\t\u0002\u0002<\u0006QQ.\u0019;i?\u001a,hnY:\u0002\u001d%sG/Z4sC2$\u0015N^5eKB\u0011qgH\n\u0006?\u0005\r\u0017q\u001a\t\t\u0003\u000b\fY-U)Z?6\u0011\u0011q\u0019\u0006\u0004\u0003\u0013|\u0014a\u0002:v]RLW.Z\u0005\u0005\u0003\u001b\f9MA\tBEN$(/Y2u\rVt7\r^5p]N\u0002B!!5\u0002X6\u0011\u00111\u001b\u0006\u0005\u0003+\f\u0019'\u0001\u0002j_&\u0019Q*a5\u0015\u0005\u0005}\u0016\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005m\u0013!B1qa2LHcB0\u0002d\u0006\u0015\u0018q\u001d\u0005\u0006\u001f\n\u0002\r!\u0015\u0005\u0006+\n\u0002\r!\u0015\u0005\b/\n\u0002\n\u00111\u0001Z\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\u001a\u0014aB;oCB\u0004H.\u001f\u000b\u0005\u0003_\fY\u0010E\u0003?\u0003c\f)0C\u0002\u0002t~\u0012aa\u00149uS>t\u0007C\u0002 \u0002xF\u000b\u0016,C\u0002\u0002z~\u0012a\u0001V;qY\u0016\u001c\u0004\u0002CA\u007fI\u0005\u0005\t\u0019A0\u0002\u0007a$\u0003'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HeM\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u0005\u000b\u0001B!!\u0018\u0003\b%!!\u0011BA0\u0005\u0019y%M[3di\u0002")
public class IntegralDivide
extends BinaryArithmetic
implements DivModLike,
Serializable {
    private Function2<Object, Object, Object> div;
    private final Expression left;
    private final Expression right;
    private final boolean failOnError;
    private Function1<Object, Object> org$apache$spark$sql$catalyst$expressions$DivModLike$$isZero;
    private volatile byte bitmap$0;

    public static boolean $lessinit$greater$default$3() {
        return IntegralDivide$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Tuple3<Expression, Expression, Object>> unapply(IntegralDivide integralDivide) {
        return IntegralDivide$.MODULE$.unapply(integralDivide);
    }

    public static boolean apply$default$3() {
        return IntegralDivide$.MODULE$.apply$default$3();
    }

    public static Function1<Tuple3<Expression, Expression, Object>, IntegralDivide> tupled() {
        return IntegralDivide$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Object, IntegralDivide>>> curried() {
        return IntegralDivide$.MODULE$.curried();
    }

    @Override
    public boolean nullable() {
        return DivModLike.nullable$(this);
    }

    @Override
    public final Object eval(InternalRow input) {
        return DivModLike.eval$(this, input);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return DivModLike.doGenCode$(this, ctx, ev);
    }

    private Function1<Object, Object> org$apache$spark$sql$catalyst$expressions$DivModLike$$isZero$lzycompute() {
        IntegralDivide integralDivide = this;
        synchronized (integralDivide) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.org$apache$spark$sql$catalyst$expressions$DivModLike$$isZero = DivModLike.org$apache$spark$sql$catalyst$expressions$DivModLike$$isZero$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.org$apache$spark$sql$catalyst$expressions$DivModLike$$isZero;
    }

    @Override
    public Function1<Object, Object> org$apache$spark$sql$catalyst$expressions$DivModLike$$isZero() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.org$apache$spark$sql$catalyst$expressions$DivModLike$$isZero$lzycompute() : this.org$apache$spark$sql$catalyst$expressions$DivModLike$$isZero;
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public boolean failOnError() {
        return this.failOnError;
    }

    @Override
    public boolean checkDivideOverflow() {
        DataType dataType = this.left().dataType();
        boolean bl = LongType$.MODULE$.equals(dataType) && this.failOnError();
        return bl;
    }

    @Override
    public AbstractDataType inputType() {
        return TypeCollection$.MODULE$.apply((Seq<AbstractDataType>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{LongType$.MODULE$, DecimalType$.MODULE$}));
    }

    @Override
    public DataType dataType() {
        return LongType$.MODULE$;
    }

    @Override
    public String symbol() {
        return "/";
    }

    @Override
    public String decimalMethod() {
        return "quot";
    }

    @Override
    public String decimalToDataTypeCodeGen(String decimalResult) {
        return new StringBuilder(9).append(decimalResult).append(".toLong()").toString();
    }

    @Override
    public String sqlOperator() {
        return "div";
    }

    private Function2<Object, Object, Object> div$lzycompute() {
        IntegralDivide integralDivide = this;
        synchronized (integralDivide) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                Decimal$DecimalAsIfIntegral$ decimal$DecimalAsIfIntegral$;
                DataType dataType = this.left().dataType();
                if (dataType instanceof IntegralType) {
                    IntegralType integralType = (IntegralType)dataType;
                    decimal$DecimalAsIfIntegral$ = integralType.integral();
                } else if (dataType instanceof DecimalType) {
                    DecimalType decimalType = (DecimalType)dataType;
                    decimal$DecimalAsIfIntegral$ = decimalType.asIntegral();
                } else {
                    throw new MatchError((Object)dataType);
                }
                Decimal$DecimalAsIfIntegral$ integral = decimal$DecimalAsIfIntegral$;
                this.div = (Function2 & Serializable)(x, y) -> {
                    Object res = integral.quot(x, y);
                    return res == null ? null : BoxesRunTime.boxToLong((long)integral.toLong(res));
                };
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.div;
    }

    private Function2<Object, Object, Object> div() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.div$lzycompute() : this.div;
    }

    @Override
    public Object evalOperation(Object left, Object right) {
        return this.div().apply(left, right);
    }

    @Override
    public IntegralDivide withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight, this.copy$default$3());
    }

    public IntegralDivide copy(Expression left, Expression right, boolean failOnError) {
        return new IntegralDivide(left, right, failOnError);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    public boolean copy$default$3() {
        return this.failOnError();
    }

    @Override
    public String productPrefix() {
        return "IntegralDivide";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.left();
                break;
            }
            case 1: {
                object = this.right();
                break;
            }
            case 2: {
                object = BoxesRunTime.boxToBoolean((boolean)this.failOnError());
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof IntegralDivide;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "left";
                break;
            }
            case 1: {
                string = "right";
                break;
            }
            case 2: {
                string = "failOnError";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof IntegralDivide)) return false;
        boolean bl = true;
        if (!bl) return false;
        IntegralDivide integralDivide = (IntegralDivide)x$1;
        if (this.failOnError() != integralDivide.failOnError()) return false;
        Expression expression = this.left();
        Expression expression2 = integralDivide.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = integralDivide.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!integralDivide.canEqual(this)) return false;
        return true;
    }

    public IntegralDivide(Expression left, Expression right, boolean failOnError) {
        this.left = left;
        this.right = right;
        this.failOnError = failOnError;
        DivModLike.$init$(this);
    }

    public IntegralDivide(Expression left, Expression right) {
        this(left, right, SQLConf$.MODULE$.get().ansiEnabled());
    }
}

