/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import com.fasterxml.jackson.core.JsonFactory;
import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.ExprUtils$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.JsonToStructs$;
import org.apache.spark.sql.catalyst.expressions.SpecializedGetters;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.json.CreateJacksonParser$;
import org.apache.spark.sql.catalyst.json.JSONOptions;
import org.apache.spark.sql.catalyst.json.JacksonParser;
import org.apache.spark.sql.catalyst.json.JacksonParser$;
import org.apache.spark.sql.catalyst.trees.TreePattern$;
import org.apache.spark.sql.catalyst.util.FailFastMode$;
import org.apache.spark.sql.catalyst.util.FailureSafeParser;
import org.apache.spark.sql.catalyst.util.ParseMode;
import org.apache.spark.sql.catalyst.util.PermissiveMode$;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Enumeration;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(jsonStr, schema[, options]) - Returns a struct value with the given `jsonStr` and `schema`.", examples="\n    Examples:\n      > SELECT _FUNC_('{\"a\":1, \"b\":0.8}', 'a INT, b DOUBLE');\n       {\"a\":1,\"b\":0.8}\n      > SELECT _FUNC_('{\"time\":\"26/08/2015\"}', 'time Timestamp', map('timestampFormat', 'dd/MM/yyyy'));\n       {\"time\":2015-08-26 00:00:00}\n  ", group="json_funcs", since="2.2.0")
@ScalaSignature(bytes="\u0006\u0005\t5h\u0001\u0002\u001a4\u0001\u0002C\u0001\"\u001b\u0001\u0003\u0016\u0004%\tA\u001b\u0005\tc\u0002\u0011\t\u0012)A\u0005W\"A!\u000f\u0001BK\u0002\u0013\u00051\u000f\u0003\u0005\u0000\u0001\tE\t\u0015!\u0003u\u0011)\t\t\u0001\u0001BK\u0002\u0013\u0005\u00111\u0001\u0005\u000b\u0003\u0017\u0001!\u0011#Q\u0001\n\u0005\u0015\u0001BCA\u0007\u0001\tU\r\u0011\"\u0001\u0002\u0010!Q\u0011q\u0003\u0001\u0003\u0012\u0003\u0006I!!\u0005\t\u000f\u0005e\u0001\u0001\"\u0001\u0002\u001c!A\u0011q\u0005\u0001C\u0002\u0013\u0005!\u000eC\u0004\u0002*\u0001\u0001\u000b\u0011B6\t\u000f\u0005-\u0002\u0001\"\u0011\u0002.!9\u0011Q\u0007\u0001\u0005F\u0005]\u0002bBA\r\u0001\u0011\u0005\u0011\u0011\u000e\u0005\b\u00033\u0001A\u0011AA9\u0011\u001d\tI\u0002\u0001C\u0001\u0003oBq!a \u0001\t\u0003\n\t\t\u0003\u0006\u0002\u0010\u0002A)\u0019!C\u0001\u0003#C\u0011\"a4\u0001\u0005\u0004%\t!!5\t\u000f\u0005M\u0007\u0001)A\u0005y\"Q\u0011Q\u001b\u0001\t\u0006\u0004%\t!a6\t\r\u0005U\b\u0001\"\u0011k\u0011\u001d\t9\u0010\u0001C!\u0003sDq!!@\u0001\t\u0003\ny\u0010C\u0004\u0003\f\u0001!\tE!\u0004\t\ra\u0002A\u0011IAi\u0011\u001d\u00119\u0002\u0001C!\u0003#DqA!\u0007\u0001\t#\u0012Y\u0002C\u0005\u0003\"\u0001\t\t\u0011\"\u0001\u0003$!I!Q\u0006\u0001\u0012\u0002\u0013\u0005!q\u0006\u0005\n\u0005\u000b\u0002\u0011\u0013!C\u0001\u0005\u000fB\u0011Ba\u0013\u0001#\u0003%\tA!\u0014\t\u0013\tE\u0003!%A\u0005\u0002\tM\u0003\"\u0003B,\u0001\u0005\u0005I\u0011\tB-\u0011%\u0011y\u0006AA\u0001\n\u0003\u0011\t\u0007C\u0005\u0003j\u0001\t\t\u0011\"\u0001\u0003l!I!\u0011\u000f\u0001\u0002\u0002\u0013\u0005#1\u000f\u0005\n\u0005\u007f\u0002\u0011\u0011!C\u0001\u0005\u0003C\u0011B!\"\u0001\u0003\u0003%\tEa\"\t\u0013\t-\u0005!!A\u0005B\t5u!\u0003BYg\u0005\u0005\t\u0012\u0001BZ\r!\u00114'!A\t\u0002\tU\u0006bBA\rU\u0011\u0005!1\u0019\u0005\n\u0005\u000bT\u0013\u0011!C#\u0005\u000fD\u0011B!3+\u0003\u0003%\tIa3\t\u0013\tU'&%A\u0005\u0002\tM\u0003\"\u0003BlU\u0005\u0005I\u0011\u0011Bm\u0011%\u00119OKI\u0001\n\u0003\u0011\u0019\u0006C\u0005\u0003j*\n\t\u0011\"\u0003\u0003l\ni!j]8o)>\u001cFO];diNT!\u0001N\u001b\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003m]\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003qe\n1a]9m\u0015\tQ4(A\u0003ta\u0006\u00148N\u0003\u0002={\u00051\u0011\r]1dQ\u0016T\u0011AP\u0001\u0004_J<7\u0001A\n\t\u0001\u0005+\u0005JT)Y=B\u0011!iQ\u0007\u0002g%\u0011Ai\r\u0002\u0010+:\f'/_#yaJ,7o]5p]B\u0011!IR\u0005\u0003\u000fN\u0012q\u0003V5nKj{g.Z!xCJ,W\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005%cU\"\u0001&\u000b\u0005-\u001b\u0014aB2pI\u0016<WM\\\u0005\u0003\u001b*\u0013qbQ8eK\u001e,gNR1mY\n\f7m\u001b\t\u0003\u0005>K!\u0001U\u001a\u0003#\u0015C\b/Z2ug&s\u0007/\u001e;UsB,7\u000f\u0005\u0002S+:\u0011!iU\u0005\u0003)N\nq\u0001]1dW\u0006<W-\u0003\u0002W/\nqa*\u001e7m\u0013:$x\u000e\\3sC:$(B\u0001+4!\tIF,D\u0001[\u0015\u0005Y\u0016!B:dC2\f\u0017BA/[\u0005\u001d\u0001&o\u001c3vGR\u0004\"a\u00184\u000f\u0005\u0001,gBA1e\u001b\u0005\u0011'BA2@\u0003\u0019a$o\\8u}%\t1,\u0003\u0002U5&\u0011q\r\u001b\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0006\u0003)j\u000baa]2iK6\fW#A6\u0011\u00051|W\"A7\u000b\u00059<\u0014!\u0002;za\u0016\u001c\u0018B\u00019n\u0005!!\u0015\r^1UsB,\u0017aB:dQ\u0016l\u0017\rI\u0001\b_B$\u0018n\u001c8t+\u0005!\b\u0003B;zyrt!A^<\u0011\u0005\u0005T\u0016B\u0001=[\u0003\u0019\u0001&/\u001a3fM&\u0011!p\u001f\u0002\u0004\u001b\u0006\u0004(B\u0001=[!\t)X0\u0003\u0002\u007fw\n11\u000b\u001e:j]\u001e\f\u0001b\u001c9uS>t7\u000fI\u0001\u0006G\"LG\u000eZ\u000b\u0003\u0003\u000b\u00012AQA\u0004\u0013\r\tIa\r\u0002\u000b\u000bb\u0004(/Z:tS>t\u0017AB2iS2$\u0007%\u0001\u0006uS6,'l\u001c8f\u0013\u0012,\"!!\u0005\u0011\te\u000b\u0019\u0002`\u0005\u0004\u0003+Q&AB(qi&|g.A\u0006uS6,'l\u001c8f\u0013\u0012\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0006\u0002\u001e\u0005}\u0011\u0011EA\u0012\u0003K\u0001\"A\u0011\u0001\t\u000b%L\u0001\u0019A6\t\u000bIL\u0001\u0019\u0001;\t\u000f\u0005\u0005\u0011\u00021\u0001\u0002\u0006!I\u0011QB\u0005\u0011\u0002\u0003\u0007\u0011\u0011C\u0001\u000f]VdG.\u00192mKN\u001b\u0007.Z7b\u0003=qW\u000f\u001c7bE2,7k\u00195f[\u0006\u0004\u0013\u0001\u00038vY2\f'\r\\3\u0016\u0005\u0005=\u0002cA-\u00022%\u0019\u00111\u0007.\u0003\u000f\t{w\u000e\\3b]\u0006!bn\u001c3f!\u0006$H/\u001a:og&sG/\u001a:oC2$\"!!\u000f\u0011\u000b}\u000bY$a\u0010\n\u0007\u0005u\u0002NA\u0002TKF\u0004B!!\u0011\u0002d9!\u00111IA/\u001d\u0011\t)%!\u0017\u000f\t\u0005\u001d\u0013q\u000b\b\u0005\u0003\u0013\n)F\u0004\u0003\u0002L\u0005Mc\u0002BA'\u0003#r1!YA(\u0013\u0005q\u0014B\u0001\u001f>\u0013\tQ4(\u0003\u00029s%\u0011agN\u0005\u0004\u00037*\u0014!\u0002;sK\u0016\u001c\u0018\u0002BA0\u0003C\n1\u0002\u0016:fKB\u000bG\u000f^3s]*\u0019\u00111L\u001b\n\t\u0005\u0015\u0014q\r\u0002\f)J,W\rU1ui\u0016\u0014hN\u0003\u0003\u0002`\u0005\u0005D\u0003CA\u000f\u0003W\ni'a\u001c\t\u000f\u0005\u0005a\u00021\u0001\u0002\u0006!1\u0011N\u0004a\u0001\u0003\u000bAQA\u001d\bA\u0002Q$b!!\b\u0002t\u0005U\u0004bBA\u0001\u001f\u0001\u0007\u0011Q\u0001\u0005\u0007S>\u0001\r!!\u0002\u0015\u0011\u0005u\u0011\u0011PA>\u0003{Bq!!\u0001\u0011\u0001\u0004\t)\u0001\u0003\u0004j!\u0001\u0007\u0011Q\u0001\u0005\u0007eB\u0001\r!!\u0002\u0002'\rDWmY6J]B,H\u000fR1uCRK\b/Z:\u0015\u0005\u0005\r\u0005\u0003BAC\u0003\u0017k!!a\"\u000b\u0007\u0005%U'\u0001\u0005b]\u0006d\u0017p]5t\u0013\u0011\ti)a\"\u0003\u001fQK\b/Z\"iK\u000e\\'+Z:vYR\f\u0011bY8om\u0016\u0014H/\u001a:\u0016\u0005\u0005M\u0005cB-\u0002\u0016\u0006e\u0015qU\u0005\u0004\u0003/S&!\u0003$v]\u000e$\u0018n\u001c82!\u0015y\u00161TAP\u0013\r\ti\n\u001b\u0002\t\u0013R,'/\u0019;peB!\u0011\u0011UAR\u001b\u0005)\u0014bAASk\tY\u0011J\u001c;fe:\fGNU8x%\u0019\tI+!,\u0002>\u001a1\u00111\u0016\u0001\u0001\u0003O\u0013A\u0002\u0010:fM&tW-\\3oiz\u0002B!a,\u0002:6\u0011\u0011\u0011\u0017\u0006\u0005\u0003g\u000b),\u0001\u0003mC:<'BAA\\\u0003\u0011Q\u0017M^1\n\t\u0005m\u0016\u0011\u0017\u0002\u0007\u001f\nTWm\u0019;\u0011\t\u0005}\u0016QY\u0007\u0003\u0003\u0003TA!a1\u00026\u0006\u0011\u0011n\\\u0005\u0004O\u0006\u0005\u0007f\u0001\n\u0002JB\u0019\u0011,a3\n\u0007\u00055'LA\u0005ue\u0006t7/[3oi\u0006\u0019b.Y7f\u001f\u001a\u001cuN\u001d:vaR\u0014VmY8sIV\tA0\u0001\u000boC6,wJZ\"peJ,\b\u000f\u001e*fG>\u0014H\rI\u0001\u0007a\u0006\u00148/\u001a:\u0016\u0005\u0005e\u0007CBAn\u0003C\f)/\u0004\u0002\u0002^*\u0019\u0011q\\\u001b\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003G\fiNA\tGC&dWO]3TC\u001a,\u0007+\u0019:tKJ\u0004B!a:\u0002p6\u0011\u0011\u0011\u001e\u0006\u0004]\u0006-(bAAws\u00051QO\\:bM\u0016LA!!=\u0002j\nQQ\u000b\u0016$9'R\u0014\u0018N\\4)\u0007U\tI-\u0001\u0005eCR\fG+\u001f9f\u000319\u0018\u000e\u001e5US6,'l\u001c8f)\r)\u00151 \u0005\u0007\u0003\u001b9\u0002\u0019\u0001?\u0002\u00199,H\u000e\\*bM\u0016,e/\u00197\u0015\t\t\u0005!q\u0001\t\u00043\n\r\u0011b\u0001B\u00035\n\u0019\u0011I\\=\t\u000f\t%\u0001\u00041\u0001\u0003\u0002\u0005!!n]8o\u0003)Ig\u000e];u)f\u0004Xm]\u000b\u0003\u0005\u001f\u0001RaXA\u001e\u0005#\u00012\u0001\u001cB\n\u0013\r\u0011)\"\u001c\u0002\u0011\u0003\n\u001cHO]1di\u0012\u000bG/\u0019+za\u0016\f!\u0002\u001d:fiRLh*Y7f\u0003Q9\u0018\u000e\u001e5OK^\u001c\u0005.\u001b7e\u0013:$XM\u001d8bYR!\u0011Q\u0004B\u000f\u0011\u001d\u0011y\u0002\ba\u0001\u0003\u000b\t\u0001B\\3x\u0007\"LG\u000eZ\u0001\u0005G>\u0004\u0018\u0010\u0006\u0006\u0002\u001e\t\u0015\"q\u0005B\u0015\u0005WAq![\u000f\u0011\u0002\u0003\u00071\u000eC\u0004s;A\u0005\t\u0019\u0001;\t\u0013\u0005\u0005Q\u0004%AA\u0002\u0005\u0015\u0001\"CA\u0007;A\u0005\t\u0019AA\t\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"A!\r+\u0007-\u0014\u0019d\u000b\u0002\u00036A!!q\u0007B!\u001b\t\u0011ID\u0003\u0003\u0003<\tu\u0012!C;oG\",7m[3e\u0015\r\u0011yDW\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B\"\u0005s\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"A!\u0013+\u0007Q\u0014\u0019$\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\t=#\u0006BA\u0003\u0005g\tabY8qs\u0012\"WMZ1vYR$C'\u0006\u0002\u0003V)\"\u0011\u0011\u0003B\u001a\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011!1\f\t\u0005\u0003_\u0013i&C\u0002\u007f\u0003c\u000bA\u0002\u001d:pIV\u001cG/\u0011:jif,\"Aa\u0019\u0011\u0007e\u0013)'C\u0002\u0003hi\u00131!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$BA!\u0001\u0003n!I!q\u000e\u0013\u0002\u0002\u0003\u0007!1M\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\tU\u0004C\u0002B<\u0005{\u0012\t!\u0004\u0002\u0003z)\u0019!1\u0010.\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\u001e\ne\u0014\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005=\"1\u0011\u0005\n\u0005_2\u0013\u0011!a\u0001\u0005\u0003\t!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR!!1\fBE\u0011%\u0011ygJA\u0001\u0002\u0004\u0011\u0019'\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003_\u0011y\tC\u0005\u0003p!\n\t\u00111\u0001\u0003\u0002!\u001a\u0002Aa%\u0003\u001a\nm%q\u0014BQ\u0005K\u00139Ka+\u0003.B\u0019!I!&\n\u0007\t]5GA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\tu\u0015AY0G+:\u001bu\f\u000b6t_:\u001cFO\u001d\u0017!g\u000eDW-\\1\\Y\u0001z\u0007\u000f^5p]Nl\u0016\u0006I\u0017!%\u0016$XO\u001d8tA\u0005\u00043\u000f\u001e:vGR\u0004c/\u00197vK\u0002:\u0018\u000e\u001e5!i\",\u0007eZ5wK:\u0004\u0003M[:p]N#(\u000f\u0019\u0011b]\u0012\u0004\u0003m]2iK6\f\u0007ML\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012!1U\u0001\u0002f*\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~Cse\u001f\u0012bEi\nD\u0006\t\u0012cEi\u0002d\u0006O?(Y\u0001:\u0013\rI%O)2\u0002#\r\t#P+\ncUiJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!Am\u0014\u0013M\t\u001e2Y\t\u0012'E\u000f\u0019/quT\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006fJ>#i&lWM\t\u001e#eYz\u0003\u0007O\u00183aE*$%`\u0014-A\u001d\"\u0018.\\3!)&lWm\u001d;b[B<C\u0006I7ba\":C/[7fgR\fW\u000e\u001d$pe6\fGo\n\u0017!O\u0011$w&T'0sfL\u0018pJ\u0015*w)\u0001\u0003\u0005\t\u0011!A\u0001Z(\u0005^5nK\nR$\u0007M\u00196[ABTF\r\u001c!aAR\u0004\u0007\r\u001e1auT\u0001\u0005I\u0001\u0006OJ|W\u000f]\u0011\u0003\u0005S\u000b!B[:p]~3WO\\2t\u0003\u0015\u0019\u0018N\\2fC\t\u0011y+A\u00033]Ir\u0003'A\u0007Kg>tGk\\*ueV\u001cGo\u001d\t\u0003\u0005*\u001aRA\u000bB\\\u0003{\u0003BB!/\u0003@.$\u0018QAA\t\u0003;i!Aa/\u000b\u0007\tu&,A\u0004sk:$\u0018.\\3\n\t\t\u0005'1\u0018\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:$DC\u0001BZ\u0003!!xn\u0015;sS:<GC\u0001B.\u0003\u0015\t\u0007\u000f\u001d7z))\tiB!4\u0003P\nE'1\u001b\u0005\u0006S6\u0002\ra\u001b\u0005\u0006e6\u0002\r\u0001\u001e\u0005\b\u0003\u0003i\u0003\u0019AA\u0003\u0011%\ti!\fI\u0001\u0002\u0004\t\t\"A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00135\u0003\u001d)h.\u00199qYf$BAa7\u0003dB)\u0011,a\u0005\u0003^BI\u0011La8li\u0006\u0015\u0011\u0011C\u0005\u0004\u0005CT&A\u0002+va2,G\u0007C\u0005\u0003f>\n\t\u00111\u0001\u0002\u001e\u0005\u0019\u0001\u0010\n\u0019\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00135\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\ti\u000b")
public class JsonToStructs
extends UnaryExpression
implements TimeZoneAwareExpression,
CodegenFallback,
ExpectsInputTypes,
package.NullIntolerant,
Serializable {
    private transient Function1<Iterator<InternalRow>, Object> converter;
    private transient FailureSafeParser<UTF8String> parser;
    private final DataType schema;
    private final Map<String, String> options;
    private final Expression child;
    private final Option<String> timeZoneId;
    private final DataType nullableSchema;
    private final String nameOfCorruptRecord;
    private boolean resolved;
    private Seq<Enumeration.Value> nodePatterns;
    private transient ZoneId zoneId;
    private volatile transient byte bitmap$trans$0;
    private volatile boolean bitmap$0;

    public static Option<String> $lessinit$greater$default$4() {
        return JsonToStructs$.MODULE$.$lessinit$greater$default$4();
    }

    public static Option<Tuple4<DataType, Map<String, String>, Expression, Option<String>>> unapply(JsonToStructs jsonToStructs) {
        return JsonToStructs$.MODULE$.unapply(jsonToStructs);
    }

    public static Option<String> apply$default$4() {
        return JsonToStructs$.MODULE$.apply$default$4();
    }

    public static Function1<Tuple4<DataType, Map<String, String>, Expression, Option<String>>, JsonToStructs> tupled() {
        return JsonToStructs$.MODULE$.tupled();
    }

    public static Function1<DataType, Function1<Map<String, String>, Function1<Expression, Function1<Option<String>, JsonToStructs>>>> curried() {
        return JsonToStructs$.MODULE$.curried();
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return CodegenFallback.doGenCode$(this, ctx, ev);
    }

    @Override
    public ZoneId zoneIdForType(DataType dataType) {
        return TimeZoneAwareExpression.zoneIdForType$(this, dataType);
    }

    private boolean resolved$lzycompute() {
        JsonToStructs jsonToStructs = this;
        synchronized (jsonToStructs) {
            if (!this.bitmap$0) {
                this.resolved = TimeZoneAwareExpression.resolved$(this);
                this.bitmap$0 = true;
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        return !this.bitmap$0 ? this.resolved$lzycompute() : this.resolved;
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private ZoneId zoneId$lzycompute() {
        JsonToStructs jsonToStructs = this;
        synchronized (jsonToStructs) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.zoneId = TimeZoneAwareExpression.zoneId$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.zoneId;
    }

    @Override
    public ZoneId zoneId() {
        return (byte)(this.bitmap$trans$0 & 4) == 0 ? this.zoneId$lzycompute() : this.zoneId;
    }

    @Override
    public final void org$apache$spark$sql$catalyst$expressions$TimeZoneAwareExpression$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public DataType schema() {
        return this.schema;
    }

    public Map<String, String> options() {
        return this.options;
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public Option<String> timeZoneId() {
        return this.timeZoneId;
    }

    public DataType nullableSchema() {
        return this.nullableSchema;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public final Seq<Enumeration.Value> nodePatternsInternal() {
        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Enumeration.Value[]{TreePattern$.MODULE$.JSON_TO_STRUCT()}));
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        DataType dataType = this.nullableSchema();
        boolean bl = dataType instanceof StructType ? true : (dataType instanceof ArrayType ? true : dataType instanceof MapType);
        TypeCheckResult typeCheckResult = bl ? ExpectsInputTypes.checkInputDataTypes$(this) : new TypeCheckResult.TypeCheckFailure(new StringBuilder(50).append("Input schema ").append(this.nullableSchema().catalogString()).append(" must be a struct, an array or a map.").toString());
        return typeCheckResult;
    }

    private Function1<Iterator<InternalRow>, Object> converter$lzycompute() {
        JsonToStructs jsonToStructs = this;
        synchronized (jsonToStructs) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                Function1 & Serializable intersect;
                DataType dataType = this.nullableSchema();
                if (dataType instanceof StructType) {
                    intersect = (Function1 & Serializable)rows -> rows.hasNext() ? (InternalRow)rows.next() : null;
                } else if (dataType instanceof ArrayType) {
                    intersect = (Function1 & Serializable)rows -> rows.hasNext() ? ((SpecializedGetters)rows.next()).getArray(0) : null;
                } else if (dataType instanceof MapType) {
                    intersect = (Function1 & Serializable)rows -> rows.hasNext() ? ((SpecializedGetters)rows.next()).getMap(0) : null;
                } else {
                    throw new MatchError((Object)dataType);
                }
                this.converter = intersect;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.converter;
    }

    public Function1<Iterator<InternalRow>, Object> converter() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.converter$lzycompute() : this.converter;
    }

    public String nameOfCorruptRecord() {
        return this.nameOfCorruptRecord;
    }

    private FailureSafeParser<UTF8String> parser$lzycompute() {
        JsonToStructs jsonToStructs = this;
        synchronized (jsonToStructs) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                Tuple2 tuple2;
                DataType dataType;
                ParseMode mode;
                JSONOptions parsedOptions = new JSONOptions(this.options(), (String)this.timeZoneId().get(), this.nameOfCorruptRecord());
                ParseMode parseMode = mode = parsedOptions.parseMode();
                PermissiveMode$ permissiveMode$ = PermissiveMode$.MODULE$;
                if (parseMode == null ? permissiveMode$ != null : !parseMode.equals(permissiveMode$)) {
                    ParseMode parseMode2 = mode;
                    FailFastMode$ failFastMode$ = FailFastMode$.MODULE$;
                    if (parseMode2 == null ? failFastMode$ != null : !parseMode2.equals(failFastMode$)) {
                        throw QueryCompilationErrors$.MODULE$.parseModeUnsupportedError("from_json", mode);
                    }
                }
                if ((dataType = this.nullableSchema()) instanceof StructType) {
                    StructType structType = (StructType)dataType;
                    ExprUtils$.MODULE$.verifyColumnNameOfCorruptRecord(structType, parsedOptions.columnNameOfCorruptRecord());
                    tuple2 = new Tuple2((Object)structType, (Object)StructType$.MODULE$.apply((Seq<StructField>)((Seq)structType.filterNot((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)JsonToStructs.$anonfun$parser$1(parsedOptions, x$6))))));
                } else {
                    StructField structField = new StructField("value", dataType, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
                    tuple2 = new Tuple2((Object)StructType$.MODULE$.apply((Seq<StructField>)package$.MODULE$.Nil().$colon$colon((Object)structField)), (Object)dataType);
                }
                Tuple2 tuple22 = tuple2;
                if (tuple22 == null) {
                    throw new MatchError((Object)tuple22);
                }
                StructType parserSchema = (StructType)tuple22._1();
                DataType actualSchema = (DataType)tuple22._2();
                Tuple2 tuple23 = new Tuple2((Object)parserSchema, (Object)actualSchema);
                Tuple2 tuple24 = tuple23;
                StructType parserSchema2 = (StructType)tuple24._1();
                DataType actualSchema2 = (DataType)tuple24._2();
                JacksonParser rawParser = new JacksonParser(actualSchema2, parsedOptions, false, JacksonParser$.MODULE$.$lessinit$greater$default$4());
                Function2 & Serializable createParser = (Function2 & Serializable)(jsonFactory, record) -> CreateJacksonParser$.MODULE$.utf8String((JsonFactory)jsonFactory, (UTF8String)record);
                this.parser = new FailureSafeParser((Function1 & Serializable)input -> rawParser.parse(input, createParser, (Function1 & Serializable)x -> (UTF8String)Predef$.MODULE$.identity(x)), mode, parserSchema2, parsedOptions.columnNameOfCorruptRecord());
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.parser;
    }

    public FailureSafeParser<UTF8String> parser() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.parser$lzycompute() : this.parser;
    }

    @Override
    public DataType dataType() {
        return this.nullableSchema();
    }

    @Override
    public TimeZoneAwareExpression withTimeZone(String timeZoneId) {
        Option x$1 = Option$.MODULE$.apply((Object)timeZoneId);
        DataType x$2 = this.copy$default$1();
        Map<String, String> x$3 = this.copy$default$2();
        Expression x$4 = this.copy$default$3();
        return this.copy(x$2, x$3, x$4, (Option<String>)x$1);
    }

    @Override
    public Object nullSafeEval(Object json) {
        return this.converter().apply(this.parser().parse((UTF8String)json));
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        StringType$ stringType$ = StringType$.MODULE$;
        return package$.MODULE$.Nil().$colon$colon((Object)stringType$);
    }

    @Override
    public String sql() {
        DataType dataType = this.schema();
        String string = dataType instanceof MapType ? "entries" : super.sql();
        return string;
    }

    @Override
    public String prettyName() {
        return "from_json";
    }

    @Override
    public JsonToStructs withNewChildInternal(Expression newChild) {
        Expression x$1 = newChild;
        DataType x$2 = this.copy$default$1();
        Map<String, String> x$3 = this.copy$default$2();
        Option<String> x$4 = this.copy$default$4();
        return this.copy(x$2, x$3, x$1, x$4);
    }

    public JsonToStructs copy(DataType schema, Map<String, String> options, Expression child, Option<String> timeZoneId) {
        return new JsonToStructs(schema, options, child, timeZoneId);
    }

    public DataType copy$default$1() {
        return this.schema();
    }

    public Map<String, String> copy$default$2() {
        return this.options();
    }

    public Expression copy$default$3() {
        return this.child();
    }

    public Option<String> copy$default$4() {
        return this.timeZoneId();
    }

    @Override
    public String productPrefix() {
        return "JsonToStructs";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.schema();
                break;
            }
            case 1: {
                object = this.options();
                break;
            }
            case 2: {
                object = this.child();
                break;
            }
            case 3: {
                object = this.timeZoneId();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof JsonToStructs;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "schema";
                break;
            }
            case 1: {
                string = "options";
                break;
            }
            case 2: {
                string = "child";
                break;
            }
            case 3: {
                string = "timeZoneId";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof JsonToStructs)) return false;
        boolean bl = true;
        if (!bl) return false;
        JsonToStructs jsonToStructs = (JsonToStructs)x$1;
        DataType dataType = this.schema();
        DataType dataType2 = jsonToStructs.schema();
        if (dataType == null) {
            if (dataType2 != null) {
                return false;
            }
        } else if (!dataType.equals(dataType2)) return false;
        Map<String, String> map = this.options();
        Map<String, String> map2 = jsonToStructs.options();
        if (map == null) {
            if (map2 != null) {
                return false;
            }
        } else if (!map.equals(map2)) return false;
        Expression expression = this.child();
        Expression expression2 = jsonToStructs.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Option<String> option = this.timeZoneId();
        Option<String> option2 = jsonToStructs.timeZoneId();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!jsonToStructs.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$parser$1(JSONOptions parsedOptions$1, StructField x$6) {
        String string = x$6.name();
        String string2 = parsedOptions$1.columnNameOfCorruptRecord();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public JsonToStructs(DataType schema, Map<String, String> options, Expression child, Option<String> timeZoneId) {
        this.schema = schema;
        this.options = options;
        this.child = child;
        this.timeZoneId = timeZoneId;
        TimeZoneAwareExpression.$init$(this);
        CodegenFallback.$init$(this);
        ExpectsInputTypes.$init$(this);
        this.nullableSchema = schema.asNullable();
        this.nameOfCorruptRecord = SQLConf$.MODULE$.get().getConf(SQLConf$.MODULE$.COLUMN_NAME_OF_CORRUPT_RECORD());
        Statics.releaseFence();
    }

    public JsonToStructs(Expression child, Expression schema, Map<String, String> options) {
        this(ExprUtils$.MODULE$.evalTypeExpr(schema), options, child, (Option<String>)None$.MODULE$);
    }

    public JsonToStructs(Expression child, Expression schema) {
        this(child, schema, (Map<String, String>)Predef$.MODULE$.Map().empty());
    }

    public JsonToStructs(Expression child, Expression schema, Expression options) {
        this(ExprUtils$.MODULE$.evalTypeExpr(schema), ExprUtils$.MODULE$.convertToMapData(options), child, (Option<String>)None$.MODULE$);
    }
}

