/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.LengthOfJsonArray$;
import org.apache.spark.sql.catalyst.expressions.SharedFactory$;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.json.CreateJacksonParser$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(jsonArray) - Returns the number of elements in the outermost JSON array.", arguments="\n    Arguments:\n      * jsonArray - A JSON array. `NULL` is returned in case of any other valid JSON string,\n          `NULL` or an invalid JSON.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('[1,2,3,4]');\n        4\n      > SELECT _FUNC_('[1,2,3,{\"f1\":1,\"f2\":[5,6]},4]');\n        5\n      > SELECT _FUNC_('[1,2');\n        NULL\n  ", group="json_funcs", since="3.1.0")
@ScalaSignature(bytes="\u0006\u0005\u0005%h\u0001B\u000e\u001d\u0001&B\u0001\"\u0013\u0001\u0003\u0016\u0004%\tA\u0013\u0005\t\u001d\u0002\u0011\t\u0012)A\u0005\u0017\")q\n\u0001C\u0001!\")1\u000b\u0001C!)\")a\f\u0001C!?\")\u0001\r\u0001C!C\")Q\r\u0001C!M\")q\u000e\u0001C!a\")!\u0010\u0001C\u0005w\"9\u0011q\u0003\u0001\u0005R\u0005e\u0001\"CA\u0010\u0001\u0005\u0005I\u0011AA\u0011\u0011%\t)\u0003AI\u0001\n\u0003\t9\u0003C\u0005\u0002>\u0001\t\t\u0011\"\u0011\u0002@!I\u0011q\n\u0001\u0002\u0002\u0013\u0005\u0011\u0011\u000b\u0005\n\u00033\u0002\u0011\u0011!C\u0001\u00037B\u0011\"!\u0019\u0001\u0003\u0003%\t%a\u0019\t\u0013\u0005E\u0004!!A\u0005\u0002\u0005M\u0004\"CA<\u0001\u0005\u0005I\u0011IA=\u0011%\ti\bAA\u0001\n\u0003\nyhB\u0005\u0002*r\t\t\u0011#\u0001\u0002,\u001aA1\u0004HA\u0001\u0012\u0003\ti\u000b\u0003\u0004P+\u0011\u0005\u0011Q\u0019\u0005\n\u0003\u000f,\u0012\u0011!C#\u0003\u0013D\u0011\"a3\u0016\u0003\u0003%\t)!4\t\u0013\u0005EW#!A\u0005\u0002\u0006M\u0007\"CAp+\u0005\u0005I\u0011BAq\u0005EaUM\\4uQ>3'j]8o\u0003J\u0014\u0018-\u001f\u0006\u0003;y\t1\"\u001a=qe\u0016\u001c8/[8og*\u0011q\u0004I\u0001\tG\u0006$\u0018\r\\=ti*\u0011\u0011EI\u0001\u0004gFd'BA\u0012%\u0003\u0015\u0019\b/\u0019:l\u0015\t)c%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002O\u0005\u0019qN]4\u0004\u0001M1\u0001A\u000b\u00185ou\u0002\"a\u000b\u0017\u000e\u0003qI!!\f\u000f\u0003\u001fUs\u0017M]=FqB\u0014Xm]:j_:\u0004\"a\f\u001a\u000e\u0003AR!!\r\u000f\u0002\u000f\r|G-Z4f]&\u00111\u0007\r\u0002\u0010\u0007>$WmZ3o\r\u0006dGNY1dWB\u00111&N\u0005\u0003mq\u0011\u0011#\u0012=qK\u000e$8/\u00138qkR$\u0016\u0010]3t!\tA4(D\u0001:\u0015\u0005Q\u0014!B:dC2\f\u0017B\u0001\u001f:\u0005\u001d\u0001&o\u001c3vGR\u0004\"A\u0010$\u000f\u0005}\"eB\u0001!D\u001b\u0005\t%B\u0001\")\u0003\u0019a$o\\8u}%\t!(\u0003\u0002Fs\u00059\u0001/Y2lC\u001e,\u0017BA$I\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\t)\u0015(A\u0003dQ&dG-F\u0001L!\tYC*\u0003\u0002N9\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0002\r\rD\u0017\u000e\u001c3!\u0003\u0019a\u0014N\\5u}Q\u0011\u0011K\u0015\t\u0003W\u0001AQ!S\u0002A\u0002-\u000b!\"\u001b8qkR$\u0016\u0010]3t+\u0005)\u0006c\u0001 W1&\u0011q\u000b\u0013\u0002\u0004'\u0016\f\bCA-]\u001b\u0005Q&BA.!\u0003\u0015!\u0018\u0010]3t\u0013\ti&L\u0001\u0005ECR\fG+\u001f9f\u0003!!\u0017\r^1UsB,W#\u0001-\u0002\u00119,H\u000e\\1cY\u0016,\u0012A\u0019\t\u0003q\rL!\u0001Z\u001d\u0003\u000f\t{w\u000e\\3b]\u0006Q\u0001O]3uift\u0015-\\3\u0016\u0003\u001d\u0004\"\u0001\u001b7\u000f\u0005%T\u0007C\u0001!:\u0013\tY\u0017(\u0001\u0004Qe\u0016$WMZ\u0005\u0003[:\u0014aa\u0015;sS:<'BA6:\u0003\u0011)g/\u00197\u0015\u0005E$\bC\u0001\u001ds\u0013\t\u0019\u0018HA\u0002B]fDq!\u001e\u0005\u0011\u0002\u0003\u0007a/A\u0003j]B,H\u000f\u0005\u0002xq6\ta$\u0003\u0002z=\tY\u0011J\u001c;fe:\fGNU8x\u00031\u0001\u0018M]:f\u0007>,h\u000e^3s)\u0011\tH0!\u0006\t\u000buL\u0001\u0019\u0001@\u0002\rA\f'o]3s!\ry\u0018\u0011C\u0007\u0003\u0003\u0003QA!a\u0001\u0002\u0006\u0005!1m\u001c:f\u0015\u0011\t9!!\u0003\u0002\u000f)\f7m[:p]*!\u00111BA\u0007\u0003%1\u0017m\u001d;feblGN\u0003\u0002\u0002\u0010\u0005\u00191m\\7\n\t\u0005M\u0011\u0011\u0001\u0002\u000b\u0015N|g\u000eU1sg\u0016\u0014\b\"B;\n\u0001\u00041\u0018\u0001F<ji\"tUm^\"iS2$\u0017J\u001c;fe:\fG\u000eF\u0002R\u00037Aa!!\b\u000b\u0001\u0004Y\u0015\u0001\u00038fo\u000eC\u0017\u000e\u001c3\u0002\t\r|\u0007/\u001f\u000b\u0004#\u0006\r\u0002bB%\f!\u0003\u0005\raS\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\tICK\u0002L\u0003WY#!!\f\u0011\t\u0005=\u0012\u0011H\u0007\u0003\u0003cQA!a\r\u00026\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003oI\u0014AC1o]>$\u0018\r^5p]&!\u00111HA\u0019\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005\u0005\u0003\u0003BA\"\u0003\u001bj!!!\u0012\u000b\t\u0005\u001d\u0013\u0011J\u0001\u0005Y\u0006twM\u0003\u0002\u0002L\u0005!!.\u0019<b\u0013\ri\u0017QI\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003'\u00022\u0001OA+\u0013\r\t9&\u000f\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0004c\u0006u\u0003\"CA0\u001f\u0005\u0005\t\u0019AA*\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011Q\r\t\u0006\u0003O\ni']\u0007\u0003\u0003SR1!a\u001b:\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003_\nIG\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dGc\u00012\u0002v!A\u0011qL\t\u0002\u0002\u0003\u0007\u0011/\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003BA!\u0003wB\u0011\"a\u0018\u0013\u0003\u0003\u0005\r!a\u0015\u0002\r\u0015\fX/\u00197t)\r\u0011\u0017\u0011\u0011\u0005\t\u0003?\u001a\u0012\u0011!a\u0001c\":\u0002!!\"\u0002\f\u00065\u0015\u0011SAJ\u0003/\u000bI*!(\u0002 \u0006\r\u0016Q\u0015\t\u0004W\u0005\u001d\u0015bAAE9\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017EAAH\u0003={f)\u0016(D?\"R7o\u001c8BeJ\f\u00170\u000b\u0011.AI+G/\u001e:og\u0002\"\b.\u001a\u0011ok6\u0014WM\u001d\u0011pM\u0002*G.Z7f]R\u001c\b%\u001b8!i\",\u0007e\\;uKJlwn\u001d;!\u0015N{e\nI1se\u0006Lh&A\u0005be\u001e,X.\u001a8ug\u0006\u0012\u0011QS\u0001\u0002*)\u0001\u0003\u0005\t\u0011Be\u001e,X.\u001a8ugjR\u0001\u0005\t\u0011!A\u0001R\u0003E[:p]\u0006\u0013(/Y=![\u0001\n\u0005ES*P\u001d\u0002\n'O]1z]\u0001\u0002g*\u0016'MA\u0002J7\u000f\t:fiV\u0014h.\u001a3!S:\u00043-Y:fA=4\u0007%\u00198zA=$\b.\u001a:!m\u0006d\u0017\u000e\u001a\u0011K'>s\u0005e\u001d;sS:<GF\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001tU\u000b\u0014'aA=\u0014\b%\u00198!S:4\u0018\r\\5eA)\u001bvJ\u0014\u0018\u000bA\u0001\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u00037\u000b\u00111\f\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)Om\u000bDF\r\u00174YQjv%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!AQR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006fJ.2YIb3\u0007L>#MF\u0012#(\r\u0017#MJ\u0012#hW\u001b-mukH\u0006N/(SmR\u0001\u0005\t\u0011!A\u0001\u0002\u0003%\u000e\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)Om\u000bDFM\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001\u0002c*\u0016'M\u0015\u0001\u0002\u0013!B4s_V\u0004\u0018EAAQ\u0003)Q7o\u001c8`MVt7m]\u0001\u0006g&t7-Z\u0011\u0003\u0003O\u000bQa\r\u00182]A\n\u0011\u0003T3oORDwJ\u001a&t_:\f%O]1z!\tYScE\u0003\u0016\u0003_\u000bY\f\u0005\u0004\u00022\u0006]6*U\u0007\u0003\u0003gS1!!.:\u0003\u001d\u0011XO\u001c;j[\u0016LA!!/\u00024\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u0019\u0011\t\u0005u\u00161Y\u0007\u0003\u0003\u007fSA!!1\u0002J\u0005\u0011\u0011n\\\u0005\u0004\u000f\u0006}FCAAV\u0003!!xn\u0015;sS:<GCAA!\u0003\u0015\t\u0007\u000f\u001d7z)\r\t\u0016q\u001a\u0005\u0006\u0013b\u0001\raS\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\t).a7\u0011\ta\n9nS\u0005\u0004\u00033L$AB(qi&|g\u000e\u0003\u0005\u0002^f\t\t\u00111\u0001R\u0003\rAH\u0005M\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u0003G\u0004B!a\u0011\u0002f&!\u0011q]A#\u0005\u0019y%M[3di\u0002")
public class LengthOfJsonArray
extends UnaryExpression
implements CodegenFallback,
ExpectsInputTypes,
Serializable {
    private final Expression child;

    public static Option<Expression> unapply(LengthOfJsonArray lengthOfJsonArray) {
        return LengthOfJsonArray$.MODULE$.unapply(lengthOfJsonArray);
    }

    public static <A> Function1<Expression, A> andThen(Function1<LengthOfJsonArray, A> function1) {
        return LengthOfJsonArray$.MODULE$.andThen(function1);
    }

    public static <A$> Function1<A$, LengthOfJsonArray> compose(Function1<A$, Expression> function1) {
        return LengthOfJsonArray$.MODULE$.compose(function1);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return CodegenFallback.doGenCode$(this, ctx, ev);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    public Seq<DataType> inputTypes() {
        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StringType$[]{StringType$.MODULE$}));
    }

    @Override
    public DataType dataType() {
        return IntegerType$.MODULE$;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public String prettyName() {
        return "json_array_length";
    }

    @Override
    public Object eval(InternalRow input) {
        Object object;
        Object object2 = new Object();
        try {
            UTF8String json = (UTF8String)this.child().eval(input);
            if (json == null) {
                return null;
            }
            try {
                object = Utils$.MODULE$.tryWithResource((Function0 & Serializable)() -> CreateJacksonParser$.MODULE$.utf8String(SharedFactory$.MODULE$.jsonFactory(), json), (Function1 & Serializable)parser -> {
                    if (parser.nextToken() == null) {
                        throw new NonLocalReturnControl(object2, null);
                    }
                    return this.parseCounter((JsonParser)parser, input);
                });
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                boolean bl = throwable2 instanceof JsonProcessingException ? true : throwable2 instanceof IOException;
                if (!bl) {
                    throw throwable;
                }
                Object var2_7 = null;
                object = var2_7;
            }
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object2) {
                object = ex.value();
            }
            throw ex;
        }
        return object;
    }

    private Object parseCounter(JsonParser parser, InternalRow input) {
        int length = 0;
        JsonToken jsonToken = parser.currentToken();
        JsonToken jsonToken2 = JsonToken.START_ARRAY;
        if (jsonToken == null ? jsonToken2 != null : !jsonToken.equals(jsonToken2)) {
            return null;
        }
        while (true) {
            JsonToken jsonToken3 = parser.nextToken();
            JsonToken jsonToken4 = JsonToken.END_ARRAY;
            if (!(jsonToken3 == null ? jsonToken4 != null : !jsonToken3.equals(jsonToken4))) break;
            ++length;
            parser.skipChildren();
        }
        return BoxesRunTime.boxToInteger((int)length);
    }

    @Override
    public LengthOfJsonArray withNewChildInternal(Expression newChild) {
        return this.copy(newChild);
    }

    public LengthOfJsonArray copy(Expression child) {
        return new LengthOfJsonArray(child);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "LengthOfJsonArray";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.child();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof LengthOfJsonArray;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "child";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof LengthOfJsonArray)) return false;
        boolean bl = true;
        if (!bl) return false;
        LengthOfJsonArray lengthOfJsonArray = (LengthOfJsonArray)x$1;
        Expression expression = this.child();
        Expression expression2 = lengthOfJsonArray.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!lengthOfJsonArray.canEqual(this)) return false;
        return true;
    }

    public LengthOfJsonArray(Expression child) {
        this.child = child;
        CodegenFallback.$init$(this);
        ExpectsInputTypes.$init$(this);
    }
}

