/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.MakeTimestamp;
import org.apache.spark.sql.catalyst.expressions.MakeTimestamp$;
import org.apache.spark.sql.catalyst.expressions.MakeTimestampLTZ$;
import org.apache.spark.sql.catalyst.expressions.RuntimeReplaceable;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.Unevaluable;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.TimestampType$;
import scala.Enumeration;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Tuple9;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(year, month, day, hour, min, sec[, timezone]) - Create the current timestamp with local time zone from year, month, day, hour, min, sec and timezone fields. ", arguments="\n    Arguments:\n      * year - the year to represent, from 1 to 9999\n      * month - the month-of-year to represent, from 1 (January) to 12 (December)\n      * day - the day-of-month to represent, from 1 to 31\n      * hour - the hour-of-day to represent, from 0 to 23\n      * min - the minute-of-hour to represent, from 0 to 59\n      * sec - the second-of-minute and its micro-fraction to represent, from\n              0 to 60. If the sec argument equals to 60, the seconds field is set\n              to 0 and 1 minute is added to the final timestamp.\n      * timezone - the time zone identifier. For example, CET, UTC and etc.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(2014, 12, 28, 6, 30, 45.887);\n       2014-12-28 06:30:45.887\n      > SELECT _FUNC_(2014, 12, 28, 6, 30, 45.887, 'CET');\n       2014-12-27 21:30:45.887\n      > SELECT _FUNC_(2019, 6, 30, 23, 59, 60);\n       2019-07-01 00:00:00\n      > SELECT _FUNC_(2019, 13, 1, 10, 11, 12, 'PST');\n       NULL\n      > SELECT _FUNC_(null, 7, 22, 15, 30, 0);\n       NULL\n  ", group="datetime_funcs", since="3.3.0")
@ScalaSignature(bytes="\u0006\u0005\tuc\u0001B\u001a5\u0001\u0006C\u0001b\u0017\u0001\u0003\u0016\u0004%\t\u0001\u0018\u0005\tA\u0002\u0011\t\u0012)A\u0005;\"A\u0011\r\u0001BK\u0002\u0013\u0005A\f\u0003\u0005c\u0001\tE\t\u0015!\u0003^\u0011!\u0019\u0007A!f\u0001\n\u0003a\u0006\u0002\u00033\u0001\u0005#\u0005\u000b\u0011B/\t\u0011\u0015\u0004!Q3A\u0005\u0002qC\u0001B\u001a\u0001\u0003\u0012\u0003\u0006I!\u0018\u0005\tO\u0002\u0011)\u001a!C\u00019\"A\u0001\u000e\u0001B\tB\u0003%Q\f\u0003\u0005j\u0001\tU\r\u0011\"\u0001]\u0011!Q\u0007A!E!\u0002\u0013i\u0006\u0002C6\u0001\u0005+\u0007I\u0011\u00017\t\u0011A\u0004!\u0011#Q\u0001\n5D\u0001\"\u001d\u0001\u0003\u0016\u0004%\tA\u001d\u0005\tm\u0002\u0011\t\u0012)A\u0005g\"Aq\u000f\u0001BK\u0002\u0013\u0005A\f\u0003\u0005y\u0001\tE\t\u0015!\u0003^\u0011\u0015I\b\u0001\"\u0001{\u0011\u0019I\b\u0001\"\u0001\u0002\f!1\u0011\u0010\u0001C\u0001\u00033Aq!!\u000b\u0001\t\u0003\nY\u0003C\u0004\u0002>\u0001!\t%a\u0010\t\u000f\u0005\u001d\u0003\u0001\"\u0015\u0002J!I\u0011q\n\u0001\u0002\u0002\u0013\u0005\u0011\u0011\u000b\u0005\n\u0003K\u0002\u0011\u0013!C\u0001\u0003OB\u0011\"! \u0001#\u0003%\t!a\u001a\t\u0013\u0005}\u0004!%A\u0005\u0002\u0005\u001d\u0004\"CAA\u0001E\u0005I\u0011AA4\u0011%\t\u0019\tAI\u0001\n\u0003\t9\u0007C\u0005\u0002\u0006\u0002\t\n\u0011\"\u0001\u0002h!I\u0011q\u0011\u0001\u0012\u0002\u0013\u0005\u0011\u0011\u0012\u0005\n\u0003\u001b\u0003\u0011\u0013!C\u0001\u0003\u001fC\u0011\"a%\u0001#\u0003%\t!a\u001a\t\u0013\u0005U\u0005!!A\u0005B\u0005]\u0005\"CAT\u0001\u0005\u0005I\u0011AAU\u0011%\t\t\fAA\u0001\n\u0003\t\u0019\fC\u0005\u0002@\u0002\t\t\u0011\"\u0011\u0002B\"I\u0011q\u001a\u0001\u0002\u0002\u0013\u0005\u0011\u0011\u001b\u0005\n\u0003+\u0004\u0011\u0011!C!\u0003/D\u0011\"a7\u0001\u0003\u0003%\t%!8\b\u0013\t\u001dA'!A\t\u0002\t%a\u0001C\u001a5\u0003\u0003E\tAa\u0003\t\re\\C\u0011\u0001B\u0012\u0011%\u0011)cKA\u0001\n\u000b\u00129\u0003C\u0005\u0003*-\n\t\u0011\"!\u0003,!I!qH\u0016\u0012\u0002\u0013\u0005\u0011q\u0012\u0005\n\u0005\u0003Z\u0013\u0011!CA\u0005\u0007B\u0011B!\u0015,#\u0003%\t!a$\t\u0013\tM3&!A\u0005\n\tU#\u0001E'bW\u0016$\u0016.\\3ti\u0006l\u0007\u000f\u0014+[\u0015\t)d'A\u0006fqB\u0014Xm]:j_:\u001c(BA\u001c9\u0003!\u0019\u0017\r^1msN$(BA\u001d;\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003wq\nQa\u001d9be.T!!\u0010 \u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0014aA8sO\u000e\u00011#\u0002\u0001C\r&{\u0005CA\"E\u001b\u0005!\u0014BA#5\u0005=)f.\u0019:z\u000bb\u0004(/Z:tS>t\u0007CA\"H\u0013\tAEG\u0001\nSk:$\u0018.\\3SKBd\u0017mY3bE2,\u0007C\u0001&N\u001b\u0005Y%\"\u0001'\u0002\u000bM\u001c\u0017\r\\1\n\u00059[%a\u0002)s_\u0012,8\r\u001e\t\u0003!bs!!\u0015,\u000f\u0005I+V\"A*\u000b\u0005Q\u0003\u0015A\u0002\u001fs_>$h(C\u0001M\u0013\t96*A\u0004qC\u000e\\\u0017mZ3\n\u0005eS&\u0001D*fe&\fG.\u001b>bE2,'BA,L\u0003\u0011IX-\u0019:\u0016\u0003u\u0003\"a\u00110\n\u0005}#$AC#yaJ,7o]5p]\u0006)\u00110Z1sA\u0005)Qn\u001c8uQ\u00061Qn\u001c8uQ\u0002\n1\u0001Z1z\u0003\u0011!\u0017-\u001f\u0011\u0002\t!|WO]\u0001\u0006Q>,(\u000fI\u0001\u0004[&t\u0017\u0001B7j]\u0002\n1a]3d\u0003\u0011\u0019Xm\u0019\u0011\u0002\u0011QLW.\u001a>p]\u0016,\u0012!\u001c\t\u0004\u0015:l\u0016BA8L\u0005\u0019y\u0005\u000f^5p]\u0006IA/[7fu>tW\rI\u0001\fM\u0006LGn\u00148FeJ|'/F\u0001t!\tQE/\u0003\u0002v\u0017\n9!i\\8mK\u0006t\u0017\u0001\u00044bS2|e.\u0012:s_J\u0004\u0013!B2iS2$\u0017AB2iS2$\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0010wrlhp`A\u0001\u0003\u0007\t)!a\u0002\u0002\nA\u00111\t\u0001\u0005\u00067N\u0001\r!\u0018\u0005\u0006CN\u0001\r!\u0018\u0005\u0006GN\u0001\r!\u0018\u0005\u0006KN\u0001\r!\u0018\u0005\u0006ON\u0001\r!\u0018\u0005\u0006SN\u0001\r!\u0018\u0005\u0006WN\u0001\r!\u001c\u0005\bcN\u0001\n\u00111\u0001t\u0011\u001598\u00031\u0001^)5Y\u0018QBA\b\u0003#\t\u0019\"!\u0006\u0002\u0018!)1\f\u0006a\u0001;\")\u0011\r\u0006a\u0001;\")1\r\u0006a\u0001;\")Q\r\u0006a\u0001;\")q\r\u0006a\u0001;\")\u0011\u000e\u0006a\u0001;Ry10a\u0007\u0002\u001e\u0005}\u0011\u0011EA\u0012\u0003K\t9\u0003C\u0003\\+\u0001\u0007Q\fC\u0003b+\u0001\u0007Q\fC\u0003d+\u0001\u0007Q\fC\u0003f+\u0001\u0007Q\fC\u0003h+\u0001\u0007Q\fC\u0003j+\u0001\u0007Q\fC\u0003l+\u0001\u0007Q,\u0001\u0006qe\u0016$H/\u001f(b[\u0016,\"!!\f\u0011\t\u0005=\u0012q\u0007\b\u0005\u0003c\t\u0019\u0004\u0005\u0002S\u0017&\u0019\u0011QG&\u0002\rA\u0013X\rZ3g\u0013\u0011\tI$a\u000f\u0003\rM#(/\u001b8h\u0015\r\t)dS\u0001\u000eKb\u0004(o\u001d*fa2\f7-\u001a3\u0016\u0005\u0005\u0005\u0003\u0003\u0002)\u0002DuK1!!\u0012[\u0005\r\u0019V-]\u0001\u0015o&$\bNT3x\u0007\"LG\u000eZ%oi\u0016\u0014h.\u00197\u0015\u0007u\u000bY\u0005\u0003\u0004\u0002Na\u0001\r!X\u0001\t]\u0016<8\t[5mI\u0006!1m\u001c9z)MY\u00181KA+\u0003/\nI&a\u0017\u0002^\u0005}\u0013\u0011MA2\u0011\u001dY\u0016\u0004%AA\u0002uCq!Y\r\u0011\u0002\u0003\u0007Q\fC\u0004d3A\u0005\t\u0019A/\t\u000f\u0015L\u0002\u0013!a\u0001;\"9q-\u0007I\u0001\u0002\u0004i\u0006bB5\u001a!\u0003\u0005\r!\u0018\u0005\bWf\u0001\n\u00111\u0001n\u0011\u001d\t\u0018\u0004%AA\u0002MDqa^\r\u0011\u0002\u0003\u0007Q,\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005%$fA/\u0002l-\u0012\u0011Q\u000e\t\u0005\u0003_\nI(\u0004\u0002\u0002r)!\u00111OA;\u0003%)hn\u00195fG.,GMC\u0002\u0002x-\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\tY(!\u001d\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%g\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\"\u0014AD2paf$C-\u001a4bk2$H%N\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00137\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uI]*\"!a#+\u00075\fY'\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001d\u0016\u0005\u0005E%fA:\u0002l\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012J\u0014!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002\u001aB!\u00111TAS\u001b\t\tiJ\u0003\u0003\u0002 \u0006\u0005\u0016\u0001\u00027b]\u001eT!!a)\u0002\t)\fg/Y\u0005\u0005\u0003s\ti*\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002,B\u0019!*!,\n\u0007\u0005=6JA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u00026\u0006m\u0006c\u0001&\u00028&\u0019\u0011\u0011X&\u0003\u0007\u0005s\u0017\u0010C\u0005\u0002>\u0016\n\t\u00111\u0001\u0002,\u0006\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!a1\u0011\r\u0005\u0015\u00171ZA[\u001b\t\t9MC\u0002\u0002J.\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\ti-a2\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0004g\u0006M\u0007\"CA_O\u0005\u0005\t\u0019AA[\u0003I\u0001(o\u001c3vGR,E.Z7f]Rt\u0015-\\3\u0015\t\u0005e\u0015\u0011\u001c\u0005\n\u0003{C\u0013\u0011!a\u0001\u0003W\u000ba!Z9vC2\u001cHcA:\u0002`\"I\u0011QX\u0015\u0002\u0002\u0003\u0007\u0011Q\u0017\u0015\u0018\u0001\u0005\r\u0018\u0011^Av\u0003_\f\t0!>\u0002x\u0006m\u0018Q B\u0001\u0005\u0007\u00012aQAs\u0013\r\t9\u000f\u000e\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\ti/AA%?\u001a+fjQ0)s\u0016\f'\u000f\f\u0011n_:$\b\u000e\f\u0011eCfd\u0003\u0005[8ve2\u0002S.\u001b8-AM,7m\u0017\u0017!i&lWM_8oKvK\u0003%\f\u0011De\u0016\fG/\u001a\u0011uQ\u0016\u00043-\u001e:sK:$\b\u0005^5nKN$\u0018-\u001c9!o&$\b\u000e\t7pG\u0006d\u0007\u0005^5nK\u0002RxN\\3!MJ|W\u000eI=fCJd\u0003%\\8oi\"d\u0003\u0005Z1zY\u0001Bw.\u001e:-A5Lg\u000e\f\u0011tK\u000e\u0004\u0013M\u001c3!i&lWM_8oK\u00022\u0017.\u001a7eg:\u0002\u0013!C1sOVlWM\u001c;tC\t\t\u00190\u0001Cv\u0015\u0001\u0002\u0003\u0005I!sOVlWM\u001c;tu)\u0001\u0003\u0005\t\u0011!A)\u0002\u00130Z1sA5\u0002C\u000f[3!s\u0016\f'\u000f\t;pAI,\u0007O]3tK:$H\u0006\t4s_6\u0004\u0013\u0007\t;pAeJ\u0014(\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0016![>tG\u000f\u001b\u0011.AQDW\rI7p]RDWf\u001c4.s\u0016\f'\u000f\t;pAI,\u0007O]3tK:$H\u0006\t4s_6\u0004\u0013\u0007\t\u0015KC:,\u0018M]=*AQ|\u0007%\r\u001a!Q\u0011+7-Z7cKJL#\u0002\t\u0011!A\u0001\u0002#\u0006\t3bs\u0002j\u0003\u0005\u001e5fA\u0011\f\u00170L8g[5|g\u000e\u001e5!i>\u0004#/\u001a9sKN,g\u000e\u001e\u0017!MJ|W\u000eI\u0019!i>\u00043'\r\u0006!A\u0001\u0002\u0003\u0005\t\u0016!Q>,(\u000fI\u0017!i\",\u0007\u0005[8ve6zg-\f3bs\u0002\"x\u000e\t:faJ,7/\u001a8uY\u00012'o\\7!a\u0001\"x\u000e\t\u001a4\u0015\u0001\u0002\u0003\u0005\t\u0011!U\u0001j\u0017N\u001c\u0011.AQDW\rI7j]V$X-L8g[!|WO\u001d\u0011u_\u0002\u0012X\r\u001d:fg\u0016tG\u000f\f\u0011ge>l\u0007\u0005\r\u0011u_\u0002*\u0014H\u0003\u0011!A\u0001\u0002\u0003E\u000b\u0011tK\u000e\u0004S\u0006\t;iK\u0002\u001aXmY8oI6zg-L7j]V$X\rI1oI\u0002JGo\u001d\u0011nS\u000e\u0014x.\f4sC\u000e$\u0018n\u001c8!i>\u0004#/\u001a9sKN,g\u000e\u001e\u0017!MJ|WN\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0019!i>\u0004c\u0007\r\u0018!\u0013\u001a\u0004C\u000f[3!g\u0016\u001c\u0007%\u0019:hk6,g\u000e\u001e\u0011fcV\fGn\u001d\u0011u_\u00022\u0004\u0007\f\u0011uQ\u0016\u00043/Z2p]\u0012\u001c\bEZ5fY\u0012\u0004\u0013n\u001d\u0011tKRT\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002Co\u001c\u00111A\u0005tG\rI\u0019![&tW\u000f^3!SN\u0004\u0013\r\u001a3fI\u0002\"x\u000e\t;iK\u00022\u0017N\\1mAQLW.Z:uC6\u0004hF\u0003\u0011!A\u0001\u0002\u0003E\u000b\u0011uS6,'p\u001c8fA5\u0002C\u000f[3!i&lW\r\t>p]\u0016\u0004\u0013\u000eZ3oi&4\u0017.\u001a:/A\u0019{'\u000fI3yC6\u0004H.\u001a\u0017!\u0007\u0016#F\u0006I+U\u0007\u0002\ng\u000e\u001a\u0011fi\u000et#\u0002\t\u0011\u0002\u0011\u0015D\u0018-\u001c9mKN\f#!!?\u0002\u0007\u001fQ\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006F\r\u00192i1\u0002\u0013G\r\u0017!eab\u0003E\u000e\u0017!gAb\u0003\u0005N\u001b/qa:\u0014f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00113aE\"T&\r\u001a.ea\u0002\u0003G\u000e\u001e4ai\"TG\f\u001d9o)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~C#\u0007M\u00195Y\u0001\n$\u0007\f\u00113q1\u0002c\u0007\f\u00114a1\u0002C'\u000e\u00189q]b\u0003eJ\"F)\u001eJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u001a1cQj\u0013GM\u00173o\u0001\u0012\u0014GO\u001a1uQ*d\u0006\u000f\u001d8\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"\u0012\u0004'M\u001d-AYb\u0003e\r\u0019-AI\u001aD\u0006I\u001b:Y\u00012\u0004'K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!eA\n\u0014(\f\u00198[A\n\u0004\u0005\r\u0019;aAR\u0004\u0007\r\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)eA\n\u0014\b\f\u00112g1\u0002\u0013\u0007\f\u00112a1\u0002\u0013'\r\u0017!cIb\u0003e\n)T)\u001eJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t(V\u00192S\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006F\\;mY2\u0002s\u0007\f\u00113e1\u0002\u0013'\u000e\u0017!gAb\u0003\u0005M\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!A9+F\n\u0014\u0006!A\u0005)qM]8va\u0006\u0012\u0011q`\u0001\u000fI\u0006$X\r^5nK~3WO\\2t\u0003\u0015\u0019\u0018N\\2fC\t\u0011)!A\u00034]Mr\u0003'\u0001\tNC.,G+[7fgR\fW\u000e\u001d'U5B\u00111iK\n\u0006W\t5!\u0011\u0004\t\u000f\u0005\u001f\u0011)\"X/^;vkVn]/|\u001b\t\u0011\tBC\u0002\u0003\u0014-\u000bqA];oi&lW-\u0003\u0003\u0003\u0018\tE!!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8osA!!1\u0004B\u0011\u001b\t\u0011iB\u0003\u0003\u0003 \u0005\u0005\u0016AA5p\u0013\rI&Q\u0004\u000b\u0003\u0005\u0013\t\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u00033\u000bQ!\u00199qYf$2c\u001fB\u0017\u0005_\u0011\tDa\r\u00036\t]\"\u0011\bB\u001e\u0005{AQa\u0017\u0018A\u0002uCQ!\u0019\u0018A\u0002uCQa\u0019\u0018A\u0002uCQ!\u001a\u0018A\u0002uCQa\u001a\u0018A\u0002uCQ!\u001b\u0018A\u0002uCQa\u001b\u0018A\u00025Dq!\u001d\u0018\u0011\u0002\u0003\u00071\u000fC\u0003x]\u0001\u0007Q,A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00139\u0003\u001d)h.\u00199qYf$BA!\u0012\u0003NA!!J\u001cB$!1Q%\u0011J/^;vkV,\\:^\u0013\r\u0011Ye\u0013\u0002\u0007)V\u0004H.Z\u001d\t\u0011\t=\u0003'!AA\u0002m\f1\u0001\u001f\u00131\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%q\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u0011!q\u000b\t\u0005\u00037\u0013I&\u0003\u0003\u0003\\\u0005u%AB(cU\u0016\u001cG\u000f")
public class MakeTimestampLTZ
extends UnaryExpression
implements RuntimeReplaceable,
Serializable {
    private final Expression year;
    private final Expression month;
    private final Expression day;
    private final Expression hour;
    private final Expression min;
    private final Expression sec;
    private final Option<Expression> timezone;
    private final boolean failOnError;
    private final Expression child;
    private Expression canonicalized;
    private Seq<Enumeration.Value> nodePatterns;
    private volatile boolean bitmap$0;

    public static boolean $lessinit$greater$default$8() {
        return MakeTimestampLTZ$.MODULE$.$lessinit$greater$default$8();
    }

    public static Option<Tuple9<Expression, Expression, Expression, Expression, Expression, Expression, Option<Expression>, Object, Expression>> unapply(MakeTimestampLTZ makeTimestampLTZ) {
        return MakeTimestampLTZ$.MODULE$.unapply(makeTimestampLTZ);
    }

    public static boolean apply$default$8() {
        return MakeTimestampLTZ$.MODULE$.apply$default$8();
    }

    public static Function1<Tuple9<Expression, Expression, Expression, Expression, Expression, Expression, Option<Expression>, Object, Expression>, MakeTimestampLTZ> tupled() {
        return MakeTimestampLTZ$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, Function1<Expression, Function1<Expression, Function1<Expression, Function1<Option<Expression>, Function1<Object, Function1<Expression, MakeTimestampLTZ>>>>>>>>> curried() {
        return MakeTimestampLTZ$.MODULE$.curried();
    }

    @Override
    public boolean nullable() {
        return RuntimeReplaceable.nullable$(this);
    }

    @Override
    public DataType dataType() {
        return RuntimeReplaceable.dataType$(this);
    }

    @Override
    public String sql() {
        return RuntimeReplaceable.sql$(this);
    }

    @Override
    public String mkString(Seq<String> childrenString) {
        return RuntimeReplaceable.mkString$(this, childrenString);
    }

    @Override
    public final boolean foldable() {
        return Unevaluable.foldable$(this);
    }

    @Override
    public final Object eval(InternalRow input) {
        return Unevaluable.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return Unevaluable.eval$default$1$(this);
    }

    @Override
    public final ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return Unevaluable.doGenCode$(this, ctx, ev);
    }

    private Expression canonicalized$lzycompute() {
        MakeTimestampLTZ makeTimestampLTZ = this;
        synchronized (makeTimestampLTZ) {
            if (!this.bitmap$0) {
                this.canonicalized = RuntimeReplaceable.canonicalized$(this);
                this.bitmap$0 = true;
            }
        }
        return this.canonicalized;
    }

    @Override
    public Expression canonicalized() {
        return !this.bitmap$0 ? this.canonicalized$lzycompute() : this.canonicalized;
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    @Override
    public final void org$apache$spark$sql$catalyst$expressions$RuntimeReplaceable$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public Expression year() {
        return this.year;
    }

    public Expression month() {
        return this.month;
    }

    public Expression day() {
        return this.day;
    }

    public Expression hour() {
        return this.hour;
    }

    public Expression min() {
        return this.min;
    }

    public Expression sec() {
        return this.sec;
    }

    public Option<Expression> timezone() {
        return this.timezone;
    }

    public boolean failOnError() {
        return this.failOnError;
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public String prettyName() {
        return "make_timestamp_ltz";
    }

    @Override
    public Seq<Expression> exprsReplaced() {
        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{this.year(), this.month(), this.day(), this.hour(), this.min(), this.sec()}));
    }

    @Override
    public Expression withNewChildInternal(Expression newChild) {
        Expression x$1 = newChild;
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        Expression x$4 = this.copy$default$3();
        Expression x$5 = this.copy$default$4();
        Expression x$6 = this.copy$default$5();
        Expression x$7 = this.copy$default$6();
        Option<Expression> x$8 = this.copy$default$7();
        boolean x$9 = this.copy$default$8();
        return this.copy(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$1);
    }

    public MakeTimestampLTZ copy(Expression year, Expression month, Expression day, Expression hour, Expression min, Expression sec, Option<Expression> timezone, boolean failOnError, Expression child) {
        return new MakeTimestampLTZ(year, month, day, hour, min, sec, timezone, failOnError, child);
    }

    public Expression copy$default$1() {
        return this.year();
    }

    public Expression copy$default$2() {
        return this.month();
    }

    public Expression copy$default$3() {
        return this.day();
    }

    public Expression copy$default$4() {
        return this.hour();
    }

    public Expression copy$default$5() {
        return this.min();
    }

    public Expression copy$default$6() {
        return this.sec();
    }

    public Option<Expression> copy$default$7() {
        return this.timezone();
    }

    public boolean copy$default$8() {
        return this.failOnError();
    }

    public Expression copy$default$9() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "MakeTimestampLTZ";
    }

    public int productArity() {
        return 9;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.year();
                break;
            }
            case 1: {
                object = this.month();
                break;
            }
            case 2: {
                object = this.day();
                break;
            }
            case 3: {
                object = this.hour();
                break;
            }
            case 4: {
                object = this.min();
                break;
            }
            case 5: {
                object = this.sec();
                break;
            }
            case 6: {
                object = this.timezone();
                break;
            }
            case 7: {
                object = BoxesRunTime.boxToBoolean((boolean)this.failOnError());
                break;
            }
            case 8: {
                object = this.child();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof MakeTimestampLTZ;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "year";
                break;
            }
            case 1: {
                string = "month";
                break;
            }
            case 2: {
                string = "day";
                break;
            }
            case 3: {
                string = "hour";
                break;
            }
            case 4: {
                string = "min";
                break;
            }
            case 5: {
                string = "sec";
                break;
            }
            case 6: {
                string = "timezone";
                break;
            }
            case 7: {
                string = "failOnError";
                break;
            }
            case 8: {
                string = "child";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof MakeTimestampLTZ)) return false;
        boolean bl = true;
        if (!bl) return false;
        MakeTimestampLTZ makeTimestampLTZ = (MakeTimestampLTZ)x$1;
        if (this.failOnError() != makeTimestampLTZ.failOnError()) return false;
        Expression expression = this.year();
        Expression expression2 = makeTimestampLTZ.year();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.month();
        Expression expression4 = makeTimestampLTZ.month();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.day();
        Expression expression6 = makeTimestampLTZ.day();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        Expression expression7 = this.hour();
        Expression expression8 = makeTimestampLTZ.hour();
        if (expression7 == null) {
            if (expression8 != null) {
                return false;
            }
        } else if (!expression7.equals(expression8)) return false;
        Expression expression9 = this.min();
        Expression expression10 = makeTimestampLTZ.min();
        if (expression9 == null) {
            if (expression10 != null) {
                return false;
            }
        } else if (!expression9.equals(expression10)) return false;
        Expression expression11 = this.sec();
        Expression expression12 = makeTimestampLTZ.sec();
        if (expression11 == null) {
            if (expression12 != null) {
                return false;
            }
        } else if (!expression11.equals(expression12)) return false;
        Option<Expression> option = this.timezone();
        Option<Expression> option2 = makeTimestampLTZ.timezone();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Expression expression13 = this.child();
        Expression expression14 = makeTimestampLTZ.child();
        if (expression13 == null) {
            if (expression14 != null) {
                return false;
            }
        } else if (!expression13.equals(expression14)) return false;
        if (!makeTimestampLTZ.canEqual(this)) return false;
        return true;
    }

    public MakeTimestampLTZ(Expression year, Expression month, Expression day, Expression hour, Expression min, Expression sec, Option<Expression> timezone, boolean failOnError, Expression child) {
        this.year = year;
        this.month = month;
        this.day = day;
        this.hour = hour;
        this.min = min;
        this.sec = sec;
        this.timezone = timezone;
        this.failOnError = failOnError;
        this.child = child;
        Unevaluable.$init$(this);
        RuntimeReplaceable.$init$(this);
        Statics.releaseFence();
    }

    public MakeTimestampLTZ(Expression year, Expression month, Expression day, Expression hour, Expression min, Expression sec) {
        Expression x$1 = year;
        Expression x$2 = month;
        Expression x$3 = day;
        Expression x$4 = hour;
        Expression x$5 = min;
        Expression x$6 = sec;
        TimestampType$ x$7 = TimestampType$.MODULE$;
        Option<Expression> x$8 = MakeTimestamp$.MODULE$.apply$default$7();
        Option<String> x$9 = MakeTimestamp$.MODULE$.apply$default$8();
        boolean x$10 = MakeTimestamp$.MODULE$.apply$default$9();
        this(year, month, day, hour, min, sec, (Option<Expression>)None$.MODULE$, SQLConf$.MODULE$.get().ansiEnabled(), new MakeTimestamp(x$1, x$2, x$3, x$4, x$5, x$6, x$8, x$9, x$10, x$7));
    }

    public MakeTimestampLTZ(Expression year, Expression month, Expression day, Expression hour, Expression min, Expression sec, Expression timezone) {
        Expression x$1 = year;
        Expression x$2 = month;
        Expression x$3 = day;
        Expression x$4 = hour;
        Expression x$5 = min;
        Expression x$6 = sec;
        Some x$7 = new Some((Object)timezone);
        TimestampType$ x$8 = TimestampType$.MODULE$;
        Option<String> x$9 = MakeTimestamp$.MODULE$.apply$default$8();
        boolean x$10 = MakeTimestamp$.MODULE$.apply$default$9();
        this(year, month, day, hour, min, sec, (Option<Expression>)new Some((Object)timezone), SQLConf$.MODULE$.get().ansiEnabled(), new MakeTimestamp(x$1, x$2, x$3, x$4, x$5, x$6, (Option<Expression>)x$7, x$9, x$10, x$8));
    }
}

