/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.LeafExpression;
import org.apache.spark.sql.catalyst.expressions.MonotonicallyIncreasingID$;
import org.apache.spark.sql.catalyst.expressions.Nondeterministic;
import org.apache.spark.sql.catalyst.expressions.Stateful;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.FalseLiteral$;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import scala.Product;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_() - Returns monotonically increasing 64-bit integers. The generated ID is guaranteed\n      to be monotonically increasing and unique, but not consecutive. The current implementation\n      puts the partition ID in the upper 31 bits, and the lower 33 bits represent the record number\n      within each partition. The assumption is that the data frame has less than 1 billion\n      partitions, and each partition has less than 8 billion records.\n      The function is non-deterministic because its result depends on partition IDs.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_();\n       0\n  ", since="1.4.0", group="misc_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005Ef\u0001B\u000e\u001d\u0001&BQa\u0011\u0001\u0005\u0002\u0011C\u0011B\u0012\u0001A\u0002\u0003\u0005\u000b\u0015B$\t\u00139\u0003\u0001\u0019!A!B\u00139\u0005\"\u0002)\u0001\t#\n\u0006\"\u0002.\u0001\t\u0003Z\u0006\"B0\u0001\t\u0003\u0002\u0007\"B4\u0001\t#B\u0007\"B8\u0001\t\u0003\u0002\b\"\u0002@\u0001\t\u0003z\b\"B\u0011\u0001\t\u0003z\bBBA\t\u0001\u0011\u0005C\t\u0003\u0005\u0002\u0014\u0001\t\t\u0011\"\u0001E\u0011%\t)\u0002AA\u0001\n\u0003\n9\u0002C\u0005\u0002(\u0001\t\t\u0011\"\u0001\u0002*!I\u00111\u0006\u0001\u0002\u0002\u0013\u0005\u0011Q\u0006\u0005\n\u0003s\u0001\u0011\u0011!C!\u0003wA\u0011\"!\u0013\u0001\u0003\u0003%\t!a\u0013\t\u0013\u0005=\u0003!!A\u0005B\u0005E\u0003\"CA+\u0001\u0005\u0005I\u0011IA,\u000f%\tY\bHA\u0001\u0012\u0003\tiH\u0002\u0005\u001c9\u0005\u0005\t\u0012AA@\u0011\u0019\u0019U\u0003\"\u0001\u0002\u0018\"I\u0011\u0011T\u000b\u0002\u0002\u0013\u0015\u00131\u0014\u0005\t\u0003;+\u0012\u0011!CA\t\"I\u0011qT\u000b\u0002\u0002\u0013\u0005\u0015\u0011\u0015\u0005\n\u0003O+\u0012\u0011!C\u0005\u0003S\u0013\u0011$T8o_R|g.[2bY2L\u0018J\\2sK\u0006\u001c\u0018N\\4J\t*\u0011QDH\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002 A\u0005A1-\u0019;bYf\u001cHO\u0003\u0002\"E\u0005\u00191/\u001d7\u000b\u0005\r\"\u0013!B:qCJ\\'BA\u0013'\u0003\u0019\t\u0007/Y2iK*\tq%A\u0002pe\u001e\u001c\u0001aE\u0003\u0001U9\nt\u0007\u0005\u0002,Y5\tA$\u0003\u0002.9\tqA*Z1g\u000bb\u0004(/Z:tS>t\u0007CA\u00160\u0013\t\u0001DD\u0001\u0005Ti\u0006$XMZ;m!\t\u0011T'D\u00014\u0015\u0005!\u0014!B:dC2\f\u0017B\u0001\u001c4\u0005\u001d\u0001&o\u001c3vGR\u0004\"\u0001\u000f!\u000f\u0005erdB\u0001\u001e>\u001b\u0005Y$B\u0001\u001f)\u0003\u0019a$o\\8u}%\tA'\u0003\u0002@g\u00059\u0001/Y2lC\u001e,\u0017BA!C\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\ty4'\u0001\u0004=S:LGO\u0010\u000b\u0002\u000bB\u00111\u0006A\u0001\u0006G>,h\u000e\u001e\t\u0003e!K!!S\u001a\u0003\t1{gn\u001a\u0015\u0003\u0005-\u0003\"A\r'\n\u00055\u001b$!\u0003;sC:\u001c\u0018.\u001a8u\u00035\u0001\u0018M\u001d;ji&|g.T1tW\"\u00121aS\u0001\u0013S:LG/[1mSj,\u0017J\u001c;fe:\fG\u000e\u0006\u0002S+B\u0011!gU\u0005\u0003)N\u0012A!\u00168ji\")a\u000b\u0002a\u0001/\u0006q\u0001/\u0019:uSRLwN\\%oI\u0016D\bC\u0001\u001aY\u0013\tI6GA\u0002J]R\f\u0001B\\;mY\u0006\u0014G.Z\u000b\u00029B\u0011!'X\u0005\u0003=N\u0012qAQ8pY\u0016\fg.\u0001\u0005eCR\fG+\u001f9f+\u0005\t\u0007C\u00012f\u001b\u0005\u0019'B\u00013!\u0003\u0015!\u0018\u0010]3t\u0013\t17M\u0001\u0005ECR\fG+\u001f9f\u00031)g/\u00197J]R,'O\\1m)\t9\u0015\u000eC\u0003k\u000f\u0001\u00071.A\u0003j]B,H\u000f\u0005\u0002m[6\ta$\u0003\u0002o=\tY\u0011J\u001c;fe:\fGNU8x\u0003%!wnR3o\u0007>$W\rF\u0002ror\u0004\"A];\u000e\u0003MT!\u0001\u001e\u000f\u0002\u000f\r|G-Z4f]&\u0011ao\u001d\u0002\t\u000bb\u0004(oQ8eK\")\u0001\u0010\u0003a\u0001s\u0006\u00191\r\u001e=\u0011\u0005IT\u0018BA>t\u00059\u0019u\u000eZ3hK:\u001cuN\u001c;fqRDQ! \u0005A\u0002E\f!!\u001a<\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-\u0006\u0002\u0002\u0002A!\u00111AA\u0006\u001d\u0011\t)!a\u0002\u0011\u0005i\u001a\u0014bAA\u0005g\u00051\u0001K]3eK\u001aLA!!\u0004\u0002\u0010\t11\u000b\u001e:j]\u001eT1!!\u00034\u0003%1'/Z:i\u0007>\u0004\u00180\u0001\u0003d_BL\u0018!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002\u001aA!\u00111DA\u0013\u001b\t\tiB\u0003\u0003\u0002 \u0005\u0005\u0012\u0001\u00027b]\u001eT!!a\t\u0002\t)\fg/Y\u0005\u0005\u0003\u001b\ti\"\u0001\u0007qe>$Wo\u0019;Be&$\u00180F\u0001X\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!a\f\u00026A\u0019!'!\r\n\u0007\u0005M2GA\u0002B]fD\u0001\"a\u000e\u0010\u0003\u0003\u0005\raV\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005u\u0002CBA \u0003\u000b\ny#\u0004\u0002\u0002B)\u0019\u00111I\u001a\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002H\u0005\u0005#\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$2\u0001XA'\u0011%\t9$EA\u0001\u0002\u0004\ty#\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003BA\r\u0003'B\u0001\"a\u000e\u0013\u0003\u0003\u0005\raV\u0001\u0007KF,\u0018\r\\:\u0015\u0007q\u000bI\u0006C\u0005\u00028M\t\t\u00111\u0001\u00020!\u001a\u0002!!\u0018\u0002d\u0005\u0015\u0014\u0011NA6\u0003_\n\t(!\u001e\u0002xA\u00191&a\u0018\n\u0007\u0005\u0005DDA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\u0005\u001d\u0014\u0001\"\u0010\u000bA\u0001\u0002\u0003e\u0018$V\u001d\u000e{\u0006&\u000b\u0011.AI+G/\u001e:og\u0002jwN\\8u_:L7-\u00197ms\u0002Jgn\u0019:fCNLgn\u001a\u00117i5\u0012\u0017\u000e\u001e\u0011j]R,w-\u001a:t]\u0001\"\u0006.\u001a\u0011hK:,'/\u0019;fI\u0002JE\tI5tA\u001d,\u0018M]1oi\u0016,GM\u0003\u0011!A\u0001\u0002\u0003\u0005^8!E\u0016\u0004Sn\u001c8pi>t\u0017nY1mYf\u0004\u0013N\\2sK\u0006\u001c\u0018N\\4!C:$\u0007%\u001e8jcV,G\u0006\t2vi\u0002rw\u000e\u001e\u0011d_:\u001cXmY;uSZ,g\u0006\t+iK\u0002\u001aWO\u001d:f]R\u0004\u0013.\u001c9mK6,g\u000e^1uS>t'\u0002\t\u0011!A\u0001\u0002\u0003/\u001e;tAQDW\r\t9beRLG/[8oA%#\u0005%\u001b8!i\",\u0007%\u001e9qKJ\u00043'\r\u0011cSR\u001cH\u0006I1oI\u0002\"\b.\u001a\u0011m_^,'\u000fI\u001a4A\tLGo\u001d\u0011sKB\u0014Xm]3oi\u0002\"\b.\u001a\u0011sK\u000e|'\u000f\u001a\u0011ok6\u0014WM\u001d\u0006!A\u0001\u0002\u0003\u0005I<ji\"Lg\u000eI3bG\"\u0004\u0003/\u0019:uSRLwN\u001c\u0018!)\",\u0007%Y:tk6\u0004H/[8oA%\u001c\b\u0005\u001e5bi\u0002\"\b.\u001a\u0011eCR\f\u0007E\u001a:b[\u0016\u0004\u0003.Y:!Y\u0016\u001c8\u000f\t;iC:\u0004\u0013\u0007\t2jY2LwN\u001c\u0006!A\u0001\u0002\u0003\u0005\t9beRLG/[8og2\u0002\u0013M\u001c3!K\u0006\u001c\u0007\u000e\t9beRLG/[8oA!\f7\u000f\t7fgN\u0004C\u000f[1oAa\u0002#-\u001b7mS>t\u0007E]3d_J$7O\f\u0006!A\u0001\u0002\u0003\u0005\t+iK\u00022WO\\2uS>t\u0007%[:!]>tW\u0006Z3uKJl\u0017N\\5ti&\u001c\u0007EY3dCV\u001cX\rI5ug\u0002\u0012Xm];mi\u0002\"W\r]3oIN\u0004sN\u001c\u0011qCJ$\u0018\u000e^5p]\u0002JEi\u001d\u0018\u000bA\u0001\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0003[\n1G\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015*w)\u0001\u0003\u0005\t\u0011!A\u0001\u0002$\u0002\t\u0011\u0002\u000bMLgnY3\"\u0005\u0005M\u0014!B\u0019/i9\u0002\u0014!B4s_V\u0004\u0018EAA=\u0003)i\u0017n]2`MVt7m]\u0001\u001a\u001b>tw\u000e^8oS\u000e\fG\u000e\\=J]\u000e\u0014X-Y:j]\u001eLE\t\u0005\u0002,+M)Q#!!\u0002\u000eB)\u00111QAE\u000b6\u0011\u0011Q\u0011\u0006\u0004\u0003\u000f\u001b\u0014a\u0002:v]RLW.Z\u0005\u0005\u0003\u0017\u000b)IA\tBEN$(/Y2u\rVt7\r^5p]B\u0002B!a$\u0002\u00166\u0011\u0011\u0011\u0013\u0006\u0005\u0003'\u000b\t#\u0001\u0002j_&\u0019\u0011)!%\u0015\u0005\u0005u\u0014\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005e\u0011!B1qa2L\u0018aB;oCB\u0004H.\u001f\u000b\u00049\u0006\r\u0006\u0002CAS3\u0005\u0005\t\u0019A#\u0002\u0007a$\u0003'\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0002,B!\u00111DAW\u0013\u0011\ty+!\b\u0003\r=\u0013'.Z2u\u0001")
public class MonotonicallyIncreasingID
extends LeafExpression
implements Stateful,
Serializable {
    private transient long count;
    private transient long partitionMask;
    private boolean deterministic;
    private transient boolean org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized;
    private volatile boolean bitmap$0;

    public static boolean unapply(MonotonicallyIncreasingID monotonicallyIncreasingID) {
        return MonotonicallyIncreasingID$.MODULE$.unapply(monotonicallyIncreasingID);
    }

    @Override
    public boolean fastEquals(TreeNode<?> other) {
        return Stateful.fastEquals$(this, other);
    }

    @Override
    public final boolean foldable() {
        return Nondeterministic.foldable$(this);
    }

    @Override
    public final void initialize(int partitionIndex) {
        Nondeterministic.initialize$(this, partitionIndex);
    }

    @Override
    public final Object eval(InternalRow input) {
        return Nondeterministic.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return Nondeterministic.eval$default$1$(this);
    }

    private boolean deterministic$lzycompute() {
        MonotonicallyIncreasingID monotonicallyIncreasingID = this;
        synchronized (monotonicallyIncreasingID) {
            if (!this.bitmap$0) {
                this.deterministic = Nondeterministic.deterministic$(this);
                this.bitmap$0 = true;
            }
        }
        return this.deterministic;
    }

    @Override
    public final boolean deterministic() {
        return !this.bitmap$0 ? this.deterministic$lzycompute() : this.deterministic;
    }

    @Override
    public boolean org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized() {
        return this.org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized;
    }

    @Override
    public void org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized_$eq(boolean x$1) {
        this.org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized = x$1;
    }

    @Override
    public void initializeInternal(int partitionIndex) {
        this.count = 0L;
        this.partitionMask = (long)partitionIndex << 33;
    }

    @Override
    public boolean nullable() {
        return false;
    }

    @Override
    public DataType dataType() {
        return LongType$.MODULE$;
    }

    public long evalInternal(InternalRow input) {
        long currentCount = this.count++;
        return this.partitionMask + currentCount;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String countTerm = ctx.addMutableState("long", "count", ctx.addMutableState$default$3(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
        String partitionMaskTerm = "partitionMask";
        ctx.addImmutableStateIfNotExists("long", partitionMaskTerm, ctx.addImmutableStateIfNotExists$default$3());
        ctx.addPartitionInitializationStatement(new StringBuilder(6).append(countTerm).append(" = 0L;").toString());
        ctx.addPartitionInitializationStatement(new StringBuilder(33).append(partitionMaskTerm).append(" = ((long) partitionIndex) << 33;").toString());
        return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n      final ", " ", " = ", " + ", ";\n      ", "++;"}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), partitionMaskTerm, countTerm, countTerm})), FalseLiteral$.MODULE$, ev.copy$default$3());
    }

    @Override
    public String prettyName() {
        return "monotonically_increasing_id";
    }

    @Override
    public String sql() {
        return new StringBuilder(2).append(this.prettyName()).append("()").toString();
    }

    @Override
    public MonotonicallyIncreasingID freshCopy() {
        return new MonotonicallyIncreasingID();
    }

    public MonotonicallyIncreasingID copy() {
        return new MonotonicallyIncreasingID();
    }

    @Override
    public String productPrefix() {
        return "MonotonicallyIncreasingID";
    }

    public int productArity() {
        return 0;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        Object object = Statics.ioobe((int)x$1);
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof MonotonicallyIncreasingID;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        String string = (String)Statics.ioobe((int)x$1);
        return string;
    }

    public boolean equals(Object x$1) {
        Object object = x$1;
        boolean bl = object instanceof MonotonicallyIncreasingID;
        return bl && ((MonotonicallyIncreasingID)x$1).canEqual(this);
    }

    public MonotonicallyIncreasingID() {
        Nondeterministic.$init$(this);
        Stateful.$init$(this);
    }
}

