/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.GetTimestamp;
import org.apache.spark.sql.catalyst.expressions.GetTimestamp$;
import org.apache.spark.sql.catalyst.expressions.ParseToTimestampNTZ$;
import org.apache.spark.sql.catalyst.expressions.RuntimeReplaceable;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.Unevaluable;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.TimestampNTZType$;
import scala.Enumeration;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(timestamp_str[, fmt]) - Parses the `timestamp_str` expression with the `fmt` expression\n      to a timestamp without time zone. Returns null with invalid input. By default, it follows casting rules to\n      a timestamp if the `fmt` is omitted.\n  ", arguments="\n    Arguments:\n      * timestamp_str - A string to be parsed to timestamp without time zone.\n      * fmt - Timestamp format pattern to follow. See <a href=\"https://spark.apache.org/docs/latest/sql-ref-datetime-pattern.html\">Datetime Patterns</a> for valid\n              date and time format patterns.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('2016-12-31 00:12:00');\n       2016-12-31 00:12:00\n      > SELECT _FUNC_('2016-12-31', 'yyyy-MM-dd');\n       2016-12-31 00:00:00\n  ", group="datetime_funcs", since="3.3.0")
@ScalaSignature(bytes="\u0006\u0005\u0005-h\u0001B\u0011#\u0001>B\u0001\"\u0013\u0001\u0003\u0016\u0004%\tA\u0013\u0005\t\u001d\u0002\u0011\t\u0012)A\u0005\u0017\"Aq\n\u0001BK\u0002\u0013\u0005\u0001\u000b\u0003\u0005U\u0001\tE\t\u0015!\u0003R\u0011!)\u0006A!f\u0001\n\u0003Q\u0005\u0002\u0003,\u0001\u0005#\u0005\u000b\u0011B&\t\u000b]\u0003A\u0011\u0001-\t\u000b]\u0003A\u0011A/\t\u000b]\u0003A\u0011\u00011\t\u000b\t\u0004A\u0011I2\t\u000b)\u0004A\u0011I6\t\u000b=\u0004A\u0011\t9\t\u000be\u0004A\u0011\t>\t\u000f\u0005\r\u0001\u0001\"\u0015\u0002\u0006!I\u00111\u0002\u0001\u0002\u0002\u0013\u0005\u0011Q\u0002\u0005\n\u0003+\u0001\u0011\u0013!C\u0001\u0003/A\u0011\"!\f\u0001#\u0003%\t!a\f\t\u0013\u0005M\u0002!%A\u0005\u0002\u0005]\u0001\"CA\u001b\u0001\u0005\u0005I\u0011IA\u001c\u0011%\t9\u0005AA\u0001\n\u0003\tI\u0005C\u0005\u0002R\u0001\t\t\u0011\"\u0001\u0002T!I\u0011\u0011\f\u0001\u0002\u0002\u0013\u0005\u00131\f\u0005\n\u0003O\u0002\u0011\u0011!C\u0001\u0003SB\u0011\"a\u001d\u0001\u0003\u0003%\t%!\u001e\t\u0013\u0005e\u0004!!A\u0005B\u0005mt!CASE\u0005\u0005\t\u0012AAT\r!\t#%!A\t\u0002\u0005%\u0006BB,\u001c\t\u0003\t\t\rC\u0005\u0002Dn\t\t\u0011\"\u0012\u0002F\"I\u0011qY\u000e\u0002\u0002\u0013\u0005\u0015\u0011\u001a\u0005\n\u0003#\\\u0012\u0011!CA\u0003'D\u0011\"!9\u001c\u0003\u0003%I!a9\u0003'A\u000b'o]3U_RKW.Z:uC6\u0004h\n\u0016.\u000b\u0005\r\"\u0013aC3yaJ,7o]5p]NT!!\n\u0014\u0002\u0011\r\fG/\u00197zgRT!a\n\u0015\u0002\u0007M\fHN\u0003\u0002*U\u0005)1\u000f]1sW*\u00111\u0006L\u0001\u0007CB\f7\r[3\u000b\u00035\n1a\u001c:h\u0007\u0001\u0019R\u0001\u0001\u00195ou\u0002\"!\r\u001a\u000e\u0003\tJ!a\r\u0012\u0003\u001fUs\u0017M]=FqB\u0014Xm]:j_:\u0004\"!M\u001b\n\u0005Y\u0012#A\u0005*v]RLW.\u001a*fa2\f7-Z1cY\u0016\u0004\"\u0001O\u001e\u000e\u0003eR\u0011AO\u0001\u0006g\u000e\fG.Y\u0005\u0003ye\u0012q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002?\r:\u0011q\b\u0012\b\u0003\u0001\u000ek\u0011!\u0011\u0006\u0003\u0005:\na\u0001\u0010:p_Rt\u0014\"\u0001\u001e\n\u0005\u0015K\u0014a\u00029bG.\fw-Z\u0005\u0003\u000f\"\u0013AbU3sS\u0006d\u0017N_1cY\u0016T!!R\u001d\u0002\t1,g\r^\u000b\u0002\u0017B\u0011\u0011\u0007T\u0005\u0003\u001b\n\u0012!\"\u0012=qe\u0016\u001c8/[8o\u0003\u0015aWM\u001a;!\u0003\u00191wN]7biV\t\u0011\u000bE\u00029%.K!aU\u001d\u0003\r=\u0003H/[8o\u0003\u001d1wN]7bi\u0002\nQa\u00195jY\u0012\faa\u00195jY\u0012\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0003Z5nc\u0006CA\u0019\u0001\u0011\u0015Iu\u00011\u0001L\u0011\u0015yu\u00011\u0001R\u0011\u0015)v\u00011\u0001L)\rIfl\u0018\u0005\u0006\u0013\"\u0001\ra\u0013\u0005\u0006\u001f\"\u0001\ra\u0013\u000b\u00033\u0006DQ!S\u0005A\u0002-\u000bQB\u001a7bi\u0006\u0013x-^7f]R\u001cX#\u00013\u0011\u0007y*w-\u0003\u0002g\u0011\nA\u0011\n^3sCR|'\u000f\u0005\u00029Q&\u0011\u0011.\u000f\u0002\u0004\u0003:L\u0018!D3yaJ\u001c(+\u001a9mC\u000e,G-F\u0001m!\rqTnS\u0005\u0003]\"\u00131aU3r\u0003)\u0001(/\u001a;us:\u000bW.Z\u000b\u0002cB\u0011!O\u001e\b\u0003gR\u0004\"\u0001Q\u001d\n\u0005UL\u0014A\u0002)sK\u0012,g-\u0003\u0002xq\n11\u000b\u001e:j]\u001eT!!^\u001d\u0002\u0011\u0011\fG/\u0019+za\u0016,\u0012a\u001f\t\u0003y~l\u0011! \u0006\u0003}\u001a\nQ\u0001^=qKNL1!!\u0001~\u0005!!\u0015\r^1UsB,\u0017\u0001F<ji\"tUm^\"iS2$\u0017J\u001c;fe:\fG\u000eF\u0002Z\u0003\u000fAa!!\u0003\u000f\u0001\u0004Y\u0015\u0001\u00038fo\u000eC\u0017\u000e\u001c3\u0002\t\r|\u0007/\u001f\u000b\b3\u0006=\u0011\u0011CA\n\u0011\u001dIu\u0002%AA\u0002-CqaT\b\u0011\u0002\u0003\u0007\u0011\u000bC\u0004V\u001fA\u0005\t\u0019A&\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011\u0011\u0004\u0016\u0004\u0017\u0006m1FAA\u000f!\u0011\ty\"!\u000b\u000e\u0005\u0005\u0005\"\u0002BA\u0012\u0003K\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\u001d\u0012(\u0001\u0006b]:|G/\u0019;j_:LA!a\u000b\u0002\"\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011\u0011\u0007\u0016\u0004#\u0006m\u0011AD2paf$C-\u001a4bk2$HeM\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005e\u0002\u0003BA\u001e\u0003\u000bj!!!\u0010\u000b\t\u0005}\u0012\u0011I\u0001\u0005Y\u0006twM\u0003\u0002\u0002D\u0005!!.\u0019<b\u0013\r9\u0018QH\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003\u0017\u00022\u0001OA'\u0013\r\ty%\u000f\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0004O\u0006U\u0003\"CA,+\u0005\u0005\t\u0019AA&\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011Q\f\t\u0006\u0003?\n)gZ\u0007\u0003\u0003CR1!a\u0019:\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0004M\u0006\u0005\u0014\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005-\u0014\u0011\u000f\t\u0004q\u00055\u0014bAA8s\t9!i\\8mK\u0006t\u0007\u0002CA,/\u0005\u0005\t\u0019A4\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0005\u0003s\t9\bC\u0005\u0002Xa\t\t\u00111\u0001\u0002L\u00051Q-];bYN$B!a\u001b\u0002~!A\u0011qK\r\u0002\u0002\u0003\u0007q\rK\f\u0001\u0003\u0003\u000b9)!#\u0002\u000e\u0006=\u00151SAK\u00033\u000bY*a(\u0002\"B\u0019\u0011'a!\n\u0007\u0005\u0015%EA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\u0005-\u0015A!\u0002\u000bA\u0001\u0002\u0003e\u0018$V\u001d\u000e{\u0006\u0006^5nKN$\u0018-\u001c9`gR\u00148\f\f\u0011g[Rl\u0016\u0006I\u0017!!\u0006\u00148/Z:!i\",\u0007\u0005\u0019;j[\u0016\u001cH/Y7q?N$(\u000f\u0019\u0011fqB\u0014Xm]:j_:\u0004s/\u001b;iAQDW\r\t1g[R\u0004\u0007%\u001a=qe\u0016\u001c8/[8o\u0015\u0001\u0002\u0003\u0005\t\u0011!i>\u0004\u0013\r\t;j[\u0016\u001cH/Y7qA]LG\u000f[8vi\u0002\"\u0018.\\3!u>tWM\f\u0011SKR,(O\\:!]VdG\u000eI<ji\"\u0004\u0013N\u001c<bY&$\u0007%\u001b8qkRt\u0003EQ=!I\u00164\u0017-\u001e7uY\u0001JG\u000f\t4pY2|wo\u001d\u0011dCN$\u0018N\\4!eVdWm\u001d\u0011u_*\u0001\u0003\u0005\t\u0011!A\u0005\u0004C/[7fgR\fW\u000e\u001d\u0011jM\u0002\"\b.\u001a\u0011aM6$\b\rI5tA=l\u0017\u000e\u001e;fI:R\u0001\u0005I\u0001\nCJ<W/\\3oiN\f#!!%\u0002\u0005CR\u0001\u0005\t\u0011!\u0003J<W/\\3oiNT$\u0002\t\u0011!A\u0001\u0002#\u0006\t;j[\u0016\u001cH/Y7q?N$(\u000fI\u0017!\u0003\u0002\u001aHO]5oO\u0002\"x\u000e\t2fAA\f'o]3eAQ|\u0007\u0005^5nKN$\u0018-\u001c9!o&$\bn\\;uAQLW.\u001a\u0011{_:,gF\u0003\u0011!A\u0001\u0002\u0003E\u000b\u0011g[R\u0004S\u0006\t+j[\u0016\u001cH/Y7qA\u0019|'/\\1uAA\fG\u000f^3s]\u0002\"x\u000e\t4pY2|wO\f\u0011TK\u0016\u0004C(\u0019\u0011ie\u00164WH\t5uiB\u001c(hL\u0018ta\u0006\u00148NL1qC\u000eDWML8sO>\"wnY:0Y\u0006$Xm\u001d;0gFdWF]3g[\u0011\fG/\u001a;j[\u0016l\u0003/\u0019;uKJtg\u0006\u001b;nY\nrD)\u0019;fi&lW\r\t)biR,'O\\:=_\u0005t\u0004EZ8sAY\fG.\u001b3\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!I\u0006$X\rI1oI\u0002\"\u0018.\\3!M>\u0014X.\u0019;!a\u0006$H/\u001a:og:R\u0001\u0005I\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012\u0011qS\u0001\u0002R)\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~CsE\r\u00192m5\n$'L\u001a2AA\u0002$(\r\u001a;aA:\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00113aE2T&\r\u001a.gE\u0002\u0003\u0007\r\u001e2ei\u0002\u0004G\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015(eA\nd'L\u00193[M\nt\u0005\f\u0011(sfL\u00180L'N[\u0011$w%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!eA\nd'L\u00193[M\n\u0004\u0005\r\u0019;aAR\u0004\u0007\r\u0006!A\u0005)qM]8va\u0006\u0012\u0011QT\u0001\u000fI\u0006$X\r^5nK~3WO\\2t\u0003\u0015\u0019\u0018N\\2fC\t\t\u0019+A\u00034]Mr\u0003'A\nQCJ\u001cX\rV8US6,7\u000f^1na:#&\f\u0005\u000227M)1$a+\u00028BA\u0011QVAZ\u0017F[\u0015,\u0004\u0002\u00020*\u0019\u0011\u0011W\u001d\u0002\u000fI,h\u000e^5nK&!\u0011QWAX\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gn\r\t\u0005\u0003s\u000by,\u0004\u0002\u0002<*!\u0011QXA!\u0003\tIw.C\u0002H\u0003w#\"!a*\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!!\u000f\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000fe\u000bY-!4\u0002P\")\u0011J\ba\u0001\u0017\")qJ\ba\u0001#\")QK\ba\u0001\u0017\u00069QO\\1qa2LH\u0003BAk\u0003;\u0004B\u0001\u000f*\u0002XB1\u0001(!7L#.K1!a7:\u0005\u0019!V\u000f\u001d7fg!A\u0011q\\\u0010\u0002\u0002\u0003\u0007\u0011,A\u0002yIA\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"!!:\u0011\t\u0005m\u0012q]\u0005\u0005\u0003S\fiD\u0001\u0004PE*,7\r\u001e")
public class ParseToTimestampNTZ
extends UnaryExpression
implements RuntimeReplaceable,
Serializable {
    private final Expression left;
    private final Option<Expression> format;
    private final Expression child;
    private Expression canonicalized;
    private Seq<Enumeration.Value> nodePatterns;
    private volatile boolean bitmap$0;

    public static Option<Tuple3<Expression, Option<Expression>, Expression>> unapply(ParseToTimestampNTZ parseToTimestampNTZ) {
        return ParseToTimestampNTZ$.MODULE$.unapply(parseToTimestampNTZ);
    }

    public static Function1<Tuple3<Expression, Option<Expression>, Expression>, ParseToTimestampNTZ> tupled() {
        return ParseToTimestampNTZ$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Option<Expression>, Function1<Expression, ParseToTimestampNTZ>>> curried() {
        return ParseToTimestampNTZ$.MODULE$.curried();
    }

    @Override
    public boolean nullable() {
        return RuntimeReplaceable.nullable$(this);
    }

    @Override
    public String sql() {
        return RuntimeReplaceable.sql$(this);
    }

    @Override
    public String mkString(Seq<String> childrenString) {
        return RuntimeReplaceable.mkString$(this, childrenString);
    }

    @Override
    public final boolean foldable() {
        return Unevaluable.foldable$(this);
    }

    @Override
    public final Object eval(InternalRow input) {
        return Unevaluable.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return Unevaluable.eval$default$1$(this);
    }

    @Override
    public final ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return Unevaluable.doGenCode$(this, ctx, ev);
    }

    private Expression canonicalized$lzycompute() {
        ParseToTimestampNTZ parseToTimestampNTZ = this;
        synchronized (parseToTimestampNTZ) {
            if (!this.bitmap$0) {
                this.canonicalized = RuntimeReplaceable.canonicalized$(this);
                this.bitmap$0 = true;
            }
        }
        return this.canonicalized;
    }

    @Override
    public Expression canonicalized() {
        return !this.bitmap$0 ? this.canonicalized$lzycompute() : this.canonicalized;
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    @Override
    public final void org$apache$spark$sql$catalyst$expressions$RuntimeReplaceable$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public Expression left() {
        return this.left;
    }

    public Option<Expression> format() {
        return this.format;
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public Iterator<Object> flatArguments() {
        return package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{this.left(), this.format()}));
    }

    @Override
    public Seq<Expression> exprsReplaced() {
        Expression expression = this.left();
        return (Seq)Option$.MODULE$.option2Iterable(this.format()).toSeq().$plus$colon((Object)expression);
    }

    @Override
    public String prettyName() {
        return "to_timestamp_ntz";
    }

    @Override
    public DataType dataType() {
        return TimestampNTZType$.MODULE$;
    }

    @Override
    public ParseToTimestampNTZ withNewChildInternal(Expression newChild) {
        Expression x$1 = newChild;
        Expression x$2 = this.copy$default$1();
        Option<Expression> x$3 = this.copy$default$2();
        return this.copy(x$2, x$3, x$1);
    }

    public ParseToTimestampNTZ copy(Expression left, Option<Expression> format, Expression child) {
        return new ParseToTimestampNTZ(left, format, child);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Option<Expression> copy$default$2() {
        return this.format();
    }

    public Expression copy$default$3() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "ParseToTimestampNTZ";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.left();
                break;
            }
            case 1: {
                object = this.format();
                break;
            }
            case 2: {
                object = this.child();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ParseToTimestampNTZ;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "left";
                break;
            }
            case 1: {
                string = "format";
                break;
            }
            case 2: {
                string = "child";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ParseToTimestampNTZ)) return false;
        boolean bl = true;
        if (!bl) return false;
        ParseToTimestampNTZ parseToTimestampNTZ = (ParseToTimestampNTZ)x$1;
        Expression expression = this.left();
        Expression expression2 = parseToTimestampNTZ.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Option<Expression> option = this.format();
        Option<Expression> option2 = parseToTimestampNTZ.format();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Expression expression3 = this.child();
        Expression expression4 = parseToTimestampNTZ.child();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!parseToTimestampNTZ.canEqual(this)) return false;
        return true;
    }

    public ParseToTimestampNTZ(Expression left, Option<Expression> format, Expression child) {
        this.left = left;
        this.format = format;
        this.child = child;
        Unevaluable.$init$(this);
        RuntimeReplaceable.$init$(this);
        Statics.releaseFence();
    }

    public ParseToTimestampNTZ(Expression left, Expression format) {
        this(left, (Option<Expression>)Option$.MODULE$.apply((Object)format), new GetTimestamp(left, format, TimestampNTZType$.MODULE$, GetTimestamp$.MODULE$.apply$default$4(), GetTimestamp$.MODULE$.apply$default$5()));
    }

    public ParseToTimestampNTZ(Expression left) {
        this(left, (Option<Expression>)None$.MODULE$, new Cast(left, TimestampNTZType$.MODULE$, Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4()));
    }
}

