/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.UnresolvedSeed$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.RDG;
import org.apache.spark.sql.catalyst.expressions.Randn$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.FalseLiteral$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.util.random.XORShiftRandom;
import scala.Option;
import scala.Product;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_([seed]) - Returns a random value with independent and identically distributed (i.i.d.) values drawn from the standard normal distribution.", examples="\n    Examples:\n      > SELECT _FUNC_();\n       -0.3254147983080288\n      > SELECT _FUNC_(0);\n       1.6034991609278433\n      > SELECT _FUNC_(null);\n       1.6034991609278433\n  ", note="\n    The function is non-deterministic in general case.\n  ", since="1.5.0", group="math_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005mh\u0001\u0002\u0012$\u0001BB\u0001b\u0012\u0001\u0003\u0016\u0004%\t\u0001\u0013\u0005\t\u0019\u0002\u0011\t\u0012)A\u0005\u0013\"AQ\n\u0001BK\u0002\u0013\u0005a\n\u0003\u0005S\u0001\tE\t\u0015!\u0003P\u0011\u0015\u0019\u0006\u0001\"\u0001U\u0011\u0015\u0019\u0006\u0001\"\u0001Y\u0011\u0015\u0019\u0006\u0001\"\u0001Z\u0011\u0015Y\u0006\u0001\"\u0011]\u0011\u0015\u0011\u0007\u0001\"\u0015d\u0011\u0015i\u0007\u0001\"\u0011o\u0011\u0015a\b\u0001\"\u0011Y\u0011\u0015i\b\u0001\"\u0011\u007f\u0011\u0019A\u0003\u0001\"\u0011\u0002\f!9\u0011Q\u0004\u0001\u0005R\u0005}\u0001\"CA\u0013\u0001\u0005\u0005I\u0011AA\u0014\u0011%\ti\u0003AI\u0001\n\u0003\ty\u0003C\u0005\u0002F\u0001\t\n\u0011\"\u0001\u0002H!I\u00111\n\u0001\u0002\u0002\u0013\u0005\u0013Q\n\u0005\n\u0003;\u0002\u0011\u0011!C\u0001\u0003?B\u0011\"a\u001a\u0001\u0003\u0003%\t!!\u001b\t\u0013\u0005=\u0004!!A\u0005B\u0005E\u0004\"CA?\u0001\u0005\u0005I\u0011AA@\u0011%\t\u0019\tAA\u0001\n\u0003\n)\tC\u0005\u0002\n\u0002\t\t\u0011\"\u0011\u0002\f\u001e9\u0011QW\u0012\t\u0002\u0005]fA\u0002\u0012$\u0011\u0003\tI\f\u0003\u0004T5\u0011\u0005\u00111\u001a\u0005\b\u0003\u001bTB\u0011AAh\u0011%\tiMGA\u0001\n\u0003\u000b\u0019\u000eC\u0005\u0002Zj\t\n\u0011\"\u0001\u0002H!I\u00111\u001c\u000e\u0002\u0002\u0013\u0005\u0015Q\u001c\u0005\n\u0003_T\u0012\u0013!C\u0001\u0003\u000fB\u0011\"!=\u001b\u0003\u0003%I!a=\u0003\u000bI\u000bg\u000e\u001a8\u000b\u0005\u0011*\u0013aC3yaJ,7o]5p]NT!AJ\u0014\u0002\u0011\r\fG/\u00197zgRT!\u0001K\u0015\u0002\u0007M\fHN\u0003\u0002+W\u0005)1\u000f]1sW*\u0011A&L\u0001\u0007CB\f7\r[3\u000b\u00039\n1a\u001c:h\u0007\u0001\u0019B\u0001A\u00196wA\u0011!gM\u0007\u0002G%\u0011Ag\t\u0002\u0004%\u0012;\u0005C\u0001\u001c:\u001b\u00059$\"\u0001\u001d\u0002\u000bM\u001c\u0017\r\\1\n\u0005i:$a\u0002)s_\u0012,8\r\u001e\t\u0003y\u0011s!!\u0010\"\u000f\u0005y\nU\"A \u000b\u0005\u0001{\u0013A\u0002\u001fs_>$h(C\u00019\u0013\t\u0019u'A\u0004qC\u000e\\\u0017mZ3\n\u0005\u00153%\u0001D*fe&\fG.\u001b>bE2,'BA\"8\u0003\u0015\u0019\u0007.\u001b7e+\u0005I\u0005C\u0001\u001aK\u0013\tY5E\u0001\u0006FqB\u0014Xm]:j_:\faa\u00195jY\u0012\u0004\u0013\u0001\u00035jI\u0016\u001cV-\u001a3\u0016\u0003=\u0003\"A\u000e)\n\u0005E;$a\u0002\"p_2,\u0017M\\\u0001\nQ&$WmU3fI\u0002\na\u0001P5oSRtDcA+W/B\u0011!\u0007\u0001\u0005\u0006\u000f\u0016\u0001\r!\u0013\u0005\b\u001b\u0016\u0001\n\u00111\u0001P)\u0005)FCA+[\u0011\u00159u\u00011\u0001J\u0003-9\u0018\u000e\u001e5OK^\u001cV-\u001a3\u0015\u0005Uk\u0006\"\u00020\t\u0001\u0004y\u0016\u0001B:fK\u0012\u0004\"A\u000e1\n\u0005\u0005<$\u0001\u0002'p]\u001e\fA\"\u001a<bY&sG/\u001a:oC2$\"\u0001Z4\u0011\u0005Y*\u0017B\u000148\u0005\u0019!u.\u001e2mK\")\u0001.\u0003a\u0001S\u0006)\u0011N\u001c9viB\u0011!n[\u0007\u0002K%\u0011A.\n\u0002\f\u0013:$XM\u001d8bYJ{w/A\u0005e_\u001e+gnQ8eKR\u0019q.\u001e>\u0011\u0005A\u001cX\"A9\u000b\u0005I\u001c\u0013aB2pI\u0016<WM\\\u0005\u0003iF\u0014\u0001\"\u0012=qe\u000e{G-\u001a\u0005\u0006m*\u0001\ra^\u0001\u0004GRD\bC\u00019y\u0013\tI\u0018O\u0001\bD_\u0012,w-\u001a8D_:$X\r\u001f;\t\u000bmT\u0001\u0019A8\u0002\u0005\u00154\u0018!\u00034sKND7i\u001c9z\u000351G.\u0019;Be\u001e,X.\u001a8ugV\tq\u0010E\u0003=\u0003\u0003\t)!C\u0002\u0002\u0004\u0019\u0013\u0001\"\u0013;fe\u0006$xN\u001d\t\u0004m\u0005\u001d\u0011bAA\u0005o\t\u0019\u0011I\\=\u0016\u0005\u00055\u0001\u0003BA\b\u0003/qA!!\u0005\u0002\u0014A\u0011ahN\u0005\u0004\u0003+9\u0014A\u0002)sK\u0012,g-\u0003\u0003\u0002\u001a\u0005m!AB*ue&twMC\u0002\u0002\u0016]\nAc^5uQ:+wo\u00115jY\u0012Le\u000e^3s]\u0006dGcA+\u0002\"!1\u00111\u0005\bA\u0002%\u000b\u0001B\\3x\u0007\"LG\u000eZ\u0001\u0005G>\u0004\u0018\u0010F\u0003V\u0003S\tY\u0003C\u0004H\u001fA\u0005\t\u0019A%\t\u000f5{\u0001\u0013!a\u0001\u001f\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA\u0019U\rI\u00151G\u0016\u0003\u0003k\u0001B!a\u000e\u0002B5\u0011\u0011\u0011\b\u0006\u0005\u0003w\ti$A\u0005v]\u000eDWmY6fI*\u0019\u0011qH\u001c\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002D\u0005e\"!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TCAA%U\ry\u00151G\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005=\u0003\u0003BA)\u00037j!!a\u0015\u000b\t\u0005U\u0013qK\u0001\u0005Y\u0006twM\u0003\u0002\u0002Z\u0005!!.\u0019<b\u0013\u0011\tI\"a\u0015\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005\u0005\u0004c\u0001\u001c\u0002d%\u0019\u0011QM\u001c\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005\u0015\u00111\u000e\u0005\n\u0003[\"\u0012\u0011!a\u0001\u0003C\n1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA:!\u0019\t)(a\u001f\u0002\u00065\u0011\u0011q\u000f\u0006\u0004\u0003s:\u0014AC2pY2,7\r^5p]&!\u00111AA<\u0003!\u0019\u0017M\\#rk\u0006dGcA(\u0002\u0002\"I\u0011Q\u000e\f\u0002\u0002\u0003\u0007\u0011QA\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0002P\u0005\u001d\u0005\"CA7/\u0005\u0005\t\u0019AA1\u0003\u0019)\u0017/^1mgR\u0019q*!$\t\u0013\u00055\u0004$!AA\u0002\u0005\u0015\u0001f\u0006\u0001\u0002\u0012\u0006]\u0015\u0011TAO\u0003?\u000b\u0019+!*\u0002*\u0006-\u0016qVAY!\r\u0011\u00141S\u0005\u0004\u0003+\u001b#!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u00037\u000b\u00111E0G+:\u001bu\fK.tK\u0016$W,\u000b\u0011.AI+G/\u001e:og\u0002\n\u0007E]1oI>l\u0007E^1mk\u0016\u0004s/\u001b;iA%tG-\u001a9f]\u0012,g\u000e\u001e\u0011b]\u0012\u0004\u0013\u000eZ3oi&\u001c\u0017\r\u001c7zA\u0011L7\u000f\u001e:jEV$X\r\u001a\u0011)S:Jg\u0006\u001a\u0018*AY\fG.^3tA\u0011\u0014\u0018m\u001e8!MJ|W\u000e\t;iK\u0002\u001aH/\u00198eCJ$\u0007E\\8s[\u0006d\u0007\u0005Z5tiJL'-\u001e;j_:t\u0013\u0001C3yC6\u0004H.Z:\"\u0005\u0005\u0005\u0016!!\u0019\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q%Z$\u0002\t\u0011!A\u0001\u0002\u0003%\f\u0019/gI*D'\r\u001b8sa\u001a\u0004\u0007\u000f\u00193qaR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006\u0006M\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AErc\u0007M\u001a5se\nd\u0007M\u001d3oa\"4g\r\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)]VdG.K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!c92\u0004g\r\u001b:sE2\u0004'\u000f\u001a8qQ\u001a4G\u0003\u0011!\u0003\u0011qw\u000e^3\"\u0005\u0005\u001d\u0016A\u000f\u0006!A\u0001\u0002C\u000b[3!MVt7\r^5p]\u0002J7\u000f\t8p]6\"W\r^3s[&t\u0017n\u001d;jG\u0002Jg\u000eI4f]\u0016\u0014\u0018\r\u001c\u0011dCN,gF\u0003\u0011!\u0003\u0015\u0019\u0018N\\2fC\t\ti+A\u00032]Ur\u0003'A\u0003he>,\b/\t\u0002\u00024\u0006QQ.\u0019;i?\u001a,hnY:\u0002\u000bI\u000bg\u000e\u001a8\u0011\u0005IR2#\u0002\u000e\u0002<\u0006\u0005\u0007c\u0001\u001c\u0002>&\u0019\u0011qX\u001c\u0003\r\u0005s\u0017PU3g!\u0011\t\u0019-!3\u000e\u0005\u0005\u0015'\u0002BAd\u0003/\n!![8\n\u0007\u0015\u000b)\r\u0006\u0002\u00028\u0006)\u0011\r\u001d9msR\u0019Q+!5\t\u000byc\u0002\u0019A0\u0015\u000bU\u000b).a6\t\u000b\u001dk\u0002\u0019A%\t\u000f5k\u0002\u0013!a\u0001\u001f\u0006y\u0011\r\u001d9ms\u0012\"WMZ1vYR$#'A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005}\u00171\u001e\t\u0006m\u0005\u0005\u0018Q]\u0005\u0004\u0003G<$AB(qi&|g\u000eE\u00037\u0003OLu*C\u0002\u0002j^\u0012a\u0001V;qY\u0016\u0014\u0004\u0002CAw?\u0005\u0005\t\u0019A+\u0002\u0007a$\u0003'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HEM\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u0003k\u0004B!!\u0015\u0002x&!\u0011\u0011`A*\u0005\u0019y%M[3di\u0002")
public class Randn
extends RDG
implements Serializable {
    private final Expression child;
    private final boolean hideSeed;

    public static boolean $lessinit$greater$default$2() {
        return Randn$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple2<Expression, Object>> unapply(Randn randn) {
        return Randn$.MODULE$.unapply(randn);
    }

    public static boolean apply$default$2() {
        return Randn$.MODULE$.apply$default$2();
    }

    @Override
    public Expression child() {
        return this.child;
    }

    public boolean hideSeed() {
        return this.hideSeed;
    }

    @Override
    public Randn withNewSeed(long seed) {
        return new Randn(new Literal(BoxesRunTime.boxToLong((long)seed), LongType$.MODULE$), this.hideSeed());
    }

    public double evalInternal(InternalRow input) {
        return this.rng().nextGaussian();
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String className = XORShiftRandom.class.getName();
        String rngTerm = ctx.addMutableState(className, "rng", ctx.addMutableState$default$3(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
        ctx.addPartitionInitializationStatement(new StringBuilder(28).append(rngTerm).append(" = new ").append(className).append("(").append(this.seed()).append("L + partitionIndex);").toString());
        return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n      final ", " ", " = ", ".nextGaussian();"}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), rngTerm})), FalseLiteral$.MODULE$, ev.copy$default$3());
    }

    @Override
    public Randn freshCopy() {
        return new Randn(this.child(), this.hideSeed());
    }

    @Override
    public Iterator<Object> flatArguments() {
        return package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{this.child()}));
    }

    @Override
    public String sql() {
        return new StringBuilder(7).append("randn(").append((Object)(this.hideSeed() ? "" : this.child().sql())).append(")").toString();
    }

    @Override
    public Randn withNewChildInternal(Expression newChild) {
        return this.copy(newChild, this.copy$default$2());
    }

    public Randn copy(Expression child, boolean hideSeed) {
        return new Randn(child, hideSeed);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public boolean copy$default$2() {
        return this.hideSeed();
    }

    @Override
    public String productPrefix() {
        return "Randn";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.child();
                break;
            }
            case 1: {
                object = BoxesRunTime.boxToBoolean((boolean)this.hideSeed());
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Randn;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "child";
                break;
            }
            case 1: {
                string = "hideSeed";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Randn)) return false;
        boolean bl = true;
        if (!bl) return false;
        Randn randn = (Randn)x$1;
        if (this.hideSeed() != randn.hideSeed()) return false;
        Expression expression = this.child();
        Expression expression2 = randn.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!randn.canEqual(this)) return false;
        return true;
    }

    public Randn(Expression child, boolean hideSeed) {
        this.child = child;
        this.hideSeed = hideSeed;
    }

    public Randn() {
        this(UnresolvedSeed$.MODULE$, true);
    }

    public Randn(Expression child) {
        this(child, false);
    }
}

