/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.QuaternaryExpression;
import org.apache.spark.sql.catalyst.expressions.WidthBucket$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.NumericType;
import scala.Function4;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(value, min_value, max_value, num_bucket) - Returns the bucket number to which\n      `value` would be assigned in an equiwidth histogram with `num_bucket` buckets,\n      in the range `min_value` to `max_value`.\"\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(5.3, 0.2, 10.6, 5);\n       3\n      > SELECT _FUNC_(-2.1, 1.3, 3.4, 3);\n       0\n      > SELECT _FUNC_(8.1, 0.0, 5.7, 4);\n       5\n      > SELECT _FUNC_(-0.9, 5.2, 0.5, 2);\n       3\n  ", since="3.1.0", group="math_funcs")
@ScalaSignature(bytes="\u0006\u0005\t\u0015t!\u0002\u0016,\u0011\u0003Ad!\u0002\u001e,\u0011\u0003Y\u0004\"\u0002&\u0002\t\u0003Y\u0005\"\u0002'\u0002\t\u0003i\u0005\"B1\u0002\t\u0003\u0011\u0007\"\u00026\u0002\t\u0003Y\u0007b\u00029\u0002\u0003\u0003%\t)\u001d\u0005\n\u0005\u000f\n\u0011\u0011!CA\u0005\u0013B\u0011Ba\u0017\u0002\u0003\u0003%IA!\u0018\u0007\tiZ\u0003i\u001d\u0005\n+&\u0011)\u001a!C\u0001\u0003;A!\"!\n\n\u0005#\u0005\u000b\u0011BA\u0010\u0011)\t9#\u0003BK\u0002\u0013\u0005\u0011Q\u0004\u0005\u000b\u0003SI!\u0011#Q\u0001\n\u0005}\u0001BCA\u0016\u0013\tU\r\u0011\"\u0001\u0002\u001e!Q\u0011QF\u0005\u0003\u0012\u0003\u0006I!a\b\t\u0013yK!Q3A\u0005\u0002\u0005u\u0001BCA\u0018\u0013\tE\t\u0015!\u0003\u0002 !1!*\u0003C\u0001\u0003cAq!a\u000f\n\t\u0003\ni\u0004C\u0004\u0002R%!\t%a\u0015\t\u000f\u0005m\u0013\u0002\"\u0011\u0002^!9\u0011qL\u0005\u0005B\u0005\u0005\u0004bBA:\u0013\u0011E\u0013Q\u000f\u0005\b\u0003\u000fKA\u0011IAE\u0011\u001d\t)+\u0003C!\u0003;Aq!a*\n\t\u0003\ni\u0002C\u0004\u0002*&!\t%!\b\t\u000f\u0005-\u0016\u0002\"\u0011\u0002\u001e!9\u0011QV\u0005\u0005R\u0005=\u0006\"CA]\u0013\u0005\u0005I\u0011AA^\u0011%\t)-CI\u0001\n\u0003\t9\rC\u0005\u0002^&\t\n\u0011\"\u0001\u0002H\"I\u0011q\\\u0005\u0012\u0002\u0013\u0005\u0011q\u0019\u0005\n\u0003CL\u0011\u0013!C\u0001\u0003\u000fD\u0011\"a9\n\u0003\u0003%\t%!:\t\u0013\u0005-\u0018\"!A\u0005\u0002\u00055\b\"CA{\u0013\u0005\u0005I\u0011AA|\u0011%\ti0CA\u0001\n\u0003\ny\u0010C\u0005\u0003\u000e%\t\t\u0011\"\u0001\u0003\u0010!I!1C\u0005\u0002\u0002\u0013\u0005#Q\u0003\u0005\n\u00053I\u0011\u0011!C!\u00057\t1bV5ei\"\u0014UoY6fi*\u0011A&L\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002/_\u0005A1-\u0019;bYf\u001cHO\u0003\u00021c\u0005\u00191/\u001d7\u000b\u0005I\u001a\u0014!B:qCJ\\'B\u0001\u001b6\u0003\u0019\t\u0007/Y2iK*\ta'A\u0002pe\u001e\u001c\u0001\u0001\u0005\u0002:\u00035\t1FA\u0006XS\u0012$\bNQ;dW\u0016$8cA\u0001=\u0005B\u0011Q\bQ\u0007\u0002})\tq(A\u0003tG\u0006d\u0017-\u0003\u0002B}\t1\u0011I\\=SK\u001a\u0004\"a\u0011%\u000e\u0003\u0011S!!\u0012$\u0002\u0005%|'\"A$\u0002\t)\fg/Y\u0005\u0003\u0013\u0012\u0013AbU3sS\u0006d\u0017N_1cY\u0016\fa\u0001P5oSRtD#\u0001\u001d\u0002'\r|W\u000e];uK\n+8m[3u\u001dVl'-\u001a:\u0015\u000b9#\u0016lW/\u0011\u0005=\u0013V\"\u0001)\u000b\u0005E3\u0015\u0001\u00027b]\u001eL!a\u0015)\u0003\t1{gn\u001a\u0005\u0006+\u000e\u0001\rAV\u0001\u0006m\u0006dW/\u001a\t\u0003{]K!\u0001\u0017 \u0003\r\u0011{WO\u00197f\u0011\u0015Q6\u00011\u0001W\u0003\ri\u0017N\u001c\u0005\u00069\u000e\u0001\rAV\u0001\u0004[\u0006D\b\"\u00020\u0004\u0001\u0004y\u0016!\u00038v[\n+8m[3u!\ti\u0004-\u0003\u0002T}\u00051\u0011n\u001d(vY2$Ra\u00194hQ&\u0004\"!\u00103\n\u0005\u0015t$a\u0002\"p_2,\u0017M\u001c\u0005\u0006+\u0012\u0001\rA\u0016\u0005\u00065\u0012\u0001\rA\u0016\u0005\u00069\u0012\u0001\rA\u0016\u0005\u0006=\u0012\u0001\raX\u0001\u001bG>l\u0007/\u001e;f\u0005V\u001c7.\u001a;Ok6\u0014WM\u001d(pi:+H\u000e\u001c\u000b\u0006\u001d2lgn\u001c\u0005\u0006+\u0016\u0001\rA\u0016\u0005\u00065\u0016\u0001\rA\u0016\u0005\u00069\u0016\u0001\rA\u0016\u0005\u0006=\u0016\u0001\raX\u0001\u0006CB\u0004H.\u001f\u000b\ne\n}\"\u0011\tB\"\u0005\u000b\u0002\"!O\u0005\u0014\u0011%!xO_A\u0002\u0003\u0013\u0001\"!O;\n\u0005Y\\#\u0001F)vCR,'O\\1ss\u0016C\bO]3tg&|g\u000e\u0005\u0002:q&\u0011\u0011p\u000b\u0002\u0017\u00136\u0004H.[2ji\u000e\u000b7\u000f^%oaV$H+\u001f9fgB\u00111P \b\u0003sqL!!`\u0016\u0002\u000fA\f7m[1hK&\u0019q0!\u0001\u0003\u001d9+H\u000e\\%oi>dWM]1oi*\u0011Qp\u000b\t\u0004{\u0005\u0015\u0011bAA\u0004}\t9\u0001K]8ek\u000e$\b\u0003BA\u0006\u00033qA!!\u0004\u0002\u00189!\u0011qBA\u000b\u001b\t\t\tBC\u0002\u0002\u0014]\na\u0001\u0010:p_Rt\u0014\"A \n\u0005ut\u0014bA%\u0002\u001c)\u0011QPP\u000b\u0003\u0003?\u00012!OA\u0011\u0013\r\t\u0019c\u000b\u0002\u000b\u000bb\u0004(/Z:tS>t\u0017A\u0002<bYV,\u0007%\u0001\u0005nS:4\u0016\r\\;f\u0003%i\u0017N\u001c,bYV,\u0007%\u0001\u0005nCb4\u0016\r\\;f\u0003%i\u0017\r\u001f,bYV,\u0007%\u0001\u0006ok6\u0014UoY6fi\u0002\"\u0012B]A\u001a\u0003k\t9$!\u000f\t\rU\u0013\u0002\u0019AA\u0010\u0011\u001d\t9C\u0005a\u0001\u0003?Aq!a\u000b\u0013\u0001\u0004\ty\u0002\u0003\u0004_%\u0001\u0007\u0011qD\u0001\u000bS:\u0004X\u000f\u001e+za\u0016\u001cXCAA !\u0019\tY!!\u0011\u0002F%!\u00111IA\u000e\u0005\r\u0019V-\u001d\t\u0005\u0003\u000f\ni%\u0004\u0002\u0002J)\u0019\u00111J\u0018\u0002\u000bQL\b/Z:\n\t\u0005=\u0013\u0011\n\u0002\u0011\u0003\n\u001cHO]1di\u0012\u000bG/\u0019+za\u0016\f\u0001\u0002Z1uCRK\b/Z\u000b\u0003\u0003+\u0002B!a\u0012\u0002X%!\u0011\u0011LA%\u0005!!\u0015\r^1UsB,\u0017\u0001\u00038vY2\f'\r\\3\u0016\u0003\r\f!\u0002\u001d:fiRLh*Y7f+\t\t\u0019\u0007\u0005\u0003\u0002f\u00055d\u0002BA4\u0003S\u00022!a\u0004?\u0013\r\tYGP\u0001\u0007!J,G-\u001a4\n\t\u0005=\u0014\u0011\u000f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005-d(\u0001\u0007ok2d7+\u00194f\u000bZ\fG\u000e\u0006\u0006\u0002x\u0005u\u0014\u0011QAB\u0003\u000b\u00032!PA=\u0013\r\tYH\u0010\u0002\u0004\u0003:L\bbBA@/\u0001\u0007\u0011qO\u0001\u0006S:\u0004X\u000f\u001e\u0005\u00075^\u0001\r!a\u001e\t\rq;\u0002\u0019AA<\u0011\u0019qv\u00031\u0001\u0002x\u0005IAm\\$f]\u000e{G-\u001a\u000b\u0007\u0003\u0017\u000b9*!)\u0011\t\u00055\u00151S\u0007\u0003\u0003\u001fS1!!%,\u0003\u001d\u0019w\u000eZ3hK:LA!!&\u0002\u0010\nAQ\t\u001f9s\u0007>$W\rC\u0004\u0002\u001ab\u0001\r!a'\u0002\u0007\r$\b\u0010\u0005\u0003\u0002\u000e\u0006u\u0015\u0002BAP\u0003\u001f\u0013abQ8eK\u001e,gnQ8oi\u0016DH\u000fC\u0004\u0002$b\u0001\r!a#\u0002\u0005\u00154\u0018!\u00024jeN$\u0018AB:fG>tG-A\u0003uQ&\u0014H-\u0001\u0004g_V\u0014H\u000f[\u0001\u0018o&$\bNT3x\u0007\"LG\u000e\u001a:f]&sG/\u001a:oC2$\u0012B]AY\u0003g\u000b),a.\t\u000f\u0005\u0015V\u00041\u0001\u0002 !9\u0011qU\u000fA\u0002\u0005}\u0001bBAU;\u0001\u0007\u0011q\u0004\u0005\b\u0003Wk\u0002\u0019AA\u0010\u0003\u0011\u0019w\u000e]=\u0015\u0013I\fi,a0\u0002B\u0006\r\u0007\u0002C+\u001f!\u0003\u0005\r!a\b\t\u0013\u0005\u001db\u0004%AA\u0002\u0005}\u0001\"CA\u0016=A\u0005\t\u0019AA\u0010\u0011!qf\u0004%AA\u0002\u0005}\u0011AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003\u0013TC!a\b\u0002L.\u0012\u0011Q\u001a\t\u0005\u0003\u001f\fI.\u0004\u0002\u0002R*!\u00111[Ak\u0003%)hn\u00195fG.,GMC\u0002\u0002Xz\n!\"\u00198o_R\fG/[8o\u0013\u0011\tY.!5\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%g\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\"\u0014!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002hB\u0019q*!;\n\u0007\u0005=\u0004+\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002pB\u0019Q(!=\n\u0007\u0005MhHA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002x\u0005e\b\"CA~K\u0005\u0005\t\u0019AAx\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011!\u0011\u0001\t\u0007\u0005\u0007\u0011I!a\u001e\u000e\u0005\t\u0015!b\u0001B\u0004}\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\t-!Q\u0001\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000eF\u0002d\u0005#A\u0011\"a?(\u0003\u0003\u0005\r!a\u001e\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0005\u0003O\u00149\u0002C\u0005\u0002|\"\n\t\u00111\u0001\u0002p\u00061Q-];bYN$2a\u0019B\u000f\u0011%\tY0KA\u0001\u0002\u0004\t9\bK\n\n\u0005C\u00119C!\u000b\u0003.\t=\"1\u0007B\u001b\u0005s\u0011Y\u0004E\u0002:\u0005GI1A!\n,\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#Aa\u000b\u0002\u0003\u0007T\u0001\u0005\t\u0011!?\u001a+fjQ0)m\u0006dW/\u001a\u0017![&twL^1mk\u0016d\u0003%\\1y?Z\fG.^3-A9,Xn\u00182vG.,G/\u000b\u0011.AI+G/\u001e:og\u0002\"\b.\u001a\u0011ck\u000e\\W\r\u001e\u0011ok6\u0014WM\u001d\u0011u_\u0002:\b.[2i\u0015\u0001\u0002\u0003\u0005\t\u0011!AZ\fG.^3aA]|W\u000f\u001c3!E\u0016\u0004\u0013m]:jO:,G\rI5oA\u0005t\u0007%Z9vS^LG\r\u001e5!Q&\u001cHo\\4sC6\u0004s/\u001b;iA\u0001tW/\\0ck\u000e\\W\r\u001e1!EV\u001c7.\u001a;tY)\u0001\u0003\u0005\t\u0011!A%t\u0007\u0005\u001e5fAI\fgnZ3!A6Lgn\u0018<bYV,\u0007\r\t;pA\u0001l\u0017\r_0wC2,X\r\u0019\u0018#\u0015\u0001\u0002\u0013\u0001C3yC6\u0004H.Z:\"\u0005\tE\u0012!!/\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`QUr3\u0007\f\u00111]Ib\u0003%\r\u0019/m1\u0002S'K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!g)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~CSF\r\u00182Y\u0001\ndf\r\u0017!g9\"D\u0006I\u001a*w)\u0001\u0003\u0005\t\u0011!A\u0001\u0002$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\f\u000b\u001d/c1\u0002\u0003G\f\u0019-AUrs\u0007\f\u00115SmR\u0001\u0005\t\u0011!A\u0001\u0002SG\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015.a9JD\u0006I\u001b/e1\u0002\u0003GL\u001b-AIJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005I\u001a\u000bA\u0001\nQa]5oG\u0016\f#Aa\u000e\u0002\u000bMr\u0013G\f\u0019\u0002\u000b\u001d\u0014x.\u001e9\"\u0005\tu\u0012AC7bi\"|f-\u001e8dg\"1QK\u0002a\u0001\u0003?Aq!a\n\u0007\u0001\u0004\ty\u0002C\u0004\u0002,\u0019\u0001\r!a\b\t\ry3\u0001\u0019AA\u0010\u0003\u001d)h.\u00199qYf$BAa\u0013\u0003XA)QH!\u0014\u0003R%\u0019!q\n \u0003\r=\u0003H/[8o!-i$1KA\u0010\u0003?\ty\"a\b\n\u0007\tUcH\u0001\u0004UkBdW\r\u000e\u0005\t\u00053:\u0011\u0011!a\u0001e\u0006\u0019\u0001\u0010\n\u0019\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\t}\u0003cA(\u0003b%\u0019!1\r)\u0003\r=\u0013'.Z2u\u0001")
public class WidthBucket
extends QuaternaryExpression
implements ImplicitCastInputTypes,
package.NullIntolerant,
Serializable {
    private final Expression value;
    private final Expression minValue;
    private final Expression maxValue;
    private final Expression numBucket;

    public static Option<Tuple4<Expression, Expression, Expression, Expression>> unapply(WidthBucket widthBucket) {
        return WidthBucket$.MODULE$.unapply(widthBucket);
    }

    public static Long computeBucketNumberNotNull(double d, double d2, double d3, long l) {
        return WidthBucket$.MODULE$.computeBucketNumberNotNull(d, d2, d3, l);
    }

    public static boolean isNull(double d, double d2, double d3, long l) {
        return WidthBucket$.MODULE$.isNull(d, d2, d3, l);
    }

    public static Long computeBucketNumber(double d, double d2, double d3, long l) {
        return WidthBucket$.MODULE$.computeBucketNumber(d, d2, d3, l);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression value() {
        return this.value;
    }

    public Expression minValue() {
        return this.minValue;
    }

    public Expression maxValue() {
        return this.maxValue;
    }

    public Expression numBucket() {
        return this.numBucket;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new NumericType[]{DoubleType$.MODULE$, DoubleType$.MODULE$, DoubleType$.MODULE$, LongType$.MODULE$}));
    }

    @Override
    public DataType dataType() {
        return LongType$.MODULE$;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public String prettyName() {
        return "width_bucket";
    }

    @Override
    public Object nullSafeEval(Object input, Object min, Object max, Object numBucket) {
        return WidthBucket$.MODULE$.computeBucketNumber(BoxesRunTime.unboxToDouble((Object)input), BoxesRunTime.unboxToDouble((Object)min), BoxesRunTime.unboxToDouble((Object)max), BoxesRunTime.unboxToLong((Object)numBucket));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function4<String, String, String, String, String>)(Function4 & Serializable)(input, min, max, numBucket) -> StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(236).append(ev.isNull()).append(" = org.apache.spark.sql.catalyst.expressions.WidthBucket\n         |  .isNull(").append((String)input).append(", ").append((String)min).append(", ").append((String)max).append(", ").append((String)numBucket).append(");\n         |if (!").append(ev.isNull()).append(") {\n         |  ").append(ev.value()).append(" = org.apache.spark.sql.catalyst.expressions.WidthBucket\n         |    .computeBucketNumberNotNull(").append((String)input).append(", ").append((String)min).append(", ").append((String)max).append(", ").append((String)numBucket).append(");\n         |}").toString())));
    }

    @Override
    public Expression first() {
        return this.value();
    }

    @Override
    public Expression second() {
        return this.minValue();
    }

    @Override
    public Expression third() {
        return this.maxValue();
    }

    @Override
    public Expression fourth() {
        return this.numBucket();
    }

    @Override
    public WidthBucket withNewChildrenInternal(Expression first, Expression second, Expression third, Expression fourth) {
        return this.copy(first, second, third, fourth);
    }

    public WidthBucket copy(Expression value, Expression minValue, Expression maxValue, Expression numBucket) {
        return new WidthBucket(value, minValue, maxValue, numBucket);
    }

    public Expression copy$default$1() {
        return this.value();
    }

    public Expression copy$default$2() {
        return this.minValue();
    }

    public Expression copy$default$3() {
        return this.maxValue();
    }

    public Expression copy$default$4() {
        return this.numBucket();
    }

    @Override
    public String productPrefix() {
        return "WidthBucket";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.value();
                break;
            }
            case 1: {
                object = this.minValue();
                break;
            }
            case 2: {
                object = this.maxValue();
                break;
            }
            case 3: {
                object = this.numBucket();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof WidthBucket;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "value";
                break;
            }
            case 1: {
                string = "minValue";
                break;
            }
            case 2: {
                string = "maxValue";
                break;
            }
            case 3: {
                string = "numBucket";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof WidthBucket)) return false;
        boolean bl = true;
        if (!bl) return false;
        WidthBucket widthBucket = (WidthBucket)x$1;
        Expression expression = this.value();
        Expression expression2 = widthBucket.value();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.minValue();
        Expression expression4 = widthBucket.minValue();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.maxValue();
        Expression expression6 = widthBucket.maxValue();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        Expression expression7 = this.numBucket();
        Expression expression8 = widthBucket.numBucket();
        if (expression7 == null) {
            if (expression8 != null) {
                return false;
            }
        } else if (!expression7.equals(expression8)) return false;
        if (!widthBucket.canEqual(this)) return false;
        return true;
    }

    public WidthBucket(Expression value, Expression minValue, Expression maxValue, Expression numBucket) {
        this.value = value;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.numBucket = numBucket;
        ExpectsInputTypes.$init$(this);
    }
}

