/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.xml;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.xml.XPathExtract;
import org.apache.spark.sql.catalyst.expressions.xml.XPathShort$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(xml, xpath) - Returns a short integer value, or the value zero if no match is found, or a match is found but the value is non-numeric.", examples="\n    Examples:\n      > SELECT _FUNC_('<a><b>1</b><b>2</b></a>', 'sum(a/b)');\n       3\n  ", since="2.0.0", group="xml_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005Mf\u0001B\u000e\u001d\u0001.B\u0001\"\b\u0001\u0003\u0016\u0004%\tA\u0011\u0005\t\u000f\u0002\u0011\t\u0012)A\u0005\u0007\"A\u0001\n\u0001BK\u0002\u0013\u0005!\t\u0003\u0005J\u0001\tE\t\u0015!\u0003D\u0011\u0015Q\u0005\u0001\"\u0001L\u0011\u0015y\u0005\u0001\"\u0011Q\u0011\u0015I\u0006\u0001\"\u0011[\u0011\u0015\t\u0007\u0001\"\u0011c\u0011\u0015A\u0007\u0001\"\u0015j\u0011\u001dq\u0007!!A\u0005\u0002=DqA\u001d\u0001\u0012\u0002\u0013\u00051\u000fC\u0004\u007f\u0001E\u0005I\u0011A:\t\u0011}\u0004\u0011\u0011!C!\u0003\u0003A\u0011\"!\u0005\u0001\u0003\u0003%\t!a\u0005\t\u0013\u0005m\u0001!!A\u0005\u0002\u0005u\u0001\"CA\u0012\u0001\u0005\u0005I\u0011IA\u0013\u0011%\t\u0019\u0004AA\u0001\n\u0003\t)\u0004C\u0005\u0002@\u0001\t\t\u0011\"\u0011\u0002B!I\u0011Q\t\u0001\u0002\u0002\u0013\u0005\u0013qI\u0004\n\u0003Wb\u0012\u0011!E\u0001\u0003[2\u0001b\u0007\u000f\u0002\u0002#\u0005\u0011q\u000e\u0005\u0007\u0015V!\t!a\"\t\u0013\u0005%U#!A\u0005F\u0005-\u0005\"CAG+\u0005\u0005I\u0011QAH\u0011%\t)*FA\u0001\n\u0003\u000b9\nC\u0005\u0002*V\t\t\u0011\"\u0003\u0002,\nQ\u0001\fU1uQNCwN\u001d;\u000b\u0005uq\u0012a\u0001=nY*\u0011q\u0004I\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002\"E\u0005A1-\u0019;bYf\u001cHO\u0003\u0002$I\u0005\u00191/\u001d7\u000b\u0005\u00152\u0013!B:qCJ\\'BA\u0014)\u0003\u0019\t\u0007/Y2iK*\t\u0011&A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001YA2\u0004CA\u0017/\u001b\u0005a\u0012BA\u0018\u001d\u00051A\u0006+\u0019;i\u000bb$(/Y2u!\t\tD'D\u00013\u0015\u0005\u0019\u0014!B:dC2\f\u0017BA\u001b3\u0005\u001d\u0001&o\u001c3vGR\u0004\"aN \u000f\u0005ajdBA\u001d=\u001b\u0005Q$BA\u001e+\u0003\u0019a$o\\8u}%\t1'\u0003\u0002?e\u00059\u0001/Y2lC\u001e,\u0017B\u0001!B\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\tq$'F\u0001D!\t!U)D\u0001\u001f\u0013\t1eD\u0001\u0006FqB\u0014Xm]:j_:\fA\u0001_7mA\u0005!\u0001/\u0019;i\u0003\u0015\u0001\u0018\r\u001e5!\u0003\u0019a\u0014N\\5u}Q\u0019A*\u0014(\u0011\u00055\u0002\u0001\"B\u000f\u0006\u0001\u0004\u0019\u0005\"\u0002%\u0006\u0001\u0004\u0019\u0015A\u00039sKR$\u0018PT1nKV\t\u0011\u000b\u0005\u0002S-:\u00111\u000b\u0016\t\u0003sIJ!!\u0016\u001a\u0002\rA\u0013X\rZ3g\u0013\t9\u0006L\u0001\u0004TiJLgn\u001a\u0006\u0003+J\n\u0001\u0002Z1uCRK\b/Z\u000b\u00027B\u0011AlX\u0007\u0002;*\u0011aLI\u0001\u0006if\u0004Xm]\u0005\u0003Av\u0013\u0001\u0002R1uCRK\b/Z\u0001\r]VdGnU1gK\u00163\u0018\r\u001c\u000b\u0004G\u001a<\u0007CA\u0019e\u0013\t)'GA\u0002B]fDQ!\b\u0005A\u0002\rDQ\u0001\u0013\u0005A\u0002\r\fqc^5uQ:+wo\u00115jY\u0012\u0014XM\\%oi\u0016\u0014h.\u00197\u0015\u00071SG\u000eC\u0003l\u0013\u0001\u00071)A\u0004oK^dUM\u001a;\t\u000b5L\u0001\u0019A\"\u0002\u00119,wOU5hQR\fAaY8qsR\u0019A\n]9\t\u000fuQ\u0001\u0013!a\u0001\u0007\"9\u0001J\u0003I\u0001\u0002\u0004\u0019\u0015AD2paf$C-\u001a4bk2$H%M\u000b\u0002i*\u00121)^\u0016\u0002mB\u0011q\u000f`\u0007\u0002q*\u0011\u0011P_\u0001\nk:\u001c\u0007.Z2lK\u0012T!a\u001f\u001a\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002~q\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!a\u0001\u0011\t\u0005\u0015\u0011qB\u0007\u0003\u0003\u000fQA!!\u0003\u0002\f\u0005!A.\u00198h\u0015\t\ti!\u0001\u0003kCZ\f\u0017bA,\u0002\b\u0005a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011Q\u0003\t\u0004c\u0005]\u0011bAA\re\t\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR\u00191-a\b\t\u0013\u0005\u0005r\"!AA\u0002\u0005U\u0011a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002(A)\u0011\u0011FA\u0018G6\u0011\u00111\u0006\u0006\u0004\u0003[\u0011\u0014AC2pY2,7\r^5p]&!\u0011\u0011GA\u0016\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005]\u0012Q\b\t\u0004c\u0005e\u0012bAA\u001ee\t9!i\\8mK\u0006t\u0007\u0002CA\u0011#\u0005\u0005\t\u0019A2\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0005\u0003\u0007\t\u0019\u0005C\u0005\u0002\"I\t\t\u00111\u0001\u0002\u0016\u00051Q-];bYN$B!a\u000e\u0002J!A\u0011\u0011E\n\u0002\u0002\u0003\u00071\rK\n\u0001\u0003\u001b\n\u0019&!\u0016\u0002Z\u0005m\u0013qLA1\u0003K\n9\u0007E\u0002E\u0003\u001fJ1!!\u0015\u001f\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#!a\u0016\u0002\u00037yf)\u0016(D?\"BX\u000e\u001c\u0017!qB\fG\u000f[\u0015![\u0001\u0012V\r^;s]N\u0004\u0013\rI:i_J$\b%\u001b8uK\u001e,'\u000f\t<bYV,G\u0006I8sAQDW\r\t<bYV,\u0007E_3s_\u0002Jg\r\t8pA5\fGo\u00195!SN\u0004cm\\;oI2\u0002sN\u001d\u0011bA5\fGo\u00195!SN\u0004cm\\;oI\u0002\u0012W\u000f\u001e\u0011uQ\u0016\u0004c/\u00197vK\u0002J7\u000f\t8p]6rW/\\3sS\u000et\u0013\u0001C3yC6\u0004H.Z:\"\u0005\u0005u\u0013\u0001\u0017\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)Oq\ng\b\u00102?cqz#M\u0010\u001fc}IbtF\u0019 =_\u0005tt\u0005\f\u0011(gVl\u0007&Y\u0018cS\u001dJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005I\u001a\u000bA\u0001\nQa]5oG\u0016\f#!a\u0019\u0002\u000bIr\u0003G\f\u0019\u0002\u000b\u001d\u0014x.\u001e9\"\u0005\u0005%\u0014!\u0003=nY~3WO\\2t\u0003)A\u0006+\u0019;i'\"|'\u000f\u001e\t\u0003[U\u0019R!FA9\u0003{\u0002r!a\u001d\u0002z\r\u001bE*\u0004\u0002\u0002v)\u0019\u0011q\u000f\u001a\u0002\u000fI,h\u000e^5nK&!\u00111PA;\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gN\r\t\u0005\u0003\u007f\n))\u0004\u0002\u0002\u0002*!\u00111QA\u0006\u0003\tIw.C\u0002A\u0003\u0003#\"!!\u001c\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!a\u0001\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000b1\u000b\t*a%\t\u000buA\u0002\u0019A\"\t\u000b!C\u0002\u0019A\"\u0002\u000fUt\u0017\r\u001d9msR!\u0011\u0011TAS!\u0015\t\u00141TAP\u0013\r\tiJ\r\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u000bE\n\tkQ\"\n\u0007\u0005\r&G\u0001\u0004UkBdWM\r\u0005\t\u0003OK\u0012\u0011!a\u0001\u0019\u0006\u0019\u0001\u0010\n\u0019\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\u00055\u0006\u0003BA\u0003\u0003_KA!!-\u0002\b\t1qJ\u00196fGR\u0004")
public class XPathShort
extends XPathExtract
implements Serializable {
    private final Expression xml;
    private final Expression path;

    public static Option<Tuple2<Expression, Expression>> unapply(XPathShort xPathShort) {
        return XPathShort$.MODULE$.unapply(xPathShort);
    }

    public static Function1<Tuple2<Expression, Expression>, XPathShort> tupled() {
        return XPathShort$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, XPathShort>> curried() {
        return XPathShort$.MODULE$.curried();
    }

    @Override
    public Expression xml() {
        return this.xml;
    }

    @Override
    public Expression path() {
        return this.path;
    }

    @Override
    public String prettyName() {
        return "xpath_short";
    }

    @Override
    public DataType dataType() {
        return ShortType$.MODULE$;
    }

    @Override
    public Object nullSafeEval(Object xml, Object path) {
        Double ret = this.xpathUtil().evalNumber(((UTF8String)xml).toString(), this.pathString());
        return ret == null ? null : BoxesRunTime.boxToShort((short)ret.shortValue());
    }

    @Override
    public XPathShort withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    public XPathShort copy(Expression xml, Expression path) {
        return new XPathShort(xml, path);
    }

    public Expression copy$default$1() {
        return this.xml();
    }

    public Expression copy$default$2() {
        return this.path();
    }

    @Override
    public String productPrefix() {
        return "XPathShort";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.xml();
                break;
            }
            case 1: {
                object = this.path();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof XPathShort;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "xml";
                break;
            }
            case 1: {
                string = "path";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof XPathShort)) return false;
        boolean bl = true;
        if (!bl) return false;
        XPathShort xPathShort = (XPathShort)x$1;
        Expression expression = this.xml();
        Expression expression2 = xPathShort.xml();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.path();
        Expression expression4 = xPathShort.path();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!xPathShort.canEqual(this)) return false;
        return true;
    }

    public XPathShort(Expression xml, Expression path) {
        this.xml = xml;
        this.path = path;
    }
}

