/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.parser;

import java.io.Serializable;
import java.nio.CharBuffer;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.misc.Interval;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.spark.sql.catalyst.parser.ParseException;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.trees.CurrentOrigin$;
import org.apache.spark.sql.catalyst.trees.Origin;
import org.apache.spark.sql.errors.QueryParsingErrors$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.LinearSeqOps;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.matching.Regex;

public final class ParserUtils$ {
    public static final ParserUtils$ MODULE$ = new ParserUtils$();
    private static final Regex U16_CHAR_PATTERN = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("\\\\u([a-fA-F0-9]{4})(?s).*"));
    private static final Regex U32_CHAR_PATTERN = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("\\\\U([a-fA-F0-9]{8})(?s).*"));
    private static final Regex OCTAL_CHAR_PATTERN = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("\\\\([01][0-7]{2})(?s).*"));
    private static final Regex ESCAPED_CHAR_PATTERN = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("\\\\((?s).)(?s).*"));
    private static final Regex escapedIdentifier = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("`((?s).+)`"));
    private static final Regex qualifiedEscapedIdentifier = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("((?s).+).`((?s).+)`"));

    public Regex U16_CHAR_PATTERN() {
        return U16_CHAR_PATTERN;
    }

    public Regex U32_CHAR_PATTERN() {
        return U32_CHAR_PATTERN;
    }

    public Regex OCTAL_CHAR_PATTERN() {
        return OCTAL_CHAR_PATTERN;
    }

    public Regex ESCAPED_CHAR_PATTERN() {
        return ESCAPED_CHAR_PATTERN;
    }

    public String command(ParserRuleContext ctx) {
        CharStream stream = ctx.getStart().getInputStream();
        return stream.getText(Interval.of((int)0, (int)(stream.size() - 1)));
    }

    public Nothing$ operationNotAllowed(String message, ParserRuleContext ctx) {
        throw QueryParsingErrors$.MODULE$.operationNotAllowedError(message, ctx);
    }

    public <T> void checkDuplicateClauses(java.util.List<T> nodes, String clauseName, ParserRuleContext ctx) {
        if (nodes.size() > 1) {
            throw QueryParsingErrors$.MODULE$.duplicateClausesError(clauseName, ctx);
        }
    }

    public <T> void checkDuplicateKeys(Seq<Tuple2<String, T>> keyPairs, ParserRuleContext ctx) {
        ((IterableOnceOps)keyPairs.groupBy((Function1 & Serializable)x$1 -> (String)x$1._1()).filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ParserUtils$.$anonfun$checkDuplicateKeys$2(x$2)))).foreach((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                throw QueryParsingErrors$.MODULE$.duplicateKeysError(key, ctx);
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public String source(ParserRuleContext ctx) {
        CharStream stream = ctx.getStart().getInputStream();
        return stream.getText(Interval.of((int)ctx.getStart().getStartIndex(), (int)ctx.getStop().getStopIndex()));
    }

    public String remainder(ParserRuleContext ctx) {
        return this.remainder(ctx.getStop());
    }

    public String remainder(Token token) {
        CharStream stream = token.getInputStream();
        Interval interval = Interval.of((int)(token.getStopIndex() + 1), (int)(stream.size() - 1));
        return stream.getText(interval);
    }

    public String interval(Token start, Token end) {
        Interval interval = Interval.of((int)(start.getStopIndex() + 1), (int)(end.getStartIndex() - 1));
        return start.getInputStream().getText(interval);
    }

    public String string(Token token) {
        return this.unescapeSQLString(token.getText());
    }

    public String string(TerminalNode node) {
        return this.unescapeSQLString(node.getText());
    }

    public String stringWithoutUnescape(TerminalNode node) {
        return StringOps$.MODULE$.slice$extension(Predef$.MODULE$.augmentString(node.getText()), 1, StringOps$.MODULE$.size$extension(Predef$.MODULE$.augmentString(node.getText())) - 1);
    }

    public Seq<Tuple2<String, String>> entry(String key, Token value) {
        return (Seq)Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)value)).toSeq().map((Function1 & Serializable)x -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)MODULE$.string((Token)x)));
    }

    public Origin position(Token token) {
        Option opt = Option$.MODULE$.apply((Object)token);
        return new Origin((Option<Object>)opt.map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.getLine())), (Option<Object>)opt.map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.getCharPositionInLine())));
    }

    public void validate(Function0<Object> f, String message, ParserRuleContext ctx) {
        if (!f.apply$mcZ$sp()) {
            throw new ParseException(message, ctx);
        }
    }

    public <T> T withOrigin(ParserRuleContext ctx, Function0<T> f) {
        Object object;
        Origin current = CurrentOrigin$.MODULE$.get();
        CurrentOrigin$.MODULE$.set(this.position(ctx.getStart()));
        try {
            object = f.apply();
        }
        finally {
            CurrentOrigin$.MODULE$.set(current);
        }
        return (T)object;
    }

    public String unescapeSQLString(String b) {
        StringBuilder sb = new StringBuilder(b.length());
        CharBuffer charBuffer = CharBuffer.wrap(b, 1, b.length() - 1);
        while (charBuffer.remaining() > 0) {
            Option option;
            Option option2;
            Option option3;
            Object object;
            Option option4;
            CharBuffer charBuffer2 = charBuffer;
            if (charBuffer2 != null && !(option4 = this.U16_CHAR_PATTERN().unapplySeq((CharSequence)charBuffer2)).isEmpty() && option4.get() != null && ((List)option4.get()).lengthCompare(1) == 0) {
                String cp = (String)((LinearSeqOps)option4.get()).apply(0);
                sb.append((char)Integer.parseInt(cp, 16));
                object = charBuffer.position(charBuffer.position() + 6);
                continue;
            }
            if (charBuffer2 != null && !(option3 = this.U32_CHAR_PATTERN().unapplySeq((CharSequence)charBuffer2)).isEmpty() && option3.get() != null && ((List)option3.get()).lengthCompare(1) == 0) {
                StringBuilder stringBuilder;
                String cp = (String)((LinearSeqOps)option3.get()).apply(0);
                long codePoint = Long.parseLong(cp, 16);
                if (codePoint < 65536L) {
                    stringBuilder = sb.append((char)(codePoint & 0xFFFFL));
                } else {
                    long highSurrogate = (codePoint - 65536L) / 1024L + 55296L;
                    long lowSurrogate = (codePoint - 65536L) % 1024L + 56320L;
                    sb.append((char)highSurrogate);
                    stringBuilder = sb.append((char)lowSurrogate);
                }
                object = charBuffer.position(charBuffer.position() + 10);
                continue;
            }
            if (charBuffer2 != null && !(option2 = this.OCTAL_CHAR_PATTERN().unapplySeq((CharSequence)charBuffer2)).isEmpty() && option2.get() != null && ((List)option2.get()).lengthCompare(1) == 0) {
                String cp = (String)((LinearSeqOps)option2.get()).apply(0);
                sb.append((char)Integer.parseInt(cp, 8));
                object = charBuffer.position(charBuffer.position() + 4);
                continue;
            }
            if (charBuffer2 != null && !(option = this.ESCAPED_CHAR_PATTERN().unapplySeq((CharSequence)charBuffer2)).isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(1) == 0) {
                String c = (String)((LinearSeqOps)option.get()).apply(0);
                ParserUtils$.appendEscapedChar$1(c.charAt(0), sb);
                object = charBuffer.position(charBuffer.position() + 2);
                continue;
            }
            object = sb.append(charBuffer.get());
        }
        return sb.toString();
    }

    public Regex escapedIdentifier() {
        return escapedIdentifier;
    }

    public Regex qualifiedEscapedIdentifier() {
        return qualifiedEscapedIdentifier;
    }

    public LogicalPlan EnhancedLogicalPlan(LogicalPlan plan2) {
        return plan2;
    }

    public static final /* synthetic */ boolean $anonfun$checkDuplicateKeys$2(Tuple2 x$2) {
        return ((SeqOps)x$2._2()).size() > 1;
    }

    private static final void appendEscapedChar$1(char n, StringBuilder sb$1) {
        char c = n;
        switch (c) {
            case '0': {
                sb$1.append('\u0000');
                break;
            }
            case '\'': {
                sb$1.append('\'');
                break;
            }
            case '\"': {
                sb$1.append('\"');
                break;
            }
            case 'b': {
                sb$1.append('\b');
                break;
            }
            case 'n': {
                sb$1.append('\n');
                break;
            }
            case 'r': {
                sb$1.append('\r');
                break;
            }
            case 't': {
                sb$1.append('\t');
                break;
            }
            case 'Z': {
                sb$1.append('\u001a');
                break;
            }
            case '\\': {
                sb$1.append('\\');
                break;
            }
            case '%': {
                sb$1.append("\\%");
                break;
            }
            case '_': {
                sb$1.append("\\_");
                break;
            }
            default: {
                sb$1.append(n);
                break;
            }
        }
    }

    private ParserUtils$() {
    }
}

