/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.analysis;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.spark.sql.catalyst.dsl.package$expressions$;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.Alias$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.CreateNamedStruct;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.IsNotNull;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.PreciseTimestampConversion;
import org.apache.spark.sql.catalyst.expressions.Predicate;
import org.apache.spark.sql.catalyst.expressions.SessionWindow;
import org.apache.spark.sql.catalyst.expressions.SessionWindow$;
import org.apache.spark.sql.catalyst.expressions.TimeWindow;
import org.apache.spark.sql.catalyst.plans.logical.Filter;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.rules.Rule;
import org.apache.spark.sql.catalyst.trees.TreePattern$;
import org.apache.spark.sql.catalyst.trees.TreePatternBits;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.Metadata$;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.TimestampType$;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

public final class SessionWindowing$
extends Rule<LogicalPlan> {
    public static final SessionWindowing$ MODULE$ = new SessionWindowing$();

    private final String SESSION_COL_NAME() {
        return "session_window";
    }

    private final String SESSION_START() {
        return "start";
    }

    private final String SESSION_END() {
        return "end";
    }

    @Override
    public LogicalPlan apply(LogicalPlan plan2) {
        return plan2.resolveOperatorsUpWithPruning((Function1<TreePatternBits, Object>)(Function1 & Serializable)x$182 -> BoxesRunTime.boxToBoolean((boolean)x$182.containsPattern(TreePattern$.MODULE$.SESSION_WINDOW())), this.ruleId(), (PartialFunction<LogicalPlan, LogicalPlan>)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1;
                A1 A12 = x1;
                if (A12 != null && (A1 = A12).children().size() == 1) {
                    Object object2;
                    LogicalPlan child = (LogicalPlan)A1.children().head();
                    Set sessionExpressions = ((IterableOnceOps)A1.expressions().flatMap((Function1 & Serializable)x$183 -> x$183.collect(new Serializable(null){
                        private static final long serialVersionUID = 0L;

                        public final <A1 extends Expression, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                            Object object;
                            A1 A1 = x1;
                            if (A1 instanceof SessionWindow) {
                                SessionWindow sessionWindow = (SessionWindow)A1;
                                object = sessionWindow;
                            } else {
                                object = function1.apply(x1);
                            }
                            return (B1)object;
                        }

                        public final boolean isDefinedAt(Expression x1) {
                            Expression expression = x1;
                            boolean bl = expression instanceof SessionWindow;
                            return bl;
                        }
                    }))).toSet();
                    int numWindowExpr = ((IterableOnceOps)A1.expressions().flatMap((Function1 & Serializable)x$184 -> x$184.collect(new Serializable(null){
                        private static final long serialVersionUID = 0L;

                        public final <A1 extends Expression, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                            Object object;
                            A1 A1 = x2;
                            if (A1 instanceof SessionWindow) {
                                SessionWindow sessionWindow = (SessionWindow)A1;
                                object = sessionWindow;
                            } else if (A1 instanceof TimeWindow) {
                                TimeWindow timeWindow = (TimeWindow)A1;
                                object = timeWindow;
                            } else {
                                object = function1.apply(x2);
                            }
                            return (B1)object;
                        }

                        public final boolean isDefinedAt(Expression x2) {
                            Expression expression = x2;
                            boolean bl = expression instanceof SessionWindow ? true : expression instanceof TimeWindow;
                            return bl;
                        }
                    }))).toSet().size();
                    if (numWindowExpr == 1 && sessionExpressions.nonEmpty() && ((SessionWindow)sessionExpressions.head()).timeColumn().resolved() && ((ExpectsInputTypes)sessionExpressions.head()).checkInputDataTypes().isSuccess()) {
                        CreateNamedStruct literalSessionStruct;
                        Metadata metadata;
                        SessionWindow session = (SessionWindow)sessionExpressions.head();
                        Expression expression = session.timeColumn();
                        if (expression instanceof Attribute) {
                            Attribute attribute = (Attribute)expression;
                            metadata = attribute.metadata();
                        } else {
                            metadata = Metadata$.MODULE$.empty();
                        }
                        Metadata metadata2 = metadata;
                        Metadata newMetadata = new MetadataBuilder().withMetadata(metadata2).putBoolean(SessionWindow$.MODULE$.marker(), true).build();
                        String x$1 = "session_window";
                        DataType x$2 = session.dataType();
                        Metadata x$3 = newMetadata;
                        boolean x$4 = AttributeReference$.MODULE$.apply$default$3();
                        ExprId x$5 = AttributeReference$.MODULE$.apply$default$5("session_window", x$2, x$4, x$3);
                        Seq<String> x$6 = AttributeReference$.MODULE$.apply$default$6("session_window", x$2, x$4, x$3);
                        AttributeReference sessionAttr = new AttributeReference("session_window", x$2, x$4, x$3, x$5, x$6);
                        PreciseTimestampConversion sessionStart = new PreciseTimestampConversion(session.timeColumn(), TimestampType$.MODULE$, LongType$.MODULE$);
                        Expression expression2 = session.gapDuration();
                        if (!Cast$.MODULE$.canCast(expression2.dataType(), CalendarIntervalType$.MODULE$)) {
                            throw QueryCompilationErrors$.MODULE$.sessionWindowGapDurationDataTypeError(expression2.dataType());
                        }
                        Cast cast = new Cast(expression2, CalendarIntervalType$.MODULE$, Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4());
                        Cast gapDuration = cast;
                        PreciseTimestampConversion sessionEnd = new PreciseTimestampConversion(package$expressions$.MODULE$.DslExpression(session.timeColumn()).$plus(gapDuration), TimestampType$.MODULE$, LongType$.MODULE$);
                        Literal literal = Literal$.MODULE$.apply("start");
                        PreciseTimestampConversion preciseTimestampConversion = new PreciseTimestampConversion(sessionStart, LongType$.MODULE$, TimestampType$.MODULE$);
                        Literal literal2 = Literal$.MODULE$.apply("end");
                        PreciseTimestampConversion preciseTimestampConversion2 = new PreciseTimestampConversion(sessionEnd, LongType$.MODULE$, TimestampType$.MODULE$);
                        CreateNamedStruct x$7 = literalSessionStruct = new CreateNamedStruct((Seq<Expression>)package$.MODULE$.Nil().$colon$colon((Object)preciseTimestampConversion2).$colon$colon((Object)literal2).$colon$colon((Object)preciseTimestampConversion).$colon$colon((Object)literal));
                        String x$8 = "session_window";
                        ExprId x$9 = sessionAttr.exprId();
                        Some x$10 = new Some((Object)newMetadata);
                        Seq<String> x$11 = Alias$.MODULE$.apply$default$4(x$7, "session_window");
                        Seq<String> x$12 = Alias$.MODULE$.apply$default$6(x$7, "session_window");
                        Alias sessionStruct = new Alias(x$7, "session_window", x$9, x$11, (Option<Metadata>)x$10, x$12);
                        LogicalPlan replacedPlan = (LogicalPlan)A1.transformExpressions((PartialFunction<Expression, Expression>)new Serializable(null, sessionAttr){
                            private static final long serialVersionUID = 0L;
                            private final AttributeReference sessionAttr$1;

                            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                                A1 A1 = x3;
                                Object object = A1 instanceof SessionWindow ? this.sessionAttr$1 : function1.apply(x3);
                                return (B1)object;
                            }

                            public final boolean isDefinedAt(Expression x3) {
                                Expression expression = x3;
                                boolean bl = expression instanceof SessionWindow;
                                return bl;
                            }
                            {
                                this.sessionAttr$1 = sessionAttr$1;
                            }
                        });
                        Predicate filterExpr = package$expressions$.MODULE$.DslExpression(new IsNotNull(session.timeColumn())).$amp$amp((Expression)((Object)package$expressions$.MODULE$.DslExpression(package$expressions$.MODULE$.DslExpression(sessionAttr).getField("end")).$greater(package$expressions$.MODULE$.DslExpression(sessionAttr).getField("start"))));
                        Alias alias = sessionStruct;
                        Filter filter = new Filter((Expression)((Object)filterExpr), new Project((Seq<NamedExpression>)((Seq)child.output().$plus$colon((Object)alias)), child));
                        object2 = replacedPlan.withNewChildren(package$.MODULE$.Nil().$colon$colon((Object)filter));
                    } else {
                        if (numWindowExpr > 1) {
                            throw QueryCompilationErrors$.MODULE$.multiTimeWindowExpressionsNotSupportedError(A1);
                        }
                        object2 = A1;
                    }
                    object = object2;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                LogicalPlan logicalPlan;
                LogicalPlan logicalPlan2 = x1;
                boolean bl = logicalPlan2 != null && (logicalPlan = logicalPlan2).children().size() == 1;
                return bl;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$218(org.apache.spark.sql.catalyst.expressions.Expression ), $anonfun$applyOrElse$219(org.apache.spark.sql.catalyst.expressions.Expression )}, serializedLambda);
            }
        });
    }

    private SessionWindowing$() {
    }
}

