/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.csv;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Locale;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.catalyst.analysis.TypeCoercion$;
import org.apache.spark.sql.catalyst.csv.CSVOptions;
import org.apache.spark.sql.catalyst.expressions.ExprUtils$;
import org.apache.spark.sql.catalyst.util.LegacyDateFormats$;
import org.apache.spark.sql.catalyst.util.TimestampFormatter;
import org.apache.spark.sql.catalyst.util.TimestampFormatter$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.IntegralType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.NullType;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.StringOps$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.control.Exception$;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005e\u0001\u0002\r\u001a\u0001\u0019B\u0001\"\u000f\u0001\u0003\u0006\u0004%\tA\u000f\u0005\t\u007f\u0001\u0011\t\u0011)A\u0005w!)\u0001\t\u0001C\u0001\u0003\"9A\t\u0001b\u0001\n\u0013)\u0005B\u0002'\u0001A\u0003%a\tC\u0004N\u0001\t\u0007I\u0011\u0002(\t\r\t\u0004\u0001\u0015!\u0003P\u0011\u0015\u0019\u0007\u0001\"\u0001e\u0011\u0015A\b\u0001\"\u0001z\u0011\u001d\tY\u0001\u0001C\u0001\u0003\u001bAq!a\u0006\u0001\t\u0003\tI\u0002C\u0004\u0002$\u0001!\t!!\n\t\u000f\u0005=\u0002\u0001\"\u0003\u00022!9\u00111\b\u0001\u0005\n\u0005u\u0002bBA!\u0001\u0011%\u00111\t\u0005\b\u0003\u000f\u0002A\u0011BA%\u0011\u001d\ti\u0005\u0001C\u0005\u0003\u001fBq!a\u0015\u0001\t\u0013\t)\u0006C\u0004\u0002Z\u0001!I!a\u0017\t\u000f\u0005}\u0003\u0001\"\u0003\u0002b!9\u00111\r\u0001\u0005\n\u0005\u0015\u0004\"CA;\u0001\t\u0007I\u0011BA<\u0011!\ty\b\u0001Q\u0001\n\u0005e$AD\"T-&sg-\u001a:TG\",W.\u0019\u0006\u00035m\t1aY:w\u0015\taR$\u0001\u0005dCR\fG._:u\u0015\tqr$A\u0002tc2T!\u0001I\u0011\u0002\u000bM\u0004\u0018M]6\u000b\u0005\t\u001a\u0013AB1qC\u000eDWMC\u0001%\u0003\ry'oZ\u0002\u0001'\r\u0001q%\f\t\u0003Q-j\u0011!\u000b\u0006\u0002U\u0005)1oY1mC&\u0011A&\u000b\u0002\u0007\u0003:L(+\u001a4\u0011\u000592dBA\u00185\u001d\t\u00014'D\u00012\u0015\t\u0011T%\u0001\u0004=e>|GOP\u0005\u0002U%\u0011Q'K\u0001\ba\u0006\u001c7.Y4f\u0013\t9\u0004H\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u00026S\u00059q\u000e\u001d;j_:\u001cX#A\u001e\u0011\u0005qjT\"A\r\n\u0005yJ\"AC\"T->\u0003H/[8og\u0006Aq\u000e\u001d;j_:\u001c\b%\u0001\u0004=S:LGO\u0010\u000b\u0003\u0005\u000e\u0003\"\u0001\u0010\u0001\t\u000be\u001a\u0001\u0019A\u001e\u0002\u001fQLW.Z:uC6\u0004\b+\u0019:tKJ,\u0012A\u0012\t\u0003\u000f*k\u0011\u0001\u0013\u0006\u0003\u0013n\tA!\u001e;jY&\u00111\n\u0013\u0002\u0013)&lWm\u001d;b[B4uN]7biR,'/\u0001\tuS6,7\u000f^1naB\u000b'o]3sA\u0005iA-Z2j[\u0006d\u0007+\u0019:tKJ,\u0012a\u0014\t\u0005QA\u0013&,\u0003\u0002RS\tIa)\u001e8di&|g.\r\t\u0003'^s!\u0001V+\u0011\u0005AJ\u0013B\u0001,*\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001,\u0017\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005YK\u0003CA.a\u001b\u0005a&BA/_\u0003\u0011i\u0017\r\u001e5\u000b\u0003}\u000bAA[1wC&\u0011\u0011\r\u0018\u0002\u000b\u0005&<G)Z2j[\u0006d\u0017A\u00043fG&l\u0017\r\u001c)beN,'\u000fI\u0001\u0006S:4WM\u001d\u000b\u0004K.4\bC\u00014j\u001b\u00059'B\u00015\u001e\u0003\u0015!\u0018\u0010]3t\u0013\tQwM\u0001\u0006TiJ,8\r\u001e+za\u0016DQ\u0001\u001c\u0005A\u00025\f\u0001\u0002^8lK:\u0014F\t\u0012\t\u0004]F\u001cX\"A8\u000b\u0005A|\u0012a\u0001:eI&\u0011!o\u001c\u0002\u0004%\u0012#\u0005c\u0001\u0015u%&\u0011Q/\u000b\u0002\u0006\u0003J\u0014\u0018-\u001f\u0005\u0006o\"\u0001\ra]\u0001\u0007Q\u0016\fG-\u001a:\u0002\u001dQ|7\u000b\u001e:vGR4\u0015.\u001a7egR!!P`A\u0005!\rACo\u001f\t\u0003MrL!!`4\u0003\u0017M#(/^2u\r&,G\u000e\u001a\u0005\u0007\u007f&\u0001\r!!\u0001\u0002\u0015\u0019LW\r\u001c3UsB,7\u000f\u0005\u0003)i\u0006\r\u0001c\u00014\u0002\u0006%\u0019\u0011qA4\u0003\u0011\u0011\u000bG/\u0019+za\u0016DQa^\u0005A\u0002M\fA\"\u001b8gKJ\u0014vn\u001e+za\u0016$b!!\u0001\u0002\u0010\u0005M\u0001bBA\t\u0015\u0001\u0007\u0011\u0011A\u0001\te><8k\u001c$be\"1\u0011Q\u0003\u0006A\u0002M\fAA\\3yi\u0006iQ.\u001a:hKJ{w\u000fV=qKN$b!!\u0001\u0002\u001c\u0005}\u0001bBA\u000f\u0017\u0001\u0007\u0011\u0011A\u0001\u0006M&\u00148\u000f\u001e\u0005\b\u0003CY\u0001\u0019AA\u0001\u0003\u0019\u0019XmY8oI\u0006Q\u0011N\u001c4fe\u001aKW\r\u001c3\u0015\r\u0005\r\u0011qEA\u0016\u0011\u001d\tI\u0003\u0004a\u0001\u0003\u0007\t\u0011\u0002^=qKN{g)\u0019:\t\r\u00055B\u00021\u0001S\u0003\u00151\u0017.\u001a7e\u0003)I7/\u00138g\u001fJt\u0015M\u001c\u000b\u0005\u0003g\tI\u0004E\u0002)\u0003kI1!a\u000e*\u0005\u001d\u0011un\u001c7fC:Da!!\f\u000e\u0001\u0004\u0011\u0016a\u0004;ssB\u000b'o]3J]R,w-\u001a:\u0015\t\u0005\r\u0011q\b\u0005\u0007\u0003[q\u0001\u0019\u0001*\u0002\u0019Q\u0014\u0018\u0010U1sg\u0016duN\\4\u0015\t\u0005\r\u0011Q\t\u0005\u0007\u0003[y\u0001\u0019\u0001*\u0002\u001fQ\u0014\u0018\u0010U1sg\u0016$UmY5nC2$B!a\u0001\u0002L!1\u0011Q\u0006\tA\u0002I\u000ba\u0002\u001e:z!\u0006\u00148/\u001a#pk\ndW\r\u0006\u0003\u0002\u0004\u0005E\u0003BBA\u0017#\u0001\u0007!+A\tuef\u0004\u0016M]:f)&lWm\u001d;b[B$B!a\u0001\u0002X!1\u0011Q\u0006\nA\u0002I\u000bq\u0002\u001e:z!\u0006\u00148/\u001a\"p_2,\u0017M\u001c\u000b\u0005\u0003\u0007\ti\u0006\u0003\u0004\u0002.M\u0001\rAU\u0001\u000bgR\u0014\u0018N\\4UsB,GCAA\u0002\u00039\u0019w.\u001c9bi&\u0014G.\u001a+za\u0016$b!a\u001a\u0002n\u0005E\u0004#\u0002\u0015\u0002j\u0005\r\u0011bAA6S\t1q\n\u001d;j_:Dq!a\u001c\u0016\u0001\u0004\t\u0019!\u0001\u0002uc!9\u00111O\u000bA\u0002\u0005\r\u0011A\u0001;3\u0003a1\u0017N\u001c3D_6\u0004\u0018\r^5cY\u0016$\u0016\u0010]3G_J\u001c5KV\u000b\u0003\u0003s\u0002\u0012\u0002KA>\u0003\u0007\t\u0019!a\u001a\n\u0007\u0005u\u0014FA\u0005Gk:\u001cG/[8oe\u0005Ib-\u001b8e\u0007>l\u0007/\u0019;jE2,G+\u001f9f\r>\u00148i\u0015,!\u0001")
public class CSVInferSchema
implements Serializable {
    private final CSVOptions options;
    private final TimestampFormatter timestampParser;
    private final Function1<String, BigDecimal> decimalParser;
    private final Function2<DataType, DataType, Option<DataType>> findCompatibleTypeForCSV;

    public CSVOptions options() {
        return this.options;
    }

    private TimestampFormatter timestampParser() {
        return this.timestampParser;
    }

    private Function1<String, BigDecimal> decimalParser() {
        return this.decimalParser;
    }

    public StructType infer(RDD<String[]> tokenRDD, String[] header) {
        StructField[] structFieldArray;
        if (this.options().inferSchemaFlag()) {
            DataType[] startType = (DataType[])Array$.MODULE$.fill(header.length, (Function0 & Serializable)() -> NullType$.MODULE$, ClassTag$.MODULE$.apply(DataType.class));
            DataType[] rootTypes = (DataType[])tokenRDD.aggregate((Object)startType, (Function2 & Serializable)(rowSoFar, next) -> this.inferRowType((DataType[])rowSoFar, (String[])next), (Function2 & Serializable)(first, second) -> this.mergeRowTypes((DataType[])first, (DataType[])second), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(DataType.class)));
            structFieldArray = this.toStructFields(rootTypes, header);
        } else {
            structFieldArray = (StructField[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])header), (Function1 & Serializable)fieldName -> new StructField((String)fieldName, StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), ClassTag$.MODULE$.apply(StructField.class));
        }
        StructField[] fields = structFieldArray;
        return new StructType(fields);
    }

    public StructField[] toStructFields(DataType[] fieldTypes, String[] header) {
        return (StructField[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zip$extension(Predef$.MODULE$.refArrayOps((Object[])header), (IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])fieldTypes))), (Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String thisHeader = (String)tuple2._1();
            DataType rootType = (DataType)tuple2._2();
            DataType dataType = rootType;
            DataType dataType2 = dataType instanceof NullType ? StringType$.MODULE$ : dataType;
            DataType dType = dataType2;
            StructField structField = new StructField(thisHeader, dType, true, StructField$.MODULE$.apply$default$4());
            return structField;
        }, ClassTag$.MODULE$.apply(StructField.class));
    }

    public DataType[] inferRowType(DataType[] rowSoFar, String[] next) {
        for (int i = 0; i < package$.MODULE$.min(rowSoFar.length, next.length); ++i) {
            rowSoFar[i] = this.inferField(rowSoFar[i], next[i]);
        }
        return rowSoFar;
    }

    public DataType[] mergeRowTypes(DataType[] first, DataType[] second) {
        return (DataType[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipAll$extension(Predef$.MODULE$.refArrayOps((Object[])first), (Iterable)Predef$.MODULE$.wrapRefArray((Object[])second), (Object)NullType$.MODULE$, (Object)NullType$.MODULE$)), (Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            DataType a = (DataType)tuple2._1();
            DataType b = (DataType)tuple2._2();
            DataType dataType = (DataType)this.compatibleType(a, b).getOrElse((Function0 & Serializable)() -> NullType$.MODULE$);
            return dataType;
        }, ClassTag$.MODULE$.apply(DataType.class));
    }

    /*
     * Enabled aggressive block sorting
     */
    public DataType inferField(DataType typeSoFar, String field) {
        DataType dataType;
        DataType dataType2;
        block19: {
            block18: {
                if (field == null || field.isEmpty()) break block18;
                String string = field;
                String string2 = this.options().nullValue();
                if (string != null ? !string.equals(string2) : string2 != null) break block19;
            }
            dataType2 = typeSoFar;
            return dataType2;
        }
        DataType dataType3 = typeSoFar;
        if (NullType$.MODULE$.equals(dataType3)) {
            dataType = this.tryParseInteger(field);
        } else if (IntegerType$.MODULE$.equals(dataType3)) {
            dataType = this.tryParseInteger(field);
        } else if (LongType$.MODULE$.equals(dataType3)) {
            dataType = this.tryParseLong(field);
        } else if (dataType3 instanceof DecimalType) {
            dataType = this.tryParseDecimal(field);
        } else if (DoubleType$.MODULE$.equals(dataType3)) {
            dataType = this.tryParseDouble(field);
        } else if (TimestampType$.MODULE$.equals(dataType3)) {
            dataType = this.tryParseTimestamp(field);
        } else if (BooleanType$.MODULE$.equals(dataType3)) {
            dataType = this.tryParseBoolean(field);
        } else {
            if (!StringType$.MODULE$.equals(dataType3)) {
                if (dataType3 == null) throw new MatchError((Object)dataType3);
                DataType dataType4 = dataType3;
                throw QueryExecutionErrors$.MODULE$.dataTypeUnexpectedError(dataType4);
            }
            dataType = StringType$.MODULE$;
        }
        DataType typeElemInfer = dataType;
        dataType2 = (DataType)this.compatibleType(typeSoFar, typeElemInfer).getOrElse((Function0 & Serializable)() -> StringType$.MODULE$);
        return dataType2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isInfOrNan(String field) {
        String string = field;
        String string2 = this.options().nanValue();
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = field;
        String string4 = this.options().negativeInf();
        if (string3 == null) {
            if (string4 == null) return true;
        } else if (string3.equals(string4)) return true;
        String string5 = field;
        String string6 = this.options().positiveInf();
        if (string5 != null) {
            if (!string5.equals(string6)) return false;
            return true;
        }
        if (string6 == null) return true;
        return false;
    }

    private DataType tryParseInteger(String field) {
        return Exception$.MODULE$.allCatch().opt((Function0)(JFunction0.mcI.sp & Serializable)() -> StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(field))).isDefined() ? IntegerType$.MODULE$ : this.tryParseLong(field);
    }

    private DataType tryParseLong(String field) {
        return Exception$.MODULE$.allCatch().opt((Function0)(JFunction0.mcJ.sp & Serializable)() -> StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(field))).isDefined() ? LongType$.MODULE$ : this.tryParseDecimal(field);
    }

    private DataType tryParseDecimal(String field) {
        Option decimalTry = Exception$.MODULE$.allCatch().opt((Function0 & Serializable)() -> {
            BigDecimal bigDecimal = (BigDecimal)this.decimalParser().apply((Object)field);
            return bigDecimal.scale() <= 0 ? new DecimalType(bigDecimal.precision(), bigDecimal.scale()) : this.tryParseDouble(field);
        });
        return (DataType)decimalTry.getOrElse((Function0 & Serializable)() -> this.tryParseDouble(field));
    }

    private DataType tryParseDouble(String field) {
        return Exception$.MODULE$.allCatch().opt((Function0)(JFunction0.mcD.sp & Serializable)() -> StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(field))).isDefined() || this.isInfOrNan(field) ? DoubleType$.MODULE$ : this.tryParseTimestamp(field);
    }

    private DataType tryParseTimestamp(String field) {
        return Exception$.MODULE$.allCatch().opt((Function0)(JFunction0.mcJ.sp & Serializable)() -> this.timestampParser().parse(field)).isDefined() ? TimestampType$.MODULE$ : this.tryParseBoolean(field);
    }

    private DataType tryParseBoolean(String field) {
        return Exception$.MODULE$.allCatch().opt((Function0)(JFunction0.mcZ.sp & Serializable)() -> StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(field))).isDefined() ? BooleanType$.MODULE$ : this.stringType();
    }

    private DataType stringType() {
        return StringType$.MODULE$;
    }

    private Option<DataType> compatibleType(DataType t1, DataType t2) {
        return ((Option)TypeCoercion$.MODULE$.findTightestCommonType().apply((Object)t1, (Object)t2)).orElse((Function0 & Serializable)() -> (Option)this.findCompatibleTypeForCSV().apply((Object)t1, (Object)t2));
    }

    private Function2<DataType, DataType, Option<DataType>> findCompatibleTypeForCSV() {
        return this.findCompatibleTypeForCSV;
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ Option $anonfun$findCompatibleTypeForCSV$1(CSVInferSchema $this, DataType x0$1, DataType x1$1) {
        block5: {
            block11: {
                block10: {
                    block9: {
                        block8: {
                            block7: {
                                block6: {
                                    block4: {
                                        var5_3 = new Tuple2((Object)x0$1, (Object)x1$1);
                                        if (var5_3 == null || !StringType$.MODULE$.equals(var6_4 = (DataType)var5_3._1())) break block4;
                                        var3_5 = new Some((Object)StringType$.MODULE$);
                                        break block5;
                                    }
                                    if (var5_3 == null || !StringType$.MODULE$.equals(var7_6 = (DataType)var5_3._2())) break block6;
                                    var3_5 = new Some((Object)StringType$.MODULE$);
                                    break block5;
                                }
                                if (var5_3 == null) break block7;
                                t1 = (DataType)var5_3._1();
                                t2 = (DataType)var5_3._2();
                                if (!(t1 instanceof IntegralType)) break block7;
                                var10_9 = (IntegralType)t1;
                                if (!(t2 instanceof DecimalType)) break block7;
                                var11_10 = (DecimalType)t2;
                                var3_5 = $this.compatibleType(DecimalType$.MODULE$.forType(var10_9), var11_10);
                                break block5;
                            }
                            if (var5_3 == null) break block8;
                            t1 = (DataType)var5_3._1();
                            t2 = (DataType)var5_3._2();
                            if (!(t1 instanceof DecimalType)) break block8;
                            var14_13 = (DecimalType)t1;
                            if (!(t2 instanceof IntegralType)) break block8;
                            var15_14 = (IntegralType)t2;
                            var3_5 = $this.compatibleType(var14_13, DecimalType$.MODULE$.forType(var15_14));
                            break block5;
                        }
                        if (var5_3 == null || !DoubleType$.MODULE$.equals(var16_15 = (DataType)var5_3._1()) || !(var5_3._2() instanceof DecimalType)) break block9;
                        var4_16 = true;
                        break block10;
                    }
                    if (var5_3 == null) ** GOTO lbl-1000
                    var17_17 = (DataType)var5_3._2();
                    if (var5_3._1() instanceof DecimalType && DoubleType$.MODULE$.equals(var17_17)) {
                        var4_16 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        var4_16 = false;
                    }
                }
                if (!var4_16) break block11;
                var3_5 = new Some((Object)DoubleType$.MODULE$);
                break block5;
            }
            if (var5_3 == null) ** GOTO lbl-1000
            t1 = (DataType)var5_3._1();
            t2 = (DataType)var5_3._2();
            if (!(t1 instanceof DecimalType)) ** GOTO lbl-1000
            var20_20 = (DecimalType)t1;
            if (t2 instanceof DecimalType) {
                var21_21 = (DecimalType)t2;
                scale = package$.MODULE$.max(var20_20.scale(), var21_21.scale());
                range = package$.MODULE$.max(var20_20.precision() - var20_20.scale(), var21_21.precision() - var21_21.scale());
                var3_5 = range + scale > 38 ? new Some((Object)DoubleType$.MODULE$) : new Some((Object)new DecimalType(range + scale, scale));
            } else lbl-1000:
            // 3 sources

            {
                var3_5 = None$.MODULE$;
            }
        }
        return var3_5;
    }

    public CSVInferSchema(CSVOptions options) {
        this.options = options;
        this.timestampParser = TimestampFormatter$.MODULE$.apply(options.timestampFormat(), options.zoneId(), options.locale(), LegacyDateFormats$.MODULE$.FAST_DATE_FORMAT(), true);
        Locale locale = options.locale();
        Locale locale2 = Locale.US;
        this.decimalParser = !(locale != null ? !((Object)locale).equals(locale2) : locale2 != null) ? s -> new BigDecimal((String)s) : ExprUtils$.MODULE$.getDecimalParser(options.locale());
        this.findCompatibleTypeForCSV = (arg_0, arg_1) -> CSVInferSchema.$anonfun$findCompatibleTypeForCSV$1(this, arg_0, arg_1);
    }
}

