/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.ArrayBasedSimpleHigherOrderFunction;
import org.apache.spark.sql.catalyst.expressions.ArraySort$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.HigherOrderFunction;
import org.apache.spark.sql.catalyst.expressions.LambdaFunction;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.NamedLambdaVariable;
import org.apache.spark.sql.catalyst.expressions.RowOrdering$;
import org.apache.spark.sql.catalyst.expressions.SimpleHigherOrderFunction;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.trees.BinaryLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.NullType$;
import scala.Enumeration;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(expr, func) - Sorts the input array. If func is omitted, sort\n    in ascending order. The elements of the input array must be orderable.\n    NaN is greater than any non-NaN elements for double/float type.\n    Null elements will be placed at the end of the returned array.\n    Since 3.0.0 this function also sorts and returns the array based on the\n    given comparator function. The comparator will take two arguments representing\n    two elements of the array.\n    It returns a negative integer, 0, or a positive integer as the first element is less than,\n    equal to, or greater than the second element. If the comparator function returns null,\n    the function will fail and raise an error.\n    ", examples="\n    Examples:\n      > SELECT _FUNC_(array(5, 6, 1), (left, right) -> case when left < right then -1 when left > right then 1 else 0 end);\n       [1,5,6]\n      > SELECT _FUNC_(array('bc', 'ab', 'dc'), (left, right) -> case when left is null and right is null then 0 when left is null then -1 when right is null then 1 when left < right then 1 when left > right then -1 else 0 end);\n       [\"dc\",\"bc\",\"ab\"]\n      > SELECT _FUNC_(array('b', 'd', null, 'c', 'a'));\n       [\"a\",\"b\",\"c\",\"d\",null]\n  ", since="2.4.0", group="lambda_funcs")
@ScalaSignature(bytes="\u0006\u0005\t]d\u0001\u0002\u0016,\u0001bB\u0001\u0002\u0017\u0001\u0003\u0016\u0004%\t!\u0017\u0005\t5\u0002\u0011\t\u0012)A\u0005s!A1\f\u0001BK\u0002\u0013\u0005\u0011\f\u0003\u0005]\u0001\tE\t\u0015!\u0003:\u0011!i\u0006A!f\u0001\n\u0003q\u0006\u0002\u00032\u0001\u0005#\u0005\u000b\u0011B0\t\u000b\r\u0004A\u0011\u00013\t\u000b\r\u0004A\u0011A5\t\u000b\r\u0004A\u0011\u00017\t\u00119\u0004\u0001R1A\u0005\u0002=DQA\u001f\u0001\u0005BmDaa \u0001\u0005B\u0005\u0005\u0001bBA\b\u0001\u0011\u0005\u0013\u0011\u0003\u0005\r\u0003_\u0001\u0001\u0013!EDB\u0013%\u0011\u0011\u0007\u0005\u000b\u0003w\u0001\u0001R1A\u0005\u0002\u0005u\u0002BCA!\u0001!\u0015\r\u0011\"\u0001\u0002>!9\u0011Q\t\u0001\u0005\u0002\u0005\u001d\u0003bBA6\u0001\u0011\u0005\u0013Q\u000e\u0005\b\u0003k\u0002A\u0011IA<\u0011\u001d\tI\t\u0001C)\u0003\u0017C\u0011\"!&\u0001\u0003\u0003%\t!a&\t\u0013\u0005}\u0005!%A\u0005\u0002\u0005\u0005\u0006\"CA\\\u0001E\u0005I\u0011AAQ\u0011%\tI\fAI\u0001\n\u0003\tY\fC\u0005\u0002@\u0002\t\t\u0011\"\u0011\u0002B\"I\u0011Q\u001a\u0001\u0002\u0002\u0013\u0005\u0011q\u001a\u0005\n\u0003/\u0004\u0011\u0011!C\u0001\u00033D\u0011\"a8\u0001\u0003\u0003%\t%!9\t\u0013\u0005=\b!!A\u0005\u0002\u0005E\b\"CA{\u0001\u0005\u0005I\u0011IA|\u0011%\tY\u0010AA\u0001\n\u0003\nipB\u0004\u0003\"-B\tAa\t\u0007\r)Z\u0003\u0012\u0001B\u0013\u0011\u0019\u0019\u0017\u0005\"\u0001\u00038!9!\u0011H\u0011\u0005\u0002\tm\u0002bBA#C\u0011\u0005!\u0011\t\u0005\n\u0005\u0017\n#\u0019!C\u0001\u0005\u001bB\u0001Ba\u0014\"A\u0003%\u0011\u0011\u0006\u0005\n\u0005s\t\u0013\u0011!CA\u0005#B\u0011B!\u0017\"\u0003\u0003%\tIa\u0017\t\u0013\t5\u0014%!A\u0005\n\t=$!C!se\u0006L8k\u001c:u\u0015\taS&A\u0006fqB\u0014Xm]:j_:\u001c(B\u0001\u00180\u0003!\u0019\u0017\r^1msN$(B\u0001\u00192\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003eM\nQa\u001d9be.T!\u0001N\u001b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u00051\u0014aA8sO\u000e\u00011C\u0002\u0001:{\u00013E\n\u0005\u0002;w5\t1&\u0003\u0002=W\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005ir\u0014BA ,\u0005\r\n%O]1z\u0005\u0006\u001cX\rZ*j[BdW\rS5hQ\u0016\u0014xJ\u001d3fe\u001a+hn\u0019;j_:\u0004\"!\u0011#\u000e\u0003\tS!aQ\u0016\u0002\u000f\r|G-Z4f]&\u0011QI\u0011\u0002\u0010\u0007>$WmZ3o\r\u0006dGNY1dWB\u0011qIS\u0007\u0002\u0011*\t\u0011*A\u0003tG\u0006d\u0017-\u0003\u0002L\u0011\n9\u0001K]8ek\u000e$\bCA'V\u001d\tq5K\u0004\u0002P%6\t\u0001K\u0003\u0002Ro\u00051AH]8pizJ\u0011!S\u0005\u0003)\"\u000bq\u0001]1dW\u0006<W-\u0003\u0002W/\na1+\u001a:jC2L'0\u00192mK*\u0011A\u000bS\u0001\tCJ<W/\\3oiV\t\u0011(A\u0005be\u001e,X.\u001a8uA\u0005Aa-\u001e8di&|g.A\u0005gk:\u001cG/[8oA\u0005I\u0012\r\u001c7po:+H\u000e\\\"p[B\f'/[:p]J+7/\u001e7u+\u0005y\u0006CA$a\u0013\t\t\u0007JA\u0004C_>dW-\u00198\u00025\u0005dGn\\<Ok2d7i\\7qCJL7o\u001c8SKN,H\u000e\u001e\u0011\u0002\rqJg.\u001b;?)\u0011)gm\u001a5\u0011\u0005i\u0002\u0001\"\u0002-\b\u0001\u0004I\u0004\"B.\b\u0001\u0004I\u0004\"B/\b\u0001\u0004yFcA3kW\")\u0001\f\u0003a\u0001s!)1\f\u0003a\u0001sQ\u0011Q-\u001c\u0005\u00061&\u0001\r!O\u0001\fK2,W.\u001a8u)f\u0004X-F\u0001q!\t\tH/D\u0001s\u0015\t\u0019x&A\u0003usB,7/\u0003\u0002ve\nAA)\u0019;b)f\u0004X\r\u000b\u0002\u000boB\u0011q\t_\u0005\u0003s\"\u0013\u0011\u0002\u001e:b]NLWM\u001c;\u0002\u0011\u0011\fG/\u0019+za\u0016,\u0012\u0001 \t\u0003cvL!A :\u0003\u0013\u0005\u0013(/Y=UsB,\u0017aE2iK\u000e\\\u0017J\u001c9vi\u0012\u000bG/\u0019+za\u0016\u001cHCAA\u0002!\u0011\t)!a\u0003\u000e\u0005\u0005\u001d!bAA\u0005[\u0005A\u0011M\\1msNL7/\u0003\u0003\u0002\u000e\u0005\u001d!a\u0004+za\u0016\u001c\u0005.Z2l%\u0016\u001cX\u000f\u001c;\u0002\t\tLg\u000e\u001a\u000b\u0004K\u0006M\u0001bBA\u000b\u001b\u0001\u0007\u0011qC\u0001\u0002MBAq)!\u0007:\u0003;\tI#C\u0002\u0002\u001c!\u0013\u0011BR;oGRLwN\u001c\u001a\u0011\u000b5\u000by\"a\t\n\u0007\u0005\u0005rKA\u0002TKF\u0004RaRA\u0013a~K1!a\nI\u0005\u0019!V\u000f\u001d7feA\u0019!(a\u000b\n\u0007\u000552F\u0001\bMC6\u0014G-\u0019$v]\u000e$\u0018n\u001c8\u0002\ta$\u0013'M\u000b\u0003\u0003g\u0001raRA\u0013\u0003k\t)\u0004E\u0002;\u0003oI1!!\u000f,\u0005Mq\u0015-\\3e\u0019\u0006l'\rZ1WCJL\u0017M\u00197f\u000311\u0017N]:u\u000b2,WNV1s+\t\t)\u0004\u000b\u0002\u0010o\u0006i1/Z2p]\u0012,E.Z7WCJD#\u0001E<\u0002\u0015\r|W\u000e]1sCR|'\u000f\u0006\u0003\u0002J\u0005}\u0003CBA&\u0003+\nI&\u0004\u0002\u0002N)!\u0011qJA)\u0003\u0011)H/\u001b7\u000b\u0005\u0005M\u0013\u0001\u00026bm\u0006LA!a\u0016\u0002N\tQ1i\\7qCJ\fGo\u001c:\u0011\u0007\u001d\u000bY&C\u0002\u0002^!\u00131!\u00118z\u0011\u001d\t\t'\u0005a\u0001\u0003G\n\u0001\"\u001b8qkR\u0014vn\u001e\t\u0005\u0003K\n9'D\u0001.\u0013\r\tI'\f\u0002\f\u0013:$XM\u001d8bYJ{w/\u0001\u0007ok2d7+\u00194f\u000bZ\fG\u000e\u0006\u0004\u0002Z\u0005=\u0014\u0011\u000f\u0005\b\u0003C\u0012\u0002\u0019AA2\u0011\u001d\t\u0019H\u0005a\u0001\u00033\nQ\"\u0019:hk6,g\u000e\u001e,bYV,\u0017A\u00039sKR$\u0018PT1nKV\u0011\u0011\u0011\u0010\t\u0005\u0003w\n\u0019I\u0004\u0003\u0002~\u0005}\u0004CA(I\u0013\r\t\t\tS\u0001\u0007!J,G-\u001a4\n\t\u0005\u0015\u0015q\u0011\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005\u0005\u0005*A\fxSRDg*Z<DQ&dGM]3o\u0013:$XM\u001d8bYR)Q-!$\u0002\u0012\"1\u0011q\u0012\u000bA\u0002e\nqA\\3x\u0019\u00164G\u000f\u0003\u0004\u0002\u0014R\u0001\r!O\u0001\t]\u0016<(+[4ii\u0006!1m\u001c9z)\u001d)\u0017\u0011TAN\u0003;Cq\u0001W\u000b\u0011\u0002\u0003\u0007\u0011\bC\u0004\\+A\u0005\t\u0019A\u001d\t\u000fu+\u0002\u0013!a\u0001?\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAARU\rI\u0014QU\u0016\u0003\u0003O\u0003B!!+\u000246\u0011\u00111\u0016\u0006\u0005\u0003[\u000by+A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011\u0017%\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u00026\u0006-&!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012\u0014AD2paf$C-\u001a4bk2$HeM\u000b\u0003\u0003{S3aXAS\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u00111\u0019\t\u0005\u0003\u000b\fY-\u0004\u0002\u0002H*!\u0011\u0011ZA)\u0003\u0011a\u0017M\\4\n\t\u0005\u0015\u0015qY\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003#\u00042aRAj\u0013\r\t)\u000e\u0013\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u00033\nY\u000eC\u0005\u0002^n\t\t\u00111\u0001\u0002R\u0006\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!a9\u0011\r\u0005\u0015\u00181^A-\u001b\t\t9OC\u0002\u0002j\"\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\ti/a:\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0004?\u0006M\b\"CAo;\u0005\u0005\t\u0019AA-\u0003I\u0001(o\u001c3vGR,E.Z7f]Rt\u0015-\\3\u0015\t\u0005\r\u0017\u0011 \u0005\n\u0003;t\u0012\u0011!a\u0001\u0003#\fa!Z9vC2\u001cHcA0\u0002\u0000\"I\u0011Q\\\u0010\u0002\u0002\u0003\u0007\u0011\u0011\f\u0015\u0014\u0001\t\r!\u0011\u0002B\u0006\u0005\u001f\u0011\tB!\u0006\u0003\u0018\tm!Q\u0004\t\u0004u\t\u0015\u0011b\u0001B\u0004W\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017E\u0001B\u0007\u0003\u0015\u0015uLR+O\u0007~CS\r\u001f9sY\u00012WO\\2*A5\u00023k\u001c:ug\u0002\"\b.\u001a\u0011j]B,H\u000fI1se\u0006Lh\u0006I%gA\u0019,hn\u0019\u0011jg\u0002zW.\u001b;uK\u0012d\u0003e]8si*\u0001\u0003\u0005\t\u0011j]\u0002\n7oY3oI&tw\rI8sI\u0016\u0014h\u0006\t+iK\u0002*G.Z7f]R\u001c\be\u001c4!i\",\u0007%\u001b8qkR\u0004\u0013M\u001d:bs\u0002jWo\u001d;!E\u0016\u0004sN\u001d3fe\u0006\u0014G.\u001a\u0018\u000bA\u0001\u0002\u0003ET1OA%\u001c\be\u001a:fCR,'\u000f\t;iC:\u0004\u0013M\\=!]>tWFT1OA\u0015dW-\\3oiN\u0004cm\u001c:!I>,(\r\\30M2|\u0017\r\u001e\u0011usB,gF\u0003\u0011!A\u0001rU\u000f\u001c7!K2,W.\u001a8ug\u0002:\u0018\u000e\u001c7!E\u0016\u0004\u0003\u000f\\1dK\u0012\u0004\u0013\r\u001e\u0011uQ\u0016\u0004SM\u001c3!_\u001a\u0004C\u000f[3!e\u0016$XO\u001d8fI\u0002\n'O]1z])\u0001\u0003\u0005\t\u0011TS:\u001cW\rI\u001a/a9\u0002\u0004\u0005\u001e5jg\u00022WO\\2uS>t\u0007%\u00197t_\u0002\u001axN\u001d;tA\u0005tG\r\t:fiV\u0014hn\u001d\u0011uQ\u0016\u0004\u0013M\u001d:bs\u0002\u0012\u0017m]3eA=t\u0007\u0005\u001e5f\u0015\u0001\u0002\u0003\u0005I4jm\u0016t\u0007eY8na\u0006\u0014\u0018\r^8sA\u0019,hn\u0019;j_:t\u0003\u0005\u00165fA\r|W\u000e]1sCR|'\u000fI<jY2\u0004C/Y6fAQ<x\u000eI1sOVlWM\u001c;tAI,\u0007O]3tK:$\u0018N\\4\u000bA\u0001\u0002\u0003\u0005^<pA\u0015dW-\\3oiN\u0004sN\u001a\u0011uQ\u0016\u0004\u0013M\u001d:bs:R\u0001\u0005\t\u0011!\u0013R\u0004#/\u001a;ve:\u001c\b%\u0019\u0011oK\u001e\fG/\u001b<fA%tG/Z4fe2\u0002\u0003\u0007\f\u0011pe\u0002\n\u0007\u0005]8tSRLg/\u001a\u0011j]R,w-\u001a:!CN\u0004C\u000f[3!M&\u00148\u000f\u001e\u0011fY\u0016lWM\u001c;!SN\u0004C.Z:tAQD\u0017M\u001c\u0017\u000bA\u0001\u0002\u0003%Z9vC2\u0004Co\u001c\u0017!_J\u0004sM]3bi\u0016\u0014\b\u0005\u001e5b]\u0002\"\b.\u001a\u0011tK\u000e|g\u000e\u001a\u0011fY\u0016lWM\u001c;/A%3\u0007\u0005\u001e5fA\r|W\u000e]1sCR|'\u000f\t4v]\u000e$\u0018n\u001c8!e\u0016$XO\u001d8tA9,H\u000e\u001c\u0017\u000bA\u0001\u0002\u0003\u0005\u001e5fA\u0019,hn\u0019;j_:\u0004s/\u001b7mA\u0019\f\u0017\u000e\u001c\u0011b]\u0012\u0004#/Y5tK\u0002\ng\u000eI3se>\u0014hF\u0003\u0011!A\u0001\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0005'\t1Q\u001c\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)CJ\u0014\u0018-\u001f\u00156Y\u00012D\u0006I\u0019*Y\u0001BC.\u001a4uY\u0001\u0012\u0018n\u001a5uS\u0001jc\bI2bg\u0016\u0004s\u000f[3oA1,g\r\u001e\u0011=AILw\r\u001b;!i\",g\u000eI\u00172A]DWM\u001c\u0011mK\u001a$\bE\u0010\u0011sS\u001eDG\u000f\t;iK:\u0004\u0013\u0007I3mg\u0016\u0004\u0003\u0007I3oI&Z$\u0002\t\u0011!A\u0001\u0002\u0003eW\u0019-k12TL\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015beJ\f\u0017\u0010K\u0014cG\u001eb\u0003eJ1cO1\u0002s\u0005Z2(S1\u0002\u0003\u0006\\3gi2\u0002#/[4ii&\u0002SF\u0010\u0011dCN,\u0007e\u001e5f]\u0002bWM\u001a;!SN\u0004c.\u001e7mA\u0005tG\r\t:jO\"$\b%[:!]VdG\u000e\t;iK:\u0004\u0003\u0007I<iK:\u0004C.\u001a4uA%\u001c\bE\\;mY\u0002\"\b.\u001a8![E\u0002s\u000f[3oAILw\r\u001b;!SN\u0004c.\u001e7mAQDWM\u001c\u00112A]DWM\u001c\u0011mK\u001a$\b\u0005\u0010\u0011sS\u001eDG\u000f\t;iK:\u0004\u0013\u0007I<iK:\u0004C.\u001a4uAy\u0002#/[4ii\u0002\"\b.\u001a8![E\u0002S\r\\:fAA\u0002SM\u001c3*w)\u0001\u0003\u0005\t\u0011!A\u0001Z&\u0005Z2#Y\t\u00127M\t\u0017#C\n\u0014SL\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015beJ\f\u0017\u0010K\u0014cO1\u0002s\u0005Z\u0014-A9,H\u000e\u001c\u0017!O\r<C\u0006I\u0014bO%J3H\u0003\u0011!A\u0001\u0002\u0003\u0005I.#C\nb#E\u0019\u0012-E\r\u0014CF\t3#Y9,H\u000e\\/\u000bA\u0001\nQa]5oG\u0016\f#A!\u0007\u0002\u000bIrCG\f\u0019\u0002\u000b\u001d\u0014x.\u001e9\"\u0005\t}\u0011\u0001\u00047b[\n$\u0017m\u00184v]\u000e\u001c\u0018!C!se\u0006L8k\u001c:u!\tQ\u0014eE\u0003\"\u0005O\u0011i\u0003E\u0002H\u0005SI1Aa\u000bI\u0005\u0019\te.\u001f*fMB!!q\u0006B\u001b\u001b\t\u0011\tD\u0003\u0003\u00034\u0005E\u0013AA5p\u0013\r1&\u0011\u0007\u000b\u0003\u0005G\tQ!\u00199qYf$R!\u001aB\u001f\u0005\u007fAQ\u0001W\u0012A\u0002eBQaW\u0012A\u0002e\"R!\u000fB\"\u0005\u000fBaA!\u0012%\u0001\u0004I\u0014\u0001\u00027fMRDaA!\u0013%\u0001\u0004I\u0014!\u0002:jO\"$\u0018!\u00053fM\u0006,H\u000e^\"p[B\f'/\u0019;peV\u0011\u0011\u0011F\u0001\u0013I\u00164\u0017-\u001e7u\u0007>l\u0007/\u0019:bi>\u0014\b\u0005F\u0004f\u0005'\u0012)Fa\u0016\t\u000ba;\u0003\u0019A\u001d\t\u000bm;\u0003\u0019A\u001d\t\u000bu;\u0003\u0019A0\u0002\u000fUt\u0017\r\u001d9msR!!Q\fB5!\u00159%q\fB2\u0013\r\u0011\t\u0007\u0013\u0002\u0007\u001fB$\u0018n\u001c8\u0011\r\u001d\u0013)'O\u001d`\u0013\r\u00119\u0007\u0013\u0002\u0007)V\u0004H.Z\u001a\t\u0011\t-\u0004&!AA\u0002\u0015\f1\u0001\u001f\u00131\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\u0011\t\b\u0005\u0003\u0002F\nM\u0014\u0002\u0002B;\u0003\u000f\u0014aa\u00142kK\u000e$\b")
public class ArraySort
extends Expression
implements ArrayBasedSimpleHigherOrderFunction,
CodegenFallback,
Serializable {
    private transient DataType elementType;
    private Tuple2<NamedLambdaVariable, NamedLambdaVariable> x$11;
    private transient NamedLambdaVariable firstElemVar;
    private transient NamedLambdaVariable secondElemVar;
    private final Expression argument;
    private final Expression function;
    private final boolean allowNullComparisonResult;
    private transient Seq<Expression> children;
    private Seq<Enumeration.Value> nodePatterns;
    private boolean argumentsResolved;
    private boolean resolved;
    private transient Seq<Expression> functionsForEval;
    private Expression canonicalized;
    private volatile transient byte bitmap$trans$0;
    private volatile byte bitmap$0;

    public static Option<Tuple3<Expression, Expression, Object>> unapply(ArraySort arraySort) {
        return ArraySort$.MODULE$.unapply(arraySort);
    }

    public static LambdaFunction defaultComparator() {
        return ArraySort$.MODULE$.defaultComparator();
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return CodegenFallback.doGenCode$(this, ctx, ev);
    }

    @Override
    public AbstractDataType argumentType() {
        return ArrayBasedSimpleHigherOrderFunction.argumentType$(this);
    }

    @Override
    public Seq<Expression> arguments() {
        return SimpleHigherOrderFunction.arguments$(this);
    }

    @Override
    public Seq<AbstractDataType> argumentTypes() {
        return SimpleHigherOrderFunction.argumentTypes$(this);
    }

    @Override
    public Seq<Expression> functions() {
        return SimpleHigherOrderFunction.functions$(this);
    }

    @Override
    public AbstractDataType functionType() {
        return SimpleHigherOrderFunction.functionType$(this);
    }

    @Override
    public Seq<AbstractDataType> functionTypes() {
        return SimpleHigherOrderFunction.functionTypes$(this);
    }

    @Override
    public Expression functionForEval() {
        return SimpleHigherOrderFunction.functionForEval$(this);
    }

    @Override
    public Expression left() {
        return SimpleHigherOrderFunction.left$(this);
    }

    @Override
    public Expression right() {
        return SimpleHigherOrderFunction.right$(this);
    }

    @Override
    public Object eval(InternalRow inputRow) {
        return SimpleHigherOrderFunction.eval$(this, inputRow);
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return BinaryLike.mapChildren$(this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return BinaryLike.withNewChildrenInternal$(this, newChildren);
    }

    @Override
    public boolean nullable() {
        return HigherOrderFunction.nullable$(this);
    }

    @Override
    public TypeCheckResult checkArgumentDataTypes() {
        return HigherOrderFunction.checkArgumentDataTypes$(this);
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return HigherOrderFunction.inputTypes$(this);
    }

    private Seq<Expression> children$lzycompute() {
        ArraySort arraySort = this;
        synchronized (arraySort) {
            if ((byte)(this.bitmap$trans$0 & 8) == 0) {
                this.children = BinaryLike.children$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 8);
            }
        }
        return this.children;
    }

    @Override
    public final Seq<Expression> children() {
        return (byte)(this.bitmap$trans$0 & 8) == 0 ? this.children$lzycompute() : this.children;
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private boolean argumentsResolved$lzycompute() {
        ArraySort arraySort = this;
        synchronized (arraySort) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.argumentsResolved = HigherOrderFunction.argumentsResolved$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.argumentsResolved;
    }

    @Override
    public boolean argumentsResolved() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.argumentsResolved$lzycompute() : this.argumentsResolved;
    }

    private boolean resolved$lzycompute() {
        ArraySort arraySort = this;
        synchronized (arraySort) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.resolved = HigherOrderFunction.resolved$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.resolved$lzycompute() : this.resolved;
    }

    private Seq<Expression> functionsForEval$lzycompute() {
        ArraySort arraySort = this;
        synchronized (arraySort) {
            if ((byte)(this.bitmap$trans$0 & 0x10) == 0) {
                this.functionsForEval = HigherOrderFunction.functionsForEval$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 0x10);
            }
        }
        return this.functionsForEval;
    }

    @Override
    public Seq<Expression> functionsForEval() {
        return (byte)(this.bitmap$trans$0 & 0x10) == 0 ? this.functionsForEval$lzycompute() : this.functionsForEval;
    }

    private Expression canonicalized$lzycompute() {
        ArraySort arraySort = this;
        synchronized (arraySort) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.canonicalized = HigherOrderFunction.canonicalized$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.canonicalized;
    }

    @Override
    public Expression canonicalized() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.canonicalized$lzycompute() : this.canonicalized;
    }

    @Override
    public final void org$apache$spark$sql$catalyst$expressions$HigherOrderFunction$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    @Override
    public Expression argument() {
        return this.argument;
    }

    @Override
    public Expression function() {
        return this.function;
    }

    public boolean allowNullComparisonResult() {
        return this.allowNullComparisonResult;
    }

    private DataType elementType$lzycompute() {
        ArraySort arraySort = this;
        synchronized (arraySort) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.elementType = ((ArrayType)this.argument().dataType()).elementType();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.elementType;
    }

    public DataType elementType() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.elementType$lzycompute() : this.elementType;
    }

    @Override
    public ArrayType dataType() {
        return (ArrayType)this.argument().dataType();
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    public TypeCheckResult checkInputDataTypes() {
        block5: {
            block4: {
                var3_1 = this.checkArgumentDataTypes();
                if (!TypeCheckResult$TypeCheckSuccess$.MODULE$.equals(var3_1)) break block4;
                var4_2 = false;
                var5_3 = null;
                var6_4 = this.argument().dataType();
                if (!(var6_4 instanceof ArrayType)) ** GOTO lbl-1000
                var4_2 = true;
                var5_3 = (ArrayType)var6_4;
                dt = var5_3.elementType();
                if (RowOrdering$.MODULE$.isOrderable(dt)) {
                    v0 = this.function().dataType();
                    var8_6 = IntegerType$.MODULE$;
                    var2_7 /* !! */  = !(v0 != null ? v0.equals(var8_6) == false : var8_6 != null) ? TypeCheckResult$TypeCheckSuccess$.MODULE$ : new TypeCheckResult.TypeCheckFailure("Return type of the given function has to be IntegerType");
                } else if (var4_2) {
                    dt = var5_3.elementType();
                    dtSimple = dt.catalogString();
                    var2_7 /* !! */  = new TypeCheckResult.TypeCheckFailure(new StringBuilder(9).append(new StringBuilder(54).append(this.prettyName()).append(" does not support sorting array of type ").append(dtSimple).append(" which is not ").toString()).append("orderable").toString());
                } else {
                    var2_7 /* !! */  = new TypeCheckResult.TypeCheckFailure(new StringBuilder(27).append(this.prettyName()).append(" only supports array input.").toString());
                }
                var1_10 = var2_7 /* !! */ ;
                break block5;
            }
            var1_10 = var3_1;
        }
        return var1_10;
    }

    @Override
    public ArraySort bind(Function2<Expression, Seq<Tuple2<DataType, Object>>, LambdaFunction> f) {
        DataType dataType = this.argument().dataType();
        if (!(dataType instanceof ArrayType)) {
            throw new MatchError((Object)dataType);
        }
        ArrayType arrayType = (ArrayType)dataType;
        DataType elementType = arrayType.elementType();
        boolean containsNull = arrayType.containsNull();
        Tuple2 tuple2 = new Tuple2((Object)elementType, (Object)BoxesRunTime.boxToBoolean((boolean)containsNull));
        Tuple2 tuple22 = tuple2;
        DataType elementType2 = (DataType)tuple22._1();
        boolean containsNull2 = tuple22._2$mcZ$sp();
        Tuple2 tuple23 = new Tuple2((Object)elementType2, (Object)BoxesRunTime.boxToBoolean((boolean)containsNull2));
        Tuple2 tuple24 = new Tuple2((Object)elementType2, (Object)BoxesRunTime.boxToBoolean((boolean)containsNull2));
        LambdaFunction x$1 = (LambdaFunction)f.apply((Object)this.function(), (Object)package$.MODULE$.Nil().$colon$colon((Object)tuple24).$colon$colon((Object)tuple23));
        Expression x$2 = this.copy$default$1();
        boolean x$3 = this.copy$default$3();
        return this.copy(x$2, x$1, x$3);
    }

    private Tuple2<NamedLambdaVariable, NamedLambdaVariable> x$11$lzycompute() {
        block5: {
            ArraySort arraySort = this;
            synchronized (arraySort) {
                NamedLambdaVariable namedLambdaVariable;
                NamedExpression secondElemVar;
                block7: {
                    Expression expression;
                    block6: {
                        SeqOps seqOps;
                        LambdaFunction lambdaFunction;
                        Seq<NamedExpression> seq;
                        if ((byte)(this.bitmap$0 & 1) != 0) break block5;
                        expression = this.function();
                        if (!(expression instanceof LambdaFunction) || (seq = (lambdaFunction = (LambdaFunction)expression).arguments()) == null || SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq(seq)) || new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) == null || SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) != 0) break block6;
                        NamedExpression firstElemVar = (NamedExpression)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
                        secondElemVar = (NamedExpression)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
                        if (!(firstElemVar instanceof NamedLambdaVariable)) break block6;
                        namedLambdaVariable = (NamedLambdaVariable)firstElemVar;
                        if (secondElemVar instanceof NamedLambdaVariable) break block7;
                    }
                    throw new MatchError((Object)expression);
                }
                NamedLambdaVariable namedLambdaVariable2 = (NamedLambdaVariable)secondElemVar;
                Tuple2 tuple2 = new Tuple2((Object)namedLambdaVariable, (Object)namedLambdaVariable2);
                this.x$11 = tuple2;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.x$11;
    }

    private /* synthetic */ Tuple2 x$11() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.x$11$lzycompute() : this.x$11;
    }

    private NamedLambdaVariable firstElemVar$lzycompute() {
        ArraySort arraySort = this;
        synchronized (arraySort) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.firstElemVar = (NamedLambdaVariable)this.x$11()._1();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.firstElemVar;
    }

    public NamedLambdaVariable firstElemVar() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.firstElemVar$lzycompute() : this.firstElemVar;
    }

    private NamedLambdaVariable secondElemVar$lzycompute() {
        ArraySort arraySort = this;
        synchronized (arraySort) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.secondElemVar = (NamedLambdaVariable)this.x$11()._2();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.secondElemVar;
    }

    public NamedLambdaVariable secondElemVar() {
        return (byte)(this.bitmap$trans$0 & 4) == 0 ? this.secondElemVar$lzycompute() : this.secondElemVar;
    }

    public Comparator<Object> comparator(InternalRow inputRow) {
        Expression f = this.functionForEval();
        return (o1, o2) -> {
            this.firstElemVar().value().set(o1);
            this.secondElemVar().value().set(o2);
            Object cmp = f.eval(inputRow);
            if (!this.allowNullComparisonResult() && cmp == null) {
                throw QueryExecutionErrors$.MODULE$.nullComparisonResultError();
            }
            return BoxesRunTime.unboxToInt((Object)cmp);
        };
    }

    @Override
    public Object nullSafeEval(InternalRow inputRow, Object argumentValue) {
        Object[] arr = (Object[])((ArrayData)argumentValue).toArray(this.elementType(), ClassTag$.MODULE$.AnyRef());
        DataType dataType = this.elementType();
        NullType$ nullType$ = NullType$.MODULE$;
        if (dataType == null ? nullType$ != null : !dataType.equals(nullType$)) {
            Arrays.sort(arr, this.comparator(inputRow));
        }
        return new GenericArrayData(arr);
    }

    @Override
    public String prettyName() {
        return "array_sort";
    }

    @Override
    public ArraySort withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight, this.copy$default$3());
    }

    public ArraySort copy(Expression argument, Expression function, boolean allowNullComparisonResult) {
        return new ArraySort(argument, function, allowNullComparisonResult);
    }

    public Expression copy$default$1() {
        return this.argument();
    }

    public Expression copy$default$2() {
        return this.function();
    }

    public boolean copy$default$3() {
        return this.allowNullComparisonResult();
    }

    @Override
    public String productPrefix() {
        return "ArraySort";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.argument();
                break;
            }
            case 1: {
                object = this.function();
                break;
            }
            case 2: {
                object = BoxesRunTime.boxToBoolean((boolean)this.allowNullComparisonResult());
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ArraySort;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "argument";
                break;
            }
            case 1: {
                string = "function";
                break;
            }
            case 2: {
                string = "allowNullComparisonResult";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ArraySort)) return false;
        boolean bl = true;
        if (!bl) return false;
        ArraySort arraySort = (ArraySort)x$1;
        if (this.allowNullComparisonResult() != arraySort.allowNullComparisonResult()) return false;
        Expression expression = this.argument();
        Expression expression2 = arraySort.argument();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.function();
        Expression expression4 = arraySort.function();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!arraySort.canEqual(this)) return false;
        return true;
    }

    public ArraySort(Expression argument, Expression function, boolean allowNullComparisonResult) {
        this.argument = argument;
        this.function = function;
        this.allowNullComparisonResult = allowNullComparisonResult;
        ExpectsInputTypes.$init$(this);
        HigherOrderFunction.$init$(this);
        BinaryLike.$init$(this);
        SimpleHigherOrderFunction.$init$(this);
        ArrayBasedSimpleHigherOrderFunction.$init$(this);
        CodegenFallback.$init$(this);
        Statics.releaseFence();
    }

    public ArraySort(Expression argument, Expression function) {
        this(argument, function, BoxesRunTime.unboxToBoolean((Object)SQLConf$.MODULE$.get().getConf(SQLConf$.MODULE$.LEGACY_ALLOW_NULL_COMPARISON_RESULT_IN_ARRAY_SORT())));
    }

    public ArraySort(Expression argument) {
        this(argument, ArraySort$.MODULE$.defaultComparator());
    }
}

