/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.expressions.BinaryArithmetic;
import org.apache.spark.sql.catalyst.expressions.BitwiseXor$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.IntegralType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ShortType$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction2;

@ExpressionDescription(usage="expr1 _FUNC_ expr2 - Returns the result of bitwise exclusive OR of `expr1` and `expr2`.", examples="\n    Examples:\n      > SELECT 3 _FUNC_ 5;\n       6\n  ", since="1.4.0", group="bitwise_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005%g\u0001\u0002\u0010 \u00012B\u0001b\u0011\u0001\u0003\u0016\u0004%\t\u0001\u0012\u0005\t\u0011\u0002\u0011\t\u0012)A\u0005\u000b\"A\u0011\n\u0001BK\u0002\u0013\u0005A\t\u0003\u0005K\u0001\tE\t\u0015!\u0003F\u0011\u0015Y\u0005\u0001\"\u0001M\u0011\u001d\u0001\u0006A1A\u0005RECa!\u0016\u0001!\u0002\u0013\u0011\u0006\"\u0002,\u0001\t\u0003:\u0006\"\u00020\u0001\t\u0003z\u0006\u0002\u00035\u0001\u0011\u000b\u0007I\u0011B5\t\u000bA\u0004A\u0011K9\t\u000bY\u0004A\u0011K<\t\u000fq\u0004\u0011\u0011!C\u0001{\"I\u0011\u0011\u0001\u0001\u0012\u0002\u0013\u0005\u00111\u0001\u0005\n\u00033\u0001\u0011\u0013!C\u0001\u0003\u0007A\u0011\"a\u0007\u0001\u0003\u0003%\t%!\b\t\u0013\u00055\u0002!!A\u0005\u0002\u0005=\u0002\"CA\u001c\u0001\u0005\u0005I\u0011AA\u001d\u0011%\ty\u0004AA\u0001\n\u0003\n\t\u0005C\u0005\u0002P\u0001\t\t\u0011\"\u0001\u0002R!I\u0011Q\u000b\u0001\u0002\u0002\u0013\u0005\u0013q\u000b\u0005\n\u00037\u0002\u0011\u0011!C!\u0003;:\u0011\"!! \u0003\u0003E\t!a!\u0007\u0011yy\u0012\u0011!E\u0001\u0003\u000bCaa\u0013\r\u0005\u0002\u0005u\u0005\"CAP1\u0005\u0005IQIAQ\u0011%\t\u0019\u000bGA\u0001\n\u0003\u000b)\u000bC\u0005\u0002,b\t\t\u0011\"!\u0002.\"I\u0011q\u0018\r\u0002\u0002\u0013%\u0011\u0011\u0019\u0002\u000b\u0005&$x/[:f1>\u0014(B\u0001\u0011\"\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005\t\u001a\u0013\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005\u0011*\u0013aA:rY*\u0011aeJ\u0001\u0006gB\f'o\u001b\u0006\u0003Q%\na!\u00199bG\",'\"\u0001\u0016\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001i\u0013g\u000e\t\u0003]=j\u0011aH\u0005\u0003a}\u0011\u0001CQ5oCJL\u0018I]5uQ6,G/[2\u0011\u0005I*T\"A\u001a\u000b\u0003Q\nQa]2bY\u0006L!AN\u001a\u0003\u000fA\u0013x\u000eZ;diB\u0011\u0001\b\u0011\b\u0003syr!AO\u001f\u000e\u0003mR!\u0001P\u0016\u0002\rq\u0012xn\u001c;?\u0013\u0005!\u0014BA 4\u0003\u001d\u0001\u0018mY6bO\u0016L!!\u0011\"\u0003\u0019M+'/[1mSj\f'\r\\3\u000b\u0005}\u001a\u0014\u0001\u00027fMR,\u0012!\u0012\t\u0003]\u0019K!aR\u0010\u0003\u0015\u0015C\bO]3tg&|g.A\u0003mK\u001a$\b%A\u0003sS\u001eDG/\u0001\u0004sS\u001eDG\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00075su\n\u0005\u0002/\u0001!)1)\u0002a\u0001\u000b\")\u0011*\u0002a\u0001\u000b\u0006Ya-Y5m\u001f:,%O]8s+\u0005\u0011\u0006C\u0001\u001aT\u0013\t!6GA\u0004C_>dW-\u00198\u0002\u0019\u0019\f\u0017\u000e\\(o\u000bJ\u0014xN\u001d\u0011\u0002\u0013%t\u0007/\u001e;UsB,W#\u0001-\u0011\u0005ecV\"\u0001.\u000b\u0005m\u001b\u0013!\u0002;za\u0016\u001c\u0018BA/[\u0005A\t%m\u001d;sC\u000e$H)\u0019;b)f\u0004X-\u0001\u0004ts6\u0014w\u000e\\\u000b\u0002AB\u0011\u0011-\u001a\b\u0003E\u000e\u0004\"AO\u001a\n\u0005\u0011\u001c\u0014A\u0002)sK\u0012,g-\u0003\u0002gO\n11\u000b\u001e:j]\u001eT!\u0001Z\u001a\u0002\u0007a|'/F\u0001k!\u0015\u00114.\\7n\u0013\ta7GA\u0005Gk:\u001cG/[8oeA\u0011!G\\\u0005\u0003_N\u00121!\u00118z\u00031qW\u000f\u001c7TC\u001a,WI^1m)\ri'\u000f\u001e\u0005\u0006g.\u0001\r!\\\u0001\u0007S:\u0004X\u000f^\u0019\t\u000bU\\\u0001\u0019A7\u0002\r%t\u0007/\u001e;3\u0003]9\u0018\u000e\u001e5OK^\u001c\u0005.\u001b7ee\u0016t\u0017J\u001c;fe:\fG\u000eF\u0002NqjDQ!\u001f\u0007A\u0002\u0015\u000bqA\\3x\u0019\u00164G\u000fC\u0003|\u0019\u0001\u0007Q)\u0001\u0005oK^\u0014\u0016n\u001a5u\u0003\u0011\u0019w\u000e]=\u0015\u00075sx\u0010C\u0004D\u001bA\u0005\t\u0019A#\t\u000f%k\u0001\u0013!a\u0001\u000b\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA\u0003U\r)\u0015qA\u0016\u0003\u0003\u0013\u0001B!a\u0003\u0002\u00165\u0011\u0011Q\u0002\u0006\u0005\u0003\u001f\t\t\"A\u0005v]\u000eDWmY6fI*\u0019\u00111C\u001a\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\u0018\u00055!!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012\u0014!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002 A!\u0011\u0011EA\u0016\u001b\t\t\u0019C\u0003\u0003\u0002&\u0005\u001d\u0012\u0001\u00027b]\u001eT!!!\u000b\u0002\t)\fg/Y\u0005\u0004M\u0006\r\u0012\u0001\u00049s_\u0012,8\r^!sSRLXCAA\u0019!\r\u0011\u00141G\u0005\u0004\u0003k\u0019$aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$HcA7\u0002<!I\u0011Q\b\n\u0002\u0002\u0003\u0007\u0011\u0011G\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005\r\u0003#BA#\u0003\u0017jWBAA$\u0015\r\tIeM\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA'\u0003\u000f\u0012\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR\u0019!+a\u0015\t\u0011\u0005uB#!AA\u00025\f!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR!\u0011qDA-\u0011%\ti$FA\u0001\u0002\u0004\t\t$\u0001\u0004fcV\fGn\u001d\u000b\u0004%\u0006}\u0003\u0002CA\u001f-\u0005\u0005\t\u0019A7)'\u0001\t\u0019'!\u001b\u0002l\u0005=\u0014\u0011OA;\u0003o\nY(! \u0011\u00079\n)'C\u0002\u0002h}\u0011Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0002n\u00059V\r\u001f9sc\u0001zf)\u0016(D?\u0002*\u0007\u0010\u001d:3A5\u0002#+\u001a;ve:\u001c\b\u0005\u001e5fAI,7/\u001e7uA=4\u0007EY5uo&\u001cX\rI3yG2,8/\u001b<fA=\u0013\u0006e\u001c4!A\u0016D\bO]\u0019aA\u0005tG\r\t1fqB\u0014(\u0007\u0019\u0018\u0002\u0011\u0015D\u0018-\u001c9mKN\f#!a\u001d\u0002k)\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u00033\u0007I0G+:\u001bu\fI\u001b<\u0015\u0001\u0002\u0003\u0005\t\u0011!AYR\u0001\u0005I\u0001\u0006g&t7-Z\u0011\u0003\u0003s\nQ!\r\u00185]A\nQa\u001a:pkB\f#!a \u0002\u001b\tLGo^5tK~3WO\\2t\u0003)\u0011\u0015\u000e^<jg\u0016DvN\u001d\t\u0003]a\u0019R\u0001GAD\u0003'\u0003r!!#\u0002\u0010\u0016+U*\u0004\u0002\u0002\f*\u0019\u0011QR\u001a\u0002\u000fI,h\u000e^5nK&!\u0011\u0011SAF\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gN\r\t\u0005\u0003+\u000bY*\u0004\u0002\u0002\u0018*!\u0011\u0011TA\u0014\u0003\tIw.C\u0002B\u0003/#\"!a!\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!a\b\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000b5\u000b9+!+\t\u000b\r[\u0002\u0019A#\t\u000b%[\u0002\u0019A#\u0002\u000fUt\u0017\r\u001d9msR!\u0011qVA^!\u0015\u0011\u0014\u0011WA[\u0013\r\t\u0019l\r\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u000bI\n9,R#\n\u0007\u0005e6G\u0001\u0004UkBdWM\r\u0005\t\u0003{c\u0012\u0011!a\u0001\u001b\u0006\u0019\u0001\u0010\n\u0019\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\u0005\r\u0007\u0003BA\u0011\u0003\u000bLA!a2\u0002$\t1qJ\u00196fGR\u0004")
public class BitwiseXor
extends BinaryArithmetic
implements Serializable {
    private Function2<Object, Object, Object> xor;
    private final Expression left;
    private final Expression right;
    private final boolean failOnError;
    private volatile boolean bitmap$0;

    public static Option<Tuple2<Expression, Expression>> unapply(BitwiseXor bitwiseXor) {
        return BitwiseXor$.MODULE$.unapply(bitwiseXor);
    }

    public static Function1<Tuple2<Expression, Expression>, BitwiseXor> tupled() {
        return BitwiseXor$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, BitwiseXor>> curried() {
        return BitwiseXor$.MODULE$.curried();
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public boolean failOnError() {
        return this.failOnError;
    }

    @Override
    public AbstractDataType inputType() {
        return IntegralType$.MODULE$;
    }

    @Override
    public String symbol() {
        return "^";
    }

    private Function2<Object, Object, Object> xor$lzycompute() {
        BitwiseXor bitwiseXor = this;
        synchronized (bitwiseXor) {
            if (!this.bitmap$0) {
                JFunction2.mcJJJ.sp & Serializable intersect;
                DataType dataType = this.dataType();
                if (ByteType$.MODULE$.equals(dataType)) {
                    intersect = (JFunction2.mcJJJ.sp & Serializable)(evalE1, evalE2) -> BoxesRunTime.boxToByte((byte)BitwiseXor.$anonfun$xor$1(BoxesRunTime.unboxToByte((Object)evalE1), BoxesRunTime.unboxToByte((Object)evalE2)));
                } else if (ShortType$.MODULE$.equals(dataType)) {
                    intersect = (JFunction2.mcJJJ.sp & Serializable)(evalE1, evalE2) -> BoxesRunTime.boxToShort((short)BitwiseXor.$anonfun$xor$2(BoxesRunTime.unboxToShort((Object)evalE1), BoxesRunTime.unboxToShort((Object)evalE2)));
                } else if (IntegerType$.MODULE$.equals(dataType)) {
                    intersect = (JFunction2.mcJJJ.sp & Serializable)(evalE1, evalE2) -> evalE1 ^ evalE2;
                } else if (LongType$.MODULE$.equals(dataType)) {
                    intersect = (JFunction2.mcJJJ.sp & Serializable)(evalE1, evalE2) -> evalE1 ^ evalE2;
                } else {
                    throw new MatchError((Object)dataType);
                }
                this.xor = intersect;
                this.bitmap$0 = true;
            }
        }
        return this.xor;
    }

    private Function2<Object, Object, Object> xor() {
        return !this.bitmap$0 ? this.xor$lzycompute() : this.xor;
    }

    @Override
    public Object nullSafeEval(Object input1, Object input2) {
        return this.xor().apply(input1, input2);
    }

    @Override
    public BitwiseXor withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    public BitwiseXor copy(Expression left, Expression right) {
        return new BitwiseXor(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "BitwiseXor";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.left();
                break;
            }
            case 1: {
                object = this.right();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof BitwiseXor;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "left";
                break;
            }
            case 1: {
                string = "right";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof BitwiseXor)) return false;
        boolean bl = true;
        if (!bl) return false;
        BitwiseXor bitwiseXor = (BitwiseXor)x$1;
        Expression expression = this.left();
        Expression expression2 = bitwiseXor.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = bitwiseXor.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!bitwiseXor.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ byte $anonfun$xor$1(byte evalE1, byte evalE2) {
        return (byte)(evalE1 ^ evalE2);
    }

    public static final /* synthetic */ short $anonfun$xor$2(short evalE1, short evalE2) {
        return (short)(evalE1 ^ evalE2);
    }

    public BitwiseXor(Expression left, Expression right) {
        this.left = left;
        this.right = right;
        this.failOnError = false;
    }
}

