/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.time.DateTimeException;
import java.time.LocalDate;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.MakeDate$;
import org.apache.spark.sql.catalyst.expressions.TernaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.IntegerType$;
import scala.Function1;
import scala.Function3;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(year, month, day) - Create date from year, month and day fields.", arguments="\n    Arguments:\n      * year - the year to represent, from 1 to 9999\n      * month - the month-of-year to represent, from 1 (January) to 12 (December)\n      * day - the day-of-month to represent, from 1 to 31\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(2013, 7, 15);\n       2013-07-15\n      > SELECT _FUNC_(2019, 13, 1);\n       NULL\n      > SELECT _FUNC_(2019, 7, NULL);\n       NULL\n      > SELECT _FUNC_(2019, 2, 30);\n       NULL\n  ", group="datetime_funcs", since="3.0.0")
@ScalaSignature(bytes="\u0006\u0005\t-c\u0001\u0002\u0016,\u0001bB\u0001\u0002\u0017\u0001\u0003\u0016\u0004%\t!\u0017\u0005\t;\u0002\u0011\t\u0012)A\u00055\"Aa\f\u0001BK\u0002\u0013\u0005\u0011\f\u0003\u0005`\u0001\tE\t\u0015!\u0003[\u0011!\u0001\u0007A!f\u0001\n\u0003I\u0006\u0002C1\u0001\u0005#\u0005\u000b\u0011\u0002.\t\u0011\t\u0004!Q3A\u0005\u0002\rD\u0001b\u001a\u0001\u0003\u0012\u0003\u0006I\u0001\u001a\u0005\u0006Q\u0002!\t!\u001b\u0005\u0006Q\u0002!\ta\u001c\u0005\u0006g\u0002!\t%\u0017\u0005\u0006i\u0002!\t%\u0017\u0005\u0006k\u0002!\t%\u0017\u0005\u0006m\u0002!\te\u001e\u0005\b\u0003\u0007\u0001A\u0011IA\u0003\u0011\u0019\ti\u0001\u0001C!G\"9\u0011q\u0002\u0001\u0005B\u0005E\u0001bBA\u0010\u0001\u0011\u0005\u0013\u0011\u0005\u0005\b\u0003{\u0001A\u0011IA \u0011\u001d\t\t\u0006\u0001C)\u0003'B\u0011\"!\u0019\u0001\u0003\u0003%\t!a\u0019\t\u0013\u00055\u0004!%A\u0005\u0002\u0005=\u0004\"CAC\u0001E\u0005I\u0011AA8\u0011%\t9\tAI\u0001\n\u0003\ty\u0007C\u0005\u0002\n\u0002\t\n\u0011\"\u0001\u0002\f\"I\u0011q\u0012\u0001\u0002\u0002\u0013\u0005\u0013\u0011\u0013\u0005\n\u0003C\u0003\u0011\u0011!C\u0001\u0003GC\u0011\"a+\u0001\u0003\u0003%\t!!,\t\u0013\u0005M\u0006!!A\u0005B\u0005U\u0006\"CAb\u0001\u0005\u0005I\u0011AAc\u0011%\tI\rAA\u0001\n\u0003\nY\rC\u0005\u0002P\u0002\t\t\u0011\"\u0011\u0002R\u001eI\u00111`\u0016\u0002\u0002#\u0005\u0011Q \u0004\tU-\n\t\u0011#\u0001\u0002\u0000\"1\u0001N\tC\u0001\u0005/A\u0011B!\u0007#\u0003\u0003%)Ea\u0007\t\u0013\tu!%!A\u0005\u0002\n}\u0001\"\u0003B\u0015EE\u0005I\u0011AAF\u0011%\u0011YCIA\u0001\n\u0003\u0013i\u0003C\u0005\u0003@\t\n\n\u0011\"\u0001\u0002\f\"I!\u0011\t\u0012\u0002\u0002\u0013%!1\t\u0002\t\u001b\u0006\\W\rR1uK*\u0011A&L\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002/_\u0005A1-\u0019;bYf\u001cHO\u0003\u00021c\u0005\u00191/\u001d7\u000b\u0005I\u001a\u0014!B:qCJ\\'B\u0001\u001b6\u0003\u0019\t\u0007/Y2iK*\ta'A\u0002pe\u001e\u001c\u0001a\u0005\u0004\u0001su\u0002u)\u0014\t\u0003umj\u0011aK\u0005\u0003y-\u0012\u0011\u0003V3s]\u0006\u0014\u00180\u0012=qe\u0016\u001c8/[8o!\tQd(\u0003\u0002@W\t1\u0012*\u001c9mS\u000eLGoQ1ti&s\u0007/\u001e;UsB,7\u000f\u0005\u0002B\t:\u0011!HQ\u0005\u0003\u0007.\nq\u0001]1dW\u0006<W-\u0003\u0002F\r\nqa*\u001e7m\u0013:$x\u000e\\3sC:$(BA\",!\tA5*D\u0001J\u0015\u0005Q\u0015!B:dC2\f\u0017B\u0001'J\u0005\u001d\u0001&o\u001c3vGR\u0004\"AT+\u000f\u0005=#fB\u0001)T\u001b\u0005\t&B\u0001*8\u0003\u0019a$o\\8u}%\t!*\u0003\u0002D\u0013&\u0011ak\u0016\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0006\u0003\u0007&\u000bA!_3beV\t!\f\u0005\u0002;7&\u0011Al\u000b\u0002\u000b\u000bb\u0004(/Z:tS>t\u0017!B=fCJ\u0004\u0013!B7p]RD\u0017AB7p]RD\u0007%A\u0002eCf\fA\u0001Z1zA\u0005Ya-Y5m\u001f:,%O]8s+\u0005!\u0007C\u0001%f\u0013\t1\u0017JA\u0004C_>dW-\u00198\u0002\u0019\u0019\f\u0017\u000e\\(o\u000bJ\u0014xN\u001d\u0011\u0002\rqJg.\u001b;?)\u0015Q7\u000e\\7o!\tQ\u0004\u0001C\u0003Y\u0013\u0001\u0007!\fC\u0003_\u0013\u0001\u0007!\fC\u0003a\u0013\u0001\u0007!\fC\u0004c\u0013A\u0005\t\u0019\u00013\u0015\t)\u0004\u0018O\u001d\u0005\u00061*\u0001\rA\u0017\u0005\u0006=*\u0001\rA\u0017\u0005\u0006A*\u0001\rAW\u0001\u0006M&\u00148\u000f^\u0001\u0007g\u0016\u001cwN\u001c3\u0002\u000bQD\u0017N\u001d3\u0002\u0015%t\u0007/\u001e;UsB,7/F\u0001y!\rq\u0015p_\u0005\u0003u^\u00131aU3r!\tax0D\u0001~\u0015\tqx&A\u0003usB,7/C\u0002\u0002\u0002u\u0014\u0001#\u00112tiJ\f7\r\u001e#bi\u0006$\u0016\u0010]3\u0002\u0011\u0011\fG/\u0019+za\u0016,\"!a\u0002\u0011\u0007q\fI!C\u0002\u0002\fu\u0014\u0001\u0002R1uCRK\b/Z\u0001\t]VdG.\u00192mK\u0006aa.\u001e7m'\u00064W-\u0012<bYRA\u00111CA\r\u00037\ti\u0002E\u0002I\u0003+I1!a\u0006J\u0005\r\te.\u001f\u0005\u00071F\u0001\r!a\u0005\t\ry\u000b\u0002\u0019AA\n\u0011\u0019\u0001\u0017\u00031\u0001\u0002\u0014\u0005IAm\\$f]\u000e{G-\u001a\u000b\u0007\u0003G\ty#!\u000f\u0011\t\u0005\u0015\u00121F\u0007\u0003\u0003OQ1!!\u000b,\u0003\u001d\u0019w\u000eZ3hK:LA!!\f\u0002(\tAQ\t\u001f9s\u0007>$W\rC\u0004\u00022I\u0001\r!a\r\u0002\u0007\r$\b\u0010\u0005\u0003\u0002&\u0005U\u0012\u0002BA\u001c\u0003O\u0011abQ8eK\u001e,gnQ8oi\u0016DH\u000fC\u0004\u0002<I\u0001\r!a\t\u0002\u0005\u00154\u0018A\u00039sKR$\u0018PT1nKV\u0011\u0011\u0011\t\t\u0005\u0003\u0007\nYE\u0004\u0003\u0002F\u0005\u001d\u0003C\u0001)J\u0013\r\tI%S\u0001\u0007!J,G-\u001a4\n\t\u00055\u0013q\n\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005%\u0013*A\fxSRDg*Z<DQ&dGM]3o\u0013:$XM\u001d8bYR9!.!\u0016\u0002Z\u0005u\u0003BBA,)\u0001\u0007!,\u0001\u0005oK^4\u0015N]:u\u0011\u0019\tY\u0006\u0006a\u00015\u0006Ia.Z<TK\u000e|g\u000e\u001a\u0005\u0007\u0003?\"\u0002\u0019\u0001.\u0002\u00119,w\u000f\u00165je\u0012\fAaY8qsRI!.!\u001a\u0002h\u0005%\u00141\u000e\u0005\b1V\u0001\n\u00111\u0001[\u0011\u001dqV\u0003%AA\u0002iCq\u0001Y\u000b\u0011\u0002\u0003\u0007!\fC\u0004c+A\u0005\t\u0019\u00013\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011\u0011\u000f\u0016\u00045\u0006M4FAA;!\u0011\t9(!!\u000e\u0005\u0005e$\u0002BA>\u0003{\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005}\u0014*\u0001\u0006b]:|G/\u0019;j_:LA!a!\u0002z\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u001a\u0014AD2paf$C-\u001a4bk2$H\u0005N\u000b\u0003\u0003\u001bS3\u0001ZA:\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u00111\u0013\t\u0005\u0003+\u000by*\u0004\u0002\u0002\u0018*!\u0011\u0011TAN\u0003\u0011a\u0017M\\4\u000b\u0005\u0005u\u0015\u0001\u00026bm\u0006LA!!\u0014\u0002\u0018\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011Q\u0015\t\u0004\u0011\u0006\u001d\u0016bAAU\u0013\n\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u00111CAX\u0011%\t\t\fHA\u0001\u0002\u0004\t)+A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003o\u0003b!!/\u0002@\u0006MQBAA^\u0015\r\ti,S\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAa\u0003w\u0013\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR\u0019A-a2\t\u0013\u0005Ef$!AA\u0002\u0005M\u0011A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$B!a%\u0002N\"I\u0011\u0011W\u0010\u0002\u0002\u0003\u0007\u0011QU\u0001\u0007KF,\u0018\r\\:\u0015\u0007\u0011\f\u0019\u000eC\u0005\u00022\u0002\n\t\u00111\u0001\u0002\u0014!:\u0002!a6\u0002^\u0006}\u00171]As\u0003S\fY/a<\u0002r\u0006U\u0018q\u001f\t\u0004u\u0005e\u0017bAAnW\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017EAAq\u0003\u001d{f)\u0016(D?\"JX-\u0019:-A5|g\u000e\u001e5-A\u0011\f\u00170\u000b\u0011.A\r\u0013X-\u0019;fA\u0011\fG/\u001a\u0011ge>l\u0007%_3be2\u0002Sn\u001c8uQ\u0002\ng\u000e\u001a\u0011eCf\u0004c-[3mINt\u0013!C1sOVlWM\u001c;tC\t\t9/AAT\u0015\u0001\u0002\u0003\u0005I!sOVlWM\u001c;tu)\u0001\u0003\u0005\t\u0011!A)\u0002\u00130Z1sA5\u0002C\u000f[3!s\u0016\f'\u000f\t;pAI,\u0007O]3tK:$H\u0006\t4s_6\u0004\u0013\u0007\t;pAeJ\u0014(\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0016![>tG\u000f\u001b\u0011.AQDW\rI7p]RDWf\u001c4.s\u0016\f'\u000f\t;pAI,\u0007O]3tK:$H\u0006\t4s_6\u0004\u0013\u0007\t\u0015KC:,\u0018M]=*AQ|\u0007%\r\u001a!Q\u0011+7-Z7cKJL#\u0002\t\u0011!A\u0001\u0002#\u0006\t3bs\u0002j\u0003\u0005\u001e5fA\u0011\f\u00170L8g[5|g\u000e\u001e5!i>\u0004#/\u001a9sKN,g\u000e\u001e\u0017!MJ|W\u000eI\u0019!i>\u00043'\r\u0006!A\u0005AQ\r_1na2,7/\t\u0002\u0002n\u0006\t\u0019L\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u00153aE\u001aD\u0006I\u001c-AE*\u0014f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00113aE\u001aT\u0006M\u001c.cUR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006F\r\u00192s1\u0002\u0013g\r\u0017!c%Z$\u0002\t\u0011!A\u0001\u0002\u0003ET+M\u0019*\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~C#\u0007M\u0019:Y\u0001:D\u0006\t(V\u00192K3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t(V\u00192S\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006F\r\u00192s1\u0002#\u0007\f\u00114a%Z$\u0002\t\u0011!A\u0001\u0002\u0003ET+M\u0019*\u0001\u0003%A\u0003he>,\b/\t\u0002\u0002t\u0006qA-\u0019;fi&lWm\u00184v]\u000e\u001c\u0018!B:j]\u000e,\u0017EAA}\u0003\u0015\u0019d\u0006\r\u00181\u0003!i\u0015m[3ECR,\u0007C\u0001\u001e#'\u0015\u0011#\u0011\u0001B\u0007!%\u0011\u0019A!\u0003[5j#'.\u0004\u0002\u0003\u0006)\u0019!qA%\u0002\u000fI,h\u000e^5nK&!!1\u0002B\u0003\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|g\u000e\u000e\t\u0005\u0005\u001f\u0011)\"\u0004\u0002\u0003\u0012)!!1CAN\u0003\tIw.C\u0002W\u0005#!\"!!@\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!a%\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0013)\u0014\tCa\t\u0003&\t\u001d\u0002\"\u0002-&\u0001\u0004Q\u0006\"\u00020&\u0001\u0004Q\u0006\"\u00021&\u0001\u0004Q\u0006b\u00022&!\u0003\u0005\r\u0001Z\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%i\u00059QO\\1qa2LH\u0003\u0002B\u0018\u0005w\u0001R\u0001\u0013B\u0019\u0005kI1Aa\rJ\u0005\u0019y\u0005\u000f^5p]B9\u0001Ja\u000e[5j#\u0017b\u0001B\u001d\u0013\n1A+\u001e9mKRB\u0001B!\u0010(\u0003\u0003\u0005\rA[\u0001\u0004q\u0012\u0002\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$C'\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0003FA!\u0011Q\u0013B$\u0013\u0011\u0011I%a&\u0003\r=\u0013'.Z2u\u0001")
public class MakeDate
extends TernaryExpression
implements ImplicitCastInputTypes,
package.NullIntolerant,
Serializable {
    private final Expression year;
    private final Expression month;
    private final Expression day;
    private final boolean failOnError;

    public static boolean $lessinit$greater$default$4() {
        return MakeDate$.MODULE$.$lessinit$greater$default$4();
    }

    public static Option<Tuple4<Expression, Expression, Expression, Object>> unapply(MakeDate makeDate) {
        return MakeDate$.MODULE$.unapply(makeDate);
    }

    public static boolean apply$default$4() {
        return MakeDate$.MODULE$.apply$default$4();
    }

    public static Function1<Tuple4<Expression, Expression, Expression, Object>, MakeDate> tupled() {
        return MakeDate$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, Function1<Object, MakeDate>>>> curried() {
        return MakeDate$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression year() {
        return this.year;
    }

    public Expression month() {
        return this.month;
    }

    public Expression day() {
        return this.day;
    }

    public boolean failOnError() {
        return this.failOnError;
    }

    @Override
    public Expression first() {
        return this.year();
    }

    @Override
    public Expression second() {
        return this.month();
    }

    @Override
    public Expression third() {
        return this.day();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new IntegerType$[]{IntegerType$.MODULE$, IntegerType$.MODULE$, IntegerType$.MODULE$}));
    }

    @Override
    public DataType dataType() {
        return DateType$.MODULE$;
    }

    @Override
    public boolean nullable() {
        return this.failOnError() ? this.children().exists((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)x$7.nullable())) : true;
    }

    @Override
    public Object nullSafeEval(Object year, Object month, Object day) {
        Integer n;
        try {
            LocalDate ld = LocalDate.of(BoxesRunTime.unboxToInt((Object)year), BoxesRunTime.unboxToInt((Object)month), BoxesRunTime.unboxToInt((Object)day));
            n = BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.localDateToDays(ld));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (!(throwable2 instanceof DateTimeException) || this.failOnError()) {
                throw throwable;
            }
            Object var4_7 = null;
            n = var4_7;
        }
        return n;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String dtu = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(DateTimeUtils$.MODULE$.getClass().getName()), "$");
        String failOnErrorBranch = this.failOnError() ? "throw e;" : new StringBuilder(8).append(ev.isNull()).append(" = true;").toString();
        return this.nullSafeCodeGen(ctx, ev, (Function3<String, String, String, String>)(Function3 & Serializable)(year, month, day) -> new StringBuilder(136).append("\n      try {\n        ").append(ev.value()).append(" = ").append(dtu).append(".localDateToDays(java.time.LocalDate.of(").append((String)year).append(", ").append((String)month).append(", ").append((String)day).append("));\n      } catch (java.time.DateTimeException e) {\n        ").append(failOnErrorBranch).append("\n      }").toString());
    }

    @Override
    public String prettyName() {
        return "make_date";
    }

    @Override
    public MakeDate withNewChildrenInternal(Expression newFirst, Expression newSecond, Expression newThird) {
        return this.copy(newFirst, newSecond, newThird, this.copy$default$4());
    }

    public MakeDate copy(Expression year, Expression month, Expression day, boolean failOnError) {
        return new MakeDate(year, month, day, failOnError);
    }

    public Expression copy$default$1() {
        return this.year();
    }

    public Expression copy$default$2() {
        return this.month();
    }

    public Expression copy$default$3() {
        return this.day();
    }

    public boolean copy$default$4() {
        return this.failOnError();
    }

    @Override
    public String productPrefix() {
        return "MakeDate";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.year();
                break;
            }
            case 1: {
                object = this.month();
                break;
            }
            case 2: {
                object = this.day();
                break;
            }
            case 3: {
                object = BoxesRunTime.boxToBoolean((boolean)this.failOnError());
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof MakeDate;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "year";
                break;
            }
            case 1: {
                string = "month";
                break;
            }
            case 2: {
                string = "day";
                break;
            }
            case 3: {
                string = "failOnError";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof MakeDate)) return false;
        boolean bl = true;
        if (!bl) return false;
        MakeDate makeDate = (MakeDate)x$1;
        if (this.failOnError() != makeDate.failOnError()) return false;
        Expression expression = this.year();
        Expression expression2 = makeDate.year();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.month();
        Expression expression4 = makeDate.month();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.day();
        Expression expression6 = makeDate.day();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!makeDate.canEqual(this)) return false;
        return true;
    }

    public MakeDate(Expression year, Expression month, Expression day, boolean failOnError) {
        this.year = year;
        this.month = month;
        this.day = day;
        this.failOnError = failOnError;
        ExpectsInputTypes.$init$(this);
    }

    public MakeDate(Expression year, Expression month, Expression day) {
        this(year, month, day, SQLConf$.MODULE$.get().ansiEnabled());
    }
}

