/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.HashExpression;
import org.apache.spark.sql.catalyst.expressions.Murmur3Hash$;
import org.apache.spark.sql.catalyst.expressions.Murmur3HashFunction$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.unsafe.hash.Murmur3_x86_32;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(expr1, expr2, ...) - Returns a hash value of the arguments.", examples="\n    Examples:\n      > SELECT _FUNC_('Spark', array(123), 2);\n       -1321691492\n  ", since="2.0.0", group="hash_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005-g\u0001B\u000f\u001f\u0001.B\u0001\"\u0012\u0001\u0003\u0016\u0004%\tA\u0012\u0005\t\u001b\u0002\u0011\t\u0012)A\u0005\u000f\"Aa\n\u0001BK\u0002\u0013\u0005q\n\u0003\u0005Q\u0001\tE\t\u0015!\u00031\u0011\u0015\t\u0006\u0001\"\u0001S\u0011\u0015\t\u0006\u0001\"\u0001W\u0011\u0015I\u0006\u0001\"\u0011[\u0011\u0015\t\u0007\u0001\"\u0011c\u0011\u0015Y\u0007\u0001\"\u0015c\u0011\u0015a\u0007\u0001\"\u0015n\u0011\u0015)\b\u0001\"\u0015w\u0011\u001da\b!!A\u0005\u0002uD\u0011\"!\u0001\u0001#\u0003%\t!a\u0001\t\u0013\u0005e\u0001!%A\u0005\u0002\u0005m\u0001\"CA\u0010\u0001\u0005\u0005I\u0011IA\u0011\u0011!\t\t\u0004AA\u0001\n\u0003y\u0005\"CA\u001a\u0001\u0005\u0005I\u0011AA\u001b\u0011%\tY\u0004AA\u0001\n\u0003\ni\u0004C\u0005\u0002L\u0001\t\t\u0011\"\u0001\u0002N!I\u0011q\u000b\u0001\u0002\u0002\u0013\u0005\u0013\u0011\f\u0005\n\u0003;\u0002\u0011\u0011!C!\u0003?:\u0011\"a!\u001f\u0003\u0003E\t!!\"\u0007\u0011uq\u0012\u0011!E\u0001\u0003\u000fCa!U\f\u0005\u0002\u0005}\u0005\"CAQ/\u0005\u0005IQIAR\u0011%\t)kFA\u0001\n\u0003\u000b9\u000bC\u0005\u0002.^\t\t\u0011\"!\u00020\"I\u0011\u0011Y\f\u0002\u0002\u0013%\u00111\u0019\u0002\f\u001bV\u0014X.\u001e:4\u0011\u0006\u001c\bN\u0003\u0002 A\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\t\t#%\u0001\u0005dCR\fG._:u\u0015\t\u0019C%A\u0002tc2T!!\n\u0014\u0002\u000bM\u0004\u0018M]6\u000b\u0005\u001dB\u0013AB1qC\u000eDWMC\u0001*\u0003\ry'oZ\u0002\u0001'\u0011\u0001AFN\u001d\u0011\u00075r\u0003'D\u0001\u001f\u0013\tycD\u0001\bICNDW\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005E\"T\"\u0001\u001a\u000b\u0003M\nQa]2bY\u0006L!!\u000e\u001a\u0003\u0007%sG\u000f\u0005\u00022o%\u0011\u0001H\r\u0002\b!J|G-^2u!\tQ$I\u0004\u0002<\u0001:\u0011AhP\u0007\u0002{)\u0011aHK\u0001\u0007yI|w\u000e\u001e \n\u0003MJ!!\u0011\u001a\u0002\u000fA\f7m[1hK&\u00111\t\u0012\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0006\u0003\u0003J\n\u0001b\u00195jY\u0012\u0014XM\\\u000b\u0002\u000fB\u0019!\b\u0013&\n\u0005%#%aA*fcB\u0011QfS\u0005\u0003\u0019z\u0011!\"\u0012=qe\u0016\u001c8/[8o\u0003%\u0019\u0007.\u001b7ee\u0016t\u0007%\u0001\u0003tK\u0016$W#\u0001\u0019\u0002\u000bM,W\r\u001a\u0011\u0002\rqJg.\u001b;?)\r\u0019F+\u0016\t\u0003[\u0001AQ!R\u0003A\u0002\u001dCQAT\u0003A\u0002A\"\"aU,\t\u000ba3\u0001\u0019A$\u0002\u0013\u0005\u0014x-^7f]R\u001c\u0018\u0001\u00033bi\u0006$\u0016\u0010]3\u0016\u0003m\u0003\"\u0001X0\u000e\u0003uS!A\u0018\u0012\u0002\u000bQL\b/Z:\n\u0005\u0001l&\u0001\u0003#bi\u0006$\u0016\u0010]3\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-F\u0001d!\t!\u0007N\u0004\u0002fMB\u0011AHM\u0005\u0003OJ\na\u0001\u0015:fI\u00164\u0017BA5k\u0005\u0019\u0019FO]5oO*\u0011qMM\u0001\u0010Q\u0006\u001c\b.\u001a:DY\u0006\u001c8OT1nK\u0006Y1m\\7qkR,\u0007*Y:i)\u0011\u0001dn\u001d;\t\u000b=T\u0001\u0019\u00019\u0002\u000bY\fG.^3\u0011\u0005E\n\u0018B\u0001:3\u0005\r\te.\u001f\u0005\u00063*\u0001\ra\u0017\u0005\u0006\u001d*\u0001\r\u0001M\u0001\u0018o&$\bNT3x\u0007\"LG\u000e\u001a:f]&sG/\u001a:oC2$\"aU<\t\u000ba\\\u0001\u0019A=\u0002\u00179,wo\u00115jY\u0012\u0014XM\u001c\t\u0004uiT\u0015BA>E\u0005)Ie\u000eZ3yK\u0012\u001cV-]\u0001\u0005G>\u0004\u0018\u0010F\u0002T}~Dq!\u0012\u0007\u0011\u0002\u0003\u0007q\tC\u0004O\u0019A\u0005\t\u0019\u0001\u0019\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011Q\u0001\u0016\u0004\u000f\u0006\u001d1FAA\u0005!\u0011\tY!!\u0006\u000e\u0005\u00055!\u0002BA\b\u0003#\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005M!'\u0001\u0006b]:|G/\u0019;j_:LA!a\u0006\u0002\u000e\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011Q\u0004\u0016\u0004a\u0005\u001d\u0011!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002$A!\u0011QEA\u0018\u001b\t\t9C\u0003\u0003\u0002*\u0005-\u0012\u0001\u00027b]\u001eT!!!\f\u0002\t)\fg/Y\u0005\u0004S\u0006\u001d\u0012\u0001\u00049s_\u0012,8\r^!sSRL\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0004a\u0006]\u0002\u0002CA\u001d#\u0005\u0005\t\u0019\u0001\u0019\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\ty\u0004E\u0003\u0002B\u0005\u001d\u0003/\u0004\u0002\u0002D)\u0019\u0011Q\t\u001a\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002J\u0005\r#\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!a\u0014\u0002VA\u0019\u0011'!\u0015\n\u0007\u0005M#GA\u0004C_>dW-\u00198\t\u0011\u0005e2#!AA\u0002A\f!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR!\u00111EA.\u0011!\tI\u0004FA\u0001\u0002\u0004\u0001\u0014AB3rk\u0006d7\u000f\u0006\u0003\u0002P\u0005\u0005\u0004\u0002CA\u001d+\u0005\u0005\t\u0019\u00019)'\u0001\t)'a\u001b\u0002n\u0005E\u00141OA<\u0003s\ni(a \u0011\u00075\n9'C\u0002\u0002jy\u0011Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0002p\u0005\u0011uLR+O\u0007~CS\r\u001f9sc1\u0002S\r\u001f9se1\u0002cF\f\u0018*A5\u0002#+\u001a;ve:\u001c\b%\u0019\u0011iCND\u0007E^1mk\u0016\u0004sN\u001a\u0011uQ\u0016\u0004\u0013M]4v[\u0016tGo\u001d\u0018\u0002\u0011\u0015D\u0018-\u001c9mKN\f#!!\u001e\u0002'*\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~Cse\u00159be.<C\u0006I1se\u0006L\b&\r\u001a4S1\u0002#'K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011![E\u001a$'\r\u001c:cQJ$G\u0003\u0011!\u0003\u0015\u0019\u0018N\\2fC\t\tY(A\u00033]Ar\u0003'A\u0003he>,\b/\t\u0002\u0002\u0002\u0006Q\u0001.Y:i?\u001a,hnY:\u0002\u00175+(/\\;sg!\u000b7\u000f\u001b\t\u0003[]\u0019RaFAE\u0003+\u0003r!a#\u0002\u0012\u001e\u00034+\u0004\u0002\u0002\u000e*\u0019\u0011q\u0012\u001a\u0002\u000fI,h\u000e^5nK&!\u00111SAG\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gN\r\t\u0005\u0003/\u000bi*\u0004\u0002\u0002\u001a*!\u00111TA\u0016\u0003\tIw.C\u0002D\u00033#\"!!\"\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!a\t\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000bM\u000bI+a+\t\u000b\u0015S\u0002\u0019A$\t\u000b9S\u0002\u0019\u0001\u0019\u0002\u000fUt\u0017\r\u001d9msR!\u0011\u0011WA_!\u0015\t\u00141WA\\\u0013\r\t)L\r\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u000bE\nIl\u0012\u0019\n\u0007\u0005m&G\u0001\u0004UkBdWM\r\u0005\t\u0003\u007f[\u0012\u0011!a\u0001'\u0006\u0019\u0001\u0010\n\u0019\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\u0005\u0015\u0007\u0003BA\u0013\u0003\u000fLA!!3\u0002(\t1qJ\u00196fGR\u0004")
public class Murmur3Hash
extends HashExpression<Object>
implements Serializable {
    private final Seq<Expression> children;
    private final int seed;

    public static Option<Tuple2<Seq<Expression>, Object>> unapply(Murmur3Hash murmur3Hash) {
        return Murmur3Hash$.MODULE$.unapply(murmur3Hash);
    }

    public static Function1<Tuple2<Seq<Expression>, Object>, Murmur3Hash> tupled() {
        return Murmur3Hash$.MODULE$.tupled();
    }

    public static Function1<Seq<Expression>, Function1<Object, Murmur3Hash>> curried() {
        return Murmur3Hash$.MODULE$.curried();
    }

    @Override
    public Seq<Expression> children() {
        return this.children;
    }

    @Override
    public int seed() {
        return this.seed;
    }

    @Override
    public DataType dataType() {
        return IntegerType$.MODULE$;
    }

    @Override
    public String prettyName() {
        return "hash";
    }

    @Override
    public String hasherClassName() {
        return Murmur3_x86_32.class.getName();
    }

    @Override
    public int computeHash(Object value, DataType dataType, int seed) {
        return (int)Murmur3HashFunction$.MODULE$.hash(value, dataType, seed);
    }

    @Override
    public Murmur3Hash withNewChildrenInternal(IndexedSeq<Expression> newChildren) {
        return this.copy((Seq<Expression>)newChildren, this.copy$default$2());
    }

    public Murmur3Hash copy(Seq<Expression> children2, int seed) {
        return new Murmur3Hash(children2, seed);
    }

    public Seq<Expression> copy$default$1() {
        return this.children();
    }

    public int copy$default$2() {
        return this.seed();
    }

    @Override
    public String productPrefix() {
        return "Murmur3Hash";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.children();
                break;
            }
            case 1: {
                object = BoxesRunTime.boxToInteger((int)this.seed());
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Murmur3Hash;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "children";
                break;
            }
            case 1: {
                string = "seed";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Murmur3Hash)) return false;
        boolean bl = true;
        if (!bl) return false;
        Murmur3Hash murmur3Hash = (Murmur3Hash)x$1;
        if (this.seed() != murmur3Hash.seed()) return false;
        Seq<Expression> seq = this.children();
        Seq<Expression> seq2 = murmur3Hash.children();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        if (!murmur3Hash.canEqual(this)) return false;
        return true;
    }

    public Murmur3Hash(Seq<Expression> children2, int seed) {
        this.children = children2;
        this.seed = seed;
    }

    public Murmur3Hash(Seq<Expression> arguments) {
        this(arguments, 42);
    }
}

