/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.NonSQLExpression;
import org.apache.spark.sql.catalyst.expressions.SessionWindow$;
import org.apache.spark.sql.catalyst.expressions.Unevaluable;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.trees.TreePattern$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AnyDataType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import scala.Enumeration;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(time_column, gap_duration) - Generates session window given a timestamp specifying column and gap duration.\n      See <a href=\"https://spark.apache.org/docs/latest/structured-streaming-programming-guide.html#types-of-time-windows\">'Types of time windows'</a> in Structured Streaming guide doc for detailed explanation and examples.\n  ", arguments="\n    Arguments:\n      * time_column - The column or the expression to use as the timestamp for windowing by time. The time column must be of TimestampType.\n      * gap_duration - A string specifying the timeout of the session represented as \"interval value\"\n        (See <a href=\"https://spark.apache.org/docs/latest/sql-ref-literals.html#interval-literal\">Interval Literal</a> for more details.) for the fixed gap duration, or\n        an expression which is applied for each input and evaluated to the \"interval value\" for the dynamic gap duration.\n  ", examples="\n    Examples:\n      > SELECT a, session_window.start, session_window.end, count(*) as cnt FROM VALUES ('A1', '2021-01-01 00:00:00'), ('A1', '2021-01-01 00:04:30'), ('A1', '2021-01-01 00:10:00'), ('A2', '2021-01-01 00:01:00') AS tab(a, b) GROUP by a, _FUNC_(b, '5 minutes') ORDER BY a, start;\n        A1\t2021-01-01 00:00:00\t2021-01-01 00:09:30\t2\n        A1\t2021-01-01 00:10:00\t2021-01-01 00:15:00\t1\n        A2\t2021-01-01 00:01:00\t2021-01-01 00:06:00\t1\n      > SELECT a, session_window.start, session_window.end, count(*) as cnt FROM VALUES ('A1', '2021-01-01 00:00:00'), ('A1', '2021-01-01 00:04:30'), ('A1', '2021-01-01 00:10:00'), ('A2', '2021-01-01 00:01:00'), ('A2', '2021-01-01 00:04:30') AS tab(a, b) GROUP by a, _FUNC_(b, CASE WHEN a = 'A1' THEN '5 minutes' WHEN a = 'A2' THEN '1 minute' ELSE '10 minutes' END) ORDER BY a, start;\n        A1\t2021-01-01 00:00:00\t2021-01-01 00:09:30\t2\n        A1\t2021-01-01 00:10:00\t2021-01-01 00:15:00\t1\n        A2\t2021-01-01 00:01:00\t2021-01-01 00:02:00\t1\n        A2\t2021-01-01 00:04:30\t2021-01-01 00:05:30\t1\n  ", group="datetime_funcs", since="3.2.0")
@ScalaSignature(bytes="\u0006\u0005\tEa\u0001B\u0011#\u0001>B\u0001b\u0014\u0001\u0003\u0016\u0004%\t\u0001\u0015\u0005\t#\u0002\u0011\t\u0012)A\u0005a!A!\u000b\u0001BK\u0002\u0013\u0005\u0001\u000b\u0003\u0005T\u0001\tE\t\u0015!\u00031\u0011\u0015!\u0006\u0001\"\u0001V\u0011\u0015I\u0006\u0001\"\u0011[\u0011\u0015q\u0006\u0001\"\u0011`\u0011\u00159\u0007\u0001\"\u0011i\u0011\u001da\u0007A1A\u0005F5Dq!!\u0003\u0001A\u00035a\u000e\u0003\u0006\u0002\f\u0001A)\u0019!C!\u0003\u001bAq!!\u0006\u0001\t\u0003\ni\u0001C\u0004\u0002\u0018\u0001!\t&!\u0007\t\u0013\u0005\u0015\u0002!!A\u0005\u0002\u0005\u001d\u0002\"CA\u0017\u0001E\u0005I\u0011AA\u0018\u0011%\t)\u0005AI\u0001\n\u0003\ty\u0003C\u0005\u0002H\u0001\t\t\u0011\"\u0011\u0002J!I\u00111\f\u0001\u0002\u0002\u0013\u0005\u0011Q\f\u0005\n\u0003K\u0002\u0011\u0011!C\u0001\u0003OB\u0011\"a\u001d\u0001\u0003\u0003%\t%!\u001e\t\u0013\u0005\r\u0005!!A\u0005\u0002\u0005\u0015\u0005\"CAE\u0001\u0005\u0005I\u0011IAF\u0011%\ty\tAA\u0001\n\u0003\n\tjB\u0004\u0002<\nB\t!!0\u0007\r\u0005\u0012\u0003\u0012AA`\u0011\u0019!\u0016\u0004\"\u0001\u0002R\"I\u00111[\rC\u0002\u0013\u0005\u0011\u0011\n\u0005\t\u0003+L\u0002\u0015!\u0003\u0002L!9\u0011q[\r\u0005\u0002\u0005e\u0007\"CAl3\u0005\u0005I\u0011QAw\u0011%\t\u00190GA\u0001\n\u0003\u000b)\u0010C\u0005\u0003\be\t\t\u0011\"\u0003\u0003\n\ti1+Z:tS>tw+\u001b8e_^T!a\t\u0013\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003K\u0019\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003O!\n1a]9m\u0015\tI#&A\u0003ta\u0006\u00148N\u0003\u0002,Y\u00051\u0011\r]1dQ\u0016T\u0011!L\u0001\u0004_J<7\u0001A\n\b\u0001A\"tGO\u001fD!\t\t$'D\u0001#\u0013\t\u0019$E\u0001\u0006FqB\u0014Xm]:j_:\u0004\"!M\u001b\n\u0005Y\u0012#AF%na2L7-\u001b;DCN$\u0018J\u001c9viRK\b/Z:\u0011\u0005EB\u0014BA\u001d#\u0005-)f.\u001a<bYV\f'\r\\3\u0011\u0005EZ\u0014B\u0001\u001f#\u0005AquN\\*R\u0019\u0016C\bO]3tg&|g\u000e\u0005\u0002?\u00036\tqHC\u0001A\u0003\u0015\u00198-\u00197b\u0013\t\u0011uHA\u0004Qe>$Wo\u0019;\u0011\u0005\u0011ceBA#K\u001d\t1\u0015*D\u0001H\u0015\tAe&\u0001\u0004=e>|GOP\u0005\u0002\u0001&\u00111jP\u0001\ba\u0006\u001c7.Y4f\u0013\tieJ\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u0002L\u007f\u0005QA/[7f\u0007>dW/\u001c8\u0016\u0003A\n1\u0002^5nK\u000e{G.^7oA\u0005Yq-\u00199EkJ\fG/[8o\u000319\u0017\r\u001d#ve\u0006$\u0018n\u001c8!\u0003\u0019a\u0014N\\5u}Q\u0019ak\u0016-\u0011\u0005E\u0002\u0001\"B(\u0006\u0001\u0004\u0001\u0004\"\u0002*\u0006\u0001\u0004\u0001\u0014\u0001C2iS2$'/\u001a8\u0016\u0003m\u00032\u0001\u0012/1\u0013\tifJA\u0002TKF\f!\"\u001b8qkR$\u0016\u0010]3t+\u0005\u0001\u0007c\u0001#]CB\u0011!-Z\u0007\u0002G*\u0011AMJ\u0001\u0006if\u0004Xm]\u0005\u0003M\u000e\u0014\u0001#\u00112tiJ\f7\r\u001e#bi\u0006$\u0016\u0010]3\u0002\u0011\u0011\fG/\u0019+za\u0016,\u0012!\u001b\t\u0003E*L!a[2\u0003\u0011\u0011\u000bG/\u0019+za\u0016\fAB\\8eKB\u000bG\u000f^3s]N,\u0012A\u001c\t\u0004\tr{\u0007c\u00019\u0002\u00049\u0011\u0011O \b\u0003ert!a]>\u000f\u0005QThBA;z\u001d\t1\bP\u0004\u0002Go&\tQ&\u0003\u0002,Y%\u0011\u0011FK\u0005\u0003O!J!!\n\u0014\n\u0005u$\u0013!\u0002;sK\u0016\u001c\u0018bA@\u0002\u0002\u0005YAK]3f!\u0006$H/\u001a:o\u0015\tiH%\u0003\u0003\u0002\u0006\u0005\u001d!a\u0003+sK\u0016\u0004\u0016\r\u001e;fe:T1a`A\u0001\u00035qw\u000eZ3QCR$XM\u001d8tA\u0005A!/Z:pYZ,G-\u0006\u0002\u0002\u0010A\u0019a(!\u0005\n\u0007\u0005MqHA\u0004C_>dW-\u00198\u0002\u00119,H\u000e\\1cY\u0016\fqc^5uQ:+wo\u00115jY\u0012\u0014XM\\%oi\u0016\u0014h.\u00197\u0015\u0007A\nY\u0002C\u0004\u0002\u001e5\u0001\r!a\b\u0002\u00179,wo\u00115jY\u0012\u0014XM\u001c\t\u0005\t\u0006\u0005\u0002'C\u0002\u0002$9\u0013!\"\u00138eKb,GmU3r\u0003\u0011\u0019w\u000e]=\u0015\u000bY\u000bI#a\u000b\t\u000f=s\u0001\u0013!a\u0001a!9!K\u0004I\u0001\u0002\u0004\u0001\u0014AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003cQ3\u0001MA\u001aW\t\t)\u0004\u0005\u0003\u00028\u0005\u0005SBAA\u001d\u0015\u0011\tY$!\u0010\u0002\u0013Ut7\r[3dW\u0016$'bAA \u007f\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\r\u0013\u0011\b\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005-\u0003\u0003BA'\u0003/j!!a\u0014\u000b\t\u0005E\u00131K\u0001\u0005Y\u0006twM\u0003\u0002\u0002V\u0005!!.\u0019<b\u0013\u0011\tI&a\u0014\u0003\rM#(/\u001b8h\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\ty\u0006E\u0002?\u0003CJ1!a\u0019@\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\tI'a\u001c\u0011\u0007y\nY'C\u0002\u0002n}\u00121!\u00118z\u0011%\t\thEA\u0001\u0002\u0004\ty&A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003o\u0002b!!\u001f\u0002\u0000\u0005%TBAA>\u0015\r\tihP\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAA\u0003w\u0012\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u0011qBAD\u0011%\t\t(FA\u0001\u0002\u0004\tI'\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003BA&\u0003\u001bC\u0011\"!\u001d\u0017\u0003\u0003\u0005\r!a\u0018\u0002\r\u0015\fX/\u00197t)\u0011\ty!a%\t\u0013\u0005Et#!AA\u0002\u0005%\u0004f\u0006\u0001\u0002\u0018\u0006u\u0015qTAR\u0003K\u000bI+a+\u00020\u0006E\u0016QWA\\!\r\t\u0014\u0011T\u0005\u0004\u00037\u0013#!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0003C\u000b!Q\u0017\u0006!A\u0001\u0002sLR+O\u0007~CC/[7f?\u000e|G.^7oY\u0001:\u0017\r]0ekJ\fG/[8oS\u0001j\u0003eR3oKJ\fG/Z:!g\u0016\u001c8/[8oA]Lg\u000eZ8xA\u001dLg/\u001a8!C\u0002\"\u0018.\\3ti\u0006l\u0007\u000fI:qK\u000eLg-_5oO\u0002\u001aw\u000e\\;n]\u0002\ng\u000e\u001a\u0011hCB\u0004C-\u001e:bi&|gN\f\u0006!A\u0001\u0002\u0003\u0005I*fK\u0002b\u0014\r\t5sK\u001al$\u0005\u001b;uaNTtfL:qCJ\\g&\u00199bG\",gf\u001c:h_\u0011|7m]\u0018mCR,7\u000f^\u0018tiJ,8\r^;sK\u0012l3\u000f\u001e:fC6LgnZ\u0017qe><'/Y7nS:<WfZ;jI\u0016t\u0003\u000e^7mGQL\b/Z:._\u001alC/[7f[]Lg\u000eZ8xg\nrt\u0005V=qKN\u0004sN\u001a\u0011uS6,\u0007e^5oI><8o\n\u001f0Cz\u0002\u0013N\u001c\u0011TiJ,8\r^;sK\u0012\u00043\u000b\u001e:fC6Lgn\u001a\u0011hk&$W\r\t3pG\u00022wN\u001d\u0011eKR\f\u0017\u000e\\3eA\u0015D\b\u000f\\1oCRLwN\u001c\u0011b]\u0012\u0004S\r_1na2,7O\f\u0006!A\u0005I\u0011M]4v[\u0016tGo]\u0011\u0003\u0003O\u000bA\u0011\u000b\u0006!A\u0001\u0002\u0013I]4v[\u0016tGo\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011+AQLW.Z0d_2,XN\u001c\u0011.AQCW\rI2pYVlg\u000eI8sAQDW\rI3yaJ,7o]5p]\u0002\"x\u000eI;tK\u0002\n7\u000f\t;iK\u0002\"\u0018.\\3ti\u0006l\u0007\u000f\t4pe\u0002:\u0018N\u001c3po&tw\r\t2zAQLW.\u001a\u0018!)\",\u0007\u0005^5nK\u0002\u001aw\u000e\\;n]\u0002jWo\u001d;!E\u0016\u0004sN\u001a\u0011US6,7\u000f^1naRK\b/\u001a\u0018\u000bA\u0001\u0002\u0003\u0005\t\u0011+A\u001d\f\u0007o\u00183ve\u0006$\u0018n\u001c8![\u0001\n\u0005e\u001d;sS:<\u0007e\u001d9fG&4\u00170\u001b8hAQDW\r\t;j[\u0016|W\u000f\u001e\u0011pM\u0002\"\b.\u001a\u0011tKN\u001c\u0018n\u001c8!e\u0016\u0004(/Z:f]R,G\rI1tA\tJg\u000e^3sm\u0006d\u0007E^1mk\u0016\u0014#\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0015TK\u0016\u0004C(\u0019\u0011ie\u00164WH\t5uiB\u001c(hL\u0018ta\u0006\u00148NL1qC\u000eDWML8sO>\"wnY:0Y\u0006$Xm\u001d;0gFdWF]3g[1LG/\u001a:bYNt\u0003\u000e^7mG%tG/\u001a:wC2lC.\u001b;fe\u0006d'EP%oi\u0016\u0014h/\u00197!\u0019&$XM]1my=\ng\b\t4pe\u0002jwN]3!I\u0016$\u0018-\u001b7t]%\u0002cm\u001c:!i\",\u0007EZ5yK\u0012\u0004s-\u00199!IV\u0014\u0018\r^5p]2\u0002sN\u001d\u0006!A\u0001\u0002\u0003\u0005\t\u0011!C:\u0004S\r\u001f9sKN\u001c\u0018n\u001c8!o\"L7\r\u001b\u0011jg\u0002\n\u0007\u000f\u001d7jK\u0012\u0004cm\u001c:!K\u0006\u001c\u0007\u000eI5oaV$\b%\u00198eA\u00154\u0018\r\\;bi\u0016$\u0007\u0005^8!i\",\u0007EI5oi\u0016\u0014h/\u00197!m\u0006dW/\u001a\u0012!M>\u0014\b\u0005\u001e5fA\u0011Lh.Y7jG\u0002:\u0017\r\u001d\u0011ekJ\fG/[8o])\u0001\u0003%\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\ti+\u0001E\u001c\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002\nG\u0006I:fgNLwN\\0xS:$wn\u001e\u0018ti\u0006\u0014H\u000f\f\u0011tKN\u001c\u0018n\u001c8`o&tGm\\</K:$G\u0006I2pk:$\bFK\u0015!CN\u00043M\u001c;!\rJ{U\n\t,B\u0019V+5\u000b\t\u0015(\u0003F:C\u0006I\u00143aI\nT\u0006M\u0019.aE\u0002\u0003\u0007\r\u001e1ai\u0002\u0004gJ\u0015-A!:\u0013)M\u0014-A\u001d\u0012\u0004GM\u0019.aEj\u0003'\r\u00111ai\u0002DGO\u001a1O%b\u0003\u0005K\u0014Bc\u001db\u0003e\n\u001a1eEj\u0003'M\u00171c\u0001\u0002\u0004GO\u00191uA\u0002t%\u000b\u0017!Q\u001d\n%g\n\u0017!OI\u0002$'M\u00171c5\u0002\u0014\u0007\t\u00191uA\n$\b\r\u0019(S\u0001\n5\u000b\t;bE\"\nG\u0006\t2*A\u001d\u0013v*\u0016)!Ef\u0004\u0013\r\f\u0011`\rVs5i\u0018\u0015cY\u0001:S\u0007I7j]V$Xm]\u0014*A=\u0013F)\u0012*!\u0005f\u0003\u0013\r\f\u0011ti\u0006\u0014Ho\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011!\u0003FJ!\u0007\r\u001a2[A\nT\u0006M\u0019!aAR\u0004\u0007\r\u001e1a%\u0011\u0004GM\u0019.aEj\u0003'\r\u00111ai\u0002\u0014HO\u001a1\u0013IR\u0001\u0005\t\u0011!A\u0001\u0002\u0003%Q\u0019\neA\u0012\u0014'\f\u00192[A\n\u0004\u0005\r\u0019;cAR\u0004\u0007M\u00053aI\nT\u0006M\u0019.aE\u0002\u0003\u0007\r\u001e2ki\u0002\u0004'C\u0019\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0005\u0013\u0014B\r\u00193c5\u0002\u0014'\f\u00192AA\u0002$\bM\u0019;aAJ!\u0007\r\u001a2[A\nT\u0006M\u0019!aAR\u0004G\u000e\u001e1a%\t$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI1-AM,7o]5p]~;\u0018N\u001c3po:\u001aH/\u0019:uY\u0001\u001aXm]:j_:|v/\u001b8e_^tSM\u001c3-A\r|WO\u001c;)U%\u0002\u0013m\u001d\u0011d]R\u0004cIU(NAY\u000bE*V#TA!:\u0013)M\u0014-A\u001d\u0012\u0004GM\u0019.aEj\u0003'\r\u00111ai\u0002\u0004G\u000f\u00191O%b\u0003\u0005K\u0014Bc\u001db\u0003e\n\u001a1eEj\u0003'M\u00171c\u0001\u0002\u0004G\u000f\u00195uM\u0002t%\u000b\u0017!Q\u001d\n\u0015g\n\u0017!OI\u0002$'M\u00171c5\u0002\u0014\u0007\t\u00191uE\u0002$\b\r\u0019(S1\u0002\u0003fJ!3O1\u0002sE\r\u00193c5\u0002\u0014'\f\u00192AA\u0002$\bM\u0019;aA:\u0013\u0006\f\u0011)O\u0005\u0013t\u0005\f\u0011(eA\u0012\u0014'\f\u00192[A\n\u0004\u0005\r\u0019;aQR4\u0007M\u0014*A\u0005\u001b\u0006\u0005^1cQ\u0005d\u0003EY\u0015!\u000fJ{U\u000b\u0015\u0011cs\u0002\nG\u0006I0G+:\u001bu\f\u000b2-A\r\u000b5+\u0012\u0011X\u0011\u0016s\u0005%\u0019\u0011>A\u001d\n\u0015g\n\u0011U\u0011\u0016s\u0005eJ\u001b![&tW\u000f^3tO\u0001:\u0006*\u0012(!C\u0002j\u0004eJ!3O\u0001\"\u0006*\u0012(!OE\u0002S.\u001b8vi\u0016<\u0003%\u0012'T\u000b\u0002:\u0013\u0007\r\u0011nS:,H/Z:(A\u0015sE)\u000b\u0011P%\u0012+%\u000b\t\"ZA\u0005d\u0003e\u001d;beR\\$\u0002\t\u0011!A\u0001\u0002\u0003\u0005I!2\u0013I\u0002$'M\u00171c5\u0002\u0014\u0007\t\u00191uA\u0002$\b\r\u0019\neA\u0012\u0014'\f\u00192[A\n\u0004\u0005\r\u0019;aeR4\u0007M\u00053\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\n\u0015'\u0003\u001a1eEj\u0003'M\u00171c\u0001\u0002\u0004GO\u00191uA\u0002\u0014B\r\u00193c5\u0002\u0014'\f\u00192AA\u0002$(M\u001b;aAJ\u0011G\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011Be%\u0011\u0004GM\u0019.aEj\u0003'\r\u00111ai\u0002\u0014G\u000f\u00191\u0013I\u0002$'M\u00171c5\u0002\u0014\u0007\t\u00191uA\u0012$\b\r\u0019\nc)\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0013IM\u00053aI\nT\u0006M\u0019.aE\u0002\u0003\u0007\r\u001e1ii\u001a\u0004'\u0003\u001a1eEj\u0003'M\u00171c\u0001\u0002\u0004G\u000f\u00196uM\u0002\u0014\"\r\u0006!A\u0005)qM]8va\u0006\u0012\u00111W\u0001\u000fI\u0006$X\r^5nK~3WO\\2t\u0003\u0015\u0019\u0018N\\2fC\t\tI,A\u00034]Ir\u0003'A\u0007TKN\u001c\u0018n\u001c8XS:$wn\u001e\t\u0003ce\u0019R!GAa\u0003\u000f\u00042APAb\u0013\r\t)m\u0010\u0002\u0007\u0003:L(+\u001a4\u0011\t\u0005%\u0017qZ\u0007\u0003\u0003\u0017TA!!4\u0002T\u0005\u0011\u0011n\\\u0005\u0004\u001b\u0006-GCAA_\u0003\u0019i\u0017M]6fe\u00069Q.\u0019:lKJ\u0004\u0013!B1qa2LH#\u0002,\u0002\\\u0006u\u0007\"B(\u001e\u0001\u0004\u0001\u0004B\u0002*\u001e\u0001\u0004\ty\u000e\u0005\u0003\u0002b\u0006%h\u0002BAr\u0003K\u0004\"AR \n\u0007\u0005\u001dx(\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u00033\nYOC\u0002\u0002h~\"RAVAx\u0003cDQa\u0014\u0010A\u0002ABQA\u0015\u0010A\u0002A\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002x\n\r\u0001#\u0002 \u0002z\u0006u\u0018bAA~\u007f\t1q\n\u001d;j_:\u0004RAPA\u0000aAJ1A!\u0001@\u0005\u0019!V\u000f\u001d7fe!A!QA\u0010\u0002\u0002\u0003\u0007a+A\u0002yIA\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"Aa\u0003\u0011\t\u00055#QB\u0005\u0005\u0005\u001f\tyE\u0001\u0004PE*,7\r\u001e")
public class SessionWindow
extends Expression
implements ImplicitCastInputTypes,
Unevaluable,
NonSQLExpression,
Serializable {
    private boolean resolved;
    private final Expression timeColumn;
    private final Expression gapDuration;
    private final Seq<Enumeration.Value> nodePatterns;
    private volatile boolean bitmap$0;

    public static Option<Tuple2<Expression, Expression>> unapply(SessionWindow sessionWindow) {
        return SessionWindow$.MODULE$.unapply(sessionWindow);
    }

    public static String marker() {
        return SessionWindow$.MODULE$.marker();
    }

    @Override
    public final String sql() {
        return NonSQLExpression.sql$(this);
    }

    @Override
    public final boolean foldable() {
        return Unevaluable.foldable$(this);
    }

    @Override
    public final Object eval(InternalRow input) {
        return Unevaluable.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return Unevaluable.eval$default$1$(this);
    }

    @Override
    public final ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return Unevaluable.doGenCode$(this, ctx, ev);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression timeColumn() {
        return this.timeColumn;
    }

    public Expression gapDuration() {
        return this.gapDuration;
    }

    @Override
    public Seq<Expression> children() {
        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{this.timeColumn(), this.gapDuration()}));
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{TimestampType$.MODULE$, AnyDataType$.MODULE$}));
    }

    @Override
    public DataType dataType() {
        return new StructType().add(new StructField("start", TimestampType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())).add(new StructField("end", TimestampType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()));
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private boolean resolved$lzycompute() {
        SessionWindow sessionWindow = this;
        synchronized (sessionWindow) {
            if (!this.bitmap$0) {
                this.resolved = false;
                this.bitmap$0 = true;
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        return !this.bitmap$0 ? this.resolved$lzycompute() : this.resolved;
    }

    @Override
    public boolean nullable() {
        return false;
    }

    @Override
    public Expression withNewChildrenInternal(IndexedSeq<Expression> newChildren) {
        return this.copy((Expression)newChildren.apply(0), (Expression)newChildren.apply(1));
    }

    public SessionWindow copy(Expression timeColumn, Expression gapDuration) {
        return new SessionWindow(timeColumn, gapDuration);
    }

    public Expression copy$default$1() {
        return this.timeColumn();
    }

    public Expression copy$default$2() {
        return this.gapDuration();
    }

    @Override
    public String productPrefix() {
        return "SessionWindow";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.timeColumn();
                break;
            }
            case 1: {
                object = this.gapDuration();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof SessionWindow;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "timeColumn";
                break;
            }
            case 1: {
                string = "gapDuration";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof SessionWindow)) return false;
        boolean bl = true;
        if (!bl) return false;
        SessionWindow sessionWindow = (SessionWindow)x$1;
        Expression expression = this.timeColumn();
        Expression expression2 = sessionWindow.timeColumn();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.gapDuration();
        Expression expression4 = sessionWindow.gapDuration();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!sessionWindow.canEqual(this)) return false;
        return true;
    }

    public SessionWindow(Expression timeColumn, Expression gapDuration) {
        this.timeColumn = timeColumn;
        this.gapDuration = gapDuration;
        ExpectsInputTypes.$init$(this);
        Unevaluable.$init$(this);
        NonSQLExpression.$init$(this);
        this.nodePatterns = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Enumeration.Value[]{TreePattern$.MODULE$.SESSION_WINDOW()}));
    }
}

