/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.aggregate;

import org.apache.spark.sql.catalyst.expressions.BinaryArithmetic;
import org.apache.spark.sql.catalyst.expressions.BitwiseOr;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.aggregate.BitAggregate;
import org.apache.spark.sql.catalyst.expressions.aggregate.BitOrAgg$;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(expr) - Returns the bitwise OR of all non-null input values, or null if none.", examples="\n    Examples:\n      > SELECT _FUNC_(col) FROM VALUES (3), (5) AS tab(col);\n       7\n  ", group="agg_funcs", since="3.0.0")
@ScalaSignature(bytes="\u0006\u0005\u0005Ee\u0001B\f\u0019\u0001\u001eB\u0001B\u0010\u0001\u0003\u0016\u0004%\ta\u0010\u0005\t\t\u0002\u0011\t\u0012)A\u0005\u0001\")Q\t\u0001C\u0001\r\")\u0011\n\u0001C!\u0015\")1\u000b\u0001C!)\")A\f\u0001C);\"9\u0001\rAA\u0001\n\u0003\t\u0007bB2\u0001#\u0003%\t\u0001\u001a\u0005\b_\u0002\t\t\u0011\"\u0011q\u0011\u001dA\b!!A\u0005\u0002eDq! \u0001\u0002\u0002\u0013\u0005a\u0010C\u0005\u0002\n\u0001\t\t\u0011\"\u0011\u0002\f!I\u0011\u0011\u0004\u0001\u0002\u0002\u0013\u0005\u00111\u0004\u0005\n\u0003K\u0001\u0011\u0011!C!\u0003OA\u0011\"a\u000b\u0001\u0003\u0003%\t%!\f\b\u0013\u0005E\u0003$!A\t\u0002\u0005Mc\u0001C\f\u0019\u0003\u0003E\t!!\u0016\t\r\u0015\u000bB\u0011AA7\u0011%\ty'EA\u0001\n\u000b\n\t\bC\u0005\u0002tE\t\t\u0011\"!\u0002v!I\u0011\u0011P\t\u0002\u0002\u0013\u0005\u00151\u0010\u0005\n\u0003\u000f\u000b\u0012\u0011!C\u0005\u0003\u0013\u0013\u0001BQ5u\u001fJ\fum\u001a\u0006\u00033i\t\u0011\"Y4he\u0016<\u0017\r^3\u000b\u0005ma\u0012aC3yaJ,7o]5p]NT!!\b\u0010\u0002\u0011\r\fG/\u00197zgRT!a\b\u0011\u0002\u0007M\fHN\u0003\u0002\"E\u0005)1\u000f]1sW*\u00111\u0005J\u0001\u0007CB\f7\r[3\u000b\u0003\u0015\n1a\u001c:h\u0007\u0001\u0019B\u0001\u0001\u0015-eA\u0011\u0011FK\u0007\u00021%\u00111\u0006\u0007\u0002\r\u0005&$\u0018iZ4sK\u001e\fG/\u001a\t\u0003[Aj\u0011A\f\u0006\u0002_\u0005)1oY1mC&\u0011\u0011G\f\u0002\b!J|G-^2u!\t\u00194H\u0004\u00025s9\u0011Q\u0007O\u0007\u0002m)\u0011qGJ\u0001\u0007yI|w\u000e\u001e \n\u0003=J!A\u000f\u0018\u0002\u000fA\f7m[1hK&\u0011A(\u0010\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0006\u0003u9\nQa\u00195jY\u0012,\u0012\u0001\u0011\t\u0003\u0003\nk\u0011AG\u0005\u0003\u0007j\u0011!\"\u0012=qe\u0016\u001c8/[8o\u0003\u0019\u0019\u0007.\u001b7eA\u00051A(\u001b8jiz\"\"a\u0012%\u0011\u0005%\u0002\u0001\"\u0002 \u0004\u0001\u0004\u0001\u0015\u0001\u00038pI\u0016t\u0015-\\3\u0016\u0003-\u0003\"\u0001\u0014)\u000f\u00055s\u0005CA\u001b/\u0013\tye&\u0001\u0004Qe\u0016$WMZ\u0005\u0003#J\u0013aa\u0015;sS:<'BA(/\u0003-\u0011\u0017\u000e^(qKJ\fGo\u001c:\u0015\u0007UC&\f\u0005\u0002B-&\u0011qK\u0007\u0002\u0011\u0005&t\u0017M]=Be&$\b.\\3uS\u000eDQ!W\u0003A\u0002\u0001\u000bA\u0001\\3gi\")1,\u0002a\u0001\u0001\u0006)!/[4ii\u0006!r/\u001b;i\u001d\u0016<8\t[5mI&sG/\u001a:oC2$\"a\u00120\t\u000b}3\u0001\u0019\u0001!\u0002\u00119,wo\u00115jY\u0012\fAaY8qsR\u0011qI\u0019\u0005\b}\u001d\u0001\n\u00111\u0001A\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\u0012!\u001a\u0016\u0003\u0001\u001a\\\u0013a\u001a\t\u0003Q6l\u0011!\u001b\u0006\u0003U.\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u00051t\u0013AC1o]>$\u0018\r^5p]&\u0011a.\u001b\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070F\u0001r!\t\u0011x/D\u0001t\u0015\t!X/\u0001\u0003mC:<'\"\u0001<\u0002\t)\fg/Y\u0005\u0003#N\fA\u0002\u001d:pIV\u001cG/\u0011:jif,\u0012A\u001f\t\u0003[mL!\u0001 \u0018\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\u0007}\f)\u0001E\u0002.\u0003\u0003I1!a\u0001/\u0005\r\te.\u001f\u0005\t\u0003\u000fY\u0011\u0011!a\u0001u\u0006\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!!\u0004\u0011\u000b\u0005=\u0011QC@\u000e\u0005\u0005E!bAA\n]\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005]\u0011\u0011\u0003\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002\u001e\u0005\r\u0002cA\u0017\u0002 %\u0019\u0011\u0011\u0005\u0018\u0003\u000f\t{w\u000e\\3b]\"A\u0011qA\u0007\u0002\u0002\u0003\u0007q0\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,GcA9\u0002*!A\u0011q\u0001\b\u0002\u0002\u0003\u0007!0\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003;\ty\u0003\u0003\u0005\u0002\b=\t\t\u00111\u0001\u0000QM\u0001\u00111GA\u001d\u0003w\ty$!\u0011\u0002F\u0005\u001d\u00131JA'!\r\t\u0015QG\u0005\u0004\u0003oQ\"!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0003{\tAk\u0018$V\u001d\u000e{\u0006&\u001a=qe&\u0002S\u0006\t*fiV\u0014hn\u001d\u0011uQ\u0016\u0004#-\u001b;xSN,\u0007e\u0014*!_\u001a\u0004\u0013\r\u001c7!]>tWF\\;mY\u0002Jg\u000e];uAY\fG.^3tY\u0001z'\u000f\t8vY2\u0004\u0013N\u001a\u0011o_:,g&\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\t\u0019%A,\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\r|G.\u000b\u0011G%>k\u0005EV!M+\u0016\u001b\u0006\u0005K\u001a*Y\u0001BS'\u000b\u0011B'\u0002\"\u0018M\u0019\u0015d_2L3H\u0003\u0011!A\u0001\u0002\u0003\u0005I\u001c\u000bA\u0001\nQa\u001a:pkB\f#!!\u0013\u0002\u0013\u0005<wm\u00184v]\u000e\u001c\u0018!B:j]\u000e,\u0017EAA(\u0003\u0015\u0019d\u0006\r\u00181\u0003!\u0011\u0015\u000e^(s\u0003\u001e<\u0007CA\u0015\u0012'\u0015\t\u0012qKA2!\u0019\tI&a\u0018A\u000f6\u0011\u00111\f\u0006\u0004\u0003;r\u0013a\u0002:v]RLW.Z\u0005\u0005\u0003C\nYFA\tBEN$(/Y2u\rVt7\r^5p]F\u0002B!!\u001a\u0002l5\u0011\u0011q\r\u0006\u0004\u0003S*\u0018AA5p\u0013\ra\u0014q\r\u000b\u0003\u0003'\n\u0001\u0002^8TiJLgn\u001a\u000b\u0002c\u0006)\u0011\r\u001d9msR\u0019q)a\u001e\t\u000by\"\u0002\u0019\u0001!\u0002\u000fUt\u0017\r\u001d9msR!\u0011QPAB!\u0011i\u0013q\u0010!\n\u0007\u0005\u0005eF\u0001\u0004PaRLwN\u001c\u0005\t\u0003\u000b+\u0012\u0011!a\u0001\u000f\u0006\u0019\u0001\u0010\n\u0019\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\u0005-\u0005c\u0001:\u0002\u000e&\u0019\u0011qR:\u0003\r=\u0013'.Z2u\u0001")
public class BitOrAgg
extends BitAggregate {
    private final Expression child;

    public static Option<Expression> unapply(BitOrAgg bitOrAgg) {
        return BitOrAgg$.MODULE$.unapply(bitOrAgg);
    }

    public static <A> Function1<Expression, A> andThen(Function1<BitOrAgg, A> function1) {
        return BitOrAgg$.MODULE$.andThen(function1);
    }

    public static <A$> Function1<A$, BitOrAgg> compose(Function1<A$, Expression> function1) {
        return BitOrAgg$.MODULE$.compose(function1);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public String nodeName() {
        return "bit_or";
    }

    @Override
    public BinaryArithmetic bitOperator(Expression left, Expression right) {
        return new BitwiseOr(left, right);
    }

    @Override
    public BitOrAgg withNewChildInternal(Expression newChild) {
        return this.copy(newChild);
    }

    public BitOrAgg copy(Expression child) {
        return new BitOrAgg(child);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "BitOrAgg";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.child();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof BitOrAgg;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "child";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof BitOrAgg)) return false;
        boolean bl = true;
        if (!bl) return false;
        BitOrAgg bitOrAgg = (BitOrAgg)x$1;
        Expression expression = this.child();
        Expression expression2 = bitOrAgg.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!bitOrAgg.canEqual(this)) return false;
        return true;
    }

    public BitOrAgg(Expression child) {
        this.child = child;
    }
}

