/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.catalyst.expressions.ExprUtils$;
import org.apache.spark.sql.catalyst.json.JSONOptions;
import org.apache.spark.sql.catalyst.json.JacksonUtils$;
import org.apache.spark.sql.catalyst.json.JsonInferSchema$;
import org.apache.spark.sql.catalyst.util.DropMalformedMode$;
import org.apache.spark.sql.catalyst.util.FailFastMode$;
import org.apache.spark.sql.catalyst.util.LegacyDateFormats$;
import org.apache.spark.sql.catalyst.util.ParseMode;
import org.apache.spark.sql.catalyst.util.PermissiveMode$;
import org.apache.spark.sql.catalyst.util.TimestampFormatter;
import org.apache.spark.sql.catalyst.util.TimestampFormatter$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FractionalType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.util.Utils$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuilder;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.control.Exception$;

@ScalaSignature(bytes="\u0006\u0005\u0005uf!B\u000b\u0017\u0001i\u0011\u0003\u0002\u0003\u001c\u0001\u0005\u0003\u0005\u000b\u0011B\u001c\t\u000bm\u0002A\u0011\u0001\u001f\t\u000f}\u0002!\u0019!C\u0005\u0001\"1A\u000b\u0001Q\u0001\n\u0005Cq!\u0016\u0001C\u0002\u0013%a\u000b\u0003\u0004^\u0001\u0001\u0006Ia\u0016\u0005\u0006=\u0002!\ta\u0018\u0005\b\u00037\u0001A\u0011AA\u000f\u0011!\tI\u0003\u0001C\u00011\u0005-raBA\u001d-!\u0005\u00111\b\u0004\u0007+YA\t!!\u0010\t\rmZA\u0011AA%\u0011%\tYe\u0003b\u0001\n\u0003\ti\u0005\u0003\u0005\u0002V-\u0001\u000b\u0011BA(\u0011\u001d\t\u0019h\u0003C\u0001\u0003kBq!a\"\f\t\u0003\tI\tC\u0004\u0002\".!\t!a)\t\u0011\u0005-6\u0002)A\u0005\u0003\u0003Cq!!,\f\t\u0003\ty\u000bC\u0005\u0002:.\t\t\u0011\"\u0003\u0002<\ny!j]8o\u0013:4WM]*dQ\u0016l\u0017M\u0003\u0002\u00181\u0005!!n]8o\u0015\tI\"$\u0001\u0005dCR\fG._:u\u0015\tYB$A\u0002tc2T!!\b\u0010\u0002\u000bM\u0004\u0018M]6\u000b\u0005}\u0001\u0013AB1qC\u000eDWMC\u0001\"\u0003\ry'oZ\n\u0004\u0001\rJ\u0003C\u0001\u0013(\u001b\u0005)#\"\u0001\u0014\u0002\u000bM\u001c\u0017\r\\1\n\u0005!*#AB!osJ+g\r\u0005\u0002+g9\u00111&\r\b\u0003YAj\u0011!\f\u0006\u0003]=\na\u0001\u0010:p_Rt4\u0001A\u0005\u0002M%\u0011!'J\u0001\ba\u0006\u001c7.Y4f\u0013\t!TG\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u00023K\u00059q\u000e\u001d;j_:\u001c\bC\u0001\u001d:\u001b\u00051\u0012B\u0001\u001e\u0017\u0005-Q5k\u0014(PaRLwN\\:\u0002\rqJg.\u001b;?)\tid\b\u0005\u00029\u0001!)aG\u0001a\u0001o\u0005iA-Z2j[\u0006d\u0007+\u0019:tKJ,\u0012!\u0011\t\u0005I\t#E*\u0003\u0002DK\tIa)\u001e8di&|g.\r\t\u0003\u000b&s!AR$\u0011\u00051*\u0013B\u0001%&\u0003\u0019\u0001&/\u001a3fM&\u0011!j\u0013\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005!+\u0003CA'S\u001b\u0005q%BA(Q\u0003\u0011i\u0017\r\u001e5\u000b\u0003E\u000bAA[1wC&\u00111K\u0014\u0002\u000b\u0005&<G)Z2j[\u0006d\u0017A\u00043fG&l\u0017\r\u001c)beN,'\u000fI\u0001\u0013i&lWm\u001d;b[B4uN]7biR,'/F\u0001X!\tA6,D\u0001Z\u0015\tQ\u0006$\u0001\u0003vi&d\u0017B\u0001/Z\u0005I!\u0016.\\3ti\u0006l\u0007OR8s[\u0006$H/\u001a:\u0002'QLW.Z:uC6\u0004hi\u001c:nCR$XM\u001d\u0011\u0002\u000b%tg-\u001a:\u0016\u0005\u0001\u0004HcA1hsB\u0011!-Z\u0007\u0002G*\u0011AMG\u0001\u0006if\u0004Xm]\u0005\u0003M\u000e\u0014!b\u0015;sk\u000e$H+\u001f9f\u0011\u00159r\u00011\u0001i!\rIGN\\\u0007\u0002U*\u00111\u000eH\u0001\u0004e\u0012$\u0017BA7k\u0005\r\u0011F\t\u0012\t\u0003_Bd\u0001\u0001B\u0003r\u000f\t\u0007!OA\u0001U#\t\u0019h\u000f\u0005\u0002%i&\u0011Q/\n\u0002\b\u001d>$\b.\u001b8h!\t!s/\u0003\u0002yK\t\u0019\u0011I\\=\t\u000bi<\u0001\u0019A>\u0002\u0019\r\u0014X-\u0019;f!\u0006\u00148/\u001a:\u0011\r\u0011bhP\\A\u000b\u0013\tiXEA\u0005Gk:\u001cG/[8oeA\u0019q0!\u0005\u000e\u0005\u0005\u0005!\u0002BA\u0002\u0003\u000b\tAaY8sK*!\u0011qAA\u0005\u0003\u001dQ\u0017mY6t_:TA!a\u0003\u0002\u000e\u0005Ia-Y:uKJDX\u000e\u001c\u0006\u0003\u0003\u001f\t1aY8n\u0013\u0011\t\u0019\"!\u0001\u0003\u0017)\u001bxN\u001c$bGR|'/\u001f\t\u0004\u007f\u0006]\u0011\u0002BA\r\u0003\u0003\u0011!BS:p]B\u000b'o]3s\u0003)IgNZ3s\r&,G\u000e\u001a\u000b\u0005\u0003?\t)\u0003E\u0002c\u0003CI1!a\td\u0005!!\u0015\r^1UsB,\u0007bBA\u0014\u0011\u0001\u0007\u0011QC\u0001\u0007a\u0006\u00148/\u001a:\u0002!\r\fgn\u001c8jG\u0006d\u0017N_3UsB,GCBA\u0017\u0003g\t9\u0004E\u0003%\u0003_\ty\"C\u0002\u00022\u0015\u0012aa\u00149uS>t\u0007bBA\u001b\u0013\u0001\u0007\u0011qD\u0001\u0004iB,\u0007\"\u0002\u001c\n\u0001\u00049\u0014a\u0004&t_:LeNZ3s'\u000eDW-\\1\u0011\u0005aZ1\u0003B\u0006$\u0003\u007f\u0001B!!\u0011\u0002H5\u0011\u00111\t\u0006\u0004\u0003\u000b\u0002\u0016AA5p\u0013\r!\u00141\t\u000b\u0003\u0003w\tQc\u001d;sk\u000e$h)[3mI\u000e{W\u000e]1sCR|'/\u0006\u0002\u0002PI1\u0011\u0011KA,\u0003G2a!a\u0015\u000f\u0001\u0005=#\u0001\u0004\u001fsK\u001aLg.Z7f]Rt\u0014AF:ueV\u001cGOR5fY\u0012\u001cu.\u001c9be\u0006$xN\u001d\u0011\u0011\t\u0005e\u0013qL\u0007\u0003\u00037R1!!\u0018Q\u0003\u0011a\u0017M\\4\n\t\u0005\u0005\u00141\f\u0002\u0007\u001f\nTWm\u0019;\u0011\r\u0005\u0015\u0014\u0011NA7\u001b\t\t9G\u0003\u0002[!&!\u00111NA4\u0005)\u0019u.\u001c9be\u0006$xN\u001d\t\u0004E\u0006=\u0014bAA9G\nY1\u000b\u001e:vGR4\u0015.\u001a7e\u0003!I7oU8si\u0016$G\u0003BA<\u0003{\u00022\u0001JA=\u0013\r\tY(\n\u0002\b\u0005>|G.Z1o\u0011\u001d\tyh\u0004a\u0001\u0003\u0003\u000b1!\u0019:s!\u0015!\u00131QA7\u0013\r\t))\n\u0002\u0006\u0003J\u0014\u0018-_\u0001\u0011o&$\bnQ8seV\u0004HOR5fY\u0012$\u0012\"YAF\u0003\u001f\u000b\u0019*a&\t\r\u00055\u0005\u00031\u0001b\u0003\u0019\u0019HO];di\"9\u0011\u0011\u0013\tA\u0002\u0005}\u0011!B8uQ\u0016\u0014\bBBAK!\u0001\u0007A)\u0001\u000ed_2,XN\u001c(b[\u0016|emQ8seV\u0004HOU3d_J$7\u000fC\u0004\u0002\u001aB\u0001\r!a'\u0002\u0013A\f'o]3N_\u0012,\u0007c\u0001-\u0002\u001e&\u0019\u0011qT-\u0003\u0013A\u000b'o]3N_\u0012,\u0017AE2p[B\fG/\u001b2mKJ{w\u000e\u001e+za\u0016$b!!*\u0002(\u0006%\u0006\u0003\u0003\u0013}\u0003?\ty\"a\b\t\r\u0005U\u0015\u00031\u0001E\u0011\u001d\tI*\u0005a\u0001\u00037\u000bQ#Z7qif\u001cFO];di\u001aKW\r\u001c3BeJ\f\u00170\u0001\bd_6\u0004\u0018\r^5cY\u0016$\u0016\u0010]3\u0015\r\u0005}\u0011\u0011WA[\u0011\u001d\t\u0019l\u0005a\u0001\u0003?\t!\u0001^\u0019\t\u000f\u0005]6\u00031\u0001\u0002 \u0005\u0011AOM\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u0003/\u0002")
public class JsonInferSchema
implements Serializable {
    private final JSONOptions options;
    private final Function1<String, BigDecimal> decimalParser;
    private final TimestampFormatter timestampFormatter;

    public static DataType compatibleType(DataType dataType, DataType dataType2) {
        return JsonInferSchema$.MODULE$.compatibleType(dataType, dataType2);
    }

    public static Function2<DataType, DataType, DataType> compatibleRootType(String string, ParseMode parseMode) {
        return JsonInferSchema$.MODULE$.compatibleRootType(string, parseMode);
    }

    public static StructType withCorruptField(StructType structType, DataType dataType, String string, ParseMode parseMode) {
        return JsonInferSchema$.MODULE$.withCorruptField(structType, dataType, string, parseMode);
    }

    public static boolean isSorted(StructField[] structFieldArray) {
        return JsonInferSchema$.MODULE$.isSorted(structFieldArray);
    }

    public static Comparator<StructField> structFieldComparator() {
        return JsonInferSchema$.MODULE$.structFieldComparator();
    }

    private Function1<String, BigDecimal> decimalParser() {
        return this.decimalParser;
    }

    private TimestampFormatter timestampFormatter() {
        return this.timestampFormatter;
    }

    public <T> StructType infer(RDD<T> json, Function2<JsonFactory, T, JsonParser> createParser) {
        ParseMode parseMode = this.options.parseMode();
        String columnNameOfCorruptRecord = this.options.columnNameOfCorruptRecord();
        Function2<DataType, DataType, DataType> typeMerger = JsonInferSchema$.MODULE$.compatibleRootType(columnNameOfCorruptRecord, parseMode);
        RDD mergedTypesFromPartitions = json.mapPartitions((Function1 & Serializable)iter -> {
            JsonFactory factory = $this.options.buildJsonFactory();
            return Option$.MODULE$.option2Iterable(iter.flatMap((Function1 & Serializable)row -> {
                Option option;
                try {
                    option = (Option)Utils$.MODULE$.tryWithResource((Function0 & Serializable)() -> (JsonParser)createParser.apply((Object)factory, row), (Function1 & Serializable)parser -> {
                        parser.nextToken();
                        return new Some((Object)this.inferField((JsonParser)parser));
                    });
                    return option;
                }
                catch (Throwable throwable) {
                    None$ none$;
                    Throwable throwable2 = throwable;
                    boolean bl = throwable2 instanceof RuntimeException ? true : throwable2 instanceof JsonProcessingException;
                    if (!bl) throw throwable;
                    ParseMode parseMode = parseMode;
                    if (PermissiveMode$.MODULE$.equals(parseMode)) {
                        none$ = new Some((Object)StructType$.MODULE$.apply((Seq<StructField>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField(columnNameOfCorruptRecord, StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())})))));
                    } else if (DropMalformedMode$.MODULE$.equals(parseMode)) {
                        none$ = None$.MODULE$;
                    } else {
                        if (!FailFastMode$.MODULE$.equals(parseMode)) throw new MatchError((Object)parseMode);
                        throw QueryExecutionErrors$.MODULE$.malformedRecordsDetectedInSchemaInferenceError(throwable2);
                    }
                    None$ none$2 = none$;
                    option = none$2;
                }
                return option;
            }).reduceOption(typeMerger)).toIterator();
        }, json.mapPartitions$default$2(), ClassTag$.MODULE$.apply(DataType.class));
        SQLConf existingConf = SQLConf$.MODULE$.get();
        ObjectRef rootType = ObjectRef.create((Object)StructType$.MODULE$.apply((Seq<StructField>)package$.MODULE$.Nil()));
        Function1 & Serializable foldPartition = (Function1 & Serializable)iter -> (DataType)iter.fold((Object)StructType$.MODULE$.apply((Seq<StructField>)package$.MODULE$.Nil()), typeMerger);
        Function2 & Serializable mergeResult = (Function2 & Serializable)(index, taskResult) -> {
            rootType.elem = (DataType)SQLConf$.MODULE$.withExistingConf(existingConf, (Function0 & Serializable)() -> (DataType)typeMerger$1.apply((Object)((DataType)rootType$1.elem), (Object)taskResult));
            return BoxedUnit.UNIT;
        };
        json.sparkContext().runJob(mergedTypesFromPartitions, (Function1)foldPartition, (Function2)mergeResult, ClassTag$.MODULE$.apply(DataType.class));
        return (StructType)Option$.MODULE$.option2Iterable(this.canonicalizeType((DataType)rootType.elem, this.options)).find((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)JsonInferSchema.$anonfun$infer$8(x$1))).getOrElse((Function0 & Serializable)() -> StructType$.MODULE$.apply((Seq<StructField>)package$.MODULE$.Nil()));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public DataType inferField(JsonParser parser) {
        void var2_16;
        boolean bl = false;
        JsonToken jsonToken = null;
        JsonToken jsonToken2 = parser.getCurrentToken();
        boolean bl2 = jsonToken2 == null ? true : JsonToken.VALUE_NULL.equals(jsonToken2);
        if (bl2) {
            NullType$ nullType$ = NullType$.MODULE$;
            return var2_16;
        }
        if (JsonToken.FIELD_NAME.equals(jsonToken2)) {
            parser.nextToken();
            DataType dataType = this.inferField(parser);
            return var2_16;
        }
        if (JsonToken.VALUE_STRING.equals(jsonToken2)) {
            bl = true;
            jsonToken = jsonToken2;
            if (parser.getTextLength() < 1) {
                NullType$ nullType$ = NullType$.MODULE$;
                return var2_16;
            }
        }
        if (bl) {
            LazyRef decimalTry$lzy = new LazyRef();
            String field = parser.getText();
            StringType$ stringType$ = this.options.prefersDecimal() && this.decimalTry$1(decimalTry$lzy, field).isDefined() ? (DataType)this.decimalTry$1(decimalTry$lzy, field).get() : (this.options.inferTimestamp() && Exception$.MODULE$.allCatch().opt((Function0)(JFunction0.mcJ.sp & Serializable)() -> this.timestampFormatter().parse(field)).isDefined() ? TimestampType$.MODULE$ : StringType$.MODULE$);
            return var2_16;
        }
        if (JsonToken.START_OBJECT.equals(jsonToken2)) {
            ArrayBuilder builder = Array$.MODULE$.newBuilder(ClassTag$.MODULE$.apply(StructField.class));
            while (true) {
                if (!JacksonUtils$.MODULE$.nextUntil(parser, JsonToken.END_OBJECT)) {
                    StructField[] fields = (StructField[])builder.result();
                    Arrays.sort((Object[])fields, JsonInferSchema$.MODULE$.structFieldComparator());
                    StructType structType = new StructType(fields);
                    return var2_16;
                }
                builder.$plus$eq((Object)new StructField(parser.getCurrentName(), this.inferField(parser), true, StructField$.MODULE$.apply$default$4()));
            }
        }
        if (JsonToken.START_ARRAY.equals(jsonToken2)) {
            NullType$ nullType$ = NullType$.MODULE$;
            while (true) {
                void var20_22;
                if (!JacksonUtils$.MODULE$.nextUntil(parser, JsonToken.END_ARRAY)) {
                    ArrayType arrayType = ArrayType$.MODULE$.apply((DataType)var20_22);
                    return var2_16;
                }
                DataType dataType = JsonInferSchema$.MODULE$.compatibleType((DataType)var20_22, this.inferField(parser));
            }
        }
        boolean bl3 = JsonToken.VALUE_NUMBER_INT.equals(jsonToken2) ? true : JsonToken.VALUE_NUMBER_FLOAT.equals(jsonToken2);
        if (bl3 && this.options.primitivesAsString()) {
            StringType$ stringType$ = StringType$.MODULE$;
            return var2_16;
        }
        boolean bl4 = JsonToken.VALUE_TRUE.equals(jsonToken2) ? true : JsonToken.VALUE_FALSE.equals(jsonToken2);
        if (bl4 && this.options.primitivesAsString()) {
            StringType$ stringType$ = StringType$.MODULE$;
            return var2_16;
        }
        boolean bl5 = JsonToken.VALUE_NUMBER_INT.equals(jsonToken2) ? true : JsonToken.VALUE_NUMBER_FLOAT.equals(jsonToken2);
        if (bl5) {
            void var4_33;
            JsonParser.NumberType numberType = parser.getNumberType();
            boolean bl6 = JsonParser.NumberType.INT.equals(numberType) ? true : JsonParser.NumberType.LONG.equals(numberType);
            if (bl6) {
                LongType$ longType$ = LongType$.MODULE$;
            } else {
                boolean bl7 = JsonParser.NumberType.BIG_INTEGER.equals(numberType) ? true : JsonParser.NumberType.BIG_DECIMAL.equals(numberType);
                if (bl7) {
                    BigDecimal v = parser.getDecimalValue();
                    FractionalType fractionalType = Math.max(v.precision(), v.scale()) <= DecimalType$.MODULE$.MAX_PRECISION() ? new DecimalType(Math.max(v.precision(), v.scale()), v.scale()) : DoubleType$.MODULE$;
                } else {
                    boolean bl8 = JsonParser.NumberType.FLOAT.equals(numberType) ? true : JsonParser.NumberType.DOUBLE.equals(numberType);
                    if (bl8 && this.options.prefersDecimal()) {
                        BigDecimal v = parser.getDecimalValue();
                        FractionalType fractionalType = Math.max(v.precision(), v.scale()) <= DecimalType$.MODULE$.MAX_PRECISION() ? new DecimalType(Math.max(v.precision(), v.scale()), v.scale()) : DoubleType$.MODULE$;
                    } else {
                        boolean bl9 = JsonParser.NumberType.FLOAT.equals(numberType) ? true : JsonParser.NumberType.DOUBLE.equals(numberType);
                        if (!bl9) throw new MatchError((Object)numberType);
                        DoubleType$ doubleType$ = DoubleType$.MODULE$;
                    }
                }
            }
            void var2_14 = var4_33;
            return var2_16;
        }
        boolean bl10 = JsonToken.VALUE_TRUE.equals(jsonToken2) ? true : JsonToken.VALUE_FALSE.equals(jsonToken2);
        if (!bl10) throw QueryExecutionErrors$.MODULE$.malformedJSONError();
        BooleanType$ booleanType$ = BooleanType$.MODULE$;
        return var2_16;
    }

    public Option<DataType> canonicalizeType(DataType tpe, JSONOptions options) {
        Object object;
        DataType dataType = tpe;
        if (dataType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType;
            object = this.canonicalizeType(arrayType.elementType(), options).map((Function1 & Serializable)t -> arrayType.copy((DataType)t, arrayType.copy$default$2()));
        } else {
            StructType structType;
            StructField[] fields;
            StructField[] canonicalFields;
            object = dataType instanceof StructType ? (ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])(canonicalFields = (StructField[])ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])(fields = (structType = (StructType)dataType).fields())), (Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$2.name()))))), (Function1 & Serializable)f -> this.canonicalizeType(f.dataType(), options).map((Function1 & Serializable)t -> {
                DataType x$1 = t;
                String x$2 = f.copy$default$1();
                boolean x$3 = f.copy$default$3();
                Metadata x$4 = f.copy$default$4();
                return f.copy(x$2, x$1, x$3, x$4);
            }), ClassTag$.MODULE$.apply(StructField.class))))) ? None$.MODULE$ : new Some((Object)new StructType(canonicalFields))) : (NullType$.MODULE$.equals(dataType) ? (options.dropFieldIfAllNull() ? None$.MODULE$ : new Some((Object)StringType$.MODULE$)) : new Some((Object)dataType));
        }
        return object;
    }

    public static final /* synthetic */ boolean $anonfun$infer$8(DataType x$1) {
        return x$1 instanceof StructType;
    }

    private final /* synthetic */ Option decimalTry$lzycompute$1(LazyRef decimalTry$lzy$1, String field$1) {
        Option option;
        LazyRef lazyRef = decimalTry$lzy$1;
        synchronized (lazyRef) {
            option = decimalTry$lzy$1.initialized() ? (Option)decimalTry$lzy$1.value() : (Option)decimalTry$lzy$1.initialize((Object)Exception$.MODULE$.allCatch().opt((Function0 & Serializable)() -> {
                BigDecimal bigDecimal = (BigDecimal)this.decimalParser().apply((Object)field$1);
                return new DecimalType(bigDecimal.precision(), bigDecimal.scale());
            }));
        }
        return option;
    }

    private final Option decimalTry$1(LazyRef decimalTry$lzy$1, String field$1) {
        return decimalTry$lzy$1.initialized() ? (Option)decimalTry$lzy$1.value() : this.decimalTry$lzycompute$1(decimalTry$lzy$1, field$1);
    }

    public JsonInferSchema(JSONOptions options) {
        this.options = options;
        this.decimalParser = ExprUtils$.MODULE$.getDecimalParser(options.locale());
        this.timestampFormatter = TimestampFormatter$.MODULE$.apply(options.timestampFormat(), options.zoneId(), options.locale(), LegacyDateFormats$.MODULE$.FAST_DATE_FORMAT(), true);
    }
}

