/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.analysis;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.analysis.CastSupport;
import org.apache.spark.sql.catalyst.analysis.TypeCoercion$;
import org.apache.spark.sql.catalyst.analysis.UnresolvedInlineTable;
import org.apache.spark.sql.catalyst.analysis.package$;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.plans.logical.LocalRelation;
import org.apache.spark.sql.catalyst.plans.logical.LocalRelation$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.rules.Rule;
import org.apache.spark.sql.catalyst.trees.AlwaysProcess$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

public final class ResolveInlineTables$
extends Rule<LogicalPlan>
implements CastSupport {
    public static final ResolveInlineTables$ MODULE$ = new ResolveInlineTables$();

    static {
        CastSupport.$init$(MODULE$);
    }

    @Override
    public Cast cast(Expression child, DataType dataType) {
        return CastSupport.cast$(this, child, dataType);
    }

    @Override
    public LogicalPlan apply(LogicalPlan plan2) {
        return plan2.resolveOperatorsWithPruning(AlwaysProcess$.MODULE$.fn(), this.ruleId(), (PartialFunction<LogicalPlan, LogicalPlan>)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                UnresolvedInlineTable unresolvedInlineTable;
                A1 A1 = x1;
                if (A1 instanceof UnresolvedInlineTable && (unresolvedInlineTable = (UnresolvedInlineTable)A1).expressionsResolved()) {
                    ResolveInlineTables$.MODULE$.validateInputDimension(unresolvedInlineTable);
                    ResolveInlineTables$.MODULE$.validateInputEvaluable(unresolvedInlineTable);
                    object = ResolveInlineTables$.MODULE$.convert(unresolvedInlineTable);
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                UnresolvedInlineTable unresolvedInlineTable;
                LogicalPlan logicalPlan = x1;
                boolean bl = logicalPlan instanceof UnresolvedInlineTable && (unresolvedInlineTable = (UnresolvedInlineTable)logicalPlan).expressionsResolved();
                return bl;
            }
        });
    }

    public void validateInputDimension(UnresolvedInlineTable table) {
        block0: {
            if (!table.rows().nonEmpty()) break block0;
            int numCols = table.names().size();
            ((IterableOnceOps)table.rows().zipWithIndex()).foreach((Function1 & Serializable)x0$1 -> {
                ResolveInlineTables$.$anonfun$validateInputDimension$1(numCols, table, x0$1);
                return BoxedUnit.UNIT;
            });
        }
    }

    public void validateInputEvaluable(UnresolvedInlineTable table) {
        table.rows().foreach((Function1 & Serializable)row -> {
            row.foreach((Function1 & Serializable)e -> {
                ResolveInlineTables$.$anonfun$validateInputEvaluable$2(e);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
    }

    public LocalRelation convert(UnresolvedInlineTable table) {
        Seq fields = (Seq)((IterableOps)((IterableOps)table.rows().transpose(Predef$.MODULE$.$conforms())).zip(table.names())).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Seq column = (Seq)tuple2._1();
            String name = (String)tuple2._2();
            Seq inputTypes = (Seq)column.map((Function1 & Serializable)x$1 -> x$1.dataType());
            DataType tpe = (DataType)TypeCoercion$.MODULE$.findWiderTypeWithoutStringPromotion((Seq<DataType>)inputTypes).getOrElse((Function0 & Serializable)() -> package$.MODULE$.AnalysisErrorAt(table).failAnalysis(new StringBuilder(52).append("incompatible types found in column ").append(name).append(" for inline table").toString()));
            StructField structField = new StructField(name, tpe, column.exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.nullable())), StructField$.MODULE$.apply$default$4());
            return structField;
        });
        Seq<AttributeReference> attributes = StructType$.MODULE$.apply((Seq<StructField>)fields).toAttributes();
        Predef$.MODULE$.assert(fields.size() == table.names().size());
        Seq newRows = (Seq)table.rows().map((Function1 & Serializable)row -> InternalRow$.MODULE$.fromSeq((Seq<Object>)((Seq)((IterableOps)row.zipWithIndex()).map((Function1 & Serializable)x0$2 -> {
            Object object;
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                Expression e = (Expression)tuple2._1();
                int ci = tuple2._2$mcI$sp();
                DataType targetType = ((StructField)fields.apply(ci)).dataType();
                try {
                    Expression castedExpr = e.dataType().sameType(targetType) ? e : MODULE$.cast(e, targetType);
                    object = castedExpr.eval(castedExpr.eval$default$1());
                }
                catch (Throwable throwable) {
                    Option option;
                    Throwable throwable2 = throwable;
                    if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                        Throwable ex = (Throwable)option.get();
                        throw package$.MODULE$.AnalysisErrorAt(table).failAnalysis(new StringBuilder(32).append("failed to evaluate expression ").append(e.sql()).append(": ").append(ex.getMessage()).toString(), ex);
                    }
                    throw throwable;
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            Object object2 = object;
            return object2;
        }))));
        return new LocalRelation(attributes, (Seq<InternalRow>)newRows, LocalRelation$.MODULE$.apply$default$3());
    }

    public static final /* synthetic */ void $anonfun$validateInputDimension$1(int numCols$1, UnresolvedInlineTable table$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Seq row = (Seq)tuple2._1();
            int ri = tuple2._2$mcI$sp();
            if (row.size() != numCols$1) {
                throw package$.MODULE$.AnalysisErrorAt(table$1).failAnalysis(new StringBuilder(44).append("expected ").append(numCols$1).append(" columns but found ").append(row.size()).append(" columns in row ").append(ri).toString());
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$validateInputEvaluable$2(Expression e) {
        if (!e.resolved() || !e.foldable()) {
            throw package$.MODULE$.AnalysisErrorAt(e).failAnalysis(new StringBuilder(54).append("cannot evaluate expression ").append(e.sql()).append(" in inline table definition").toString());
        }
    }

    private ResolveInlineTables$() {
    }
}

