/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.analysis.TypeCoercion$;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ElementAt$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.GetArrayItemUtil;
import org.apache.spark.sql.catalyst.expressions.GetMapValueUtil;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.SupportQueryContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.IntegralType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.MapType$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(array, index) - Returns element of array at given (1-based) index. If Index is 0,\n      Spark will throw an error. If index < 0, accesses elements from the last to the first.\n      The function returns NULL if the index exceeds the length of the array and\n      `spark.sql.ansi.enabled` is set to false.\n      If `spark.sql.ansi.enabled` is set to true, it throws ArrayIndexOutOfBoundsException\n      for invalid indices.\n\n    _FUNC_(map, key) - Returns value for given key. The function returns NULL\n      if the key is not contained in the map and `spark.sql.ansi.enabled` is set to false.\n      If `spark.sql.ansi.enabled` is set to true, it throws NoSuchElementException instead.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(array(1, 2, 3), 2);\n       2\n      > SELECT _FUNC_(map(1, 'a', 2, 'b'), 2);\n       b\n  ", since="2.4.0", group="map_funcs")
@ScalaSignature(bytes="\u0006\u0005\t5f\u0001B\u00193\u0001~B\u0001B\u0019\u0001\u0003\u0016\u0004%\ta\u0019\u0005\tO\u0002\u0011\t\u0012)A\u0005I\"A\u0001\u000e\u0001BK\u0002\u0013\u00051\r\u0003\u0005j\u0001\tE\t\u0015!\u0003e\u0011!Q\u0007A!f\u0001\n\u0003Y\u0007\u0002\u0003:\u0001\u0005#\u0005\u000b\u0011\u00027\t\u0011M\u0004!Q3A\u0005\u0002QD\u0001\u0002\u001f\u0001\u0003\u0012\u0003\u0006I!\u001e\u0005\u0006s\u0002!\tA\u001f\u0005\u0007s\u0002!\t!!\u0001\t\u0015\u0005\u001d\u0001\u0001#b\u0001\n\u0013\tI\u0001C\u0005\u0002 \u0001A)\u0019!C\u0005i\"I\u00111\u0005\u0001\t\u0006\u0004%I\u0001\u001e\u0005\u000b\u0003O\u0001\u0001R1A\u0005\n\u0005%\u0002BCA\u001d\u0001!\u0015\r\u0011\"\u0011\u0002\n!9\u0011Q\b\u0001\u0005B\u0005}\u0002bBA'\u0001\u0011\u0005\u0013q\n\u0005\b\u0003;\u0002A\u0011BA0\u0011\u0019\t\t\b\u0001C!i\"9\u00111\u000f\u0001\u0005B\u0005U\u0004BCA?\u0001!\u0015\r\u0011\"\u0003\u0002\u0000!9\u0011\u0011\u0012\u0001\u0005B\u0005-\u0005bBAT\u0001\u0011\u0005\u0013\u0011\u0016\u0005\b\u0003w\u0003A\u0011KA_\u0011\u001d\t9\r\u0001C!\u0003\u0013D\u0011\"a3\u0001\u0003\u0003%\t!!4\t\u0013\u0005]\u0007!%A\u0005\u0002\u0005e\u0007\"CAx\u0001E\u0005I\u0011AAm\u0011%\t\t\u0010AI\u0001\n\u0003\t\u0019\u0010C\u0005\u0002x\u0002\t\n\u0011\"\u0001\u0002z\"I\u0011Q \u0001\u0002\u0002\u0013\u0005\u0013q \u0005\n\u0005\u001f\u0001\u0011\u0011!C\u0001\u0005#A\u0011Ba\u0005\u0001\u0003\u0003%\tA!\u0006\t\u0013\tm\u0001!!A\u0005B\tu\u0001\"\u0003B\u0016\u0001\u0005\u0005I\u0011\u0001B\u0017\u0011%\u0011\t\u0004AA\u0001\n\u0003\u0012\u0019\u0004C\u0005\u00038\u0001\t\t\u0011\"\u0011\u0003:\u001dI!Q\f\u001a\u0002\u0002#\u0005!q\f\u0004\tcI\n\t\u0011#\u0001\u0003b!1\u0011p\nC\u0001\u0005sB\u0011Ba\u001f(\u0003\u0003%)E! \t\u0013\t}t%!A\u0005\u0002\n\u0005\u0005\"\u0003BFOE\u0005I\u0011AAz\u0011%\u0011iiJI\u0001\n\u0003\tI\u0010C\u0005\u0003\u0010\u001e\n\t\u0011\"!\u0003\u0012\"I!qT\u0014\u0012\u0002\u0013\u0005\u00111\u001f\u0005\n\u0005C;\u0013\u0013!C\u0001\u0003sD\u0011Ba)(\u0003\u0003%IA!*\u0003\u0013\u0015cW-\\3oi\u0006#(BA\u001a5\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005U2\u0014\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005]B\u0014aA:rY*\u0011\u0011HO\u0001\u0006gB\f'o\u001b\u0006\u0003wq\na!\u00199bG\",'\"A\u001f\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000f\u0001\u0001Ei\u0012&R/B\u0011\u0011IQ\u0007\u0002e%\u00111I\r\u0002\u0011\u0005&t\u0017M]=FqB\u0014Xm]:j_:\u0004\"!Q#\n\u0005\u0019\u0013$aD$fi6\u000b\u0007OV1mk\u0016,F/\u001b7\u0011\u0005\u0005C\u0015BA%3\u0005A9U\r^!se\u0006L\u0018\n^3n+RLG\u000e\u0005\u0002L\u001d:\u0011\u0011\tT\u0005\u0003\u001bJ\nq\u0001]1dW\u0006<W-\u0003\u0002P!\nqa*\u001e7m\u0013:$x\u000e\\3sC:$(BA'3!\t\u0011V+D\u0001T\u0015\u0005!\u0016!B:dC2\f\u0017B\u0001,T\u0005\u001d\u0001&o\u001c3vGR\u0004\"\u0001W0\u000f\u0005esfB\u0001.^\u001b\u0005Y&B\u0001/?\u0003\u0019a$o\\8u}%\tA+\u0003\u0002N'&\u0011\u0001-\u0019\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0006\u0003\u001bN\u000bA\u0001\\3giV\tA\r\u0005\u0002BK&\u0011aM\r\u0002\u000b\u000bb\u0004(/Z:tS>t\u0017!\u00027fMR\u0004\u0013!\u0002:jO\"$\u0018A\u0002:jO\"$\b%\u0001\feK\u001a\fW\u000f\u001c;WC2,XmT;u\u001f\u001a\u0014u.\u001e8e+\u0005a\u0007c\u0001*n_&\u0011an\u0015\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005\u0005\u0003\u0018BA93\u0005\u001da\u0015\u000e^3sC2\fq\u0003Z3gCVdGOV1mk\u0016|U\u000f^(g\u0005>,h\u000e\u001a\u0011\u0002\u0017\u0019\f\u0017\u000e\\(o\u000bJ\u0014xN]\u000b\u0002kB\u0011!K^\u0005\u0003oN\u0013qAQ8pY\u0016\fg.\u0001\u0007gC&dwJ\\#se>\u0014\b%\u0001\u0004=S:LGO\u0010\u000b\u0006wrlhp \t\u0003\u0003\u0002AQAY\u0005A\u0002\u0011DQ\u0001[\u0005A\u0002\u0011DqA[\u0005\u0011\u0002\u0003\u0007A\u000eC\u0004t\u0013A\u0005\t\u0019A;\u0015\u000bm\f\u0019!!\u0002\t\u000b\tT\u0001\u0019\u00013\t\u000b!T\u0001\u0019\u00013\u0002\u00155\f\u0007oS3z)f\u0004X-\u0006\u0002\u0002\fA!\u0011QBA\n\u001b\t\tyAC\u0002\u0002\u0012Y\nQ\u0001^=qKNLA!!\u0006\u0002\u0010\tAA)\u0019;b)f\u0004X\rK\u0002\f\u00033\u00012AUA\u000e\u0013\r\tib\u0015\u0002\niJ\fgn]5f]R\fA#\\1q-\u0006dW/Z\"p]R\f\u0017N\\:Ok2d\u0007f\u0001\u0007\u0002\u001a\u0005\t\u0012M\u001d:bs\u000e{g\u000e^1j]NtU\u000f\u001c7)\u00075\tI\"\u0001\u0005pe\u0012,'/\u001b8h+\t\tY\u0003E\u0003Y\u0003[\t\t$C\u0002\u00020\u0005\u0014\u0001b\u0014:eKJLgn\u001a\t\u0004%\u0006M\u0012bAA\u001b'\n\u0019\u0011I\\=)\u00079\tI\"\u0001\u0005eCR\fG+\u001f9fQ\ry\u0011\u0011D\u0001\u000bS:\u0004X\u000f\u001e+za\u0016\u001cXCAA!!\u0015A\u00161IA$\u0013\r\t)%\u0019\u0002\u0004'\u0016\f\b\u0003BA\u0007\u0003\u0013JA!a\u0013\u0002\u0010\t\u0001\u0012IY:ue\u0006\u001cG\u000fR1uCRK\b/Z\u0001\u0014G\",7m[%oaV$H)\u0019;b)f\u0004Xm\u001d\u000b\u0003\u0003#\u0002B!a\u0015\u0002Z5\u0011\u0011Q\u000b\u0006\u0004\u0003/\"\u0014\u0001C1oC2L8/[:\n\t\u0005m\u0013Q\u000b\u0002\u0010)f\u0004Xm\u00115fG.\u0014Vm];mi\u0006Ya.\u001e7mC\nLG.\u001b;z)\u0015)\u0018\u0011MA4\u0011\u001d\t\u0019G\u0005a\u0001\u0003K\n\u0001\"\u001a7f[\u0016tGo\u001d\t\u00051\u0006\rC\rC\u0004\u0002jI\u0001\r!a\u001b\u0002\u000f=\u0014H-\u001b8bYB\u0019!+!\u001c\n\u0007\u0005=4KA\u0002J]R\f\u0001B\\;mY\u0006\u0014G.Z\u0001\r]VdGnU1gK\u00163\u0018\r\u001c\u000b\u0007\u0003c\t9(a\u001f\t\u000f\u0005eD\u00031\u0001\u00022\u0005)a/\u00197vK\"9\u0011\u0011\u000e\u000bA\u0002\u0005E\u0012a\u00033p\u000b2,W.\u001a8u\u0003R,\"!!!\u0011\u0013I\u000b\u0019)!\r\u00022\u0005E\u0012bAAC'\nIa)\u001e8di&|gN\r\u0015\u0004+\u0005e\u0011!\u00033p\u000f\u0016t7i\u001c3f)\u0019\ti)!'\u0002$B!\u0011qRAK\u001b\t\t\tJC\u0002\u0002\u0014J\nqaY8eK\u001e,g.\u0003\u0003\u0002\u0018\u0006E%\u0001C#yaJ\u001cu\u000eZ3\t\u000f\u0005me\u00031\u0001\u0002\u001e\u0006\u00191\r\u001e=\u0011\t\u0005=\u0015qT\u0005\u0005\u0003C\u000b\tJ\u0001\bD_\u0012,w-\u001a8D_:$X\r\u001f;\t\u000f\u0005\u0015f\u00031\u0001\u0002\u000e\u0006\u0011QM^\u0001\u000baJ,G\u000f^=OC6,WCAAV!\u0011\ti+!.\u000f\t\u0005=\u0016\u0011\u0017\t\u00035NK1!a-T\u0003\u0019\u0001&/\u001a3fM&!\u0011qWA]\u0005\u0019\u0019FO]5oO*\u0019\u00111W*\u0002/]LG\u000f\u001b(fo\u000eC\u0017\u000e\u001c3sK:Le\u000e^3s]\u0006dG#B>\u0002@\u0006\r\u0007BBAa1\u0001\u0007A-A\u0004oK^dUM\u001a;\t\r\u0005\u0015\u0007\u00041\u0001e\u0003!qWm\u001e*jO\"$\u0018\u0001E5oSR\fV/\u001a:z\u0007>tG/\u001a=u)\t\tY+\u0001\u0003d_BLH#C>\u0002P\u0006E\u00171[Ak\u0011\u001d\u0011'\u0004%AA\u0002\u0011Dq\u0001\u001b\u000e\u0011\u0002\u0003\u0007A\rC\u0004k5A\u0005\t\u0019\u00017\t\u000fMT\u0002\u0013!a\u0001k\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAAnU\r!\u0017Q\\\u0016\u0003\u0003?\u0004B!!9\u0002l6\u0011\u00111\u001d\u0006\u0005\u0003K\f9/A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011^*\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002n\u0006\r(!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012\u0014AD2paf$C-\u001a4bk2$HeM\u000b\u0003\u0003kT3\u0001\\Ao\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIQ*\"!a?+\u0007U\fi.A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0005\u0003\u0001BAa\u0001\u0003\u000e5\u0011!Q\u0001\u0006\u0005\u0005\u000f\u0011I!\u0001\u0003mC:<'B\u0001B\u0006\u0003\u0011Q\u0017M^1\n\t\u0005]&QA\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003W\na\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u00022\t]\u0001\"\u0003B\rC\u0005\u0005\t\u0019AA6\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011!q\u0004\t\u0007\u0005C\u00119#!\r\u000e\u0005\t\r\"b\u0001B\u0013'\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\t%\"1\u0005\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000eF\u0002v\u0005_A\u0011B!\u0007$\u0003\u0003\u0005\r!!\r\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0005\u0005\u0003\u0011)\u0004C\u0005\u0003\u001a\u0011\n\t\u00111\u0001\u0002l\u00051Q-];bYN$2!\u001eB\u001e\u0011%\u0011I\"JA\u0001\u0002\u0004\t\t\u0004K\n\u0001\u0005\u007f\u0011)Ea\u0012\u0003L\t5#\u0011\u000bB*\u0005/\u0012I\u0006E\u0002B\u0005\u0003J1Aa\u00113\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#A!\u0013\u0002\u000bkR\u0001\u0005\t\u0011!?\u001a+fjQ0)CJ\u0014\u0018-\u001f\u0017!S:$W\r_\u0015![\u0001\u0012V\r^;s]N\u0004S\r\\3nK:$\be\u001c4!CJ\u0014\u0018-\u001f\u0011bi\u0002:\u0017N^3oA!\nTFY1tK\u0012L\u0003%\u001b8eKbt\u0003%\u00134!\u0013:$W\r\u001f\u0011jg\u0002\u0002DF\u0003\u0011!A\u0001\u0002\u0003e\u00159be.\u0004s/\u001b7mAQD'o\\<!C:\u0004SM\u001d:pe:\u0002\u0013J\u001a\u0011j]\u0012,\u0007\u0010\t\u001f!a1\u0002\u0013mY2fgN,7\u000fI3mK6,g\u000e^:!MJ|W\u000e\t;iK\u0002b\u0017m\u001d;!i>\u0004C\u000f[3!M&\u00148\u000f\u001e\u0018\u000bA\u0001\u0002\u0003\u0005\t\u0011UQ\u0016\u0004c-\u001e8di&|g\u000e\t:fiV\u0014hn\u001d\u0011O+2c\u0005%\u001b4!i\",\u0007%\u001b8eKb\u0004S\r_2fK\u0012\u001c\b\u0005\u001e5fA1,gn\u001a;iA=4\u0007\u0005\u001e5fA\u0005\u0014(/Y=!C:$'\u0002\t\u0011!A\u0001\u0002\u0003m\u001d9be.t3/\u001d7/C:\u001c\u0018NL3oC\ndW\r\u001a1!SN\u00043/\u001a;!i>\u0004c-\u00197tK:R\u0001\u0005\t\u0011!A\u0001Je\r\t1ta\u0006\u00148NL:rY:\ngn]5/K:\f'\r\\3eA\u0002J7\u000fI:fi\u0002\"x\u000e\t;sk\u0016d\u0003%\u001b;!i\"\u0014xn^:!\u0003J\u0014\u0018-_%oI\u0016Dx*\u001e;PM\n{WO\u001c3t\u000bb\u001cW\r\u001d;j_:T\u0001\u0005\t\u0011!A\u00012wN\u001d\u0011j]Z\fG.\u001b3!S:$\u0017nY3t])Q\u0001\u0005\t\u0011!?\u001a+fjQ0)[\u0006\u0004H\u0006I6fs&\u0002S\u0006\t*fiV\u0014hn\u001d\u0011wC2,X\r\t4pe\u0002:\u0017N^3oA-,\u0017P\f\u0011UQ\u0016\u0004c-\u001e8di&|g\u000e\t:fiV\u0014hn\u001d\u0011O+2c%\u0002\t\u0011!A\u0001\u0002\u0013N\u001a\u0011uQ\u0016\u00043.Z=!SN\u0004cn\u001c;!G>tG/Y5oK\u0012\u0004\u0013N\u001c\u0011uQ\u0016\u0004S.\u00199!C:$\u0007\u0005Y:qCJ\\gf]9m]\u0005t7/\u001b\u0018f]\u0006\u0014G.\u001a3aA%\u001c\be]3uAQ|\u0007EZ1mg\u0016t#\u0002\t\u0011!A\u0001\u0002\u0013J\u001a\u0011agB\f'o\u001b\u0018tc2t\u0013M\\:j]\u0015t\u0017M\u00197fI\u0002\u0004\u0013n\u001d\u0011tKR\u0004Co\u001c\u0011ueV,G\u0006I5uAQD'o\\<tA9{7+^2i\u000b2,W.\u001a8u\u000bb\u001cW\r\u001d;j_:\u0004\u0013N\\:uK\u0006$gF\u0003\u0011!\u0003!)\u00070Y7qY\u0016\u001c\u0018E\u0001B(\u0003qT\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006&\u0019:sCfD\u0013\u0007\f\u00113Y\u0001\u001a\u0014\u0006\f\u00113SmR\u0001\u0005\t\u0011!A\u0001\u0002#G\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015nCBD\u0013\u0007\f\u0011(C\u001eb\u0003E\r\u0017!O\t<\u0013\u0006\f\u00113SmR\u0001\u0005\t\u0011!A\u0001\u0002#M\u0003\u0011!\u0003\u0015\u0019\u0018N\\2fC\t\u0011)&A\u00033]Qr\u0003'A\u0003he>,\b/\t\u0002\u0003\\\u0005IQ.\u00199`MVt7m]\u0001\n\u000b2,W.\u001a8u\u0003R\u0004\"!Q\u0014\u0014\u000b\u001d\u0012\u0019Ga\u001c\u0011\u0013\t\u0015$1\u000e3eYV\\XB\u0001B4\u0015\r\u0011IgU\u0001\beVtG/[7f\u0013\u0011\u0011iGa\u001a\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>tG\u0007\u0005\u0003\u0003r\t]TB\u0001B:\u0015\u0011\u0011)H!\u0003\u0002\u0005%|\u0017b\u00011\u0003tQ\u0011!qL\u0001\ti>\u001cFO]5oOR\u0011!\u0011A\u0001\u0006CB\u0004H.\u001f\u000b\nw\n\r%Q\u0011BD\u0005\u0013CQA\u0019\u0016A\u0002\u0011DQ\u0001\u001b\u0016A\u0002\u0011DqA\u001b\u0016\u0011\u0002\u0003\u0007A\u000eC\u0004tUA\u0005\t\u0019A;\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uIM\nq\"\u00199qYf$C-\u001a4bk2$H\u0005N\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0011\u0019Ja'\u0011\tIk'Q\u0013\t\b%\n]E\r\u001a7v\u0013\r\u0011Ij\u0015\u0002\u0007)V\u0004H.\u001a\u001b\t\u0011\tuU&!AA\u0002m\f1\u0001\u001f\u00131\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%g\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIQ\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"Aa*\u0011\t\t\r!\u0011V\u0005\u0005\u0005W\u0013)A\u0001\u0004PE*,7\r\u001e")
public class ElementAt
extends BinaryExpression
implements GetMapValueUtil,
GetArrayItemUtil,
package.NullIntolerant {
    private transient DataType mapKeyType;
    private transient boolean mapValueContainsNull;
    private transient boolean arrayContainsNull;
    private transient Ordering<Object> ordering;
    private transient DataType dataType;
    private transient Function2<Object, Object, Object> doElementAt;
    private final Expression left;
    private final Expression right;
    private final Option<Literal> defaultValueOutOfBound;
    private final boolean failOnError;
    private String queryContext;
    private volatile transient byte bitmap$trans$0;

    public static boolean $lessinit$greater$default$4() {
        return ElementAt$.MODULE$.$lessinit$greater$default$4();
    }

    public static Option<Literal> $lessinit$greater$default$3() {
        return ElementAt$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Tuple4<Expression, Expression, Option<Literal>, Object>> unapply(ElementAt x$0) {
        return ElementAt$.MODULE$.unapply(x$0);
    }

    public static boolean apply$default$4() {
        return ElementAt$.MODULE$.apply$default$4();
    }

    public static Option<Literal> apply$default$3() {
        return ElementAt$.MODULE$.apply$default$3();
    }

    public static Function1<Tuple4<Expression, Expression, Option<Literal>, Object>, ElementAt> tupled() {
        return ElementAt$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Option<Literal>, Function1<Object, ElementAt>>>> curried() {
        return ElementAt$.MODULE$.curried();
    }

    @Override
    public boolean computeNullabilityFromArray(Expression child, Expression ordinal, boolean failOnError, Function2<Seq<Expression>, Object, Object> nullability) {
        return GetArrayItemUtil.computeNullabilityFromArray$(this, child, ordinal, failOnError, nullability);
    }

    @Override
    public Object getValueEval(Object value, Object ordinal, DataType keyType, Ordering<Object> ordering, boolean failOnError) {
        return GetMapValueUtil.getValueEval$(this, value, ordinal, keyType, ordering, failOnError);
    }

    @Override
    public ExprCode doGetValueGenCode(CodegenContext ctx, ExprCode ev, MapType mapType, boolean failOnError) {
        return GetMapValueUtil.doGetValueGenCode$(this, ctx, ev, mapType, failOnError);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$catalyst$expressions$SupportQueryContext$$super$copyTagsFrom(Expression other) {
        super.copyTagsFrom(other);
    }

    @Override
    public void copyTagsFrom(Expression other) {
        SupportQueryContext.copyTagsFrom$(this, other);
    }

    @Override
    public String queryContext() {
        return this.queryContext;
    }

    @Override
    public void queryContext_$eq(String x$1) {
        this.queryContext = x$1;
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    public Option<Literal> defaultValueOutOfBound() {
        return this.defaultValueOutOfBound;
    }

    public boolean failOnError() {
        return this.failOnError;
    }

    private DataType mapKeyType$lzycompute() {
        ElementAt elementAt = this;
        synchronized (elementAt) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.mapKeyType = ((MapType)this.left().dataType()).keyType();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.mapKeyType;
    }

    private DataType mapKeyType() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.mapKeyType$lzycompute() : this.mapKeyType;
    }

    private boolean mapValueContainsNull$lzycompute() {
        ElementAt elementAt = this;
        synchronized (elementAt) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.mapValueContainsNull = ((MapType)this.left().dataType()).valueContainsNull();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.mapValueContainsNull;
    }

    private boolean mapValueContainsNull() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.mapValueContainsNull$lzycompute() : this.mapValueContainsNull;
    }

    private boolean arrayContainsNull$lzycompute() {
        ElementAt elementAt = this;
        synchronized (elementAt) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.arrayContainsNull = ((ArrayType)this.left().dataType()).containsNull();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.arrayContainsNull;
    }

    private boolean arrayContainsNull() {
        return (byte)(this.bitmap$trans$0 & 4) == 0 ? this.arrayContainsNull$lzycompute() : this.arrayContainsNull;
    }

    private Ordering<Object> ordering$lzycompute() {
        ElementAt elementAt = this;
        synchronized (elementAt) {
            if ((byte)(this.bitmap$trans$0 & 8) == 0) {
                this.ordering = TypeUtils$.MODULE$.getInterpretedOrdering(this.mapKeyType());
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 8);
            }
        }
        return this.ordering;
    }

    private Ordering<Object> ordering() {
        return (byte)(this.bitmap$trans$0 & 8) == 0 ? this.ordering$lzycompute() : this.ordering;
    }

    private DataType dataType$lzycompute() {
        ElementAt elementAt = this;
        synchronized (elementAt) {
            if ((byte)(this.bitmap$trans$0 & 0x10) == 0) {
                DataType dataType;
                DataType dataType2 = this.left().dataType();
                if (dataType2 instanceof ArrayType) {
                    DataType elementType;
                    ArrayType arrayType = (ArrayType)dataType2;
                    dataType = elementType = arrayType.elementType();
                } else if (dataType2 instanceof MapType) {
                    DataType valueType;
                    MapType mapType = (MapType)dataType2;
                    dataType = valueType = mapType.valueType();
                } else {
                    throw new MatchError((Object)dataType2);
                }
                this.dataType = dataType;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 0x10);
            }
        }
        return this.dataType;
    }

    @Override
    public DataType dataType() {
        return (byte)(this.bitmap$trans$0 & 0x10) == 0 ? this.dataType$lzycompute() : this.dataType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Seq<AbstractDataType> inputTypes() {
        Tuple2 tuple2 = new Tuple2((Object)this.left().dataType(), (Object)this.right().dataType());
        if (tuple2 != null) {
            DataType arr = (DataType)tuple2._1();
            DataType e2 = (DataType)tuple2._2();
            if (arr instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)arr;
                if (e2 instanceof IntegralType) {
                    IntegralType integralType;
                    IntegralType integralType2 = integralType = (IntegralType)e2;
                    LongType$ longType$ = LongType$.MODULE$;
                    if (integralType2 == null ? longType$ != null : !integralType2.equals(longType$)) {
                        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DataType[]{arrayType, IntegerType$.MODULE$}));
                    }
                }
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            DataType e2 = (DataType)tuple2._2();
            if (dataType instanceof MapType) {
                Seq seq;
                MapType mapType = (MapType)dataType;
                DataType keyType = mapType.keyType();
                DataType valueType = mapType.valueType();
                boolean hasNull = mapType.valueContainsNull();
                Option option = (Option)TypeCoercion$.MODULE$.findTightestCommonType().apply((Object)keyType, (Object)e2);
                if (option instanceof Some) {
                    Some some = (Some)option;
                    DataType dt = (DataType)some.value();
                    seq = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DataType[]{new MapType(dt, valueType, hasNull), dt}));
                    return seq;
                } else {
                    seq = (Seq)package$.MODULE$.Seq().empty();
                }
                return seq;
            }
        }
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        return (Seq)package$.MODULE$.Seq().empty();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    public TypeCheckResult checkInputDataTypes() {
        DataType e1;
        void var1_8;
        Tuple2 tuple2 = new Tuple2((Object)this.left().dataType(), (Object)this.right().dataType());
        if (tuple2 != null) {
            DataType e2 = (DataType)tuple2._2();
            if (tuple2._1() instanceof ArrayType) {
                DataType dataType = e2;
                IntegerType$ integerType$ = IntegerType$.MODULE$;
                if (dataType == null ? integerType$ != null : !dataType.equals(integerType$)) {
                    TypeCheckResult.TypeCheckFailure typeCheckFailure = new TypeCheckResult.TypeCheckFailure(new StringBuilder(0).append(new StringBuilder(31).append("Input to function ").append(this.prettyName()).append(" should have ").toString()).append(new StringBuilder(31).append("been ").append(ArrayType$.MODULE$.simpleString()).append(" followed by a ").append(IntegerType$.MODULE$.simpleString()).append(", but it's ").toString()).append(new StringBuilder(5).append("[").append(this.left().dataType().catalogString()).append(", ").append(this.right().dataType().catalogString()).append("].").toString()).toString());
                    return var1_8;
                }
            }
        }
        if (tuple2 != null) {
            MapType mapType;
            DataType e12;
            DataType dataType = (DataType)tuple2._1();
            DataType e2 = (DataType)tuple2._2();
            if (dataType instanceof MapType && !e2.sameType(e12 = (mapType = (MapType)dataType).keyType())) {
                TypeCheckResult.TypeCheckFailure typeCheckFailure = new TypeCheckResult.TypeCheckFailure(new StringBuilder(0).append(new StringBuilder(31).append("Input to function ").append(this.prettyName()).append(" should have ").toString()).append(new StringBuilder(53).append("been ").append(MapType$.MODULE$.simpleString()).append(" followed by a value of same key type, but it's ").toString()).append(new StringBuilder(5).append("[").append(this.left().dataType().catalogString()).append(", ").append(this.right().dataType().catalogString()).append("].").toString()).toString());
                return var1_8;
            }
        }
        if (tuple2 != null && !((e1 = (DataType)tuple2._1()) instanceof MapType) && !(e1 instanceof ArrayType)) {
            TypeCheckResult.TypeCheckFailure typeCheckFailure = new TypeCheckResult.TypeCheckFailure(new StringBuilder(0).append(new StringBuilder(39).append("The first argument to function ").append(this.prettyName()).append(" should ").toString()).append(new StringBuilder(29).append("have been ").append(ArrayType$.MODULE$.simpleString()).append(" or ").append(MapType$.MODULE$.simpleString()).append(" type, but its ").toString()).append(new StringBuilder(6).append(this.left().dataType().catalogString()).append(" type.").toString()).toString());
            return var1_8;
        }
        TypeCheckResult$TypeCheckSuccess$ typeCheckResult$TypeCheckSuccess$ = TypeCheckResult$TypeCheckSuccess$.MODULE$;
        return var1_8;
    }

    private boolean nullability(Seq<Expression> elements, int ordinal) {
        return ordinal == 0 ? false : (elements.length() < scala.math.package$.MODULE$.abs(ordinal) ? !this.failOnError() : (ordinal < 0 ? ((Expression)elements.apply(elements.length() + ordinal)).nullable() : ((Expression)elements.apply(ordinal - 1)).nullable()));
    }

    @Override
    public boolean nullable() {
        boolean bl;
        DataType dataType = this.left().dataType();
        if (dataType instanceof ArrayType) {
            bl = this.computeNullabilityFromArray(this.left(), this.right(), this.failOnError(), (Function2<Seq<Expression>, Object, Object>)(Function2 & Serializable)(elements, ordinal) -> BoxesRunTime.boxToBoolean((boolean)this.nullability((Seq<Expression>)elements, BoxesRunTime.unboxToInt((Object)ordinal))));
        } else if (dataType instanceof MapType) {
            bl = this.failOnError() ? this.mapValueContainsNull() : true;
        } else {
            throw new MatchError((Object)dataType);
        }
        return bl;
    }

    @Override
    public Object nullSafeEval(Object value, Object ordinal) {
        return this.doElementAt().apply(value, ordinal);
    }

    private Function2<Object, Object, Object> doElementAt$lzycompute() {
        ElementAt elementAt = this;
        synchronized (elementAt) {
            if ((byte)(this.bitmap$trans$0 & 0x20) == 0) {
                Function2 & Serializable intersect;
                DataType dataType = this.left().dataType();
                if (dataType instanceof ArrayType) {
                    intersect = (Function2 & Serializable)(value, ordinal) -> {
                        Object object;
                        ArrayData array = (ArrayData)value;
                        int index = BoxesRunTime.unboxToInt((Object)ordinal);
                        if (array.numElements() < scala.math.package$.MODULE$.abs(index)) {
                            Object object2;
                            if (this.failOnError()) {
                                throw QueryExecutionErrors$.MODULE$.invalidElementAtIndexError(index, array.numElements());
                            }
                            Option<Literal> option = this.defaultValueOutOfBound();
                            if (option instanceof Some) {
                                Some some = (Some)option;
                                Literal value2 = (Literal)some.value();
                                object2 = value2.eval(value2.eval$default$1());
                            } else if (None$.MODULE$.equals(option)) {
                                object2 = null;
                            } else {
                                throw new MatchError(option);
                            }
                            object = object2;
                        } else {
                            if (index == 0) {
                                throw QueryExecutionErrors$.MODULE$.sqlArrayIndexNotStartAtOneError();
                            }
                            int idx = index > 0 ? index - 1 : array.numElements() + index;
                            object = this.arrayContainsNull() && array.isNullAt(idx) ? null : array.get(idx, this.dataType());
                        }
                        return object;
                    };
                } else if (dataType instanceof MapType) {
                    intersect = (Function2 & Serializable)(value, ordinal) -> this.getValueEval(value, ordinal, this.mapKeyType(), this.ordering(), this.failOnError());
                } else {
                    throw new MatchError((Object)dataType);
                }
                this.doElementAt = intersect;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 0x20);
            }
        }
        return this.doElementAt;
    }

    private Function2<Object, Object, Object> doElementAt() {
        return (byte)(this.bitmap$trans$0 & 0x20) == 0 ? this.doElementAt$lzycompute() : this.doElementAt;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode exprCode;
        DataType dataType = this.left().dataType();
        if (dataType instanceof ArrayType) {
            exprCode = this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable)(eval1, eval2) -> {
                String string;
                String nullCheck;
                String index = ctx.freshName("elementAtIndex");
                String string2 = nullCheck = this.arrayContainsNull() ? StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(99).append("\n               |if (").append((String)eval1).append(".isNullAt(").append(index).append(")) {\n               |  ").append(ev.isNull()).append(" = true;\n               |} else\n             ").toString())) : "";
                if (this.failOnError()) {
                    string = new StringBuilder(72).append("throw QueryExecutionErrors.invalidElementAtIndexError(").append(index).append(", ").append((String)eval1).append(".numElements());").toString();
                } else {
                    String string3;
                    Option<Literal> option = this.defaultValueOutOfBound();
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        Literal value = (Literal)some.value();
                        ExprCode defaultValueEval = value.genCode(ctx);
                        string3 = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(80).append("\n                  ").append(defaultValueEval.code()).append("\n                  ").append(ev.isNull()).append(" = ").append(defaultValueEval.isNull()).append("\n                  ").append(ev.value()).append(" = ").append(defaultValueEval.value()).append("\n                ").toString()));
                    } else if (None$.MODULE$.equals(option)) {
                        string3 = new StringBuilder(8).append(ev.isNull()).append(" = true;").toString();
                    } else {
                        throw new MatchError(option);
                    }
                    string = string3;
                }
                String indexOutOfBoundBranch = string;
                return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(469).append("\n             |int ").append(index).append(" = (int) ").append((String)eval2).append(";\n             |if (").append((String)eval1).append(".numElements() < Math.abs(").append(index).append(")) {\n             |  ").append(indexOutOfBoundBranch).append("\n             |} else {\n             |  if (").append(index).append(" == 0) {\n             |    throw QueryExecutionErrors.sqlArrayIndexNotStartAtOneError();\n             |  } else if (").append(index).append(" > 0) {\n             |    ").append(index).append("--;\n             |  } else {\n             |    ").append(index).append(" += ").append((String)eval1).append(".numElements();\n             |  }\n             |  ").append(nullCheck).append("\n             |  {\n             |    ").append(ev.value()).append(" = ").append(CodeGenerator$.MODULE$.getValue((String)eval1, this.dataType(), index)).append(";\n             |  }\n             |}\n           ").toString()));
            });
        } else if (dataType instanceof MapType) {
            exprCode = this.doGetValueGenCode(ctx, ev, (MapType)this.left().dataType(), this.failOnError());
        } else {
            throw new MatchError((Object)dataType);
        }
        return exprCode;
    }

    @Override
    public String prettyName() {
        return "element_at";
    }

    @Override
    public ElementAt withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight, this.copy$default$3(), this.copy$default$4());
    }

    @Override
    public String initQueryContext() {
        return this.failOnError() ? this.origin().context() : "";
    }

    public ElementAt copy(Expression left, Expression right, Option<Literal> defaultValueOutOfBound, boolean failOnError) {
        return new ElementAt(left, right, defaultValueOutOfBound, failOnError);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    public Option<Literal> copy$default$3() {
        return this.defaultValueOutOfBound();
    }

    public boolean copy$default$4() {
        return this.failOnError();
    }

    @Override
    public String productPrefix() {
        return "ElementAt";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.left();
                break;
            }
            case 1: {
                object = this.right();
                break;
            }
            case 2: {
                object = this.defaultValueOutOfBound();
                break;
            }
            case 3: {
                object = BoxesRunTime.boxToBoolean((boolean)this.failOnError());
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ElementAt;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "left";
                break;
            }
            case 1: {
                string = "right";
                break;
            }
            case 2: {
                string = "defaultValueOutOfBound";
                break;
            }
            case 3: {
                string = "failOnError";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ElementAt)) return false;
        boolean bl = true;
        if (!bl) return false;
        ElementAt elementAt = (ElementAt)x$1;
        if (this.failOnError() != elementAt.failOnError()) return false;
        Expression expression = this.left();
        Expression expression2 = elementAt.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = elementAt.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Option<Literal> option = this.defaultValueOutOfBound();
        Option<Literal> option2 = elementAt.defaultValueOutOfBound();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!elementAt.canEqual(this)) return false;
        return true;
    }

    public ElementAt(Expression left, Expression right, Option<Literal> defaultValueOutOfBound, boolean failOnError) {
        this.left = left;
        this.right = right;
        this.defaultValueOutOfBound = defaultValueOutOfBound;
        this.failOnError = failOnError;
        ExpectsInputTypes.$init$(this);
        SupportQueryContext.$init$(this);
        GetMapValueUtil.$init$(this);
        GetArrayItemUtil.$init$(this);
    }

    public ElementAt(Expression left, Expression right) {
        this(left, right, (Option<Literal>)None$.MODULE$, SQLConf$.MODULE$.get().ansiEnabled());
    }
}

