/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.GetTimestamp;
import org.apache.spark.sql.catalyst.expressions.GetTimestamp$;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.ParseToDate$;
import org.apache.spark.sql.catalyst.expressions.RuntimeReplaceable;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.trees.TreePattern$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.TypeCollection;
import org.apache.spark.sql.types.TypeCollection$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Product;
import scala.Some;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(date_str[, fmt]) - Parses the `date_str` expression with the `fmt` expression to\n      a date. Returns null with invalid input. By default, it follows casting rules to a date if\n      the `fmt` is omitted.\n  ", arguments="\n    Arguments:\n      * date_str - A string to be parsed to date.\n      * fmt - Date format pattern to follow. See <a href=\"https://spark.apache.org/docs/latest/sql-ref-datetime-pattern.html\">Datetime Patterns</a> for valid\n              date and time format patterns.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('2009-07-30 04:17:52');\n       2009-07-30\n      > SELECT _FUNC_('2016-12-31', 'yyyy-MM-dd');\n       2016-12-31\n  ", group="datetime_funcs", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0005\tub\u0001B\u0013'\u0001NB\u0001b\u0015\u0001\u0003\u0016\u0004%\t\u0001\u0016\u0005\t+\u0002\u0011\t\u0012)A\u0005i!Aa\u000b\u0001BK\u0002\u0013\u0005q\u000b\u0003\u0005\\\u0001\tE\t\u0015!\u0003Y\u0011!a\u0006A!f\u0001\n\u0003i\u0006\u0002C4\u0001\u0005#\u0005\u000b\u0011\u00020\t\u000b!\u0004A\u0011A5\t\u00119\u0004\u0001R1A\u0005BQCQ\u0001\u001b\u0001\u0005\u0002=DQ\u0001\u001b\u0001\u0005\u0002IDQ\u0001\u001e\u0001\u0005BUDQA\u001e\u0001\u0005B]DQ!\u001f\u0001\u0005BiDq!a\n\u0001\t\u0003\nI\u0003C\u0004\u0002.\u0001!\t%a\f\t\u000f\u0005}\u0002\u0001\"\u0015\u0002B!I\u0011Q\n\u0001\u0002\u0002\u0013\u0005\u0011q\n\u0005\n\u0003/\u0002\u0011\u0013!C\u0001\u00033B\u0011\"a\u001c\u0001#\u0003%\t!!\u001d\t\u0013\u0005U\u0004!%A\u0005\u0002\u0005]\u0004\"CA>\u0001\u0005\u0005I\u0011IA?\u0011%\ti\tAA\u0001\n\u0003\ty\tC\u0005\u0002\u0018\u0002\t\t\u0011\"\u0001\u0002\u001a\"I\u0011Q\u0015\u0001\u0002\u0002\u0013\u0005\u0013q\u0015\u0005\n\u0003k\u0003\u0011\u0011!C\u0001\u0003oC\u0011\"!1\u0001\u0003\u0003%\t%a1\t\u0013\u0005\u001d\u0007!!A\u0005B\u0005%w!CAzM\u0005\u0005\t\u0012AA{\r!)c%!A\t\u0002\u0005]\bB\u00025\u001e\t\u0003\u0011y\u0001C\u0005\u0003\u0012u\t\t\u0011\"\u0012\u0003\u0014!I!QC\u000f\u0002\u0002\u0013\u0005%q\u0003\u0005\n\u0005?i\u0012\u0013!C\u0001\u0003oB\u0011B!\t\u001e\u0003\u0003%\tIa\t\t\u0013\tER$%A\u0005\u0002\u0005]\u0004\"\u0003B\u001a;\u0005\u0005I\u0011\u0002B\u001b\u0005-\u0001\u0016M]:f)>$\u0015\r^3\u000b\u0005\u001dB\u0013aC3yaJ,7o]5p]NT!!\u000b\u0016\u0002\u0011\r\fG/\u00197zgRT!a\u000b\u0017\u0002\u0007M\fHN\u0003\u0002.]\u0005)1\u000f]1sW*\u0011q\u0006M\u0001\u0007CB\f7\r[3\u000b\u0003E\n1a\u001c:h\u0007\u0001\u0019r\u0001\u0001\u001b9wy\nu\t\u0005\u00026m5\ta%\u0003\u00028M\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005UJ\u0014B\u0001\u001e'\u0005I\u0011VO\u001c;j[\u0016\u0014V\r\u001d7bG\u0016\f'\r\\3\u0011\u0005Ub\u0014BA\u001f'\u0005YIU\u000e\u001d7jG&$8)Y:u\u0013:\u0004X\u000f\u001e+za\u0016\u001c\bCA\u001b@\u0013\t\u0001eEA\fUS6,'l\u001c8f\u0003^\f'/Z#yaJ,7o]5p]B\u0011!)R\u0007\u0002\u0007*\tA)A\u0003tG\u0006d\u0017-\u0003\u0002G\u0007\n9\u0001K]8ek\u000e$\bC\u0001%Q\u001d\tIeJ\u0004\u0002K\u001b6\t1J\u0003\u0002Me\u00051AH]8pizJ\u0011\u0001R\u0005\u0003\u001f\u000e\u000bq\u0001]1dW\u0006<W-\u0003\u0002R%\na1+\u001a:jC2L'0\u00192mK*\u0011qjQ\u0001\u0005Y\u00164G/F\u00015\u0003\u0015aWM\u001a;!\u0003\u00191wN]7biV\t\u0001\fE\u0002C3RJ!AW\"\u0003\r=\u0003H/[8o\u0003\u001d1wN]7bi\u0002\n!\u0002^5nKj{g.Z%e+\u0005q\u0006c\u0001\"Z?B\u0011\u0001\r\u001a\b\u0003C\n\u0004\"AS\"\n\u0005\r\u001c\u0015A\u0002)sK\u0012,g-\u0003\u0002fM\n11\u000b\u001e:j]\u001eT!aY\"\u0002\u0017QLW.\u001a.p]\u0016LE\rI\u0001\u0007y%t\u0017\u000e\u001e \u0015\t)\\G.\u001c\t\u0003k\u0001AQaU\u0004A\u0002QBQAV\u0004A\u0002aCq\u0001X\u0004\u0011\u0002\u0003\u0007a,A\u0006sKBd\u0017mY3nK:$Hc\u00016qc\")1+\u0003a\u0001i!)a+\u0003a\u0001iQ\u0011!n\u001d\u0005\u0006'*\u0001\r\u0001N\u0001\u000baJ,G\u000f^=OC6,W#A0\u0002\u0019]LG\u000f\u001b+j[\u0016TvN\\3\u0015\u0005yB\b\"\u0002/\r\u0001\u0004y\u0016\u0001\u00068pI\u0016\u0004\u0016\r\u001e;fe:\u001c\u0018J\u001c;fe:\fG\u000eF\u0001|!\rAEP`\u0005\u0003{J\u00131aU3r!\ry\u0018\u0011\u0005\b\u0005\u0003\u0003\tYB\u0004\u0003\u0002\u0004\u0005]a\u0002BA\u0003\u0003+qA!a\u0002\u0002\u00149!\u0011\u0011BA\t\u001d\u0011\tY!a\u0004\u000f\u0007)\u000bi!C\u00012\u0013\ty\u0003'\u0003\u0002.]%\u00111\u0006L\u0005\u0003S)J1!!\u0007)\u0003\u0015!(/Z3t\u0013\u0011\ti\"a\b\u0002\u0017Q\u0013X-\u001a)biR,'O\u001c\u0006\u0004\u00033A\u0013\u0002BA\u0012\u0003K\u00111\u0002\u0016:fKB\u000bG\u000f^3s]*!\u0011QDA\u0010\u0003!\u0019\u0007.\u001b7ee\u0016tWCAA\u0016!\rAE\u0010N\u0001\u000bS:\u0004X\u000f\u001e+za\u0016\u001cXCAA\u0019!\u0011AE0a\r\u0011\t\u0005U\u00121H\u0007\u0003\u0003oQ1!!\u000f+\u0003\u0015!\u0018\u0010]3t\u0013\u0011\ti$a\u000e\u0003!\u0005\u00137\u000f\u001e:bGR$\u0015\r^1UsB,\u0017aF<ji\"tUm^\"iS2$'/\u001a8J]R,'O\\1m)\r!\u00141\t\u0005\b\u0003\u000b\u0002\u0002\u0019AA$\u0003-qWm^\"iS2$'/\u001a8\u0011\t!\u000bI\u0005N\u0005\u0004\u0003\u0017\u0012&AC%oI\u0016DX\rZ*fc\u0006!1m\u001c9z)\u001dQ\u0017\u0011KA*\u0003+BqaU\t\u0011\u0002\u0003\u0007A\u0007C\u0004W#A\u0005\t\u0019\u0001-\t\u000fq\u000b\u0002\u0013!a\u0001=\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA.U\r!\u0014QL\u0016\u0003\u0003?\u0002B!!\u0019\u0002l5\u0011\u00111\r\u0006\u0005\u0003K\n9'A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011N\"\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002n\u0005\r$!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TCAA:U\rA\u0016QL\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134+\t\tIHK\u0002_\u0003;\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA@!\u0011\t\t)a#\u000e\u0005\u0005\r%\u0002BAC\u0003\u000f\u000bA\u0001\\1oO*\u0011\u0011\u0011R\u0001\u0005U\u00064\u0018-C\u0002f\u0003\u0007\u000bA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!!%\u0011\u0007\t\u000b\u0019*C\u0002\u0002\u0016\u000e\u00131!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!a'\u0002\"B\u0019!)!(\n\u0007\u0005}5IA\u0002B]fD\u0011\"a)\u0018\u0003\u0003\u0005\r!!%\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\tI\u000b\u0005\u0004\u0002,\u0006E\u00161T\u0007\u0003\u0003[S1!a,D\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003g\u000biK\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA]\u0003\u007f\u00032AQA^\u0013\r\til\u0011\u0002\b\u0005>|G.Z1o\u0011%\t\u0019+GA\u0001\u0002\u0004\tY*\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003BA@\u0003\u000bD\u0011\"a)\u001b\u0003\u0003\u0005\r!!%\u0002\r\u0015\fX/\u00197t)\u0011\tI,a3\t\u0013\u0005\r6$!AA\u0002\u0005m\u0005f\u0006\u0001\u0002P\u0006U\u0017q[An\u0003;\f\t/a9\u0002h\u0006%\u0018Q^Ax!\r)\u0014\u0011[\u0005\u0004\u0003'4#!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u00033\f\u0011\u0011\u0018\u0006!A\u0001\u0002sLR+O\u0007~CC-\u0019;f?N$(o\u0017\u0017!M6$X,\u000b\u0011.AA\u000b'o]3tAQDW\r\t1eCR,wl\u001d;sA\u0002*\u0007\u0010\u001d:fgNLwN\u001c\u0011xSRD\u0007\u0005\u001e5fA\u00014W\u000e\u001e1!Kb\u0004(/Z:tS>t\u0007\u0005^8\u000bA\u0001\u0002\u0003\u0005\t\u0011bA\u0011\fG/\u001a\u0018!%\u0016$XO\u001d8tA9,H\u000e\u001c\u0011xSRD\u0007%\u001b8wC2LG\rI5oaV$h\u0006\t\"zA\u0011,g-Y;mi2\u0002\u0013\u000e\u001e\u0011g_2dwn^:!G\u0006\u001cH/\u001b8hAI,H.Z:!i>\u0004\u0013\r\t3bi\u0016\u0004\u0013N\u001a\u0006!A\u0001\u0002\u0003\u0005\t;iK\u0002\u0002g-\u001c;aA%\u001c\be\\7jiR,GM\f\u0006!A\u0005I\u0011M]4v[\u0016tGo]\u0011\u0003\u0003?\f!q\u0004\u0006!A\u0001\u0002\u0013I]4v[\u0016tGo\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011+A\u0011\fG/Z0tiJ\u0004S\u0006I!!gR\u0014\u0018N\\4!i>\u0004#-\u001a\u0011qCJ\u001cX\r\u001a\u0011u_\u0002\"\u0017\r^3/\u0015\u0001\u0002\u0003\u0005\t\u0011!U\u00012W\u000e\u001e\u0011.A\u0011\u000bG/\u001a\u0011g_Jl\u0017\r\u001e\u0011qCR$XM\u001d8!i>\u0004cm\u001c7m_^t\u0003eU3fAq\n\u0007\u0005\u001b:fMv\u0012\u0003\u000e\u001e;qgjzsf\u001d9be.t\u0013\r]1dQ\u0016tsN]40I>\u001c7o\f7bi\u0016\u001cHoL:rY6\u0012XMZ\u0017eCR,G/[7f[A\fG\u000f^3s]:BG/\u001c7#}\u0011\u000bG/\u001a;j[\u0016\u0004\u0003+\u0019;uKJt7\u000fP\u0018b}\u00012wN\u001d\u0011wC2LGM\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t3bi\u0016\u0004\u0013M\u001c3!i&lW\r\t4pe6\fG\u000f\t9biR,'O\\:/\u0015\u0001\u0002\u0013\u0001C3yC6\u0004H.Z:\"\u0005\u0005\u0015\u0018!!\f\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001d\u0012\u0004\u0007M\u001d.a]j3\u0007\r\u00111ii\ntGO\u001b3O%Z$\u0002\t\u0011!A\u0001\u0002\u0003E\r\u00191s5\u0002t'L\u001a1\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\":#\u0007M\u00197[E\u0012TfM\u0019(Y\u0001:\u00130_=z[5kU\u0006\u001a3(SmR\u0001\u0005\t\u0011!A\u0001\u0002#\u0007M\u00197[E\u0012TfM\u0019\u000bA\u0001\nQa\u001a:pkB\f#!a;\u0002\u001d\u0011\fG/\u001a;j[\u0016|f-\u001e8dg\u0006)1/\u001b8dK\u0006\u0012\u0011\u0011_\u0001\u0006c9*d\u0006M\u0001\f!\u0006\u00148/\u001a+p\t\u0006$X\r\u0005\u00026;M)Q$!?\u0003\u0006AA\u00111 B\u0001ias&.\u0004\u0002\u0002~*\u0019\u0011q`\"\u0002\u000fI,h\u000e^5nK&!!1AA\u007f\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gn\r\t\u0005\u0005\u000f\u0011i!\u0004\u0002\u0003\n)!!1BAD\u0003\tIw.C\u0002R\u0005\u0013!\"!!>\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!a \u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000f)\u0014IBa\u0007\u0003\u001e!)1\u000b\ta\u0001i!)a\u000b\ta\u00011\"9A\f\tI\u0001\u0002\u0004q\u0016aD1qa2LH\u0005Z3gCVdG\u000fJ\u001a\u0002\u000fUt\u0017\r\u001d9msR!!Q\u0005B\u0017!\u0011\u0011\u0015La\n\u0011\r\t\u0013I\u0003\u000e-_\u0013\r\u0011Yc\u0011\u0002\u0007)V\u0004H.Z\u001a\t\u0011\t=\"%!AA\u0002)\f1\u0001\u001f\u00131\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%g\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u0011!q\u0007\t\u0005\u0003\u0003\u0013I$\u0003\u0003\u0003<\u0005\r%AB(cU\u0016\u001cG\u000f")
public class ParseToDate
extends Expression
implements RuntimeReplaceable,
ImplicitCastInputTypes,
TimeZoneAwareExpression,
Serializable {
    private Expression replacement;
    private final Expression left;
    private final Option<Expression> format;
    private final Option<String> timeZoneId;
    private boolean resolved;
    private Seq<Enumeration.Value> nodePatterns;
    private transient ZoneId zoneId;
    private Expression preCanonicalized;
    private volatile transient boolean bitmap$trans$0;
    private volatile byte bitmap$0;

    public static Option<String> $lessinit$greater$default$3() {
        return ParseToDate$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Tuple3<Expression, Option<Expression>, Option<String>>> unapply(ParseToDate x$0) {
        return ParseToDate$.MODULE$.unapply(x$0);
    }

    public static Option<String> apply$default$3() {
        return ParseToDate$.MODULE$.apply$default$3();
    }

    public static Function1<Tuple3<Expression, Option<Expression>, Option<String>>, ParseToDate> tupled() {
        return ParseToDate$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Option<Expression>, Function1<Option<String>, ParseToDate>>> curried() {
        return ParseToDate$.MODULE$.curried();
    }

    @Override
    public ZoneId zoneIdForType(DataType dataType) {
        return TimeZoneAwareExpression.zoneIdForType$(this, dataType);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public boolean nullable() {
        return RuntimeReplaceable.nullable$(this);
    }

    @Override
    public DataType dataType() {
        return RuntimeReplaceable.dataType$(this);
    }

    @Override
    public final Object eval(InternalRow input) {
        return RuntimeReplaceable.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return RuntimeReplaceable.eval$default$1$(this);
    }

    @Override
    public final ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return RuntimeReplaceable.doGenCode$(this, ctx, ev);
    }

    private boolean resolved$lzycompute() {
        ParseToDate parseToDate = this;
        synchronized (parseToDate) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.resolved = TimeZoneAwareExpression.resolved$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.resolved$lzycompute() : this.resolved;
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private ZoneId zoneId$lzycompute() {
        ParseToDate parseToDate = this;
        synchronized (parseToDate) {
            if (!this.bitmap$trans$0) {
                this.zoneId = TimeZoneAwareExpression.zoneId$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.zoneId;
    }

    @Override
    public ZoneId zoneId() {
        return !this.bitmap$trans$0 ? this.zoneId$lzycompute() : this.zoneId;
    }

    @Override
    public final void org$apache$spark$sql$catalyst$expressions$TimeZoneAwareExpression$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    private Expression preCanonicalized$lzycompute() {
        ParseToDate parseToDate = this;
        synchronized (parseToDate) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.preCanonicalized = RuntimeReplaceable.preCanonicalized$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.preCanonicalized;
    }

    @Override
    public Expression preCanonicalized() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.preCanonicalized$lzycompute() : this.preCanonicalized;
    }

    @Override
    public void org$apache$spark$sql$catalyst$expressions$RuntimeReplaceable$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
    }

    public Expression left() {
        return this.left;
    }

    public Option<Expression> format() {
        return this.format;
    }

    @Override
    public Option<String> timeZoneId() {
        return this.timeZoneId;
    }

    private Expression replacement$lzycompute() {
        ParseToDate parseToDate = this;
        synchronized (parseToDate) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.replacement = (Expression)this.format().map((Function1 & Serializable)f -> new Cast(new GetTimestamp(this.left(), (Expression)f, TimestampType$.MODULE$, this.timeZoneId(), GetTimestamp$.MODULE$.apply$default$5()), DateType$.MODULE$, this.timeZoneId(), Cast$.MODULE$.apply$default$4())).getOrElse((Function0 & Serializable)() -> new Cast(this.left(), DateType$.MODULE$, this.timeZoneId(), Cast$.MODULE$.apply$default$4()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.replacement;
    }

    @Override
    public Expression replacement() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.replacement$lzycompute() : this.replacement;
    }

    @Override
    public String prettyName() {
        return "to_date";
    }

    @Override
    public TimeZoneAwareExpression withTimeZone(String timeZoneId) {
        Some x$1 = new Some((Object)timeZoneId);
        Expression x$2 = this.copy$default$1();
        Option<Expression> x$3 = this.copy$default$2();
        return this.copy(x$2, x$3, (Option<String>)x$1);
    }

    @Override
    public Seq<Enumeration.Value> nodePatternsInternal() {
        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Enumeration.Value[]{TreePattern$.MODULE$.RUNTIME_REPLACEABLE()}));
    }

    @Override
    public Seq<Expression> children() {
        Expression expression = this.left();
        return (Seq)Option$.MODULE$.option2Iterable(this.format()).toSeq().$plus$colon((Object)expression);
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        TypeCollection typeCollection = TypeCollection$.MODULE$.apply((Seq<AbstractDataType>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{StringType$.MODULE$, DateType$.MODULE$, TimestampType$.MODULE$, TimestampNTZType$.MODULE$}));
        return (Seq)Option$.MODULE$.option2Iterable(this.format().map((Function1 & Serializable)x$6 -> StringType$.MODULE$)).toSeq().$plus$colon((Object)typeCollection);
    }

    @Override
    public Expression withNewChildrenInternal(IndexedSeq<Expression> newChildren) {
        return this.format().isDefined() ? this.copy((Expression)newChildren.head(), (Option<Expression>)new Some(newChildren.last()), this.copy$default$3()) : this.copy((Expression)newChildren.head(), this.copy$default$2(), this.copy$default$3());
    }

    public ParseToDate copy(Expression left, Option<Expression> format, Option<String> timeZoneId) {
        return new ParseToDate(left, format, timeZoneId);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Option<Expression> copy$default$2() {
        return this.format();
    }

    public Option<String> copy$default$3() {
        return this.timeZoneId();
    }

    @Override
    public String productPrefix() {
        return "ParseToDate";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.left();
                break;
            }
            case 1: {
                object = this.format();
                break;
            }
            case 2: {
                object = this.timeZoneId();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ParseToDate;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "left";
                break;
            }
            case 1: {
                string = "format";
                break;
            }
            case 2: {
                string = "timeZoneId";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ParseToDate)) return false;
        boolean bl = true;
        if (!bl) return false;
        ParseToDate parseToDate = (ParseToDate)x$1;
        Expression expression = this.left();
        Expression expression2 = parseToDate.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Option<Expression> option = this.format();
        Option<Expression> option2 = parseToDate.format();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Option<String> option3 = this.timeZoneId();
        Option<String> option4 = parseToDate.timeZoneId();
        if (option3 == null) {
            if (option4 != null) {
                return false;
            }
        } else if (!option3.equals(option4)) return false;
        if (!parseToDate.canEqual(this)) return false;
        return true;
    }

    public ParseToDate(Expression left, Option<Expression> format, Option<String> timeZoneId) {
        this.left = left;
        this.format = format;
        this.timeZoneId = timeZoneId;
        RuntimeReplaceable.$init$(this);
        ExpectsInputTypes.$init$(this);
        TimeZoneAwareExpression.$init$(this);
        Statics.releaseFence();
    }

    public ParseToDate(Expression left, Expression format) {
        this(left, (Option<Expression>)Option$.MODULE$.apply((Object)format), ParseToDate$.MODULE$.$lessinit$greater$default$3());
    }

    public ParseToDate(Expression left) {
        this(left, (Option<Expression>)None$.MODULE$, ParseToDate$.MODULE$.$lessinit$greater$default$3());
    }
}

