/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.ParseUrl$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(url, partToExtract[, key]) - Extracts a part from a URL.", examples="\n    Examples:\n      > SELECT _FUNC_('http://spark.apache.org/path?query=1', 'HOST');\n       spark.apache.org\n      > SELECT _FUNC_('http://spark.apache.org/path?query=1', 'QUERY');\n       query=1\n      > SELECT _FUNC_('http://spark.apache.org/path?query=1', 'QUERY', 'query');\n       1\n  ", since="2.0.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0005\tEw!B\u001f?\u0011\u0003Ye!B'?\u0011\u0003q\u0005\"B/\u0002\t\u0003q\u0006bB0\u0002\u0005\u0004%I\u0001\u0019\u0005\u0007S\u0006\u0001\u000b\u0011B1\t\u000f)\f!\u0019!C\u0005A\"11.\u0001Q\u0001\n\u0005Dq\u0001\\\u0001C\u0002\u0013%\u0001\r\u0003\u0004n\u0003\u0001\u0006I!\u0019\u0005\b]\u0006\u0011\r\u0011\"\u0003a\u0011\u0019y\u0017\u0001)A\u0005C\"9\u0001/\u0001b\u0001\n\u0013\u0001\u0007BB9\u0002A\u0003%\u0011\rC\u0004s\u0003\t\u0007I\u0011\u00021\t\rM\f\u0001\u0015!\u0003b\u0011\u001d!\u0018A1A\u0005\n\u0001Da!^\u0001!\u0002\u0013\t\u0007b\u0002<\u0002\u0005\u0004%I\u0001\u0019\u0005\u0007o\u0006\u0001\u000b\u0011B1\t\u000fa\f!\u0019!C\u0005s\"9\u0011\u0011A\u0001!\u0002\u0013Q\b\u0002CA\u0002\u0003\t\u0007I\u0011B=\t\u000f\u0005\u0015\u0011\u0001)A\u0005u\"I\u0011qA\u0001\u0002\u0002\u0013\u0005\u0015\u0011\u0002\u0005\n\u0005_\u000b\u0011\u0013!C\u0001\u0005#B\u0011B!-\u0002\u0003\u0003%\tIa-\t\u0013\t\u0015\u0017!%A\u0005\u0002\tE\u0003\"\u0003Bd\u0003\u0005\u0005I\u0011\u0002Be\r\u0015ie\bQA\u0007\u0011)\t\u0019\u0005\bBK\u0002\u0013\u0005\u0011Q\t\u0005\u000b\u0003\u001bb\"\u0011#Q\u0001\n\u0005\u001d\u0003BCA(9\tU\r\u0011\"\u0001\u0002R!Q\u0011\u0011\f\u000f\u0003\u0012\u0003\u0006I!a\u0015\t\rucB\u0011AA.\u0011\u0019iF\u0004\"\u0001\u0002b!9\u0011Q\r\u000f\u0005B\u0005E\u0003bBA49\u0011\u0005\u0013\u0011\u000e\u0005\b\u0003obB\u0011IA=\u0011\u001d\tY\b\bC!\u0003{B!\"!$\u001d\u0011\u000b\u0007I\u0011BAH\u0011)\t)\u000b\bEC\u0002\u0013%\u0011q\u0015\u0005\u000b\u0003wc\u0002R1A\u0005\n\u0005u\u0006bBAd9\u0011\u0005\u0013\u0011\u001a\u0005\b\u0003/dB\u0011BAm\u0011\u001d\ty\u000e\bC\u0005\u0003CDq!a:\u001d\t\u0013\tI\u000fC\u0004\u0002pr!I!!=\t\u000f\u0005mH\u0004\"\u0003\u0002~\"9!1\u0001\u000f\u0005\n\t\u0015\u0001b\u0002B\u00069\u0011\u0005#Q\u0002\u0005\b\u0005CaB\u0011\u000bB\u0012\u0011%\u0011y\u0003HA\u0001\n\u0003\u0011\t\u0004C\u0005\u00038q\t\n\u0011\"\u0001\u0003:!I!q\n\u000f\u0012\u0002\u0013\u0005!\u0011\u000b\u0005\t\u0005+b\u0012\u0011!C!s\"I!q\u000b\u000f\u0002\u0002\u0013\u0005!\u0011\f\u0005\n\u0005Cb\u0012\u0011!C\u0001\u0005GB\u0011B!\u001b\u001d\u0003\u0003%\tEa\u001b\t\u0013\teD$!A\u0005\u0002\tm\u0004\"\u0003B@9\u0005\u0005I\u0011\tBA\u0011%\u0011)\tHA\u0001\n\u0003\u00129)\u0001\u0005QCJ\u001cX-\u0016:m\u0015\ty\u0004)A\u0006fqB\u0014Xm]:j_:\u001c(BA!C\u0003!\u0019\u0017\r^1msN$(BA\"E\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u000b\u001a\u000bQa\u001d9be.T!a\u0012%\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005I\u0015aA8sO\u000e\u0001\u0001C\u0001'\u0002\u001b\u0005q$\u0001\u0003)beN,WK\u001d7\u0014\u0007\u0005yU\u000b\u0005\u0002Q'6\t\u0011KC\u0001S\u0003\u0015\u00198-\u00197b\u0013\t!\u0016K\u0001\u0004B]f\u0014VM\u001a\t\u0003-nk\u0011a\u0016\u0006\u00031f\u000b!![8\u000b\u0003i\u000bAA[1wC&\u0011Al\u0016\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003-\u000bA\u0001S(T)V\t\u0011\r\u0005\u0002cO6\t1M\u0003\u0002eK\u0006)A/\u001f9fg*\u0011a\rR\u0001\u0007k:\u001c\u0018MZ3\n\u0005!\u001c'AC+U\rb\u001aFO]5oO\u0006)\u0001jT*UA\u0005!\u0001+\u0011+I\u0003\u0015\u0001\u0016\t\u0016%!\u0003\u0015\tV+\u0012*Z\u0003\u0019\tV+\u0012*ZA\u0005\u0019!+\u0012$\u0002\tI+e\tI\u0001\t!J{EkT\"P\u0019\u0006I\u0001KU(U\u001f\u000e{E\nI\u0001\u0005\r&cU)A\u0003G\u00132+\u0005%A\u0005B+RCuJU%U3\u0006Q\u0011)\u0016+I\u001fJKE+\u0017\u0011\u0002\u0011U\u001bVIU%O\r>\u000b\u0011\"V*F%&sei\u0014\u0011\u0002\u0017I+u)\u0012-Q%\u00163\u0015\nW\u000b\u0002uB\u00111P`\u0007\u0002y*\u0011Q0W\u0001\u0005Y\u0006tw-\u0003\u0002\u0000y\n11\u000b\u001e:j]\u001e\fABU#H\u000bb\u0003&+\u0012$J1\u0002\n1BU#H\u000bb\u001bVK\u0011$J1\u0006a!+R$F1N+&IR%YA\u0005)\u0011\r\u001d9msR1\u00111\u0002BV\u0005[\u0003\"\u0001\u0014\u000f\u0014\u0017q\ty!!\u0006\u0002\u001c\u0005\u001d\u0012Q\u0006\t\u0004\u0019\u0006E\u0011bAA\n}\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u00071\u000b9\"C\u0002\u0002\u001ay\u0012\u0011#\u0012=qK\u000e$8/\u00138qkR$\u0016\u0010]3t!\u0011\ti\"a\t\u000e\u0005\u0005}!bAA\u0011}\u000591m\u001c3fO\u0016t\u0017\u0002BA\u0013\u0003?\u0011qbQ8eK\u001e,gNR1mY\n\f7m\u001b\t\u0004!\u0006%\u0012bAA\u0016#\n9\u0001K]8ek\u000e$\b\u0003BA\u0018\u0003\u007fqA!!\r\u0002<9!\u00111GA\u001d\u001b\t\t)DC\u0002\u00028)\u000ba\u0001\u0010:p_Rt\u0014\"\u0001*\n\u0007\u0005u\u0012+A\u0004qC\u000e\\\u0017mZ3\n\u0007q\u000b\tEC\u0002\u0002>E\u000b\u0001b\u00195jY\u0012\u0014XM\\\u000b\u0003\u0003\u000f\u0002b!a\f\u0002J\u0005=\u0011\u0002BA&\u0003\u0003\u00121aU3r\u0003%\u0019\u0007.\u001b7ee\u0016t\u0007%A\u0006gC&dwJ\\#se>\u0014XCAA*!\r\u0001\u0016QK\u0005\u0004\u0003/\n&a\u0002\"p_2,\u0017M\\\u0001\rM\u0006LGn\u00148FeJ|'\u000f\t\u000b\u0007\u0003\u0017\ti&a\u0018\t\u000f\u0005\r\u0013\u00051\u0001\u0002H!I\u0011qJ\u0011\u0011\u0002\u0003\u0007\u00111\u000b\u000b\u0005\u0003\u0017\t\u0019\u0007C\u0004\u0002D\t\u0002\r!a\u0012\u0002\u00119,H\u000e\\1cY\u0016\f!\"\u001b8qkR$\u0016\u0010]3t+\t\tY\u0007\u0005\u0004\u00020\u0005%\u0013Q\u000e\t\u0005\u0003_\n\u0019(\u0004\u0002\u0002r)\u0011AMQ\u0005\u0005\u0003k\n\tH\u0001\u0005ECR\fG+\u001f9f\u0003!!\u0017\r^1UsB,WCAA7\u0003)\u0001(/\u001a;us:\u000bW.Z\u000b\u0003\u0003\u007f\u0002B!!!\u0002\n:!\u00111QAC!\r\t\u0019$U\u0005\u0004\u0003\u000f\u000b\u0016A\u0002)sK\u0012,g-C\u0002\u0000\u0003\u0017S1!a\"R\u0003%\u0019\u0017m\u00195fIV\u0013H.\u0006\u0002\u0002\u0012B!\u00111SAM\u001b\t\t)JC\u0002\u0002\u0018f\u000b1A\\3u\u0013\u0011\tY*!&\u0003\u0007U\u0013\u0016\nK\u0002(\u0003?\u00032\u0001UAQ\u0013\r\t\u0019+\u0015\u0002\niJ\fgn]5f]R\fQbY1dQ\u0016$\u0007+\u0019;uKJtWCAAU!\u0011\tY+!.\u000e\u0005\u00055&\u0002BAX\u0003c\u000bQA]3hKbT1!a-Z\u0003\u0011)H/\u001b7\n\t\u0005]\u0016Q\u0016\u0002\b!\u0006$H/\u001a:oQ\rA\u0013qT\u0001\u0016G\u0006\u001c\u0007.\u001a3FqR\u0014\u0018m\u0019;QCJ$h)\u001e8d+\t\ty\fE\u0004Q\u0003\u0003\f\t*a \n\u0007\u0005\r\u0017KA\u0005Gk:\u001cG/[8oc!\u001a\u0011&a(\u0002'\rDWmY6J]B,H\u000fR1uCRK\b/Z:\u0015\u0005\u0005-\u0007\u0003BAg\u0003'l!!a4\u000b\u0007\u0005E\u0007)\u0001\u0005b]\u0006d\u0017p]5t\u0013\u0011\t).a4\u0003\u001fQK\b/Z\"iK\u000e\\'+Z:vYR\f!bZ3u!\u0006$H/\u001a:o)\u0011\tI+a7\t\r\u0005u7\u00061\u0001b\u0003\rYW-_\u0001\u0007O\u0016$XK\u001d7\u0015\t\u0005E\u00151\u001d\u0005\u0007\u0003Kd\u0003\u0019A1\u0002\u0007U\u0014H.\u0001\nhKR,\u0005\u0010\u001e:bGR\u0004\u0016M\u001d;Gk:\u001cG\u0003BA`\u0003WDa!!<.\u0001\u0004\t\u0017!\u00049beR$v.\u0012=ue\u0006\u001cG/A\u000bfqR\u0014\u0018m\u0019;WC2,XM\u0012:p[F+XM]=\u0015\u000b\u0005\f\u00190a>\t\r\u0005Uh\u00061\u0001b\u0003\u0015\tX/\u001a:z\u0011\u001d\tIP\fa\u0001\u0003S\u000bq\u0001]1ui\u0016\u0014h.\u0001\bfqR\u0014\u0018m\u0019;Ge>lWK\u001d7\u0015\u000b\u0005\fyP!\u0001\t\u000f\u0005\u0015x\u00061\u0001\u0002\u0012\"1\u0011Q^\u0018A\u0002\u0005\f!\u0003]1sg\u0016,&\u000f\\,ji\"|W\u000f^&fsR)\u0011Ma\u0002\u0003\n!1\u0011Q\u001d\u0019A\u0002\u0005Da!!<1\u0001\u0004\t\u0017\u0001B3wC2$BAa\u0004\u0003\u0016A\u0019\u0001K!\u0005\n\u0007\tM\u0011KA\u0002B]fD\u0011Ba\u00062!\u0003\u0005\rA!\u0007\u0002\u000b%t\u0007/\u001e;\u0011\t\tm!QD\u0007\u0002\u0001&\u0019!q\u0004!\u0003\u0017%sG/\u001a:oC2\u0014vn^\u0001\u0018o&$\bNT3x\u0007\"LG\u000e\u001a:f]&sG/\u001a:oC2$B!a\u0003\u0003&!9!q\u0005\u001aA\u0002\t%\u0012a\u00038fo\u000eC\u0017\u000e\u001c3sK:\u0004b!a\f\u0003,\u0005=\u0011\u0002\u0002B\u0017\u0003\u0003\u0012!\"\u00138eKb,GmU3r\u0003\u0011\u0019w\u000e]=\u0015\r\u0005-!1\u0007B\u001b\u0011%\t\u0019e\rI\u0001\u0002\u0004\t9\u0005C\u0005\u0002PM\u0002\n\u00111\u0001\u0002T\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nTC\u0001B\u001eU\u0011\t9E!\u0010,\u0005\t}\u0002\u0003\u0002B!\u0005\u0017j!Aa\u0011\u000b\t\t\u0015#qI\u0001\nk:\u001c\u0007.Z2lK\u0012T1A!\u0013R\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005\u001b\u0012\u0019EA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0003T)\"\u00111\u000bB\u001f\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jq\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011!1\f\t\u0004!\nu\u0013b\u0001B0#\n\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!!q\u0002B3\u0011%\u00119\u0007OA\u0001\u0002\u0004\u0011Y&A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0005[\u0002bAa\u001c\u0003v\t=QB\u0001B9\u0015\r\u0011\u0019(U\u0001\u000bG>dG.Z2uS>t\u0017\u0002\u0002B<\u0005c\u0012\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u00111\u000bB?\u0011%\u00119GOA\u0001\u0002\u0004\u0011y!\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,Gc\u0001>\u0003\u0004\"I!qM\u001e\u0002\u0002\u0003\u0007!1L\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005M#\u0011\u0012\u0005\n\u0005Ob\u0014\u0011!a\u0001\u0005\u001fA3\u0003\bBG\u0005'\u0013)J!'\u0003\u001c\n}%\u0011\u0015BS\u0005O\u00032\u0001\u0014BH\u0013\r\u0011\tJ\u0010\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\u00119*A `\rVs5i\u0018\u0015ve2d\u0003\u0005]1siR{W\t\u001f;sC\u000e$8\f\f\u0011lKfl\u0016\u0006I\u0017!\u000bb$(/Y2ug\u0002\n\u0007\u0005]1si\u00022'o\\7!C\u0002*&\u000b\u0014\u0018\u0002\u0011\u0015D\u0018-\u001c9mKN\f#A!(\u0002\u0005\u0007R\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006f\n5uiBTtfL:qCJ\\g&\u00199bG\",gf\u001c:h_A\fG\u000f[ rk\u0016\u0014\u00180P\u0019(Y\u0001:\u0003jT*UO%Z$\u0002\t\u0011!A\u0001\u0002\u0003e\u001d9be.t\u0013\r]1dQ\u0016tsN]4\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001dBG\u000f\u001e9;_=\u001a\b/\u0019:l]\u0005\u0004\u0018m\u00195f]=\u0014xm\f9bi\"|\u0014/^3ssv\nt\u0005\f\u0011(#V+%+W\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001\nX/\u001a:z{ER\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006f\n5uiBTtfL:qCJ\\g&\u00199bG\",gf\u001c:h_A\fG\u000f[ rk\u0016\u0014\u00180P\u0019(Y\u0001:\u0013+V#S3\u001eb\u0003eJ9vKJLx%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!c)\u0001\u0003%A\u0003tS:\u001cW-\t\u0002\u0003$\u0006)!G\f\u0019/a\u0005)qM]8va\u0006\u0012!\u0011V\u0001\rgR\u0014\u0018N\\4`MVt7m\u001d\u0005\b\u0003\u0007:\u0002\u0019AA$\u0011%\tye\u0006I\u0001\u0002\u0004\t\u0019&A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00133\u0003\u001d)h.\u00199qYf$BA!.\u0003BB)\u0001Ka.\u0003<&\u0019!\u0011X)\u0003\r=\u0003H/[8o!\u001d\u0001&QXA$\u0003'J1Aa0R\u0005\u0019!V\u000f\u001d7fe!I!1Y\r\u0002\u0002\u0003\u0007\u00111B\u0001\u0004q\u0012\u0002\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$#'\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0003LB\u00191P!4\n\u0007\t=GP\u0001\u0004PE*,7\r\u001e")
public class ParseUrl
extends Expression
implements ExpectsInputTypes,
CodegenFallback,
Serializable {
    private transient URI cachedUrl;
    private transient Pattern cachedPattern;
    private transient Function1<URI, String> cachedExtractPartFunc;
    private final Seq<Expression> children;
    private final boolean failOnError;
    private volatile transient byte bitmap$trans$0;

    public static boolean $lessinit$greater$default$2() {
        return ParseUrl$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple2<Seq<Expression>, Object>> unapply(ParseUrl x$0) {
        return ParseUrl$.MODULE$.unapply(x$0);
    }

    public static boolean apply$default$2() {
        return ParseUrl$.MODULE$.apply$default$2();
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return CodegenFallback.doGenCode$(this, ctx, ev);
    }

    @Override
    public Seq<Expression> children() {
        return this.children;
    }

    public boolean failOnError() {
        return this.failOnError;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    public Seq<DataType> inputTypes() {
        return (Seq)package$.MODULE$.Seq().fill(this.children().size(), (Function0 & Serializable)() -> StringType$.MODULE$);
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    @Override
    public String prettyName() {
        return "parse_url";
    }

    private URI cachedUrl$lzycompute() {
        ParseUrl parseUrl = this;
        synchronized (parseUrl) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                UTF8String uTF8String;
                Literal literal;
                Object url;
                Expression expression = (Expression)this.children().apply(0);
                URI uRI = expression instanceof Literal && (url = (literal = (Literal)expression).value()) instanceof UTF8String && (uTF8String = (UTF8String)url) != null ? this.getUrl(uTF8String) : null;
                this.cachedUrl = uRI;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.cachedUrl;
    }

    private URI cachedUrl() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.cachedUrl$lzycompute() : this.cachedUrl;
    }

    private Pattern cachedPattern$lzycompute() {
        ParseUrl parseUrl = this;
        synchronized (parseUrl) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                UTF8String uTF8String;
                Literal literal;
                Object key;
                Expression expression = (Expression)this.children().apply(2);
                Pattern pattern = expression instanceof Literal && (key = (literal = (Literal)expression).value()) instanceof UTF8String && (uTF8String = (UTF8String)key) != null ? this.getPattern(uTF8String) : null;
                this.cachedPattern = pattern;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.cachedPattern;
    }

    private Pattern cachedPattern() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.cachedPattern$lzycompute() : this.cachedPattern;
    }

    private Function1<URI, String> cachedExtractPartFunc$lzycompute() {
        ParseUrl parseUrl = this;
        synchronized (parseUrl) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                Function1<URI, String> function1;
                Literal literal;
                Object part;
                Expression expression = (Expression)this.children().apply(1);
                if (expression instanceof Literal && (part = (literal = (Literal)expression).value()) instanceof UTF8String) {
                    UTF8String uTF8String = (UTF8String)part;
                    function1 = this.getExtractPartFunc(uTF8String);
                } else {
                    function1 = null;
                }
                this.cachedExtractPartFunc = function1;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.cachedExtractPartFunc;
    }

    private Function1<URI, String> cachedExtractPartFunc() {
        return (byte)(this.bitmap$trans$0 & 4) == 0 ? this.cachedExtractPartFunc$lzycompute() : this.cachedExtractPartFunc;
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return this.children().size() > 3 || this.children().size() < 2 ? new TypeCheckResult.TypeCheckFailure(new StringBuilder(41).append(this.prettyName()).append(" function requires two or three arguments").toString()) : ExpectsInputTypes.checkInputDataTypes$(this);
    }

    private Pattern getPattern(UTF8String key) {
        return Pattern.compile(new StringBuilder(0).append(ParseUrl$.MODULE$.org$apache$spark$sql$catalyst$expressions$ParseUrl$$REGEXPREFIX()).append(key.toString()).append(ParseUrl$.MODULE$.org$apache$spark$sql$catalyst$expressions$ParseUrl$$REGEXSUBFIX()).toString());
    }

    private URI getUrl(UTF8String url) {
        URI uRI;
        try {
            uRI = new URI(url.toString());
        }
        catch (URISyntaxException uRISyntaxException) {
            if (this.failOnError()) {
                throw QueryExecutionErrors$.MODULE$.invalidUrlError(url, uRISyntaxException);
            }
            uRI = null;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        return uRI;
    }

    private Function1<URI, String> getExtractPartFunc(UTF8String partToExtract) {
        Function1 & Serializable intersect;
        UTF8String uTF8String = partToExtract;
        UTF8String uTF8String2 = ParseUrl$.MODULE$.org$apache$spark$sql$catalyst$expressions$ParseUrl$$HOST();
        UTF8String uTF8String3 = uTF8String;
        if (!(uTF8String2 != null ? !uTF8String2.equals(uTF8String3) : uTF8String3 != null)) {
            intersect = (Function1 & Serializable)x$22 -> x$22.getHost();
        } else {
            UTF8String uTF8String4 = ParseUrl$.MODULE$.org$apache$spark$sql$catalyst$expressions$ParseUrl$$PATH();
            UTF8String uTF8String5 = uTF8String;
            if (!(uTF8String4 != null ? !uTF8String4.equals(uTF8String5) : uTF8String5 != null)) {
                intersect = (Function1 & Serializable)x$23 -> x$23.getRawPath();
            } else {
                UTF8String uTF8String6 = ParseUrl$.MODULE$.org$apache$spark$sql$catalyst$expressions$ParseUrl$$QUERY();
                UTF8String uTF8String7 = uTF8String;
                if (!(uTF8String6 != null ? !uTF8String6.equals(uTF8String7) : uTF8String7 != null)) {
                    intersect = (Function1 & Serializable)x$24 -> x$24.getRawQuery();
                } else {
                    UTF8String uTF8String8 = ParseUrl$.MODULE$.org$apache$spark$sql$catalyst$expressions$ParseUrl$$REF();
                    UTF8String uTF8String9 = uTF8String;
                    if (!(uTF8String8 != null ? !uTF8String8.equals(uTF8String9) : uTF8String9 != null)) {
                        intersect = (Function1 & Serializable)x$25 -> x$25.getRawFragment();
                    } else {
                        UTF8String uTF8String10 = ParseUrl$.MODULE$.org$apache$spark$sql$catalyst$expressions$ParseUrl$$PROTOCOL();
                        UTF8String uTF8String11 = uTF8String;
                        if (!(uTF8String10 != null ? !uTF8String10.equals(uTF8String11) : uTF8String11 != null)) {
                            intersect = (Function1 & Serializable)x$26 -> x$26.getScheme();
                        } else {
                            UTF8String uTF8String12 = ParseUrl$.MODULE$.org$apache$spark$sql$catalyst$expressions$ParseUrl$$FILE();
                            UTF8String uTF8String13 = uTF8String;
                            if (!(uTF8String12 != null ? !uTF8String12.equals(uTF8String13) : uTF8String13 != null)) {
                                intersect = (Function1 & Serializable)url -> url.getRawQuery() != null ? new StringBuilder(1).append(url.getRawPath()).append("?").append(url.getRawQuery()).toString() : url.getRawPath();
                            } else {
                                UTF8String uTF8String14 = ParseUrl$.MODULE$.org$apache$spark$sql$catalyst$expressions$ParseUrl$$AUTHORITY();
                                UTF8String uTF8String15 = uTF8String;
                                if (!(uTF8String14 != null ? !uTF8String14.equals(uTF8String15) : uTF8String15 != null)) {
                                    intersect = (Function1 & Serializable)x$27 -> x$27.getRawAuthority();
                                } else {
                                    UTF8String uTF8String16 = ParseUrl$.MODULE$.org$apache$spark$sql$catalyst$expressions$ParseUrl$$USERINFO();
                                    UTF8String uTF8String17 = uTF8String;
                                    intersect = !(uTF8String16 != null ? !uTF8String16.equals(uTF8String17) : uTF8String17 != null) ? (Function1 & Serializable)x$28 -> x$28.getRawUserInfo() : (Function1 & Serializable)url -> null;
                                }
                            }
                        }
                    }
                }
            }
        }
        return intersect;
    }

    private UTF8String extractValueFromQuery(UTF8String query, Pattern pattern) {
        Matcher m = pattern.matcher(query.toString());
        return m.find() ? UTF8String.fromString((String)m.group(2)) : null;
    }

    private UTF8String extractFromUrl(URI url, UTF8String partToExtract) {
        return this.cachedExtractPartFunc() != null ? UTF8String.fromString((String)((String)this.cachedExtractPartFunc().apply((Object)url))) : UTF8String.fromString((String)((String)this.getExtractPartFunc(partToExtract).apply((Object)url)));
    }

    private UTF8String parseUrlWithoutKey(UTF8String url, UTF8String partToExtract) {
        URI currentUrl;
        return this.cachedUrl() != null ? this.extractFromUrl(this.cachedUrl(), partToExtract) : ((currentUrl = this.getUrl(url)) != null ? this.extractFromUrl(currentUrl, partToExtract) : null);
    }

    @Override
    public Object eval(InternalRow input) {
        UTF8String uTF8String;
        Seq evaluated = (Seq)this.children().map((Function1 & Serializable)e -> (UTF8String)e.eval(input));
        if (evaluated.contains(null)) {
            return null;
        }
        if (evaluated.size() == 2) {
            uTF8String = this.parseUrlWithoutKey((UTF8String)evaluated.apply(0), (UTF8String)evaluated.apply(1));
        } else {
            Predef$.MODULE$.assert(evaluated.size() == 3);
            Object object = evaluated.apply(1);
            UTF8String uTF8String2 = ParseUrl$.MODULE$.org$apache$spark$sql$catalyst$expressions$ParseUrl$$QUERY();
            if (object == null ? uTF8String2 != null : !object.equals(uTF8String2)) {
                return null;
            }
            UTF8String query = this.parseUrlWithoutKey((UTF8String)evaluated.apply(0), (UTF8String)evaluated.apply(1));
            if (query == null) {
                return null;
            }
            uTF8String = this.cachedPattern() != null ? this.extractValueFromQuery(query, this.cachedPattern()) : this.extractValueFromQuery(query, this.getPattern((UTF8String)evaluated.apply(2)));
        }
        return uTF8String;
    }

    @Override
    public ParseUrl withNewChildrenInternal(IndexedSeq<Expression> newChildren) {
        return this.copy((Seq<Expression>)newChildren, this.copy$default$2());
    }

    public ParseUrl copy(Seq<Expression> children2, boolean failOnError) {
        return new ParseUrl(children2, failOnError);
    }

    public Seq<Expression> copy$default$1() {
        return this.children();
    }

    public boolean copy$default$2() {
        return this.failOnError();
    }

    @Override
    public String productPrefix() {
        return "ParseUrl";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.children();
                break;
            }
            case 1: {
                object = BoxesRunTime.boxToBoolean((boolean)this.failOnError());
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ParseUrl;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "children";
                break;
            }
            case 1: {
                string = "failOnError";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ParseUrl)) return false;
        boolean bl = true;
        if (!bl) return false;
        ParseUrl parseUrl = (ParseUrl)x$1;
        if (this.failOnError() != parseUrl.failOnError()) return false;
        Seq<Expression> seq = this.children();
        Seq<Expression> seq2 = parseUrl.children();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        if (!parseUrl.canEqual(this)) return false;
        return true;
    }

    public ParseUrl(Seq<Expression> children2, boolean failOnError) {
        this.children = children2;
        this.failOnError = failOnError;
        ExpectsInputTypes.$init$(this);
        CodegenFallback.$init$(this);
    }

    public ParseUrl(Seq<Expression> children2) {
        this(children2, SQLConf$.MODULE$.get().ansiEnabled());
    }
}

