/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.util.Locale;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.Encode;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.RuntimeReplaceable;
import org.apache.spark.sql.catalyst.expressions.ToBinary$;
import org.apache.spark.sql.catalyst.expressions.UnBase64;
import org.apache.spark.sql.catalyst.expressions.Unhex;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(str[, fmt]) - Converts the input `str` to a binary value based on the supplied `fmt`.\n      `fmt` can be a case-insensitive string literal of \"hex\", \"utf-8\", or \"base64\".\n      By default, the binary format for conversion is \"hex\" if `fmt` is omitted.\n      The function returns NULL if at least one of the input parameters is NULL.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('abc', 'utf-8');\n       abc\n  ", since="3.3.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005Uh\u0001B\u0012%\u0001FB\u0001B\u0014\u0001\u0003\u0016\u0004%\ta\u0014\u0005\t!\u0002\u0011\t\u0012)A\u0005e!A\u0011\u000b\u0001BK\u0002\u0013\u0005!\u000b\u0003\u0005W\u0001\tE\t\u0015!\u0003T\u0011!9\u0006A!f\u0001\n\u0003A\u0006\u0002\u0003/\u0001\u0005#\u0005\u000b\u0011B-\t\u000bu\u0003A\u0011\u00010\t\u0011\r\u0004\u0001R1A\u0005B=CQ!\u0018\u0001\u0005\u0002\u0011DQ!\u0018\u0001\u0005\u0002\u0019DQ!\u001b\u0001\u0005B)DQa\u001d\u0001\u0005BQDQ\u0001\u001f\u0001\u0005BeDq!a\u0001\u0001\t#\n)\u0001C\u0005\u0002\u0012\u0001\t\t\u0011\"\u0001\u0002\u0014!I\u00111\u0004\u0001\u0012\u0002\u0013\u0005\u0011Q\u0004\u0005\n\u0003g\u0001\u0011\u0013!C\u0001\u0003kA\u0011\"!\u000f\u0001#\u0003%\t!a\u000f\t\u0013\u0005}\u0002!!A\u0005B\u0005\u0005\u0003\"CA)\u0001\u0005\u0005I\u0011AA*\u0011%\tY\u0006AA\u0001\n\u0003\ti\u0006C\u0005\u0002j\u0001\t\t\u0011\"\u0011\u0002l!I\u0011\u0011\u0010\u0001\u0002\u0002\u0013\u0005\u00111\u0010\u0005\n\u0003\u007f\u0002\u0011\u0011!C!\u0003\u0003C\u0011\"!\"\u0001\u0003\u0003%\t%a\"\b\u0013\u0005-F%!A\t\u0002\u00055f\u0001C\u0012%\u0003\u0003E\t!a,\t\ru[B\u0011AAd\u0011%\tImGA\u0001\n\u000b\nY\rC\u0005\u0002Nn\t\t\u0011\"!\u0002P\"I\u0011q[\u000e\u0012\u0002\u0013\u0005\u00111\b\u0005\n\u00033\\\u0012\u0011!CA\u00037D\u0011\"!;\u001c#\u0003%\t!a\u000f\t\u0013\u0005-8$!A\u0005\n\u00055(\u0001\u0003+p\u0005&t\u0017M]=\u000b\u0005\u00152\u0013aC3yaJ,7o]5p]NT!a\n\u0015\u0002\u0011\r\fG/\u00197zgRT!!\u000b\u0016\u0002\u0007M\fHN\u0003\u0002,Y\u0005)1\u000f]1sW*\u0011QFL\u0001\u0007CB\f7\r[3\u000b\u0003=\n1a\u001c:h\u0007\u0001\u0019b\u0001\u0001\u001a7sq\u0012\u0005CA\u001a5\u001b\u0005!\u0013BA\u001b%\u0005))\u0005\u0010\u001d:fgNLwN\u001c\t\u0003g]J!\u0001\u000f\u0013\u0003%I+h\u000e^5nKJ+\u0007\u000f\\1dK\u0006\u0014G.\u001a\t\u0003giJ!a\u000f\u0013\u0003-%k\u0007\u000f\\5dSR\u001c\u0015m\u001d;J]B,H\u000fV=qKN\u0004\"!\u0010!\u000e\u0003yR\u0011aP\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0003z\u0012q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002D\u0017:\u0011A)\u0013\b\u0003\u000b\"k\u0011A\u0012\u0006\u0003\u000fB\na\u0001\u0010:p_Rt\u0014\"A \n\u0005)s\u0014a\u00029bG.\fw-Z\u0005\u0003\u00196\u0013AbU3sS\u0006d\u0017N_1cY\u0016T!A\u0013 \u0002\t\u0015D\bO]\u000b\u0002e\u0005)Q\r\u001f9sA\u00051am\u001c:nCR,\u0012a\u0015\t\u0004{Q\u0013\u0014BA+?\u0005\u0019y\u0005\u000f^5p]\u00069am\u001c:nCR\u0004\u0013a\u00058vY2|e.\u00138wC2LGMR8s[\u0006$X#A-\u0011\u0005uR\u0016BA.?\u0005\u001d\u0011un\u001c7fC:\fAC\\;mY>s\u0017J\u001c<bY&$gi\u001c:nCR\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0003`A\u0006\u0014\u0007CA\u001a\u0001\u0011\u0015qu\u00011\u00013\u0011\u0015\tv\u00011\u0001T\u0011\u001d9v\u0001%AA\u0002e\u000b1B]3qY\u0006\u001cW-\\3oiR\u0011q,\u001a\u0005\u0006\u001d&\u0001\rA\r\u000b\u0004?\u001eD\u0007\"\u0002(\u000b\u0001\u0004\u0011\u0004\"B)\u000b\u0001\u0004\u0011\u0014A\u00039sKR$\u0018PT1nKV\t1\u000e\u0005\u0002ma:\u0011QN\u001c\t\u0003\u000bzJ!a\u001c \u0002\rA\u0013X\rZ3g\u0013\t\t(O\u0001\u0004TiJLgn\u001a\u0006\u0003_z\n\u0001b\u00195jY\u0012\u0014XM\\\u000b\u0002kB\u00191I\u001e\u001a\n\u0005]l%aA*fc\u0006Q\u0011N\u001c9viRK\b/Z:\u0016\u0003i\u00042a\u0011<|!\tax0D\u0001~\u0015\tq\b&A\u0003usB,7/C\u0002\u0002\u0002u\u0014\u0001#\u00112tiJ\f7\r\u001e#bi\u0006$\u0016\u0010]3\u0002/]LG\u000f\u001b(fo\u000eC\u0017\u000e\u001c3sK:Le\u000e^3s]\u0006dGc\u0001\u001a\u0002\b!9\u0011\u0011\u0002\bA\u0002\u0005-\u0011a\u00038fo\u000eC\u0017\u000e\u001c3sK:\u0004BaQA\u0007e%\u0019\u0011qB'\u0003\u0015%sG-\u001a=fIN+\u0017/\u0001\u0003d_BLHcB0\u0002\u0016\u0005]\u0011\u0011\u0004\u0005\b\u001d>\u0001\n\u00111\u00013\u0011\u001d\tv\u0002%AA\u0002MCqaV\b\u0011\u0002\u0003\u0007\u0011,\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005}!f\u0001\u001a\u0002\"-\u0012\u00111\u0005\t\u0005\u0003K\ty#\u0004\u0002\u0002()!\u0011\u0011FA\u0016\u0003%)hn\u00195fG.,GMC\u0002\u0002.y\n!\"\u00198o_R\fG/[8o\u0013\u0011\t\t$a\n\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005]\"fA*\u0002\"\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u001aTCAA\u001fU\rI\u0016\u0011E\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005\r\u0003\u0003BA#\u0003\u001fj!!a\u0012\u000b\t\u0005%\u00131J\u0001\u0005Y\u0006twM\u0003\u0002\u0002N\u0005!!.\u0019<b\u0013\r\t\u0018qI\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003+\u00022!PA,\u0013\r\tIF\u0010\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003?\n)\u0007E\u0002>\u0003CJ1!a\u0019?\u0005\r\te.\u001f\u0005\n\u0003O*\u0012\u0011!a\u0001\u0003+\n1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA7!\u0019\ty'!\u001e\u0002`5\u0011\u0011\u0011\u000f\u0006\u0004\u0003gr\u0014AC2pY2,7\r^5p]&!\u0011qOA9\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\u0007e\u000bi\bC\u0005\u0002h]\t\t\u00111\u0001\u0002`\u0005\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\t\u0019%a!\t\u0013\u0005\u001d\u0004$!AA\u0002\u0005U\u0013AB3rk\u0006d7\u000fF\u0002Z\u0003\u0013C\u0011\"a\u001a\u001a\u0003\u0003\u0005\r!a\u0018)'\u0001\ti)a%\u0002\u0016\u0006e\u00151TAP\u0003C\u000b)+a*\u0011\u0007M\ny)C\u0002\u0002\u0012\u0012\u0012Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0002\u0018\u0006\u00119L\u0003\u0011!A\u0001zf)\u0016(D?\"\u001aHO].-A\u0019lG/X\u0015![\u0001\u001auN\u001c<feR\u001c\b\u0005\u001e5fA%t\u0007/\u001e;!AN$(\u000f\u0019\u0011u_\u0002\n\u0007EY5oCJL\bE^1mk\u0016\u0004#-Y:fI\u0002zg\u000e\t;iK\u0002\u001aX\u000f\u001d9mS\u0016$\u0007\u0005\u00194ni\u0002t#\u0002\t\u0011!A\u0001\u0002\u0003MZ7uA\u0002\u001a\u0017M\u001c\u0011cK\u0002\n\u0007eY1tK6Jgn]3og&$\u0018N^3!gR\u0014\u0018N\\4!Y&$XM]1mA=4\u0007E\t5fq\nb\u0003EI;uM6B$\u0005\f\u0011pe\u0002\u0012#-Y:fmQ\u0012cF\u0003\u0011!A\u0001\u0002\u0003EQ=!I\u00164\u0017-\u001e7uY\u0001\"\b.\u001a\u0011cS:\f'/\u001f\u0011g_Jl\u0017\r\u001e\u0011g_J\u00043m\u001c8wKJ\u001c\u0018n\u001c8!SN\u0004#\u0005[3yE\u0001Jg\r\t1g[R\u0004\u0007%[:!_6LG\u000f^3e])\u0001\u0003\u0005\t\u0011!AQCW\r\t4v]\u000e$\u0018n\u001c8!e\u0016$XO\u001d8tA9+F\n\u0014\u0011jM\u0002\nG\u000f\t7fCN$\be\u001c8fA=4\u0007\u0005\u001e5fA%t\u0007/\u001e;!a\u0006\u0014\u0018-\\3uKJ\u001c\b%[:!\u001dVcEJ\f\u0006!A\u0005AQ\r_1na2,7/\t\u0002\u0002\u001e\u0006\u0019%\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u0014bE\u000e<C\u0006I\u0014vi\u001al\u0003hJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0005\u00147M\u0003\u0011!\u0003\u0015\u0019\u0018N\\2fC\t\t\u0019+A\u00034]Mr\u0003'A\u0003he>,\b/\t\u0002\u0002*\u0006a1\u000f\u001e:j]\u001e|f-\u001e8dg\u0006AAk\u001c\"j]\u0006\u0014\u0018\u0010\u0005\u000247M)1$!-\u0002>BA\u00111WA]eMKv,\u0004\u0002\u00026*\u0019\u0011q\u0017 \u0002\u000fI,h\u000e^5nK&!\u00111XA[\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gn\r\t\u0005\u0003\u007f\u000b)-\u0004\u0002\u0002B*!\u00111YA&\u0003\tIw.C\u0002M\u0003\u0003$\"!!,\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!a\u0011\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000f}\u000b\t.a5\u0002V\")aJ\ba\u0001e!)\u0011K\ba\u0001'\"9qK\bI\u0001\u0002\u0004I\u0016aD1qa2LH\u0005Z3gCVdG\u000fJ\u001a\u0002\u000fUt\u0017\r\u001d9msR!\u0011Q\\As!\u0011iD+a8\u0011\ru\n\tOM*Z\u0013\r\t\u0019O\u0010\u0002\u0007)V\u0004H.Z\u001a\t\u0011\u0005\u001d\b%!AA\u0002}\u000b1\u0001\u001f\u00131\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%g\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u0011\u0011q\u001e\t\u0005\u0003\u000b\n\t0\u0003\u0003\u0002t\u0006\u001d#AB(cU\u0016\u001cG\u000f")
public class ToBinary
extends Expression
implements RuntimeReplaceable,
ImplicitCastInputTypes,
Serializable {
    private Expression replacement;
    private final Expression expr;
    private final Option<Expression> format;
    private final boolean nullOnInvalidFormat;
    private Seq<Enumeration.Value> nodePatterns;
    private Expression preCanonicalized;
    private volatile byte bitmap$0;

    public static boolean $lessinit$greater$default$3() {
        return ToBinary$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Tuple3<Expression, Option<Expression>, Object>> unapply(ToBinary x$0) {
        return ToBinary$.MODULE$.unapply(x$0);
    }

    public static boolean apply$default$3() {
        return ToBinary$.MODULE$.apply$default$3();
    }

    public static Function1<Tuple3<Expression, Option<Expression>, Object>, ToBinary> tupled() {
        return ToBinary$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Option<Expression>, Function1<Object, ToBinary>>> curried() {
        return ToBinary$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public boolean nullable() {
        return RuntimeReplaceable.nullable$(this);
    }

    @Override
    public DataType dataType() {
        return RuntimeReplaceable.dataType$(this);
    }

    @Override
    public final Object eval(InternalRow input) {
        return RuntimeReplaceable.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return RuntimeReplaceable.eval$default$1$(this);
    }

    @Override
    public final ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return RuntimeReplaceable.doGenCode$(this, ctx, ev);
    }

    @Override
    public Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private Expression preCanonicalized$lzycompute() {
        ToBinary toBinary = this;
        synchronized (toBinary) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.preCanonicalized = RuntimeReplaceable.preCanonicalized$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.preCanonicalized;
    }

    @Override
    public Expression preCanonicalized() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.preCanonicalized$lzycompute() : this.preCanonicalized;
    }

    @Override
    public void org$apache$spark$sql$catalyst$expressions$RuntimeReplaceable$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public Expression expr() {
        return this.expr;
    }

    public Option<Expression> format() {
        return this.format;
    }

    public boolean nullOnInvalidFormat() {
        return this.nullOnInvalidFormat;
    }

    private Expression replacement$lzycompute() {
        ToBinary toBinary = this;
        synchronized (toBinary) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.replacement = (Expression)this.format().map(arg_0 -> ToBinary.$anonfun$replacement$1(this, arg_0)).getOrElse((Function0 & Serializable)() -> new Unhex(this.expr()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.replacement;
    }

    @Override
    public Expression replacement() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.replacement$lzycompute() : this.replacement;
    }

    @Override
    public String prettyName() {
        return "to_binary";
    }

    @Override
    public Seq<Expression> children() {
        Expression expression = this.expr();
        return (Seq)Option$.MODULE$.option2Iterable(this.format()).toSeq().$plus$colon((Object)expression);
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)this.children().map((Function1 & Serializable)x$31 -> StringType$.MODULE$);
    }

    @Override
    public Expression withNewChildrenInternal(IndexedSeq<Expression> newChildren) {
        return this.format().isDefined() ? this.copy((Expression)newChildren.head(), (Option<Expression>)new Some(newChildren.last()), this.copy$default$3()) : this.copy((Expression)newChildren.head(), this.copy$default$2(), this.copy$default$3());
    }

    public ToBinary copy(Expression expr, Option<Expression> format, boolean nullOnInvalidFormat) {
        return new ToBinary(expr, format, nullOnInvalidFormat);
    }

    public Expression copy$default$1() {
        return this.expr();
    }

    public Option<Expression> copy$default$2() {
        return this.format();
    }

    public boolean copy$default$3() {
        return this.nullOnInvalidFormat();
    }

    @Override
    public String productPrefix() {
        return "ToBinary";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.expr();
                break;
            }
            case 1: {
                object = this.format();
                break;
            }
            case 2: {
                object = BoxesRunTime.boxToBoolean((boolean)this.nullOnInvalidFormat());
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ToBinary;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "expr";
                break;
            }
            case 1: {
                string = "format";
                break;
            }
            case 2: {
                string = "nullOnInvalidFormat";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ToBinary)) return false;
        boolean bl = true;
        if (!bl) return false;
        ToBinary toBinary = (ToBinary)x$1;
        if (this.nullOnInvalidFormat() != toBinary.nullOnInvalidFormat()) return false;
        Expression expression = this.expr();
        Expression expression2 = toBinary.expr();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Option<Expression> option = this.format();
        Option<Expression> option2 = toBinary.format();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!toBinary.canEqual(this)) return false;
        return true;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static final /* synthetic */ Expression $anonfun$replacement$1(ToBinary $this, Expression f) {
        block9: {
            block10: {
                block8: {
                    if (!f.foldable()) ** GOTO lbl-1000
                    v0 = f.dataType();
                    var3_2 = StringType$.MODULE$;
                    if (!(v0 == null ? var3_2 != null : v0.equals(var3_2) == false)) ** GOTO lbl-1000
                    v1 = f.dataType();
                    var4_3 = NullType$.MODULE$;
                    if (!(v1 != null ? v1.equals(var4_3) == false : var4_3 != null)) lbl-1000:
                    // 2 sources

                    {
                        v2 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v2 = false;
                    }
                    Predef$.MODULE$.assert(v2);
                    value = f.eval(f.eval$default$1());
                    if (value != null) break block8;
                    v3 /* !! */  = new Literal(null, BinaryType$.MODULE$);
                    break block9;
                }
                var6_5 = ((UTF8String)value).toString().toLowerCase(Locale.ROOT);
                switch (var6_5 == null ? 0 : var6_5.hashCode()) {
                    case -1396204209: {
                        if (!"base64".equals(var6_5)) break;
                        var2_6 /* !! */  = new UnBase64($this.expr());
                        break block10;
                    }
                    case 103195: {
                        if (!"hex".equals(var6_5)) break;
                        var2_6 /* !! */  = new Unhex($this.expr());
                        break block10;
                    }
                    case 111607186: {
                        if (!"utf-8".equals(var6_5)) break;
                        var2_6 /* !! */  = new Encode($this.expr(), Literal$.MODULE$.apply("UTF-8"));
                        break block10;
                    }
                }
                if (!$this.nullOnInvalidFormat()) {
                    throw QueryCompilationErrors$.MODULE$.invalidStringLiteralParameter("to_binary", "format", var6_5, (Option<String>)new Some((Object)"The value has to be a case-insensitive string literal of 'hex', 'utf-8', or 'base64'."));
                }
                var2_6 /* !! */  = new Literal(null, BinaryType$.MODULE$);
            }
            v3 /* !! */  = var2_6 /* !! */ ;
        }
        return v3 /* !! */ ;
    }

    public ToBinary(Expression expr, Option<Expression> format, boolean nullOnInvalidFormat) {
        this.expr = expr;
        this.format = format;
        this.nullOnInvalidFormat = nullOnInvalidFormat;
        RuntimeReplaceable.$init$(this);
        ExpectsInputTypes.$init$(this);
        Statics.releaseFence();
    }

    public ToBinary(Expression expr) {
        this(expr, (Option<Expression>)None$.MODULE$, false);
    }

    public ToBinary(Expression expr, Expression format) {
        block3: {
            block2: {
                NullType$ nullType$;
                DataType dataType;
                block4: {
                    if (!format.foldable()) break block2;
                    DataType dataType2 = format.dataType();
                    StringType$ stringType$ = StringType$.MODULE$;
                    if (!(dataType2 == null ? stringType$ != null : !dataType2.equals(stringType$))) break block3;
                    dataType = format.dataType();
                    nullType$ = NullType$.MODULE$;
                    if (dataType != null) break block4;
                    if (nullType$ == null) break block3;
                    break block2;
                }
                if (dataType.equals(nullType$)) break block3;
            }
            throw QueryCompilationErrors$.MODULE$.requireLiteralParameter("to_binary", "format", "string");
        }
        this(expr, (Option<Expression>)new Some((Object)format), false);
    }
}

