/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.util.Locale;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.ToNumber$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.util.ToNumberParser;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n     _FUNC_(expr, fmt) - Convert string 'expr' to a number based on the string format 'fmt'.\n       Throws an exception if the conversion fails. The format can consist of the following\n       characters, case insensitive:\n         '0' or '9': Specifies an expected digit between 0 and 9. A sequence of 0 or 9 in the format\n           string matches a sequence of digits in the input string. If the 0/9 sequence starts with\n           0 and is before the decimal point, it can only match a digit sequence of the same size.\n           Otherwise, if the sequence starts with 9 or is after the decimal poin, it can match a\n           digit sequence that has the same or smaller size.\n         '.' or 'D': Specifies the position of the decimal point (optional, only allowed once).\n         ',' or 'G': Specifies the position of the grouping (thousands) separator (,). There must be\n           one or more 0 or 9 to the left of the rightmost grouping separator. 'expr' must match the\n           grouping separator relevant for the size of the number.\n         '$': Specifies the location of the $ currency sign. This character may only be specified\n           once.\n         'S' or 'MI': Specifies the position of a '-' or '+' sign (optional, only allowed once at\n           the beginning or end of the format string). Note that 'S' allows '-' but 'MI' does not.\n         'PR': Only allowed at the end of the format string; specifies that 'expr' indicates a\n           negative number with wrapping angled brackets.\n           ('<1>').\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('454', '999');\n       454\n      > SELECT _FUNC_('454.00', '000.00');\n       454.00\n      > SELECT _FUNC_('12,454', '99,999');\n       12454\n      > SELECT _FUNC_('$78.12', '$99.99');\n       78.12\n      > SELECT _FUNC_('12,454.8-', '99,999.9S');\n       -12454.8\n  ", since="3.3.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0005\tea\u0001\u0002\u0011\"\u0001:B\u0001B\u0014\u0001\u0003\u0016\u0004%\ta\u0014\u0005\t'\u0002\u0011\t\u0012)A\u0005!\"AA\u000b\u0001BK\u0002\u0013\u0005q\n\u0003\u0005V\u0001\tE\t\u0015!\u0003Q\u0011\u00151\u0006\u0001\"\u0001X\u0011!Y\u0006\u0001#b\u0001\n\u0013a\u0006\u0002C3\u0001\u0011\u000b\u0007I\u0011\u00024\t\u000b5\u0004A\u0011\t8\t\u000bU\u0004A\u0011\t<\t\u000bi\u0004A\u0011I>\t\u000f\u0005\u0015\u0001\u0001\"\u0011\u0002\b!9\u0011q\u0003\u0001\u0005B\u0005e\u0001bBA\u0015\u0001\u0011\u0005\u00131\u0006\u0005\b\u0003\u000f\u0002A\u0011KA%\u0011%\t\u0019\u0006AA\u0001\n\u0003\t)\u0006C\u0005\u0002\\\u0001\t\n\u0011\"\u0001\u0002^!I\u00111\u000f\u0001\u0012\u0002\u0013\u0005\u0011Q\f\u0005\t\u0003k\u0002\u0011\u0011!C!9\"I\u0011q\u000f\u0001\u0002\u0002\u0013\u0005\u0011\u0011\u0010\u0005\n\u0003\u0003\u0003\u0011\u0011!C\u0001\u0003\u0007C\u0011\"!#\u0001\u0003\u0003%\t%a#\t\u0013\u0005e\u0005!!A\u0005\u0002\u0005m\u0005\"CAS\u0001\u0005\u0005I\u0011IAT\u0011%\tY\u000bAA\u0001\n\u0003\nikB\u0005\u0002R\u0006\n\t\u0011#\u0001\u0002T\u001aA\u0001%IA\u0001\u0012\u0003\t)\u000e\u0003\u0004W5\u0011\u0005\u0011Q\u001e\u0005\n\u0003_T\u0012\u0011!C#\u0003cD\u0011\"a=\u001b\u0003\u0003%\t)!>\t\u0013\u0005m($!A\u0005\u0002\u0006u\b\"\u0003B\b5\u0005\u0005I\u0011\u0002B\t\u0005!!vNT;nE\u0016\u0014(B\u0001\u0012$\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005\u0011*\u0013\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005\u0019:\u0013aA:rY*\u0011\u0001&K\u0001\u0006gB\f'o\u001b\u0006\u0003U-\na!\u00199bG\",'\"\u0001\u0017\u0002\u0007=\u0014xm\u0001\u0001\u0014\r\u0001y3GN\u001fD!\t\u0001\u0014'D\u0001\"\u0013\t\u0011\u0014E\u0001\tCS:\f'/_#yaJ,7o]5p]B\u0011\u0001\u0007N\u0005\u0003k\u0005\u0012a#S7qY&\u001c\u0017\u000e^\"bgRLe\u000e];u)f\u0004Xm\u001d\t\u0003oir!\u0001\r\u001d\n\u0005e\n\u0013a\u00029bG.\fw-Z\u0005\u0003wq\u0012aBT;mY&sGo\u001c7fe\u0006tGO\u0003\u0002:CA\u0011a(Q\u0007\u0002\u007f)\t\u0001)A\u0003tG\u0006d\u0017-\u0003\u0002C\u007f\t9\u0001K]8ek\u000e$\bC\u0001#L\u001d\t)%J\u0004\u0002G\u00136\tqI\u0003\u0002I[\u00051AH]8pizJ\u0011\u0001Q\u0005\u0003s}J!\u0001T'\u0003\u0019M+'/[1mSj\f'\r\\3\u000b\u0005ez\u0014\u0001\u00027fMR,\u0012\u0001\u0015\t\u0003aEK!AU\u0011\u0003\u0015\u0015C\bO]3tg&|g.A\u0003mK\u001a$\b%A\u0003sS\u001eDG/\u0001\u0004sS\u001eDG\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007aK&\f\u0005\u00021\u0001!)a*\u0002a\u0001!\")A+\u0002a\u0001!\u0006aa.^7cKJ4uN]7biV\tQ\f\u0005\u0002_G6\tqL\u0003\u0002aC\u0006!A.\u00198h\u0015\u0005\u0011\u0017\u0001\u00026bm\u0006L!\u0001Z0\u0003\rM#(/\u001b8h\u0003=qW/\u001c2fe\u001a{'/\\1ui\u0016\u0014X#A4\u0011\u0005!\\W\"A5\u000b\u0005)\u001c\u0013\u0001B;uS2L!\u0001\\5\u0003\u001dQ{g*^7cKJ\u0004\u0016M]:fe\u0006AA-\u0019;b)f\u0004X-F\u0001p!\t\u00018/D\u0001r\u0015\t\u0011X%A\u0003usB,7/\u0003\u0002uc\nAA)\u0019;b)f\u0004X-\u0001\u0006j]B,H\u000fV=qKN,\u0012a\u001e\t\u0004\tb|\u0017BA=N\u0005\r\u0019V-]\u0001\u0014G\",7m[%oaV$H)\u0019;b)f\u0004Xm\u001d\u000b\u0002yB\u0019Q0!\u0001\u000e\u0003yT!a`\u0012\u0002\u0011\u0005t\u0017\r\\=tSNL1!a\u0001\u007f\u0005=!\u0016\u0010]3DQ\u0016\u001c7NU3tk2$\u0018A\u00039sKR$\u0018PT1nKV\u0011\u0011\u0011\u0002\t\u0005\u0003\u0017\t\u0019B\u0004\u0003\u0002\u000e\u0005=\u0001C\u0001$@\u0013\r\t\tbP\u0001\u0007!J,G-\u001a4\n\u0007\u0011\f)BC\u0002\u0002\u0012}\nAB\\;mYN\u000bg-Z#wC2$b!a\u0007\u0002\"\u0005\u0015\u0002c\u0001 \u0002\u001e%\u0019\u0011qD \u0003\u0007\u0005s\u0017\u0010C\u0004\u0002$1\u0001\r!a\u0007\u0002\rM$(/\u001b8h\u0011\u001d\t9\u0003\u0004a\u0001\u00037\taAZ8s[\u0006$\u0018!\u00033p\u000f\u0016t7i\u001c3f)\u0019\ti#!\u000f\u0002DA!\u0011qFA\u001b\u001b\t\t\tDC\u0002\u00024\u0005\nqaY8eK\u001e,g.\u0003\u0003\u00028\u0005E\"\u0001C#yaJ\u001cu\u000eZ3\t\u000f\u0005mR\u00021\u0001\u0002>\u0005\u00191\r\u001e=\u0011\t\u0005=\u0012qH\u0005\u0005\u0003\u0003\n\tD\u0001\bD_\u0012,w-\u001a8D_:$X\r\u001f;\t\u000f\u0005\u0015S\u00021\u0001\u0002.\u0005\u0011QM^\u0001\u0018o&$\bNT3x\u0007\"LG\u000e\u001a:f]&sG/\u001a:oC2$R\u0001WA&\u0003\u001fBa!!\u0014\u000f\u0001\u0004\u0001\u0016a\u00028fo2+g\r\u001e\u0005\u0007\u0003#r\u0001\u0019\u0001)\u0002\u00119,wOU5hQR\fAaY8qsR)\u0001,a\u0016\u0002Z!9aj\u0004I\u0001\u0002\u0004\u0001\u0006b\u0002+\u0010!\u0003\u0005\r\u0001U\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\tyFK\u0002Q\u0003CZ#!a\u0019\u0011\t\u0005\u0015\u0014qN\u0007\u0003\u0003ORA!!\u001b\u0002l\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003[z\u0014AC1o]>$\u0018\r^5p]&!\u0011\u0011OA4\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jq\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u00111\u0010\t\u0004}\u0005u\u0014bAA@\u007f\t\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u00111DAC\u0011%\t9\tFA\u0001\u0002\u0004\tY(A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003\u001b\u0003b!a$\u0002\u0016\u0006mQBAAI\u0015\r\t\u0019jP\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAL\u0003#\u0013\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u0011QTAR!\rq\u0014qT\u0005\u0004\u0003C{$a\u0002\"p_2,\u0017M\u001c\u0005\n\u0003\u000f3\u0012\u0011!a\u0001\u00037\t!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR\u0019Q,!+\t\u0013\u0005\u001du#!AA\u0002\u0005m\u0014AB3rk\u0006d7\u000f\u0006\u0003\u0002\u001e\u0006=\u0006\"CAD1\u0005\u0005\t\u0019AA\u000eQM\u0001\u00111WA]\u0003w\u000by,!1\u0002F\u0006\u001d\u00171ZAg!\r\u0001\u0014QW\u0005\u0004\u0003o\u000b#!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0003{\u000b12 \u0006!A\u0001\u0002\u0003e\u0018$V\u001d\u000e{\u0006&\u001a=qe2\u0002c-\u001c;*A5\u00023i\u001c8wKJ$\be\u001d;sS:<\u0007eJ3yaJ<\u0003\u0005^8!C\u0002rW/\u001c2fe\u0002\u0012\u0017m]3eA=t\u0007\u0005\u001e5fAM$(/\u001b8hA\u0019|'/\\1uA\u001d2W\u000e^\u0014/\u0015\u0001\u0002\u0003\u0005\t\u0011!AQC'o\\<tA\u0005t\u0007%\u001a=dKB$\u0018n\u001c8!S\u001a\u0004C\u000f[3!G>tg/\u001a:tS>t\u0007EZ1jYNt\u0003\u0005\u00165fA\u0019|'/\\1uA\r\fg\u000eI2p]NL7\u000f\u001e\u0011pM\u0002\"\b.\u001a\u0011g_2dwn^5oO*\u0001\u0003\u0005\t\u0011!A\u0001\u001a\u0007.\u0019:bGR,'o\u001d\u0017!G\u0006\u001cX\rI5og\u0016t7/\u001b;jm\u0016T$\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011(a\u001d\u0002sN\u001d\u0011(s\u001dR\u0004e\u00159fG&4\u0017.Z:!C:\u0004S\r\u001f9fGR,G\r\t3jO&$\bEY3uo\u0016,g\u000e\t\u0019!C:$\u0007%\u000f\u0018!\u0003\u0002\u001aX-];f]\u000e,\u0007e\u001c4!a\u0001z'\u000fI\u001d!S:\u0004C\u000f[3!M>\u0014X.\u0019;\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003e\u001d;sS:<\u0007%\\1uG\",7\u000fI1!g\u0016\fX/\u001a8dK\u0002zg\r\t3jO&$8\u000fI5oAQDW\rI5oaV$\be\u001d;sS:<g\u0006I%gAQDW\r\t\u00190s\u0001\u001aX-];f]\u000e,\u0007e\u001d;beR\u001c\be^5uQ*\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u00111A\u0005tG\rI5tA\t,gm\u001c:fAQDW\r\t3fG&l\u0017\r\u001c\u0011q_&tG\u000f\f\u0011ji\u0002\u001a\u0017M\u001c\u0011p]2L\b%\\1uG\"\u0004\u0013\r\t3jO&$\be]3rk\u0016t7-\u001a\u0011pM\u0002\"\b.\u001a\u0011tC6,\u0007e]5{K:R\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!\u001fRDWM]<jg\u0016d\u0003%\u001b4!i\",\u0007e]3rk\u0016t7-\u001a\u0011ti\u0006\u0014Ho\u001d\u0011xSRD\u0007%\u000f\u0011pe\u0002J7\u000fI1gi\u0016\u0014\b\u0005\u001e5fA\u0011,7-[7bY\u0002\u0002x.\u001b8-A%$\beY1oA5\fGo\u00195!C*\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011eS\u001eLG\u000fI:fcV,gnY3!i\"\fG\u000f\t5bg\u0002\"\b.\u001a\u0011tC6,\u0007e\u001c:!g6\fG\u000e\\3sAML'0\u001a\u0018\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001:cf\n\u0011pe\u0002:Ci\n\u001e!'B,7-\u001b4jKN\u0004C\u000f[3!a>\u001c\u0018\u000e^5p]\u0002zg\r\t;iK\u0002\"WmY5nC2\u0004\u0003o\\5oi\u0002Bs\u000e\u001d;j_:\fG\u000e\f\u0011p]2L\b%\u00197m_^,G\rI8oG\u0016LcF\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!O1:\u0003e\u001c:!O\u001d;#\bI*qK\u000eLg-[3tAQDW\r\t9pg&$\u0018n\u001c8!_\u001a\u0004C\u000f[3!OJ|W\u000f]5oO\u0002BC\u000f[8vg\u0006tGm]\u0015!g\u0016\u0004\u0018M]1u_J\u0004\u0003\u0006L\u0015/AQCWM]3![V\u001cH\u000f\t2f\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005I8oK\u0002z'\u000fI7pe\u0016\u0004\u0003\u0007I8sAe\u0002Co\u001c\u0011uQ\u0016\u0004C.\u001a4uA=4\u0007\u0005\u001e5fAILw\r\u001b;n_N$\be\u001a:pkBLgn\u001a\u0011tKB\f'/\u0019;pe:\u0002s%\u001a=qe\u001e\u0002S.^:uA5\fGo\u00195!i\",'\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u001d\u0014x.\u001e9j]\u001e\u00043/\u001a9be\u0006$xN\u001d\u0011sK2,g/\u00198uA\u0019|'\u000f\t;iK\u0002\u001a\u0018N_3!_\u001a\u0004C\u000f[3!]Vl'-\u001a:/\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002s\u0005J\u0014;AM\u0003XmY5gS\u0016\u001c\b\u0005\u001e5fA1|7-\u0019;j_:\u0004sN\u001a\u0011uQ\u0016\u0004C\u0005I2veJ,gnY=!g&<gN\f\u0011UQ&\u001c\be\u00195be\u0006\u001cG/\u001a:![\u0006L\be\u001c8ms\u0002\u0012W\rI:qK\u000eLg-[3e\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005I8oG\u0016t#\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011('\u001e\u0002sN\u001d\u0011(\u001b&;#\bI*qK\u000eLg-[3tAQDW\r\t9pg&$\u0018n\u001c8!_\u001a\u0004\u0013\rI\u0014.O\u0001z'\u000fI\u0014,O\u0001\u001a\u0018n\u001a8!Q=\u0004H/[8oC2d\u0003e\u001c8ms\u0002\nG\u000e\\8xK\u0012\u0004sN\\2fA\u0005$(\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!AQDW\r\t2fO&tg.\u001b8hA=\u0014\b%\u001a8eA=4\u0007\u0005\u001e5fA\u0019|'/\\1uAM$(/\u001b8hS9\u0002cj\u001c;fAQD\u0017\r\u001e\u0011('\u001e\u0002\u0013\r\u001c7poN\u0004s%L\u0014!EV$\beJ'JO\u0001\"w.Z:!]>$hF\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!OA\u0013vE\u000f\u0011P]2L\b%\u00197m_^,G\rI1uAQDW\rI3oI\u0002zg\r\t;iK\u00022wN]7bi\u0002\u001aHO]5oOn\u00023\u000f]3dS\u001aLWm\u001d\u0011uQ\u0006$\beJ3yaJ<\u0003%\u001b8eS\u000e\fG/Z:!C*\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011oK\u001e\fG/\u001b<fA9,XNY3sA]LG\u000f\u001b\u0011xe\u0006\u0004\b/\u001b8hA\u0005tw\r\\3eA\t\u0014\u0018mY6fiNt#\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A!:C(\r (S9R\u0001\u0005I\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012\u00111Y\u0001\u0003X)\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~Cs\u0005N\u001b5O1\u0002s%O\u001d:O%Z$\u0002\t\u0011!A\u0001\u0002\u0003\u0005N\u001b5\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\":C'\u000e\u001b/aA:C\u0006I\u00141aAr\u0003\u0007M\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001\"T\u0007\u000e\u00181a)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~Cs%\r\u001a-iU\"t\u0005\f\u0011(seb\u0013(O\u001d(SmR\u0001\u0005\t\u0011!A\u0001\u0002\u0013G\r\u001b6i)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~Cs\u0005J\u001c9]E\u0012t\u0005\f\u0011(IeJd&O\u001d(SmR\u0001\u0005\t\u0011!A\u0001\u0002s\u0007\u000f\u00182e)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~Cs%\r\u001a-iU\"d\u0006O\u0017(Y\u0001:\u0013(\u000f\u0017:ser\u0013hU\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001j\u0013G\r\u001b6i9B$\u0002\t\u0011\u0002\u000bMLgnY3\"\u0005\u0005%\u0017!B\u001a/g9\u0002\u0014!B4s_V\u0004\u0018EAAh\u00031\u0019HO]5oO~3WO\\2t\u0003!!vNT;nE\u0016\u0014\bC\u0001\u0019\u001b'\u0015Q\u0012q[Ar!\u001d\tI.a8Q!bk!!a7\u000b\u0007\u0005uw(A\u0004sk:$\u0018.\\3\n\t\u0005\u0005\u00181\u001c\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u0014\u0004\u0003BAs\u0003Wl!!a:\u000b\u0007\u0005%\u0018-\u0001\u0002j_&\u0019A*a:\u0015\u0005\u0005M\u0017\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0003u\u000bQ!\u00199qYf$R\u0001WA|\u0003sDQAT\u000fA\u0002ACQ\u0001V\u000fA\u0002A\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002\u0000\n-\u0001#\u0002 \u0003\u0002\t\u0015\u0011b\u0001B\u0002\u007f\t1q\n\u001d;j_:\u0004RA\u0010B\u0004!BK1A!\u0003@\u0005\u0019!V\u000f\u001d7fe!A!Q\u0002\u0010\u0002\u0002\u0003\u0007\u0001,A\u0002yIA\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"Aa\u0005\u0011\u0007y\u0013)\"C\u0002\u0003\u0018}\u0013aa\u00142kK\u000e$\b")
public class ToNumber
extends BinaryExpression
implements ImplicitCastInputTypes,
package.NullIntolerant,
Serializable {
    private String numberFormat;
    private ToNumberParser numberFormatter;
    private final Expression left;
    private final Expression right;
    private volatile byte bitmap$0;

    public static Option<Tuple2<Expression, Expression>> unapply(ToNumber x$0) {
        return ToNumber$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple2<Expression, Expression>, ToNumber> tupled() {
        return ToNumber$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, ToNumber>> curried() {
        return ToNumber$.MODULE$.curried();
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    private String numberFormat$lzycompute() {
        ToNumber toNumber = this;
        synchronized (toNumber) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.numberFormat = this.right().eval(this.right().eval$default$1()).toString().toUpperCase(Locale.ROOT);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.numberFormat;
    }

    private String numberFormat() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.numberFormat$lzycompute() : this.numberFormat;
    }

    private ToNumberParser numberFormatter$lzycompute() {
        ToNumber toNumber = this;
        synchronized (toNumber) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.numberFormatter = new ToNumberParser(this.numberFormat(), true);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.numberFormatter;
    }

    private ToNumberParser numberFormatter() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.numberFormatter$lzycompute() : this.numberFormatter;
    }

    @Override
    public DataType dataType() {
        return this.numberFormatter().parsedDecimalType();
    }

    public Seq<DataType> inputTypes() {
        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StringType$[]{StringType$.MODULE$, StringType$.MODULE$}));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public TypeCheckResult checkInputDataTypes() {
        void var1_1;
        TypeCheckResult inputTypeCheck = ExpectsInputTypes.checkInputDataTypes$(this);
        return inputTypeCheck.isSuccess() ? (this.right().foldable() ? this.numberFormatter().check() : new TypeCheckResult.TypeCheckFailure(new StringBuilder(44).append("Format expression must be foldable, but got ").append(this.right()).toString())) : var1_1;
    }

    @Override
    public String prettyName() {
        return "to_number";
    }

    @Override
    public Object nullSafeEval(Object string, Object format) {
        UTF8String input = (UTF8String)string;
        return this.numberFormatter().parse(input);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String builder = ctx.addReferenceObj("builder", this.numberFormatter(), ToNumberParser.class.getName());
        ExprCode eval = this.left().genCode(ctx);
        return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n        |", "\n        |boolean ", " = ", ";\n        |", " ", " = ", ";\n        |if (!", ") {\n        |  ", " = ", ".parse(", ");\n        |}\n      "}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{eval.code(), ev.isNull(), eval.isNull(), CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), CodeGenerator$.MODULE$.defaultValue(this.dataType(), CodeGenerator$.MODULE$.defaultValue$default$2()), ev.isNull(), ev.value(), builder, eval.value()})).stripMargin(), ev.copy$default$2(), ev.copy$default$3());
    }

    @Override
    public ToNumber withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    public ToNumber copy(Expression left, Expression right) {
        return new ToNumber(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "ToNumber";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.left();
                break;
            }
            case 1: {
                object = this.right();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ToNumber;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "left";
                break;
            }
            case 1: {
                string = "right";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ToNumber)) return false;
        boolean bl = true;
        if (!bl) return false;
        ToNumber toNumber = (ToNumber)x$1;
        Expression expression = this.left();
        Expression expression2 = toNumber.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = toNumber.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!toNumber.canEqual(this)) return false;
        return true;
    }

    public ToNumber(Expression left, Expression right) {
        this.left = left;
        this.right = right;
        ExpectsInputTypes.$init$(this);
    }
}

