/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.util.Locale;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.ToNumber;
import org.apache.spark.sql.catalyst.expressions.TryToNumber$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.util.ToNumberParser;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n     _FUNC_(expr, fmt) - Convert string 'expr' to a number based on the string format `fmt`.\n       Returns NULL if the string 'expr' does not match the expected format. The format follows the\n       same semantics as the to_number function.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('454', '999');\n       454\n      > SELECT _FUNC_('454.00', '000.00');\n       454.00\n      > SELECT _FUNC_('12,454', '99,999');\n       12454\n      > SELECT _FUNC_('$78.12', '$99.99');\n       78.12\n      > SELECT _FUNC_('12,454.8-', '99,999.9S');\n       -12454.8\n  ", since="3.3.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0005\t}a\u0001B\u0011#\u0001>B\u0001b\u0014\u0001\u0003\u0016\u0004%\t\u0001\u0015\u0005\t)\u0002\u0011\t\u0012)A\u0005#\"AQ\u000b\u0001BK\u0002\u0013\u0005\u0001\u000b\u0003\u0005W\u0001\tE\t\u0015!\u0003R\u0011\u00159\u0006\u0001\"\u0001Y\u0011!a\u0006\u0001#b\u0001\n\u0013i\u0006\u0002\u00034\u0001\u0011\u000b\u0007I\u0011B4\t\u000b9\u0004A\u0011I8\t\u000bY\u0004A\u0011I<\t\u000bm\u0004A\u0011\t?\t\u000f\u0005\u0005\u0001\u0001\"\u0011\u0002\u0004!9\u0011\u0011\u0003\u0001\u0005B\u0005M\u0001bBA\u0012\u0001\u0011\u0005\u0013Q\u0005\u0005\b\u0003k\u0001A\u0011IA\u001c\u0011\u001d\t\u0019\u0006\u0001C)\u0003+B\u0011\"a\u0018\u0001\u0003\u0003%\t!!\u0019\t\u0013\u0005\u001d\u0004!%A\u0005\u0002\u0005%\u0004\"CA@\u0001E\u0005I\u0011AA5\u0011!\t\t\tAA\u0001\n\u0003j\u0006\"CAB\u0001\u0005\u0005I\u0011AAC\u0011%\ti\tAA\u0001\n\u0003\ty\tC\u0005\u0002\u0016\u0002\t\t\u0011\"\u0011\u0002\u0018\"I\u0011Q\u0015\u0001\u0002\u0002\u0013\u0005\u0011q\u0015\u0005\n\u0003W\u0003\u0011\u0011!C!\u0003[C\u0011\"!-\u0001\u0003\u0003%\t%a-\b\u0013\u0005]'%!A\t\u0002\u0005eg\u0001C\u0011#\u0003\u0003E\t!a7\t\r][B\u0011AAz\u0011%\t)pGA\u0001\n\u000b\n9\u0010C\u0005\u0002zn\t\t\u0011\"!\u0002|\"I!\u0011A\u000e\u0002\u0002\u0013\u0005%1\u0001\u0005\n\u0005+Y\u0012\u0011!C\u0005\u0005/\u00111\u0002\u0016:z)>tU/\u001c2fe*\u00111\u0005J\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002&M\u0005A1-\u0019;bYf\u001cHO\u0003\u0002(Q\u0005\u00191/\u001d7\u000b\u0005%R\u0013!B:qCJ\\'BA\u0016-\u0003\u0019\t\u0007/Y2iK*\tQ&A\u0002pe\u001e\u001c\u0001a\u0005\u0004\u0001aQ:d\b\u0012\t\u0003cIj\u0011AI\u0005\u0003g\t\u0012\u0001CQ5oCJLX\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005E*\u0014B\u0001\u001c#\u0005YIU\u000e\u001d7jG&$8)Y:u\u0013:\u0004X\u000f\u001e+za\u0016\u001c\bC\u0001\u001d<\u001d\t\t\u0014(\u0003\u0002;E\u00059\u0001/Y2lC\u001e,\u0017B\u0001\u001f>\u00059qU\u000f\u001c7J]R|G.\u001a:b]RT!A\u000f\u0012\u0011\u0005}\u0012U\"\u0001!\u000b\u0003\u0005\u000bQa]2bY\u0006L!a\u0011!\u0003\u000fA\u0013x\u000eZ;diB\u0011Q\t\u0014\b\u0003\r.s!a\u0012&\u000e\u0003!S!!\u0013\u0018\u0002\rq\u0012xn\u001c;?\u0013\u0005\t\u0015B\u0001\u001eA\u0013\tieJ\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u0002;\u0001\u0006!A.\u001a4u+\u0005\t\u0006CA\u0019S\u0013\t\u0019&E\u0001\u0006FqB\u0014Xm]:j_:\fQ\u0001\\3gi\u0002\nQA]5hQR\faA]5hQR\u0004\u0013A\u0002\u001fj]&$h\bF\u0002Z5n\u0003\"!\r\u0001\t\u000b=+\u0001\u0019A)\t\u000bU+\u0001\u0019A)\u0002\u00199,XNY3s\r>\u0014X.\u0019;\u0016\u0003y\u0003\"a\u00183\u000e\u0003\u0001T!!\u00192\u0002\t1\fgn\u001a\u0006\u0002G\u0006!!.\u0019<b\u0013\t)\u0007M\u0001\u0004TiJLgnZ\u0001\u0010]Vl'-\u001a:G_Jl\u0017\r\u001e;feV\t\u0001\u000e\u0005\u0002jY6\t!N\u0003\u0002lI\u0005!Q\u000f^5m\u0013\ti'N\u0001\bU_:+XNY3s!\u0006\u00148/\u001a:\u0002\u0011\u0011\fG/\u0019+za\u0016,\u0012\u0001\u001d\t\u0003cRl\u0011A\u001d\u0006\u0003g\u001a\nQ\u0001^=qKNL!!\u001e:\u0003\u0011\u0011\u000bG/\u0019+za\u0016\f!\"\u001b8qkR$\u0016\u0010]3t+\u0005A\bcA#za&\u0011!P\u0014\u0002\u0004'\u0016\f\u0018\u0001\u00038vY2\f'\r\\3\u0016\u0003u\u0004\"a\u0010@\n\u0005}\u0004%a\u0002\"p_2,\u0017M\\\u0001\u0014G\",7m[%oaV$H)\u0019;b)f\u0004Xm\u001d\u000b\u0003\u0003\u000b\u0001B!a\u0002\u0002\u000e5\u0011\u0011\u0011\u0002\u0006\u0004\u0003\u0017!\u0013\u0001C1oC2L8/[:\n\t\u0005=\u0011\u0011\u0002\u0002\u0010)f\u0004Xm\u00115fG.\u0014Vm];mi\u0006Q\u0001O]3uift\u0015-\\3\u0016\u0005\u0005U\u0001\u0003BA\f\u0003?qA!!\u0007\u0002\u001cA\u0011q\tQ\u0005\u0004\u0003;\u0001\u0015A\u0002)sK\u0012,g-C\u0002f\u0003CQ1!!\bA\u00031qW\u000f\u001c7TC\u001a,WI^1m)\u0019\t9#!\f\u00022A\u0019q(!\u000b\n\u0007\u0005-\u0002IA\u0002B]fDq!a\f\u000e\u0001\u0004\t9#\u0001\u0004tiJLgn\u001a\u0005\b\u0003gi\u0001\u0019AA\u0014\u0003\u00191wN]7bi\u0006IAm\\$f]\u000e{G-\u001a\u000b\u0007\u0003s\t)%a\u0014\u0011\t\u0005m\u0012\u0011I\u0007\u0003\u0003{Q1!a\u0010#\u0003\u001d\u0019w\u000eZ3hK:LA!a\u0011\u0002>\tAQ\t\u001f9s\u0007>$W\rC\u0004\u0002H9\u0001\r!!\u0013\u0002\u0007\r$\b\u0010\u0005\u0003\u0002<\u0005-\u0013\u0002BA'\u0003{\u0011abQ8eK\u001e,gnQ8oi\u0016DH\u000fC\u0004\u0002R9\u0001\r!!\u000f\u0002\u0005\u00154\u0018aF<ji\"tUm^\"iS2$'/\u001a8J]R,'O\\1m)\u0015I\u0016qKA.\u0011\u0019\tIf\u0004a\u0001#\u00069a.Z<MK\u001a$\bBBA/\u001f\u0001\u0007\u0011+\u0001\u0005oK^\u0014\u0016n\u001a5u\u0003\u0011\u0019w\u000e]=\u0015\u000be\u000b\u0019'!\u001a\t\u000f=\u0003\u0002\u0013!a\u0001#\"9Q\u000b\u0005I\u0001\u0002\u0004\t\u0016AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003WR3!UA7W\t\ty\u0007\u0005\u0003\u0002r\u0005mTBAA:\u0015\u0011\t)(a\u001e\u0002\u0013Ut7\r[3dW\u0016$'bAA=\u0001\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005u\u00141\u000f\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005\u001d\u0005cA \u0002\n&\u0019\u00111\u0012!\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005\u001d\u0012\u0011\u0013\u0005\n\u0003'+\u0012\u0011!a\u0001\u0003\u000f\u000b1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAAM!\u0019\tY*!)\u0002(5\u0011\u0011Q\u0014\u0006\u0004\u0003?\u0003\u0015AC2pY2,7\r^5p]&!\u00111UAO\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\u0007u\fI\u000bC\u0005\u0002\u0014^\t\t\u00111\u0001\u0002(\u0005\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\rq\u0016q\u0016\u0005\n\u0003'C\u0012\u0011!a\u0001\u0003\u000f\u000ba!Z9vC2\u001cHcA?\u00026\"I\u00111S\r\u0002\u0002\u0003\u0007\u0011q\u0005\u0015\u0014\u0001\u0005e\u0016qXAa\u0003\u000b\f9-a3\u0002N\u0006E\u00171\u001b\t\u0004c\u0005m\u0016bAA_E\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017EAAb\u0003\u0005-(\u0002\t\u0011!A\u0001zf)\u0016(D?\"*\u0007\u0010\u001d:-A\u0019lG/\u000b\u0011.A\r{gN^3si\u0002\u001aHO]5oO\u0002:S\r\u001f9sO\u0001\"x\u000eI1!]Vl'-\u001a:!E\u0006\u001cX\r\u001a\u0011p]\u0002\"\b.\u001a\u0011tiJLgn\u001a\u0011g_Jl\u0017\r\u001e\u0011aM6$\bM\f\u0006!A\u0001\u0002\u0003\u0005\t\u0011SKR,(O\\:!\u001dVcE\nI5gAQDW\rI:ue&tw\rI\u0014fqB\u0014x\u0005\t3pKN\u0004cn\u001c;![\u0006$8\r\u001b\u0011uQ\u0016\u0004S\r\u001f9fGR,G\r\t4pe6\fGO\f\u0011UQ\u0016\u0004cm\u001c:nCR\u0004cm\u001c7m_^\u001c\b\u0005\u001e5f\u0015\u0001\u0002\u0003\u0005\t\u0011!AM\fW.\u001a\u0011tK6\fg\u000e^5dg\u0002\n7\u000f\t;iK\u0002\"xn\u00188v[\n,'\u000f\t4v]\u000e$\u0018n\u001c8/\u0015\u0001\u0002\u0013\u0001C3yC6\u0004H.Z:\"\u0005\u0005%\u0017Aa\u0016\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001d\"T\u0007N\u0014-A\u001dJ\u0014(O\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001\"T\u0007\u000e\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)OQ*DG\f\u00191O1\u0002s\u0005\r\u00191]A\u0002t%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!iU\"d\u0006\r\u0019\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001d\n$\u0007\f\u001b6i\u001db\u0003eJ\u001d:YeJ\u0014hJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AE\u0012D'\u000e\u001b\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001d\"s\u0007\u000f\u00182e\u001db\u0003e\n\u0013:s9J\u0014hJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!A]Bd&\r\u001a\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001d\n$\u0007\f\u001b6i9BTf\n\u0017!OeJD&O\u001d:]e\u001av%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011![E\u0012D'\u000e\u001b/q)\u0001\u0003%A\u0003tS:\u001cW-\t\u0002\u0002P\u0006)1GL\u001a/a\u0005)qM]8va\u0006\u0012\u0011Q[\u0001\rgR\u0014\u0018N\\4`MVt7m]\u0001\f)JLHk\u001c(v[\n,'\u000f\u0005\u000227M)1$!8\u0002jB9\u0011q\\As#FKVBAAq\u0015\r\t\u0019\u000fQ\u0001\beVtG/[7f\u0013\u0011\t9/!9\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t'\u0007\u0005\u0003\u0002l\u0006EXBAAw\u0015\r\tyOY\u0001\u0003S>L1!TAw)\t\tI.\u0001\u0005u_N#(/\u001b8h)\u0005q\u0016!B1qa2LH#B-\u0002~\u0006}\b\"B(\u001f\u0001\u0004\t\u0006\"B+\u001f\u0001\u0004\t\u0016aB;oCB\u0004H.\u001f\u000b\u0005\u0005\u000b\u0011\t\u0002E\u0003@\u0005\u000f\u0011Y!C\u0002\u0003\n\u0001\u0013aa\u00149uS>t\u0007#B \u0003\u000eE\u000b\u0016b\u0001B\b\u0001\n1A+\u001e9mKJB\u0001Ba\u0005 \u0003\u0003\u0005\r!W\u0001\u0004q\u0012\u0002\u0014\u0001D<sSR,'+\u001a9mC\u000e,GC\u0001B\r!\ry&1D\u0005\u0004\u0005;\u0001'AB(cU\u0016\u001cG\u000f")
public class TryToNumber
extends BinaryExpression
implements ImplicitCastInputTypes,
package.NullIntolerant,
Serializable {
    private String numberFormat;
    private ToNumberParser numberFormatter;
    private final Expression left;
    private final Expression right;
    private volatile byte bitmap$0;

    public static Option<Tuple2<Expression, Expression>> unapply(TryToNumber x$0) {
        return TryToNumber$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple2<Expression, Expression>, TryToNumber> tupled() {
        return TryToNumber$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, TryToNumber>> curried() {
        return TryToNumber$.MODULE$.curried();
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    private String numberFormat$lzycompute() {
        TryToNumber tryToNumber = this;
        synchronized (tryToNumber) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.numberFormat = this.right().eval(this.right().eval$default$1()).toString().toUpperCase(Locale.ROOT);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.numberFormat;
    }

    private String numberFormat() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.numberFormat$lzycompute() : this.numberFormat;
    }

    private ToNumberParser numberFormatter$lzycompute() {
        TryToNumber tryToNumber = this;
        synchronized (tryToNumber) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.numberFormatter = new ToNumberParser(this.numberFormat(), false);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.numberFormatter;
    }

    private ToNumberParser numberFormatter() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.numberFormatter$lzycompute() : this.numberFormatter;
    }

    @Override
    public DataType dataType() {
        return this.numberFormatter().parsedDecimalType();
    }

    public Seq<DataType> inputTypes() {
        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StringType$[]{StringType$.MODULE$, StringType$.MODULE$}));
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return new ToNumber(this.left(), this.right()).checkInputDataTypes();
    }

    @Override
    public String prettyName() {
        return "try_to_number";
    }

    @Override
    public Object nullSafeEval(Object string, Object format) {
        UTF8String input = (UTF8String)string;
        return this.numberFormatter().parse(input);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String builder = ctx.addReferenceObj("builder", this.numberFormatter(), ToNumberParser.class.getName());
        ExprCode eval = this.left().genCode(ctx);
        return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n        |", "\n        |boolean ", " = ", ";\n        |", " ", " = ", ";\n        |if (!", ") {\n        |  ", " = ", ".parse(", ");\n        |}\n      "}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{eval.code(), ev.isNull(), eval.isNull(), CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), CodeGenerator$.MODULE$.defaultValue(this.dataType(), CodeGenerator$.MODULE$.defaultValue$default$2()), ev.isNull(), ev.value(), builder, eval.value()})).stripMargin(), ev.copy$default$2(), ev.copy$default$3());
    }

    @Override
    public TryToNumber withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    public TryToNumber copy(Expression left, Expression right) {
        return new TryToNumber(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "TryToNumber";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.left();
                break;
            }
            case 1: {
                object = this.right();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof TryToNumber;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "left";
                break;
            }
            case 1: {
                string = "right";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof TryToNumber)) return false;
        boolean bl = true;
        if (!bl) return false;
        TryToNumber tryToNumber = (TryToNumber)x$1;
        Expression expression = this.left();
        Expression expression2 = tryToNumber.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = tryToNumber.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!tryToNumber.canEqual(this)) return false;
        return true;
    }

    public TryToNumber(Expression left, Expression right) {
        this.left = left;
        this.right = right;
        ExpectsInputTypes.$init$(this);
    }
}

