/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.errors;

import java.io.Serializable;
import java.util.Locale;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.util.package$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import scala.Function1;
import scala.Predef$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;
import scala.runtime.RichFloat$;

@ScalaSignature(bytes="\u0006\u0005-4\u0001b\u0003\u0007\u0011\u0002\u0007\u0005aB\u0006\u0005\u0006;\u0001!\ta\b\u0005\u0006G\u0001!\t\u0001\n\u0005\u0006{\u0001!IA\u0010\u0005\u0006\u0003\u0002!\tA\u0011\u0005\u0006\u000b\u0002!\tA\u0012\u0005\u0006\u000b\u0002!\tA\u0015\u0005\u0006)\u0002!\t!\u0016\u0005\u0006/\u0002!\t\u0001\u0017\u0005\u00067\u0002!\t\u0001\u0018\u0005\u0006?\u0002!\t\u0001\u0019\u0002\u0010#V,'/_#se>\u00148OQ1tK*\u0011QBD\u0001\u0007KJ\u0014xN]:\u000b\u0005=\u0001\u0012aA:rY*\u0011\u0011CE\u0001\u0006gB\f'o\u001b\u0006\u0003'Q\ta!\u00199bG\",'\"A\u000b\u0002\u0007=\u0014xm\u0005\u0002\u0001/A\u0011\u0001dG\u0007\u00023)\t!$A\u0003tG\u0006d\u0017-\u0003\u0002\u001d3\t1\u0011I\\=SK\u001a\fa\u0001J5oSR$3\u0001\u0001\u000b\u0002AA\u0011\u0001$I\u0005\u0003Ee\u0011A!\u00168ji\u0006QAo\\*R\u0019Z\u000bG.^3\u0015\u0007\u0015\u0002T\u0007\u0005\u0002'[9\u0011qe\u000b\t\u0003Qei\u0011!\u000b\u0006\u0003Uy\ta\u0001\u0010:p_Rt\u0014B\u0001\u0017\u001a\u0003\u0019\u0001&/\u001a3fM&\u0011af\f\u0002\u0007'R\u0014\u0018N\\4\u000b\u00051J\u0002\"B\u0019\u0003\u0001\u0004\u0011\u0014!\u0001<\u0011\u0005a\u0019\u0014B\u0001\u001b\u001a\u0005\r\te.\u001f\u0005\u0006m\t\u0001\raN\u0001\u0002iB\u0011\u0001hO\u0007\u0002s)\u0011!HD\u0001\u0006if\u0004Xm]\u0005\u0003ye\u0012\u0001\u0002R1uCRK\b/Z\u0001\u000fcV|G/\u001a\"z\t\u00164\u0017-\u001e7u)\t)s\bC\u0003A\u0007\u0001\u0007Q%\u0001\u0003fY\u0016l\u0017!\u0003;p'Fc5\u000b^7u)\t)3\tC\u0003E\t\u0001\u0007Q%\u0001\u0003uKb$\u0018a\u0002;p'Fc\u0015\n\u001a\u000b\u0003K\u001dCQ\u0001S\u0003A\u0002%\u000bQ\u0001]1siN\u00042AS(&\u001d\tYUJ\u0004\u0002)\u0019&\t!$\u0003\u0002O3\u00059\u0001/Y2lC\u001e,\u0017B\u0001)R\u0005\r\u0019V-\u001d\u0006\u0003\u001df!\"!J*\t\u000b!3\u0001\u0019A\u0013\u0002\u0013Q|7+\u0015'UsB,GCA\u0013W\u0011\u00151t\u00011\u00018\u0003%!xnU)M\u0007>tg\r\u0006\u0002&3\")!\f\u0003a\u0001K\u0005!1m\u001c8g\u0003)!x\u000eR*PaRLwN\u001c\u000b\u0003KuCQAX\u0005A\u0002\u0015\naa\u001c9uS>t\u0017!\u0003;p'FcU\t\u001f9s)\t)\u0013\rC\u0003c\u0015\u0001\u00071-A\u0001f!\t!\u0017.D\u0001f\u0015\t1w-A\u0006fqB\u0014Xm]:j_:\u001c(B\u00015\u000f\u0003!\u0019\u0017\r^1msN$\u0018B\u00016f\u0005))\u0005\u0010\u001d:fgNLwN\u001c")
public interface QueryErrorsBase {
    public static /* synthetic */ String toSQLValue$(QueryErrorsBase $this, Object v, DataType t) {
        return $this.toSQLValue(v, t);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    default public String toSQLValue(Object v, DataType t) {
        Object object;
        Literal literal = Literal$.MODULE$.create(v, t);
        if (literal != null && (object = literal.value()) == null) {
            return "NULL";
        }
        if (literal != null) {
            Object v2 = literal.value();
            DataType dataType = literal.dataType();
            if (v2 instanceof Float) {
                float f = BoxesRunTime.unboxToFloat((Object)v2);
                if (FloatType$.MODULE$.equals(dataType)) {
                    if (Float.isNaN(f)) {
                        return "NaN";
                    }
                    if (RichFloat$.MODULE$.isPosInfinity$extension(Predef$.MODULE$.floatWrapper(f))) {
                        return "Infinity";
                    }
                    if (RichFloat$.MODULE$.isNegInfinity$extension(Predef$.MODULE$.floatWrapper(f))) {
                        return "-Infinity";
                    }
                    String string = Float.toString(f);
                    return string;
                }
            }
        }
        if (literal == null) return literal.sql();
        Object v3 = literal.value();
        DataType dataType = literal.dataType();
        if (!(v3 instanceof Double)) return literal.sql();
        double d = BoxesRunTime.unboxToDouble((Object)v3);
        if (!DoubleType$.MODULE$.equals(dataType)) return literal.sql();
        if (Double.isNaN(d)) {
            return "NaN";
        }
        if (RichDouble$.MODULE$.isPosInfinity$extension(Predef$.MODULE$.doubleWrapper(d))) {
            return "Infinity";
        }
        if (RichDouble$.MODULE$.isNegInfinity$extension(Predef$.MODULE$.doubleWrapper(d))) {
            return "-Infinity";
        }
        String string = literal.sql();
        return string;
    }

    private String quoteByDefault(String elem) {
        return new StringBuilder(2).append("\"").append(elem).append("\"").toString();
    }

    public static /* synthetic */ String toSQLStmt$(QueryErrorsBase $this, String text) {
        return $this.toSQLStmt(text);
    }

    default public String toSQLStmt(String text) {
        return text.toUpperCase(Locale.ROOT);
    }

    public static /* synthetic */ String toSQLId$(QueryErrorsBase $this, Seq parts) {
        return $this.toSQLId((Seq<String>)parts);
    }

    default public String toSQLId(Seq<String> parts) {
        return ((IterableOnceOps)parts.map((Function1 & Serializable)name -> package$.MODULE$.quoteIdentifier((String)name))).mkString(".");
    }

    public static /* synthetic */ String toSQLId$(QueryErrorsBase $this, String parts) {
        return $this.toSQLId(parts);
    }

    default public String toSQLId(String parts) {
        return this.toSQLId((Seq<String>)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)parts.split("\\.")));
    }

    public static /* synthetic */ String toSQLType$(QueryErrorsBase $this, DataType t) {
        return $this.toSQLType(t);
    }

    default public String toSQLType(DataType t) {
        return this.quoteByDefault(t.sql());
    }

    public static /* synthetic */ String toSQLConf$(QueryErrorsBase $this, String conf) {
        return $this.toSQLConf(conf);
    }

    default public String toSQLConf(String conf) {
        return this.quoteByDefault(conf);
    }

    public static /* synthetic */ String toDSOption$(QueryErrorsBase $this, String option) {
        return $this.toDSOption(option);
    }

    default public String toDSOption(String option) {
        return this.quoteByDefault(option);
    }

    public static /* synthetic */ String toSQLExpr$(QueryErrorsBase $this, Expression e) {
        return $this.toSQLExpr(e);
    }

    default public String toSQLExpr(Expression e) {
        return this.quoteByDefault(package$.MODULE$.toPrettySQL(e));
    }

    public static void $init$(QueryErrorsBase $this) {
    }
}

