/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.analysis;

import java.io.File;
import java.io.Serializable;
import java.time.ZoneId;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.analysis.AnalysisTest;
import org.apache.spark.sql.catalyst.analysis.Analyzer;
import org.apache.spark.sql.catalyst.analysis.TestRelations$;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAttribute;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAttribute$;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.dsl.package;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.AliasHelper;
import org.apache.spark.sql.catalyst.expressions.Ascending$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.LeafExpression;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.PredicateHelper;
import org.apache.spark.sql.catalyst.expressions.SortDirection;
import org.apache.spark.sql.catalyst.expressions.SortOrder;
import org.apache.spark.sql.catalyst.expressions.SortOrder$;
import org.apache.spark.sql.catalyst.parser.CatalystSqlParser$;
import org.apache.spark.sql.catalyst.plans.Inner$;
import org.apache.spark.sql.catalyst.plans.JoinType;
import org.apache.spark.sql.catalyst.plans.PlanTestBase;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.catalyst.plans.logical.Aggregate;
import org.apache.spark.sql.catalyst.plans.logical.BROADCAST$;
import org.apache.spark.sql.catalyst.plans.logical.HintInfo;
import org.apache.spark.sql.catalyst.plans.logical.Join;
import org.apache.spark.sql.catalyst.plans.logical.JoinHint$;
import org.apache.spark.sql.catalyst.plans.logical.JoinStrategyHint;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.plans.logical.RebalancePartitions;
import org.apache.spark.sql.catalyst.plans.logical.RebalancePartitions$;
import org.apache.spark.sql.catalyst.plans.logical.Repartition;
import org.apache.spark.sql.catalyst.plans.logical.RepartitionByExpression;
import org.apache.spark.sql.catalyst.plans.logical.RepartitionByExpression$;
import org.apache.spark.sql.catalyst.plans.logical.ResolvedHint;
import org.apache.spark.sql.catalyst.plans.logical.SHUFFLE_HASH$;
import org.apache.spark.sql.catalyst.plans.logical.SHUFFLE_MERGE$;
import org.apache.spark.sql.catalyst.plans.logical.SHUFFLE_REPLICATE_NL$;
import org.apache.spark.sql.catalyst.plans.logical.UnresolvedHint;
import org.apache.spark.sql.catalyst.rules.Rule;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.Metadata;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.compatible.Assertion;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Symbol;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005q1AAA\u0002\u0001!!)\u0011\u0004\u0001C\u00015\t\t\"+Z:pYZ,\u0007*\u001b8ugN+\u0018\u000e^3\u000b\u0005\u0011)\u0011\u0001C1oC2L8/[:\u000b\u0005\u00199\u0011\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005!I\u0011aA:rY*\u0011!bC\u0001\u0006gB\f'o\u001b\u0006\u0003\u00195\ta!\u00199bG\",'\"\u0001\b\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001\tR\u0003\u0005\u0002\u0013'5\t\u0011\"\u0003\u0002\u0015\u0013\ti1\u000b]1sW\u001a+hnU;ji\u0016\u0004\"AF\f\u000e\u0003\rI!\u0001G\u0002\u0003\u0019\u0005s\u0017\r\\=tSN$Vm\u001d;\u0002\rqJg.\u001b;?)\u0005Y\u0002C\u0001\f\u0001\u0001")
public class ResolveHintsSuite
extends SparkFunSuite
implements AnalysisTest {
    private String sparkHome;
    private volatile boolean bitmap$0;

    @Override
    public /* synthetic */ void org$apache$spark$sql$catalyst$analysis$AnalysisTest$$super$comparePlans(LogicalPlan plan1, LogicalPlan plan2, boolean checkAnalysis) {
        PlanTestBase.comparePlans$(this, plan1, plan2, checkAnalysis);
    }

    @Override
    public Seq<Rule<LogicalPlan>> extendedAnalysisRules() {
        return AnalysisTest.extendedAnalysisRules$(this);
    }

    @Override
    public void createTempView(SessionCatalog catalog, String name, LogicalPlan plan, boolean overrideIfExists) {
        AnalysisTest.createTempView$(this, catalog, name, plan, overrideIfExists);
    }

    @Override
    public void createGlobalTempView(SessionCatalog catalog, String name, LogicalPlan plan, boolean overrideIfExists) {
        AnalysisTest.createGlobalTempView$(this, catalog, name, plan, overrideIfExists);
    }

    @Override
    public Analyzer getAnalyzer() {
        return AnalysisTest.getAnalyzer$(this);
    }

    @Override
    public void checkAnalysis(LogicalPlan inputPlan, LogicalPlan expectedPlan, boolean caseSensitive) {
        AnalysisTest.checkAnalysis$(this, inputPlan, expectedPlan, caseSensitive);
    }

    @Override
    public boolean checkAnalysis$default$3() {
        return AnalysisTest.checkAnalysis$default$3$(this);
    }

    @Override
    public void checkAnalysisWithoutViewWrapper(LogicalPlan inputPlan, LogicalPlan expectedPlan, boolean caseSensitive, boolean inlineCTE) {
        AnalysisTest.checkAnalysisWithoutViewWrapper$(this, inputPlan, expectedPlan, caseSensitive, inlineCTE);
    }

    @Override
    public boolean checkAnalysisWithoutViewWrapper$default$3() {
        return AnalysisTest.checkAnalysisWithoutViewWrapper$default$3$(this);
    }

    @Override
    public boolean checkAnalysisWithoutViewWrapper$default$4() {
        return AnalysisTest.checkAnalysisWithoutViewWrapper$default$4$(this);
    }

    @Override
    public void comparePlans(LogicalPlan plan1, LogicalPlan plan2, boolean checkAnalysis) {
        AnalysisTest.comparePlans$(this, plan1, plan2, checkAnalysis);
    }

    @Override
    public boolean comparePlans$default$3() {
        return AnalysisTest.comparePlans$default$3$(this);
    }

    @Override
    public void assertAnalysisSuccess(LogicalPlan inputPlan, boolean caseSensitive) {
        AnalysisTest.assertAnalysisSuccess$(this, inputPlan, caseSensitive);
    }

    @Override
    public boolean assertAnalysisSuccess$default$2() {
        return AnalysisTest.assertAnalysisSuccess$default$2$(this);
    }

    @Override
    public void assertAnalysisError(LogicalPlan inputPlan, Seq<String> expectedErrors, boolean caseSensitive) {
        AnalysisTest.assertAnalysisError$(this, inputPlan, expectedErrors, caseSensitive);
    }

    @Override
    public boolean assertAnalysisError$default$3() {
        return AnalysisTest.assertAnalysisError$default$3$(this);
    }

    @Override
    public void assertAnalysisErrorClass(LogicalPlan inputPlan, String expectedErrorClass, String[] expectedMessageParameters, boolean caseSensitive) {
        AnalysisTest.assertAnalysisErrorClass$(this, inputPlan, expectedErrorClass, expectedMessageParameters, caseSensitive);
    }

    @Override
    public boolean assertAnalysisErrorClass$default$4() {
        return AnalysisTest.assertAnalysisErrorClass$default$4$(this);
    }

    @Override
    public void interceptParseException(Function1<String, Object> parser, String sqlCommand, Seq<String> messages, Option<String> errorClass) {
        AnalysisTest.interceptParseException$(this, parser, sqlCommand, messages, errorClass);
    }

    @Override
    public Option<String> interceptParseException$default$4(Function1<String, Object> parser, String sqlCommand, Seq<String> messages) {
        return AnalysisTest.interceptParseException$default$4$(this, parser, sqlCommand, messages);
    }

    @Override
    public LogicalPlan normalizeExprIds(LogicalPlan plan) {
        return PlanTestBase.normalizeExprIds$(this, plan);
    }

    @Override
    public LogicalPlan rewriteNameFromAttrNullability(LogicalPlan plan) {
        return PlanTestBase.rewriteNameFromAttrNullability$(this, plan);
    }

    @Override
    public LogicalPlan normalizePlan(LogicalPlan plan) {
        return PlanTestBase.normalizePlan$(this, plan);
    }

    @Override
    public void compareExpressions(Expression e1, Expression e2) {
        PlanTestBase.compareExpressions$(this, e1, e2);
    }

    public SQLConf conf() {
        return SQLConfHelper.conf$((SQLConfHelper)this);
    }

    @Override
    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLHelper.withSQLConf$(this, pairs, f);
    }

    @Override
    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$(this, f);
    }

    @Override
    public <T> void testSpecialDatetimeValues(Function1<ZoneId, T> test) {
        SQLHelper.testSpecialDatetimeValues$(this, test);
    }

    public Seq<Expression> splitConjunctivePredicates(Expression condition) {
        return PredicateHelper.splitConjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Option<Tuple2<Expression, LogicalPlan>> findExpressionAndTrackLineageDown(Expression exp, LogicalPlan plan) {
        return PredicateHelper.findExpressionAndTrackLineageDown$((PredicateHelper)this, (Expression)exp, (LogicalPlan)plan);
    }

    public Seq<Expression> splitDisjunctivePredicates(Expression condition) {
        return PredicateHelper.splitDisjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Expression buildBalancedPredicate(Seq<Expression> expressions, Function2<Expression, Expression, Expression> op) {
        return PredicateHelper.buildBalancedPredicate$((PredicateHelper)this, expressions, op);
    }

    public boolean canEvaluate(Expression expr, LogicalPlan plan) {
        return PredicateHelper.canEvaluate$((PredicateHelper)this, (Expression)expr, (LogicalPlan)plan);
    }

    public boolean canEvaluateWithinJoin(Expression expr) {
        return PredicateHelper.canEvaluateWithinJoin$((PredicateHelper)this, (Expression)expr);
    }

    public Option<Expression> extractPredicatesWithinOutputSet(Expression condition, AttributeSet outputSet) {
        return PredicateHelper.extractPredicatesWithinOutputSet$((PredicateHelper)this, (Expression)condition, (AttributeSet)outputSet);
    }

    public boolean isNullIntolerant(Expression expr) {
        return PredicateHelper.isNullIntolerant$((PredicateHelper)this, (Expression)expr);
    }

    public Seq<Attribute> outputWithNullability(Seq<Attribute> output, Seq<ExprId> nonNullAttrExprIds) {
        return PredicateHelper.outputWithNullability$((PredicateHelper)this, output, nonNullAttrExprIds);
    }

    public boolean isLikelySelective(Expression e) {
        return PredicateHelper.isLikelySelective$((PredicateHelper)this, (Expression)e);
    }

    public AttributeMap<Alias> getAliasMap(Project plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Project)plan);
    }

    public AttributeMap<Alias> getAliasMap(Aggregate plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Aggregate)plan);
    }

    public AttributeMap<Alias> getAliasMap(Seq<NamedExpression> exprs) {
        return AliasHelper.getAliasMap$((AliasHelper)this, exprs);
    }

    public Expression replaceAlias(Expression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAlias$((AliasHelper)this, (Expression)expr, aliasMap);
    }

    public NamedExpression replaceAliasButKeepName(NamedExpression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAliasButKeepName$((AliasHelper)this, (NamedExpression)expr, aliasMap);
    }

    public Expression trimAliases(Expression e) {
        return AliasHelper.trimAliases$((AliasHelper)this, (Expression)e);
    }

    public <T extends Expression> T trimNonTopLevelAliases(T e) {
        return (T)AliasHelper.trimNonTopLevelAliases$((AliasHelper)this, e);
    }

    private String sparkHome$lzycompute() {
        ResolveHintsSuite resolveHintsSuite = this;
        synchronized (resolveHintsSuite) {
            if (!this.bitmap$0) {
                this.sparkHome = SQLHelper.sparkHome$(this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkHome;
    }

    @Override
    public String sparkHome() {
        return !this.bitmap$0 ? this.sparkHome$lzycompute() : this.sparkHome;
    }

    public static final /* synthetic */ boolean $anonfun$new$13(LogEvent e) {
        Level level = e.getLevel();
        Level level2 = Level.WARN;
        return !(level != null ? !level.equals(level2) : level2 != null) && e.getMessage().getFormattedMessage().contains("Unrecognized hint: unknown_hint");
    }

    public static final /* synthetic */ void $anonfun$new$16(ResolveHintsSuite $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String hintName = (String)tuple2._1();
        JoinStrategyHint st = (JoinStrategyHint)tuple2._2();
        package.plans$.DslLogicalPlan qual$2 = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"TaBlE"})));
        LogicalPlan x$58 = package.plans$.MODULE$.table((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"TaBlE2"}));
        JoinType x$59 = qual$2.join$default$2();
        Option x$60 = qual$2.join$default$3();
        $this.checkAnalysisWithoutViewWrapper((LogicalPlan)new UnresolvedHint(hintName, (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"table", "table2"})), qual$2.join(x$58, x$59, x$60)), (LogicalPlan)new Join((LogicalPlan)new ResolvedHint((LogicalPlan)TestRelations$.MODULE$.testRelation(), new HintInfo((Option)new Some((Object)st))), (LogicalPlan)new ResolvedHint((LogicalPlan)TestRelations$.MODULE$.testRelation2(), new HintInfo((Option)new Some((Object)st))), (JoinType)Inner$.MODULE$, (Option)None$.MODULE$, JoinHint$.MODULE$.NONE()), false, $this.checkAnalysisWithoutViewWrapper$default$4());
        package.plans$.DslLogicalPlan qual$3 = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"TaBlE"})));
        LogicalPlan x$61 = package.plans$.MODULE$.table((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"TaBlE2"}));
        JoinType x$62 = qual$3.join$default$2();
        Option x$63 = qual$3.join$default$3();
        $this.checkAnalysisWithoutViewWrapper((LogicalPlan)new UnresolvedHint(hintName, (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"TaBlE", "table2"})), qual$3.join(x$61, x$62, x$63)), (LogicalPlan)new Join((LogicalPlan)new ResolvedHint((LogicalPlan)TestRelations$.MODULE$.testRelation(), new HintInfo((Option)new Some((Object)st))), (LogicalPlan)TestRelations$.MODULE$.testRelation2(), (JoinType)Inner$.MODULE$, (Option)None$.MODULE$, JoinHint$.MODULE$.NONE()), true, $this.checkAnalysisWithoutViewWrapper$default$4());
        package.plans$.DslLogicalPlan qual$4 = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"global_temp", "table4"})));
        LogicalPlan x$64 = package.plans$.MODULE$.table((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"global_temp", "table5"}));
        JoinType x$65 = qual$4.join$default$2();
        Option x$66 = qual$4.join$default$3();
        $this.checkAnalysisWithoutViewWrapper((LogicalPlan)new UnresolvedHint(hintName, (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"GlOBal_TeMP.table4", "table5"})), qual$4.join(x$64, x$65, x$66)), (LogicalPlan)new Join((LogicalPlan)new ResolvedHint((LogicalPlan)TestRelations$.MODULE$.testRelation4(), new HintInfo((Option)new Some((Object)st))), (LogicalPlan)new ResolvedHint((LogicalPlan)TestRelations$.MODULE$.testRelation5(), new HintInfo((Option)new Some((Object)st))), (JoinType)Inner$.MODULE$, (Option)None$.MODULE$, JoinHint$.MODULE$.NONE()), false, $this.checkAnalysisWithoutViewWrapper$default$4());
        package.plans$.DslLogicalPlan qual$5 = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"global_temp", "TaBlE4"})));
        LogicalPlan x$67 = package.plans$.MODULE$.table((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"global_temp", "TaBlE5"}));
        JoinType x$68 = qual$5.join$default$2();
        Option x$69 = qual$5.join$default$3();
        $this.checkAnalysisWithoutViewWrapper((LogicalPlan)new UnresolvedHint(hintName, (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"global_temp.TaBlE4", "table5"})), qual$5.join(x$67, x$68, x$69)), (LogicalPlan)new Join((LogicalPlan)new ResolvedHint((LogicalPlan)TestRelations$.MODULE$.testRelation4(), new HintInfo((Option)new Some((Object)st))), (LogicalPlan)TestRelations$.MODULE$.testRelation5(), (JoinType)Inner$.MODULE$, (Option)None$.MODULE$, JoinHint$.MODULE$.NONE()), true, $this.checkAnalysisWithoutViewWrapper$default$4());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public ResolveHintsSuite() {
        AliasHelper.$init$((AliasHelper)this);
        PredicateHelper.$init$((PredicateHelper)this);
        SQLHelper.$init$(this);
        SQLConfHelper.$init$((SQLConfHelper)this);
        PlanTestBase.$init$(this);
        AnalysisTest.$init$(this);
        this.test("invalid hints should be ignored", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.checkAnalysisWithoutViewWrapper((LogicalPlan)new UnresolvedHint("some_random_hint_that_does_not_exist", (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"TaBlE"})), package.plans$.MODULE$.table((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"TaBlE"}))), (LogicalPlan)TestRelations$.MODULE$.testRelation(), false, this.checkAnalysisWithoutViewWrapper$default$4()), new Position("ResolveHintsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 35));
        this.test("case-sensitive or insensitive parameters", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.checkAnalysisWithoutViewWrapper((LogicalPlan)new UnresolvedHint("MAPJOIN", (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"TaBlE"})), package.plans$.MODULE$.table((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"TaBlE"}))), (LogicalPlan)new ResolvedHint((LogicalPlan)TestRelations$.MODULE$.testRelation(), new HintInfo((Option)new Some((Object)BROADCAST$.MODULE$))), false, this.checkAnalysisWithoutViewWrapper$default$4());
            this.checkAnalysisWithoutViewWrapper((LogicalPlan)new UnresolvedHint("MAPJOIN", (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"table"})), package.plans$.MODULE$.table((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"TaBlE"}))), (LogicalPlan)new ResolvedHint((LogicalPlan)TestRelations$.MODULE$.testRelation(), new HintInfo((Option)new Some((Object)BROADCAST$.MODULE$))), false, this.checkAnalysisWithoutViewWrapper$default$4());
            this.checkAnalysisWithoutViewWrapper((LogicalPlan)new UnresolvedHint("MAPJOIN", (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"TaBlE"})), package.plans$.MODULE$.table((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"TaBlE"}))), (LogicalPlan)new ResolvedHint((LogicalPlan)TestRelations$.MODULE$.testRelation(), new HintInfo((Option)new Some((Object)BROADCAST$.MODULE$))), true, this.checkAnalysisWithoutViewWrapper$default$4());
            this.checkAnalysisWithoutViewWrapper((LogicalPlan)new UnresolvedHint("MAPJOIN", (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"table"})), package.plans$.MODULE$.table((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"TaBlE"}))), (LogicalPlan)TestRelations$.MODULE$.testRelation(), true, this.checkAnalysisWithoutViewWrapper$default$4());
        }, new Position("ResolveHintsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 42));
        this.test("multiple broadcast hint aliases", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            package.plans$.DslLogicalPlan qual$1 = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"table"})));
            LogicalPlan x$1 = package.plans$.MODULE$.table((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"table2"}));
            JoinType x$2 = qual$1.join$default$2();
            Option x$3 = qual$1.join$default$3();
            this.checkAnalysisWithoutViewWrapper((LogicalPlan)new UnresolvedHint("MAPJOIN", (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"table", "table2"})), qual$1.join(x$1, x$2, x$3)), (LogicalPlan)new Join((LogicalPlan)new ResolvedHint((LogicalPlan)TestRelations$.MODULE$.testRelation(), new HintInfo((Option)new Some((Object)BROADCAST$.MODULE$))), (LogicalPlan)new ResolvedHint((LogicalPlan)TestRelations$.MODULE$.testRelation2(), new HintInfo((Option)new Some((Object)BROADCAST$.MODULE$))), (JoinType)Inner$.MODULE$, (Option)None$.MODULE$, JoinHint$.MODULE$.NONE()), false, this.checkAnalysisWithoutViewWrapper$default$4());
        }, new Position("ResolveHintsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 64));
        this.test("do not traverse past existing broadcast hints", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.checkAnalysisWithoutViewWrapper((LogicalPlan)new UnresolvedHint("MAPJOIN", (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"table"})), (LogicalPlan)new ResolvedHint(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"table"}))).where((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$greater((Expression)package.expressions$.MODULE$.intToLiteral(1))), new HintInfo((Option)new Some((Object)BROADCAST$.MODULE$)))), package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new ResolvedHint(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)TestRelations$.MODULE$.testRelation()).where((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$greater((Expression)package.expressions$.MODULE$.intToLiteral(1))), new HintInfo((Option)new Some((Object)BROADCAST$.MODULE$)))).analyze(), false, this.checkAnalysisWithoutViewWrapper$default$4()), new Position("ResolveHintsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 73));
        this.test("should work for subqueries", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.checkAnalysisWithoutViewWrapper((LogicalPlan)new UnresolvedHint("MAPJOIN", (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"tableAlias"})), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"table"}))).as("tableAlias")), (LogicalPlan)new ResolvedHint((LogicalPlan)TestRelations$.MODULE$.testRelation(), new HintInfo((Option)new Some((Object)BROADCAST$.MODULE$))), false, this.checkAnalysisWithoutViewWrapper$default$4());
            this.checkAnalysisWithoutViewWrapper((LogicalPlan)new UnresolvedHint("MAPJOIN", (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"tableAlias"})), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"table"}))).subquery((Symbol)SymbolLiteral.bootstrap("apply", "tableAlias"))), (LogicalPlan)new ResolvedHint((LogicalPlan)TestRelations$.MODULE$.testRelation(), new HintInfo((Option)new Some((Object)BROADCAST$.MODULE$))), false, this.checkAnalysisWithoutViewWrapper$default$4());
            this.checkAnalysisWithoutViewWrapper((LogicalPlan)new UnresolvedHint("MAPJOIN", (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"table"})), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"table"}))).as("tableAlias")), (LogicalPlan)TestRelations$.MODULE$.testRelation(), false, this.checkAnalysisWithoutViewWrapper$default$4());
        }, new Position("ResolveHintsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 81));
        this.test("do not traverse past subquery alias", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.checkAnalysisWithoutViewWrapper((LogicalPlan)new UnresolvedHint("MAPJOIN", (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"table"})), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"table"}))).where((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$greater((Expression)package.expressions$.MODULE$.intToLiteral(1)))).subquery((Symbol)SymbolLiteral.bootstrap("apply", "tableAlias"))), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)TestRelations$.MODULE$.testRelation()).where((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$greater((Expression)package.expressions$.MODULE$.intToLiteral(1)))).analyze(), false, this.checkAnalysisWithoutViewWrapper$default$4()), new Position("ResolveHintsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 99));
        this.test("should work for CTE", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.checkAnalysisWithoutViewWrapper(CatalystSqlParser$.MODULE$.parsePlan(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n          |WITH ctetable AS (SELECT * FROM table WHERE a > 1)\n          |SELECT /*+ BROADCAST(ctetable) */ * FROM ctetable\n        "))), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new ResolvedHint(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)TestRelations$.MODULE$.testRelation()).where((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$greater((Expression)package.expressions$.MODULE$.intToLiteral(1)))).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a"))})), new HintInfo((Option)new Some((Object)BROADCAST$.MODULE$)))).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a"))}))).analyze(), false, true), new Position("ResolveHintsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 106));
        this.test("should not traverse down CTE", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.checkAnalysisWithoutViewWrapper(CatalystSqlParser$.MODULE$.parsePlan(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n          |WITH ctetable AS (SELECT * FROM table WHERE a > 1)\n          |SELECT /*+ BROADCAST(table) */ * FROM ctetable\n        "))), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)TestRelations$.MODULE$.testRelation()).where((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$greater((Expression)package.expressions$.MODULE$.intToLiteral(1)))).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a"))}))).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a"))}))).analyze(), false, true), new Position("ResolveHintsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 120));
        this.test("coalesce and repartition hint", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.checkAnalysisWithoutViewWrapper((LogicalPlan)new UnresolvedHint("COALESCE", (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Literal[]{Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)10))})), package.plans$.MODULE$.table((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"TaBlE"}))), (LogicalPlan)new Repartition(10, false, (LogicalPlan)TestRelations$.MODULE$.testRelation()), this.checkAnalysisWithoutViewWrapper$default$3(), this.checkAnalysisWithoutViewWrapper$default$4());
            this.checkAnalysisWithoutViewWrapper((LogicalPlan)new UnresolvedHint("coalesce", (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Literal[]{Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)20))})), package.plans$.MODULE$.table((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"TaBlE"}))), (LogicalPlan)new Repartition(20, false, (LogicalPlan)TestRelations$.MODULE$.testRelation()), this.checkAnalysisWithoutViewWrapper$default$3(), this.checkAnalysisWithoutViewWrapper$default$4());
            this.checkAnalysisWithoutViewWrapper((LogicalPlan)new UnresolvedHint("REPARTITION", (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Literal[]{Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)100))})), package.plans$.MODULE$.table((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"TaBlE"}))), (LogicalPlan)new Repartition(100, true, (LogicalPlan)TestRelations$.MODULE$.testRelation()), this.checkAnalysisWithoutViewWrapper$default$3(), this.checkAnalysisWithoutViewWrapper$default$4());
            this.checkAnalysisWithoutViewWrapper((LogicalPlan)new UnresolvedHint("RePARTITion", (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Literal[]{Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)200))})), package.plans$.MODULE$.table((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"TaBlE"}))), (LogicalPlan)new Repartition(200, true, (LogicalPlan)TestRelations$.MODULE$.testRelation()), this.checkAnalysisWithoutViewWrapper$default$3(), this.checkAnalysisWithoutViewWrapper$default$4());
            String errMsg = "COALESCE Hint expects a partition number as a parameter";
            this.assertAnalysisError((LogicalPlan)new UnresolvedHint("COALESCE", (Seq)package$.MODULE$.Seq().empty(), package.plans$.MODULE$.table((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"TaBlE"}))), (Seq<String>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{errMsg}))), this.assertAnalysisError$default$3());
            this.assertAnalysisError((LogicalPlan)new UnresolvedHint("COALESCE", (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Literal[]{Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)10)), Literal$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)false))})), package.plans$.MODULE$.table((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"TaBlE"}))), (Seq<String>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{errMsg}))), this.assertAnalysisError$default$3());
            this.assertAnalysisError((LogicalPlan)new UnresolvedHint("COALESCE", (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Literal[]{Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)1.0))})), package.plans$.MODULE$.table((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"TaBlE"}))), (Seq<String>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{errMsg}))), this.assertAnalysisError$default$3());
            AttributeReference[] attributeReferenceArray = new AttributeReference[1];
            String x$4 = "a";
            IntegerType$ x$5 = IntegerType$.MODULE$;
            boolean x$6 = AttributeReference$.MODULE$.apply$default$3();
            Metadata x$7 = AttributeReference$.MODULE$.apply$default$4();
            ExprId x$8 = AttributeReference$.MODULE$.apply$default$5("a", (DataType)x$5, x$6, x$7);
            Seq x$9 = AttributeReference$.MODULE$.apply$default$6("a", (DataType)x$5, x$6, x$7);
            attributeReferenceArray[0] = new AttributeReference("a", (DataType)x$5, x$6, x$7, x$8, x$9);
            this.checkAnalysisWithoutViewWrapper((LogicalPlan)new UnresolvedHint("RePartition", (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LeafExpression[]{Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)10)), UnresolvedAttribute$.MODULE$.apply("a")})), package.plans$.MODULE$.table((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"TaBlE"}))), (LogicalPlan)RepartitionByExpression$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])attributeReferenceArray)), (LogicalPlan)TestRelations$.MODULE$.testRelation(), 10), this.checkAnalysisWithoutViewWrapper$default$3(), this.checkAnalysisWithoutViewWrapper$default$4());
            AttributeReference[] attributeReferenceArray2 = new AttributeReference[1];
            String x$10 = "a";
            IntegerType$ x$11 = IntegerType$.MODULE$;
            boolean x$12 = AttributeReference$.MODULE$.apply$default$3();
            Metadata x$13 = AttributeReference$.MODULE$.apply$default$4();
            ExprId x$14 = AttributeReference$.MODULE$.apply$default$5("a", (DataType)x$11, x$12, x$13);
            Seq x$15 = AttributeReference$.MODULE$.apply$default$6("a", (DataType)x$11, x$12, x$13);
            attributeReferenceArray2[0] = new AttributeReference("a", (DataType)x$11, x$12, x$13, x$14, x$15);
            this.checkAnalysisWithoutViewWrapper((LogicalPlan)new UnresolvedHint("REPARTITION", (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LeafExpression[]{Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)10)), UnresolvedAttribute$.MODULE$.apply("a")})), package.plans$.MODULE$.table((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"TaBlE"}))), (LogicalPlan)RepartitionByExpression$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])attributeReferenceArray2)), (LogicalPlan)TestRelations$.MODULE$.testRelation(), 10), this.checkAnalysisWithoutViewWrapper$default$3(), this.checkAnalysisWithoutViewWrapper$default$4());
            AttributeReference[] attributeReferenceArray3 = new AttributeReference[1];
            String x$16 = "a";
            IntegerType$ x$17 = IntegerType$.MODULE$;
            boolean x$18 = AttributeReference$.MODULE$.apply$default$3();
            Metadata x$19 = AttributeReference$.MODULE$.apply$default$4();
            ExprId x$20 = AttributeReference$.MODULE$.apply$default$5("a", (DataType)x$17, x$18, x$19);
            Seq x$21 = AttributeReference$.MODULE$.apply$default$6("a", (DataType)x$17, x$18, x$19);
            attributeReferenceArray3[0] = new AttributeReference("a", (DataType)x$17, x$18, x$19, x$20, x$21);
            this.checkAnalysisWithoutViewWrapper((LogicalPlan)new UnresolvedHint("REPARTITION", (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new UnresolvedAttribute[]{UnresolvedAttribute$.MODULE$.apply("a")})), package.plans$.MODULE$.table((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"TaBlE"}))), (LogicalPlan)new RepartitionByExpression((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])attributeReferenceArray3)), (LogicalPlan)TestRelations$.MODULE$.testRelation(), (Option)None$.MODULE$), this.checkAnalysisWithoutViewWrapper$default$3(), this.checkAnalysisWithoutViewWrapper$default$4());
            AnalysisException e = (AnalysisException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> {
                SortOrder[] sortOrderArray = new SortOrder[1];
                String x$22 = "a";
                IntegerType$ x$23 = IntegerType$.MODULE$;
                boolean x$24 = AttributeReference$.MODULE$.apply$default$3();
                Metadata x$25 = AttributeReference$.MODULE$.apply$default$4();
                ExprId x$26 = AttributeReference$.MODULE$.apply$default$5("a", (DataType)x$23, x$24, x$25);
                Seq x$27 = AttributeReference$.MODULE$.apply$default$6("a", (DataType)x$23, x$24, x$25);
                sortOrderArray[0] = SortOrder$.MODULE$.apply((Expression)new AttributeReference("a", (DataType)x$23, x$24, x$25, x$26, x$27), (SortDirection)Ascending$.MODULE$, SortOrder$.MODULE$.apply$default$3());
                SortOrder[] sortOrderArray2 = new SortOrder[1];
                String x$28 = "a";
                IntegerType$ x$29 = IntegerType$.MODULE$;
                boolean x$30 = AttributeReference$.MODULE$.apply$default$3();
                Metadata x$31 = AttributeReference$.MODULE$.apply$default$4();
                ExprId x$32 = AttributeReference$.MODULE$.apply$default$5("a", (DataType)x$29, x$30, x$31);
                Seq x$33 = AttributeReference$.MODULE$.apply$default$6("a", (DataType)x$29, x$30, x$31);
                sortOrderArray2[0] = SortOrder$.MODULE$.apply((Expression)new AttributeReference("a", (DataType)x$29, x$30, x$31, x$32, x$33), (SortDirection)Ascending$.MODULE$, SortOrder$.MODULE$.apply$default$3());
                this.checkAnalysis((LogicalPlan)new UnresolvedHint("REPARTITION", (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])sortOrderArray)), package.plans$.MODULE$.table((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"TaBlE"}))), (LogicalPlan)RepartitionByExpression$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])sortOrderArray2)), (LogicalPlan)TestRelations$.MODULE$.testRelation(), 10), this.checkAnalysis$default$3());
            }, ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ResolveHintsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 172));
            e.getMessage().contains("For range partitioning use REPARTITION_BY_RANGE instead");
            SortOrder[] sortOrderArray = new SortOrder[1];
            String x$34 = "a";
            IntegerType$ x$35 = IntegerType$.MODULE$;
            boolean x$36 = AttributeReference$.MODULE$.apply$default$3();
            Metadata x$37 = AttributeReference$.MODULE$.apply$default$4();
            ExprId x$38 = AttributeReference$.MODULE$.apply$default$5("a", (DataType)x$35, x$36, x$37);
            Seq x$39 = AttributeReference$.MODULE$.apply$default$6("a", (DataType)x$35, x$36, x$37);
            sortOrderArray[0] = SortOrder$.MODULE$.apply((Expression)new AttributeReference("a", (DataType)x$35, x$36, x$37, x$38, x$39), (SortDirection)Ascending$.MODULE$, SortOrder$.MODULE$.apply$default$3());
            this.checkAnalysisWithoutViewWrapper((LogicalPlan)new UnresolvedHint("REPARTITION_BY_RANGE", (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LeafExpression[]{Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)10)), UnresolvedAttribute$.MODULE$.apply("a")})), package.plans$.MODULE$.table((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"TaBlE"}))), (LogicalPlan)RepartitionByExpression$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])sortOrderArray)), (LogicalPlan)TestRelations$.MODULE$.testRelation(), 10), this.checkAnalysisWithoutViewWrapper$default$3(), this.checkAnalysisWithoutViewWrapper$default$4());
            SortOrder[] sortOrderArray2 = new SortOrder[1];
            String x$40 = "a";
            IntegerType$ x$41 = IntegerType$.MODULE$;
            boolean x$42 = AttributeReference$.MODULE$.apply$default$3();
            Metadata x$43 = AttributeReference$.MODULE$.apply$default$4();
            ExprId x$44 = AttributeReference$.MODULE$.apply$default$5("a", (DataType)x$41, x$42, x$43);
            Seq x$45 = AttributeReference$.MODULE$.apply$default$6("a", (DataType)x$41, x$42, x$43);
            sortOrderArray2[0] = SortOrder$.MODULE$.apply((Expression)new AttributeReference("a", (DataType)x$41, x$42, x$43, x$44, x$45), (SortDirection)Ascending$.MODULE$, SortOrder$.MODULE$.apply$default$3());
            this.checkAnalysisWithoutViewWrapper((LogicalPlan)new UnresolvedHint("REPARTITION_BY_RANGE", (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new UnresolvedAttribute[]{UnresolvedAttribute$.MODULE$.apply("a")})), package.plans$.MODULE$.table((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"TaBlE"}))), (LogicalPlan)new RepartitionByExpression((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])sortOrderArray2)), (LogicalPlan)TestRelations$.MODULE$.testRelation(), (Option)None$.MODULE$), this.checkAnalysisWithoutViewWrapper$default$3(), this.checkAnalysisWithoutViewWrapper$default$4());
            String errMsg2 = "REPARTITION Hint parameter should include columns, but";
            this.assertAnalysisError((LogicalPlan)new UnresolvedHint("REPARTITION", (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Literal[]{Literal$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)true))})), package.plans$.MODULE$.table((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"TaBlE"}))), (Seq<String>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{errMsg2}))), this.assertAnalysisError$default$3());
            LeafExpression[] leafExpressionArray = new LeafExpression[2];
            leafExpressionArray[0] = Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)1.0));
            String x$46 = "a";
            IntegerType$ x$47 = IntegerType$.MODULE$;
            boolean x$48 = AttributeReference$.MODULE$.apply$default$3();
            Metadata x$49 = AttributeReference$.MODULE$.apply$default$4();
            ExprId x$50 = AttributeReference$.MODULE$.apply$default$5("a", (DataType)x$47, x$48, x$49);
            Seq x$51 = AttributeReference$.MODULE$.apply$default$6("a", (DataType)x$47, x$48, x$49);
            leafExpressionArray[1] = new AttributeReference("a", (DataType)x$47, x$48, x$49, x$50, x$51);
            this.assertAnalysisError((LogicalPlan)new UnresolvedHint("REPARTITION", (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])leafExpressionArray)), package.plans$.MODULE$.table((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"TaBlE"}))), (Seq<String>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{errMsg2}))), this.assertAnalysisError$default$3());
            String errMsg3 = "REPARTITION_BY_RANGE Hint parameter should include columns, but";
            LeafExpression[] leafExpressionArray2 = new LeafExpression[2];
            leafExpressionArray2[0] = Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)1.0));
            String x$52 = "a";
            IntegerType$ x$53 = IntegerType$.MODULE$;
            boolean x$54 = AttributeReference$.MODULE$.apply$default$3();
            Metadata x$55 = AttributeReference$.MODULE$.apply$default$4();
            ExprId x$56 = AttributeReference$.MODULE$.apply$default$5("a", (DataType)x$53, x$54, x$55);
            Seq x$57 = AttributeReference$.MODULE$.apply$default$6("a", (DataType)x$53, x$54, x$55);
            leafExpressionArray2[1] = new AttributeReference("a", (DataType)x$53, x$54, x$55, x$56, x$57);
            this.assertAnalysisError((LogicalPlan)new UnresolvedHint("REPARTITION_BY_RANGE", (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])leafExpressionArray2)), package.plans$.MODULE$.table((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"TaBlE"}))), (Seq<String>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{errMsg3}))), this.assertAnalysisError$default$3());
            this.assertAnalysisError((LogicalPlan)new UnresolvedHint("REPARTITION_BY_RANGE", (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Literal[]{Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)10)), Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)10))})), package.plans$.MODULE$.table((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"TaBlE"}))), (Seq<String>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{errMsg3}))), this.assertAnalysisError$default$3());
            this.assertAnalysisError((LogicalPlan)new UnresolvedHint("REPARTITION_BY_RANGE", (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LeafExpression[]{Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)10)), Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)10)), UnresolvedAttribute$.MODULE$.apply("a")})), package.plans$.MODULE$.table((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"TaBlE"}))), (Seq<String>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{errMsg3}))), this.assertAnalysisError$default$3());
        }, new Position("ResolveHintsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 133));
        this.test("log warnings for invalid hints", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            SparkFunSuite.LogAppender logAppender = new SparkFunSuite.LogAppender((SparkFunSuite)this, "invalid hints", this.LogAppender().$lessinit$greater$default$2());
            this.withLogAppender((AbstractAppender)logAppender, this.withLogAppender$default$2(), this.withLogAppender$default$3(), (Function0)(JFunction0.mcV.sp & Serializable)() -> this.checkAnalysisWithoutViewWrapper((LogicalPlan)new UnresolvedHint("unknown_hint", (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"TaBlE"})), package.plans$.MODULE$.table((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"TaBlE"}))), (LogicalPlan)TestRelations$.MODULE$.testRelation(), false, this.checkAnalysisWithoutViewWrapper$default$4()));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(logAppender.loggingEvents().exists((Function1 & Serializable)e -> BoxesRunTime.boxToBoolean((boolean)ResolveHintsSuite.$anonfun$new$13(e))), "logAppender.loggingEvents.exists(((e: org.apache.logging.log4j.core.LogEvent) => e.getLevel().==(org.apache.logging.log4j.Level.WARN).&&(e.getMessage().getFormattedMessage().contains(\"Unrecognized hint: unknown_hint\"))))", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ResolveHintsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 237));
        }, new Position("ResolveHintsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 229));
        this.test("SPARK-30003: Do not throw stack overflow exception in non-root unknown hint resolution", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.checkAnalysisWithoutViewWrapper((LogicalPlan)new Project(TestRelations$.MODULE$.testRelation().output(), (LogicalPlan)new UnresolvedHint("unknown_hint", (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"TaBlE"})), package.plans$.MODULE$.table((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"TaBlE"})))), (LogicalPlan)new Project(TestRelations$.MODULE$.testRelation().output(), (LogicalPlan)TestRelations$.MODULE$.testRelation()), false, this.checkAnalysisWithoutViewWrapper$default$4()), new Position("ResolveHintsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 242));
        this.test("Supports multi-part table names for join strategy hint resolution", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"MAPJOIN", (Object)BROADCAST$.MODULE$), new Tuple2((Object)"MERGEJOIN", (Object)SHUFFLE_MERGE$.MODULE$), new Tuple2((Object)"SHUFFLE_HASH", (Object)SHUFFLE_HASH$.MODULE$), new Tuple2((Object)"SHUFFLE_REPLICATE_NL", (Object)SHUFFLE_REPLICATE_NL$.MODULE$)})).foreach((Function1 & Serializable)x0$1 -> {
            ResolveHintsSuite.$anonfun$new$16(this, x0$1);
            return BoxedUnit.UNIT;
        }), new Position("ResolveHintsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 249));
        this.test("SPARK-35786: Support optimize rebalance by expression in AQE", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            AttributeReference[] attributeReferenceArray = new AttributeReference[1];
            String x$70 = "a";
            IntegerType$ x$71 = IntegerType$.MODULE$;
            boolean x$72 = AttributeReference$.MODULE$.apply$default$3();
            Metadata x$73 = AttributeReference$.MODULE$.apply$default$4();
            ExprId x$74 = AttributeReference$.MODULE$.apply$default$5("a", (DataType)x$71, x$72, x$73);
            Seq x$75 = AttributeReference$.MODULE$.apply$default$6("a", (DataType)x$71, x$72, x$73);
            attributeReferenceArray[0] = new AttributeReference("a", (DataType)x$71, x$72, x$73, x$74, x$75);
            this.checkAnalysisWithoutViewWrapper((LogicalPlan)new UnresolvedHint("REBALANCE", (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new UnresolvedAttribute[]{UnresolvedAttribute$.MODULE$.apply("a")})), package.plans$.MODULE$.table((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"TaBlE"}))), (LogicalPlan)new RebalancePartitions((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])attributeReferenceArray)), (LogicalPlan)TestRelations$.MODULE$.testRelation(), RebalancePartitions$.MODULE$.apply$default$3()), this.checkAnalysisWithoutViewWrapper$default$3(), this.checkAnalysisWithoutViewWrapper$default$4());
            AttributeReference[] attributeReferenceArray2 = new AttributeReference[1];
            String x$76 = "a";
            IntegerType$ x$77 = IntegerType$.MODULE$;
            boolean x$78 = AttributeReference$.MODULE$.apply$default$3();
            Metadata x$79 = AttributeReference$.MODULE$.apply$default$4();
            ExprId x$80 = AttributeReference$.MODULE$.apply$default$5("a", (DataType)x$77, x$78, x$79);
            Seq x$81 = AttributeReference$.MODULE$.apply$default$6("a", (DataType)x$77, x$78, x$79);
            attributeReferenceArray2[0] = new AttributeReference("a", (DataType)x$77, x$78, x$79, x$80, x$81);
            this.checkAnalysisWithoutViewWrapper((LogicalPlan)new UnresolvedHint("REBALANCE", (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), UnresolvedAttribute$.MODULE$.apply("a")})), package.plans$.MODULE$.table((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"TaBlE"}))), (LogicalPlan)new RebalancePartitions((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])attributeReferenceArray2)), (LogicalPlan)TestRelations$.MODULE$.testRelation(), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)1))), this.checkAnalysisWithoutViewWrapper$default$3(), this.checkAnalysisWithoutViewWrapper$default$4());
            AttributeReference[] attributeReferenceArray3 = new AttributeReference[1];
            String x$82 = "a";
            IntegerType$ x$83 = IntegerType$.MODULE$;
            boolean x$84 = AttributeReference$.MODULE$.apply$default$3();
            Metadata x$85 = AttributeReference$.MODULE$.apply$default$4();
            ExprId x$86 = AttributeReference$.MODULE$.apply$default$5("a", (DataType)x$83, x$84, x$85);
            Seq x$87 = AttributeReference$.MODULE$.apply$default$6("a", (DataType)x$83, x$84, x$85);
            attributeReferenceArray3[0] = new AttributeReference("a", (DataType)x$83, x$84, x$85, x$86, x$87);
            this.checkAnalysisWithoutViewWrapper((LogicalPlan)new UnresolvedHint("REBALANCE", (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LeafExpression[]{Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1)), UnresolvedAttribute$.MODULE$.apply("a")})), package.plans$.MODULE$.table((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"TaBlE"}))), (LogicalPlan)new RebalancePartitions((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])attributeReferenceArray3)), (LogicalPlan)TestRelations$.MODULE$.testRelation(), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)1))), this.checkAnalysisWithoutViewWrapper$default$3(), this.checkAnalysisWithoutViewWrapper$default$4());
            this.checkAnalysisWithoutViewWrapper((LogicalPlan)new UnresolvedHint("REBALANCE", (Seq)package$.MODULE$.Seq().empty(), package.plans$.MODULE$.table((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"TaBlE"}))), (LogicalPlan)new RebalancePartitions((Seq)package$.MODULE$.Seq().empty(), (LogicalPlan)TestRelations$.MODULE$.testRelation(), RebalancePartitions$.MODULE$.apply$default$3()), this.checkAnalysisWithoutViewWrapper$default$3(), this.checkAnalysisWithoutViewWrapper$default$4());
            this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ADAPTIVE_EXECUTION_ENABLED().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                this.checkAnalysisWithoutViewWrapper((LogicalPlan)new UnresolvedHint("REBALANCE", (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new UnresolvedAttribute[]{UnresolvedAttribute$.MODULE$.apply("a")})), package.plans$.MODULE$.table((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"TaBlE"}))), (LogicalPlan)TestRelations$.MODULE$.testRelation(), this.checkAnalysisWithoutViewWrapper$default$3(), this.checkAnalysisWithoutViewWrapper$default$4());
                this.checkAnalysisWithoutViewWrapper((LogicalPlan)new UnresolvedHint("REBALANCE", (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), UnresolvedAttribute$.MODULE$.apply("a")})), package.plans$.MODULE$.table((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"TaBlE"}))), (LogicalPlan)TestRelations$.MODULE$.testRelation(), this.checkAnalysisWithoutViewWrapper$default$3(), this.checkAnalysisWithoutViewWrapper$default$4());
                this.checkAnalysisWithoutViewWrapper((LogicalPlan)new UnresolvedHint("REBALANCE", (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LeafExpression[]{Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1)), UnresolvedAttribute$.MODULE$.apply("a")})), package.plans$.MODULE$.table((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"TaBlE"}))), (LogicalPlan)TestRelations$.MODULE$.testRelation(), this.checkAnalysisWithoutViewWrapper$default$3(), this.checkAnalysisWithoutViewWrapper$default$4());
                this.checkAnalysisWithoutViewWrapper((LogicalPlan)new UnresolvedHint("REBALANCE", (Seq)package$.MODULE$.Seq().empty(), package.plans$.MODULE$.table((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"TaBlE"}))), (LogicalPlan)TestRelations$.MODULE$.testRelation(), this.checkAnalysisWithoutViewWrapper$default$3(), this.checkAnalysisWithoutViewWrapper$default$4());
                this.checkAnalysisWithoutViewWrapper((LogicalPlan)new UnresolvedHint("REBALANCE", (Seq)package$.MODULE$.Nil().$colon$colon((Object)BoxesRunTime.boxToInteger((int)1)), package.plans$.MODULE$.table((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"TaBlE"}))), (LogicalPlan)TestRelations$.MODULE$.testRelation(), this.checkAnalysisWithoutViewWrapper$default$3(), this.checkAnalysisWithoutViewWrapper$default$4());
            });
            this.assertAnalysisError((LogicalPlan)new UnresolvedHint("REBALANCE", (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Literal[]{Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1)), Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1))})), package.plans$.MODULE$.table((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"TaBlE"}))), (Seq<String>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Hint parameter should include columns"}))), this.assertAnalysisError$default$3());
            this.assertAnalysisError((LogicalPlan)new UnresolvedHint("REBALANCE", (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1))})), package.plans$.MODULE$.table((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"TaBlE"}))), (Seq<String>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Hint parameter should include columns"}))), this.assertAnalysisError$default$3());
        }, new Position("ResolveHintsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 302));
        this.test("SPARK-38410: Support specify initial partition number for rebalance", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.SHUFFLE_PARTITIONS().key()), (Object)"3")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)package$.MODULE$.Nil()), (Object)BoxesRunTime.boxToInteger((int)3)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1}))), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new UnresolvedAttribute[]{UnresolvedAttribute$.MODULE$.apply("a")}))), (Object)BoxesRunTime.boxToInteger((int)3)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), UnresolvedAttribute$.MODULE$.apply("a")}))), (Object)BoxesRunTime.boxToInteger((int)1))})).foreach((Function1 & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Seq param = (Seq)tuple2._1();
            int initialNumPartitions = tuple2._2$mcI$sp();
            int $org_scalatest_assert_macro_left = ((RebalancePartitions)package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new UnresolvedHint("REBALANCE", param, (LogicalPlan)TestRelations$.MODULE$.testRelation())).analyze()).partitioning().numPartitions();
            int $org_scalatest_assert_macro_right = initialNumPartitions;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertion assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ResolveHintsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 357));
            return assertion;
        })), new Position("ResolveHintsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 350));
    }
}

