/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.aggregate;

import java.io.Serializable;
import java.sql.Date;
import java.util.Random;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAttribute$;
import org.apache.spark.sql.catalyst.dsl.package;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.BoundReference;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.CreateArray;
import org.apache.spark.sql.catalyst.expressions.CreateArray$;
import org.apache.spark.sql.catalyst.expressions.DecimalLiteral$;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.aggregate.ApproximatePercentile;
import org.apache.spark.sql.catalyst.expressions.aggregate.ApproximatePercentile$;
import org.apache.spark.sql.catalyst.plans.logical.LocalRelation;
import org.apache.spark.sql.catalyst.plans.logical.LocalRelation$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.QuantileSummaries;
import org.apache.spark.sql.catalyst.util.QuantileSummaries$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.IntegralType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.util.SizeEstimator$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.compatible.Assertion;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005E4A\u0001C\u0005\u00011!)Q\u0004\u0001C\u0001=!9\u0011\u0005\u0001b\u0001\n\u0013\u0011\u0003BB\u0016\u0001A\u0003%1\u0005C\u0004-\u0001\t\u0007I\u0011B\u0017\t\rq\u0002\u0001\u0015!\u0003/\u0011\u0015i\u0004\u0001\"\u0003?\u0011\u0015q\u0006\u0001\"\u0003`\u0005i\t\u0005\u000f\u001d:pq&l\u0017\r^3QKJ\u001cWM\u001c;jY\u0016\u001cV/\u001b;f\u0015\tQ1\"A\u0005bO\u001e\u0014XmZ1uK*\u0011A\"D\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002\u000f\u001f\u0005A1-\u0019;bYf\u001cHO\u0003\u0002\u0011#\u0005\u00191/\u001d7\u000b\u0005I\u0019\u0012!B:qCJ\\'B\u0001\u000b\u0016\u0003\u0019\t\u0007/Y2iK*\ta#A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u00013A\u0011!dG\u0007\u0002#%\u0011A$\u0005\u0002\u000e'B\f'o\u001b$v]N+\u0018\u000e^3\u0002\rqJg.\u001b;?)\u0005y\u0002C\u0001\u0011\u0001\u001b\u0005I\u0011A\u0002:b]\u0012|W.F\u0001$!\t!\u0013&D\u0001&\u0015\t1s%\u0001\u0003vi&d'\"\u0001\u0015\u0002\t)\fg/Y\u0005\u0003U\u0015\u0012aAU1oI>l\u0017a\u0002:b]\u0012|W\u000eI\u0001\u0005I\u0006$\u0018-F\u0001/!\ryc\u0007O\u0007\u0002a)\u0011\u0011GM\u0001\nS6lW\u000f^1cY\u0016T!a\r\u001b\u0002\u0015\r|G\u000e\\3di&|gNC\u00016\u0003\u0015\u00198-\u00197b\u0013\t9\u0004G\u0001\u0006J]\u0012,\u00070\u001a3TKF\u0004\"!\u000f\u001e\u000e\u0003QJ!a\u000f\u001b\u0003\u0007%sG/A\u0003eCR\f\u0007%A\u0007d_6\u0004\u0018M]3FcV\fGn\u001d\u000b\u0004\u007f\tc\u0006CA\u001dA\u0013\t\tEGA\u0004C_>dW-\u00198\t\u000b\r3\u0001\u0019\u0001#\u0002\t1,g\r\u001e\t\u0003\u000bfs!AR,\u000f\u0005\u001d3fB\u0001%V\u001d\tIEK\u0004\u0002K':\u00111J\u0015\b\u0003\u0019Fs!!\u0014)\u000e\u00039S!aT\f\u0002\rq\u0012xn\u001c;?\u0013\u00051\u0012B\u0001\u000b\u0016\u0013\t\u00112#\u0003\u0002\u0011#%\u0011abD\u0005\u0003\u00195I!AC\u0006\n\u0005aK\u0011!F!qaJ|\u00070[7bi\u0016\u0004VM]2f]RLG.Z\u0005\u00035n\u0013\u0001\u0003U3sG\u0016tG/\u001b7f\t&<Wm\u001d;\u000b\u0005aK\u0001\"B/\u0007\u0001\u0004!\u0015!\u0002:jO\"$\u0018aC1tg\u0016\u0014H/R9vC2,\"\u0001Y4\u0015\u0007\u0005$\u0007\u000f\u0005\u0002:E&\u00111\r\u000e\u0002\u0005+:LG\u000fC\u0003D\u000f\u0001\u0007Q\r\u0005\u0002gO2\u0001A!\u00025\b\u0005\u0004I'!\u0001+\u0012\u0005)l\u0007CA\u001dl\u0013\taGGA\u0004O_RD\u0017N\\4\u0011\u0005er\u0017BA85\u0005\r\te.\u001f\u0005\u0006;\u001e\u0001\r!\u001a")
public class ApproximatePercentileSuite
extends SparkFunSuite {
    private final Random random = new Random();
    private final IndexedSeq<Object> data = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10000).map((Function1)(JFunction1.mcII.sp & Serializable)x$1 -> this.random().nextInt(10000));

    private Random random() {
        return this.random;
    }

    private IndexedSeq<Object> data() {
        return this.data;
    }

    private boolean compareEquals(ApproximatePercentile.PercentileDigest left, ApproximatePercentile.PercentileDigest right) {
        QuantileSummaries leftSummary = left.quantileSummaries();
        QuantileSummaries rightSummary = right.quantileSummaries();
        return leftSummary.compressThreshold() == rightSummary.compressThreshold() && leftSummary.relativeError() == rightSummary.relativeError() && leftSummary.count() == rightSummary.count() && Predef$.MODULE$.wrapRefArray((Object[])leftSummary.sampled()).sameElements((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])rightSummary.sampled()));
    }

    private <T> void assertEqual(T left, T right) {
        T $org_scalatest_assert_macro_right;
        T $org_scalatest_assert_macro_left;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left, "==", $org_scalatest_assert_macro_right, BoxesRunTime.equals($org_scalatest_assert_macro_left = left, $org_scalatest_assert_macro_right = right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ApproximatePercentileSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 383));
    }

    public static final /* synthetic */ void $anonfun$new$5(double relativeError$1, ApproximatePercentile.PercentileDigest buffer$2, Range group) {
        ApproximatePercentile.PercentileDigest partialBuffer = new ApproximatePercentile.PercentileDigest(relativeError$1);
        group.foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x -> partialBuffer.add((double)x));
        buffer$2.merge(partialBuffer);
    }

    public static final /* synthetic */ Assertion $anonfun$new$10(double relativeError$2, double memoryFootPrintUpperBound$1, int count) {
        ApproximatePercentile.PercentileDigest buffer = new ApproximatePercentile.PercentileDigest(relativeError$2);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), count).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$4 -> buffer.add((double)x$4));
        long $org_scalatest_assert_macro_left = SizeEstimator$.MODULE$.estimate((Object)buffer);
        double $org_scalatest_assert_macro_right = memoryFootPrintUpperBound$1;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), (double)$org_scalatest_assert_macro_left < $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ApproximatePercentileSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 94));
    }

    public static final /* synthetic */ ApproximatePercentile.PercentileDigest $anonfun$new$15(Range data$1, ApproximatePercentile agg$1, ApproximatePercentile.PercentileDigest group1Buffer$1, int index) {
        InternalRow input = InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)data$1.apply$mcII$sp(index))}));
        return agg$1.update(group1Buffer$1, input);
    }

    public static final /* synthetic */ ApproximatePercentile.PercentileDigest $anonfun$new$16(Range data$1, ApproximatePercentile agg$1, ApproximatePercentile.PercentileDigest group2Buffer$1, int index) {
        InternalRow input = InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)data$1.apply$mcII$sp(index))}));
        return agg$1.update(group2Buffer$1, input);
    }

    public static final /* synthetic */ boolean $anonfun$new$17(int error$1, Tuple2 pair) {
        return Math.abs(pair._1$mcD$sp() - pair._2$mcD$sp()) < (double)error$1;
    }

    public ApproximatePercentileSuite() {
        this.test("serialize and de-serialize", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            ApproximatePercentile.PercentileDigestSerializer serializer = new ApproximatePercentile.PercentileDigestSerializer();
            ApproximatePercentile.PercentileDigest emptyBuffer = new ApproximatePercentile.PercentileDigest(0.01);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.compareEquals(emptyBuffer, serializer.deserialize(serializer.serialize(emptyBuffer))), "ApproximatePercentileSuite.this.compareEquals(emptyBuffer, serializer.deserialize(serializer.serialize(emptyBuffer)))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ApproximatePercentileSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 49));
            ApproximatePercentile.PercentileDigest buffer = new ApproximatePercentile.PercentileDigest(0.01);
            this.data().foreach((Function1)(JFunction1.mcVI.sp & Serializable)value -> buffer.add((double)value));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(this.compareEquals(buffer, serializer.deserialize(serializer.serialize(buffer))), "ApproximatePercentileSuite.this.compareEquals(buffer, serializer.deserialize(serializer.serialize(buffer)))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ApproximatePercentileSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 55));
            ApproximatePercentile agg = new ApproximatePercentile((Expression)new BoundReference(0, (DataType)DoubleType$.MODULE$, true), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)0.5)));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(this.compareEquals(agg.deserialize(agg.serialize(buffer)), buffer), "ApproximatePercentileSuite.this.compareEquals(agg.deserialize(agg.serialize(buffer)), buffer)", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ApproximatePercentileSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 58));
        }, new Position("ApproximatePercentileSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 44));
        this.test("class PercentileDigest, basic operations", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            int valueCount = 10000;
            double[] percentages = new double[]{0.25, 0.5, 0.75};
            package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{1.0E-4, 0.001, 0.01, 0.1})).foreach((Function1)(JFunction1.mcVD.sp & Serializable)relativeError -> {
                ApproximatePercentile.PercentileDigest buffer = new ApproximatePercentile.PercentileDigest(relativeError);
                RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), valueCount).grouped(10).foreach((Function1 & Serializable)group -> {
                    ApproximatePercentileSuite.$anonfun$new$5(relativeError, buffer, group);
                    return BoxedUnit.UNIT;
                });
                double[] expectedPercentiles = (double[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.doubleArrayOps(percentages), (Function1)(JFunction1.mcDD.sp & Serializable)x$2 -> x$2 * (double)valueCount, (ClassTag)ClassTag$.MODULE$.Double());
                Seq approxPercentiles = buffer.getPercentiles(new double[]{0.25, 0.5, 0.75});
                ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zip$extension(Predef$.MODULE$.doubleArrayOps(expectedPercentiles), (IterableOnce)approxPercentiles)), (Function1 & Serializable)pair -> {
                    Tuple2 tuple2 = pair;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    double expected = tuple2._1$mcD$sp();
                    double estimate = tuple2._2$mcD$sp();
                    Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(expected, estimate);
                    Tuple2.mcDD.sp sp3 = sp2;
                    double expected2 = sp3._1$mcD$sp();
                    double estimate2 = sp3._2$mcD$sp();
                    double $org_scalatest_assert_macro_left = (estimate2 - expected2) / (double)valueCount;
                    double $org_scalatest_assert_macro_right = relativeError;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), "<=", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left <= $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                    return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ApproximatePercentileSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 75));
                });
            });
        }, new Position("ApproximatePercentileSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 61));
        this.test("class PercentileDigest, makes sure the memory foot print is bounded", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            double relativeError = 0.01;
            long headBufferSize = SizeEstimator$.MODULE$.estimate((Object)new double[QuantileSummaries$.MODULE$.defaultHeadSize()]);
            double bufferSize = (double)SizeEstimator$.MODULE$.estimate((Object)new QuantileSummaries.Stats(0.0, 0L, 0L)) * (1.0 / relativeError) * (double)2;
            double memoryFootPrintUpperBound = ((double)headBufferSize + bufferSize) * (double)2;
            package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{100, 1000, 10000, 100000, 1000000, 10000000})).foreach((Function1 & Serializable)count -> ApproximatePercentileSuite.$anonfun$new$10(relativeError, memoryFootPrintUpperBound, BoxesRunTime.unboxToInt((Object)count)));
        }, new Position("ApproximatePercentileSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 80));
        this.test("class ApproximatePercentile, high level interface, update, merge, eval...", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            int count = 10000;
            Range data = (Range)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(1), 10000).toSeq();
            double[] percentages = new double[]{0.25, 0.5, 0.75};
            int accuracy = 10000;
            double[] expectedPercentiles = (double[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.doubleArrayOps(percentages), (Function1)(JFunction1.mcDD.sp & Serializable)x$5 -> (double)count * x$5, (ClassTag)ClassTag$.MODULE$.Double());
            Cast childExpression = new Cast((Expression)new BoundReference(0, (DataType)IntegerType$.MODULE$, false), (DataType)DoubleType$.MODULE$, Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4());
            CreateArray percentageExpression = CreateArray$.MODULE$.apply((Seq)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.doubleArrayOps(percentages)).map((Function1 & Serializable)x$6 -> Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)x$6)))));
            Literal accuracyExpression = Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)10000));
            ApproximatePercentile agg = new ApproximatePercentile((Expression)childExpression, (Expression)percentageExpression, (Expression)accuracyExpression);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(agg.nullable(), "agg.nullable", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ApproximatePercentileSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 109));
            Range group1 = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), data.length() / 2);
            ApproximatePercentile.PercentileDigest group1Buffer = agg.createAggregationBuffer();
            group1.foreach((Function1 & Serializable)index -> ApproximatePercentileSuite.$anonfun$new$15(data, agg, group1Buffer, BoxesRunTime.unboxToInt((Object)index)));
            Range group2 = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(data.length() / 2), data.length());
            ApproximatePercentile.PercentileDigest group2Buffer = agg.createAggregationBuffer();
            group2.foreach((Function1 & Serializable)index -> ApproximatePercentileSuite.$anonfun$new$16(data, agg, group2Buffer, BoxesRunTime.unboxToInt((Object)index)));
            ApproximatePercentile.PercentileDigest mergeBuffer = agg.createAggregationBuffer();
            agg.merge(mergeBuffer, group1Buffer);
            agg.merge(mergeBuffer, group2Buffer);
            Object object = agg.eval(mergeBuffer);
            if (!(object instanceof ArrayData)) {
                throw new MatchError(object);
            }
            ArrayData arrayData = (ArrayData)object;
            int error = count / accuracy;
            double[] percentiles = arrayData.toDoubleArray();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(ArrayOps$.MODULE$.forall$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zip$extension(Predef$.MODULE$.doubleArrayOps(percentiles), (IterableOnce)Predef$.MODULE$.wrapDoubleArray(expectedPercentiles))), (Function1 & Serializable)pair -> BoxesRunTime.boxToBoolean((boolean)ApproximatePercentileSuite.$anonfun$new$17(error, pair))), "scala.Predef.refArrayOps[(Double, Double)](scala.Predef.doubleArrayOps(percentiles).zip[Double](scala.Predef.wrapDoubleArray(expectedPercentiles))).forall(((pair: (Double, Double)) => java.lang.Math.abs(pair._1.-(pair._2)).<(error)))", Prettifier$.MODULE$.default());
            Assertion assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ApproximatePercentileSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 132));
            return assertion;
        }, new Position("ApproximatePercentileSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 98));
        this.test("class ApproximatePercentile, low level interface, update, merge, eval...", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Cast childExpression = new Cast((Expression)new BoundReference(0, (DataType)IntegerType$.MODULE$, true), (DataType)DoubleType$.MODULE$, Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4());
            int inputAggregationBufferOffset = 1;
            int mutableAggregationBufferOffset = 2;
            double percentage = 0.5;
            ApproximatePercentile agg = new ApproximatePercentile((Expression)childExpression, (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)percentage))).withNewInputAggBufferOffset(inputAggregationBufferOffset).withNewMutableAggBufferOffset(mutableAggregationBufferOffset);
            GenericInternalRow mutableAggBuffer = new GenericInternalRow(new Object[mutableAggregationBufferOffset + 1]);
            agg.initialize((InternalRow)mutableAggBuffer);
            int dataCount = 10;
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), dataCount).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)data -> agg.update((InternalRow)mutableAggBuffer, InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)data)}))));
            agg.serializeAggregateBufferInPlace((InternalRow)mutableAggBuffer);
            byte[] serialized = mutableAggBuffer.getBinary(mutableAggregationBufferOffset);
            GenericInternalRow inputAggBuffer = new GenericInternalRow(new Object[]{null, serialized});
            agg.initialize((InternalRow)mutableAggBuffer);
            agg.merge((InternalRow)mutableAggBuffer, (InternalRow)inputAggBuffer);
            double expectedPercentile = (double)dataCount * percentage;
            double $org_scalatest_assert_macro_left = Math.abs(BoxesRunTime.unboxToDouble((Object)agg.eval((InternalRow)mutableAggBuffer)) - expectedPercentile);
            double $org_scalatest_assert_macro_right = 0.1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left < $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ApproximatePercentileSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 166));
        }, new Position("ApproximatePercentileSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 137));
        this.test("class ApproximatePercentile, sql string", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            int defaultAccuracy = ApproximatePercentile$.MODULE$.DEFAULT_PERCENTILE_ACCURACY();
            this.assertEqual(new StringBuilder(28).append("percentile_approx(a, 0.5D, ").append(defaultAccuracy).append(")").toString(), new ApproximatePercentile((Expression)package.expressions$.MODULE$.DslString("a").attr(), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)0.5))).sql());
            this.assertEqual(new StringBuilder(49).append("percentile_approx(a, array(0.25D, 0.5D, 0.75D), ").append(defaultAccuracy).append(")").toString(), new ApproximatePercentile((Expression)package.expressions$.MODULE$.DslString("a").attr(), (Expression)CreateArray$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{0.25, 0.5, 0.75})).map((Function1 & Serializable)x$7 -> Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)x$7)))))).sql());
            this.assertEqual(new StringBuilder(28).append("percentile_approx(a, 0.5D, ").append(defaultAccuracy).append(")").toString(), new ApproximatePercentile((Expression)package.expressions$.MODULE$.DslString("a").attr(), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)0.5))).sql(false));
            this.assertEqual(new StringBuilder(49).append("percentile_approx(a, array(0.25D, 0.5D, 0.75D), ").append(defaultAccuracy).append(")").toString(), new ApproximatePercentile((Expression)package.expressions$.MODULE$.DslString("a").attr(), (Expression)CreateArray$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{0.25, 0.5, 0.75})).map((Function1 & Serializable)x$8 -> Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)x$8)))))).sql(false));
            this.assertEqual(new StringBuilder(37).append("percentile_approx(DISTINCT a, 0.5D, ").append(defaultAccuracy).append(")").toString(), new ApproximatePercentile((Expression)package.expressions$.MODULE$.DslString("a").attr(), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)0.5))).sql(true));
            this.assertEqual(new StringBuilder(58).append("percentile_approx(DISTINCT a, array(0.25D, 0.5D, 0.75D), ").append(defaultAccuracy).append(")").toString(), new ApproximatePercentile((Expression)package.expressions$.MODULE$.DslString("a").attr(), (Expression)CreateArray$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{0.25, 0.5, 0.75})).map((Function1 & Serializable)x$9 -> Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)x$9)))))).sql(true));
        }, new Position("ApproximatePercentileSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 169));
        this.test("class ApproximatePercentile, fails analysis if percentage or accuracy is not a constant", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String x$1 = "a";
            DoubleType$ x$2 = DoubleType$.MODULE$;
            boolean x$3 = AttributeReference$.MODULE$.apply$default$3();
            Metadata x$4 = AttributeReference$.MODULE$.apply$default$4();
            ExprId x$5 = AttributeReference$.MODULE$.apply$default$5("a", (DataType)x$2, x$3, x$4);
            Seq x$6 = AttributeReference$.MODULE$.apply$default$6("a", (DataType)x$2, x$3, x$4);
            AttributeReference attribute = new AttributeReference("a", (DataType)x$2, x$3, x$4, x$5, x$6);
            String x$7 = "b";
            IntegerType$ x$8 = IntegerType$.MODULE$;
            boolean x$9 = AttributeReference$.MODULE$.apply$default$3();
            Metadata x$10 = AttributeReference$.MODULE$.apply$default$4();
            ExprId x$11 = AttributeReference$.MODULE$.apply$default$5("b", (DataType)x$8, x$9, x$10);
            Seq x$12 = AttributeReference$.MODULE$.apply$default$6("b", (DataType)x$8, x$9, x$10);
            ApproximatePercentile wrongAccuracy = new ApproximatePercentile((Expression)attribute, (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)0.5)), (Expression)new AttributeReference("b", (DataType)x$8, x$9, x$10, x$11, x$12));
            this.assertEqual(wrongAccuracy.checkInputDataTypes(), new TypeCheckResult.TypeCheckFailure("The accuracy or percentage provided must be a constant literal"));
            ApproximatePercentile wrongPercentage = new ApproximatePercentile((Expression)attribute, (Expression)attribute, (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)10000)));
            this.assertEqual(wrongPercentage.checkInputDataTypes(), new TypeCheckResult.TypeCheckFailure("The accuracy or percentage provided must be a constant literal"));
        }, new Position("ApproximatePercentileSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 213));
        this.test("class ApproximatePercentile, fails analysis if parameters are invalid", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String x$13 = "a";
            DoubleType$ x$14 = DoubleType$.MODULE$;
            boolean x$15 = AttributeReference$.MODULE$.apply$default$3();
            Metadata x$16 = AttributeReference$.MODULE$.apply$default$4();
            ExprId x$17 = AttributeReference$.MODULE$.apply$default$5("a", (DataType)x$14, x$15, x$16);
            Seq x$18 = AttributeReference$.MODULE$.apply$default$6("a", (DataType)x$14, x$15, x$16);
            ApproximatePercentile wrongAccuracy = new ApproximatePercentile((Expression)new AttributeReference("a", (DataType)x$14, x$15, x$16, x$17, x$18), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)0.5)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)-1)));
            this.assertEqual(wrongAccuracy.checkInputDataTypes(), new TypeCheckResult.TypeCheckFailure(new StringBuilder(21).append(new StringBuilder(73).append("The accuracy provided must be a literal between (0, ").append(Integer.MAX_VALUE).append("]").toString()).append(" (current value = -1)").toString()));
            Seq correctPercentageExpressions = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{new Literal((Object)BoxesRunTime.boxToFloat((float)0.1f), (DataType)FloatType$.MODULE$), new Literal((Object)Decimal$.MODULE$.apply(0.2), (DataType)new DecimalType(2, 1)), Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)0.0)), Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)1.0)), Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)0.5)), CreateArray$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{0.0, 1.0, 0.5})).map((Function1 & Serializable)x$10 -> Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)x$10)))))}));
            correctPercentageExpressions.foreach((Function1 & Serializable)percentageExpression -> {
                String x$19 = "a";
                DoubleType$ x$20 = DoubleType$.MODULE$;
                boolean x$21 = AttributeReference$.MODULE$.apply$default$3();
                Metadata x$22 = AttributeReference$.MODULE$.apply$default$4();
                ExprId x$23 = AttributeReference$.MODULE$.apply$default$5("a", (DataType)x$20, x$21, x$22);
                Seq x$24 = AttributeReference$.MODULE$.apply$default$6("a", (DataType)x$20, x$21, x$22);
                ApproximatePercentile correctPercentage = new ApproximatePercentile((Expression)new AttributeReference("a", (DataType)x$20, x$21, x$22, x$23, x$24), percentageExpression, (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)100)));
                return correctPercentage.checkInputDataTypes();
            });
            Seq wrongPercentageExpressions = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)1.1)), Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)-0.5)), CreateArray$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{0.0, 0.5, 1.1})).map((Function1 & Serializable)x$11 -> Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)x$11)))))}));
            wrongPercentageExpressions.foreach((Function1 & Serializable)percentageExpression -> {
                TypeCheckResult.TypeCheckFailure typeCheckFailure;
                String msg;
                Seq x$30;
                ExprId x$29;
                Metadata x$28;
                String x$25 = "a";
                DoubleType$ x$26 = DoubleType$.MODULE$;
                boolean x$27 = AttributeReference$.MODULE$.apply$default$3();
                ApproximatePercentile wrongPercentage = new ApproximatePercentile((Expression)new AttributeReference("a", (DataType)x$26, x$27, x$28 = AttributeReference$.MODULE$.apply$default$4(), x$29 = AttributeReference$.MODULE$.apply$default$5("a", (DataType)x$26, x$27, x$28), x$30 = AttributeReference$.MODULE$.apply$default$6("a", (DataType)x$26, x$27, x$28)), percentageExpression, (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)100)));
                TypeCheckResult typeCheckResult = wrongPercentage.checkInputDataTypes();
                boolean bl = typeCheckResult instanceof TypeCheckResult.TypeCheckFailure && (msg = (typeCheckFailure = (TypeCheckResult.TypeCheckFailure)typeCheckResult).message()).contains("must be between 0.0 and 1.0");
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(bl, "wrongPercentage.checkInputDataTypes() match {\n  case (message: String): org.apache.spark.sql.catalyst.analysis.TypeCheckResult.TypeCheckFailure((msg @ _)) if msg.contains(\"must be between 0.0 and 1.0\") => true\n  case _ => false\n}", Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ApproximatePercentileSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 276));
            });
        }, new Position("ApproximatePercentileSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 236));
        this.test("class ApproximatePercentile, automatically add type casting for parameters", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            LocalRelation testRelation = LocalRelation$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Attribute[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int()}));
            Seq accuracyExpressions = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Literal[]{Literal$.MODULE$.apply((Object)BoxesRunTime.boxToByte((byte)((byte)1))), Literal$.MODULE$.apply((Object)BoxesRunTime.boxToShort((short)((short)100))), Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)100)), Literal$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)1000L))}));
            Seq percentageExpressions = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{Literal$.MODULE$.apply((Object)BoxesRunTime.boxToFloat((float)0.3f)), DecimalLiteral$.MODULE$.apply(0.5), Literal$.MODULE$.apply((Object)"0.2"), CreateArray$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Literal[]{Literal$.MODULE$.apply((Object)BoxesRunTime.boxToFloat((float)0.3f)), Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)0.5)), DecimalLiteral$.MODULE$.apply(0.7)})))}));
            accuracyExpressions.foreach((Function1 & Serializable)accuracyExpression -> {
                percentageExpressions.foreach((Function1 & Serializable)percentageExpression -> {
                    Bool bool;
                    Bool $org_scalatest_assert_macro_left;
                    ApproximatePercentile approximatePercentile;
                    Alias alias;
                    Expression agg;
                    ApproximatePercentile agg2 = new ApproximatePercentile((Expression)UnresolvedAttribute$.MODULE$.apply("a"), percentageExpression, (Expression)accuracyExpression);
                    Expression analyzed = (Expression)package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)testRelation$1).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{agg2}))).analyze().expressions().head();
                    Expression expression = analyzed;
                    if (expression instanceof Alias && (agg = (alias = (Alias)expression).child()) instanceof ApproximatePercentile) {
                        approximatePercentile = (ApproximatePercentile)agg;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(approximatePercentile.resolved(), "agg.resolved", Prettifier$.MODULE$.default());
                        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ApproximatePercentileSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 307));
                        DataType $org_scalatest_assert_macro_left2 = approximatePercentile.child().dataType();
                        IntegerType$ $org_scalatest_assert_macro_right = IntegerType$.MODULE$;
                        DataType dataType = $org_scalatest_assert_macro_left2;
                        IntegerType$ integerType$ = $org_scalatest_assert_macro_right;
                        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right, !(dataType != null ? !dataType.equals(integerType$) : integerType$ != null), Prettifier$.MODULE$.default());
                        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ApproximatePercentileSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 308));
                        DataType $org_scalatest_assert_macro_left3 = approximatePercentile.percentageExpression().dataType();
                        DoubleType$ $org_scalatest_assert_macro_right2 = DoubleType$.MODULE$;
                        DataType dataType2 = $org_scalatest_assert_macro_left3;
                        DoubleType$ doubleType$ = $org_scalatest_assert_macro_right2;
                        $org_scalatest_assert_macro_left = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right2, !(dataType2 != null ? !dataType2.equals(doubleType$) : doubleType$ != null), Prettifier$.MODULE$.default());
                        if ($org_scalatest_assert_macro_left.value()) {
                            bool = Bool$.MODULE$.simpleMacroBool(true, "", Prettifier$.MODULE$.default());
                        } else {
                            DataType $org_scalatest_assert_macro_left4 = approximatePercentile.percentageExpression().dataType();
                            ArrayType $org_scalatest_assert_macro_right3 = new ArrayType((DataType)DoubleType$.MODULE$, false);
                            DataType dataType3 = $org_scalatest_assert_macro_left4;
                            ArrayType arrayType = $org_scalatest_assert_macro_right3;
                            bool = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right3, !(dataType3 != null ? !dataType3.equals(arrayType) : arrayType != null), Prettifier$.MODULE$.default());
                        }
                    } else {
                        throw $this.fail(new Position("ApproximatePercentileSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 312));
                    }
                    Bool $org_scalatest_assert_macro_right = bool;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "||", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$bar$bar((Function0 & Serializable)() -> $org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ApproximatePercentileSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 309));
                    DataType $org_scalatest_assert_macro_left5 = approximatePercentile.accuracyExpression().dataType();
                    Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left5, "isInstanceOf", "org.apache.spark.sql.types.IntegralType", $org_scalatest_assert_macro_left5 instanceof IntegralType, Prettifier$.MODULE$.default());
                    Assertion assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ApproximatePercentileSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 311));
                    return assertion;
                });
                return BoxedUnit.UNIT;
            });
        }, new Position("ApproximatePercentileSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 284));
        this.test("ApproximatePercentile: nulls in percentage expression", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String x$31 = "a";
            DoubleType$ x$32 = DoubleType$.MODULE$;
            boolean x$33 = AttributeReference$.MODULE$.apply$default$3();
            Metadata x$34 = AttributeReference$.MODULE$.apply$default$4();
            ExprId x$35 = AttributeReference$.MODULE$.apply$default$5("a", (DataType)x$32, x$33, x$34);
            Seq x$36 = AttributeReference$.MODULE$.apply$default$6("a", (DataType)x$32, x$33, x$34);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(new ApproximatePercentile((Expression)new AttributeReference("a", (DataType)x$32, x$33, x$34, x$35, x$36), (Expression)new Literal(null, (DataType)DoubleType$.MODULE$)).checkInputDataTypes());
            TypeCheckResult.TypeCheckFailure $org_scalatest_assert_macro_right = new TypeCheckResult.TypeCheckFailure("Percentage value must not be null");
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ApproximatePercentileSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 320));
            Seq nullPercentageExprs = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CreateArray[]{CreateArray$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Null$[]{null})).map((Function1 & Serializable)x$12 -> Literal$.MODULE$.apply(null))), CreateArray$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)0.1), null})).map((Function1 & Serializable)x$13 -> Literal$.MODULE$.apply(x$13)))}));
            nullPercentageExprs.foreach((Function1 & Serializable)percentageExpression -> {
                TypeCheckResult.TypeCheckFailure typeCheckFailure;
                String msg;
                Seq x$42;
                ExprId x$41;
                Metadata x$40;
                String x$37 = "a";
                DoubleType$ x$38 = DoubleType$.MODULE$;
                boolean x$39 = AttributeReference$.MODULE$.apply$default$3();
                ApproximatePercentile wrongPercentage = new ApproximatePercentile((Expression)new AttributeReference("a", (DataType)x$38, x$39, x$40 = AttributeReference$.MODULE$.apply$default$4(), x$41 = AttributeReference$.MODULE$.apply$default$5("a", (DataType)x$38, x$39, x$40), x$42 = AttributeReference$.MODULE$.apply$default$6("a", (DataType)x$38, x$39, x$40)), (Expression)percentageExpression, (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)100)));
                TypeCheckResult typeCheckResult = wrongPercentage.checkInputDataTypes();
                boolean bl = typeCheckResult instanceof TypeCheckResult.TypeCheckFailure && (msg = (typeCheckFailure = (TypeCheckResult.TypeCheckFailure)typeCheckResult).message()).contains("argument 2 requires (double or array<double>) type");
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(bl, "wrongPercentage.checkInputDataTypes() match {\n  case (message: String): org.apache.spark.sql.catalyst.analysis.TypeCheckResult.TypeCheckFailure((msg @ _)) if msg.contains(\"argument 2 requires (double or array<double>) type\") => true\n  case _ => false\n}", Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ApproximatePercentileSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 333));
            });
        }, new Position("ApproximatePercentileSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 318));
        this.test("ApproximatePercentile: invalid accuracy expressions", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Seq invalidAccuracies = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToFloat((float)1.2f), BoxesRunTime.boxToDouble((double)1.9), package$.MODULE$.BigDecimal().apply(1.9), new Date(0L), "1.5"}));
            invalidAccuracies.foreach((Function1 & Serializable)acc -> {
                TypeCheckResult.TypeCheckFailure typeCheckFailure;
                String msg;
                Seq x$48;
                ExprId x$47;
                Metadata x$46;
                String x$43 = "a";
                DoubleType$ x$44 = DoubleType$.MODULE$;
                boolean x$45 = AttributeReference$.MODULE$.apply$default$3();
                ApproximatePercentile wrongPercentage = new ApproximatePercentile((Expression)new AttributeReference("a", (DataType)x$44, x$45, x$46 = AttributeReference$.MODULE$.apply$default$4(), x$47 = AttributeReference$.MODULE$.apply$default$5("a", (DataType)x$44, x$45, x$46), x$48 = AttributeReference$.MODULE$.apply$default$6("a", (DataType)x$44, x$45, x$46)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)0.5)), (Expression)Literal$.MODULE$.apply(acc));
                TypeCheckResult typeCheckResult = wrongPercentage.checkInputDataTypes();
                boolean bl = typeCheckResult instanceof TypeCheckResult.TypeCheckFailure && (msg = (typeCheckFailure = (TypeCheckResult.TypeCheckFailure)typeCheckResult).message()).contains("argument 3 requires integral type");
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(bl, "wrongPercentage.checkInputDataTypes() match {\n  case (message: String): org.apache.spark.sql.catalyst.analysis.TypeCheckResult.TypeCheckFailure((msg @ _)) if msg.contains(\"argument 3 requires integral type\") => true\n  case _ => false\n}", Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ApproximatePercentileSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 350));
            });
        }, new Position("ApproximatePercentileSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 343));
        this.test("class ApproximatePercentile, null handling", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Cast childExpression = new Cast((Expression)new BoundReference(0, (DataType)IntegerType$.MODULE$, true), (DataType)DoubleType$.MODULE$, Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4());
            ApproximatePercentile agg = new ApproximatePercentile((Expression)childExpression, (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)0.5)));
            GenericInternalRow buffer = new GenericInternalRow(new Object[1]);
            agg.initialize((InternalRow)buffer);
            Object $org_scalatest_assert_macro_left = agg.eval((InternalRow)buffer);
            Object $org_scalatest_assert_macro_right = null;
            Object object = $org_scalatest_assert_macro_left;
            Object var6_5 = null;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left, "==", null, !(object != null ? !object.equals(var6_5) : var6_5 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ApproximatePercentileSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 363));
            agg.update((InternalRow)buffer, InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{null})));
            Object $org_scalatest_assert_macro_left2 = agg.eval((InternalRow)buffer);
            Object $org_scalatest_assert_macro_right2 = null;
            Object object2 = $org_scalatest_assert_macro_left2;
            Object var10_9 = null;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left2, "==", null, !(object2 != null ? !object2.equals(var10_9) : var10_9 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ApproximatePercentileSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 366));
            agg.update((InternalRow)buffer, InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0)})));
            Object $org_scalatest_assert_macro_left3 = agg.eval((InternalRow)buffer);
            Object $org_scalatest_assert_macro_right3 = null;
            Object object3 = $org_scalatest_assert_macro_left3;
            Object var14_13 = null;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left3, "!=", null, object3 == null ? var14_13 != null : !object3.equals(var14_13), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ApproximatePercentileSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 370));
        }, new Position("ApproximatePercentileSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 357));
    }
}

